/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AddressDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.valueset.AdministrativeGenderCodesEnum;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.OrganizationTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Organization", profile="http://hl7.org/fhir/profiles/Organization", id="organization")
public class Organization
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="name", path="Organization.name", description="A portion of the organization's name", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="phonetic", path="", description="A portion of the organization's name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="type", path="Organization.type", description="A code for the type of organization", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="identifier", path="Organization.identifier", description="Any identifier for the organization (not the accreditation issuer's identifier)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="partof", path="Organization.partOf", description="Search all organizations that are part of the given organization", type="reference")
    public static final String SP_PARTOF = "partof";
    public static final ReferenceClientParam PARTOF = new ReferenceClientParam("partof");
    public static final Include INCLUDE_PARTOF = new Include("Organization.partOf");
    @SearchParamDefinition(name="active", path="Organization.active", description="Whether the organization's record is active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Identifies this organization  across multiple systems", formalDefinition="Identifier for the organization that is used to identify the organization across multiple disparate systems")
    private List<IdentifierDt> myIdentifier;
    @Child(name="name", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Name used for the organization", formalDefinition="A name associated with the organization")
    private StringDt myName;
    @Child(name="type", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Kind of organization", formalDefinition="The kind of organization that this is")
    private BoundCodeableConceptDt<OrganizationTypeEnum> myType;
    @Child(name="telecom", type={ContactDt.class}, order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A contact detail for the organization", formalDefinition="A contact detail for the organization")
    private List<ContactDt> myTelecom;
    @Child(name="address", type={AddressDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="An address for the organization", formalDefinition="An address for the organization")
    private List<AddressDt> myAddress;
    @Child(name="partOf", order=5, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="The organization of which this organization forms a part", formalDefinition="The organization of which this organization forms a part")
    private ResourceReferenceDt myPartOf;
    @Child(name="contact", order=6, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Contact for the organization for a certain purpose", formalDefinition="")
    private List<Contact> myContact;
    @Child(name="location", order=7, min=0, max=-1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="Location(s) the organization uses to provide services", formalDefinition="Location(s) the organization uses to provide services")
    private List<ResourceReferenceDt> myLocation;
    @Child(name="active", type={BooleanDt.class}, order=8, min=0, max=1, summary=false, modifier=true)
    @Description(shortDefinition="Whether the organization's record is still in active use", formalDefinition="Whether the organization's record is still in active use")
    private BooleanDt myActive;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myName, this.myType, this.myTelecom, this.myAddress, this.myPartOf, this.myContact, this.myLocation, this.myActive});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myName, this.myType, this.myTelecom, this.myAddress, this.myPartOf, this.myContact, this.myLocation, this.myActive});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Organization setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Organization addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Organization addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public Organization setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Organization setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeableConceptDt<OrganizationTypeEnum> getType() {
        if (this.myType == null) {
            this.myType = new BoundCodeableConceptDt<OrganizationTypeEnum>(OrganizationTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public BoundCodeableConceptDt<OrganizationTypeEnum> getTypeElement() {
        if (this.myType == null) {
            this.myType = new BoundCodeableConceptDt<OrganizationTypeEnum>(OrganizationTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public Organization setType(BoundCodeableConceptDt<OrganizationTypeEnum> theValue) {
        this.myType = theValue;
        return this;
    }

    public Organization setType(OrganizationTypeEnum theValue) {
        this.getType().setValueAsEnum(theValue);
        return this;
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public Organization setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Organization addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public Organization addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public List<AddressDt> getAddress() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public List<AddressDt> getAddressElement() {
        if (this.myAddress == null) {
            this.myAddress = new ArrayList<AddressDt>();
        }
        return this.myAddress;
    }

    public Organization setAddress(List<AddressDt> theValue) {
        this.myAddress = theValue;
        return this;
    }

    public AddressDt addAddress() {
        AddressDt newType = new AddressDt();
        this.getAddress().add(newType);
        return newType;
    }

    public AddressDt getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            return this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public ResourceReferenceDt getPartOf() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public ResourceReferenceDt getPartOfElement() {
        if (this.myPartOf == null) {
            this.myPartOf = new ResourceReferenceDt();
        }
        return this.myPartOf;
    }

    public Organization setPartOf(ResourceReferenceDt theValue) {
        this.myPartOf = theValue;
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public List<Contact> getContactElement() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public Organization setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<ResourceReferenceDt> getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<ResourceReferenceDt>();
        }
        return this.myLocation;
    }

    public List<ResourceReferenceDt> getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new ArrayList<ResourceReferenceDt>();
        }
        return this.myLocation;
    }

    public Organization setLocation(List<ResourceReferenceDt> theValue) {
        this.myLocation = theValue;
        return this;
    }

    public ResourceReferenceDt addLocation() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getLocation().add(newType);
        return newType;
    }

    public BooleanDt getActive() {
        if (this.myActive == null) {
            this.myActive = new BooleanDt();
        }
        return this.myActive;
    }

    public BooleanDt getActiveElement() {
        if (this.myActive == null) {
            this.myActive = new BooleanDt();
        }
        return this.myActive;
    }

    public Organization setActive(BooleanDt theValue) {
        this.myActive = theValue;
        return this;
    }

    public Organization setActive(boolean theBoolean) {
        this.myActive = new BooleanDt(theBoolean);
        return this;
    }

    public String getResourceName() {
        return "Organization";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="purpose", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The type of contact", formalDefinition="Indicates a purpose for which the contact can be reached")
        private CodeableConceptDt myPurpose;
        @Child(name="name", type={HumanNameDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="A name associated with the contact", formalDefinition="A name associated with the contact")
        private HumanNameDt myName;
        @Child(name="telecom", type={ContactDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Contact details (telephone, email, etc)  for a contact", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.")
        private List<ContactDt> myTelecom;
        @Child(name="address", type={AddressDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Visiting or postal addresses for the contact", formalDefinition="Visiting or postal addresses for the contact")
        private AddressDt myAddress;
        @Child(name="gender", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Gender for administrative purposes", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
        private BoundCodeableConceptDt<AdministrativeGenderCodesEnum> myGender;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPurpose, this.myName, this.myTelecom, this.myAddress, this.myGender});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPurpose, this.myName, this.myTelecom, this.myAddress, this.myGender});
        }

        public CodeableConceptDt getPurpose() {
            if (this.myPurpose == null) {
                this.myPurpose = new CodeableConceptDt();
            }
            return this.myPurpose;
        }

        public CodeableConceptDt getPurposeElement() {
            if (this.myPurpose == null) {
                this.myPurpose = new CodeableConceptDt();
            }
            return this.myPurpose;
        }

        public Contact setPurpose(CodeableConceptDt theValue) {
            this.myPurpose = theValue;
            return this;
        }

        public HumanNameDt getName() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public HumanNameDt getNameElement() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public Contact setName(HumanNameDt theValue) {
            this.myName = theValue;
            return this;
        }

        public List<ContactDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactDt>();
            }
            return this.myTelecom;
        }

        public List<ContactDt> getTelecomElement() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactDt addTelecom() {
            ContactDt newType = new ContactDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public ContactDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }

        public Contact addTelecom(ContactUseEnum theContactUse, String theValue) {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactDt>();
            }
            this.myTelecom.add(new ContactDt(theContactUse, theValue));
            return this;
        }

        public Contact addTelecom(String theValue) {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactDt>();
            }
            this.myTelecom.add(new ContactDt(theValue));
            return this;
        }

        public AddressDt getAddress() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public AddressDt getAddressElement() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public Contact setAddress(AddressDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGender() {
            if (this.myGender == null) {
                this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
            }
            return this.myGender;
        }

        public BoundCodeableConceptDt<AdministrativeGenderCodesEnum> getGenderElement() {
            if (this.myGender == null) {
                this.myGender = new BoundCodeableConceptDt<AdministrativeGenderCodesEnum>(AdministrativeGenderCodesEnum.VALUESET_BINDER);
            }
            return this.myGender;
        }

        public Contact setGender(BoundCodeableConceptDt<AdministrativeGenderCodesEnum> theValue) {
            this.myGender = theValue;
            return this;
        }

        public Contact setGender(AdministrativeGenderCodesEnum theValue) {
            this.getGender().setValueAsEnum(theValue);
            return this;
        }
    }
}

