/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ExtensionContextEnum {
    RESOURCE("resource", "http://hl7.org/fhir/extension-context"),
    DATATYPE("datatype", "http://hl7.org/fhir/extension-context"),
    MAPPING("mapping", "http://hl7.org/fhir/extension-context"),
    EXTENSION("extension", "http://hl7.org/fhir/extension-context");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/extension-context";
    public static final String VALUESET_NAME = "ExtensionContext";
    private static Map<String, ExtensionContextEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ExtensionContextEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ExtensionContextEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ExtensionContextEnum forCode(String theCode) {
        ExtensionContextEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ExtensionContextEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ExtensionContextEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ExtensionContextEnum>>();
        for (ExtensionContextEnum next : ExtensionContextEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ExtensionContextEnum>(){

            public String toCodeString(ExtensionContextEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ExtensionContextEnum theEnum) {
                return theEnum.getSystem();
            }

            public ExtensionContextEnum fromCodeString(String theCodeString) {
                return (ExtensionContextEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ExtensionContextEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ExtensionContextEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

