/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SlicingRulesEnum {
    CLOSED("closed", "http://hl7.org/fhir/resource-slicing-rules"),
    OPEN("open", "http://hl7.org/fhir/resource-slicing-rules"),
    OPENATEND("openAtEnd", "http://hl7.org/fhir/resource-slicing-rules");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/resource-slicing-rules";
    public static final String VALUESET_NAME = "SlicingRules";
    private static Map<String, SlicingRulesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SlicingRulesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SlicingRulesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static SlicingRulesEnum forCode(String theCode) {
        SlicingRulesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SlicingRulesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SlicingRulesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SlicingRulesEnum>>();
        for (SlicingRulesEnum next : SlicingRulesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SlicingRulesEnum>(){

            public String toCodeString(SlicingRulesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SlicingRulesEnum theEnum) {
                return theEnum.getSystem();
            }

            public SlicingRulesEnum fromCodeString(String theCodeString) {
                return (SlicingRulesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SlicingRulesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SlicingRulesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

