/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.audit;

import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectTypeEnum;
import ca.uhn.fhir.rest.server.audit.IResourceAuditor;
import java.util.HashMap;
import java.util.Map;

public class EncounterAuditor
implements IResourceAuditor<Encounter> {
    private Encounter myEncounter;

    public Encounter getResource() {
        return this.myEncounter;
    }

    public void setResource(Encounter theEncounter) {
        this.myEncounter = theEncounter;
    }

    public boolean isAuditable() {
        return this.myEncounter != null;
    }

    public String getName() {
        if (this.myEncounter != null) {
            String id = (String)this.myEncounter.getIdentifierFirstRep().getValue().getValue();
            String system = this.myEncounter.getIdentifierFirstRep().getSystem().getValueAsString();
            String service = (String)this.myEncounter.getServiceProvider().getDisplay().getValue();
            return "Encounter: " + id + "/" + system + ": " + service;
        }
        return null;
    }

    public IdentifierDt getIdentifier() {
        if (this.myEncounter != null) {
            return this.myEncounter.getIdentifierFirstRep();
        }
        return null;
    }

    public SecurityEventObjectTypeEnum getType() {
        return SecurityEventObjectTypeEnum.OTHER;
    }

    public String getDescription() {
        if (this.myEncounter != null) {
            String type = (String)this.myEncounter.getTypeFirstRep().getText().getValue();
            String status = this.myEncounter.getStatus().getValueAsString();
            String startDate = this.myEncounter.getPeriod().getStart().getValueAsString();
            String endDate = this.myEncounter.getPeriod().getEnd().getValueAsString();
            return "Encounter: " + type + ": " + status + ", " + startDate + " - " + endDate;
        }
        return null;
    }

    public Map<String, String> getDetail() {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("startDate", this.myEncounter.getPeriod().getStart().getValueAsString());
        details.put("endDate", this.myEncounter.getPeriod().getEnd().getValueAsString());
        details.put("service", (String)this.myEncounter.getServiceProvider().getDisplay().getValue());
        details.put("type", (String)this.myEncounter.getTypeFirstRep().getText().getValue());
        details.put("status", this.myEncounter.getStatus().getValueAsString());
        details.put("subject", this.myEncounter.getSubject().getReference().getValue());
        return details;
    }

    public BaseCodingDt getSensitivity() {
        return null;
    }
}

