/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceDefinition;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeResourceReferenceDefinition;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.ContainedDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.Profile;
import ca.uhn.fhir.model.dstu.valueset.DataTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.SlicingRulesEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.server.Dstu1BundleFactory;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.provider.ServerConformanceProvider;
import ca.uhn.fhir.rest.server.provider.ServerProfileProvider;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirDstu1
implements IFhirVersion {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirDstu1.class);
    private String myId;

    public ServerConformanceProvider createServerConformanceProvider(RestfulServer theServer) {
        return new ServerConformanceProvider(theServer);
    }

    public IResourceProvider createServerProfilesProvider(RestfulServer theRestfulServer) {
        return new ServerProfileProvider(theRestfulServer);
    }

    private void fillBasics(Profile.StructureElement theElement, BaseRuntimeElementDefinition<?> def, LinkedList<String> path, BaseRuntimeDeclaredChildDefinition theChild) {
        if (path.isEmpty()) {
            path.add(def.getName());
            theElement.setName(def.getName());
        } else {
            path.add(WordUtils.uncapitalize((String)theChild.getElementName()));
            theElement.setName(theChild.getElementName());
        }
        theElement.setPath(StringUtils.join(path, (char)'.'));
    }

    private void fillExtensions(Profile.Structure theStruct, LinkedList<String> path, List<RuntimeChildDeclaredExtensionDefinition> extList, String elementName, boolean theIsModifier) {
        if (extList.size() > 0) {
            Profile.StructureElement extSlice = theStruct.addElement();
            extSlice.setName(elementName);
            extSlice.setPath(StringUtils.join(path, (char)'.') + '.' + elementName);
            extSlice.getSlicing().getDiscriminator().setValue("url");
            extSlice.getSlicing().setOrdered(false);
            extSlice.getSlicing().setRules(SlicingRulesEnum.OPEN);
            extSlice.getDefinition().addType().setCode(DataTypeEnum.EXTENSION);
            for (RuntimeChildDeclaredExtensionDefinition nextExt : extList) {
                Profile.StructureElement nextProfileExt = theStruct.addElement();
                nextProfileExt.getDefinition().setIsModifier(theIsModifier);
                nextProfileExt.setName(extSlice.getName());
                nextProfileExt.setPath(extSlice.getPath());
                this.fillMinAndMaxAndDefinitions((BaseRuntimeDeclaredChildDefinition)nextExt, nextProfileExt);
                Profile.StructureElementDefinitionType type = nextProfileExt.getDefinition().addType();
                type.setCode(DataTypeEnum.EXTENSION);
                if (nextExt.isDefinedLocally()) {
                    type.setProfile(nextExt.getExtensionUrl().substring(nextExt.getExtensionUrl().indexOf(35)));
                    continue;
                }
                type.setProfile(nextExt.getExtensionUrl());
            }
        } else {
            Profile.StructureElement extSlice = theStruct.addElement();
            extSlice.setName(elementName);
            extSlice.setPath(StringUtils.join(path, (char)'.') + '.' + elementName);
            extSlice.getDefinition().setIsModifier(theIsModifier);
            extSlice.getDefinition().addType().setCode(DataTypeEnum.EXTENSION);
            extSlice.getDefinition().setMin(0);
            extSlice.getDefinition().setMax("*");
        }
    }

    private void fillMinAndMaxAndDefinitions(BaseRuntimeDeclaredChildDefinition child, Profile.StructureElement elem) {
        elem.getDefinition().setMin(child.getMin());
        if (child.getMax() == -1) {
            elem.getDefinition().setMax("*");
        } else {
            elem.getDefinition().setMax(Integer.toString(child.getMax()));
        }
        if (StringUtils.isNotBlank((CharSequence)child.getShortDefinition())) {
            elem.getDefinition().getShort().setValue((Object)child.getShortDefinition());
        }
        if (StringUtils.isNotBlank((CharSequence)child.getFormalDefinition())) {
            elem.getDefinition().getFormal().setValue((Object)child.getFormalDefinition());
        }
    }

    private void fillName(Profile.StructureElement elem, BaseRuntimeElementDefinition<?> nextDef, String theServerBase) {
        if (nextDef instanceof RuntimeResourceReferenceDefinition) {
            RuntimeResourceReferenceDefinition rr = (RuntimeResourceReferenceDefinition)nextDef;
            for (Class next : rr.getResourceTypes()) {
                Profile.StructureElementDefinitionType type = elem.getDefinition().addType();
                type.getCode().setValue((Object)"ResourceReference");
                if (next == IResource.class) continue;
                RuntimeResourceDefinition resDef = rr.getDefinitionForResourceType(next);
                type.getProfile().setValueAsString(resDef.getResourceProfile(theServerBase));
            }
            return;
        }
        Profile.StructureElementDefinitionType type = elem.getDefinition().addType();
        String name = nextDef.getName();
        DataTypeEnum fromCodeString = (DataTypeEnum)DataTypeEnum.VALUESET_BINDER.fromCodeString(name);
        if (fromCodeString == null) {
            throw new ConfigurationException("Unknown type: " + name);
        }
        type.setCode(fromCodeString);
    }

    private void fillProfile(Profile.Structure theStruct, Profile.StructureElement theElement, BaseRuntimeElementDefinition<?> def, LinkedList<String> path, BaseRuntimeDeclaredChildDefinition theChild, String theServerBase) {
        this.fillBasics(theElement, def, path, theChild);
        String expectedPath = StringUtils.join(path, (char)'.');
        ourLog.debug("Filling profile for: {} - Path: {}", (Object)expectedPath);
        String name = def.getName();
        if (!expectedPath.equals(name)) {
            path.pollLast();
            theElement.getDefinition().getNameReference().setValue((Object)def.getName());
            return;
        }
        this.fillExtensions(theStruct, path, def.getExtensionsNonModifier(), "extension", false);
        this.fillExtensions(theStruct, path, def.getExtensionsModifier(), "modifierExtension", true);
        if (def.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.RESOURCE) {
            Profile.StructureElement narrative = theStruct.addElement();
            narrative.setName("text");
            narrative.setPath(StringUtils.join(path, (char)'.') + ".text");
            narrative.getDefinition().addType().setCode(DataTypeEnum.NARRATIVE);
            narrative.getDefinition().setIsModifier(false);
            narrative.getDefinition().setMin(0);
            narrative.getDefinition().setMax("1");
            Profile.StructureElement contained = theStruct.addElement();
            contained.setName("contained");
            contained.setPath(StringUtils.join(path, (char)'.') + ".contained");
            contained.getDefinition().addType().getCode().setValue((Object)"Resource");
            contained.getDefinition().setIsModifier(false);
            contained.getDefinition().setMin(0);
            contained.getDefinition().setMax("1");
        }
        if (def instanceof BaseRuntimeElementCompositeDefinition) {
            BaseRuntimeElementCompositeDefinition cdef = (BaseRuntimeElementCompositeDefinition)def;
            for (BaseRuntimeChildDefinition nextChild : cdef.getChildren()) {
                if (nextChild instanceof RuntimeChildUndeclaredExtensionDefinition) continue;
                BaseRuntimeDeclaredChildDefinition child = (BaseRuntimeDeclaredChildDefinition)nextChild;
                Profile.StructureElement elem = theStruct.addElement();
                this.fillMinAndMaxAndDefinitions(child, elem);
                if (child instanceof RuntimeChildResourceBlockDefinition) {
                    RuntimeResourceBlockDefinition nextDef = (RuntimeResourceBlockDefinition)child.getSingleChildOrThrow();
                    this.fillProfile(theStruct, elem, (BaseRuntimeElementDefinition<?>)nextDef, path, child, theServerBase);
                    continue;
                }
                if (child instanceof RuntimeChildContainedResources) continue;
                if (child instanceof RuntimeChildDeclaredExtensionDefinition) {
                    throw new IllegalStateException("Unexpected child type: " + child.getClass().getCanonicalName());
                }
                if (child instanceof RuntimeChildCompositeDatatypeDefinition || child instanceof RuntimeChildPrimitiveDatatypeDefinition || child instanceof RuntimeChildChoiceDefinition || child instanceof RuntimeChildResourceDefinition) {
                    Iterator childNamesIter = child.getValidChildNames().iterator();
                    String nextName = (String)childNamesIter.next();
                    BaseRuntimeElementDefinition nextDef = child.getChildByName(nextName);
                    this.fillBasics(elem, nextDef, path, child);
                    this.fillName(elem, nextDef, theServerBase);
                    while (childNamesIter.hasNext()) {
                        nextDef = child.getChildByName((String)childNamesIter.next());
                        this.fillName(elem, nextDef, theServerBase);
                    }
                    path.pollLast();
                    continue;
                }
                throw new IllegalStateException("Unexpected child type: " + child.getClass().getCanonicalName());
            }
        } else {
            throw new IllegalStateException("Unexpected child type: " + def.getClass().getCanonicalName());
        }
        path.pollLast();
    }

    public IResource generateProfile(RuntimeResourceDefinition theRuntimeResourceDefinition, String theServerBase) {
        Profile retVal = new Profile();
        RuntimeResourceDefinition def = theRuntimeResourceDefinition;
        this.myId = def.getId();
        if (StringUtils.isBlank((CharSequence)this.myId)) {
            this.myId = theRuntimeResourceDefinition.getName().toLowerCase();
        }
        retVal.setId(new IdDt(this.myId));
        this.scanForExtensions(retVal, (BaseRuntimeElementDefinition<?>)def, (Map<RuntimeChildDeclaredExtensionDefinition, String>)new HashMap<RuntimeChildDeclaredExtensionDefinition, String>());
        Collections.sort(retVal.getExtensionDefn(), new Comparator<Profile.ExtensionDefn>(){

            @Override
            public int compare(Profile.ExtensionDefn theO1, Profile.ExtensionDefn theO2) {
                return theO1.getCode().compareTo(theO2.getCode());
            }
        });
        retVal.setName(def.getName());
        Profile.Structure struct = retVal.addStructure();
        LinkedList<String> path = new LinkedList<String>();
        Profile.StructureElement element = struct.addElement();
        element.getDefinition().setMin(1);
        element.getDefinition().setMax("1");
        this.fillProfile(struct, element, (BaseRuntimeElementDefinition<?>)def, path, null, theServerBase);
        retVal.getStructure().get(0).getElement().get(0).getDefinition().addType().getCode().setValue((Object)"Resource");
        return retVal;
    }

    public Class<? extends BaseContainedDt> getContainedType() {
        return ContainedDt.class;
    }

    public InputStream getFhirVersionPropertiesFile() {
        InputStream str = FhirDstu1.class.getResourceAsStream("/ca/uhn/fhir/model/dstu/fhirversion.properties");
        if (str == null) {
            str = FhirDstu1.class.getResourceAsStream("ca/uhn/fhir/model/dstu/fhirversion.properties");
        }
        if (str == null) {
            throw new ConfigurationException("Can not find model property file on classpath: /ca/uhn/fhir/model/dstu/model.properties");
        }
        return str;
    }

    public IPrimitiveType<Date> getLastUpdated(IBaseResource theResource) {
        return (IPrimitiveType)ResourceMetadataKeyEnum.UPDATED.get((IResource)theResource);
    }

    public String getPathToSchemaDefinitions() {
        return "/ca/uhn/fhir/model/dstu/schema";
    }

    public Class<? extends BaseResourceReferenceDt> getResourceReferenceType() {
        return ResourceReferenceDt.class;
    }

    public FhirVersionEnum getVersion() {
        return FhirVersionEnum.DSTU1;
    }

    public IVersionSpecificBundleFactory newBundleFactory(FhirContext theContext) {
        return new Dstu1BundleFactory(theContext);
    }

    public BaseCodingDt newCodingDt() {
        return new CodingDt();
    }

    private Map<RuntimeChildDeclaredExtensionDefinition, String> scanForExtensions(Profile theProfile, BaseRuntimeElementDefinition<?> def, Map<RuntimeChildDeclaredExtensionDefinition, String> theExtensionDefToCode) {
        BaseRuntimeElementCompositeDefinition cdef = (BaseRuntimeElementCompositeDefinition)def;
        for (RuntimeChildDeclaredExtensionDefinition nextChild : cdef.getExtensions()) {
            RuntimeResourceBlockDefinition pdef;
            if (theExtensionDefToCode.containsKey(nextChild) || !nextChild.isDefinedLocally()) continue;
            Profile.ExtensionDefn defn = theProfile.addExtensionDefn();
            String code = null;
            if (!nextChild.getExtensionUrl().contains("#") || nextChild.getExtensionUrl().endsWith("#")) {
                throw new ConfigurationException("Locally defined extension has no '#[code]' part in extension URL: " + nextChild.getExtensionUrl());
            }
            code = nextChild.getExtensionUrl().substring(nextChild.getExtensionUrl().indexOf(35) + 1);
            defn.setCode(code);
            if (theExtensionDefToCode.values().contains(code)) {
                throw new IllegalStateException("Duplicate extension code: " + code);
            }
            theExtensionDefToCode.put(nextChild, code);
            if (nextChild.getChildType() != null && IPrimitiveDatatype.class.isAssignableFrom(nextChild.getChildType())) {
                pdef = (RuntimePrimitiveDatatypeDefinition)nextChild.getSingleChildOrThrow();
                defn.getDefinition().addType().setCode((DataTypeEnum)DataTypeEnum.VALUESET_BINDER.fromCodeString(pdef.getName()));
                continue;
            }
            if (nextChild.getChildType() != null && ICompositeDatatype.class.isAssignableFrom(nextChild.getChildType())) {
                pdef = (RuntimeCompositeDatatypeDefinition)nextChild.getSingleChildOrThrow();
                defn.getDefinition().addType().setCode((DataTypeEnum)DataTypeEnum.VALUESET_BINDER.fromCodeString(pdef.getName()));
                continue;
            }
            pdef = (RuntimeResourceBlockDefinition)nextChild.getSingleChildOrThrow();
            this.scanForExtensions(theProfile, (BaseRuntimeElementDefinition<?>)pdef, theExtensionDefToCode);
            for (RuntimeChildDeclaredExtensionDefinition nextChildExt : pdef.getExtensions()) {
                Profile.StructureElementDefinitionType type = defn.getDefinition().addType();
                type.setCode(DataTypeEnum.EXTENSION);
                type.setProfile("#" + theExtensionDefToCode.get(nextChildExt));
            }
        }
        return theExtensionDefToCode;
    }
}

