/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.base.composite.BaseNarrativeDt;
import ca.uhn.fhir.model.dstu.valueset.NarrativeStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="Narrative")
public class NarrativeDt
extends BaseNarrativeDt<NarrativeStatusEnum> {
    @Child(name="status", type={CodeDt.class}, order=0, min=1, max=1)
    private BoundCodeDt<NarrativeStatusEnum> myStatus;
    @Child(name="div", type={XhtmlDt.class}, order=1, min=1, max=1)
    private XhtmlDt myDiv;

    public NarrativeDt() {
    }

    public NarrativeDt(XhtmlDt theDiv, NarrativeStatusEnum theStatus) {
        this.setDiv(theDiv);
        this.setStatus(theStatus);
    }

    public boolean isEmpty() {
        return ElementUtil.isEmpty((IElement[])new IElement[]{this.myStatus, this.myDiv});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStatus, this.myDiv});
    }

    public BoundCodeDt<NarrativeStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(NarrativeStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public void setStatus(BoundCodeDt<NarrativeStatusEnum> theValue) {
        this.myStatus = theValue;
    }

    public void setStatus(NarrativeStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
    }

    public XhtmlDt getDiv() {
        if (this.myDiv == null) {
            this.myDiv = new XhtmlDt();
        }
        return this.myDiv;
    }

    public void setDiv(XhtmlDt theValue) {
        this.myDiv = theValue;
    }

    public void setDiv(String theTextDiv) {
        this.myDiv = new XhtmlDt(theTextDiv);
    }
}

