/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Observation;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DeviceObservationReport", profile="http://hl7.org/fhir/profiles/DeviceObservationReport", id="deviceobservationreport")
public class DeviceObservationReport
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="source", path="DeviceObservationReport.source", description="", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("DeviceObservationReport.source");
    @SearchParamDefinition(name="code", path="DeviceObservationReport.virtualDevice.code", description="The compatment code", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="channel", path="DeviceObservationReport.virtualDevice.channel.code", description="The channel code", type="token")
    public static final String SP_CHANNEL = "channel";
    public static final TokenClientParam CHANNEL = new TokenClientParam("channel");
    @SearchParamDefinition(name="observation", path="DeviceObservationReport.virtualDevice.channel.metric.observation", description="", type="reference")
    public static final String SP_OBSERVATION = "observation";
    public static final ReferenceClientParam OBSERVATION = new ReferenceClientParam("observation");
    public static final Include INCLUDE_VIRTUALDEVICE_CHANNEL_METRIC_OBSERVATION = new Include("DeviceObservationReport.virtualDevice.channel.metric.observation");
    @SearchParamDefinition(name="subject", path="DeviceObservationReport.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceObservationReport.subject");
    @Child(name="instant", type={InstantDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="When the data values are reported", formalDefinition="The point in time that the values are reported")
    private InstantDt myInstant;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="As assigned by the source device", formalDefinition="An identifier assigned to this observation bu the source device that made the observation")
    private IdentifierDt myIdentifier;
    @Child(name="source", order=2, min=1, max=1, summary=false, modifier=false, type={Device.class})
    @Description(shortDefinition="Identifies/describes where the data came from", formalDefinition="Identification information for the device that is the source of the data")
    private ResourceReferenceDt mySource;
    @Child(name="subject", order=3, min=0, max=1, summary=false, modifier=false, type={Patient.class, Device.class, Location.class})
    @Description(shortDefinition="Subject of the measurement", formalDefinition="The subject of the measurement")
    private ResourceReferenceDt mySubject;
    @Child(name="virtualDevice", order=4, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A medical-related subsystem of a medical device", formalDefinition="A medical-related subsystem of a medical device")
    private List<VirtualDevice> myVirtualDevice;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myInstant, this.myIdentifier, this.mySource, this.mySubject, this.myVirtualDevice});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myInstant, this.myIdentifier, this.mySource, this.mySubject, this.myVirtualDevice});
    }

    public InstantDt getInstant() {
        if (this.myInstant == null) {
            this.myInstant = new InstantDt();
        }
        return this.myInstant;
    }

    public InstantDt getInstantElement() {
        if (this.myInstant == null) {
            this.myInstant = new InstantDt();
        }
        return this.myInstant;
    }

    public DeviceObservationReport setInstant(InstantDt theValue) {
        this.myInstant = theValue;
        return this;
    }

    public DeviceObservationReport setInstantWithMillisPrecision(Date theDate) {
        this.myInstant = new InstantDt(theDate);
        return this;
    }

    public DeviceObservationReport setInstant(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myInstant = new InstantDt(theDate, thePrecision);
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public DeviceObservationReport setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public DeviceObservationReport setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public DeviceObservationReport setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public ResourceReferenceDt getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public DeviceObservationReport setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DeviceObservationReport setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public List<VirtualDevice> getVirtualDevice() {
        if (this.myVirtualDevice == null) {
            this.myVirtualDevice = new ArrayList<VirtualDevice>();
        }
        return this.myVirtualDevice;
    }

    public List<VirtualDevice> getVirtualDeviceElement() {
        if (this.myVirtualDevice == null) {
            this.myVirtualDevice = new ArrayList<VirtualDevice>();
        }
        return this.myVirtualDevice;
    }

    public DeviceObservationReport setVirtualDevice(List<VirtualDevice> theValue) {
        this.myVirtualDevice = theValue;
        return this;
    }

    public VirtualDevice addVirtualDevice() {
        VirtualDevice newType = new VirtualDevice();
        this.getVirtualDevice().add(newType);
        return newType;
    }

    public VirtualDevice getVirtualDeviceFirstRep() {
        if (this.getVirtualDevice().isEmpty()) {
            return this.addVirtualDevice();
        }
        return this.getVirtualDevice().get(0);
    }

    public String getResourceName() {
        return "DeviceObservationReport";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class VirtualDeviceChannelMetric
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="observation", order=0, min=1, max=1, summary=false, modifier=false, type={Observation.class})
        @Description(shortDefinition="The data for the metric", formalDefinition="The data for the metric")
        private ResourceReferenceDt myObservation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myObservation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myObservation});
        }

        public ResourceReferenceDt getObservation() {
            if (this.myObservation == null) {
                this.myObservation = new ResourceReferenceDt();
            }
            return this.myObservation;
        }

        public ResourceReferenceDt getObservationElement() {
            if (this.myObservation == null) {
                this.myObservation = new ResourceReferenceDt();
            }
            return this.myObservation;
        }

        public VirtualDeviceChannelMetric setObservation(ResourceReferenceDt theValue) {
            this.myObservation = theValue;
            return this;
        }
    }

    @Block
    public static class VirtualDeviceChannel
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Describes the channel", formalDefinition="Describes the channel")
        private CodeableConceptDt myCode;
        @Child(name="metric", order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Piece of data reported by device", formalDefinition="A piece of measured or derived data that is reported by the machine")
        private List<VirtualDeviceChannelMetric> myMetric;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myMetric});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myMetric});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public VirtualDeviceChannel setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public List<VirtualDeviceChannelMetric> getMetric() {
            if (this.myMetric == null) {
                this.myMetric = new ArrayList<VirtualDeviceChannelMetric>();
            }
            return this.myMetric;
        }

        public List<VirtualDeviceChannelMetric> getMetricElement() {
            if (this.myMetric == null) {
                this.myMetric = new ArrayList<VirtualDeviceChannelMetric>();
            }
            return this.myMetric;
        }

        public VirtualDeviceChannel setMetric(List<VirtualDeviceChannelMetric> theValue) {
            this.myMetric = theValue;
            return this;
        }

        public VirtualDeviceChannelMetric addMetric() {
            VirtualDeviceChannelMetric newType = new VirtualDeviceChannelMetric();
            this.getMetric().add(newType);
            return newType;
        }

        public VirtualDeviceChannelMetric getMetricFirstRep() {
            if (this.getMetric().isEmpty()) {
                return this.addMetric();
            }
            return this.getMetric().get(0);
        }
    }

    @Block
    public static class VirtualDevice
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Describes the compartment", formalDefinition="Describes the compartment")
        private CodeableConceptDt myCode;
        @Child(name="channel", order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Groups related data items", formalDefinition="Groups together physiological measurement data and derived data")
        private List<VirtualDeviceChannel> myChannel;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myChannel});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myChannel});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public VirtualDevice setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public List<VirtualDeviceChannel> getChannel() {
            if (this.myChannel == null) {
                this.myChannel = new ArrayList<VirtualDeviceChannel>();
            }
            return this.myChannel;
        }

        public List<VirtualDeviceChannel> getChannelElement() {
            if (this.myChannel == null) {
                this.myChannel = new ArrayList<VirtualDeviceChannel>();
            }
            return this.myChannel;
        }

        public VirtualDevice setChannel(List<VirtualDeviceChannel> theValue) {
            this.myChannel = theValue;
            return this;
        }

        public VirtualDeviceChannel addChannel() {
            VirtualDeviceChannel newType = new VirtualDeviceChannel();
            this.getChannel().add(newType);
            return newType;
        }

        public VirtualDeviceChannel getChannelFirstRep() {
            if (this.getChannel().isEmpty()) {
                return this.addChannel();
            }
            return this.getChannel().get(0);
        }
    }
}

