/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Specimen;
import ca.uhn.fhir.model.dstu.valueset.DiagnosticOrderPriorityEnum;
import ca.uhn.fhir.model.dstu.valueset.DiagnosticOrderStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DiagnosticOrder", profile="http://hl7.org/fhir/profiles/DiagnosticOrder", id="diagnosticorder")
public class DiagnosticOrder
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="actor", path="DiagnosticOrder.event.actor | DiagnosticOrder.item.event.actor", description="", type="reference")
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_EVENT_ACTOR = new Include("DiagnosticOrder.event.actor");
    public static final Include INCLUDE_ITEM_EVENT_ACTOR = new Include("DiagnosticOrder.item.event.actor");
    @SearchParamDefinition(name="bodysite", path="DiagnosticOrder.item.bodySite", description="", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="code", path="DiagnosticOrder.item.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="event-date", path="DiagnosticOrder.event.dateTime", description="", type="date")
    public static final String SP_EVENT_DATE = "event-date";
    public static final DateClientParam EVENT_DATE = new DateClientParam("event-date");
    @SearchParamDefinition(name="encounter", path="DiagnosticOrder.encounter", description="", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("DiagnosticOrder.encounter");
    @SearchParamDefinition(name="identifier", path="DiagnosticOrder.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="item-date", path="DiagnosticOrder.item.event.dateTime", description="", type="date")
    public static final String SP_ITEM_DATE = "item-date";
    public static final DateClientParam ITEM_DATE = new DateClientParam("item-date");
    @SearchParamDefinition(name="item-past-status", path="DiagnosticOrder.item.event.status", description="", type="token")
    public static final String SP_ITEM_PAST_STATUS = "item-past-status";
    public static final TokenClientParam ITEM_PAST_STATUS = new TokenClientParam("item-past-status");
    @SearchParamDefinition(name="item-status", path="DiagnosticOrder.item.status", description="", type="token")
    public static final String SP_ITEM_STATUS = "item-status";
    public static final TokenClientParam ITEM_STATUS = new TokenClientParam("item-status");
    @SearchParamDefinition(name="orderer", path="DiagnosticOrder.orderer", description="", type="reference")
    public static final String SP_ORDERER = "orderer";
    public static final ReferenceClientParam ORDERER = new ReferenceClientParam("orderer");
    public static final Include INCLUDE_ORDERER = new Include("DiagnosticOrder.orderer");
    @SearchParamDefinition(name="event-status", path="DiagnosticOrder.event.status", description="", type="token")
    public static final String SP_EVENT_STATUS = "event-status";
    public static final TokenClientParam EVENT_STATUS = new TokenClientParam("event-status");
    @SearchParamDefinition(name="specimen", path="DiagnosticOrder.specimen | DiagnosticOrder.item.specimen", description="", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("DiagnosticOrder.specimen");
    public static final Include INCLUDE_ITEM_SPECIMEN = new Include("DiagnosticOrder.item.specimen");
    @SearchParamDefinition(name="status", path="DiagnosticOrder.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="DiagnosticOrder.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DiagnosticOrder.subject");
    @SearchParamDefinition(name="item-past-status-item-date", path="item-past-status & item-date", description="A combination of item-past-status and item-date", type="composite", compositeOf={"item-past-status", "item-date"})
    public static final String SP_ITEM_PAST_STATUS_ITEM_DATE = "item-past-status-item-date";
    public static final CompositeClientParam<TokenClientParam, DateClientParam> ITEM_PAST_STATUS_ITEM_DATE = new CompositeClientParam("item-past-status-item-date");
    @SearchParamDefinition(name="event-status-event-date", path="event-status & event-date", description="A combination of past-status and date", type="composite", compositeOf={"event-status", "event-date"})
    public static final String SP_EVENT_STATUS_EVENT_DATE = "event-status-event-date";
    public static final CompositeClientParam<TokenClientParam, DateClientParam> EVENT_STATUS_EVENT_DATE = new CompositeClientParam("event-status-event-date");
    @Child(name="subject", order=0, min=1, max=1, summary=false, modifier=false, type={Patient.class, Group.class, Location.class, Device.class})
    @Description(shortDefinition="Who and/or what test is about", formalDefinition="Who or what the investigation is to be performed on. This is usually a human patient, but diagnostic tests can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans)")
    private ResourceReferenceDt mySubject;
    @Child(name="orderer", order=1, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="Who ordered the test", formalDefinition="The practitioner that holds legal responsibility for ordering the investigation")
    private ResourceReferenceDt myOrderer;
    @Child(name="identifier", type={IdentifierDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Identifiers assigned to this order", formalDefinition="Identifiers assigned to this order by the order or by the receiver")
    private List<IdentifierDt> myIdentifier;
    @Child(name="encounter", order=3, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="The encounter that this diagnostic order is associated with", formalDefinition="An encounter that provides additional informaton about the healthcare context in which this request is made")
    private ResourceReferenceDt myEncounter;
    @Child(name="clinicalNotes", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Explanation/Justification for test", formalDefinition="An explanation or justification for why this diagnostic investigation is being requested")
    private StringDt myClinicalNotes;
    @Child(name="specimen", order=5, min=0, max=-1, summary=false, modifier=false, type={Specimen.class})
    @Description(shortDefinition="If the whole order relates to specific specimens", formalDefinition="One or more specimens that the diagnostic investigation is about")
    private List<ResourceReferenceDt> mySpecimen;
    @Child(name="status", type={CodeDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="requested | received | accepted | in progress | review | completed | suspended | rejected | failed", formalDefinition="The status of the order")
    private BoundCodeDt<DiagnosticOrderStatusEnum> myStatus;
    @Child(name="priority", type={CodeDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="routine | urgent | stat | asap", formalDefinition="The clinical priority associated with this order")
    private BoundCodeDt<DiagnosticOrderPriorityEnum> myPriority;
    @Child(name="event", order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A list of events of interest in the lifecycle", formalDefinition="A summary of the events of interest that have occurred as the request is processed. E.g. when the order was made, various processing steps (specimens received), when it was completed")
    private List<Event> myEvent;
    @Child(name="item", order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="The items the orderer requested", formalDefinition="The specific diagnostic investigations that are requested as part of this request. Sometimes, there can only be one item per request, but in most contexts, more than one investigation can be requested")
    private List<Item> myItem;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.myOrderer, this.myIdentifier, this.myEncounter, this.myClinicalNotes, this.mySpecimen, this.myStatus, this.myPriority, this.myEvent, this.myItem});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myOrderer, this.myIdentifier, this.myEncounter, this.myClinicalNotes, this.mySpecimen, this.myStatus, this.myPriority, this.myEvent, this.myItem});
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public DiagnosticOrder setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getOrderer() {
        if (this.myOrderer == null) {
            this.myOrderer = new ResourceReferenceDt();
        }
        return this.myOrderer;
    }

    public ResourceReferenceDt getOrdererElement() {
        if (this.myOrderer == null) {
            this.myOrderer = new ResourceReferenceDt();
        }
        return this.myOrderer;
    }

    public DiagnosticOrder setOrderer(ResourceReferenceDt theValue) {
        this.myOrderer = theValue;
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DiagnosticOrder setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DiagnosticOrder addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public DiagnosticOrder addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ResourceReferenceDt getEncounterElement() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public DiagnosticOrder setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public StringDt getClinicalNotes() {
        if (this.myClinicalNotes == null) {
            this.myClinicalNotes = new StringDt();
        }
        return this.myClinicalNotes;
    }

    public StringDt getClinicalNotesElement() {
        if (this.myClinicalNotes == null) {
            this.myClinicalNotes = new StringDt();
        }
        return this.myClinicalNotes;
    }

    public DiagnosticOrder setClinicalNotes(StringDt theValue) {
        this.myClinicalNotes = theValue;
        return this;
    }

    public DiagnosticOrder setClinicalNotes(String theString) {
        this.myClinicalNotes = new StringDt(theString);
        return this;
    }

    public List<ResourceReferenceDt> getSpecimen() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySpecimen;
    }

    public List<ResourceReferenceDt> getSpecimenElement() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySpecimen;
    }

    public DiagnosticOrder setSpecimen(List<ResourceReferenceDt> theValue) {
        this.mySpecimen = theValue;
        return this;
    }

    public ResourceReferenceDt addSpecimen() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSpecimen().add(newType);
        return newType;
    }

    public BoundCodeDt<DiagnosticOrderStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<DiagnosticOrderStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public DiagnosticOrder setStatus(BoundCodeDt<DiagnosticOrderStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DiagnosticOrder setStatus(DiagnosticOrderStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeDt<DiagnosticOrderPriorityEnum> getPriority() {
        if (this.myPriority == null) {
            this.myPriority = new BoundCodeDt(DiagnosticOrderPriorityEnum.VALUESET_BINDER);
        }
        return this.myPriority;
    }

    public BoundCodeDt<DiagnosticOrderPriorityEnum> getPriorityElement() {
        if (this.myPriority == null) {
            this.myPriority = new BoundCodeDt(DiagnosticOrderPriorityEnum.VALUESET_BINDER);
        }
        return this.myPriority;
    }

    public DiagnosticOrder setPriority(BoundCodeDt<DiagnosticOrderPriorityEnum> theValue) {
        this.myPriority = theValue;
        return this;
    }

    public DiagnosticOrder setPriority(DiagnosticOrderPriorityEnum theValue) {
        this.getPriority().setValueAsEnum((Enum)theValue);
        return this;
    }

    public List<Event> getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<Event>();
        }
        return this.myEvent;
    }

    public List<Event> getEventElement() {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<Event>();
        }
        return this.myEvent;
    }

    public DiagnosticOrder setEvent(List<Event> theValue) {
        this.myEvent = theValue;
        return this;
    }

    public Event addEvent() {
        Event newType = new Event();
        this.getEvent().add(newType);
        return newType;
    }

    public Event getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            return this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public List<Item> getItem() {
        if (this.myItem == null) {
            this.myItem = new ArrayList<Item>();
        }
        return this.myItem;
    }

    public List<Item> getItemElement() {
        if (this.myItem == null) {
            this.myItem = new ArrayList<Item>();
        }
        return this.myItem;
    }

    public DiagnosticOrder setItem(List<Item> theValue) {
        this.myItem = theValue;
        return this;
    }

    public Item addItem() {
        Item newType = new Item();
        this.getItem().add(newType);
        return newType;
    }

    public Item getItemFirstRep() {
        if (this.getItem().isEmpty()) {
            return this.addItem();
        }
        return this.getItem().get(0);
    }

    public String getResourceName() {
        return "DiagnosticOrder";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Item
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Code to indicate the item (test or panel) being ordered", formalDefinition="A code that identifies a particular diagnostic investigation, or panel of investigations, that have been requested")
        private CodeableConceptDt myCode;
        @Child(name="specimen", order=1, min=0, max=-1, summary=false, modifier=false, type={Specimen.class})
        @Description(shortDefinition="If this item relates to specific specimens", formalDefinition="If the item is related to a specific speciment")
        private List<ResourceReferenceDt> mySpecimen;
        @Child(name="bodySite", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Location of requested test (if applicable)", formalDefinition="Anatomical location where the request test should be performed")
        private CodeableConceptDt myBodySite;
        @Child(name="status", type={CodeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="requested | received | accepted | in progress | review | completed | suspended | rejected | failed", formalDefinition="The status of this individual item within the order")
        private BoundCodeDt<DiagnosticOrderStatusEnum> myStatus;
        @Child(name="event", type={Event.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Events specific to this item", formalDefinition="A summary of the events of interest that have occurred as this item of the request is processed")
        private List<Event> myEvent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.mySpecimen, this.myBodySite, this.myStatus, this.myEvent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.mySpecimen, this.myBodySite, this.myStatus, this.myEvent});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Item setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getSpecimen() {
            if (this.mySpecimen == null) {
                this.mySpecimen = new ArrayList<ResourceReferenceDt>();
            }
            return this.mySpecimen;
        }

        public List<ResourceReferenceDt> getSpecimenElement() {
            if (this.mySpecimen == null) {
                this.mySpecimen = new ArrayList<ResourceReferenceDt>();
            }
            return this.mySpecimen;
        }

        public Item setSpecimen(List<ResourceReferenceDt> theValue) {
            this.mySpecimen = theValue;
            return this;
        }

        public ResourceReferenceDt addSpecimen() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getSpecimen().add(newType);
            return newType;
        }

        public CodeableConceptDt getBodySite() {
            if (this.myBodySite == null) {
                this.myBodySite = new CodeableConceptDt();
            }
            return this.myBodySite;
        }

        public CodeableConceptDt getBodySiteElement() {
            if (this.myBodySite == null) {
                this.myBodySite = new CodeableConceptDt();
            }
            return this.myBodySite;
        }

        public Item setBodySite(CodeableConceptDt theValue) {
            this.myBodySite = theValue;
            return this;
        }

        public BoundCodeDt<DiagnosticOrderStatusEnum> getStatus() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public BoundCodeDt<DiagnosticOrderStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public Item setStatus(BoundCodeDt<DiagnosticOrderStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Item setStatus(DiagnosticOrderStatusEnum theValue) {
            this.getStatus().setValueAsEnum((Enum)theValue);
            return this;
        }

        public List<Event> getEvent() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<Event>();
            }
            return this.myEvent;
        }

        public List<Event> getEventElement() {
            if (this.myEvent == null) {
                this.myEvent = new ArrayList<Event>();
            }
            return this.myEvent;
        }

        public Item setEvent(List<Event> theValue) {
            this.myEvent = theValue;
            return this;
        }

        public Event addEvent() {
            Event newType = new Event();
            this.getEvent().add(newType);
            return newType;
        }

        public Event getEventFirstRep() {
            if (this.getEvent().isEmpty()) {
                return this.addEvent();
            }
            return this.getEvent().get(0);
        }
    }

    @Block
    public static class Event
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="status", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="requested | received | accepted | in progress | review | completed | suspended | rejected | failed", formalDefinition="The status for the event")
        private BoundCodeDt<DiagnosticOrderStatusEnum> myStatus;
        @Child(name="description", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="More information about the event and it's context", formalDefinition="Additional information about the event that occurred - e.g. if the status remained unchanged")
        private CodeableConceptDt myDescription;
        @Child(name="dateTime", type={DateTimeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The date at which the event happened", formalDefinition="The date/time at which the event occurred")
        private DateTimeDt myDateTime;
        @Child(name="actor", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Device.class})
        @Description(shortDefinition="Who recorded or did this", formalDefinition="The person who was responsible for performing or recording the action")
        private ResourceReferenceDt myActor;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStatus, this.myDescription, this.myDateTime, this.myActor});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStatus, this.myDescription, this.myDateTime, this.myActor});
        }

        public BoundCodeDt<DiagnosticOrderStatusEnum> getStatus() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public BoundCodeDt<DiagnosticOrderStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(DiagnosticOrderStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public Event setStatus(BoundCodeDt<DiagnosticOrderStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Event setStatus(DiagnosticOrderStatusEnum theValue) {
            this.getStatus().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodeableConceptDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new CodeableConceptDt();
            }
            return this.myDescription;
        }

        public CodeableConceptDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new CodeableConceptDt();
            }
            return this.myDescription;
        }

        public Event setDescription(CodeableConceptDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public DateTimeDt getDateTime() {
            if (this.myDateTime == null) {
                this.myDateTime = new DateTimeDt();
            }
            return this.myDateTime;
        }

        public DateTimeDt getDateTimeElement() {
            if (this.myDateTime == null) {
                this.myDateTime = new DateTimeDt();
            }
            return this.myDateTime;
        }

        public Event setDateTime(DateTimeDt theValue) {
            this.myDateTime = theValue;
            return this;
        }

        public Event setDateTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDateTime = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Event setDateTimeWithSecondsPrecision(Date theDate) {
            this.myDateTime = new DateTimeDt(theDate);
            return this;
        }

        public ResourceReferenceDt getActor() {
            if (this.myActor == null) {
                this.myActor = new ResourceReferenceDt();
            }
            return this.myActor;
        }

        public ResourceReferenceDt getActorElement() {
            if (this.myActor == null) {
                this.myActor = new ResourceReferenceDt();
            }
            return this.myActor;
        }

        public Event setActor(ResourceReferenceDt theValue) {
            this.myActor = theValue;
            return this;
        }
    }
}

