/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AgeDt;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.RangeDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="FamilyHistory", profile="http://hl7.org/fhir/profiles/FamilyHistory", id="familyhistory")
public class FamilyHistory
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="FamilyHistory.subject", description="The identity of a subject to list family history items for", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("FamilyHistory.subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="External Id(s) for this record", formalDefinition="This records identifiers associated with this family history record that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=1, min=1, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="Patient history is about", formalDefinition="The person who this history concerns")
    private ResourceReferenceDt mySubject;
    @Child(name="note", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Additional details not covered elsewhere", formalDefinition="Conveys information about family history not specific to individual relations.")
    private StringDt myNote;
    @Child(name="relation", order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Relative described by history", formalDefinition="The related person. Each FamilyHistory resource contains the entire family history for a single person.")
    private List<Relation> myRelation;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.mySubject, this.myNote, this.myRelation});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.mySubject, this.myNote, this.myRelation});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public FamilyHistory setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public FamilyHistory addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public FamilyHistory addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public FamilyHistory setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public StringDt getNote() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public StringDt getNoteElement() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public FamilyHistory setNote(StringDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public FamilyHistory setNote(String theString) {
        this.myNote = new StringDt(theString);
        return this;
    }

    public List<Relation> getRelation() {
        if (this.myRelation == null) {
            this.myRelation = new ArrayList<Relation>();
        }
        return this.myRelation;
    }

    public List<Relation> getRelationElement() {
        if (this.myRelation == null) {
            this.myRelation = new ArrayList<Relation>();
        }
        return this.myRelation;
    }

    public FamilyHistory setRelation(List<Relation> theValue) {
        this.myRelation = theValue;
        return this;
    }

    public Relation addRelation() {
        Relation newType = new Relation();
        this.getRelation().add(newType);
        return newType;
    }

    public Relation getRelationFirstRep() {
        if (this.getRelation().isEmpty()) {
            return this.addRelation();
        }
        return this.getRelation().get(0);
    }

    public String getResourceName() {
        return "FamilyHistory";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class RelationCondition
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Condition suffered by relation", formalDefinition="The actual condition specified. Could be a coded condition (like MI or Diabetes) or a less specific string like 'cancer' depending on how much is known about the condition and the capabilities of the creating system")
        private CodeableConceptDt myType;
        @Child(name="outcome", type={CodeableConceptDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="deceased | permanent disability | etc.", formalDefinition="Indicates what happened as a result of this condition.  If the condition resulted in death, deceased date is captured on the relation.")
        private CodeableConceptDt myOutcome;
        @Child(name="onset", order=2, min=0, max=1, summary=false, modifier=false, type={AgeDt.class, RangeDt.class, StringDt.class})
        @Description(shortDefinition="When condition first manifested", formalDefinition="Either the age of onset, range of approximate age or descriptive string can be recorded.  For conditions with multiple occurrences, this describes the first known occurrence.")
        private IDatatype myOnset;
        @Child(name="note", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Extra information about condition", formalDefinition="An area where general notes can be placed about this specific condition.")
        private StringDt myNote;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myOutcome, this.myOnset, this.myNote});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myOutcome, this.myOnset, this.myNote});
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public CodeableConceptDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public RelationCondition setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public CodeableConceptDt getOutcome() {
            if (this.myOutcome == null) {
                this.myOutcome = new CodeableConceptDt();
            }
            return this.myOutcome;
        }

        public CodeableConceptDt getOutcomeElement() {
            if (this.myOutcome == null) {
                this.myOutcome = new CodeableConceptDt();
            }
            return this.myOutcome;
        }

        public RelationCondition setOutcome(CodeableConceptDt theValue) {
            this.myOutcome = theValue;
            return this;
        }

        public IDatatype getOnset() {
            return this.myOnset;
        }

        public IDatatype getOnsetElement() {
            return this.myOnset;
        }

        public RelationCondition setOnset(IDatatype theValue) {
            this.myOnset = theValue;
            return this;
        }

        public StringDt getNote() {
            if (this.myNote == null) {
                this.myNote = new StringDt();
            }
            return this.myNote;
        }

        public StringDt getNoteElement() {
            if (this.myNote == null) {
                this.myNote = new StringDt();
            }
            return this.myNote;
        }

        public RelationCondition setNote(StringDt theValue) {
            this.myNote = theValue;
            return this;
        }

        public RelationCondition setNote(String theString) {
            this.myNote = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Relation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="The family member described", formalDefinition="This will either be a name or a description.  E.g. \"Aunt Susan\", \"my cousin with the red hair\"")
        private StringDt myName;
        @Child(name="relationship", type={CodeableConceptDt.class}, order=1, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="Relationship to the subject", formalDefinition="The type of relationship this person has to the patient (father, mother, brother etc.)")
        private CodeableConceptDt myRelationship;
        @Child(name="born", order=2, min=0, max=1, summary=false, modifier=false, type={PeriodDt.class, DateDt.class, StringDt.class})
        @Description(shortDefinition="(approximate) date of birth", formalDefinition="The actual or approximate date of birth of the relative")
        private IDatatype myBorn;
        @Child(name="deceased", order=3, min=0, max=1, summary=false, modifier=false, type={BooleanDt.class, AgeDt.class, RangeDt.class, DateDt.class, StringDt.class})
        @Description(shortDefinition="Dead? How old/when?", formalDefinition="If this resource is indicating that the related person is deceased, then an indicator of whether the person is deceased (yes) or not (no) or the age or age range or description of age at death - can be indicated here. If the reason for death is known, then it can be indicated in the outcome code of the condition - in this case the deceased property should still be set.")
        private IDatatype myDeceased;
        @Child(name="note", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="General note about related person", formalDefinition="This property allows a non condition-specific note to the made about the related person. Ideally, the note would be in the condition property, but this is not always possible.")
        private StringDt myNote;
        @Child(name="condition", order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Condition that the related person had", formalDefinition="The significant Conditions (or condition) that the family member had. This is a repeating section to allow a system to represent more than one condition per resource, though there is nothing stopping multiple resources - one per condition.")
        private List<RelationCondition> myCondition;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myRelationship, this.myBorn, this.myDeceased, this.myNote, this.myCondition});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myRelationship, this.myBorn, this.myDeceased, this.myNote, this.myCondition});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Relation setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Relation setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getRelationship() {
            if (this.myRelationship == null) {
                this.myRelationship = new CodeableConceptDt();
            }
            return this.myRelationship;
        }

        public CodeableConceptDt getRelationshipElement() {
            if (this.myRelationship == null) {
                this.myRelationship = new CodeableConceptDt();
            }
            return this.myRelationship;
        }

        public Relation setRelationship(CodeableConceptDt theValue) {
            this.myRelationship = theValue;
            return this;
        }

        public IDatatype getBorn() {
            return this.myBorn;
        }

        public IDatatype getBornElement() {
            return this.myBorn;
        }

        public Relation setBorn(IDatatype theValue) {
            this.myBorn = theValue;
            return this;
        }

        public IDatatype getDeceased() {
            return this.myDeceased;
        }

        public IDatatype getDeceasedElement() {
            return this.myDeceased;
        }

        public Relation setDeceased(IDatatype theValue) {
            this.myDeceased = theValue;
            return this;
        }

        public StringDt getNote() {
            if (this.myNote == null) {
                this.myNote = new StringDt();
            }
            return this.myNote;
        }

        public StringDt getNoteElement() {
            if (this.myNote == null) {
                this.myNote = new StringDt();
            }
            return this.myNote;
        }

        public Relation setNote(StringDt theValue) {
            this.myNote = theValue;
            return this;
        }

        public Relation setNote(String theString) {
            this.myNote = new StringDt(theString);
            return this;
        }

        public List<RelationCondition> getCondition() {
            if (this.myCondition == null) {
                this.myCondition = new ArrayList<RelationCondition>();
            }
            return this.myCondition;
        }

        public List<RelationCondition> getConditionElement() {
            if (this.myCondition == null) {
                this.myCondition = new ArrayList<RelationCondition>();
            }
            return this.myCondition;
        }

        public Relation setCondition(List<RelationCondition> theValue) {
            this.myCondition = theValue;
            return this;
        }

        public RelationCondition addCondition() {
            RelationCondition newType = new RelationCondition();
            this.getCondition().add(newType);
            return newType;
        }

        public RelationCondition getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                return this.addCondition();
            }
            return this.getCondition().get(0);
        }
    }
}

