/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Microarray;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.SequencingAnalysis;
import ca.uhn.fhir.model.dstu.resource.SequencingLab;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="GeneExpression", profile="http://hl7.org/fhir/profiles/GeneExpression", id="geneexpression")
public class GeneExpression
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="GeneExpression.subject", description="subject being described by the resource", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("GeneExpression.subject");
    @SearchParamDefinition(name="gene", path="GeneExpression.gene.identifier", description="Id of the gene", type="string")
    public static final String SP_GENE = "gene";
    public static final StringClientParam GENE = new StringClientParam("gene");
    @SearchParamDefinition(name="coordinate", path="GeneExpression.gene.coordinate", description="Coordinate of the gene", type="string")
    public static final String SP_COORDINATE = "coordinate";
    public static final StringClientParam COORDINATE = new StringClientParam("coordinate");
    @Child(name="subject", order=0, min=0, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="Subject described by the resource", formalDefinition="Subject described by the resource")
    private ResourceReferenceDt mySubject;
    @Child(name="gene", order=1, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Gene of study", formalDefinition="Gene of study")
    private Gene myGene;
    @Child(name="microarray", order=2, min=0, max=-1, summary=false, modifier=false, type={Microarray.class})
    @Description(shortDefinition="Microarray that studies the gene", formalDefinition="Microarray that studies the gene")
    private List<ResourceReferenceDt> myMicroarray;
    @Child(name="rnaSeq", order=3, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="RNA-Seq that studies the gene", formalDefinition="RNA-Seq that studies the gene")
    private List<RnaSeq> myRnaSeq;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.myGene, this.myMicroarray, this.myRnaSeq});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myGene, this.myMicroarray, this.myRnaSeq});
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public GeneExpression setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public Gene getGene() {
        if (this.myGene == null) {
            this.myGene = new Gene();
        }
        return this.myGene;
    }

    public Gene getGeneElement() {
        if (this.myGene == null) {
            this.myGene = new Gene();
        }
        return this.myGene;
    }

    public GeneExpression setGene(Gene theValue) {
        this.myGene = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getMicroarray() {
        if (this.myMicroarray == null) {
            this.myMicroarray = new ArrayList<ResourceReferenceDt>();
        }
        return this.myMicroarray;
    }

    public List<ResourceReferenceDt> getMicroarrayElement() {
        if (this.myMicroarray == null) {
            this.myMicroarray = new ArrayList<ResourceReferenceDt>();
        }
        return this.myMicroarray;
    }

    public GeneExpression setMicroarray(List<ResourceReferenceDt> theValue) {
        this.myMicroarray = theValue;
        return this;
    }

    public ResourceReferenceDt addMicroarray() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getMicroarray().add(newType);
        return newType;
    }

    public List<RnaSeq> getRnaSeq() {
        if (this.myRnaSeq == null) {
            this.myRnaSeq = new ArrayList<RnaSeq>();
        }
        return this.myRnaSeq;
    }

    public List<RnaSeq> getRnaSeqElement() {
        if (this.myRnaSeq == null) {
            this.myRnaSeq = new ArrayList<RnaSeq>();
        }
        return this.myRnaSeq;
    }

    public GeneExpression setRnaSeq(List<RnaSeq> theValue) {
        this.myRnaSeq = theValue;
        return this;
    }

    public RnaSeq addRnaSeq() {
        RnaSeq newType = new RnaSeq();
        this.getRnaSeq().add(newType);
        return newType;
    }

    public RnaSeq getRnaSeqFirstRep() {
        if (this.getRnaSeq().isEmpty()) {
            return this.addRnaSeq();
        }
        return this.getRnaSeq().get(0);
    }

    public String getResourceName() {
        return "GeneExpression";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class RnaSeqIsoform
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identity", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifier of the isoform", formalDefinition="Identifier of the isoform")
        private StringDt myIdentity;
        @Child(name="expression", type={DecimalDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Expression level of the isoform in RPKM", formalDefinition="Expression level of the isoform in RPKM")
        private DecimalDt myExpression;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentity, this.myExpression});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentity, this.myExpression});
        }

        public StringDt getIdentity() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public StringDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public RnaSeqIsoform setIdentity(StringDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public RnaSeqIsoform setIdentity(String theString) {
            this.myIdentity = new StringDt(theString);
            return this;
        }

        public DecimalDt getExpression() {
            if (this.myExpression == null) {
                this.myExpression = new DecimalDt();
            }
            return this.myExpression;
        }

        public DecimalDt getExpressionElement() {
            if (this.myExpression == null) {
                this.myExpression = new DecimalDt();
            }
            return this.myExpression;
        }

        public RnaSeqIsoform setExpression(DecimalDt theValue) {
            this.myExpression = theValue;
            return this;
        }

        public RnaSeqIsoform setExpression(long theValue) {
            this.myExpression = new DecimalDt(theValue);
            return this;
        }

        public RnaSeqIsoform setExpression(double theValue) {
            this.myExpression = new DecimalDt(theValue);
            return this;
        }

        public RnaSeqIsoform setExpression(BigDecimal theValue) {
            this.myExpression = new DecimalDt(theValue);
            return this;
        }
    }

    @Block
    public static class RnaSeq
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="inputLab", order=0, min=0, max=1, summary=false, modifier=false, type={SequencingLab.class})
        @Description(shortDefinition="Input lab for the RNA-Seq", formalDefinition="Input lab for the RNA-Seq")
        private ResourceReferenceDt myInputLab;
        @Child(name="inputAnalysis", order=1, min=0, max=1, summary=false, modifier=false, type={SequencingAnalysis.class})
        @Description(shortDefinition="Input analysis for the RNA-Seq", formalDefinition="Input analysis for the RNA-Seq")
        private ResourceReferenceDt myInputAnalysis;
        @Child(name="expression", type={DecimalDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Expression level of the gene in RPKM", formalDefinition="Expression level of the gene in RPKM")
        private DecimalDt myExpression;
        @Child(name="isoform", order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Isoform of the gene", formalDefinition="Isoform of the gene")
        private List<RnaSeqIsoform> myIsoform;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myInputLab, this.myInputAnalysis, this.myExpression, this.myIsoform});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myInputLab, this.myInputAnalysis, this.myExpression, this.myIsoform});
        }

        public ResourceReferenceDt getInputLab() {
            if (this.myInputLab == null) {
                this.myInputLab = new ResourceReferenceDt();
            }
            return this.myInputLab;
        }

        public ResourceReferenceDt getInputLabElement() {
            if (this.myInputLab == null) {
                this.myInputLab = new ResourceReferenceDt();
            }
            return this.myInputLab;
        }

        public RnaSeq setInputLab(ResourceReferenceDt theValue) {
            this.myInputLab = theValue;
            return this;
        }

        public ResourceReferenceDt getInputAnalysis() {
            if (this.myInputAnalysis == null) {
                this.myInputAnalysis = new ResourceReferenceDt();
            }
            return this.myInputAnalysis;
        }

        public ResourceReferenceDt getInputAnalysisElement() {
            if (this.myInputAnalysis == null) {
                this.myInputAnalysis = new ResourceReferenceDt();
            }
            return this.myInputAnalysis;
        }

        public RnaSeq setInputAnalysis(ResourceReferenceDt theValue) {
            this.myInputAnalysis = theValue;
            return this;
        }

        public DecimalDt getExpression() {
            if (this.myExpression == null) {
                this.myExpression = new DecimalDt();
            }
            return this.myExpression;
        }

        public DecimalDt getExpressionElement() {
            if (this.myExpression == null) {
                this.myExpression = new DecimalDt();
            }
            return this.myExpression;
        }

        public RnaSeq setExpression(DecimalDt theValue) {
            this.myExpression = theValue;
            return this;
        }

        public RnaSeq setExpression(long theValue) {
            this.myExpression = new DecimalDt(theValue);
            return this;
        }

        public RnaSeq setExpression(double theValue) {
            this.myExpression = new DecimalDt(theValue);
            return this;
        }

        public RnaSeq setExpression(BigDecimal theValue) {
            this.myExpression = new DecimalDt(theValue);
            return this;
        }

        public List<RnaSeqIsoform> getIsoform() {
            if (this.myIsoform == null) {
                this.myIsoform = new ArrayList<RnaSeqIsoform>();
            }
            return this.myIsoform;
        }

        public List<RnaSeqIsoform> getIsoformElement() {
            if (this.myIsoform == null) {
                this.myIsoform = new ArrayList<RnaSeqIsoform>();
            }
            return this.myIsoform;
        }

        public RnaSeq setIsoform(List<RnaSeqIsoform> theValue) {
            this.myIsoform = theValue;
            return this;
        }

        public RnaSeqIsoform addIsoform() {
            RnaSeqIsoform newType = new RnaSeqIsoform();
            this.getIsoform().add(newType);
            return newType;
        }

        public RnaSeqIsoform getIsoformFirstRep() {
            if (this.getIsoform().isEmpty()) {
                return this.addIsoform();
            }
            return this.getIsoform().get(0);
        }
    }

    @Block
    public static class GeneCoordinate
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="chromosome", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Chromosome", formalDefinition="Chromosome")
        private StringDt myChromosome;
        @Child(name="start", type={IntegerDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Start position", formalDefinition="Start position")
        private IntegerDt myStart;
        @Child(name="end", type={IntegerDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="End position", formalDefinition="End position")
        private IntegerDt myEnd;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myChromosome, this.myStart, this.myEnd});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myChromosome, this.myStart, this.myEnd});
        }

        public StringDt getChromosome() {
            if (this.myChromosome == null) {
                this.myChromosome = new StringDt();
            }
            return this.myChromosome;
        }

        public StringDt getChromosomeElement() {
            if (this.myChromosome == null) {
                this.myChromosome = new StringDt();
            }
            return this.myChromosome;
        }

        public GeneCoordinate setChromosome(StringDt theValue) {
            this.myChromosome = theValue;
            return this;
        }

        public GeneCoordinate setChromosome(String theString) {
            this.myChromosome = new StringDt(theString);
            return this;
        }

        public IntegerDt getStart() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public IntegerDt getStartElement() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public GeneCoordinate setStart(IntegerDt theValue) {
            this.myStart = theValue;
            return this;
        }

        public GeneCoordinate setStart(int theInteger) {
            this.myStart = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getEnd() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public IntegerDt getEndElement() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public GeneCoordinate setEnd(IntegerDt theValue) {
            this.myEnd = theValue;
            return this;
        }

        public GeneCoordinate setEnd(int theInteger) {
            this.myEnd = new IntegerDt(theInteger);
            return this;
        }
    }

    @Block
    public static class Gene
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={StringDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifier of the gene", formalDefinition="Identifier of the gene")
        private StringDt myIdentifier;
        @Child(name="coordinate", order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Coordinate of the gene", formalDefinition="Coordinate of the gene")
        private GeneCoordinate myCoordinate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentifier, this.myCoordinate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCoordinate});
        }

        public StringDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new StringDt();
            }
            return this.myIdentifier;
        }

        public StringDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new StringDt();
            }
            return this.myIdentifier;
        }

        public Gene setIdentifier(StringDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Gene setIdentifier(String theString) {
            this.myIdentifier = new StringDt(theString);
            return this;
        }

        public GeneCoordinate getCoordinate() {
            if (this.myCoordinate == null) {
                this.myCoordinate = new GeneCoordinate();
            }
            return this.myCoordinate;
        }

        public GeneCoordinate getCoordinateElement() {
            if (this.myCoordinate == null) {
                this.myCoordinate = new GeneCoordinate();
            }
            return this.myCoordinate;
        }

        public Gene setCoordinate(GeneCoordinate theValue) {
            this.myCoordinate = theValue;
            return this;
        }
    }
}

