/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Order;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.OrderOutcomeStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="OrderResponse", profile="http://hl7.org/fhir/profiles/OrderResponse", id="orderresponse")
public class OrderResponse
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="request", path="OrderResponse.request", description="", type="reference")
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("OrderResponse.request");
    @SearchParamDefinition(name="date", path="OrderResponse.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="who", path="OrderResponse.who", description="", type="reference")
    public static final String SP_WHO = "who";
    public static final ReferenceClientParam WHO = new ReferenceClientParam("who");
    public static final Include INCLUDE_WHO = new Include("OrderResponse.who");
    @SearchParamDefinition(name="code", path="OrderResponse.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="fulfillment", path="OrderResponse.fulfillment", description="", type="reference")
    public static final String SP_FULFILLMENT = "fulfillment";
    public static final ReferenceClientParam FULFILLMENT = new ReferenceClientParam("fulfillment");
    public static final Include INCLUDE_FULFILLMENT = new Include("OrderResponse.fulfillment");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Identifiers assigned to this order by the orderer or by the receiver", formalDefinition="Identifiers assigned to this order. The identifiers are usually assigned by the system responding to the order, but they may be provided or added to by other systems")
    private List<IdentifierDt> myIdentifier;
    @Child(name="request", order=1, min=1, max=1, summary=false, modifier=false, type={Order.class})
    @Description(shortDefinition="The order that this is a response to", formalDefinition="A reference to the order that this is in response to")
    private ResourceReferenceDt myRequest;
    @Child(name="date", type={DateTimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="When the response was made", formalDefinition="The date and time at which this order response was made (created/posted)")
    private DateTimeDt myDate;
    @Child(name="who", order=3, min=0, max=1, summary=false, modifier=false, type={Practitioner.class, Organization.class, Device.class})
    @Description(shortDefinition="Who made the response", formalDefinition="The person, organization, or device credited with making the response")
    private ResourceReferenceDt myWho;
    @Child(name="authority", order=4, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, IResource.class})
    @Description(shortDefinition="If required by policy", formalDefinition="A reference to an authority policy that is the reason for the response. Usually this is used when the order is rejected, to provide a reason for rejection")
    private IDatatype myAuthority;
    @Child(name="code", type={CodeDt.class}, order=5, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="pending | review | rejected | error | accepted | cancelled | replaced | aborted | complete", formalDefinition="What this response says about the status of the original order")
    private BoundCodeDt<OrderOutcomeStatusEnum> myCode;
    @Child(name="description", type={StringDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Additional description of the response", formalDefinition="Additional description about the response - e.g. a text description provided by a human user when making decisions about the order")
    private StringDt myDescription;
    @Child(name="fulfillment", order=7, min=0, max=-1, summary=false, modifier=false, type={IResource.class})
    @Description(shortDefinition="Details of the outcome of performing the order", formalDefinition="Links to resources that provide details of the outcome of performing the order. E.g. Diagnostic Reports in a response that is made to an order that referenced a diagnostic order")
    private List<ResourceReferenceDt> myFulfillment;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myRequest, this.myDate, this.myWho, this.myAuthority, this.myCode, this.myDescription, this.myFulfillment});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myRequest, this.myDate, this.myWho, this.myAuthority, this.myCode, this.myDescription, this.myFulfillment});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public OrderResponse setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public OrderResponse addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public OrderResponse addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getRequest() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public ResourceReferenceDt getRequestElement() {
        if (this.myRequest == null) {
            this.myRequest = new ResourceReferenceDt();
        }
        return this.myRequest;
    }

    public OrderResponse setRequest(ResourceReferenceDt theValue) {
        this.myRequest = theValue;
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public OrderResponse setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public OrderResponse setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public OrderResponse setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getWho() {
        if (this.myWho == null) {
            this.myWho = new ResourceReferenceDt();
        }
        return this.myWho;
    }

    public ResourceReferenceDt getWhoElement() {
        if (this.myWho == null) {
            this.myWho = new ResourceReferenceDt();
        }
        return this.myWho;
    }

    public OrderResponse setWho(ResourceReferenceDt theValue) {
        this.myWho = theValue;
        return this;
    }

    public IDatatype getAuthority() {
        return this.myAuthority;
    }

    public IDatatype getAuthorityElement() {
        return this.myAuthority;
    }

    public OrderResponse setAuthority(IDatatype theValue) {
        this.myAuthority = theValue;
        return this;
    }

    public BoundCodeDt<OrderOutcomeStatusEnum> getCode() {
        if (this.myCode == null) {
            this.myCode = new BoundCodeDt(OrderOutcomeStatusEnum.VALUESET_BINDER);
        }
        return this.myCode;
    }

    public BoundCodeDt<OrderOutcomeStatusEnum> getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new BoundCodeDt(OrderOutcomeStatusEnum.VALUESET_BINDER);
        }
        return this.myCode;
    }

    public OrderResponse setCode(BoundCodeDt<OrderOutcomeStatusEnum> theValue) {
        this.myCode = theValue;
        return this;
    }

    public OrderResponse setCode(OrderOutcomeStatusEnum theValue) {
        this.getCode().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public OrderResponse setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public OrderResponse setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<ResourceReferenceDt> getFulfillment() {
        if (this.myFulfillment == null) {
            this.myFulfillment = new ArrayList<ResourceReferenceDt>();
        }
        return this.myFulfillment;
    }

    public List<ResourceReferenceDt> getFulfillmentElement() {
        if (this.myFulfillment == null) {
            this.myFulfillment = new ArrayList<ResourceReferenceDt>();
        }
        return this.myFulfillment;
    }

    public OrderResponse setFulfillment(List<ResourceReferenceDt> theValue) {
        this.myFulfillment = theValue;
        return this;
    }

    public ResourceReferenceDt addFulfillment() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getFulfillment().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "OrderResponse";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

