/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.ValueSet;
import ca.uhn.fhir.model.dstu.valueset.AggregationModeEnum;
import ca.uhn.fhir.model.dstu.valueset.BindingConformanceEnum;
import ca.uhn.fhir.model.dstu.valueset.ConstraintSeverityEnum;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.DataTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.ExtensionContextEnum;
import ca.uhn.fhir.model.dstu.valueset.FHIRDefinedTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.PropertyRepresentationEnum;
import ca.uhn.fhir.model.dstu.valueset.ResourceProfileStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.SearchParamTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.SlicingRulesEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Profile", profile="http://hl7.org/fhir/profiles/Profile", id="profile")
public class Profile
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Profile.identifier", description="The identifier of the profile", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="Profile.version", description="The version identifier of the profile", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="Profile.name", description="Name of the profile", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="Profile.publisher", description="Name of the publisher of the profile", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="Profile.description", description="Text search in the description of the profile", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="Profile.status", description="The current status of the profile", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="Profile.date", description="The profile publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="code", path="Profile.code", description="A code for the profile in the format uri::code (server may choose to do subsumption)", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="extension", path="Profile.extensionDefn.code", description="An extension code (use or definition)", type="token")
    public static final String SP_EXTENSION = "extension";
    public static final TokenClientParam EXTENSION = new TokenClientParam("extension");
    @SearchParamDefinition(name="valueset", path="Profile.structure.element.definition.binding.reference[x]", description="A vocabulary binding code", type="reference")
    public static final String SP_VALUESET = "valueset";
    public static final ReferenceClientParam VALUESET = new ReferenceClientParam("valueset");
    public static final Include INCLUDE_STRUCTURE_ELEMENT_DEFINITION_BINDING_REFERENCE = new Include("Profile.structure.element.definition.binding.reference[x]");
    @SearchParamDefinition(name="type", path="Profile.structure.type", description="Type of resource that is constrained in the profile", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @Child(name="identifier", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Logical id to reference this profile", formalDefinition="The identifier that is used to identify this profile when it is referenced in a specification, model, design or an instance  (should be globally unique OID, UUID, or URI)")
    private StringDt myIdentifier;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Logical id for this version of the profile", formalDefinition="The identifier that is used to identify this version of the profile when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=2, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Informal name for this profile", formalDefinition="A free text natural language name identifying the Profile")
    private StringDt myName;
    @Child(name="publisher", type={StringDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="Details of the individual or organization who accepts responsibility for publishing the profile")
    private StringDt myPublisher;
    @Child(name="telecom", type={ContactDt.class}, order=4, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Contact information of the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher")
    private List<ContactDt> myTelecom;
    @Child(name="description", type={StringDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Natural language description of the profile", formalDefinition="A free text natural language description of the profile and its use")
    private StringDt myDescription;
    @Child(name="code", type={CodingDt.class}, order=6, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="Assist with indexing and finding", formalDefinition="A set of terms from external terminologies that may be used to assist with indexing and searching of templates.")
    private List<CodingDt> myCode;
    @Child(name="status", type={CodeDt.class}, order=7, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the profile")
    private BoundCodeDt<ResourceProfileStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=8, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This profile was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="date", type={DateTimeDt.class}, order=9, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="Date for this version of the profile", formalDefinition="The date that this version of the profile was published")
    private DateTimeDt myDate;
    @Child(name="requirements", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Scope and Usage this profile is for", formalDefinition="The Scope and Usage that this profile was created to meet")
    private StringDt myRequirements;
    @Child(name="fhirVersion", type={IdDt.class}, order=11, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="FHIR Version this profile targets", formalDefinition="The version of the FHIR specification on which this profile is based")
    private IdDt myFhirVersion;
    @Child(name="mapping", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="External specification that the content is mapped to", formalDefinition="An external specification that the content is mapped to")
    private List<Mapping> myMapping;
    @Child(name="structure", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A constraint on a resource or a data type", formalDefinition="A constraint statement about what contents a resource or data type may have")
    private List<Structure> myStructure;
    @Child(name="extensionDefn", order=14, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Definition of an extension", formalDefinition="An extension defined as part of the profile")
    private List<ExtensionDefn> myExtensionDefn;
    @Child(name="query", order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="Definition of a named query", formalDefinition="Definition of a named query and its parameters and their meaning")
    private List<Query> myQuery;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myVersion, this.myName, this.myPublisher, this.myTelecom, this.myDescription, this.myCode, this.myStatus, this.myExperimental, this.myDate, this.myRequirements, this.myFhirVersion, this.myMapping, this.myStructure, this.myExtensionDefn, this.myQuery});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myVersion, this.myName, this.myPublisher, this.myTelecom, this.myDescription, this.myCode, this.myStatus, this.myExperimental, this.myDate, this.myRequirements, this.myFhirVersion, this.myMapping, this.myStructure, this.myExtensionDefn, this.myQuery});
    }

    public StringDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new StringDt();
        }
        return this.myIdentifier;
    }

    public StringDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new StringDt();
        }
        return this.myIdentifier;
    }

    public Profile setIdentifier(StringDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Profile setIdentifier(String theString) {
        this.myIdentifier = new StringDt(theString);
        return this;
    }

    public StringDt getVersion() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public Profile setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public Profile setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public Profile setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public Profile setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public StringDt getPublisher() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public Profile setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public Profile setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public Profile setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Profile addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public Profile addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public Profile setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public Profile setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodingDt> getCode() {
        if (this.myCode == null) {
            this.myCode = new ArrayList<CodingDt>();
        }
        return this.myCode;
    }

    public List<CodingDt> getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new ArrayList<CodingDt>();
        }
        return this.myCode;
    }

    public Profile setCode(List<CodingDt> theValue) {
        this.myCode = theValue;
        return this;
    }

    public CodingDt addCode() {
        CodingDt newType = new CodingDt();
        this.getCode().add(newType);
        return newType;
    }

    public CodingDt getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            return this.addCode();
        }
        return this.getCode().get(0);
    }

    public BoundCodeDt<ResourceProfileStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ResourceProfileStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<ResourceProfileStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ResourceProfileStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Profile setStatus(BoundCodeDt<ResourceProfileStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Profile setStatus(ResourceProfileStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getExperimental() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Profile setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public Profile setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Profile setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Profile setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Profile setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public StringDt getRequirements() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public StringDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public Profile setRequirements(StringDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public Profile setRequirements(String theString) {
        this.myRequirements = new StringDt(theString);
        return this;
    }

    public IdDt getFhirVersion() {
        if (this.myFhirVersion == null) {
            this.myFhirVersion = new IdDt();
        }
        return this.myFhirVersion;
    }

    public IdDt getFhirVersionElement() {
        if (this.myFhirVersion == null) {
            this.myFhirVersion = new IdDt();
        }
        return this.myFhirVersion;
    }

    public Profile setFhirVersion(IdDt theValue) {
        this.myFhirVersion = theValue;
        return this;
    }

    public Profile setFhirVersion(String theId) {
        this.myFhirVersion = new IdDt(theId);
        return this;
    }

    public List<Mapping> getMapping() {
        if (this.myMapping == null) {
            this.myMapping = new ArrayList<Mapping>();
        }
        return this.myMapping;
    }

    public List<Mapping> getMappingElement() {
        if (this.myMapping == null) {
            this.myMapping = new ArrayList<Mapping>();
        }
        return this.myMapping;
    }

    public Profile setMapping(List<Mapping> theValue) {
        this.myMapping = theValue;
        return this;
    }

    public Mapping addMapping() {
        Mapping newType = new Mapping();
        this.getMapping().add(newType);
        return newType;
    }

    public Mapping getMappingFirstRep() {
        if (this.getMapping().isEmpty()) {
            return this.addMapping();
        }
        return this.getMapping().get(0);
    }

    public List<Structure> getStructure() {
        if (this.myStructure == null) {
            this.myStructure = new ArrayList<Structure>();
        }
        return this.myStructure;
    }

    public List<Structure> getStructureElement() {
        if (this.myStructure == null) {
            this.myStructure = new ArrayList<Structure>();
        }
        return this.myStructure;
    }

    public Profile setStructure(List<Structure> theValue) {
        this.myStructure = theValue;
        return this;
    }

    public Structure addStructure() {
        Structure newType = new Structure();
        this.getStructure().add(newType);
        return newType;
    }

    public Structure getStructureFirstRep() {
        if (this.getStructure().isEmpty()) {
            return this.addStructure();
        }
        return this.getStructure().get(0);
    }

    public List<ExtensionDefn> getExtensionDefn() {
        if (this.myExtensionDefn == null) {
            this.myExtensionDefn = new ArrayList<ExtensionDefn>();
        }
        return this.myExtensionDefn;
    }

    public List<ExtensionDefn> getExtensionDefnElement() {
        if (this.myExtensionDefn == null) {
            this.myExtensionDefn = new ArrayList<ExtensionDefn>();
        }
        return this.myExtensionDefn;
    }

    public Profile setExtensionDefn(List<ExtensionDefn> theValue) {
        this.myExtensionDefn = theValue;
        return this;
    }

    public ExtensionDefn addExtensionDefn() {
        ExtensionDefn newType = new ExtensionDefn();
        this.getExtensionDefn().add(newType);
        return newType;
    }

    public ExtensionDefn getExtensionDefnFirstRep() {
        if (this.getExtensionDefn().isEmpty()) {
            return this.addExtensionDefn();
        }
        return this.getExtensionDefn().get(0);
    }

    public List<Query> getQuery() {
        if (this.myQuery == null) {
            this.myQuery = new ArrayList<Query>();
        }
        return this.myQuery;
    }

    public List<Query> getQueryElement() {
        if (this.myQuery == null) {
            this.myQuery = new ArrayList<Query>();
        }
        return this.myQuery;
    }

    public Profile setQuery(List<Query> theValue) {
        this.myQuery = theValue;
        return this;
    }

    public Query addQuery() {
        Query newType = new Query();
        this.getQuery().add(newType);
        return newType;
    }

    public Query getQueryFirstRep() {
        if (this.getQuery().isEmpty()) {
            return this.addQuery();
        }
        return this.getQuery().get(0);
    }

    public String getResourceName() {
        return "Profile";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Query
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Special named queries (_query=)", formalDefinition="The name of a query, which is used in the URI from Conformance statements declaring use of the query.  Typically this will also be the name for the _query parameter when the query is called, though in some cases it may be aliased by a server to avoid collisions")
        private StringDt myName;
        @Child(name="documentation", type={StringDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Describes the named query", formalDefinition="Description of the query - the functionality it offers, and considerations about how it functions and to use it")
        private StringDt myDocumentation;
        @Child(name="parameter", type={StructureSearchParam.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Parameter for the named query", formalDefinition="A parameter of a named query")
        private List<StructureSearchParam> myParameter;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myDocumentation, this.myParameter});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myDocumentation, this.myParameter});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Query setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Query setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public Query setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public Query setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public List<StructureSearchParam> getParameter() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<StructureSearchParam>();
            }
            return this.myParameter;
        }

        public List<StructureSearchParam> getParameterElement() {
            if (this.myParameter == null) {
                this.myParameter = new ArrayList<StructureSearchParam>();
            }
            return this.myParameter;
        }

        public Query setParameter(List<StructureSearchParam> theValue) {
            this.myParameter = theValue;
            return this;
        }

        public StructureSearchParam addParameter() {
            StructureSearchParam newType = new StructureSearchParam();
            this.getParameter().add(newType);
            return newType;
        }

        public StructureSearchParam getParameterFirstRep() {
            if (this.getParameter().isEmpty()) {
                return this.addParameter();
            }
            return this.getParameter().get(0);
        }
    }

    @Block
    public static class ExtensionDefn
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifies the extension in this profile", formalDefinition="A unique code (within the profile) used to identify the extension")
        private CodeDt myCode;
        @Child(name="display", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Use this name when displaying the value", formalDefinition="Defined so that applications can use this name when displaying the value of the extension to the user")
        private StringDt myDisplay;
        @Child(name="contextType", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="resource | datatype | mapping | extension", formalDefinition="Identifies the type of context to which the extension applies")
        private BoundCodeDt<ExtensionContextEnum> myContextType;
        @Child(name="context", type={StringDt.class}, order=3, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Where the extension can be used in instances", formalDefinition="Identifies the types of resource or data type elements to which the extension can be applied")
        private List<StringDt> myContext;
        @Child(name="definition", type={StructureElementDefinition.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Definition of the extension and its content", formalDefinition="Definition of the extension and its content")
        private StructureElementDefinition myDefinition;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myDisplay, this.myContextType, this.myContext, this.myDefinition});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myDisplay, this.myContextType, this.myContext, this.myDefinition});
        }

        public CodeDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public ExtensionDefn setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ExtensionDefn setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public StringDt getDisplay() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public ExtensionDefn setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public ExtensionDefn setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<ExtensionContextEnum> getContextType() {
            if (this.myContextType == null) {
                this.myContextType = new BoundCodeDt(ExtensionContextEnum.VALUESET_BINDER);
            }
            return this.myContextType;
        }

        public BoundCodeDt<ExtensionContextEnum> getContextTypeElement() {
            if (this.myContextType == null) {
                this.myContextType = new BoundCodeDt(ExtensionContextEnum.VALUESET_BINDER);
            }
            return this.myContextType;
        }

        public ExtensionDefn setContextType(BoundCodeDt<ExtensionContextEnum> theValue) {
            this.myContextType = theValue;
            return this;
        }

        public ExtensionDefn setContextType(ExtensionContextEnum theValue) {
            this.getContextType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public List<StringDt> getContext() {
            if (this.myContext == null) {
                this.myContext = new ArrayList<StringDt>();
            }
            return this.myContext;
        }

        public List<StringDt> getContextElement() {
            if (this.myContext == null) {
                this.myContext = new ArrayList<StringDt>();
            }
            return this.myContext;
        }

        public ExtensionDefn setContext(List<StringDt> theValue) {
            this.myContext = theValue;
            return this;
        }

        public StringDt addContext() {
            StringDt newType = new StringDt();
            this.getContext().add(newType);
            return newType;
        }

        public StringDt getContextFirstRep() {
            if (this.getContext().isEmpty()) {
                return this.addContext();
            }
            return this.getContext().get(0);
        }

        public ExtensionDefn addContext(String theString) {
            if (this.myContext == null) {
                this.myContext = new ArrayList<StringDt>();
            }
            this.myContext.add(new StringDt(theString));
            return this;
        }

        public StructureElementDefinition getDefinition() {
            if (this.myDefinition == null) {
                this.myDefinition = new StructureElementDefinition();
            }
            return this.myDefinition;
        }

        public StructureElementDefinition getDefinitionElement() {
            if (this.myDefinition == null) {
                this.myDefinition = new StructureElementDefinition();
            }
            return this.myDefinition;
        }

        public ExtensionDefn setDefinition(StructureElementDefinition theValue) {
            this.myDefinition = theValue;
            return this;
        }
    }

    @Block
    public static class StructureSearchParam
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of search parameter", formalDefinition="The name of the standard or custom search parameter")
        private StringDt myName;
        @Child(name="type", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="number | date | string | token | reference | composite | quantity", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted")
        private BoundCodeDt<SearchParamTypeEnum> myType;
        @Child(name="documentation", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Contents and meaning of search parameter", formalDefinition="A specification for search parameters. For standard parameters, provides additional information on how the parameter is used in this solution.  For custom parameters, provides a description of what the parameter does")
        private StringDt myDocumentation;
        @Child(name="xpath", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="XPath that extracts the parameter set", formalDefinition="An XPath expression that returns a set of elements for the search parameter")
        private StringDt myXpath;
        @Child(name="target", type={CodeDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Types of resource (if a resource reference)", formalDefinition="Types of resource (if a resource is referenced)")
        private List<BoundCodeDt<ResourceTypeEnum>> myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myType, this.myDocumentation, this.myXpath, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myType, this.myDocumentation, this.myXpath, this.myTarget});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StructureSearchParam setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public StructureSearchParam setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<SearchParamTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SearchParamTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<SearchParamTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(SearchParamTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public StructureSearchParam setType(BoundCodeDt<SearchParamTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public StructureSearchParam setType(SearchParamTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDocumentation() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public StructureSearchParam setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public StructureSearchParam setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public StringDt getXpath() {
            if (this.myXpath == null) {
                this.myXpath = new StringDt();
            }
            return this.myXpath;
        }

        public StringDt getXpathElement() {
            if (this.myXpath == null) {
                this.myXpath = new StringDt();
            }
            return this.myXpath;
        }

        public StructureSearchParam setXpath(StringDt theValue) {
            this.myXpath = theValue;
            return this;
        }

        public StructureSearchParam setXpath(String theString) {
            this.myXpath = new StringDt(theString);
            return this;
        }

        public List<BoundCodeDt<ResourceTypeEnum>> getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
            }
            return this.myTarget;
        }

        public List<BoundCodeDt<ResourceTypeEnum>> getTargetElement() {
            if (this.myTarget == null) {
                this.myTarget = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
            }
            return this.myTarget;
        }

        public StructureSearchParam setTarget(List<BoundCodeDt<ResourceTypeEnum>> theValue) {
            this.myTarget = theValue;
            return this;
        }

        public BoundCodeDt<ResourceTypeEnum> addTarget(ResourceTypeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getTarget().add((BoundCodeDt<ResourceTypeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<ResourceTypeEnum> getTargetFirstRep() {
            if (this.getTarget().size() == 0) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        public BoundCodeDt<ResourceTypeEnum> addTarget() {
            BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
            this.getTarget().add((BoundCodeDt<ResourceTypeEnum>)retVal);
            return retVal;
        }

        public StructureSearchParam setTarget(ResourceTypeEnum theValue) {
            this.getTarget().clear();
            this.addTarget(theValue);
            return this;
        }
    }

    @Block
    public static class StructureElementDefinitionMapping
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identity", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Reference to mapping declaration", formalDefinition="An internal reference to the definition of a mapping")
        private IdDt myIdentity;
        @Child(name="map", type={StringDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Details of the mapping", formalDefinition="Expresses what part of the target specification corresponds to this element")
        private StringDt myMap;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentity, this.myMap});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentity, this.myMap});
        }

        public IdDt getIdentity() {
            if (this.myIdentity == null) {
                this.myIdentity = new IdDt();
            }
            return this.myIdentity;
        }

        public IdDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new IdDt();
            }
            return this.myIdentity;
        }

        public StructureElementDefinitionMapping setIdentity(IdDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public StructureElementDefinitionMapping setIdentity(String theId) {
            this.myIdentity = new IdDt(theId);
            return this;
        }

        public StringDt getMap() {
            if (this.myMap == null) {
                this.myMap = new StringDt();
            }
            return this.myMap;
        }

        public StringDt getMapElement() {
            if (this.myMap == null) {
                this.myMap = new StringDt();
            }
            return this.myMap;
        }

        public StructureElementDefinitionMapping setMap(StringDt theValue) {
            this.myMap = theValue;
            return this;
        }

        public StructureElementDefinitionMapping setMap(String theString) {
            this.myMap = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class StructureElementDefinitionBinding
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Descriptive Name", formalDefinition="A descriptive name for this - can be useful for generating implementation artifacts")
        private StringDt myName;
        @Child(name="isExtensible", type={BooleanDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Can additional codes be used?", formalDefinition="If true, then conformant systems may use additional codes or (where the data type permits) text alone to convey concepts not covered by the set of codes identified in the binding.  If false, then conformant systems are constrained to the provided codes alone")
        private BooleanDt myIsExtensible;
        @Child(name="conformance", type={CodeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="required | preferred | example", formalDefinition="Indicates the degree of conformance expectations associated with this binding")
        private BoundCodeDt<BindingConformanceEnum> myConformance;
        @Child(name="description", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Human explanation of the value set", formalDefinition="Describes the intended use of this particular set of codes")
        private StringDt myDescription;
        @Child(name="reference", order=4, min=0, max=1, summary=false, modifier=false, type={UriDt.class, ValueSet.class})
        @Description(shortDefinition="Source of value set", formalDefinition="Points to the value set or external definition that identifies the set of codes to be used")
        private IDatatype myReference;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myIsExtensible, this.myConformance, this.myDescription, this.myReference});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myIsExtensible, this.myConformance, this.myDescription, this.myReference});
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StructureElementDefinitionBinding setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public StructureElementDefinitionBinding setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public BooleanDt getIsExtensible() {
            if (this.myIsExtensible == null) {
                this.myIsExtensible = new BooleanDt();
            }
            return this.myIsExtensible;
        }

        public BooleanDt getIsExtensibleElement() {
            if (this.myIsExtensible == null) {
                this.myIsExtensible = new BooleanDt();
            }
            return this.myIsExtensible;
        }

        public StructureElementDefinitionBinding setIsExtensible(BooleanDt theValue) {
            this.myIsExtensible = theValue;
            return this;
        }

        public StructureElementDefinitionBinding setIsExtensible(boolean theBoolean) {
            this.myIsExtensible = new BooleanDt(theBoolean);
            return this;
        }

        public BoundCodeDt<BindingConformanceEnum> getConformance() {
            if (this.myConformance == null) {
                this.myConformance = new BoundCodeDt(BindingConformanceEnum.VALUESET_BINDER);
            }
            return this.myConformance;
        }

        public BoundCodeDt<BindingConformanceEnum> getConformanceElement() {
            if (this.myConformance == null) {
                this.myConformance = new BoundCodeDt(BindingConformanceEnum.VALUESET_BINDER);
            }
            return this.myConformance;
        }

        public StructureElementDefinitionBinding setConformance(BoundCodeDt<BindingConformanceEnum> theValue) {
            this.myConformance = theValue;
            return this;
        }

        public StructureElementDefinitionBinding setConformance(BindingConformanceEnum theValue) {
            this.getConformance().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StructureElementDefinitionBinding setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public StructureElementDefinitionBinding setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public IDatatype getReference() {
            return this.myReference;
        }

        public IDatatype getReferenceElement() {
            return this.myReference;
        }

        public StructureElementDefinitionBinding setReference(IDatatype theValue) {
            this.myReference = theValue;
            return this;
        }
    }

    @Block
    public static class StructureElementDefinitionConstraint
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="key", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Target of 'condition' reference above", formalDefinition="Allows identification of which elements have their cardinalities impacted by the constraint.  Will not be referenced for constraints that do not affect cardinality")
        private IdDt myKey;
        @Child(name="name", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Short human label", formalDefinition="Used to label the constraint in OCL or in short displays incapable of displaying the full human description")
        private StringDt myName;
        @Child(name="severity", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="error | warning", formalDefinition="Identifies the impact constraint violation has on the conformance of the instance")
        private BoundCodeDt<ConstraintSeverityEnum> mySeverity;
        @Child(name="human", type={StringDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Human description of constraint", formalDefinition="Text that can be used to describe the constraint in messages identifying that the constraint has been violated")
        private StringDt myHuman;
        @Child(name="xpath", type={StringDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="XPath expression of constraint", formalDefinition="XPath expression of constraint")
        private StringDt myXpath;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myKey, this.myName, this.mySeverity, this.myHuman, this.myXpath});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myKey, this.myName, this.mySeverity, this.myHuman, this.myXpath});
        }

        public IdDt getKey() {
            if (this.myKey == null) {
                this.myKey = new IdDt();
            }
            return this.myKey;
        }

        public IdDt getKeyElement() {
            if (this.myKey == null) {
                this.myKey = new IdDt();
            }
            return this.myKey;
        }

        public StructureElementDefinitionConstraint setKey(IdDt theValue) {
            this.myKey = theValue;
            return this;
        }

        public StructureElementDefinitionConstraint setKey(String theId) {
            this.myKey = new IdDt(theId);
            return this;
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StructureElementDefinitionConstraint setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public StructureElementDefinitionConstraint setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<ConstraintSeverityEnum> getSeverity() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(ConstraintSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public BoundCodeDt<ConstraintSeverityEnum> getSeverityElement() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(ConstraintSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public StructureElementDefinitionConstraint setSeverity(BoundCodeDt<ConstraintSeverityEnum> theValue) {
            this.mySeverity = theValue;
            return this;
        }

        public StructureElementDefinitionConstraint setSeverity(ConstraintSeverityEnum theValue) {
            this.getSeverity().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getHuman() {
            if (this.myHuman == null) {
                this.myHuman = new StringDt();
            }
            return this.myHuman;
        }

        public StringDt getHumanElement() {
            if (this.myHuman == null) {
                this.myHuman = new StringDt();
            }
            return this.myHuman;
        }

        public StructureElementDefinitionConstraint setHuman(StringDt theValue) {
            this.myHuman = theValue;
            return this;
        }

        public StructureElementDefinitionConstraint setHuman(String theString) {
            this.myHuman = new StringDt(theString);
            return this;
        }

        public StringDt getXpath() {
            if (this.myXpath == null) {
                this.myXpath = new StringDt();
            }
            return this.myXpath;
        }

        public StringDt getXpathElement() {
            if (this.myXpath == null) {
                this.myXpath = new StringDt();
            }
            return this.myXpath;
        }

        public StructureElementDefinitionConstraint setXpath(StringDt theValue) {
            this.myXpath = theValue;
            return this;
        }

        public StructureElementDefinitionConstraint setXpath(String theString) {
            this.myXpath = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class StructureElementDefinitionType
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name of Data type or Resource", formalDefinition="")
        private BoundCodeDt<DataTypeEnum> myCode;
        @Child(name="profile", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Profile.structure to apply", formalDefinition="Identifies a profile that SHALL hold for resources or datatypes referenced as the type of this element. Can be a local reference - to another structure in this profile, or a reference to a structure in another profile")
        private UriDt myProfile;
        @Child(name="aggregation", type={CodeDt.class}, order=2, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="contained | referenced | bundled - how aggregated", formalDefinition="If the type is a reference to another resource, how the resource is or can be aggreated - is it a contained resource, or a reference, and if the context is a bundle, is it included in the bundle")
        private List<BoundCodeDt<AggregationModeEnum>> myAggregation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myProfile, this.myAggregation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myProfile, this.myAggregation});
        }

        public BoundCodeDt<DataTypeEnum> getCode() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(DataTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public BoundCodeDt<DataTypeEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(DataTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public StructureElementDefinitionType setCode(BoundCodeDt<DataTypeEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public StructureElementDefinitionType setCode(DataTypeEnum theValue) {
            this.getCode().setValueAsEnum((Enum)theValue);
            return this;
        }

        public UriDt getProfile() {
            if (this.myProfile == null) {
                this.myProfile = new UriDt();
            }
            return this.myProfile;
        }

        public UriDt getProfileElement() {
            if (this.myProfile == null) {
                this.myProfile = new UriDt();
            }
            return this.myProfile;
        }

        public StructureElementDefinitionType setProfile(UriDt theValue) {
            this.myProfile = theValue;
            return this;
        }

        public StructureElementDefinitionType setProfile(String theUri) {
            this.myProfile = new UriDt(theUri);
            return this;
        }

        public List<BoundCodeDt<AggregationModeEnum>> getAggregation() {
            if (this.myAggregation == null) {
                this.myAggregation = new ArrayList<BoundCodeDt<AggregationModeEnum>>();
            }
            return this.myAggregation;
        }

        public List<BoundCodeDt<AggregationModeEnum>> getAggregationElement() {
            if (this.myAggregation == null) {
                this.myAggregation = new ArrayList<BoundCodeDt<AggregationModeEnum>>();
            }
            return this.myAggregation;
        }

        public StructureElementDefinitionType setAggregation(List<BoundCodeDt<AggregationModeEnum>> theValue) {
            this.myAggregation = theValue;
            return this;
        }

        public BoundCodeDt<AggregationModeEnum> addAggregation(AggregationModeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(AggregationModeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getAggregation().add((BoundCodeDt<AggregationModeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<AggregationModeEnum> getAggregationFirstRep() {
            if (this.getAggregation().size() == 0) {
                this.addAggregation();
            }
            return this.getAggregation().get(0);
        }

        public BoundCodeDt<AggregationModeEnum> addAggregation() {
            BoundCodeDt retVal = new BoundCodeDt(AggregationModeEnum.VALUESET_BINDER);
            this.getAggregation().add((BoundCodeDt<AggregationModeEnum>)retVal);
            return retVal;
        }

        public StructureElementDefinitionType setAggregation(AggregationModeEnum theValue) {
            this.getAggregation().clear();
            this.addAggregation(theValue);
            return this;
        }
    }

    @Block
    public static class StructureElementDefinition
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="short", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Concise definition for xml presentation", formalDefinition="A concise definition that  is shown in the generated XML format that summarizes profiles (used throughout the specification)")
        private StringDt myShort;
        @Child(name="formal", type={StringDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Full formal definition in human language", formalDefinition="The definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource")
        private StringDt myFormal;
        @Child(name="comments", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Comments about the use of this element", formalDefinition="Comments about the use of the element, including notes about how to use the data properly, exceptions to proper use, etc.")
        private StringDt myComments;
        @Child(name="requirements", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Why is this needed?", formalDefinition="Explains why this element is needed and why it's been constrained as it has")
        private StringDt myRequirements;
        @Child(name="synonym", type={StringDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Other names", formalDefinition="Identifies additional names by which this element might also be known")
        private List<StringDt> mySynonym;
        @Child(name="min", type={IntegerDt.class}, order=5, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Minimum Cardinality", formalDefinition="The minimum number of times this element SHALL appear in the instance")
        private IntegerDt myMin;
        @Child(name="max", type={StringDt.class}, order=6, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Maximum Cardinality (a number or *)", formalDefinition="The maximum number of times this element is permitted to appear in the instance")
        private StringDt myMax;
        @Child(name="type", order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Data type and Profile for this element", formalDefinition="The data type or resource that the value of this element is permitted to be")
        private List<StructureElementDefinitionType> myType;
        @Child(name="nameReference", type={StringDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="To another element constraint (by element.name)", formalDefinition="Identifies the name of a slice defined elsewhere in the profile whose constraints should be applied to the current element")
        private StringDt myNameReference;
        @Child(name="value", type={IDatatype.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Fixed value: [as defined for a primitive type]", formalDefinition="Specifies a primitive value that SHALL hold for this element in the instance")
        private IDatatype myValue;
        @Child(name="example", type={IDatatype.class}, order=10, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Example value: [as defined for type]", formalDefinition="An example value for this element")
        private IDatatype myExample;
        @Child(name="maxLength", type={IntegerDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Length for strings", formalDefinition="Indicates the shortest length that SHALL be supported by conformant instances without truncation")
        private IntegerDt myMaxLength;
        @Child(name="condition", type={IdDt.class}, order=12, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Reference to invariant about presence", formalDefinition="A reference to an invariant that may make additional statements about the cardinality or value in the instance")
        private List<IdDt> myCondition;
        @Child(name="constraint", order=13, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Condition that must evaluate to true", formalDefinition="Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance")
        private List<StructureElementDefinitionConstraint> myConstraint;
        @Child(name="mustSupport", type={BooleanDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="If the element must supported", formalDefinition="If true, conformant resource authors SHALL be capable of providing a value for the element and resource consumers SHALL be capable of extracting and doing something useful with the data element.  If false, the element may be ignored and not supported")
        private BooleanDt myMustSupport;
        @Child(name="isModifier", type={BooleanDt.class}, order=15, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="If this modifies the meaning of other elements", formalDefinition="If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.")
        private BooleanDt myIsModifier;
        @Child(name="binding", order=16, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="ValueSet details if this is coded", formalDefinition="Binds to a value set if this element is coded (code, Coding, CodeableConcept)")
        private StructureElementDefinitionBinding myBinding;
        @Child(name="mapping", order=17, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Map element to another set of definitions", formalDefinition="Identifies a concept from an external specification that roughly corresponds to this element")
        private List<StructureElementDefinitionMapping> myMapping;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myShort, this.myFormal, this.myComments, this.myRequirements, this.mySynonym, this.myMin, this.myMax, this.myType, this.myNameReference, this.myValue, this.myExample, this.myMaxLength, this.myCondition, this.myConstraint, this.myMustSupport, this.myIsModifier, this.myBinding, this.myMapping});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myShort, this.myFormal, this.myComments, this.myRequirements, this.mySynonym, this.myMin, this.myMax, this.myType, this.myNameReference, this.myValue, this.myExample, this.myMaxLength, this.myCondition, this.myConstraint, this.myMustSupport, this.myIsModifier, this.myBinding, this.myMapping});
        }

        public StringDt getShort() {
            if (this.myShort == null) {
                this.myShort = new StringDt();
            }
            return this.myShort;
        }

        public StringDt getShortElement() {
            if (this.myShort == null) {
                this.myShort = new StringDt();
            }
            return this.myShort;
        }

        public StructureElementDefinition setShort(StringDt theValue) {
            this.myShort = theValue;
            return this;
        }

        public StructureElementDefinition setShort(String theString) {
            this.myShort = new StringDt(theString);
            return this;
        }

        public StringDt getFormal() {
            if (this.myFormal == null) {
                this.myFormal = new StringDt();
            }
            return this.myFormal;
        }

        public StringDt getFormalElement() {
            if (this.myFormal == null) {
                this.myFormal = new StringDt();
            }
            return this.myFormal;
        }

        public StructureElementDefinition setFormal(StringDt theValue) {
            this.myFormal = theValue;
            return this;
        }

        public StructureElementDefinition setFormal(String theString) {
            this.myFormal = new StringDt(theString);
            return this;
        }

        public StringDt getComments() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public StringDt getCommentsElement() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public StructureElementDefinition setComments(StringDt theValue) {
            this.myComments = theValue;
            return this;
        }

        public StructureElementDefinition setComments(String theString) {
            this.myComments = new StringDt(theString);
            return this;
        }

        public StringDt getRequirements() {
            if (this.myRequirements == null) {
                this.myRequirements = new StringDt();
            }
            return this.myRequirements;
        }

        public StringDt getRequirementsElement() {
            if (this.myRequirements == null) {
                this.myRequirements = new StringDt();
            }
            return this.myRequirements;
        }

        public StructureElementDefinition setRequirements(StringDt theValue) {
            this.myRequirements = theValue;
            return this;
        }

        public StructureElementDefinition setRequirements(String theString) {
            this.myRequirements = new StringDt(theString);
            return this;
        }

        public List<StringDt> getSynonym() {
            if (this.mySynonym == null) {
                this.mySynonym = new ArrayList<StringDt>();
            }
            return this.mySynonym;
        }

        public List<StringDt> getSynonymElement() {
            if (this.mySynonym == null) {
                this.mySynonym = new ArrayList<StringDt>();
            }
            return this.mySynonym;
        }

        public StructureElementDefinition setSynonym(List<StringDt> theValue) {
            this.mySynonym = theValue;
            return this;
        }

        public StringDt addSynonym() {
            StringDt newType = new StringDt();
            this.getSynonym().add(newType);
            return newType;
        }

        public StringDt getSynonymFirstRep() {
            if (this.getSynonym().isEmpty()) {
                return this.addSynonym();
            }
            return this.getSynonym().get(0);
        }

        public StructureElementDefinition addSynonym(String theString) {
            if (this.mySynonym == null) {
                this.mySynonym = new ArrayList<StringDt>();
            }
            this.mySynonym.add(new StringDt(theString));
            return this;
        }

        public IntegerDt getMin() {
            if (this.myMin == null) {
                this.myMin = new IntegerDt();
            }
            return this.myMin;
        }

        public IntegerDt getMinElement() {
            if (this.myMin == null) {
                this.myMin = new IntegerDt();
            }
            return this.myMin;
        }

        public StructureElementDefinition setMin(IntegerDt theValue) {
            this.myMin = theValue;
            return this;
        }

        public StructureElementDefinition setMin(int theInteger) {
            this.myMin = new IntegerDt(theInteger);
            return this;
        }

        public StringDt getMax() {
            if (this.myMax == null) {
                this.myMax = new StringDt();
            }
            return this.myMax;
        }

        public StringDt getMaxElement() {
            if (this.myMax == null) {
                this.myMax = new StringDt();
            }
            return this.myMax;
        }

        public StructureElementDefinition setMax(StringDt theValue) {
            this.myMax = theValue;
            return this;
        }

        public StructureElementDefinition setMax(String theString) {
            this.myMax = new StringDt(theString);
            return this;
        }

        public List<StructureElementDefinitionType> getType() {
            if (this.myType == null) {
                this.myType = new ArrayList<StructureElementDefinitionType>();
            }
            return this.myType;
        }

        public List<StructureElementDefinitionType> getTypeElement() {
            if (this.myType == null) {
                this.myType = new ArrayList<StructureElementDefinitionType>();
            }
            return this.myType;
        }

        public StructureElementDefinition setType(List<StructureElementDefinitionType> theValue) {
            this.myType = theValue;
            return this;
        }

        public StructureElementDefinitionType addType() {
            StructureElementDefinitionType newType = new StructureElementDefinitionType();
            this.getType().add(newType);
            return newType;
        }

        public StructureElementDefinitionType getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                return this.addType();
            }
            return this.getType().get(0);
        }

        public StringDt getNameReference() {
            if (this.myNameReference == null) {
                this.myNameReference = new StringDt();
            }
            return this.myNameReference;
        }

        public StringDt getNameReferenceElement() {
            if (this.myNameReference == null) {
                this.myNameReference = new StringDt();
            }
            return this.myNameReference;
        }

        public StructureElementDefinition setNameReference(StringDt theValue) {
            this.myNameReference = theValue;
            return this;
        }

        public StructureElementDefinition setNameReference(String theString) {
            this.myNameReference = new StringDt(theString);
            return this;
        }

        public IDatatype getValue() {
            return this.myValue;
        }

        public IDatatype getValueElement() {
            return this.myValue;
        }

        public StructureElementDefinition setValue(IDatatype theValue) {
            this.myValue = theValue;
            return this;
        }

        public IDatatype getExample() {
            return this.myExample;
        }

        public IDatatype getExampleElement() {
            return this.myExample;
        }

        public StructureElementDefinition setExample(IDatatype theValue) {
            this.myExample = theValue;
            return this;
        }

        public IntegerDt getMaxLength() {
            if (this.myMaxLength == null) {
                this.myMaxLength = new IntegerDt();
            }
            return this.myMaxLength;
        }

        public IntegerDt getMaxLengthElement() {
            if (this.myMaxLength == null) {
                this.myMaxLength = new IntegerDt();
            }
            return this.myMaxLength;
        }

        public StructureElementDefinition setMaxLength(IntegerDt theValue) {
            this.myMaxLength = theValue;
            return this;
        }

        public StructureElementDefinition setMaxLength(int theInteger) {
            this.myMaxLength = new IntegerDt(theInteger);
            return this;
        }

        public List<IdDt> getCondition() {
            if (this.myCondition == null) {
                this.myCondition = new ArrayList<IdDt>();
            }
            return this.myCondition;
        }

        public List<IdDt> getConditionElement() {
            if (this.myCondition == null) {
                this.myCondition = new ArrayList<IdDt>();
            }
            return this.myCondition;
        }

        public StructureElementDefinition setCondition(List<IdDt> theValue) {
            this.myCondition = theValue;
            return this;
        }

        public IdDt addCondition() {
            IdDt newType = new IdDt();
            this.getCondition().add(newType);
            return newType;
        }

        public IdDt getConditionFirstRep() {
            if (this.getCondition().isEmpty()) {
                return this.addCondition();
            }
            return this.getCondition().get(0);
        }

        public StructureElementDefinition addCondition(String theId) {
            if (this.myCondition == null) {
                this.myCondition = new ArrayList<IdDt>();
            }
            this.myCondition.add(new IdDt(theId));
            return this;
        }

        public List<StructureElementDefinitionConstraint> getConstraint() {
            if (this.myConstraint == null) {
                this.myConstraint = new ArrayList<StructureElementDefinitionConstraint>();
            }
            return this.myConstraint;
        }

        public List<StructureElementDefinitionConstraint> getConstraintElement() {
            if (this.myConstraint == null) {
                this.myConstraint = new ArrayList<StructureElementDefinitionConstraint>();
            }
            return this.myConstraint;
        }

        public StructureElementDefinition setConstraint(List<StructureElementDefinitionConstraint> theValue) {
            this.myConstraint = theValue;
            return this;
        }

        public StructureElementDefinitionConstraint addConstraint() {
            StructureElementDefinitionConstraint newType = new StructureElementDefinitionConstraint();
            this.getConstraint().add(newType);
            return newType;
        }

        public StructureElementDefinitionConstraint getConstraintFirstRep() {
            if (this.getConstraint().isEmpty()) {
                return this.addConstraint();
            }
            return this.getConstraint().get(0);
        }

        public BooleanDt getMustSupport() {
            if (this.myMustSupport == null) {
                this.myMustSupport = new BooleanDt();
            }
            return this.myMustSupport;
        }

        public BooleanDt getMustSupportElement() {
            if (this.myMustSupport == null) {
                this.myMustSupport = new BooleanDt();
            }
            return this.myMustSupport;
        }

        public StructureElementDefinition setMustSupport(BooleanDt theValue) {
            this.myMustSupport = theValue;
            return this;
        }

        public StructureElementDefinition setMustSupport(boolean theBoolean) {
            this.myMustSupport = new BooleanDt(theBoolean);
            return this;
        }

        public BooleanDt getIsModifier() {
            if (this.myIsModifier == null) {
                this.myIsModifier = new BooleanDt();
            }
            return this.myIsModifier;
        }

        public BooleanDt getIsModifierElement() {
            if (this.myIsModifier == null) {
                this.myIsModifier = new BooleanDt();
            }
            return this.myIsModifier;
        }

        public StructureElementDefinition setIsModifier(BooleanDt theValue) {
            this.myIsModifier = theValue;
            return this;
        }

        public StructureElementDefinition setIsModifier(boolean theBoolean) {
            this.myIsModifier = new BooleanDt(theBoolean);
            return this;
        }

        public StructureElementDefinitionBinding getBinding() {
            if (this.myBinding == null) {
                this.myBinding = new StructureElementDefinitionBinding();
            }
            return this.myBinding;
        }

        public StructureElementDefinitionBinding getBindingElement() {
            if (this.myBinding == null) {
                this.myBinding = new StructureElementDefinitionBinding();
            }
            return this.myBinding;
        }

        public StructureElementDefinition setBinding(StructureElementDefinitionBinding theValue) {
            this.myBinding = theValue;
            return this;
        }

        public List<StructureElementDefinitionMapping> getMapping() {
            if (this.myMapping == null) {
                this.myMapping = new ArrayList<StructureElementDefinitionMapping>();
            }
            return this.myMapping;
        }

        public List<StructureElementDefinitionMapping> getMappingElement() {
            if (this.myMapping == null) {
                this.myMapping = new ArrayList<StructureElementDefinitionMapping>();
            }
            return this.myMapping;
        }

        public StructureElementDefinition setMapping(List<StructureElementDefinitionMapping> theValue) {
            this.myMapping = theValue;
            return this;
        }

        public StructureElementDefinitionMapping addMapping() {
            StructureElementDefinitionMapping newType = new StructureElementDefinitionMapping();
            this.getMapping().add(newType);
            return newType;
        }

        public StructureElementDefinitionMapping getMappingFirstRep() {
            if (this.getMapping().isEmpty()) {
                return this.addMapping();
            }
            return this.getMapping().get(0);
        }
    }

    @Block
    public static class StructureElementSlicing
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="discriminator", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Element that used to distinguish the slices", formalDefinition="Designates which child element is used to discriminate between the slices when processing an instance. The value of the child element in the instance SHALL completely distinguish which slice the element in the resource matches based on the allowed values for that element in each of the slices")
        private IdDt myDiscriminator;
        @Child(name="ordered", type={BooleanDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="If elements must be in same order as slices", formalDefinition="If the matching elements have to occur in the same order as defined in the profile")
        private BooleanDt myOrdered;
        @Child(name="rules", type={CodeDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="closed | open | openAtEnd", formalDefinition="Whether additional slices are allowed or not. When the slices are ordered, profile authors can also say that additional slices are only allowed at the end")
        private BoundCodeDt<SlicingRulesEnum> myRules;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDiscriminator, this.myOrdered, this.myRules});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDiscriminator, this.myOrdered, this.myRules});
        }

        public IdDt getDiscriminator() {
            if (this.myDiscriminator == null) {
                this.myDiscriminator = new IdDt();
            }
            return this.myDiscriminator;
        }

        public IdDt getDiscriminatorElement() {
            if (this.myDiscriminator == null) {
                this.myDiscriminator = new IdDt();
            }
            return this.myDiscriminator;
        }

        public StructureElementSlicing setDiscriminator(IdDt theValue) {
            this.myDiscriminator = theValue;
            return this;
        }

        public StructureElementSlicing setDiscriminator(String theId) {
            this.myDiscriminator = new IdDt(theId);
            return this;
        }

        public BooleanDt getOrdered() {
            if (this.myOrdered == null) {
                this.myOrdered = new BooleanDt();
            }
            return this.myOrdered;
        }

        public BooleanDt getOrderedElement() {
            if (this.myOrdered == null) {
                this.myOrdered = new BooleanDt();
            }
            return this.myOrdered;
        }

        public StructureElementSlicing setOrdered(BooleanDt theValue) {
            this.myOrdered = theValue;
            return this;
        }

        public StructureElementSlicing setOrdered(boolean theBoolean) {
            this.myOrdered = new BooleanDt(theBoolean);
            return this;
        }

        public BoundCodeDt<SlicingRulesEnum> getRules() {
            if (this.myRules == null) {
                this.myRules = new BoundCodeDt(SlicingRulesEnum.VALUESET_BINDER);
            }
            return this.myRules;
        }

        public BoundCodeDt<SlicingRulesEnum> getRulesElement() {
            if (this.myRules == null) {
                this.myRules = new BoundCodeDt(SlicingRulesEnum.VALUESET_BINDER);
            }
            return this.myRules;
        }

        public StructureElementSlicing setRules(BoundCodeDt<SlicingRulesEnum> theValue) {
            this.myRules = theValue;
            return this;
        }

        public StructureElementSlicing setRules(SlicingRulesEnum theValue) {
            this.getRules().setValueAsEnum((Enum)theValue);
            return this;
        }
    }

    @Block
    public static class StructureElement
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="path", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The path of the element (see the formal definitions)", formalDefinition="The path identifies the element and is expressed as a \".\"-separated list of ancestor elements, beginning with the name of the resource")
        private StringDt myPath;
        @Child(name="representation", type={CodeDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="How this element is represented in instances", formalDefinition="Codes that define how this element is represented in instances, when the deviation varies from the normal case")
        private List<BoundCodeDt<PropertyRepresentationEnum>> myRepresentation;
        @Child(name="name", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name for this particular element definition (reference target)", formalDefinition="The name of this element definition (to refer to it from other element definitions using Profile.structure.element.definition.nameReference). This is a unique name referring to a specific set of constraints applied to this element. One use of this is to provide a name to different slices of the same element")
        private StringDt myName;
        @Child(name="slicing", order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="This element is sliced - slices follow", formalDefinition="Indicates that the element is sliced into a set of alternative definitions (there are multiple definitions on a single element in the base resource). The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set)")
        private StructureElementSlicing mySlicing;
        @Child(name="definition", order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="More specific definition of the element", formalDefinition="Definition of the content of the element to provide a more specific definition than that contained for the element in the base resource")
        private StructureElementDefinition myDefinition;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPath, this.myRepresentation, this.myName, this.mySlicing, this.myDefinition});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPath, this.myRepresentation, this.myName, this.mySlicing, this.myDefinition});
        }

        public StringDt getPath() {
            if (this.myPath == null) {
                this.myPath = new StringDt();
            }
            return this.myPath;
        }

        public StringDt getPathElement() {
            if (this.myPath == null) {
                this.myPath = new StringDt();
            }
            return this.myPath;
        }

        public StructureElement setPath(StringDt theValue) {
            this.myPath = theValue;
            return this;
        }

        public StructureElement setPath(String theString) {
            this.myPath = new StringDt(theString);
            return this;
        }

        public List<BoundCodeDt<PropertyRepresentationEnum>> getRepresentation() {
            if (this.myRepresentation == null) {
                this.myRepresentation = new ArrayList<BoundCodeDt<PropertyRepresentationEnum>>();
            }
            return this.myRepresentation;
        }

        public List<BoundCodeDt<PropertyRepresentationEnum>> getRepresentationElement() {
            if (this.myRepresentation == null) {
                this.myRepresentation = new ArrayList<BoundCodeDt<PropertyRepresentationEnum>>();
            }
            return this.myRepresentation;
        }

        public StructureElement setRepresentation(List<BoundCodeDt<PropertyRepresentationEnum>> theValue) {
            this.myRepresentation = theValue;
            return this;
        }

        public BoundCodeDt<PropertyRepresentationEnum> addRepresentation(PropertyRepresentationEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(PropertyRepresentationEnum.VALUESET_BINDER, (Enum)theValue);
            this.getRepresentation().add((BoundCodeDt<PropertyRepresentationEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<PropertyRepresentationEnum> getRepresentationFirstRep() {
            if (this.getRepresentation().size() == 0) {
                this.addRepresentation();
            }
            return this.getRepresentation().get(0);
        }

        public BoundCodeDt<PropertyRepresentationEnum> addRepresentation() {
            BoundCodeDt retVal = new BoundCodeDt(PropertyRepresentationEnum.VALUESET_BINDER);
            this.getRepresentation().add((BoundCodeDt<PropertyRepresentationEnum>)retVal);
            return retVal;
        }

        public StructureElement setRepresentation(PropertyRepresentationEnum theValue) {
            this.getRepresentation().clear();
            this.addRepresentation(theValue);
            return this;
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StructureElement setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public StructureElement setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StructureElementSlicing getSlicing() {
            if (this.mySlicing == null) {
                this.mySlicing = new StructureElementSlicing();
            }
            return this.mySlicing;
        }

        public StructureElementSlicing getSlicingElement() {
            if (this.mySlicing == null) {
                this.mySlicing = new StructureElementSlicing();
            }
            return this.mySlicing;
        }

        public StructureElement setSlicing(StructureElementSlicing theValue) {
            this.mySlicing = theValue;
            return this;
        }

        public StructureElementDefinition getDefinition() {
            if (this.myDefinition == null) {
                this.myDefinition = new StructureElementDefinition();
            }
            return this.myDefinition;
        }

        public StructureElementDefinition getDefinitionElement() {
            if (this.myDefinition == null) {
                this.myDefinition = new StructureElementDefinition();
            }
            return this.myDefinition;
        }

        public StructureElement setDefinition(StructureElementDefinition theValue) {
            this.myDefinition = theValue;
            return this;
        }
    }

    @Block
    public static class Structure
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="The Resource or Data Type being described", formalDefinition="The Resource or Data type being described")
        private BoundCodeDt<FHIRDefinedTypeEnum> myType;
        @Child(name="name", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Name for this particular structure (reference target)", formalDefinition="The name of this resource constraint statement (to refer to it from other resource constraints - from Profile.structure.element.definition.type.profile)")
        private StringDt myName;
        @Child(name="publish", type={BooleanDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="This definition is published (i.e. for validation)", formalDefinition="This definition of a profile on a structure is published as a formal statement. Some structural definitions might be defined purely for internal use within the profile, and not intended to be used outside that context")
        private BooleanDt myPublish;
        @Child(name="purpose", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Human summary: why describe this resource?", formalDefinition="Human summary: why describe this resource?")
        private StringDt myPurpose;
        @Child(name="element", order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Definition of elements in the resource (if no profile)", formalDefinition="Captures constraints on each element within the resource")
        private List<StructureElement> myElement;
        @Child(name="searchParam", order=5, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="Search params defined", formalDefinition="Additional search parameters for implementations to support and/or make use of")
        private List<StructureSearchParam> mySearchParam;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myType, this.myName, this.myPublish, this.myPurpose, this.myElement, this.mySearchParam});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myName, this.myPublish, this.myPurpose, this.myElement, this.mySearchParam});
        }

        public BoundCodeDt<FHIRDefinedTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(FHIRDefinedTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<FHIRDefinedTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(FHIRDefinedTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public Structure setType(BoundCodeDt<FHIRDefinedTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Structure setType(FHIRDefinedTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Structure setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Structure setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public BooleanDt getPublish() {
            if (this.myPublish == null) {
                this.myPublish = new BooleanDt();
            }
            return this.myPublish;
        }

        public BooleanDt getPublishElement() {
            if (this.myPublish == null) {
                this.myPublish = new BooleanDt();
            }
            return this.myPublish;
        }

        public Structure setPublish(BooleanDt theValue) {
            this.myPublish = theValue;
            return this;
        }

        public Structure setPublish(boolean theBoolean) {
            this.myPublish = new BooleanDt(theBoolean);
            return this;
        }

        public StringDt getPurpose() {
            if (this.myPurpose == null) {
                this.myPurpose = new StringDt();
            }
            return this.myPurpose;
        }

        public StringDt getPurposeElement() {
            if (this.myPurpose == null) {
                this.myPurpose = new StringDt();
            }
            return this.myPurpose;
        }

        public Structure setPurpose(StringDt theValue) {
            this.myPurpose = theValue;
            return this;
        }

        public Structure setPurpose(String theString) {
            this.myPurpose = new StringDt(theString);
            return this;
        }

        public List<StructureElement> getElement() {
            if (this.myElement == null) {
                this.myElement = new ArrayList<StructureElement>();
            }
            return this.myElement;
        }

        public List<StructureElement> getElementElement() {
            if (this.myElement == null) {
                this.myElement = new ArrayList<StructureElement>();
            }
            return this.myElement;
        }

        public Structure setElement(List<StructureElement> theValue) {
            this.myElement = theValue;
            return this;
        }

        public StructureElement addElement() {
            StructureElement newType = new StructureElement();
            this.getElement().add(newType);
            return newType;
        }

        public StructureElement getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                return this.addElement();
            }
            return this.getElement().get(0);
        }

        public List<StructureSearchParam> getSearchParam() {
            if (this.mySearchParam == null) {
                this.mySearchParam = new ArrayList<StructureSearchParam>();
            }
            return this.mySearchParam;
        }

        public List<StructureSearchParam> getSearchParamElement() {
            if (this.mySearchParam == null) {
                this.mySearchParam = new ArrayList<StructureSearchParam>();
            }
            return this.mySearchParam;
        }

        public Structure setSearchParam(List<StructureSearchParam> theValue) {
            this.mySearchParam = theValue;
            return this;
        }

        public StructureSearchParam addSearchParam() {
            StructureSearchParam newType = new StructureSearchParam();
            this.getSearchParam().add(newType);
            return newType;
        }

        public StructureSearchParam getSearchParamFirstRep() {
            if (this.getSearchParam().isEmpty()) {
                return this.addSearchParam();
            }
            return this.getSearchParam().get(0);
        }
    }

    @Block
    public static class Mapping
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identity", type={IdDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Internal id when this mapping is used", formalDefinition="An Internal id that is used to identify this mapping set when specific mappings are made")
        private IdDt myIdentity;
        @Child(name="uri", type={UriDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Identifies what this mapping refers to", formalDefinition="A URI that identifies the specification that this mapping is expressed to")
        private UriDt myUri;
        @Child(name="name", type={StringDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Names what this mapping refers to", formalDefinition="A name for the specification that is being mapped to")
        private StringDt myName;
        @Child(name="comments", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Versions, Issues, Scope limitations etc", formalDefinition="Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage")
        private StringDt myComments;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIdentity, this.myUri, this.myName, this.myComments});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentity, this.myUri, this.myName, this.myComments});
        }

        public IdDt getIdentity() {
            if (this.myIdentity == null) {
                this.myIdentity = new IdDt();
            }
            return this.myIdentity;
        }

        public IdDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new IdDt();
            }
            return this.myIdentity;
        }

        public Mapping setIdentity(IdDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public Mapping setIdentity(String theId) {
            this.myIdentity = new IdDt(theId);
            return this;
        }

        public UriDt getUri() {
            if (this.myUri == null) {
                this.myUri = new UriDt();
            }
            return this.myUri;
        }

        public UriDt getUriElement() {
            if (this.myUri == null) {
                this.myUri = new UriDt();
            }
            return this.myUri;
        }

        public Mapping setUri(UriDt theValue) {
            this.myUri = theValue;
            return this;
        }

        public Mapping setUri(String theUri) {
            this.myUri = new UriDt(theUri);
            return this;
        }

        public StringDt getName() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public Mapping setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Mapping setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public StringDt getComments() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public StringDt getCommentsElement() {
            if (this.myComments == null) {
                this.myComments = new StringDt();
            }
            return this.myComments;
        }

        public Mapping setComments(StringDt theValue) {
            this.myComments = theValue;
            return this;
        }

        public Mapping setComments(String theString) {
            this.myComments = new StringDt(theString);
            return this;
        }
    }
}

