/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Remittance", profile="http://hl7.org/fhir/profiles/Remittance", id="remittance")
public class Remittance
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="Remittance.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="service", path="Remittance.service.code", description="", type="token")
    public static final String SP_SERVICE = "service";
    public static final TokenClientParam SERVICE = new TokenClientParam("service");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="Remittance id", formalDefinition="The remittance identifier")
    private IdentifierDt myIdentifier;
    @Child(name="service", order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="A service paid as part of remittance", formalDefinition="A service paid as part of remittance")
    private List<Service> myService;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myService});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myService});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Remittance setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Remittance setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Remittance setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public List<Service> getService() {
        if (this.myService == null) {
            this.myService = new ArrayList<Service>();
        }
        return this.myService;
    }

    public List<Service> getServiceElement() {
        if (this.myService == null) {
            this.myService = new ArrayList<Service>();
        }
        return this.myService;
    }

    public Remittance setService(List<Service> theValue) {
        this.myService = theValue;
        return this;
    }

    public Service addService() {
        Service newType = new Service();
        this.getService().add(newType);
        return newType;
    }

    public Service getServiceFirstRep() {
        if (this.getService().isEmpty()) {
            return this.addService();
        }
        return this.getService().get(0);
    }

    public String getResourceName() {
        return "Remittance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Service
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="instance", type={IntegerDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Service instance number", formalDefinition="The service instance number for the original transaction")
        private IntegerDt myInstance;
        @Child(name="code", type={CodeableConceptDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Professional service code", formalDefinition="The code for the professional service")
        private CodeableConceptDt myCode;
        @Child(name="rate", type={DecimalDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Benefit Rate %", formalDefinition="The percent of the service fee which would be elegible for coverage")
        private DecimalDt myRate;
        @Child(name="benefit", type={DecimalDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="Benefit amount", formalDefinition="The amount payable for a submitted service (includes both professional and lab fees.)")
        private DecimalDt myBenefit;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myInstance, this.myCode, this.myRate, this.myBenefit});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myInstance, this.myCode, this.myRate, this.myBenefit});
        }

        public IntegerDt getInstance() {
            if (this.myInstance == null) {
                this.myInstance = new IntegerDt();
            }
            return this.myInstance;
        }

        public IntegerDt getInstanceElement() {
            if (this.myInstance == null) {
                this.myInstance = new IntegerDt();
            }
            return this.myInstance;
        }

        public Service setInstance(IntegerDt theValue) {
            this.myInstance = theValue;
            return this;
        }

        public Service setInstance(int theInteger) {
            this.myInstance = new IntegerDt(theInteger);
            return this;
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Service setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public DecimalDt getRate() {
            if (this.myRate == null) {
                this.myRate = new DecimalDt();
            }
            return this.myRate;
        }

        public DecimalDt getRateElement() {
            if (this.myRate == null) {
                this.myRate = new DecimalDt();
            }
            return this.myRate;
        }

        public Service setRate(DecimalDt theValue) {
            this.myRate = theValue;
            return this;
        }

        public Service setRate(long theValue) {
            this.myRate = new DecimalDt(theValue);
            return this;
        }

        public Service setRate(double theValue) {
            this.myRate = new DecimalDt(theValue);
            return this;
        }

        public Service setRate(BigDecimal theValue) {
            this.myRate = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getBenefit() {
            if (this.myBenefit == null) {
                this.myBenefit = new DecimalDt();
            }
            return this.myBenefit;
        }

        public DecimalDt getBenefitElement() {
            if (this.myBenefit == null) {
                this.myBenefit = new DecimalDt();
            }
            return this.myBenefit;
        }

        public Service setBenefit(DecimalDt theValue) {
            this.myBenefit = theValue;
            return this;
        }

        public Service setBenefit(long theValue) {
            this.myBenefit = new DecimalDt(theValue);
            return this;
        }

        public Service setBenefit(double theValue) {
            this.myBenefit = new DecimalDt(theValue);
            return this;
        }

        public Service setBenefit(BigDecimal theValue) {
            this.myBenefit = new DecimalDt(theValue);
            return this;
        }
    }
}

