/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ContactSystemEnum {
    PHONE("phone", "http://hl7.org/fhir/contact-system"),
    FAX("fax", "http://hl7.org/fhir/contact-system"),
    EMAIL("email", "http://hl7.org/fhir/contact-system"),
    URL("url", "http://hl7.org/fhir/contact-system");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/contact-system";
    public static final String VALUESET_NAME = "ContactSystem";
    private static Map<String, ContactSystemEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ContactSystemEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ContactSystemEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ContactSystemEnum forCode(String theCode) {
        ContactSystemEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ContactSystemEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ContactSystemEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ContactSystemEnum>>();
        for (ContactSystemEnum next : ContactSystemEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ContactSystemEnum>(){

            public String toCodeString(ContactSystemEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ContactSystemEnum theEnum) {
                return theEnum.getSystem();
            }

            public ContactSystemEnum fromCodeString(String theCodeString) {
                return (ContactSystemEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ContactSystemEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ContactSystemEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

