/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum MedicationDispenseStatusEnum {
    IN_PROGRESS("in progress", "http://hl7.org/fhir/medication-dispense-status"),
    ON_HOLD("on hold", "http://hl7.org/fhir/medication-dispense-status"),
    COMPLETED("completed", "http://hl7.org/fhir/medication-dispense-status"),
    ENTERED_IN_ERROR("entered in error", "http://hl7.org/fhir/medication-dispense-status"),
    STOPPED("stopped", "http://hl7.org/fhir/medication-dispense-status");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/medication-dispense-status";
    public static final String VALUESET_NAME = "MedicationDispenseStatus";
    private static Map<String, MedicationDispenseStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, MedicationDispenseStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<MedicationDispenseStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static MedicationDispenseStatusEnum forCode(String theCode) {
        MedicationDispenseStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private MedicationDispenseStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, MedicationDispenseStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, MedicationDispenseStatusEnum>>();
        for (MedicationDispenseStatusEnum next : MedicationDispenseStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<MedicationDispenseStatusEnum>(){

            public String toCodeString(MedicationDispenseStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(MedicationDispenseStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public MedicationDispenseStatusEnum fromCodeString(String theCodeString) {
                return (MedicationDispenseStatusEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public MedicationDispenseStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (MedicationDispenseStatusEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

