/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ReactionSeverityEnum {
    SEVERE("severe", "http://hl7.org/fhir/reactionSeverity"),
    SERIOUS("serious", "http://hl7.org/fhir/reactionSeverity"),
    MODERATE("moderate", "http://hl7.org/fhir/reactionSeverity"),
    MINOR("minor", "http://hl7.org/fhir/reactionSeverity");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/reactionSeverity";
    public static final String VALUESET_NAME = "ReactionSeverity";
    private static Map<String, ReactionSeverityEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ReactionSeverityEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ReactionSeverityEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ReactionSeverityEnum forCode(String theCode) {
        ReactionSeverityEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ReactionSeverityEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ReactionSeverityEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ReactionSeverityEnum>>();
        for (ReactionSeverityEnum next : ReactionSeverityEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ReactionSeverityEnum>(){

            public String toCodeString(ReactionSeverityEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ReactionSeverityEnum theEnum) {
                return theEnum.getSystem();
            }

            public ReactionSeverityEnum fromCodeString(String theCodeString) {
                return (ReactionSeverityEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ReactionSeverityEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ReactionSeverityEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

