/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum RestfulOperationSystemEnum {
    TRANSACTION("transaction", "http://hl7.org/fhir/restful-operation"),
    SEARCH_SYSTEM("search-system", "http://hl7.org/fhir/restful-operation"),
    HISTORY_SYSTEM("history-system", "http://hl7.org/fhir/restful-operation");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/system-restful-operation";
    public static final String VALUESET_NAME = "RestfulOperationSystem";
    private static Map<String, RestfulOperationSystemEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, RestfulOperationSystemEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<RestfulOperationSystemEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static RestfulOperationSystemEnum forCode(String theCode) {
        RestfulOperationSystemEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private RestfulOperationSystemEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, RestfulOperationSystemEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, RestfulOperationSystemEnum>>();
        for (RestfulOperationSystemEnum next : RestfulOperationSystemEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<RestfulOperationSystemEnum>(){

            public String toCodeString(RestfulOperationSystemEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(RestfulOperationSystemEnum theEnum) {
                return theEnum.getSystem();
            }

            public RestfulOperationSystemEnum fromCodeString(String theCodeString) {
                return (RestfulOperationSystemEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public RestfulOperationSystemEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (RestfulOperationSystemEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

