/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SecurityEventActionEnum {
    CREATE("C", "http://hl7.org/fhir/security-event-action"),
    READ_VIEW_PRINT("R", "http://hl7.org/fhir/security-event-action"),
    UPDATE("U", "http://hl7.org/fhir/security-event-action"),
    DELETE("D", "http://hl7.org/fhir/security-event-action"),
    EXECUTE("E", "http://hl7.org/fhir/security-event-action");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/security-event-action";
    public static final String VALUESET_NAME = "SecurityEventAction";
    private static Map<String, SecurityEventActionEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SecurityEventActionEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SecurityEventActionEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static SecurityEventActionEnum forCode(String theCode) {
        SecurityEventActionEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SecurityEventActionEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SecurityEventActionEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SecurityEventActionEnum>>();
        for (SecurityEventActionEnum next : SecurityEventActionEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SecurityEventActionEnum>(){

            public String toCodeString(SecurityEventActionEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SecurityEventActionEnum theEnum) {
                return theEnum.getSystem();
            }

            public SecurityEventActionEnum fromCodeString(String theCodeString) {
                return (SecurityEventActionEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SecurityEventActionEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SecurityEventActionEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

