/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum UnitsOfTimeEnum {
    S("s", "http://unitsofmeasure.org"),
    MIN("min", "http://unitsofmeasure.org"),
    H("h", "http://unitsofmeasure.org"),
    D("d", "http://unitsofmeasure.org"),
    WK("wk", "http://unitsofmeasure.org"),
    MO("mo", "http://unitsofmeasure.org"),
    A("a", "http://unitsofmeasure.org");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/units-of-time";
    public static final String VALUESET_NAME = "UnitsOfTime";
    private static Map<String, UnitsOfTimeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, UnitsOfTimeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<UnitsOfTimeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static UnitsOfTimeEnum forCode(String theCode) {
        UnitsOfTimeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private UnitsOfTimeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, UnitsOfTimeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, UnitsOfTimeEnum>>();
        for (UnitsOfTimeEnum next : UnitsOfTimeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<UnitsOfTimeEnum>(){

            public String toCodeString(UnitsOfTimeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(UnitsOfTimeEnum theEnum) {
                return theEnum.getSystem();
            }

            public UnitsOfTimeEnum fromCodeString(String theCodeString) {
                return (UnitsOfTimeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public UnitsOfTimeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (UnitsOfTimeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

