/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.audit;

import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.dstu.resource.Observation;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectTypeEnum;
import ca.uhn.fhir.rest.server.audit.IResourceAuditor;
import java.util.HashMap;
import java.util.Map;

public class ObservationAuditor
implements IResourceAuditor<Observation> {
    private Observation myResource = null;

    public Observation getResource() {
        return this.myResource;
    }

    public void setResource(Observation resource) {
        this.myResource = resource;
    }

    public boolean isAuditable() {
        return this.myResource != null;
    }

    public String getName() {
        if (this.myResource == null) {
            return null;
        }
        return "Observation:" + (String)this.myResource.getName().getCodingFirstRep().getCode().getValue();
    }

    public BaseIdentifierDt getIdentifier() {
        return this.myResource.getIdentifier();
    }

    public SecurityEventObjectTypeEnum getType() {
        return SecurityEventObjectTypeEnum.OTHER;
    }

    public String getDescription() {
        return null;
    }

    public Map<String, String> getDetail() {
        if (this.myResource == null) {
            return null;
        }
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("dateIssued", this.myResource.getIssued().getValueAsString());
        details.put("version", this.myResource.getId().getVersionIdPart());
        details.put("subject", this.myResource.getSubject().getReference().getValue());
        return details;
    }

    public BaseCodingDt getSensitivity() {
        return null;
    }
}

