/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu.resource.Profile;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ServerProfileProvider
implements IResourceProvider {
    private final FhirContext myContext;
    private final RestfulServer myRestfulServer;

    public ServerProfileProvider(RestfulServer theServer) {
        this.myContext = theServer.getFhirContext();
        this.myRestfulServer = theServer;
    }

    public Class<? extends IResource> getResourceType() {
        return Profile.class;
    }

    @Read
    public Profile getProfileById(HttpServletRequest theRequest, @IdParam IdDt theId) {
        RuntimeResourceDefinition retVal = this.myContext.getResourceDefinitionById(theId.getIdPart());
        if (retVal == null) {
            return null;
        }
        String serverBase = this.getServerBase(theRequest);
        return (Profile)retVal.toProfile(serverBase);
    }

    @Search
    public List<Profile> getAllProfiles(HttpServletRequest theRequest) {
        final String serverBase = this.getServerBase(theRequest);
        ArrayList defs = new ArrayList(this.myContext.getResourceDefinitions());
        Collections.sort(defs, new Comparator<RuntimeResourceDefinition>(){

            @Override
            public int compare(RuntimeResourceDefinition theO1, RuntimeResourceDefinition theO2) {
                int cmp = theO1.getName().compareTo(theO2.getName());
                if (cmp == 0) {
                    cmp = theO1.getResourceProfile(serverBase).compareTo(theO2.getResourceProfile(serverBase));
                }
                return cmp;
            }
        });
        ArrayList<Profile> retVal = new ArrayList<Profile>();
        for (RuntimeResourceDefinition next : defs) {
            retVal.add((Profile)next.toProfile(serverBase));
        }
        return retVal;
    }

    private String getServerBase(HttpServletRequest theHttpRequest) {
        return this.myRestfulServer.getServerBaseForRequest(theHttpRequest);
    }
}

