/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.formats;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.dstu2016may.formats.TurtleLexer;
import org.hl7.fhir.utilities.Utilities;

public class RdfGenerator {
    private List<Section> sections = new ArrayList<Section>();
    protected Set<String> subjectSet = new HashSet<String>();
    protected Set<String> predicateSet = new HashSet<String>();
    protected Set<String> objectSet = new HashSet<String>();
    private OutputStream destination;
    protected Map<String, String> prefixes = new HashMap<String, String>();

    public RdfGenerator(OutputStream destination) {
        this.destination = destination;
    }

    protected String pctEncode(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                b.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                b.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                b.append(c);
                continue;
            }
            if (c == '.') {
                b.append(c);
                continue;
            }
            b.append("%" + Integer.toHexString(c));
        }
        return b.toString();
    }

    protected List<String> sorted(Set<String> keys) {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(keys);
        Collections.sort(names);
        return names;
    }

    public void prefix(String code, String url) {
        if (!this.prefixes.containsKey(code)) {
            this.prefixes.put(code, url);
        } else if (!this.prefixes.get(code).equals(url)) {
            throw new Error("The prefix " + code + " is already assigned to " + this.prefixes.get(code) + " so cannot be set to " + url);
        }
    }

    protected boolean hasSection(String sn) {
        for (Section s : this.sections) {
            if (!s.name.equals(sn)) continue;
            return true;
        }
        return false;
    }

    public Section section(String sn) {
        if (this.hasSection(sn)) {
            throw new Error("Duplicate section name " + sn);
        }
        Section s = new Section();
        s.name = sn;
        this.sections.add(s);
        return s;
    }

    protected String matches(String url, String prefixUri, String prefix) {
        if (url.startsWith(prefixUri)) {
            this.prefixes.put(prefix, prefixUri);
            return prefix + ":" + RdfGenerator.escape(url.substring(prefixUri.length()), false);
        }
        return null;
    }

    protected Complex complex() {
        return new Complex();
    }

    private void checkPrefix(Triple object) {
        if (object instanceof StringType) {
            this.checkPrefix(((StringType)object).value);
        } else {
            Complex obj = (Complex)object;
            for (Predicate po : obj.predicates) {
                this.checkPrefix(po.getPredicate());
                this.checkPrefix(po.getObject());
            }
        }
    }

    protected void checkPrefix(String pname) {
        String prefix;
        if (pname.startsWith("(")) {
            return;
        }
        if (pname.startsWith("\"")) {
            return;
        }
        if (pname.startsWith("<")) {
            return;
        }
        if (pname.contains(":") && !this.prefixes.containsKey(prefix = pname.substring(0, pname.indexOf(":"))) && !prefix.equals("http") && !prefix.equals("urn")) {
            throw new Error("undefined prefix " + prefix);
        }
    }

    protected StringType literal(String s) {
        return new StringType("\"" + RdfGenerator.escape(s, true) + "\"");
    }

    public static String escape(String s, boolean string) {
        if (s == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == '\r') {
                b.append("\\r");
                continue;
            }
            if (c == '\n') {
                b.append("\\n");
                continue;
            }
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c == '/' && !string) {
                b.append("\\/");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public void commit(boolean header) throws Exception {
        LineOutputStreamWriter writer = new LineOutputStreamWriter(this.destination);
        this.commitPrefixes(writer, header);
        for (Section s : this.sections) {
            this.commitSection(writer, s);
        }
        writer.ln("# -------------------------------------------------------------------------------------");
        writer.ln();
        writer.flush();
        writer.close();
    }

    private void commitPrefixes(LineOutputStreamWriter writer, boolean header) throws Exception {
        if (header) {
            writer.ln("# FHIR Sub-definitions");
            writer.write("# This is work in progress, and may change rapidly \r\n");
            writer.ln();
            writer.write("# A note about policy: the focus here is providing the knowledge from \r\n");
            writer.write("# the FHIR specification as a set of triples for knowledge processing. \r\n");
            writer.write("# Where appopriate, predicates defined external to FHIR are used. \"Where \r\n");
            writer.write("# appropriate\" means that the predicates are a faithful representation \r\n");
            writer.write("# of the FHIR semantics, and do not involve insane (or owful) syntax. \r\n");
            writer.ln();
            writer.write("# Where the community agrees on additional predicate statements (such \r\n");
            writer.write("# as OWL constraints) these are added in addition to the direct FHIR \r\n");
            writer.write("# predicates \r\n");
            writer.ln();
            writer.write("# This it not a formal ontology, though it is possible it may start to become one eventually\r\n");
            writer.ln();
            writer.write("# this file refers to concepts defined in rim.ttl and to others defined elsewhere outside HL7 \r\n");
            writer.ln();
        }
        for (String p : this.sorted(this.prefixes.keySet())) {
            writer.ln("@prefix " + p + ": <" + this.prefixes.get(p) + "> .");
        }
        writer.ln();
        if (header) {
            writer.ln("# Predicates used in this file:");
            for (String s : this.sorted(this.predicateSet)) {
                writer.ln(" # " + s);
            }
            writer.ln();
        }
    }

    private void commitSection(LineOutputStreamWriter writer, Section section) throws Exception {
        writer.ln("# - " + section.name + " " + Utilities.padLeft((String)"", (char)'-', (int)(75 - section.name.length())));
        writer.ln();
        for (Subject sbj : section.subjects) {
            writer.write(sbj.id);
            writer.write(" ");
            int i = 0;
            for (Predicate p : sbj.predicates) {
                String comment;
                writer.write(p.getPredicate());
                writer.write(" ");
                if (p.getObject() instanceof StringType) {
                    writer.write(((StringType)p.getObject()).value);
                } else {
                    writer.write("[");
                    if (((Complex)p.getObject()).write(writer, 4)) {
                        writer.write("\r\n  ]");
                    } else {
                        writer.write("]");
                    }
                }
                String string = comment = p.comment == null ? "" : " # " + p.comment;
                if (++i < sbj.predicates.size()) {
                    writer.write(";" + comment + "\r\n  ");
                    continue;
                }
                writer.write("." + comment + "\r\n\r\n");
            }
        }
    }

    protected class LineOutputStreamWriter
    extends OutputStreamWriter {
        private LineOutputStreamWriter(OutputStream out) throws UnsupportedEncodingException {
            super(out, "UTF-8");
        }

        private void ln() throws Exception {
            this.write("\r\n");
        }

        private void ln(String s) throws Exception {
            this.write(s);
            this.write("\r\n");
        }
    }

    public class Section {
        private String name;
        private List<Subject> subjects = new ArrayList<Subject>();

        public Subject triple(String subject, String predicate, String object, String comment) {
            return this.triple(subject, predicate, new StringType(object), comment);
        }

        public Subject triple(String subject, String predicate, String object) {
            return this.triple(subject, predicate, new StringType(object));
        }

        public Subject triple(String subject, String predicate, Triple object) {
            return this.triple(subject, predicate, object, null);
        }

        public Subject triple(String subject, String predicate, Triple object, String comment) {
            Subject s = this.subject(subject);
            s.predicate(predicate, object, comment);
            return s;
        }

        public void comment(String subject, String comment) {
            this.triple(subject, "rdfs:comment", RdfGenerator.this.literal(comment));
            this.triple(subject, "dcterms:description", RdfGenerator.this.literal(comment));
        }

        public void label(String subject, String comment) {
            this.triple(subject, "rdfs:label", RdfGenerator.this.literal(comment));
            this.triple(subject, "dc:title", RdfGenerator.this.literal(comment));
        }

        public void importTtl(String ttl) throws Exception {
            if (!Utilities.noString((String)ttl)) {
                TurtleLexer lexer = new TurtleLexer(ttl);
                String subject = null;
                String predicate = null;
                while (!lexer.done()) {
                    if (subject == null) {
                        subject = lexer.next();
                    }
                    if (predicate == null) {
                        predicate = lexer.next();
                    }
                    if (lexer.peekType() == null) {
                        throw new Error("Unexpected end of input parsing turtle");
                    }
                    if (lexer.peekType() == TurtleLexer.TurtleTokenType.TOKEN) {
                        this.triple(subject, predicate, lexer.next());
                    } else {
                        if (lexer.peek() == null) {
                            throw new Error("Unexected - turtle lexer found no token");
                        }
                        if (lexer.peek().equals("[")) {
                            this.triple(subject, predicate, this.importComplex(lexer));
                        } else {
                            throw new Exception("Not done yet");
                        }
                    }
                    String n = lexer.next();
                    if (Utilities.noString((String)n)) break;
                    if (n.equals(".")) {
                        subject = null;
                        predicate = null;
                        continue;
                    }
                    if (n.equals(";")) {
                        predicate = null;
                        continue;
                    }
                    if (n.equals(",")) continue;
                    throw new Exception("Unexpected token " + n);
                }
            }
        }

        private Complex importComplex(TurtleLexer lexer) throws Exception {
            lexer.next();
            Complex obj = new Complex();
            while (!lexer.peek().equals("]")) {
                String predicate = lexer.next();
                if (lexer.peekType() == TurtleLexer.TurtleTokenType.TOKEN || lexer.peekType() == TurtleLexer.TurtleTokenType.LITERAL) {
                    obj.predicate(predicate, lexer.next());
                } else if (lexer.peek().equals("[")) {
                    obj.predicate(predicate, this.importComplex(lexer));
                } else {
                    throw new Exception("Not done yet");
                }
                if (!lexer.peek().equals(";")) continue;
                lexer.next();
            }
            lexer.next();
            return obj;
        }

        public Subject subject(String subject) {
            for (Subject ss : this.subjects) {
                if (!ss.id.equals(subject)) continue;
                return ss;
            }
            Subject s = new Subject();
            s.id = subject;
            this.subjects.add(s);
            return s;
        }
    }

    public class Subject
    extends Complex {
        private String id;

        public Predicate predicate(String predicate, Triple object, String comment) {
            Predicate p = new Predicate();
            p.predicate = predicate;
            RdfGenerator.this.predicateSet.add(predicate);
            if (object instanceof StringType) {
                RdfGenerator.this.objectSet.add(((StringType)object).value);
            }
            p.object = object;
            this.predicates.add(p);
            p.comment = comment;
            return p;
        }

        public void comment(String comment) {
            if (!Utilities.noString((String)comment)) {
                this.predicate("rdfs:comment", RdfGenerator.this.literal(comment));
                this.predicate("dcterms:description", RdfGenerator.this.literal(comment));
            }
        }

        public void label(String label) {
            if (!Utilities.noString((String)label)) {
                this.predicate("rdfs:label", RdfGenerator.this.literal(label));
                this.predicate("dc:title", RdfGenerator.this.literal(label));
            }
        }
    }

    private class Predicate {
        protected String predicate;
        protected Triple object;
        protected String comment;

        private Predicate() {
        }

        public String getPredicate() {
            return this.predicate;
        }

        public Triple getObject() {
            return this.object;
        }

        public String getComment() {
            return this.comment;
        }
    }

    public class Complex
    extends Triple {
        protected List<Predicate> predicates;

        public Complex() {
            this.predicates = new ArrayList<Predicate>();
        }

        public boolean write(LineOutputStreamWriter writer, int indent) throws Exception {
            if (this.predicates.isEmpty()) {
                return false;
            }
            if (this.predicates.size() == 1 && this.predicates.get((int)0).object instanceof StringType && Utilities.noString((String)this.predicates.get((int)0).comment)) {
                writer.write(" " + this.predicates.get((int)0).predicate + " " + ((StringType)this.predicates.get((int)0).object).value);
                return false;
            }
            String left = Utilities.padLeft((String)"", (char)' ', (int)indent);
            int i = 0;
            for (Predicate po : this.predicates) {
                writer.write("\r\n");
                if (po.getObject() instanceof StringType) {
                    writer.write(left + " " + po.getPredicate() + " " + ((StringType)po.getObject()).value);
                } else {
                    writer.write(left + " " + po.getPredicate() + " [");
                    if (((Complex)po.getObject()).write(writer, indent + 2)) {
                        writer.write(left + " ]");
                    } else {
                        writer.write(" ]");
                    }
                }
                if (++i < this.predicates.size()) {
                    writer.write(";");
                }
                if (Utilities.noString((String)po.comment)) continue;
                writer.write(" # " + RdfGenerator.escape(po.comment, false));
            }
            return true;
        }

        public Complex predicate(String predicate, String object) {
            RdfGenerator.this.predicateSet.add(predicate);
            RdfGenerator.this.objectSet.add(object);
            return this.predicate(predicate, new StringType(object));
        }

        public Complex predicate(String predicate, Triple object) {
            Predicate p = new Predicate();
            p.predicate = predicate;
            RdfGenerator.this.predicateSet.add(predicate);
            if (object instanceof StringType) {
                RdfGenerator.this.objectSet.add(((StringType)object).value);
            }
            p.object = object;
            this.predicates.add(p);
            return this;
        }

        public Complex predicate(String predicate) {
            RdfGenerator.this.predicateSet.add(predicate);
            Complex c = RdfGenerator.this.complex();
            this.predicate(predicate, c);
            return c;
        }

        public void prefix(String code, String url) {
            RdfGenerator.this.prefix(code, url);
        }
    }

    public class StringType
    extends Triple {
        private String value;

        public StringType(String value) {
            this.value = value;
        }
    }

    public abstract class Triple {
        private String uri;
    }
}

