/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.BodySite;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="DeviceUseStatement", profile="http://hl7.org/fhir/Profile/DeviceUseStatement")
public class DeviceUseStatement
extends DomainResource {
    @Child(name="bodySite", type={CodeableConcept.class, BodySite.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Target body site", formalDefinition="Indicates the site on the subject's body where the device was used ( i.e. the target site).")
    protected Type bodySite;
    @Child(name="whenUsed", type={Period.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="The time period over which the device was used.")
    protected Period whenUsed;
    @Child(name="device", type={Device.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="The details of the device used.")
    protected Reference device;
    protected Device deviceTarget;
    @Child(name="identifier", type={Identifier.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="An external identifier for this statement such as an IRI.")
    protected List<Identifier> identifier;
    @Child(name="indication", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="Reason or justification for the use of the device.")
    protected List<CodeableConcept> indication;
    @Child(name="notes", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.")
    protected List<StringType> notes;
    @Child(name="recordedOn", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="The time at which the statement was made/recorded.")
    protected DateTimeType recordedOn;
    @Child(name="subject", type={Patient.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="The patient who used the device.")
    protected Reference subject;
    protected Patient subjectTarget;
    @Child(name="timing", type={Timing.class, Period.class, DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="", formalDefinition="How often the device was used.")
    protected Type timing;
    private static final long serialVersionUID = -1668571635L;
    @SearchParamDefinition(name="patient", path="DeviceUseStatement.subject", description="Search by subject - a patient", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DeviceUseStatement:patient").toLocked();
    @SearchParamDefinition(name="subject", path="DeviceUseStatement.subject", description="Search by subject", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DeviceUseStatement:subject").toLocked();
    @SearchParamDefinition(name="device", path="DeviceUseStatement.device", description="Search by device", type="reference")
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("DeviceUseStatement:device").toLocked();

    public DeviceUseStatement() {
    }

    public DeviceUseStatement(Reference device, Reference subject) {
        this.device = device;
        this.subject = subject;
    }

    public Type getBodySite() {
        return this.bodySite;
    }

    public CodeableConcept getBodySiteCodeableConcept() throws FHIRException {
        if (!(this.bodySite instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.bodySite.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.bodySite;
    }

    public boolean hasBodySiteCodeableConcept() {
        return this.bodySite instanceof CodeableConcept;
    }

    public Reference getBodySiteReference() throws FHIRException {
        if (!(this.bodySite instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.bodySite.getClass().getName() + " was encountered");
        }
        return (Reference)this.bodySite;
    }

    public boolean hasBodySiteReference() {
        return this.bodySite instanceof Reference;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public DeviceUseStatement setBodySite(Type value) {
        this.bodySite = value;
        return this;
    }

    public Period getWhenUsed() {
        if (this.whenUsed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.whenUsed");
            }
            if (Configuration.doAutoCreate()) {
                this.whenUsed = new Period();
            }
        }
        return this.whenUsed;
    }

    public boolean hasWhenUsed() {
        return this.whenUsed != null && !this.whenUsed.isEmpty();
    }

    public DeviceUseStatement setWhenUsed(Period value) {
        this.whenUsed = value;
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public DeviceUseStatement setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Device getDeviceTarget() {
        if (this.deviceTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.device");
            }
            if (Configuration.doAutoCreate()) {
                this.deviceTarget = new Device();
            }
        }
        return this.deviceTarget;
    }

    public DeviceUseStatement setDeviceTarget(Device value) {
        this.deviceTarget = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceUseStatement addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public List<CodeableConcept> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        return this.indication;
    }

    public boolean hasIndication() {
        if (this.indication == null) {
            return false;
        }
        for (CodeableConcept item : this.indication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIndication() {
        CodeableConcept t = new CodeableConcept();
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        this.indication.add(t);
        return t;
    }

    public DeviceUseStatement addIndication(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        this.indication.add(t);
        return this;
    }

    public List<StringType> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<StringType>();
        }
        return this.notes;
    }

    public boolean hasNotes() {
        if (this.notes == null) {
            return false;
        }
        for (StringType item : this.notes) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addNotesElement() {
        StringType t = new StringType();
        if (this.notes == null) {
            this.notes = new ArrayList<StringType>();
        }
        this.notes.add(t);
        return t;
    }

    public DeviceUseStatement addNotes(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.notes == null) {
            this.notes = new ArrayList<StringType>();
        }
        this.notes.add(t);
        return this;
    }

    public boolean hasNotes(String value) {
        if (this.notes == null) {
            return false;
        }
        for (StringType v : this.notes) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public DateTimeType getRecordedOnElement() {
        if (this.recordedOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.recordedOn");
            }
            if (Configuration.doAutoCreate()) {
                this.recordedOn = new DateTimeType();
            }
        }
        return this.recordedOn;
    }

    public boolean hasRecordedOnElement() {
        return this.recordedOn != null && !this.recordedOn.isEmpty();
    }

    public boolean hasRecordedOn() {
        return this.recordedOn != null && !this.recordedOn.isEmpty();
    }

    public DeviceUseStatement setRecordedOnElement(DateTimeType value) {
        this.recordedOn = value;
        return this;
    }

    public Date getRecordedOn() {
        return this.recordedOn == null ? null : (Date)this.recordedOn.getValue();
    }

    public DeviceUseStatement setRecordedOn(Date value) {
        if (value == null) {
            this.recordedOn = null;
        } else {
            if (this.recordedOn == null) {
                this.recordedOn = new DateTimeType();
            }
            this.recordedOn.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DeviceUseStatement setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Patient getSubjectTarget() {
        if (this.subjectTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseStatement.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subjectTarget = new Patient();
            }
        }
        return this.subjectTarget;
    }

    public DeviceUseStatement setSubjectTarget(Patient value) {
        this.subjectTarget = value;
        return this;
    }

    public Type getTiming() {
        return this.timing;
    }

    public Timing getTimingTiming() throws FHIRException {
        if (!(this.timing instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Timing)this.timing;
    }

    public boolean hasTimingTiming() {
        return this.timing instanceof Timing;
    }

    public Period getTimingPeriod() throws FHIRException {
        if (!(this.timing instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Period)this.timing;
    }

    public boolean hasTimingPeriod() {
        return this.timing instanceof Period;
    }

    public DateTimeType getTimingDateTimeType() throws FHIRException {
        if (!(this.timing instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.timing;
    }

    public boolean hasTimingDateTimeType() {
        return this.timing instanceof DateTimeType;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public DeviceUseStatement setTiming(Type value) {
        this.timing = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("bodySite[x]", "CodeableConcept|Reference(BodySite)", "Indicates the site on the subject's body where the device was used ( i.e. the target site).", 0, Integer.MAX_VALUE, this.bodySite));
        childrenList.add(new Property("whenUsed", "Period", "The time period over which the device was used.", 0, Integer.MAX_VALUE, this.whenUsed));
        childrenList.add(new Property(SP_DEVICE, "Reference(Device)", "The details of the device used.", 0, Integer.MAX_VALUE, this.device));
        childrenList.add(new Property("identifier", "Identifier", "An external identifier for this statement such as an IRI.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("indication", "CodeableConcept", "Reason or justification for the use of the device.", 0, Integer.MAX_VALUE, this.indication));
        childrenList.add(new Property("notes", "string", "Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.notes));
        childrenList.add(new Property("recordedOn", "dateTime", "The time at which the statement was made/recorded.", 0, Integer.MAX_VALUE, this.recordedOn));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient)", "The patient who used the device.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("timing[x]", "Timing|Period|dateTime", "How often the device was used.", 0, Integer.MAX_VALUE, this.timing));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.bodySite;
                }
                return baseArray;
            }
            case 2042879511: {
                Base[] baseArray;
                if (this.whenUsed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.whenUsed;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.device;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -597168804: {
                return this.indication == null ? new Base[]{} : this.indication.toArray(new Base[this.indication.size()]);
            }
            case 105008833: {
                return this.notes == null ? new Base[]{} : this.notes.toArray(new Base[this.notes.size()]);
            }
            case 735397551: {
                Base[] baseArray;
                if (this.recordedOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.recordedOn;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.timing;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1702620169: {
                this.bodySite = (Type)value;
                break;
            }
            case 2042879511: {
                this.whenUsed = this.castToPeriod(value);
                break;
            }
            case -1335157162: {
                this.device = this.castToReference(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -597168804: {
                this.getIndication().add(this.castToCodeableConcept(value));
                break;
            }
            case 105008833: {
                this.getNotes().add(this.castToString(value));
                break;
            }
            case 735397551: {
                this.recordedOn = this.castToDateTime(value);
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case -873664438: {
                this.timing = (Type)value;
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("bodySite[x]")) {
            this.bodySite = (Type)value;
        } else if (name.equals("whenUsed")) {
            this.whenUsed = this.castToPeriod(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = this.castToReference(value);
        } else if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("indication")) {
            this.getIndication().add(this.castToCodeableConcept(value));
        } else if (name.equals("notes")) {
            this.getNotes().add(this.castToString(value));
        } else if (name.equals("recordedOn")) {
            this.recordedOn = this.castToDateTime(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("timing[x]")) {
            this.timing = (Type)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -806219817: {
                return this.getBodySite();
            }
            case 2042879511: {
                return this.getWhenUsed();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -597168804: {
                return this.addIndication();
            }
            case 105008833: {
                throw new FHIRException("Cannot make property notes as it is not a complex type");
            }
            case 735397551: {
                throw new FHIRException("Cannot make property recordedOn as it is not a complex type");
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 164632566: {
                return this.getTiming();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("bodySiteCodeableConcept")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals("bodySiteReference")) {
            this.bodySite = new Reference();
            return this.bodySite;
        }
        if (name.equals("whenUsed")) {
            this.whenUsed = new Period();
            return this.whenUsed;
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("indication")) {
            return this.addIndication();
        }
        if (name.equals("notes")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceUseStatement.notes");
        }
        if (name.equals("recordedOn")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceUseStatement.recordedOn");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("timingTiming")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("timingPeriod")) {
            this.timing = new Period();
            return this.timing;
        }
        if (name.equals("timingDateTime")) {
            this.timing = new DateTimeType();
            return this.timing;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceUseStatement";
    }

    @Override
    public DeviceUseStatement copy() {
        DeviceUseStatement dst = new DeviceUseStatement();
        this.copyValues(dst);
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.whenUsed = this.whenUsed == null ? null : this.whenUsed.copy();
        Reference reference = dst.device = this.device == null ? null : this.device.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.indication != null) {
            dst.indication = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.indication) {
                dst.indication.add(codeableConcept.copy());
            }
        }
        if (this.notes != null) {
            dst.notes = new ArrayList<StringType>();
            for (StringType stringType : this.notes) {
                dst.notes.add(stringType.copy());
            }
        }
        dst.recordedOn = this.recordedOn == null ? null : this.recordedOn.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        return dst;
    }

    protected DeviceUseStatement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DeviceUseStatement)) {
            return false;
        }
        DeviceUseStatement o = (DeviceUseStatement)other;
        return DeviceUseStatement.compareDeep(this.bodySite, o.bodySite, true) && DeviceUseStatement.compareDeep(this.whenUsed, o.whenUsed, true) && DeviceUseStatement.compareDeep(this.device, o.device, true) && DeviceUseStatement.compareDeep(this.identifier, o.identifier, true) && DeviceUseStatement.compareDeep(this.indication, o.indication, true) && DeviceUseStatement.compareDeep(this.notes, o.notes, true) && DeviceUseStatement.compareDeep(this.recordedOn, o.recordedOn, true) && DeviceUseStatement.compareDeep(this.subject, o.subject, true) && DeviceUseStatement.compareDeep(this.timing, o.timing, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DeviceUseStatement)) {
            return false;
        }
        DeviceUseStatement o = (DeviceUseStatement)other;
        return DeviceUseStatement.compareValues(this.notes, o.notes, true) && DeviceUseStatement.compareValues(this.recordedOn, o.recordedOn, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.whenUsed != null && !this.whenUsed.isEmpty() || this.device != null && !this.device.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.indication != null && !this.indication.isEmpty() || this.notes != null && !this.notes.isEmpty() || this.recordedOn != null && !this.recordedOn.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.timing != null && !this.timing.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceUseStatement;
    }
}

