/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Coverage;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EligibilityRequest", profile="http://hl7.org/fhir/Profile/EligibilityRequest")
public class EligibilityRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="ruleset", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when this resource was created.")
    protected DateTimeType created;
    @Child(name="target", type={Identifier.class, Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer", formalDefinition="The Insurer who is target  of the request.")
    protected Type target;
    @Child(name="provider", type={Identifier.class, Practitioner.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Type provider;
    @Child(name="organization", type={Identifier.class, Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Type organization;
    @Child(name="priority", type={Coding.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Desired processing priority", formalDefinition="Immediate (STAT), best effort (NORMAL), deferred (DEFER).")
    protected Coding priority;
    @Child(name="enterer", type={Identifier.class, Practitioner.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Author", formalDefinition="Person who created the invoice/claim/pre-determination or pre-authorization.")
    protected Type enterer;
    @Child(name="facility", type={Identifier.class, Location.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Servicing Facility", formalDefinition="Facility where the services were provided.")
    protected Type facility;
    @Child(name="patient", type={Identifier.class, Patient.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the Products and Services", formalDefinition="Patient Resource.")
    protected Type patient;
    @Child(name="coverage", type={Identifier.class, Coverage.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected Type coverage;
    @Child(name="businessArrangement", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business agreement", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
    protected StringType businessArrangement;
    @Child(name="serviced", type={DateType.class, Period.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Estimated date or dates of Service", formalDefinition="The date or dates when the enclosed suite of services were performed or completed.")
    protected Type serviced;
    @Child(name="benefitCategory", type={Coding.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Benefit Category", formalDefinition="Dental, Vision, Medical, Pharmacy, Rehab etc.")
    protected Coding benefitCategory;
    @Child(name="benefitSubCategory", type={Coding.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Benefit SubCategory", formalDefinition="Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.")
    protected Coding benefitSubCategory;
    private static final long serialVersionUID = 313969968L;
    @SearchParamDefinition(name="patientidentifier", path="EligibilityRequest.patient.as(Identifier)", description="The reference to the patient", type="token")
    public static final String SP_PATIENTIDENTIFIER = "patientidentifier";
    public static final TokenClientParam PATIENTIDENTIFIER = new TokenClientParam("patientidentifier");
    @SearchParamDefinition(name="created", path="EligibilityRequest.created", description="The creation date for the EOB", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="facilityidentifier", path="EligibilityRequest.facility.as(identifier)", description="Facility responsible for the goods and services", type="token")
    public static final String SP_FACILITYIDENTIFIER = "facilityidentifier";
    public static final TokenClientParam FACILITYIDENTIFIER = new TokenClientParam("facilityidentifier");
    @SearchParamDefinition(name="facilityreference", path="EligibilityRequest.facility.as(Reference)", description="Facility responsible for the goods and services", type="reference")
    public static final String SP_FACILITYREFERENCE = "facilityreference";
    public static final ReferenceClientParam FACILITYREFERENCE = new ReferenceClientParam("facilityreference");
    public static final Include INCLUDE_FACILITYREFERENCE = new Include("EligibilityRequest:facilityreference").toLocked();
    @SearchParamDefinition(name="providerreference", path="EligibilityRequest.provider.as(Reference)", description="The reference to the provider", type="reference")
    public static final String SP_PROVIDERREFERENCE = "providerreference";
    public static final ReferenceClientParam PROVIDERREFERENCE = new ReferenceClientParam("providerreference");
    public static final Include INCLUDE_PROVIDERREFERENCE = new Include("EligibilityRequest:providerreference").toLocked();
    @SearchParamDefinition(name="organizationidentifier", path="EligibilityRequest.organization.as(identifier)", description="The reference to the providing organization", type="token")
    public static final String SP_ORGANIZATIONIDENTIFIER = "organizationidentifier";
    public static final TokenClientParam ORGANIZATIONIDENTIFIER = new TokenClientParam("organizationidentifier");
    @SearchParamDefinition(name="organizationreference", path="EligibilityRequest.organization.as(Reference)", description="The reference to the providing organization", type="reference")
    public static final String SP_ORGANIZATIONREFERENCE = "organizationreference";
    public static final ReferenceClientParam ORGANIZATIONREFERENCE = new ReferenceClientParam("organizationreference");
    public static final Include INCLUDE_ORGANIZATIONREFERENCE = new Include("EligibilityRequest:organizationreference").toLocked();
    @SearchParamDefinition(name="patientreference", path="EligibilityRequest.patient.as(Reference)", description="The reference to the patient", type="reference")
    public static final String SP_PATIENTREFERENCE = "patientreference";
    public static final ReferenceClientParam PATIENTREFERENCE = new ReferenceClientParam("patientreference");
    public static final Include INCLUDE_PATIENTREFERENCE = new Include("EligibilityRequest:patientreference").toLocked();
    @SearchParamDefinition(name="identifier", path="EligibilityRequest.identifier", description="The business identifier of the Eligibility", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="provideridentifier", path="EligibilityRequest.provider.as(identifier)", description="The reference to the provider", type="token")
    public static final String SP_PROVIDERIDENTIFIER = "provideridentifier";
    public static final TokenClientParam PROVIDERIDENTIFIER = new TokenClientParam("provideridentifier");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EligibilityRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public EligibilityRequest setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public EligibilityRequest setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public EligibilityRequest setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public EligibilityRequest setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Type getTarget() {
        return this.target;
    }

    public Identifier getTargetIdentifier() throws FHIRException {
        if (!(this.target instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (Identifier)this.target;
    }

    public boolean hasTargetIdentifier() {
        return this.target instanceof Identifier;
    }

    public Reference getTargetReference() throws FHIRException {
        if (!(this.target instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (Reference)this.target;
    }

    public boolean hasTargetReference() {
        return this.target instanceof Reference;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public EligibilityRequest setTarget(Type value) {
        this.target = value;
        return this;
    }

    public Type getProvider() {
        return this.provider;
    }

    public Identifier getProviderIdentifier() throws FHIRException {
        if (!(this.provider instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.provider.getClass().getName() + " was encountered");
        }
        return (Identifier)this.provider;
    }

    public boolean hasProviderIdentifier() {
        return this.provider instanceof Identifier;
    }

    public Reference getProviderReference() throws FHIRException {
        if (!(this.provider instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.provider.getClass().getName() + " was encountered");
        }
        return (Reference)this.provider;
    }

    public boolean hasProviderReference() {
        return this.provider instanceof Reference;
    }

    public boolean hasProvider() {
        return this.provider != null && !this.provider.isEmpty();
    }

    public EligibilityRequest setProvider(Type value) {
        this.provider = value;
        return this;
    }

    public Type getOrganization() {
        return this.organization;
    }

    public Identifier getOrganizationIdentifier() throws FHIRException {
        if (!(this.organization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.organization;
    }

    public boolean hasOrganizationIdentifier() {
        return this.organization instanceof Identifier;
    }

    public Reference getOrganizationReference() throws FHIRException {
        if (!(this.organization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Reference)this.organization;
    }

    public boolean hasOrganizationReference() {
        return this.organization instanceof Reference;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public EligibilityRequest setOrganization(Type value) {
        this.organization = value;
        return this;
    }

    public Coding getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Coding();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public EligibilityRequest setPriority(Coding value) {
        this.priority = value;
        return this;
    }

    public Type getEnterer() {
        return this.enterer;
    }

    public Identifier getEntererIdentifier() throws FHIRException {
        if (!(this.enterer instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.enterer.getClass().getName() + " was encountered");
        }
        return (Identifier)this.enterer;
    }

    public boolean hasEntererIdentifier() {
        return this.enterer instanceof Identifier;
    }

    public Reference getEntererReference() throws FHIRException {
        if (!(this.enterer instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.enterer.getClass().getName() + " was encountered");
        }
        return (Reference)this.enterer;
    }

    public boolean hasEntererReference() {
        return this.enterer instanceof Reference;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public EligibilityRequest setEnterer(Type value) {
        this.enterer = value;
        return this;
    }

    public Type getFacility() {
        return this.facility;
    }

    public Identifier getFacilityIdentifier() throws FHIRException {
        if (!(this.facility instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.facility.getClass().getName() + " was encountered");
        }
        return (Identifier)this.facility;
    }

    public boolean hasFacilityIdentifier() {
        return this.facility instanceof Identifier;
    }

    public Reference getFacilityReference() throws FHIRException {
        if (!(this.facility instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.facility.getClass().getName() + " was encountered");
        }
        return (Reference)this.facility;
    }

    public boolean hasFacilityReference() {
        return this.facility instanceof Reference;
    }

    public boolean hasFacility() {
        return this.facility != null && !this.facility.isEmpty();
    }

    public EligibilityRequest setFacility(Type value) {
        this.facility = value;
        return this;
    }

    public Type getPatient() {
        return this.patient;
    }

    public Identifier getPatientIdentifier() throws FHIRException {
        if (!(this.patient instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.patient.getClass().getName() + " was encountered");
        }
        return (Identifier)this.patient;
    }

    public boolean hasPatientIdentifier() {
        return this.patient instanceof Identifier;
    }

    public Reference getPatientReference() throws FHIRException {
        if (!(this.patient instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.patient.getClass().getName() + " was encountered");
        }
        return (Reference)this.patient;
    }

    public boolean hasPatientReference() {
        return this.patient instanceof Reference;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public EligibilityRequest setPatient(Type value) {
        this.patient = value;
        return this;
    }

    public Type getCoverage() {
        return this.coverage;
    }

    public Identifier getCoverageIdentifier() throws FHIRException {
        if (!(this.coverage instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.coverage.getClass().getName() + " was encountered");
        }
        return (Identifier)this.coverage;
    }

    public boolean hasCoverageIdentifier() {
        return this.coverage instanceof Identifier;
    }

    public Reference getCoverageReference() throws FHIRException {
        if (!(this.coverage instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.coverage.getClass().getName() + " was encountered");
        }
        return (Reference)this.coverage;
    }

    public boolean hasCoverageReference() {
        return this.coverage instanceof Reference;
    }

    public boolean hasCoverage() {
        return this.coverage != null && !this.coverage.isEmpty();
    }

    public EligibilityRequest setCoverage(Type value) {
        this.coverage = value;
        return this;
    }

    public StringType getBusinessArrangementElement() {
        if (this.businessArrangement == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.businessArrangement");
            }
            if (Configuration.doAutoCreate()) {
                this.businessArrangement = new StringType();
            }
        }
        return this.businessArrangement;
    }

    public boolean hasBusinessArrangementElement() {
        return this.businessArrangement != null && !this.businessArrangement.isEmpty();
    }

    public boolean hasBusinessArrangement() {
        return this.businessArrangement != null && !this.businessArrangement.isEmpty();
    }

    public EligibilityRequest setBusinessArrangementElement(StringType value) {
        this.businessArrangement = value;
        return this;
    }

    public String getBusinessArrangement() {
        return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
    }

    public EligibilityRequest setBusinessArrangement(String value) {
        if (Utilities.noString((String)value)) {
            this.businessArrangement = null;
        } else {
            if (this.businessArrangement == null) {
                this.businessArrangement = new StringType();
            }
            this.businessArrangement.setValue(value);
        }
        return this;
    }

    public Type getServiced() {
        return this.serviced;
    }

    public DateType getServicedDateType() throws FHIRException {
        if (!(this.serviced instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.serviced.getClass().getName() + " was encountered");
        }
        return (DateType)this.serviced;
    }

    public boolean hasServicedDateType() {
        return this.serviced instanceof DateType;
    }

    public Period getServicedPeriod() throws FHIRException {
        if (!(this.serviced instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.serviced.getClass().getName() + " was encountered");
        }
        return (Period)this.serviced;
    }

    public boolean hasServicedPeriod() {
        return this.serviced instanceof Period;
    }

    public boolean hasServiced() {
        return this.serviced != null && !this.serviced.isEmpty();
    }

    public EligibilityRequest setServiced(Type value) {
        this.serviced = value;
        return this;
    }

    public Coding getBenefitCategory() {
        if (this.benefitCategory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.benefitCategory");
            }
            if (Configuration.doAutoCreate()) {
                this.benefitCategory = new Coding();
            }
        }
        return this.benefitCategory;
    }

    public boolean hasBenefitCategory() {
        return this.benefitCategory != null && !this.benefitCategory.isEmpty();
    }

    public EligibilityRequest setBenefitCategory(Coding value) {
        this.benefitCategory = value;
        return this;
    }

    public Coding getBenefitSubCategory() {
        if (this.benefitSubCategory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EligibilityRequest.benefitSubCategory");
            }
            if (Configuration.doAutoCreate()) {
                this.benefitSubCategory = new Coding();
            }
        }
        return this.benefitSubCategory;
    }

    public boolean hasBenefitSubCategory() {
        return this.benefitSubCategory != null && !this.benefitSubCategory.isEmpty();
    }

    public EligibilityRequest setBenefitSubCategory(Coding value) {
        this.benefitSubCategory = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property(SP_CREATED, "dateTime", "The date when this resource was created.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("target[x]", "Identifier|Reference(Organization)", "The Insurer who is target  of the request.", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property("provider[x]", "Identifier|Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.provider));
        childrenList.add(new Property("organization[x]", "Identifier|Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("priority", "Coding", "Immediate (STAT), best effort (NORMAL), deferred (DEFER).", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property("enterer[x]", "Identifier|Reference(Practitioner)", "Person who created the invoice/claim/pre-determination or pre-authorization.", 0, Integer.MAX_VALUE, this.enterer));
        childrenList.add(new Property("facility[x]", "Identifier|Reference(Location)", "Facility where the services were provided.", 0, Integer.MAX_VALUE, this.facility));
        childrenList.add(new Property("patient[x]", "Identifier|Reference(Patient)", "Patient Resource.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("coverage[x]", "Identifier|Reference(Coverage)", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.coverage));
        childrenList.add(new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, Integer.MAX_VALUE, this.businessArrangement));
        childrenList.add(new Property("serviced[x]", "date|Period", "The date or dates when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.serviced));
        childrenList.add(new Property("benefitCategory", "Coding", "Dental, Vision, Medical, Pharmacy, Rehab etc.", 0, Integer.MAX_VALUE, this.benefitCategory));
        childrenList.add(new Property("benefitSubCategory", "Coding", "Dental: basic, major, ortho; Vision exam, glasses, contacts; etc.", 0, Integer.MAX_VALUE, this.benefitSubCategory));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1548678118: {
                Base[] baseArray;
                if (this.ruleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.ruleset;
                }
                return baseArray;
            }
            case 1089373397: {
                Base[] baseArray;
                if (this.originalRuleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.originalRuleset;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.created;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.target;
                }
                return baseArray;
            }
            case -987494927: {
                Base[] baseArray;
                if (this.provider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.provider;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.organization;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.priority;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.enterer;
                }
                return baseArray;
            }
            case 501116579: {
                Base[] baseArray;
                if (this.facility == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.facility;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.patient;
                }
                return baseArray;
            }
            case -351767064: {
                Base[] baseArray;
                if (this.coverage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.coverage;
                }
                return baseArray;
            }
            case 259920682: {
                Base[] baseArray;
                if (this.businessArrangement == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.businessArrangement;
                }
                return baseArray;
            }
            case 1379209295: {
                Base[] baseArray;
                if (this.serviced == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.serviced;
                }
                return baseArray;
            }
            case -1023390027: {
                Base[] baseArray;
                if (this.benefitCategory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.benefitCategory;
                }
                return baseArray;
            }
            case 1987878471: {
                Base[] baseArray;
                if (this.benefitSubCategory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.benefitSubCategory;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 1548678118: {
                this.ruleset = this.castToCoding(value);
                break;
            }
            case 1089373397: {
                this.originalRuleset = this.castToCoding(value);
                break;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                break;
            }
            case -880905839: {
                this.target = (Type)value;
                break;
            }
            case -987494927: {
                this.provider = (Type)value;
                break;
            }
            case 1178922291: {
                this.organization = (Type)value;
                break;
            }
            case -1165461084: {
                this.priority = this.castToCoding(value);
                break;
            }
            case -1591951995: {
                this.enterer = (Type)value;
                break;
            }
            case 501116579: {
                this.facility = (Type)value;
                break;
            }
            case -791418107: {
                this.patient = (Type)value;
                break;
            }
            case -351767064: {
                this.coverage = (Type)value;
                break;
            }
            case 259920682: {
                this.businessArrangement = this.castToString(value);
                break;
            }
            case 1379209295: {
                this.serviced = (Type)value;
                break;
            }
            case -1023390027: {
                this.benefitCategory = this.castToCoding(value);
                break;
            }
            case 1987878471: {
                this.benefitSubCategory = this.castToCoding(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("target[x]")) {
            this.target = (Type)value;
        } else if (name.equals("provider[x]")) {
            this.provider = (Type)value;
        } else if (name.equals("organization[x]")) {
            this.organization = (Type)value;
        } else if (name.equals("priority")) {
            this.priority = this.castToCoding(value);
        } else if (name.equals("enterer[x]")) {
            this.enterer = (Type)value;
        } else if (name.equals("facility[x]")) {
            this.facility = (Type)value;
        } else if (name.equals("patient[x]")) {
            this.patient = (Type)value;
        } else if (name.equals("coverage[x]")) {
            this.coverage = (Type)value;
        } else if (name.equals("businessArrangement")) {
            this.businessArrangement = this.castToString(value);
        } else if (name.equals("serviced[x]")) {
            this.serviced = (Type)value;
        } else if (name.equals("benefitCategory")) {
            this.benefitCategory = this.castToCoding(value);
        } else if (name.equals("benefitSubCategory")) {
            this.benefitSubCategory = this.castToCoding(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1548678118: {
                return this.getRuleset();
            }
            case 1089373397: {
                return this.getOriginalRuleset();
            }
            case 1028554472: {
                throw new FHIRException("Cannot make property created as it is not a complex type");
            }
            case -815579825: {
                return this.getTarget();
            }
            case 2064698607: {
                return this.getProvider();
            }
            case 1326483053: {
                return this.getOrganization();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -812909349: {
                return this.getEnterer();
            }
            case -542224643: {
                return this.getFacility();
            }
            case -2061246629: {
                return this.getPatient();
            }
            case 227689880: {
                return this.getCoverage();
            }
            case 259920682: {
                throw new FHIRException("Cannot make property businessArrangement as it is not a complex type");
            }
            case -1927922223: {
                return this.getServiced();
            }
            case -1023390027: {
                return this.getBenefitCategory();
            }
            case 1987878471: {
                return this.getBenefitSubCategory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityRequest.created");
        }
        if (name.equals("targetIdentifier")) {
            this.target = new Identifier();
            return this.target;
        }
        if (name.equals("targetReference")) {
            this.target = new Reference();
            return this.target;
        }
        if (name.equals("providerIdentifier")) {
            this.provider = new Identifier();
            return this.provider;
        }
        if (name.equals("providerReference")) {
            this.provider = new Reference();
            return this.provider;
        }
        if (name.equals("organizationIdentifier")) {
            this.organization = new Identifier();
            return this.organization;
        }
        if (name.equals("organizationReference")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("priority")) {
            this.priority = new Coding();
            return this.priority;
        }
        if (name.equals("entererIdentifier")) {
            this.enterer = new Identifier();
            return this.enterer;
        }
        if (name.equals("entererReference")) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals("facilityIdentifier")) {
            this.facility = new Identifier();
            return this.facility;
        }
        if (name.equals("facilityReference")) {
            this.facility = new Reference();
            return this.facility;
        }
        if (name.equals("patientIdentifier")) {
            this.patient = new Identifier();
            return this.patient;
        }
        if (name.equals("patientReference")) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("coverageIdentifier")) {
            this.coverage = new Identifier();
            return this.coverage;
        }
        if (name.equals("coverageReference")) {
            this.coverage = new Reference();
            return this.coverage;
        }
        if (name.equals("businessArrangement")) {
            throw new FHIRException("Cannot call addChild on a singleton property EligibilityRequest.businessArrangement");
        }
        if (name.equals("servicedDate")) {
            this.serviced = new DateType();
            return this.serviced;
        }
        if (name.equals("servicedPeriod")) {
            this.serviced = new Period();
            return this.serviced;
        }
        if (name.equals("benefitCategory")) {
            this.benefitCategory = new Coding();
            return this.benefitCategory;
        }
        if (name.equals("benefitSubCategory")) {
            this.benefitSubCategory = new Coding();
            return this.benefitSubCategory;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EligibilityRequest";
    }

    @Override
    public EligibilityRequest copy() {
        EligibilityRequest dst = new EligibilityRequest();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.target = this.target == null ? null : this.target.copy();
        dst.provider = this.provider == null ? null : this.provider.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.facility = this.facility == null ? null : this.facility.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.coverage = this.coverage == null ? null : this.coverage.copy();
        dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
        dst.serviced = this.serviced == null ? null : this.serviced.copy();
        dst.benefitCategory = this.benefitCategory == null ? null : this.benefitCategory.copy();
        dst.benefitSubCategory = this.benefitSubCategory == null ? null : this.benefitSubCategory.copy();
        return dst;
    }

    protected EligibilityRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof EligibilityRequest)) {
            return false;
        }
        EligibilityRequest o = (EligibilityRequest)other;
        return EligibilityRequest.compareDeep(this.identifier, o.identifier, true) && EligibilityRequest.compareDeep(this.ruleset, o.ruleset, true) && EligibilityRequest.compareDeep(this.originalRuleset, o.originalRuleset, true) && EligibilityRequest.compareDeep(this.created, o.created, true) && EligibilityRequest.compareDeep(this.target, o.target, true) && EligibilityRequest.compareDeep(this.provider, o.provider, true) && EligibilityRequest.compareDeep(this.organization, o.organization, true) && EligibilityRequest.compareDeep(this.priority, o.priority, true) && EligibilityRequest.compareDeep(this.enterer, o.enterer, true) && EligibilityRequest.compareDeep(this.facility, o.facility, true) && EligibilityRequest.compareDeep(this.patient, o.patient, true) && EligibilityRequest.compareDeep(this.coverage, o.coverage, true) && EligibilityRequest.compareDeep(this.businessArrangement, o.businessArrangement, true) && EligibilityRequest.compareDeep(this.serviced, o.serviced, true) && EligibilityRequest.compareDeep(this.benefitCategory, o.benefitCategory, true) && EligibilityRequest.compareDeep(this.benefitSubCategory, o.benefitSubCategory, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof EligibilityRequest)) {
            return false;
        }
        EligibilityRequest o = (EligibilityRequest)other;
        return EligibilityRequest.compareValues(this.created, o.created, true) && EligibilityRequest.compareValues(this.businessArrangement, o.businessArrangement, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.target != null && !this.target.isEmpty() || this.provider != null && !this.provider.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.enterer != null && !this.enterer.isEmpty() || this.facility != null && !this.facility.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.coverage != null && !this.coverage.isEmpty() || this.businessArrangement != null && !this.businessArrangement.isEmpty() || this.serviced != null && !this.serviced.isEmpty() || this.benefitCategory != null && !this.benefitCategory.isEmpty() || this.benefitSubCategory != null && !this.benefitSubCategory.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EligibilityRequest;
    }
}

