/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Money;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.ProcessRequest;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PaymentReconciliation", profile="http://hl7.org/fhir/Profile/PaymentReconciliation")
public class PaymentReconciliation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="request", type={Identifier.class, ProcessRequest.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Claim reference", formalDefinition="Original request resource reference.")
    protected Type request;
    @Child(name="outcome", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="complete | error", formalDefinition="Transaction status: error, complete.")
    protected Enumeration<Enumerations.RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="ruleset", type={Coding.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="period", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period covered", formalDefinition="The period of time for which payments have been gathered into this bulk payment for settlement.")
    protected Period period;
    @Child(name="organization", type={Identifier.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Type organization;
    @Child(name="requestProvider", type={Identifier.class, Practitioner.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Type requestProvider;
    @Child(name="requestOrganization", type={Identifier.class, Organization.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Type requestOrganization;
    @Child(name="detail", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Details", formalDefinition="List of individual settlement amounts and the corresponding transaction.")
    protected List<DetailsComponent> detail;
    @Child(name="form", type={Coding.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    protected Coding form;
    @Child(name="total", type={Money.class}, order=13, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total amount of Payment", formalDefinition="Total payment amount.")
    protected Money total;
    @Child(name="note", type={}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Note text", formalDefinition="Suite of notes.")
    protected List<NotesComponent> note;
    private static final long serialVersionUID = -293306995L;
    @SearchParamDefinition(name="requestorganizationreference", path="PaymentReconciliation.requestOrganization.as(Reference)", description="The organization who generated this resource", type="reference")
    public static final String SP_REQUESTORGANIZATIONREFERENCE = "requestorganizationreference";
    public static final ReferenceClientParam REQUESTORGANIZATIONREFERENCE = new ReferenceClientParam("requestorganizationreference");
    public static final Include INCLUDE_REQUESTORGANIZATIONREFERENCE = new Include("PaymentReconciliation:requestorganizationreference").toLocked();
    @SearchParamDefinition(name="created", path="PaymentReconciliation.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="requestorganizationidentifier", path="PaymentReconciliation.requestOrganization.as(Identifier)", description="The organization who generated this resource", type="token")
    public static final String SP_REQUESTORGANIZATIONIDENTIFIER = "requestorganizationidentifier";
    public static final TokenClientParam REQUESTORGANIZATIONIDENTIFIER = new TokenClientParam("requestorganizationidentifier");
    @SearchParamDefinition(name="requestprovideridentifier", path="PaymentReconciliation.requestProvider.as(Identifier)", description="The reference to the provider who sumbitted the claim", type="token")
    public static final String SP_REQUESTPROVIDERIDENTIFIER = "requestprovideridentifier";
    public static final TokenClientParam REQUESTPROVIDERIDENTIFIER = new TokenClientParam("requestprovideridentifier");
    @SearchParamDefinition(name="requestidentifier", path="PaymentReconciliation.request.as(Identifier)", description="The reference to the claim", type="token")
    public static final String SP_REQUESTIDENTIFIER = "requestidentifier";
    public static final TokenClientParam REQUESTIDENTIFIER = new TokenClientParam("requestidentifier");
    @SearchParamDefinition(name="requestreference", path="PaymentReconciliation.request.as(Reference)", description="The reference to the claim", type="reference")
    public static final String SP_REQUESTREFERENCE = "requestreference";
    public static final ReferenceClientParam REQUESTREFERENCE = new ReferenceClientParam("requestreference");
    public static final Include INCLUDE_REQUESTREFERENCE = new Include("PaymentReconciliation:requestreference").toLocked();
    @SearchParamDefinition(name="organizationidentifier", path="PaymentReconciliation.organization.as(Identifier)", description="The organization who generated this resource", type="token")
    public static final String SP_ORGANIZATIONIDENTIFIER = "organizationidentifier";
    public static final TokenClientParam ORGANIZATIONIDENTIFIER = new TokenClientParam("organizationidentifier");
    @SearchParamDefinition(name="requestproviderreference", path="PaymentReconciliation.requestProvider.as(Reference)", description="The reference to the provider who sumbitted the claim", type="reference")
    public static final String SP_REQUESTPROVIDERREFERENCE = "requestproviderreference";
    public static final ReferenceClientParam REQUESTPROVIDERREFERENCE = new ReferenceClientParam("requestproviderreference");
    public static final Include INCLUDE_REQUESTPROVIDERREFERENCE = new Include("PaymentReconciliation:requestproviderreference").toLocked();
    @SearchParamDefinition(name="organizationreference", path="PaymentReconciliation.organization.as(Reference)", description="The organization who generated this resource", type="reference")
    public static final String SP_ORGANIZATIONREFERENCE = "organizationreference";
    public static final ReferenceClientParam ORGANIZATIONREFERENCE = new ReferenceClientParam("organizationreference");
    public static final Include INCLUDE_ORGANIZATIONREFERENCE = new Include("PaymentReconciliation:organizationreference").toLocked();
    @SearchParamDefinition(name="outcome", path="PaymentReconciliation.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="identifier", path="PaymentReconciliation.identifier", description="The business identifier of the Explanation of Benefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="disposition", path="PaymentReconciliation.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");

    public PaymentReconciliation() {
    }

    public PaymentReconciliation(Money total) {
        this.total = total;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PaymentReconciliation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Type getRequest() {
        return this.request;
    }

    public Identifier getRequestIdentifier() throws FHIRException {
        if (!(this.request instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.request.getClass().getName() + " was encountered");
        }
        return (Identifier)this.request;
    }

    public boolean hasRequestIdentifier() {
        return this.request instanceof Identifier;
    }

    public Reference getRequestReference() throws FHIRException {
        if (!(this.request instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.request.getClass().getName() + " was encountered");
        }
        return (Reference)this.request;
    }

    public boolean hasRequestReference() {
        return this.request instanceof Reference;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public PaymentReconciliation setRequest(Type value) {
        this.request = value;
        return this;
    }

    public Enumeration<Enumerations.RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public PaymentReconciliation setOutcomeElement(Enumeration<Enumerations.RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public Enumerations.RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (Enumerations.RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public PaymentReconciliation setOutcome(Enumerations.RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public PaymentReconciliation setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public PaymentReconciliation setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public PaymentReconciliation setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public PaymentReconciliation setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public PaymentReconciliation setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public PaymentReconciliation setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public PaymentReconciliation setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Type getOrganization() {
        return this.organization;
    }

    public Identifier getOrganizationIdentifier() throws FHIRException {
        if (!(this.organization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.organization;
    }

    public boolean hasOrganizationIdentifier() {
        return this.organization instanceof Identifier;
    }

    public Reference getOrganizationReference() throws FHIRException {
        if (!(this.organization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.organization.getClass().getName() + " was encountered");
        }
        return (Reference)this.organization;
    }

    public boolean hasOrganizationReference() {
        return this.organization instanceof Reference;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public PaymentReconciliation setOrganization(Type value) {
        this.organization = value;
        return this;
    }

    public Type getRequestProvider() {
        return this.requestProvider;
    }

    public Identifier getRequestProviderIdentifier() throws FHIRException {
        if (!(this.requestProvider instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.requestProvider.getClass().getName() + " was encountered");
        }
        return (Identifier)this.requestProvider;
    }

    public boolean hasRequestProviderIdentifier() {
        return this.requestProvider instanceof Identifier;
    }

    public Reference getRequestProviderReference() throws FHIRException {
        if (!(this.requestProvider instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.requestProvider.getClass().getName() + " was encountered");
        }
        return (Reference)this.requestProvider;
    }

    public boolean hasRequestProviderReference() {
        return this.requestProvider instanceof Reference;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public PaymentReconciliation setRequestProvider(Type value) {
        this.requestProvider = value;
        return this;
    }

    public Type getRequestOrganization() {
        return this.requestOrganization;
    }

    public Identifier getRequestOrganizationIdentifier() throws FHIRException {
        if (!(this.requestOrganization instanceof Identifier)) {
            throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.requestOrganization.getClass().getName() + " was encountered");
        }
        return (Identifier)this.requestOrganization;
    }

    public boolean hasRequestOrganizationIdentifier() {
        return this.requestOrganization instanceof Identifier;
    }

    public Reference getRequestOrganizationReference() throws FHIRException {
        if (!(this.requestOrganization instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.requestOrganization.getClass().getName() + " was encountered");
        }
        return (Reference)this.requestOrganization;
    }

    public boolean hasRequestOrganizationReference() {
        return this.requestOrganization instanceof Reference;
    }

    public boolean hasRequestOrganization() {
        return this.requestOrganization != null && !this.requestOrganization.isEmpty();
    }

    public PaymentReconciliation setRequestOrganization(Type value) {
        this.requestOrganization = value;
        return this;
    }

    public List<DetailsComponent> getDetail() {
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        return this.detail;
    }

    public boolean hasDetail() {
        if (this.detail == null) {
            return false;
        }
        for (DetailsComponent item : this.detail) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DetailsComponent addDetail() {
        DetailsComponent t = new DetailsComponent();
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        this.detail.add(t);
        return t;
    }

    public PaymentReconciliation addDetail(DetailsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.detail == null) {
            this.detail = new ArrayList<DetailsComponent>();
        }
        this.detail.add(t);
        return this;
    }

    public Coding getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new Coding();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public PaymentReconciliation setForm(Coding value) {
        this.form = value;
        return this;
    }

    public Money getTotal() {
        if (this.total == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.total");
            }
            if (Configuration.doAutoCreate()) {
                this.total = new Money();
            }
        }
        return this.total;
    }

    public boolean hasTotal() {
        return this.total != null && !this.total.isEmpty();
    }

    public PaymentReconciliation setTotal(Money value) {
        this.total = value;
        return this;
    }

    public List<NotesComponent> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (NotesComponent item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NotesComponent addNote() {
        NotesComponent t = new NotesComponent();
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        this.note.add(t);
        return t;
    }

    public PaymentReconciliation addNote(NotesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        this.note.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("request[x]", "Identifier|Reference(ProcessRequest)", "Original request resource reference.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property(SP_OUTCOME, "code", "Transaction status: error, complete.", 0, Integer.MAX_VALUE, this.outcome));
        childrenList.add(new Property(SP_DISPOSITION, "string", "A description of the status of the adjudication.", 0, Integer.MAX_VALUE, this.disposition));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property(SP_CREATED, "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("period", "Period", "The period of time for which payments have been gathered into this bulk payment for settlement.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("organization[x]", "Identifier|Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("requestProvider[x]", "Identifier|Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestProvider));
        childrenList.add(new Property("requestOrganization[x]", "Identifier|Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestOrganization));
        childrenList.add(new Property("detail", "", "List of individual settlement amounts and the corresponding transaction.", 0, Integer.MAX_VALUE, this.detail));
        childrenList.add(new Property("form", "Coding", "The form to be used for printing the content.", 0, Integer.MAX_VALUE, this.form));
        childrenList.add(new Property("total", "Money", "Total payment amount.", 0, Integer.MAX_VALUE, this.total));
        childrenList.add(new Property("note", "", "Suite of notes.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.disposition;
                }
                return baseArray;
            }
            case 1548678118: {
                Base[] baseArray;
                if (this.ruleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.ruleset;
                }
                return baseArray;
            }
            case 1089373397: {
                Base[] baseArray;
                if (this.originalRuleset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.originalRuleset;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.created;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.period;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.organization;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.requestProvider;
                }
                return baseArray;
            }
            case 599053666: {
                Base[] baseArray;
                if (this.requestOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requestOrganization;
                }
                return baseArray;
            }
            case -1335224239: {
                return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
            }
            case 3148996: {
                Base[] baseArray;
                if (this.form == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.form;
                }
                return baseArray;
            }
            case 110549828: {
                Base[] baseArray;
                if (this.total == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.total;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 1095692943: {
                this.request = (Type)value;
                break;
            }
            case -1106507950: {
                this.outcome = new Enumerations.RemittanceOutcomeEnumFactory().fromType(value);
                break;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                break;
            }
            case 1548678118: {
                this.ruleset = this.castToCoding(value);
                break;
            }
            case 1089373397: {
                this.originalRuleset = this.castToCoding(value);
                break;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case 1178922291: {
                this.organization = (Type)value;
                break;
            }
            case 1601527200: {
                this.requestProvider = (Type)value;
                break;
            }
            case 599053666: {
                this.requestOrganization = (Type)value;
                break;
            }
            case -1335224239: {
                this.getDetail().add((DetailsComponent)value);
                break;
            }
            case 3148996: {
                this.form = this.castToCoding(value);
                break;
            }
            case 110549828: {
                this.total = this.castToMoney(value);
                break;
            }
            case 3387378: {
                this.getNote().add((NotesComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("request[x]")) {
            this.request = (Type)value;
        } else if (name.equals(SP_OUTCOME)) {
            this.outcome = new Enumerations.RemittanceOutcomeEnumFactory().fromType(value);
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = this.castToString(value);
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("organization[x]")) {
            this.organization = (Type)value;
        } else if (name.equals("requestProvider[x]")) {
            this.requestProvider = (Type)value;
        } else if (name.equals("requestOrganization[x]")) {
            this.requestOrganization = (Type)value;
        } else if (name.equals("detail")) {
            this.getDetail().add((DetailsComponent)value);
        } else if (name.equals("form")) {
            this.form = this.castToCoding(value);
        } else if (name.equals("total")) {
            this.total = this.castToMoney(value);
        } else if (name.equals("note")) {
            this.getNote().add((NotesComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 37106577: {
                return this.getRequest();
            }
            case -1106507950: {
                throw new FHIRException("Cannot make property outcome as it is not a complex type");
            }
            case 583380919: {
                throw new FHIRException("Cannot make property disposition as it is not a complex type");
            }
            case 1548678118: {
                return this.getRuleset();
            }
            case 1089373397: {
                return this.getOriginalRuleset();
            }
            case 1028554472: {
                throw new FHIRException("Cannot make property created as it is not a complex type");
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1326483053: {
                return this.getOrganization();
            }
            case -1694784800: {
                return this.getRequestProvider();
            }
            case 818740190: {
                return this.getRequestOrganization();
            }
            case -1335224239: {
                return this.addDetail();
            }
            case 3148996: {
                return this.getForm();
            }
            case 110549828: {
                return this.getTotal();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("requestIdentifier")) {
            this.request = new Identifier();
            return this.request;
        }
        if (name.equals("requestReference")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a singleton property PaymentReconciliation.outcome");
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a singleton property PaymentReconciliation.disposition");
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a singleton property PaymentReconciliation.created");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("organizationIdentifier")) {
            this.organization = new Identifier();
            return this.organization;
        }
        if (name.equals("organizationReference")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("requestProviderIdentifier")) {
            this.requestProvider = new Identifier();
            return this.requestProvider;
        }
        if (name.equals("requestProviderReference")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals("requestOrganizationIdentifier")) {
            this.requestOrganization = new Identifier();
            return this.requestOrganization;
        }
        if (name.equals("requestOrganizationReference")) {
            this.requestOrganization = new Reference();
            return this.requestOrganization;
        }
        if (name.equals("detail")) {
            return this.addDetail();
        }
        if (name.equals("form")) {
            this.form = new Coding();
            return this.form;
        }
        if (name.equals("total")) {
            this.total = new Money();
            return this.total;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PaymentReconciliation";
    }

    @Override
    public PaymentReconciliation copy() {
        PaymentReconciliation dst = new PaymentReconciliation();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        Type type = dst.requestOrganization = this.requestOrganization == null ? null : this.requestOrganization.copy();
        if (this.detail != null) {
            dst.detail = new ArrayList<DetailsComponent>();
            for (DetailsComponent detailsComponent : this.detail) {
                dst.detail.add(detailsComponent.copy());
            }
        }
        dst.form = this.form == null ? null : this.form.copy();
        Money money = dst.total = this.total == null ? null : this.total.copy();
        if (this.note != null) {
            dst.note = new ArrayList<NotesComponent>();
            for (NotesComponent notesComponent : this.note) {
                dst.note.add(notesComponent.copy());
            }
        }
        return dst;
    }

    protected PaymentReconciliation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof PaymentReconciliation)) {
            return false;
        }
        PaymentReconciliation o = (PaymentReconciliation)other;
        return PaymentReconciliation.compareDeep(this.identifier, o.identifier, true) && PaymentReconciliation.compareDeep(this.request, o.request, true) && PaymentReconciliation.compareDeep(this.outcome, o.outcome, true) && PaymentReconciliation.compareDeep(this.disposition, o.disposition, true) && PaymentReconciliation.compareDeep(this.ruleset, o.ruleset, true) && PaymentReconciliation.compareDeep(this.originalRuleset, o.originalRuleset, true) && PaymentReconciliation.compareDeep(this.created, o.created, true) && PaymentReconciliation.compareDeep(this.period, o.period, true) && PaymentReconciliation.compareDeep(this.organization, o.organization, true) && PaymentReconciliation.compareDeep(this.requestProvider, o.requestProvider, true) && PaymentReconciliation.compareDeep(this.requestOrganization, o.requestOrganization, true) && PaymentReconciliation.compareDeep(this.detail, o.detail, true) && PaymentReconciliation.compareDeep(this.form, o.form, true) && PaymentReconciliation.compareDeep(this.total, o.total, true) && PaymentReconciliation.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof PaymentReconciliation)) {
            return false;
        }
        PaymentReconciliation o = (PaymentReconciliation)other;
        return PaymentReconciliation.compareValues(this.outcome, o.outcome, true) && PaymentReconciliation.compareValues(this.disposition, o.disposition, true) && PaymentReconciliation.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.request != null && !this.request.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.disposition != null && !this.disposition.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.period != null && !this.period.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.requestProvider != null && !this.requestProvider.isEmpty() || this.requestOrganization != null && !this.requestOrganization.isEmpty() || this.detail != null && !this.detail.isEmpty() || this.form != null && !this.form.isEmpty() || this.total != null && !this.total.isEmpty() || this.note != null && !this.note.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PaymentReconciliation;
    }

    @Block
    public static class NotesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        protected Coding type;
        @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Notes text", formalDefinition="The note text.")
        protected StringType text;
        private static final long serialVersionUID = 129959202L;

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NotesComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NotesComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NotesComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "The note purpose: Print/Display.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("text", "string", "The note text.", 0, Integer.MAX_VALUE, this.text));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 3556653: {
                    this.text = this.castToString(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3556653: {
                    throw new FHIRException("Cannot make property text as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property PaymentReconciliation.text");
            }
            return super.addChild(name);
        }

        @Override
        public NotesComponent copy() {
            NotesComponent dst = new NotesComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other;
            return NotesComponent.compareDeep(this.type, o.type, true) && NotesComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other;
            return NotesComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.text != null && !this.text.isEmpty());
        }

        @Override
        public String fhirType() {
            return "PaymentReconciliation.note";
        }
    }

    @Block
    public static class DetailsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type code", formalDefinition="Code to indicate the nature of the payment, adjustment, funds advance, etc.")
        protected Coding type;
        @Child(name="request", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Claim", formalDefinition="The claim or financial resource.")
        protected Type request;
        @Child(name="responce", type={Identifier.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Claim Response", formalDefinition="The claim response resource.")
        protected Type responce;
        @Child(name="submitter", type={Identifier.class, Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Submitter", formalDefinition="The Organization which submitted the invoice or financial transaction.")
        protected Type submitter;
        @Child(name="payee", type={Identifier.class, Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Payee", formalDefinition="The organization which is receiving the payment.")
        protected Type payee;
        @Child(name="date", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Invoice date", formalDefinition="The date of the invoice or financial resource.")
        protected DateType date;
        @Child(name="amount", type={Money.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Detail amount", formalDefinition="Amount paid for this detail.")
        protected Money amount;
        private static final long serialVersionUID = 1706468339L;

        public DetailsComponent() {
        }

        public DetailsComponent(Coding type) {
            this.type = type;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DetailsComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Type getRequest() {
            return this.request;
        }

        public Identifier getRequestIdentifier() throws FHIRException {
            if (!(this.request instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.request.getClass().getName() + " was encountered");
            }
            return (Identifier)this.request;
        }

        public boolean hasRequestIdentifier() {
            return this.request instanceof Identifier;
        }

        public Reference getRequestReference() throws FHIRException {
            if (!(this.request instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.request.getClass().getName() + " was encountered");
            }
            return (Reference)this.request;
        }

        public boolean hasRequestReference() {
            return this.request instanceof Reference;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public DetailsComponent setRequest(Type value) {
            this.request = value;
            return this;
        }

        public Type getResponce() {
            return this.responce;
        }

        public Identifier getResponceIdentifier() throws FHIRException {
            if (!(this.responce instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.responce.getClass().getName() + " was encountered");
            }
            return (Identifier)this.responce;
        }

        public boolean hasResponceIdentifier() {
            return this.responce instanceof Identifier;
        }

        public Reference getResponceReference() throws FHIRException {
            if (!(this.responce instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.responce.getClass().getName() + " was encountered");
            }
            return (Reference)this.responce;
        }

        public boolean hasResponceReference() {
            return this.responce instanceof Reference;
        }

        public boolean hasResponce() {
            return this.responce != null && !this.responce.isEmpty();
        }

        public DetailsComponent setResponce(Type value) {
            this.responce = value;
            return this;
        }

        public Type getSubmitter() {
            return this.submitter;
        }

        public Identifier getSubmitterIdentifier() throws FHIRException {
            if (!(this.submitter instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.submitter.getClass().getName() + " was encountered");
            }
            return (Identifier)this.submitter;
        }

        public boolean hasSubmitterIdentifier() {
            return this.submitter instanceof Identifier;
        }

        public Reference getSubmitterReference() throws FHIRException {
            if (!(this.submitter instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.submitter.getClass().getName() + " was encountered");
            }
            return (Reference)this.submitter;
        }

        public boolean hasSubmitterReference() {
            return this.submitter instanceof Reference;
        }

        public boolean hasSubmitter() {
            return this.submitter != null && !this.submitter.isEmpty();
        }

        public DetailsComponent setSubmitter(Type value) {
            this.submitter = value;
            return this;
        }

        public Type getPayee() {
            return this.payee;
        }

        public Identifier getPayeeIdentifier() throws FHIRException {
            if (!(this.payee instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.payee.getClass().getName() + " was encountered");
            }
            return (Identifier)this.payee;
        }

        public boolean hasPayeeIdentifier() {
            return this.payee instanceof Identifier;
        }

        public Reference getPayeeReference() throws FHIRException {
            if (!(this.payee instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.payee.getClass().getName() + " was encountered");
            }
            return (Reference)this.payee;
        }

        public boolean hasPayeeReference() {
            return this.payee instanceof Reference;
        }

        public boolean hasPayee() {
            return this.payee != null && !this.payee.isEmpty();
        }

        public DetailsComponent setPayee(Type value) {
            this.payee = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public DetailsComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public DetailsComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailsComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public DetailsComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "Code to indicate the nature of the payment, adjustment, funds advance, etc.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("request[x]", "Identifier|Reference(Any)", "The claim or financial resource.", 0, Integer.MAX_VALUE, this.request));
            childrenList.add(new Property("responce[x]", "Identifier|Reference(Any)", "The claim response resource.", 0, Integer.MAX_VALUE, this.responce));
            childrenList.add(new Property("submitter[x]", "Identifier|Reference(Organization)", "The Organization which submitted the invoice or financial transaction.", 0, Integer.MAX_VALUE, this.submitter));
            childrenList.add(new Property("payee[x]", "Identifier|Reference(Organization)", "The organization which is receiving the payment.", 0, Integer.MAX_VALUE, this.payee));
            childrenList.add(new Property("date", "date", "The date of the invoice or financial resource.", 0, Integer.MAX_VALUE, this.date));
            childrenList.add(new Property("amount", "Money", "Amount paid for this detail.", 0, Integer.MAX_VALUE, this.amount));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    Base[] baseArray;
                    if (this.request == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.request;
                    }
                    return baseArray;
                }
                case -340323759: {
                    Base[] baseArray;
                    if (this.responce == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.responce;
                    }
                    return baseArray;
                }
                case 348678409: {
                    Base[] baseArray;
                    if (this.submitter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.submitter;
                    }
                    return baseArray;
                }
                case 106443592: {
                    Base[] baseArray;
                    if (this.payee == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.payee;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.date;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCoding(value);
                    break;
                }
                case 1095692943: {
                    this.request = (Type)value;
                    break;
                }
                case -340323759: {
                    this.responce = (Type)value;
                    break;
                }
                case 348678409: {
                    this.submitter = (Type)value;
                    break;
                }
                case 106443592: {
                    this.payee = (Type)value;
                    break;
                }
                case 3076014: {
                    this.date = this.castToDate(value);
                    break;
                }
                case -1413853096: {
                    this.amount = this.castToMoney(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("request[x]")) {
                this.request = (Type)value;
            } else if (name.equals("responce[x]")) {
                this.responce = (Type)value;
            } else if (name.equals("submitter[x]")) {
                this.submitter = (Type)value;
            } else if (name.equals("payee[x]")) {
                this.payee = (Type)value;
            } else if (name.equals("date")) {
                this.date = this.castToDate(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 37106577: {
                    return this.getRequest();
                }
                case 1832772751: {
                    return this.getResponce();
                }
                case -2047315241: {
                    return this.getSubmitter();
                }
                case 1375276088: {
                    return this.getPayee();
                }
                case 3076014: {
                    throw new FHIRException("Cannot make property date as it is not a complex type");
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("requestIdentifier")) {
                this.request = new Identifier();
                return this.request;
            }
            if (name.equals("requestReference")) {
                this.request = new Reference();
                return this.request;
            }
            if (name.equals("responceIdentifier")) {
                this.responce = new Identifier();
                return this.responce;
            }
            if (name.equals("responceReference")) {
                this.responce = new Reference();
                return this.responce;
            }
            if (name.equals("submitterIdentifier")) {
                this.submitter = new Identifier();
                return this.submitter;
            }
            if (name.equals("submitterReference")) {
                this.submitter = new Reference();
                return this.submitter;
            }
            if (name.equals("payeeIdentifier")) {
                this.payee = new Identifier();
                return this.payee;
            }
            if (name.equals("payeeReference")) {
                this.payee = new Reference();
                return this.payee;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a singleton property PaymentReconciliation.date");
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public DetailsComponent copy() {
            DetailsComponent dst = new DetailsComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.responce = this.responce == null ? null : this.responce.copy();
            dst.submitter = this.submitter == null ? null : this.submitter.copy();
            dst.payee = this.payee == null ? null : this.payee.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DetailsComponent)) {
                return false;
            }
            DetailsComponent o = (DetailsComponent)other;
            return DetailsComponent.compareDeep(this.type, o.type, true) && DetailsComponent.compareDeep(this.request, o.request, true) && DetailsComponent.compareDeep(this.responce, o.responce, true) && DetailsComponent.compareDeep(this.submitter, o.submitter, true) && DetailsComponent.compareDeep(this.payee, o.payee, true) && DetailsComponent.compareDeep(this.date, o.date, true) && DetailsComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DetailsComponent)) {
                return false;
            }
            DetailsComponent o = (DetailsComponent)other;
            return DetailsComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.request != null && !this.request.isEmpty() || this.responce != null && !this.responce.isEmpty() || this.submitter != null && !this.submitter.isEmpty() || this.payee != null && !this.payee.isEmpty() || this.date != null && !this.date.isEmpty() || this.amount != null && !this.amount.isEmpty());
        }

        @Override
        public String fhirType() {
            return "PaymentReconciliation.detail";
        }
    }
}

