/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DataAbsentReason {
    UNKNOWN,
    ASKED,
    TEMP,
    NOTASKED,
    MASKED,
    UNSUPPORTED,
    ASTEXT,
    ERROR,
    NAN,
    NULL;


    public static DataAbsentReason fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        if ("asked".equals(codeString)) {
            return ASKED;
        }
        if ("temp".equals(codeString)) {
            return TEMP;
        }
        if ("not-asked".equals(codeString)) {
            return NOTASKED;
        }
        if ("masked".equals(codeString)) {
            return MASKED;
        }
        if ("unsupported".equals(codeString)) {
            return UNSUPPORTED;
        }
        if ("astext".equals(codeString)) {
            return ASTEXT;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        if ("NaN".equals(codeString)) {
            return NAN;
        }
        throw new FHIRException("Unknown DataAbsentReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNKNOWN: {
                return "unknown";
            }
            case ASKED: {
                return "asked";
            }
            case TEMP: {
                return "temp";
            }
            case NOTASKED: {
                return "not-asked";
            }
            case MASKED: {
                return "masked";
            }
            case UNSUPPORTED: {
                return "unsupported";
            }
            case ASTEXT: {
                return "astext";
            }
            case ERROR: {
                return "error";
            }
            case NAN: {
                return "NaN";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/data-absent-reason";
    }

    public String getDefinition() {
        switch (this) {
            case UNKNOWN: {
                return "The value is not known.";
            }
            case ASKED: {
                return "The source human does not know the value.";
            }
            case TEMP: {
                return "There is reason to expect (from the workflow) that the value may become known.";
            }
            case NOTASKED: {
                return "The workflow didn't lead to this value being known.";
            }
            case MASKED: {
                return "The information is not available due to security, privacy or related reasons.";
            }
            case UNSUPPORTED: {
                return "The source system wasn't capable of supporting this element.";
            }
            case ASTEXT: {
                return "The content of the data is represented in the resource narrative.";
            }
            case ERROR: {
                return "Some system or workflow process error means that the information is not available.";
            }
            case NAN: {
                return "NaN, standing for not a number, is a numeric data type value representing an undefined or unrepresentable value.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNKNOWN: {
                return "Unknown";
            }
            case ASKED: {
                return "Asked";
            }
            case TEMP: {
                return "Temp";
            }
            case NOTASKED: {
                return "Not Asked";
            }
            case MASKED: {
                return "Masked";
            }
            case UNSUPPORTED: {
                return "Unsupported";
            }
            case ASTEXT: {
                return "As Text";
            }
            case ERROR: {
                return "Error";
            }
            case NAN: {
                return "Not a Number";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

