/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ExProgramCode;

public class ExProgramCodeEnumFactory
implements EnumFactory<ExProgramCode> {
    @Override
    public ExProgramCode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("AS".equals(codeString)) {
            return ExProgramCode.AS;
        }
        if ("HD".equals(codeString)) {
            return ExProgramCode.HD;
        }
        if ("AUSCR".equals(codeString)) {
            return ExProgramCode.AUSCR;
        }
        throw new IllegalArgumentException("Unknown ExProgramCode code '" + codeString + "'");
    }

    @Override
    public String toCode(ExProgramCode code) {
        if (code == ExProgramCode.AS) {
            return "AS";
        }
        if (code == ExProgramCode.HD) {
            return "HD";
        }
        if (code == ExProgramCode.AUSCR) {
            return "AUSCR";
        }
        return "?";
    }

    @Override
    public String toSystem(ExProgramCode code) {
        return code.getSystem();
    }
}

