/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcObservationHeightMeasMethodDevice {
    _2057,
    _2058,
    _2061,
    _2063,
    _521363688,
    NULL;


    public static HspcObservationHeightMeasMethodDevice fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("2057".equals(codeString)) {
            return _2057;
        }
        if ("2058".equals(codeString)) {
            return _2058;
        }
        if ("2061".equals(codeString)) {
            return _2061;
        }
        if ("2063".equals(codeString)) {
            return _2063;
        }
        if ("521363688".equals(codeString)) {
            return _521363688;
        }
        throw new FHIRException("Unknown HspcObservationHeightMeasMethodDevice code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _2057: {
                return "2057";
            }
            case _2058: {
                return "2058";
            }
            case _2061: {
                return "2061";
            }
            case _2063: {
                return "2063";
            }
            case _521363688: {
                return "521363688";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7,org/fhir/valueset-observation-heightMeasMethodDevice";
    }

    public String getDefinition() {
        switch (this) {
            case _2057: {
                return "The method of determining body length or height where it is guessed at by the health care provider";
            }
            case _2058: {
                return "A method of determining body length or height by utilizing a device to measure it.";
            }
            case _2061: {
                return "A method of determining body length or height by using a growth percentile chart";
            }
            case _2063: {
                return "The body length or height was given verbally rather than measured.";
            }
            case _521363688: {
                return "A device for measuring body length or height.  Usually constructed of a ruler and a sliding headpiece that, when placed on an individual's head will give a reading of the body length or height.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _2057: {
                return "Height, estimated by provider";
            }
            case _2058: {
                return "Height, measured";
            }
            case _2061: {
                return "Height, percentile";
            }
            case _2063: {
                return "Height, stated (reported)";
            }
            case _521363688: {
                return "Stadiometer";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

