/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MetricCalibrationType {
    UNSPECIFIED,
    OFFSET,
    GAIN,
    TWOPOINT,
    NULL;


    public static MetricCalibrationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("unspecified".equals(codeString)) {
            return UNSPECIFIED;
        }
        if ("offset".equals(codeString)) {
            return OFFSET;
        }
        if ("gain".equals(codeString)) {
            return GAIN;
        }
        if ("two-point".equals(codeString)) {
            return TWOPOINT;
        }
        throw new FHIRException("Unknown MetricCalibrationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UNSPECIFIED: {
                return "unspecified";
            }
            case OFFSET: {
                return "offset";
            }
            case GAIN: {
                return "gain";
            }
            case TWOPOINT: {
                return "two-point";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/metric-calibration-type";
    }

    public String getDefinition() {
        switch (this) {
            case UNSPECIFIED: {
                return "TODO";
            }
            case OFFSET: {
                return "TODO";
            }
            case GAIN: {
                return "TODO";
            }
            case TWOPOINT: {
                return "TODO";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UNSPECIFIED: {
                return "Unspecified";
            }
            case OFFSET: {
                return "Offset";
            }
            case GAIN: {
                return "Gain";
            }
            case TWOPOINT: {
                return "Two Point";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

