/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NarrativeStatus {
    GENERATED,
    EXTENSIONS,
    ADDITIONAL,
    EMPTY,
    NULL;


    public static NarrativeStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("generated".equals(codeString)) {
            return GENERATED;
        }
        if ("extensions".equals(codeString)) {
            return EXTENSIONS;
        }
        if ("additional".equals(codeString)) {
            return ADDITIONAL;
        }
        if ("empty".equals(codeString)) {
            return EMPTY;
        }
        throw new FHIRException("Unknown NarrativeStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GENERATED: {
                return "generated";
            }
            case EXTENSIONS: {
                return "extensions";
            }
            case ADDITIONAL: {
                return "additional";
            }
            case EMPTY: {
                return "empty";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/narrative-status";
    }

    public String getDefinition() {
        switch (this) {
            case GENERATED: {
                return "The contents of the narrative are entirely generated from the structured data in the content.";
            }
            case EXTENSIONS: {
                return "The contents of the narrative are entirely generated from the structured data in the content and some of the content is generated from extensions";
            }
            case ADDITIONAL: {
                return "The contents of the narrative contain additional information not found in the structured data";
            }
            case EMPTY: {
                return "The contents of the narrative are some equivalent of \"No human-readable text provided in this case\"";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GENERATED: {
                return "Generated";
            }
            case EXTENSIONS: {
                return "Extensions";
            }
            case ADDITIONAL: {
                return "Additional";
            }
            case EMPTY: {
                return "Empty";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

