/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.OrderStatus;

public class OrderStatusEnumFactory
implements EnumFactory<OrderStatus> {
    @Override
    public OrderStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("pending".equals(codeString)) {
            return OrderStatus.PENDING;
        }
        if ("review".equals(codeString)) {
            return OrderStatus.REVIEW;
        }
        if ("rejected".equals(codeString)) {
            return OrderStatus.REJECTED;
        }
        if ("error".equals(codeString)) {
            return OrderStatus.ERROR;
        }
        if ("accepted".equals(codeString)) {
            return OrderStatus.ACCEPTED;
        }
        if ("cancelled".equals(codeString)) {
            return OrderStatus.CANCELLED;
        }
        if ("replaced".equals(codeString)) {
            return OrderStatus.REPLACED;
        }
        if ("aborted".equals(codeString)) {
            return OrderStatus.ABORTED;
        }
        if ("completed".equals(codeString)) {
            return OrderStatus.COMPLETED;
        }
        throw new IllegalArgumentException("Unknown OrderStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(OrderStatus code) {
        if (code == OrderStatus.PENDING) {
            return "pending";
        }
        if (code == OrderStatus.REVIEW) {
            return "review";
        }
        if (code == OrderStatus.REJECTED) {
            return "rejected";
        }
        if (code == OrderStatus.ERROR) {
            return "error";
        }
        if (code == OrderStatus.ACCEPTED) {
            return "accepted";
        }
        if (code == OrderStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == OrderStatus.REPLACED) {
            return "replaced";
        }
        if (code == OrderStatus.ABORTED) {
            return "aborted";
        }
        if (code == OrderStatus.COMPLETED) {
            return "completed";
        }
        return "?";
    }

    @Override
    public String toSystem(OrderStatus code) {
        return code.getSystem();
    }
}

