/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.terminologies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.XmlParser;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.CodeSystemUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ICPC2Importer {
    private String sourceFileName;
    private String targetFileNameVS;
    private String targetFileNameCS;

    public static void main(String[] args) {
        try {
            ICPC2Importer r = new ICPC2Importer();
            r.setSourceFileName(Utilities.path((String[])new String[]{"[tmp]", "ICPC-2e-v5.0.xml"}));
            r.setTargetFileNameCS(Utilities.path((String[])new String[]{"[tmp]", "icpc2.xml"}));
            r.setTargetFileNameVS(Utilities.path((String[])new String[]{"[tmp]", "icpc2-vs.xml"}));
            r.go();
            System.out.println("Completed OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ICPC2Importer() {
    }

    public ICPC2Importer(String sourceFileName, String targetFileNameCS, String targetFileNameVS) {
        this.sourceFileName = sourceFileName;
        this.targetFileNameCS = targetFileNameCS;
        this.targetFileNameVS = targetFileNameVS;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public String getTargetFileNameCS() {
        return this.targetFileNameCS;
    }

    public void setTargetFileNameCS(String targetFileName) {
        this.targetFileNameCS = targetFileName;
    }

    public String getTargetFileNameVS() {
        return this.targetFileNameVS;
    }

    public void setTargetFileNameVS(String targetFileName) {
        this.targetFileNameVS = targetFileName;
    }

    public void go() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(ManagedFileAccess.inStream((String)this.sourceFileName));
        ValueSet vs = new ValueSet();
        vs.setUrl("http://hl7.org/fhir/sid/icpc2/vs");
        Element title = XMLUtil.getNamedChild((Element)doc.getDocumentElement(), (String)"Title");
        vs.setVersion(title.getAttribute("version"));
        vs.setName(title.getAttribute("name"));
        vs.setImmutable(true);
        Element identifier = XMLUtil.getNamedChild((Element)doc.getDocumentElement(), (String)"Identifier");
        vs.setPublisher(identifier.getAttribute("authority"));
        vs.setIdentifier(new Identifier().setValue(identifier.getAttribute("uid")));
        ArrayList authors = new ArrayList();
        XMLUtil.getNamedChildren((Element)XMLUtil.getNamedChild((Element)doc.getDocumentElement(), (String)"Authors"), (String)"Author", authors);
        for (Object a : authors) {
            if (a.getAttribute("name").contains("+")) continue;
            vs.addContact().setName(a.getTextContent());
        }
        vs.setCopyright("The copyright of ICPC, both in hard copy and in electronic form, is owned by Wonca. See http://www.kith.no/templates/kith_WebPage____1110.aspx");
        vs.setStatus(Enumerations.ConformanceResourceStatus.ACTIVE);
        vs.setDateElement(new DateTimeType(title.getAttribute("date")));
        vs.getCompose().addInclude().setSystem("http://hl7.org/fhir/sid/icpc2");
        CodeSystem cs = new CodeSystem();
        cs.setUrl("http://hl7.org/fhir/sid/icpc2");
        cs.setVersion(title.getAttribute("version"));
        cs.setName(title.getAttribute("name"));
        identifier = XMLUtil.getNamedChild((Element)doc.getDocumentElement(), (String)"Identifier");
        cs.setPublisher(identifier.getAttribute("authority"));
        cs.setIdentifier(new Identifier().setValue(identifier.getAttribute("uid")));
        authors = new ArrayList();
        XMLUtil.getNamedChildren((Element)XMLUtil.getNamedChild((Element)doc.getDocumentElement(), (String)"Authors"), (String)"Author", authors);
        for (Element a : authors) {
            if (a.getAttribute("name").contains("+")) continue;
            cs.addContact().setName(a.getTextContent());
        }
        cs.setCopyright("The copyright of ICPC, both in hard copy and in electronic form, is owned by Wonca. See http://www.kith.no/templates/kith_WebPage____1110.aspx");
        cs.setStatus(Enumerations.ConformanceResourceStatus.ACTIVE);
        cs.setDateElement(new DateTimeType(title.getAttribute("date")));
        cs.setValueSet(vs.getUrl());
        HashMap<String, CodeSystem.ConceptDefinitionComponent> concepts = new HashMap<String, CodeSystem.ConceptDefinitionComponent>();
        ArrayList classes = new ArrayList();
        XMLUtil.getNamedChildren((Element)doc.getDocumentElement(), (String)"Class", classes);
        for (Element cls : classes) {
            this.processClass(cls, concepts, cs);
        }
        XmlParser xml = new XmlParser();
        xml.setOutputStyle(IParser.OutputStyle.PRETTY);
        xml.compose(ManagedFileAccess.outStream((String)this.targetFileNameVS), vs);
        xml.compose(ManagedFileAccess.outStream((String)this.targetFileNameCS), cs);
    }

    private void processClass(Element cls, Map<String, CodeSystem.ConceptDefinitionComponent> concepts, CodeSystem define) {
        Element parent;
        CodeSystem.ConceptDefinitionComponent concept = new CodeSystem.ConceptDefinitionComponent();
        concept.setCode(cls.getAttribute("code"));
        concept.setDefinition(this.getRubric(cls, "preferred"));
        String s = this.getRubric(cls, "shortTitle");
        if (s != null && !s.equals(concept.getDefinition())) {
            concept.addDesignation().setUse(new Coding().setSystem("http://hl7.org/fhir/sid/icpc2/rubrics").setCode("shortTitle")).setValue(s);
        }
        if ((s = this.getRubric(cls, "inclusion")) != null) {
            concept.addDesignation().setUse(new Coding().setSystem("http://hl7.org/fhir/sid/icpc2/rubrics").setCode("inclusion")).setValue(s);
        }
        if ((s = this.getRubric(cls, "exclusion")) != null) {
            concept.addDesignation().setUse(new Coding().setSystem("http://hl7.org/fhir/sid/icpc2/rubrics").setCode("exclusion")).setValue(s);
        }
        if ((s = this.getRubric(cls, "criteria")) != null) {
            concept.addDesignation().setUse(new Coding().setSystem("http://hl7.org/fhir/sid/icpc2/rubrics").setCode("criteria")).setValue(s);
        }
        if ((s = this.getRubric(cls, "consider")) != null) {
            concept.addDesignation().setUse(new Coding().setSystem("http://hl7.org/fhir/sid/icpc2/rubrics").setCode("consider")).setValue(s);
        }
        if ((s = this.getRubric(cls, "note")) != null) {
            concept.addDesignation().setUse(new Coding().setSystem("http://hl7.org/fhir/sid/icpc2/rubrics").setCode("note")).setValue(s);
        }
        concepts.put(concept.getCode(), concept);
        ArrayList children = new ArrayList();
        XMLUtil.getNamedChildren((Element)cls, (String)"SubClass", children);
        if (children.size() > 0) {
            CodeSystemUtilities.setAbstract(define, concept);
        }
        if ((parent = XMLUtil.getNamedChild((Element)cls, (String)"SuperClass")) == null) {
            define.addConcept(concept);
        } else {
            CodeSystem.ConceptDefinitionComponent p = concepts.get(parent.getAttribute("code"));
            p.getConcept().add(concept);
        }
    }

    private String getRubric(Element cls, String kind) {
        ArrayList rubrics = new ArrayList();
        XMLUtil.getNamedChildren((Element)cls, (String)"Rubric", rubrics);
        for (Element r : rubrics) {
            if (!r.getAttribute("kind").equals(kind)) continue;
            return XMLUtil.getNamedChild((Element)r, (String)"Label").getTextContent();
        }
        return null;
    }
}

