/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Condition;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Duration;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.MedicationStatement;
import org.hl7.fhir.dstu2016may.model.NutritionOrder;
import org.hl7.fhir.dstu2016may.model.Observation;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.ProcedureRequest;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.RiskAssessment;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Goal", profile="http://hl7.org/fhir/Profile/Goal")
public class Goal
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External Ids for this goal", formalDefinition="This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="subject", type={Patient.class, Group.class, Organization.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who this goal is intended for", formalDefinition="Identifies the patient, group or organization for whom the goal is being established.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="start", type={DateType.class, CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When goal pursuit begins", formalDefinition="The date or event after which the goal should begin being pursued.")
    protected Type start;
    @Child(name="target", type={DateType.class, Duration.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reach goal on or before", formalDefinition="Indicates either the date or the duration after start by which the goal should be met.")
    protected Type target;
    @Child(name="category", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="E.g. Treatment, dietary, behavioral, etc.", formalDefinition="Indicates a category the goal falls within.")
    protected List<CodeableConcept> category;
    @Child(name="description", type={StringType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What's the desired outcome?", formalDefinition="Human-readable description of a specific desired objective of care.")
    protected StringType description;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | planned | accepted | rejected | in-progress | achieved | sustaining | on-hold | cancelled", formalDefinition="Indicates whether the goal has been reached and is still considered relevant.")
    protected Enumeration<GoalStatus> status;
    @Child(name="statusDate", type={DateType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When goal status took effect", formalDefinition="Identifies when the current status.  I.e. When initially created, when achieved, when cancelled, etc.")
    protected DateType statusDate;
    @Child(name="statusReason", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reason for current status", formalDefinition="Captures the reason for the current status.")
    protected CodeableConcept statusReason;
    @Child(name="author", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who's responsible for creating Goal?", formalDefinition="Indicates whose goal this is - patient goal, practitioner goal, etc.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="priority", type={CodeableConcept.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="high | medium |low", formalDefinition="Identifies the mutually agreed level of importance associated with reaching/sustaining the goal.")
    protected CodeableConcept priority;
    @Child(name="addresses", type={Condition.class, Observation.class, MedicationStatement.class, NutritionOrder.class, ProcedureRequest.class, RiskAssessment.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Issues addressed by this goal", formalDefinition="The identified conditions and other health record elements that are intended to be addressed by the goal.")
    protected List<Reference> addresses;
    protected List<Resource> addressesTarget;
    @Child(name="note", type={Annotation.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments about the goal", formalDefinition="Any comments related to the goal.")
    protected List<Annotation> note;
    @Child(name="outcome", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What was end result of goal?", formalDefinition="Identifies the change (or lack of change) at the point where the goal was deepmed to be cancelled or achieved.")
    protected List<GoalOutcomeComponent> outcome;
    private static final long serialVersionUID = 2029459056L;
    @SearchParamDefinition(name="targetdate", path="Goal.target.as(Date)", description="Reach goal on or before", type="date")
    public static final String SP_TARGETDATE = "targetdate";
    public static final DateClientParam TARGETDATE = new DateClientParam("targetdate");
    @SearchParamDefinition(name="category", path="Goal.category", description="E.g. Treatment, dietary, behavioral, etc.", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="patient", path="Goal.subject", description="Who this goal is intended for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Goal:patient").toLocked();
    @SearchParamDefinition(name="status", path="Goal.status", description="proposed | planned | accepted | rejected | in-progress | achieved | sustaining | on-hold | cancelled", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Goal.subject", description="Who this goal is intended for", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Goal:subject").toLocked();
    @SearchParamDefinition(name="identifier", path="Goal.identifier", description="External Ids for this goal", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Goal() {
    }

    public Goal(StringType description, Enumeration<GoalStatus> status) {
        this.description = description;
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Goal addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Goal setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Goal setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Type getStart() {
        return this.start;
    }

    public DateType getStartDateType() throws FHIRException {
        if (!(this.start instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.start.getClass().getName() + " was encountered");
        }
        return (DateType)this.start;
    }

    public boolean hasStartDateType() {
        return this.start instanceof DateType;
    }

    public CodeableConcept getStartCodeableConcept() throws FHIRException {
        if (!(this.start instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.start.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.start;
    }

    public boolean hasStartCodeableConcept() {
        return this.start instanceof CodeableConcept;
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public Goal setStart(Type value) {
        this.start = value;
        return this;
    }

    public Type getTarget() {
        return this.target;
    }

    public DateType getTargetDateType() throws FHIRException {
        if (!(this.target instanceof DateType)) {
            throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (DateType)this.target;
    }

    public boolean hasTargetDateType() {
        return this.target instanceof DateType;
    }

    public Duration getTargetDuration() throws FHIRException {
        if (!(this.target instanceof Duration)) {
            throw new FHIRException("Type mismatch: the type Duration was expected, but " + this.target.getClass().getName() + " was encountered");
        }
        return (Duration)this.target;
    }

    public boolean hasTargetDuration() {
        return this.target instanceof Duration;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public Goal setTarget(Type value) {
        this.target = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Goal addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Goal setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Goal setDescription(String value) {
        if (this.description == null) {
            this.description = new StringType();
        }
        this.description.setValue(value);
        return this;
    }

    public Enumeration<GoalStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<GoalStatus>(new GoalStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Goal setStatusElement(Enumeration<GoalStatus> value) {
        this.status = value;
        return this;
    }

    public GoalStatus getStatus() {
        return this.status == null ? null : (GoalStatus)((Object)this.status.getValue());
    }

    public Goal setStatus(GoalStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<GoalStatus>(new GoalStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public DateType getStatusDateElement() {
        if (this.statusDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.statusDate");
            }
            if (Configuration.doAutoCreate()) {
                this.statusDate = new DateType();
            }
        }
        return this.statusDate;
    }

    public boolean hasStatusDateElement() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public boolean hasStatusDate() {
        return this.statusDate != null && !this.statusDate.isEmpty();
    }

    public Goal setStatusDateElement(DateType value) {
        this.statusDate = value;
        return this;
    }

    public Date getStatusDate() {
        return this.statusDate == null ? null : (Date)this.statusDate.getValue();
    }

    public Goal setStatusDate(Date value) {
        if (value == null) {
            this.statusDate = null;
        } else {
            if (this.statusDate == null) {
                this.statusDate = new DateType();
            }
            this.statusDate.setValue(value);
        }
        return this;
    }

    public CodeableConcept getStatusReason() {
        if (this.statusReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.statusReason");
            }
            if (Configuration.doAutoCreate()) {
                this.statusReason = new CodeableConcept();
            }
        }
        return this.statusReason;
    }

    public boolean hasStatusReason() {
        return this.statusReason != null && !this.statusReason.isEmpty();
    }

    public Goal setStatusReason(CodeableConcept value) {
        this.statusReason = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public Goal setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public Goal setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Goal.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Goal setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public List<Reference> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        return this.addresses;
    }

    public boolean hasAddresses() {
        if (this.addresses == null) {
            return false;
        }
        for (Reference item : this.addresses) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAddresses() {
        Reference t = new Reference();
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        this.addresses.add(t);
        return t;
    }

    public Goal addAddresses(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.addresses == null) {
            this.addresses = new ArrayList<Reference>();
        }
        this.addresses.add(t);
        return this;
    }

    public List<Resource> getAddressesTarget() {
        if (this.addressesTarget == null) {
            this.addressesTarget = new ArrayList<Resource>();
        }
        return this.addressesTarget;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Goal addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public List<GoalOutcomeComponent> getOutcome() {
        if (this.outcome == null) {
            this.outcome = new ArrayList<GoalOutcomeComponent>();
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        if (this.outcome == null) {
            return false;
        }
        for (GoalOutcomeComponent item : this.outcome) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GoalOutcomeComponent addOutcome() {
        GoalOutcomeComponent t = new GoalOutcomeComponent();
        if (this.outcome == null) {
            this.outcome = new ArrayList<GoalOutcomeComponent>();
        }
        this.outcome.add(t);
        return t;
    }

    public Goal addOutcome(GoalOutcomeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.outcome == null) {
            this.outcome = new ArrayList<GoalOutcomeComponent>();
        }
        this.outcome.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this care plan that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Organization)", "Identifies the patient, group or organization for whom the goal is being established.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("start[x]", "date|CodeableConcept", "The date or event after which the goal should begin being pursued.", 0, Integer.MAX_VALUE, this.start));
        childrenList.add(new Property("target[x]", "date|Duration", "Indicates either the date or the duration after start by which the goal should be met.", 0, Integer.MAX_VALUE, this.target));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "Indicates a category the goal falls within.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property("description", "string", "Human-readable description of a specific desired objective of care.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property(SP_STATUS, "code", "Indicates whether the goal has been reached and is still considered relevant.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("statusDate", "date", "Identifies when the current status.  I.e. When initially created, when achieved, when cancelled, etc.", 0, Integer.MAX_VALUE, this.statusDate));
        childrenList.add(new Property("statusReason", "CodeableConcept", "Captures the reason for the current status.", 0, Integer.MAX_VALUE, this.statusReason));
        childrenList.add(new Property("author", "Reference(Patient|Practitioner|RelatedPerson)", "Indicates whose goal this is - patient goal, practitioner goal, etc.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property("priority", "CodeableConcept", "Identifies the mutually agreed level of importance associated with reaching/sustaining the goal.", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property("addresses", "Reference(Condition|Observation|MedicationStatement|NutritionOrder|ProcedureRequest|RiskAssessment)", "The identified conditions and other health record elements that are intended to be addressed by the goal.", 0, Integer.MAX_VALUE, this.addresses));
        childrenList.add(new Property("note", "Annotation", "Any comments related to the goal.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("outcome", "", "Identifies the change (or lack of change) at the point where the goal was deepmed to be cancelled or achieved.", 0, Integer.MAX_VALUE, this.outcome));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.subject;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.start;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.target;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case 247524032: {
                Base[] baseArray;
                if (this.statusDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.statusDate;
                }
                return baseArray;
            }
            case 2051346646: {
                Base[] baseArray;
                if (this.statusReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.statusReason;
                }
                return baseArray;
            }
            case -1406328437: {
                Base[] baseArray;
                if (this.author == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.author;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.priority;
                }
                return baseArray;
            }
            case 874544034: {
                return this.addresses == null ? new Base[]{} : this.addresses.toArray(new Base[this.addresses.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1106507950: {
                return this.outcome == null ? new Base[]{} : this.outcome.toArray(new Base[this.outcome.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case 109757538: {
                this.start = (Type)value;
                break;
            }
            case -880905839: {
                this.target = (Type)value;
                break;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -892481550: {
                this.status = new GoalStatusEnumFactory().fromType(value);
                break;
            }
            case 247524032: {
                this.statusDate = this.castToDate(value);
                break;
            }
            case 2051346646: {
                this.statusReason = this.castToCodeableConcept(value);
                break;
            }
            case -1406328437: {
                this.author = this.castToReference(value);
                break;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                break;
            }
            case 874544034: {
                this.getAddresses().add(this.castToReference(value));
                break;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                break;
            }
            case -1106507950: {
                this.getOutcome().add((GoalOutcomeComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("start[x]")) {
            this.start = (Type)value;
        } else if (name.equals("target[x]")) {
            this.target = (Type)value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new GoalStatusEnumFactory().fromType(value);
        } else if (name.equals("statusDate")) {
            this.statusDate = this.castToDate(value);
        } else if (name.equals("statusReason")) {
            this.statusReason = this.castToCodeableConcept(value);
        } else if (name.equals("author")) {
            this.author = this.castToReference(value);
        } else if (name.equals("priority")) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals("addresses")) {
            this.getAddresses().add(this.castToReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("outcome")) {
            this.getOutcome().add((GoalOutcomeComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1316793566: {
                return this.getStart();
            }
            case -815579825: {
                return this.getTarget();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 247524032: {
                throw new FHIRException("Cannot make property statusDate as it is not a complex type");
            }
            case 2051346646: {
                return this.getStatusReason();
            }
            case -1406328437: {
                return this.getAuthor();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case 874544034: {
                return this.addAddresses();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1106507950: {
                return this.addOutcome();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("startDate")) {
            this.start = new DateType();
            return this.start;
        }
        if (name.equals("startCodeableConcept")) {
            this.start = new CodeableConcept();
            return this.start;
        }
        if (name.equals("targetDate")) {
            this.target = new DateType();
            return this.target;
        }
        if (name.equals("targetDuration")) {
            this.target = new Duration();
            return this.target;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property Goal.description");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Goal.status");
        }
        if (name.equals("statusDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Goal.statusDate");
        }
        if (name.equals("statusReason")) {
            this.statusReason = new CodeableConcept();
            return this.statusReason;
        }
        if (name.equals("author")) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals("addresses")) {
            return this.addAddresses();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("outcome")) {
            return this.addOutcome();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Goal";
    }

    @Override
    public Goal copy() {
        Goal dst = new Goal();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.start = this.start == null ? null : this.start.copy();
        Type type = dst.target = this.target == null ? null : this.target.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.description = this.description == null ? null : this.description.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.statusDate = this.statusDate == null ? null : this.statusDate.copy();
        dst.statusReason = this.statusReason == null ? null : this.statusReason.copy();
        dst.author = this.author == null ? null : this.author.copy();
        CodeableConcept codeableConcept = dst.priority = this.priority == null ? null : this.priority.copy();
        if (this.addresses != null) {
            dst.addresses = new ArrayList<Reference>();
            for (Reference reference : this.addresses) {
                dst.addresses.add(reference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.outcome != null) {
            dst.outcome = new ArrayList<GoalOutcomeComponent>();
            for (GoalOutcomeComponent goalOutcomeComponent : this.outcome) {
                dst.outcome.add(goalOutcomeComponent.copy());
            }
        }
        return dst;
    }

    protected Goal typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Goal)) {
            return false;
        }
        Goal o = (Goal)other;
        return Goal.compareDeep(this.identifier, o.identifier, true) && Goal.compareDeep(this.subject, o.subject, true) && Goal.compareDeep(this.start, o.start, true) && Goal.compareDeep(this.target, o.target, true) && Goal.compareDeep(this.category, o.category, true) && Goal.compareDeep(this.description, o.description, true) && Goal.compareDeep(this.status, o.status, true) && Goal.compareDeep(this.statusDate, o.statusDate, true) && Goal.compareDeep(this.statusReason, o.statusReason, true) && Goal.compareDeep(this.author, o.author, true) && Goal.compareDeep(this.priority, o.priority, true) && Goal.compareDeep(this.addresses, o.addresses, true) && Goal.compareDeep(this.note, o.note, true) && Goal.compareDeep(this.outcome, o.outcome, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Goal)) {
            return false;
        }
        Goal o = (Goal)other;
        return Goal.compareValues(this.description, o.description, true) && Goal.compareValues(this.status, o.status, true) && Goal.compareValues(this.statusDate, o.statusDate, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.start != null && !this.start.isEmpty() || this.target != null && !this.target.isEmpty() || this.category != null && !this.category.isEmpty() || this.description != null && !this.description.isEmpty() || this.status != null && !this.status.isEmpty() || this.statusDate != null && !this.statusDate.isEmpty() || this.statusReason != null && !this.statusReason.isEmpty() || this.author != null && !this.author.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.addresses != null && !this.addresses.isEmpty() || this.note != null && !this.note.isEmpty() || this.outcome != null && !this.outcome.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Goal;
    }

    @Block
    public static class GoalOutcomeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="result", type={CodeableConcept.class, Observation.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code or observation that resulted from goal", formalDefinition="Details of what's changed (or not changed).")
        protected Type result;
        private static final long serialVersionUID = 1994317639L;

        public Type getResult() {
            return this.result;
        }

        public CodeableConcept getResultCodeableConcept() throws FHIRException {
            if (!(this.result instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.result.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.result;
        }

        public boolean hasResultCodeableConcept() {
            return this.result instanceof CodeableConcept;
        }

        public Reference getResultReference() throws FHIRException {
            if (!(this.result instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.result.getClass().getName() + " was encountered");
            }
            return (Reference)this.result;
        }

        public boolean hasResultReference() {
            return this.result instanceof Reference;
        }

        public boolean hasResult() {
            return this.result != null && !this.result.isEmpty();
        }

        public GoalOutcomeComponent setResult(Type value) {
            this.result = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("result[x]", "CodeableConcept|Reference(Observation)", "Details of what's changed (or not changed).", 0, Integer.MAX_VALUE, this.result));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    Base[] baseArray;
                    if (this.result == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.result;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -934426595: {
                    this.result = (Type)value;
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("result[x]")) {
                this.result = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1819555005: {
                    return this.getResult();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("resultCodeableConcept")) {
                this.result = new CodeableConcept();
                return this.result;
            }
            if (name.equals("resultReference")) {
                this.result = new Reference();
                return this.result;
            }
            return super.addChild(name);
        }

        @Override
        public GoalOutcomeComponent copy() {
            GoalOutcomeComponent dst = new GoalOutcomeComponent();
            this.copyValues(dst);
            dst.result = this.result == null ? null : this.result.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof GoalOutcomeComponent)) {
                return false;
            }
            GoalOutcomeComponent o = (GoalOutcomeComponent)other;
            return GoalOutcomeComponent.compareDeep(this.result, o.result, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof GoalOutcomeComponent)) {
                return false;
            }
            GoalOutcomeComponent o = (GoalOutcomeComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.result == null || this.result.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Goal.outcome";
        }
    }

    public static class GoalStatusEnumFactory
    implements EnumFactory<GoalStatus> {
        @Override
        public GoalStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return GoalStatus.PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return GoalStatus.PLANNED;
            }
            if ("accepted".equals(codeString)) {
                return GoalStatus.ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return GoalStatus.REJECTED;
            }
            if ("in-progress".equals(codeString)) {
                return GoalStatus.INPROGRESS;
            }
            if ("achieved".equals(codeString)) {
                return GoalStatus.ACHIEVED;
            }
            if ("sustaining".equals(codeString)) {
                return GoalStatus.SUSTAINING;
            }
            if ("on-hold".equals(codeString)) {
                return GoalStatus.ONHOLD;
            }
            if ("cancelled".equals(codeString)) {
                return GoalStatus.CANCELLED;
            }
            throw new IllegalArgumentException("Unknown GoalStatus code '" + codeString + "'");
        }

        public Enumeration<GoalStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.PROPOSED);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.PLANNED);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.ACCEPTED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.REJECTED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.INPROGRESS);
            }
            if ("achieved".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.ACHIEVED);
            }
            if ("sustaining".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.SUSTAINING);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.ONHOLD);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<GoalStatus>(this, GoalStatus.CANCELLED);
            }
            throw new FHIRException("Unknown GoalStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(GoalStatus code) {
            if (code == GoalStatus.PROPOSED) {
                return "proposed";
            }
            if (code == GoalStatus.PLANNED) {
                return "planned";
            }
            if (code == GoalStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == GoalStatus.REJECTED) {
                return "rejected";
            }
            if (code == GoalStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == GoalStatus.ACHIEVED) {
                return "achieved";
            }
            if (code == GoalStatus.SUSTAINING) {
                return "sustaining";
            }
            if (code == GoalStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == GoalStatus.CANCELLED) {
                return "cancelled";
            }
            return "?";
        }

        @Override
        public String toSystem(GoalStatus code) {
            return code.getSystem();
        }
    }

    public static enum GoalStatus {
        PROPOSED,
        PLANNED,
        ACCEPTED,
        REJECTED,
        INPROGRESS,
        ACHIEVED,
        SUSTAINING,
        ONHOLD,
        CANCELLED,
        NULL;


        public static GoalStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("achieved".equals(codeString)) {
                return ACHIEVED;
            }
            if ("sustaining".equals(codeString)) {
                return SUSTAINING;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            throw new FHIRException("Unknown GoalStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case PLANNED: {
                    return "planned";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case REJECTED: {
                    return "rejected";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ACHIEVED: {
                    return "achieved";
                }
                case SUSTAINING: {
                    return "sustaining";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case PLANNED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case ACHIEVED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case SUSTAINING: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/goal-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "A goal is proposed for this patient";
                }
                case PLANNED: {
                    return "A goal is planned for this patient";
                }
                case ACCEPTED: {
                    return "A proposed goal was accepted";
                }
                case REJECTED: {
                    return "A proposed goal was rejected";
                }
                case INPROGRESS: {
                    return "The goal is being sought but has not yet been reached.  (Also applies if goal was reached in the past but there has been regression and goal is being sought again)";
                }
                case ACHIEVED: {
                    return "The goal has been met and no further action is needed";
                }
                case SUSTAINING: {
                    return "The goal has been met, but ongoing activity is needed to sustain the goal objective";
                }
                case ONHOLD: {
                    return "The goal remains a long term objective but is no longer being actively pursued for a temporary period of time.";
                }
                case CANCELLED: {
                    return "The goal is no longer being sought";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case PLANNED: {
                    return "Planned";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ACHIEVED: {
                    return "Achieved";
                }
                case SUSTAINING: {
                    return "Sustaining";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

