/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.ListResource;
import org.hl7.fhir.dstu2016may.model.Measure;
import org.hl7.fhir.dstu2016may.model.Organization;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="MeasureReport", profile="http://hl7.org/fhir/Profile/MeasureReport")
public class MeasureReport
extends DomainResource {
    @Child(name="measure", type={Measure.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Measure that was evaluated", formalDefinition="A reference to the Measure that was evaluated to produce this report.")
    protected Reference measure;
    protected Measure measureTarget;
    @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="individual | patient-list | summary", formalDefinition="The type of measure report. This may be an individual report, which provides a single patient's score for the measure, a patient listing, which returns the list of patients that meet the various criteria in the measure, or a summary report, which returns a population count for each criteria in the measure.")
    protected Enumeration<MeasureReportType> type;
    @Child(name="patient", type={Patient.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Optional Patient", formalDefinition="Optional Patient if the report was requested for a single patient.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="period", type={Period.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reporting period", formalDefinition="The reporting period for which the report was calculated.")
    protected Period period;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="complete | pending | error", formalDefinition="The report status. No data will be available until the report status is complete.")
    protected Enumeration<MeasureReportStatus> status;
    @Child(name="date", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date the report was generated", formalDefinition="The date this measure report was generated.")
    protected DateTimeType date;
    @Child(name="reportingOrganization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reporting Organization", formalDefinition="Reporting Organization.")
    protected Reference reportingOrganization;
    protected Organization reportingOrganizationTarget;
    @Child(name="group", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Measure results for each group", formalDefinition="The results of the calculation, one for each population group in the measure.")
    protected List<MeasureReportGroupComponent> group;
    @Child(name="evaluatedResources", type={Bundle.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Evaluated Resources", formalDefinition="A reference to a Bundle containing the Resources that were used in the evaluation of this report.")
    protected Reference evaluatedResources;
    protected Bundle evaluatedResourcesTarget;
    private static final long serialVersionUID = -891268298L;
    @SearchParamDefinition(name="patient", path="MeasureReport.patient", description="The identity of a patient to search for individual measure report results for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MeasureReport:patient").toLocked();

    public MeasureReport() {
    }

    public MeasureReport(Reference measure, Enumeration<MeasureReportType> type, Period period, Enumeration<MeasureReportStatus> status) {
        this.measure = measure;
        this.type = type;
        this.period = period;
        this.status = status;
    }

    public Reference getMeasure() {
        if (this.measure == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.measure");
            }
            if (Configuration.doAutoCreate()) {
                this.measure = new Reference();
            }
        }
        return this.measure;
    }

    public boolean hasMeasure() {
        return this.measure != null && !this.measure.isEmpty();
    }

    public MeasureReport setMeasure(Reference value) {
        this.measure = value;
        return this;
    }

    public Measure getMeasureTarget() {
        if (this.measureTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.measure");
            }
            if (Configuration.doAutoCreate()) {
                this.measureTarget = new Measure();
            }
        }
        return this.measureTarget;
    }

    public MeasureReport setMeasureTarget(Measure value) {
        this.measureTarget = value;
        return this;
    }

    public Enumeration<MeasureReportType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<MeasureReportType>(new MeasureReportTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public MeasureReport setTypeElement(Enumeration<MeasureReportType> value) {
        this.type = value;
        return this;
    }

    public MeasureReportType getType() {
        return this.type == null ? null : (MeasureReportType)((Object)this.type.getValue());
    }

    public MeasureReport setType(MeasureReportType value) {
        if (this.type == null) {
            this.type = new Enumeration<MeasureReportType>(new MeasureReportTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public MeasureReport setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public MeasureReport setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public MeasureReport setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Enumeration<MeasureReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MeasureReportStatus>(new MeasureReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MeasureReport setStatusElement(Enumeration<MeasureReportStatus> value) {
        this.status = value;
        return this;
    }

    public MeasureReportStatus getStatus() {
        return this.status == null ? null : (MeasureReportStatus)((Object)this.status.getValue());
    }

    public MeasureReport setStatus(MeasureReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<MeasureReportStatus>(new MeasureReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public MeasureReport setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public MeasureReport setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getReportingOrganization() {
        if (this.reportingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.reportingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.reportingOrganization = new Reference();
            }
        }
        return this.reportingOrganization;
    }

    public boolean hasReportingOrganization() {
        return this.reportingOrganization != null && !this.reportingOrganization.isEmpty();
    }

    public MeasureReport setReportingOrganization(Reference value) {
        this.reportingOrganization = value;
        return this;
    }

    public Organization getReportingOrganizationTarget() {
        if (this.reportingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.reportingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.reportingOrganizationTarget = new Organization();
            }
        }
        return this.reportingOrganizationTarget;
    }

    public MeasureReport setReportingOrganizationTarget(Organization value) {
        this.reportingOrganizationTarget = value;
        return this;
    }

    public List<MeasureReportGroupComponent> getGroup() {
        if (this.group == null) {
            this.group = new ArrayList<MeasureReportGroupComponent>();
        }
        return this.group;
    }

    public boolean hasGroup() {
        if (this.group == null) {
            return false;
        }
        for (MeasureReportGroupComponent item : this.group) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MeasureReportGroupComponent addGroup() {
        MeasureReportGroupComponent t = new MeasureReportGroupComponent();
        if (this.group == null) {
            this.group = new ArrayList<MeasureReportGroupComponent>();
        }
        this.group.add(t);
        return t;
    }

    public MeasureReport addGroup(MeasureReportGroupComponent t) {
        if (t == null) {
            return this;
        }
        if (this.group == null) {
            this.group = new ArrayList<MeasureReportGroupComponent>();
        }
        this.group.add(t);
        return this;
    }

    public Reference getEvaluatedResources() {
        if (this.evaluatedResources == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.evaluatedResources");
            }
            if (Configuration.doAutoCreate()) {
                this.evaluatedResources = new Reference();
            }
        }
        return this.evaluatedResources;
    }

    public boolean hasEvaluatedResources() {
        return this.evaluatedResources != null && !this.evaluatedResources.isEmpty();
    }

    public MeasureReport setEvaluatedResources(Reference value) {
        this.evaluatedResources = value;
        return this;
    }

    public Bundle getEvaluatedResourcesTarget() {
        if (this.evaluatedResourcesTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MeasureReport.evaluatedResources");
            }
            if (Configuration.doAutoCreate()) {
                this.evaluatedResourcesTarget = new Bundle();
            }
        }
        return this.evaluatedResourcesTarget;
    }

    public MeasureReport setEvaluatedResourcesTarget(Bundle value) {
        this.evaluatedResourcesTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("measure", "Reference(Measure)", "A reference to the Measure that was evaluated to produce this report.", 0, Integer.MAX_VALUE, this.measure));
        childrenList.add(new Property("type", "code", "The type of measure report. This may be an individual report, which provides a single patient's score for the measure, a patient listing, which returns the list of patients that meet the various criteria in the measure, or a summary report, which returns a population count for each criteria in the measure.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "Optional Patient if the report was requested for a single patient.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("period", "Period", "The reporting period for which the report was calculated.", 0, Integer.MAX_VALUE, this.period));
        childrenList.add(new Property("status", "code", "The report status. No data will be available until the report status is complete.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("date", "dateTime", "The date this measure report was generated.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property("reportingOrganization", "Reference(Organization)", "Reporting Organization.", 0, Integer.MAX_VALUE, this.reportingOrganization));
        childrenList.add(new Property("group", "", "The results of the calculation, one for each population group in the measure.", 0, Integer.MAX_VALUE, this.group));
        childrenList.add(new Property("evaluatedResources", "Reference(Bundle)", "A reference to a Bundle containing the Resources that were used in the evaluation of this report.", 0, Integer.MAX_VALUE, this.evaluatedResources));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 938321246: {
                Base[] baseArray;
                if (this.measure == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.measure;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.patient;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case -2053950847: {
                Base[] baseArray;
                if (this.reportingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.reportingOrganization;
                }
                return baseArray;
            }
            case 98629247: {
                return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
            }
            case 1599836026: {
                Base[] baseArray;
                if (this.evaluatedResources == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.evaluatedResources;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 938321246: {
                this.measure = this.castToReference(value);
                break;
            }
            case 3575610: {
                this.type = new MeasureReportTypeEnumFactory().fromType(value);
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                break;
            }
            case -892481550: {
                this.status = new MeasureReportStatusEnumFactory().fromType(value);
                break;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                break;
            }
            case -2053950847: {
                this.reportingOrganization = this.castToReference(value);
                break;
            }
            case 98629247: {
                this.getGroup().add((MeasureReportGroupComponent)value);
                break;
            }
            case 1599836026: {
                this.evaluatedResources = this.castToReference(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("measure")) {
            this.measure = this.castToReference(value);
        } else if (name.equals("type")) {
            this.type = new MeasureReportTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals("status")) {
            this.status = new MeasureReportStatusEnumFactory().fromType(value);
        } else if (name.equals("date")) {
            this.date = this.castToDateTime(value);
        } else if (name.equals("reportingOrganization")) {
            this.reportingOrganization = this.castToReference(value);
        } else if (name.equals("group")) {
            this.getGroup().add((MeasureReportGroupComponent)value);
        } else if (name.equals("evaluatedResources")) {
            this.evaluatedResources = this.castToReference(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 938321246: {
                return this.getMeasure();
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case -791418107: {
                return this.getPatient();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -892481550: {
                throw new FHIRException("Cannot make property status as it is not a complex type");
            }
            case 3076014: {
                throw new FHIRException("Cannot make property date as it is not a complex type");
            }
            case -2053950847: {
                return this.getReportingOrganization();
            }
            case 98629247: {
                return this.addGroup();
            }
            case 1599836026: {
                return this.getEvaluatedResources();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("measure")) {
            this.measure = new Reference();
            return this.measure;
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.type");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.status");
        }
        if (name.equals("date")) {
            throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.date");
        }
        if (name.equals("reportingOrganization")) {
            this.reportingOrganization = new Reference();
            return this.reportingOrganization;
        }
        if (name.equals("group")) {
            return this.addGroup();
        }
        if (name.equals("evaluatedResources")) {
            this.evaluatedResources = new Reference();
            return this.evaluatedResources;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MeasureReport";
    }

    @Override
    public MeasureReport copy() {
        MeasureReport dst = new MeasureReport();
        this.copyValues(dst);
        dst.measure = this.measure == null ? null : this.measure.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.date = this.date == null ? null : this.date.copy();
        Reference reference = dst.reportingOrganization = this.reportingOrganization == null ? null : this.reportingOrganization.copy();
        if (this.group != null) {
            dst.group = new ArrayList<MeasureReportGroupComponent>();
            for (MeasureReportGroupComponent i : this.group) {
                dst.group.add(i.copy());
            }
        }
        dst.evaluatedResources = this.evaluatedResources == null ? null : this.evaluatedResources.copy();
        return dst;
    }

    protected MeasureReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof MeasureReport)) {
            return false;
        }
        MeasureReport o = (MeasureReport)other;
        return MeasureReport.compareDeep(this.measure, o.measure, true) && MeasureReport.compareDeep(this.type, o.type, true) && MeasureReport.compareDeep(this.patient, o.patient, true) && MeasureReport.compareDeep(this.period, o.period, true) && MeasureReport.compareDeep(this.status, o.status, true) && MeasureReport.compareDeep(this.date, o.date, true) && MeasureReport.compareDeep(this.reportingOrganization, o.reportingOrganization, true) && MeasureReport.compareDeep(this.group, o.group, true) && MeasureReport.compareDeep(this.evaluatedResources, o.evaluatedResources, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof MeasureReport)) {
            return false;
        }
        MeasureReport o = (MeasureReport)other;
        return MeasureReport.compareValues(this.type, o.type, true) && MeasureReport.compareValues(this.status, o.status, true) && MeasureReport.compareValues(this.date, o.date, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.measure != null && !this.measure.isEmpty() || this.type != null && !this.type.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.period != null && !this.period.isEmpty() || this.status != null && !this.status.isEmpty() || this.date != null && !this.date.isEmpty() || this.reportingOrganization != null && !this.reportingOrganization.isEmpty() || this.group != null && !this.group.isEmpty() || this.evaluatedResources != null && !this.evaluatedResources.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MeasureReport;
    }

    @Block
    public static class MeasureReportGroupSupplementalDataGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The data value, e.g. male", formalDefinition="The value for this supplemental data element, expressed as a string.  When defining supplemental data  on complex values, the value must be rendered such that the value for each group within the supplemental data element is unique.")
        protected StringType value;
        @Child(name="count", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of members in the group", formalDefinition="The number of members in the supplemental data group.")
        protected IntegerType count;
        @Child(name="patients", type={ListResource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For patient-list reports, the patients in this population", formalDefinition="This element refers to a List of patient level MeasureReport resources, one for each patient in this population.")
        protected Reference patients;
        protected ListResource patientsTarget;
        private static final long serialVersionUID = 1011446829L;

        public MeasureReportGroupSupplementalDataGroupComponent() {
        }

        public MeasureReportGroupSupplementalDataGroupComponent(StringType value) {
            this.value = value;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupSupplementalDataGroupComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MeasureReportGroupSupplementalDataGroupComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public MeasureReportGroupSupplementalDataGroupComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupSupplementalDataGroupComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public MeasureReportGroupSupplementalDataGroupComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public MeasureReportGroupSupplementalDataGroupComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        public Reference getPatients() {
            if (this.patients == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupSupplementalDataGroupComponent.patients");
                }
                if (Configuration.doAutoCreate()) {
                    this.patients = new Reference();
                }
            }
            return this.patients;
        }

        public boolean hasPatients() {
            return this.patients != null && !this.patients.isEmpty();
        }

        public MeasureReportGroupSupplementalDataGroupComponent setPatients(Reference value) {
            this.patients = value;
            return this;
        }

        public ListResource getPatientsTarget() {
            if (this.patientsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupSupplementalDataGroupComponent.patients");
                }
                if (Configuration.doAutoCreate()) {
                    this.patientsTarget = new ListResource();
                }
            }
            return this.patientsTarget;
        }

        public MeasureReportGroupSupplementalDataGroupComponent setPatientsTarget(ListResource value) {
            this.patientsTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("value", "string", "The value for this supplemental data element, expressed as a string.  When defining supplemental data  on complex values, the value must be rendered such that the value for each group within the supplemental data element is unique.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("count", "integer", "The number of members in the supplemental data group.", 0, Integer.MAX_VALUE, this.count));
            childrenList.add(new Property("patients", "Reference(List)", "This element refers to a List of patient level MeasureReport resources, one for each patient in this population.", 0, Integer.MAX_VALUE, this.patients));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
                case 1235842574: {
                    Base[] baseArray;
                    if (this.patients == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.patients;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                case 94851343: {
                    this.count = this.castToInteger(value);
                    break;
                }
                case 1235842574: {
                    this.patients = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value")) {
                this.value = this.castToString(value);
            } else if (name.equals("count")) {
                this.count = this.castToInteger(value);
            } else if (name.equals("patients")) {
                this.patients = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
                case 94851343: {
                    throw new FHIRException("Cannot make property count as it is not a complex type");
                }
                case 1235842574: {
                    return this.getPatients();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.value");
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.count");
            }
            if (name.equals("patients")) {
                this.patients = new Reference();
                return this.patients;
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupSupplementalDataGroupComponent copy() {
            MeasureReportGroupSupplementalDataGroupComponent dst = new MeasureReportGroupSupplementalDataGroupComponent();
            this.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
            dst.count = this.count == null ? null : this.count.copy();
            dst.patients = this.patients == null ? null : this.patients.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupSupplementalDataGroupComponent)) {
                return false;
            }
            MeasureReportGroupSupplementalDataGroupComponent o = (MeasureReportGroupSupplementalDataGroupComponent)other;
            return MeasureReportGroupSupplementalDataGroupComponent.compareDeep(this.value, o.value, true) && MeasureReportGroupSupplementalDataGroupComponent.compareDeep(this.count, o.count, true) && MeasureReportGroupSupplementalDataGroupComponent.compareDeep(this.patients, o.patients, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupSupplementalDataGroupComponent)) {
                return false;
            }
            MeasureReportGroupSupplementalDataGroupComponent o = (MeasureReportGroupSupplementalDataGroupComponent)other;
            return MeasureReportGroupSupplementalDataGroupComponent.compareValues(this.value, o.value, true) && MeasureReportGroupSupplementalDataGroupComponent.compareValues(this.count, o.count, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.value != null && !this.value.isEmpty() || this.count != null && !this.count.isEmpty() || this.patients != null && !this.patients.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.supplementalData.group";
        }
    }

    @Block
    public static class MeasureReportGroupSupplementalDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of the supplemental data element", formalDefinition="The identifier of the supplemental data element as defined in the measure.")
        protected Identifier identifier;
        @Child(name="group", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supplemental data results, one for each unique supplemental data value", formalDefinition="This element contains the results for a single value within the supplemental data. For example, when reporting supplemental data for administrative gender, there will be four groups, one for each possible gender value.")
        protected List<MeasureReportGroupSupplementalDataGroupComponent> group;
        private static final long serialVersionUID = -1254392714L;

        public MeasureReportGroupSupplementalDataComponent() {
        }

        public MeasureReportGroupSupplementalDataComponent(Identifier identifier) {
            this.identifier = identifier;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupSupplementalDataComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureReportGroupSupplementalDataComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public List<MeasureReportGroupSupplementalDataGroupComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<MeasureReportGroupSupplementalDataGroupComponent>();
            }
            return this.group;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (MeasureReportGroupSupplementalDataGroupComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureReportGroupSupplementalDataGroupComponent addGroup() {
            MeasureReportGroupSupplementalDataGroupComponent t = new MeasureReportGroupSupplementalDataGroupComponent();
            if (this.group == null) {
                this.group = new ArrayList<MeasureReportGroupSupplementalDataGroupComponent>();
            }
            this.group.add(t);
            return t;
        }

        public MeasureReportGroupSupplementalDataComponent addGroup(MeasureReportGroupSupplementalDataGroupComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<MeasureReportGroupSupplementalDataGroupComponent>();
            }
            this.group.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("identifier", "Identifier", "The identifier of the supplemental data element as defined in the measure.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("group", "", "This element contains the results for a single value within the supplemental data. For example, when reporting supplemental data for administrative gender, there will be four groups, one for each possible gender value.", 0, Integer.MAX_VALUE, this.group));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 98629247: {
                    return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    break;
                }
                case 98629247: {
                    this.getGroup().add((MeasureReportGroupSupplementalDataGroupComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("group")) {
                this.getGroup().add((MeasureReportGroupSupplementalDataGroupComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 98629247: {
                    return this.addGroup();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupSupplementalDataComponent copy() {
            MeasureReportGroupSupplementalDataComponent dst = new MeasureReportGroupSupplementalDataComponent();
            this.copyValues(dst);
            Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
            if (this.group != null) {
                dst.group = new ArrayList<MeasureReportGroupSupplementalDataGroupComponent>();
                for (MeasureReportGroupSupplementalDataGroupComponent i : this.group) {
                    dst.group.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupSupplementalDataComponent)) {
                return false;
            }
            MeasureReportGroupSupplementalDataComponent o = (MeasureReportGroupSupplementalDataComponent)other;
            return MeasureReportGroupSupplementalDataComponent.compareDeep(this.identifier, o.identifier, true) && MeasureReportGroupSupplementalDataComponent.compareDeep(this.group, o.group, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupSupplementalDataComponent)) {
                return false;
            }
            MeasureReportGroupSupplementalDataComponent o = (MeasureReportGroupSupplementalDataComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.group != null && !this.group.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.supplementalData";
        }
    }

    @Block
    public static class MeasureReportGroupStratifierGroupPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="initial-population | numerator | numerator-exclusion | denominator | denominator-exclusion | denominator-exception | measure-population | measure-population-exclusion | measure-score", formalDefinition="The type of the population.")
        protected CodeType type;
        @Child(name="count", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Size of the population", formalDefinition="The number of members of the population in this stratum.")
        protected IntegerType count;
        @Child(name="patients", type={ListResource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For patient-list reports, the patients in this population", formalDefinition="This element refers to a List of patient level MeasureReport resources, one for each patient in this population in this stratum.")
        protected Reference patients;
        protected ListResource patientsTarget;
        private static final long serialVersionUID = 407500224L;

        public MeasureReportGroupStratifierGroupPopulationComponent() {
        }

        public MeasureReportGroupStratifierGroupPopulationComponent(CodeType type) {
            this.type = type;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupStratifierGroupPopulationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MeasureReportGroupStratifierGroupPopulationComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public MeasureReportGroupStratifierGroupPopulationComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupStratifierGroupPopulationComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public MeasureReportGroupStratifierGroupPopulationComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public MeasureReportGroupStratifierGroupPopulationComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        public Reference getPatients() {
            if (this.patients == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupStratifierGroupPopulationComponent.patients");
                }
                if (Configuration.doAutoCreate()) {
                    this.patients = new Reference();
                }
            }
            return this.patients;
        }

        public boolean hasPatients() {
            return this.patients != null && !this.patients.isEmpty();
        }

        public MeasureReportGroupStratifierGroupPopulationComponent setPatients(Reference value) {
            this.patients = value;
            return this;
        }

        public ListResource getPatientsTarget() {
            if (this.patientsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupStratifierGroupPopulationComponent.patients");
                }
                if (Configuration.doAutoCreate()) {
                    this.patientsTarget = new ListResource();
                }
            }
            return this.patientsTarget;
        }

        public MeasureReportGroupStratifierGroupPopulationComponent setPatientsTarget(ListResource value) {
            this.patientsTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "The type of the population.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("count", "integer", "The number of members of the population in this stratum.", 0, Integer.MAX_VALUE, this.count));
            childrenList.add(new Property("patients", "Reference(List)", "This element refers to a List of patient level MeasureReport resources, one for each patient in this population in this stratum.", 0, Integer.MAX_VALUE, this.patients));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
                case 1235842574: {
                    Base[] baseArray;
                    if (this.patients == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.patients;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCode(value);
                    break;
                }
                case 94851343: {
                    this.count = this.castToInteger(value);
                    break;
                }
                case 1235842574: {
                    this.patients = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("count")) {
                this.count = this.castToInteger(value);
            } else if (name.equals("patients")) {
                this.patients = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 94851343: {
                    throw new FHIRException("Cannot make property count as it is not a complex type");
                }
                case 1235842574: {
                    return this.getPatients();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.type");
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.count");
            }
            if (name.equals("patients")) {
                this.patients = new Reference();
                return this.patients;
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupStratifierGroupPopulationComponent copy() {
            MeasureReportGroupStratifierGroupPopulationComponent dst = new MeasureReportGroupStratifierGroupPopulationComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.count = this.count == null ? null : this.count.copy();
            dst.patients = this.patients == null ? null : this.patients.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupStratifierGroupPopulationComponent)) {
                return false;
            }
            MeasureReportGroupStratifierGroupPopulationComponent o = (MeasureReportGroupStratifierGroupPopulationComponent)other;
            return MeasureReportGroupStratifierGroupPopulationComponent.compareDeep(this.type, o.type, true) && MeasureReportGroupStratifierGroupPopulationComponent.compareDeep(this.count, o.count, true) && MeasureReportGroupStratifierGroupPopulationComponent.compareDeep(this.patients, o.patients, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupStratifierGroupPopulationComponent)) {
                return false;
            }
            MeasureReportGroupStratifierGroupPopulationComponent o = (MeasureReportGroupStratifierGroupPopulationComponent)other;
            return MeasureReportGroupStratifierGroupPopulationComponent.compareValues(this.type, o.type, true) && MeasureReportGroupStratifierGroupPopulationComponent.compareValues(this.count, o.count, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.count != null && !this.count.isEmpty() || this.patients != null && !this.patients.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.stratifier.group.population";
        }
    }

    @Block
    public static class MeasureReportGroupStratifierGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The stratum value, e.g. male", formalDefinition="The value for this stratum, expressed as a string. When defining stratifiers on complex values, the value must be rendered such that the value for each stratum within the stratifier is unique.")
        protected StringType value;
        @Child(name="population", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Population results in this stratum", formalDefinition="The populations that make up the stratum, one for each type of population appropriate to the measure.")
        protected List<MeasureReportGroupStratifierGroupPopulationComponent> population;
        @Child(name="measureScore", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The measure score", formalDefinition="The measure score for this stratum.")
        protected DecimalType measureScore;
        private static final long serialVersionUID = -1663404087L;

        public MeasureReportGroupStratifierGroupComponent() {
        }

        public MeasureReportGroupStratifierGroupComponent(StringType value) {
            this.value = value;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupStratifierGroupComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public MeasureReportGroupStratifierGroupComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public MeasureReportGroupStratifierGroupComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        public List<MeasureReportGroupStratifierGroupPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupStratifierGroupPopulationComponent>();
            }
            return this.population;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MeasureReportGroupStratifierGroupPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureReportGroupStratifierGroupPopulationComponent addPopulation() {
            MeasureReportGroupStratifierGroupPopulationComponent t = new MeasureReportGroupStratifierGroupPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupStratifierGroupPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MeasureReportGroupStratifierGroupComponent addPopulation(MeasureReportGroupStratifierGroupPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupStratifierGroupPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public DecimalType getMeasureScoreElement() {
            if (this.measureScore == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupStratifierGroupComponent.measureScore");
                }
                if (Configuration.doAutoCreate()) {
                    this.measureScore = new DecimalType();
                }
            }
            return this.measureScore;
        }

        public boolean hasMeasureScoreElement() {
            return this.measureScore != null && !this.measureScore.isEmpty();
        }

        public boolean hasMeasureScore() {
            return this.measureScore != null && !this.measureScore.isEmpty();
        }

        public MeasureReportGroupStratifierGroupComponent setMeasureScoreElement(DecimalType value) {
            this.measureScore = value;
            return this;
        }

        public BigDecimal getMeasureScore() {
            return this.measureScore == null ? null : (BigDecimal)this.measureScore.getValue();
        }

        public MeasureReportGroupStratifierGroupComponent setMeasureScore(BigDecimal value) {
            if (value == null) {
                this.measureScore = null;
            } else {
                if (this.measureScore == null) {
                    this.measureScore = new DecimalType();
                }
                this.measureScore.setValue(value);
            }
            return this;
        }

        public MeasureReportGroupStratifierGroupComponent setMeasureScore(long value) {
            this.measureScore = new DecimalType();
            this.measureScore.setValue(value);
            return this;
        }

        public MeasureReportGroupStratifierGroupComponent setMeasureScore(double value) {
            this.measureScore = new DecimalType();
            this.measureScore.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("value", "string", "The value for this stratum, expressed as a string. When defining stratifiers on complex values, the value must be rendered such that the value for each stratum within the stratifier is unique.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("population", "", "The populations that make up the stratum, one for each type of population appropriate to the measure.", 0, Integer.MAX_VALUE, this.population));
            childrenList.add(new Property("measureScore", "decimal", "The measure score for this stratum.", 0, Integer.MAX_VALUE, this.measureScore));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
                case -386313260: {
                    Base[] baseArray;
                    if (this.measureScore == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.measureScore;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = this.castToString(value);
                    break;
                }
                case -2023558323: {
                    this.getPopulation().add((MeasureReportGroupStratifierGroupPopulationComponent)value);
                    break;
                }
                case -386313260: {
                    this.measureScore = this.castToDecimal(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value")) {
                this.value = this.castToString(value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MeasureReportGroupStratifierGroupPopulationComponent)value);
            } else if (name.equals("measureScore")) {
                this.measureScore = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    throw new FHIRException("Cannot make property value as it is not a complex type");
                }
                case -2023558323: {
                    return this.addPopulation();
                }
                case -386313260: {
                    throw new FHIRException("Cannot make property measureScore as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.value");
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            if (name.equals("measureScore")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.measureScore");
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupStratifierGroupComponent copy() {
            MeasureReportGroupStratifierGroupComponent dst = new MeasureReportGroupStratifierGroupComponent();
            this.copyValues(dst);
            StringType stringType = dst.value = this.value == null ? null : this.value.copy();
            if (this.population != null) {
                dst.population = new ArrayList<MeasureReportGroupStratifierGroupPopulationComponent>();
                for (MeasureReportGroupStratifierGroupPopulationComponent i : this.population) {
                    dst.population.add(i.copy());
                }
            }
            dst.measureScore = this.measureScore == null ? null : this.measureScore.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupStratifierGroupComponent)) {
                return false;
            }
            MeasureReportGroupStratifierGroupComponent o = (MeasureReportGroupStratifierGroupComponent)other;
            return MeasureReportGroupStratifierGroupComponent.compareDeep(this.value, o.value, true) && MeasureReportGroupStratifierGroupComponent.compareDeep(this.population, o.population, true) && MeasureReportGroupStratifierGroupComponent.compareDeep(this.measureScore, o.measureScore, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupStratifierGroupComponent)) {
                return false;
            }
            MeasureReportGroupStratifierGroupComponent o = (MeasureReportGroupStratifierGroupComponent)other;
            return MeasureReportGroupStratifierGroupComponent.compareValues(this.value, o.value, true) && MeasureReportGroupStratifierGroupComponent.compareValues(this.measureScore, o.measureScore, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.value != null && !this.value.isEmpty() || this.population != null && !this.population.isEmpty() || this.measureScore != null && !this.measureScore.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.stratifier.group";
        }
    }

    @Block
    public static class MeasureReportGroupStratifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of the stratifier", formalDefinition="The identifier of this stratifier, as defined in the measure definition.")
        protected Identifier identifier;
        @Child(name="group", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Stratum results, one for each unique value in the stratifier", formalDefinition="This element contains the results for a single stratum within the stratifier. For example, when stratifying on administrative gender, there will be four strata, one for each possible gender value.")
        protected List<MeasureReportGroupStratifierGroupComponent> group;
        private static final long serialVersionUID = -229867715L;

        public MeasureReportGroupStratifierComponent() {
        }

        public MeasureReportGroupStratifierComponent(Identifier identifier) {
            this.identifier = identifier;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupStratifierComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureReportGroupStratifierComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public List<MeasureReportGroupStratifierGroupComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<MeasureReportGroupStratifierGroupComponent>();
            }
            return this.group;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (MeasureReportGroupStratifierGroupComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureReportGroupStratifierGroupComponent addGroup() {
            MeasureReportGroupStratifierGroupComponent t = new MeasureReportGroupStratifierGroupComponent();
            if (this.group == null) {
                this.group = new ArrayList<MeasureReportGroupStratifierGroupComponent>();
            }
            this.group.add(t);
            return t;
        }

        public MeasureReportGroupStratifierComponent addGroup(MeasureReportGroupStratifierGroupComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<MeasureReportGroupStratifierGroupComponent>();
            }
            this.group.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("identifier", "Identifier", "The identifier of this stratifier, as defined in the measure definition.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("group", "", "This element contains the results for a single stratum within the stratifier. For example, when stratifying on administrative gender, there will be four strata, one for each possible gender value.", 0, Integer.MAX_VALUE, this.group));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 98629247: {
                    return this.group == null ? new Base[]{} : this.group.toArray(new Base[this.group.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    break;
                }
                case 98629247: {
                    this.getGroup().add((MeasureReportGroupStratifierGroupComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("group")) {
                this.getGroup().add((MeasureReportGroupStratifierGroupComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 98629247: {
                    return this.addGroup();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupStratifierComponent copy() {
            MeasureReportGroupStratifierComponent dst = new MeasureReportGroupStratifierComponent();
            this.copyValues(dst);
            Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
            if (this.group != null) {
                dst.group = new ArrayList<MeasureReportGroupStratifierGroupComponent>();
                for (MeasureReportGroupStratifierGroupComponent i : this.group) {
                    dst.group.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupStratifierComponent)) {
                return false;
            }
            MeasureReportGroupStratifierComponent o = (MeasureReportGroupStratifierComponent)other;
            return MeasureReportGroupStratifierComponent.compareDeep(this.identifier, o.identifier, true) && MeasureReportGroupStratifierComponent.compareDeep(this.group, o.group, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupStratifierComponent)) {
                return false;
            }
            MeasureReportGroupStratifierComponent o = (MeasureReportGroupStratifierComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.group != null && !this.group.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.stratifier";
        }
    }

    @Block
    public static class MeasureReportGroupPopulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="initial-population | numerator | numerator-exclusion | denominator | denominator-exclusion | denominator-exception | measure-population | measure-population-exclusion | measure-score", formalDefinition="The type of the population.")
        protected CodeType type;
        @Child(name="count", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Size of the population", formalDefinition="The number of members of the population.")
        protected IntegerType count;
        @Child(name="patients", type={ListResource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For patient-list reports, the patients in this population", formalDefinition="This element refers to a List of patient level MeasureReport resources, one for each patient in this population.")
        protected Reference patients;
        protected ListResource patientsTarget;
        private static final long serialVersionUID = 407500224L;

        public MeasureReportGroupPopulationComponent() {
        }

        public MeasureReportGroupPopulationComponent(CodeType type) {
            this.type = type;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupPopulationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MeasureReportGroupPopulationComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public MeasureReportGroupPopulationComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupPopulationComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public MeasureReportGroupPopulationComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public MeasureReportGroupPopulationComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        public Reference getPatients() {
            if (this.patients == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupPopulationComponent.patients");
                }
                if (Configuration.doAutoCreate()) {
                    this.patients = new Reference();
                }
            }
            return this.patients;
        }

        public boolean hasPatients() {
            return this.patients != null && !this.patients.isEmpty();
        }

        public MeasureReportGroupPopulationComponent setPatients(Reference value) {
            this.patients = value;
            return this;
        }

        public ListResource getPatientsTarget() {
            if (this.patientsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupPopulationComponent.patients");
                }
                if (Configuration.doAutoCreate()) {
                    this.patientsTarget = new ListResource();
                }
            }
            return this.patientsTarget;
        }

        public MeasureReportGroupPopulationComponent setPatientsTarget(ListResource value) {
            this.patientsTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "code", "The type of the population.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("count", "integer", "The number of members of the population.", 0, Integer.MAX_VALUE, this.count));
            childrenList.add(new Property("patients", "Reference(List)", "This element refers to a List of patient level MeasureReport resources, one for each patient in this population.", 0, Integer.MAX_VALUE, this.patients));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
                case 1235842574: {
                    Base[] baseArray;
                    if (this.patients == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.patients;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCode(value);
                    break;
                }
                case 94851343: {
                    this.count = this.castToInteger(value);
                    break;
                }
                case 1235842574: {
                    this.patients = this.castToReference(value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("count")) {
                this.count = this.castToInteger(value);
            } else if (name.equals("patients")) {
                this.patients = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 94851343: {
                    throw new FHIRException("Cannot make property count as it is not a complex type");
                }
                case 1235842574: {
                    return this.getPatients();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.type");
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.count");
            }
            if (name.equals("patients")) {
                this.patients = new Reference();
                return this.patients;
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupPopulationComponent copy() {
            MeasureReportGroupPopulationComponent dst = new MeasureReportGroupPopulationComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.count = this.count == null ? null : this.count.copy();
            dst.patients = this.patients == null ? null : this.patients.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupPopulationComponent)) {
                return false;
            }
            MeasureReportGroupPopulationComponent o = (MeasureReportGroupPopulationComponent)other;
            return MeasureReportGroupPopulationComponent.compareDeep(this.type, o.type, true) && MeasureReportGroupPopulationComponent.compareDeep(this.count, o.count, true) && MeasureReportGroupPopulationComponent.compareDeep(this.patients, o.patients, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupPopulationComponent)) {
                return false;
            }
            MeasureReportGroupPopulationComponent o = (MeasureReportGroupPopulationComponent)other;
            return MeasureReportGroupPopulationComponent.compareValues(this.type, o.type, true) && MeasureReportGroupPopulationComponent.compareValues(this.count, o.count, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.count != null && !this.count.isEmpty() || this.patients != null && !this.patients.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group.population";
        }
    }

    @Block
    public static class MeasureReportGroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of the population group being reported", formalDefinition="The identifier of the population group as defined in the measure definition.")
        protected Identifier identifier;
        @Child(name="population", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The populations in the group", formalDefinition="The populations that make up the population group, one for each type of population appropriate for the measure.")
        protected List<MeasureReportGroupPopulationComponent> population;
        @Child(name="measureScore", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The measure score", formalDefinition="The measure score.")
        protected DecimalType measureScore;
        @Child(name="stratifier", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Stratification results", formalDefinition="When a measure includes multiple stratifiers, there will be a stratifier group for each stratifier defined by the measure.")
        protected List<MeasureReportGroupStratifierComponent> stratifier;
        @Child(name="supplementalData", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Supplemental data elements for the measure", formalDefinition="Supplemental data elements for the measure provide additional information requested by the measure for each patient involved in the populations.")
        protected List<MeasureReportGroupSupplementalDataComponent> supplementalData;
        private static final long serialVersionUID = -832029515L;

        public MeasureReportGroupComponent() {
        }

        public MeasureReportGroupComponent(Identifier identifier) {
            this.identifier = identifier;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MeasureReportGroupComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public List<MeasureReportGroupPopulationComponent> getPopulation() {
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupPopulationComponent>();
            }
            return this.population;
        }

        public boolean hasPopulation() {
            if (this.population == null) {
                return false;
            }
            for (MeasureReportGroupPopulationComponent item : this.population) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureReportGroupPopulationComponent addPopulation() {
            MeasureReportGroupPopulationComponent t = new MeasureReportGroupPopulationComponent();
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupPopulationComponent>();
            }
            this.population.add(t);
            return t;
        }

        public MeasureReportGroupComponent addPopulation(MeasureReportGroupPopulationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.population == null) {
                this.population = new ArrayList<MeasureReportGroupPopulationComponent>();
            }
            this.population.add(t);
            return this;
        }

        public DecimalType getMeasureScoreElement() {
            if (this.measureScore == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MeasureReportGroupComponent.measureScore");
                }
                if (Configuration.doAutoCreate()) {
                    this.measureScore = new DecimalType();
                }
            }
            return this.measureScore;
        }

        public boolean hasMeasureScoreElement() {
            return this.measureScore != null && !this.measureScore.isEmpty();
        }

        public boolean hasMeasureScore() {
            return this.measureScore != null && !this.measureScore.isEmpty();
        }

        public MeasureReportGroupComponent setMeasureScoreElement(DecimalType value) {
            this.measureScore = value;
            return this;
        }

        public BigDecimal getMeasureScore() {
            return this.measureScore == null ? null : (BigDecimal)this.measureScore.getValue();
        }

        public MeasureReportGroupComponent setMeasureScore(BigDecimal value) {
            if (value == null) {
                this.measureScore = null;
            } else {
                if (this.measureScore == null) {
                    this.measureScore = new DecimalType();
                }
                this.measureScore.setValue(value);
            }
            return this;
        }

        public MeasureReportGroupComponent setMeasureScore(long value) {
            this.measureScore = new DecimalType();
            this.measureScore.setValue(value);
            return this;
        }

        public MeasureReportGroupComponent setMeasureScore(double value) {
            this.measureScore = new DecimalType();
            this.measureScore.setValue(value);
            return this;
        }

        public List<MeasureReportGroupStratifierComponent> getStratifier() {
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureReportGroupStratifierComponent>();
            }
            return this.stratifier;
        }

        public boolean hasStratifier() {
            if (this.stratifier == null) {
                return false;
            }
            for (MeasureReportGroupStratifierComponent item : this.stratifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureReportGroupStratifierComponent addStratifier() {
            MeasureReportGroupStratifierComponent t = new MeasureReportGroupStratifierComponent();
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureReportGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return t;
        }

        public MeasureReportGroupComponent addStratifier(MeasureReportGroupStratifierComponent t) {
            if (t == null) {
                return this;
            }
            if (this.stratifier == null) {
                this.stratifier = new ArrayList<MeasureReportGroupStratifierComponent>();
            }
            this.stratifier.add(t);
            return this;
        }

        public List<MeasureReportGroupSupplementalDataComponent> getSupplementalData() {
            if (this.supplementalData == null) {
                this.supplementalData = new ArrayList<MeasureReportGroupSupplementalDataComponent>();
            }
            return this.supplementalData;
        }

        public boolean hasSupplementalData() {
            if (this.supplementalData == null) {
                return false;
            }
            for (MeasureReportGroupSupplementalDataComponent item : this.supplementalData) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public MeasureReportGroupSupplementalDataComponent addSupplementalData() {
            MeasureReportGroupSupplementalDataComponent t = new MeasureReportGroupSupplementalDataComponent();
            if (this.supplementalData == null) {
                this.supplementalData = new ArrayList<MeasureReportGroupSupplementalDataComponent>();
            }
            this.supplementalData.add(t);
            return t;
        }

        public MeasureReportGroupComponent addSupplementalData(MeasureReportGroupSupplementalDataComponent t) {
            if (t == null) {
                return this;
            }
            if (this.supplementalData == null) {
                this.supplementalData = new ArrayList<MeasureReportGroupSupplementalDataComponent>();
            }
            this.supplementalData.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("identifier", "Identifier", "The identifier of the population group as defined in the measure definition.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("population", "", "The populations that make up the population group, one for each type of population appropriate for the measure.", 0, Integer.MAX_VALUE, this.population));
            childrenList.add(new Property("measureScore", "decimal", "The measure score.", 0, Integer.MAX_VALUE, this.measureScore));
            childrenList.add(new Property("stratifier", "", "When a measure includes multiple stratifiers, there will be a stratifier group for each stratifier defined by the measure.", 0, Integer.MAX_VALUE, this.stratifier));
            childrenList.add(new Property("supplementalData", "", "Supplemental data elements for the measure provide additional information requested by the measure for each patient involved in the populations.", 0, Integer.MAX_VALUE, this.supplementalData));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -2023558323: {
                    return this.population == null ? new Base[]{} : this.population.toArray(new Base[this.population.size()]);
                }
                case -386313260: {
                    Base[] baseArray;
                    if (this.measureScore == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.measureScore;
                    }
                    return baseArray;
                }
                case 90983669: {
                    return this.stratifier == null ? new Base[]{} : this.stratifier.toArray(new Base[this.stratifier.size()]);
                }
                case 1447496814: {
                    return this.supplementalData == null ? new Base[]{} : this.supplementalData.toArray(new Base[this.supplementalData.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = this.castToIdentifier(value);
                    break;
                }
                case -2023558323: {
                    this.getPopulation().add((MeasureReportGroupPopulationComponent)value);
                    break;
                }
                case -386313260: {
                    this.measureScore = this.castToDecimal(value);
                    break;
                }
                case 90983669: {
                    this.getStratifier().add((MeasureReportGroupStratifierComponent)value);
                    break;
                }
                case 1447496814: {
                    this.getSupplementalData().add((MeasureReportGroupSupplementalDataComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("population")) {
                this.getPopulation().add((MeasureReportGroupPopulationComponent)value);
            } else if (name.equals("measureScore")) {
                this.measureScore = this.castToDecimal(value);
            } else if (name.equals("stratifier")) {
                this.getStratifier().add((MeasureReportGroupStratifierComponent)value);
            } else if (name.equals("supplementalData")) {
                this.getSupplementalData().add((MeasureReportGroupSupplementalDataComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -2023558323: {
                    return this.addPopulation();
                }
                case -386313260: {
                    throw new FHIRException("Cannot make property measureScore as it is not a complex type");
                }
                case 90983669: {
                    return this.addStratifier();
                }
                case 1447496814: {
                    return this.addSupplementalData();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("population")) {
                return this.addPopulation();
            }
            if (name.equals("measureScore")) {
                throw new FHIRException("Cannot call addChild on a singleton property MeasureReport.measureScore");
            }
            if (name.equals("stratifier")) {
                return this.addStratifier();
            }
            if (name.equals("supplementalData")) {
                return this.addSupplementalData();
            }
            return super.addChild(name);
        }

        @Override
        public MeasureReportGroupComponent copy() {
            MeasureReportGroupComponent dst = new MeasureReportGroupComponent();
            this.copyValues(dst);
            Identifier identifier = dst.identifier = this.identifier == null ? null : this.identifier.copy();
            if (this.population != null) {
                dst.population = new ArrayList<MeasureReportGroupPopulationComponent>();
                for (MeasureReportGroupPopulationComponent measureReportGroupPopulationComponent : this.population) {
                    dst.population.add(measureReportGroupPopulationComponent.copy());
                }
            }
            DecimalType decimalType = dst.measureScore = this.measureScore == null ? null : this.measureScore.copy();
            if (this.stratifier != null) {
                dst.stratifier = new ArrayList<MeasureReportGroupStratifierComponent>();
                for (MeasureReportGroupStratifierComponent measureReportGroupStratifierComponent : this.stratifier) {
                    dst.stratifier.add(measureReportGroupStratifierComponent.copy());
                }
            }
            if (this.supplementalData != null) {
                dst.supplementalData = new ArrayList<MeasureReportGroupSupplementalDataComponent>();
                for (MeasureReportGroupSupplementalDataComponent measureReportGroupSupplementalDataComponent : this.supplementalData) {
                    dst.supplementalData.add(measureReportGroupSupplementalDataComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupComponent)) {
                return false;
            }
            MeasureReportGroupComponent o = (MeasureReportGroupComponent)other;
            return MeasureReportGroupComponent.compareDeep(this.identifier, o.identifier, true) && MeasureReportGroupComponent.compareDeep(this.population, o.population, true) && MeasureReportGroupComponent.compareDeep(this.measureScore, o.measureScore, true) && MeasureReportGroupComponent.compareDeep(this.stratifier, o.stratifier, true) && MeasureReportGroupComponent.compareDeep(this.supplementalData, o.supplementalData, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MeasureReportGroupComponent)) {
                return false;
            }
            MeasureReportGroupComponent o = (MeasureReportGroupComponent)other;
            return MeasureReportGroupComponent.compareValues(this.measureScore, o.measureScore, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.population != null && !this.population.isEmpty() || this.measureScore != null && !this.measureScore.isEmpty() || this.stratifier != null && !this.stratifier.isEmpty() || this.supplementalData != null && !this.supplementalData.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MeasureReport.group";
        }
    }

    public static class MeasureReportStatusEnumFactory
    implements EnumFactory<MeasureReportStatus> {
        @Override
        public MeasureReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return MeasureReportStatus.COMPLETE;
            }
            if ("pending".equals(codeString)) {
                return MeasureReportStatus.PENDING;
            }
            if ("error".equals(codeString)) {
                return MeasureReportStatus.ERROR;
            }
            throw new IllegalArgumentException("Unknown MeasureReportStatus code '" + codeString + "'");
        }

        public Enumeration<MeasureReportStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<MeasureReportStatus>(this, MeasureReportStatus.COMPLETE);
            }
            if ("pending".equals(codeString)) {
                return new Enumeration<MeasureReportStatus>(this, MeasureReportStatus.PENDING);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<MeasureReportStatus>(this, MeasureReportStatus.ERROR);
            }
            throw new FHIRException("Unknown MeasureReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasureReportStatus code) {
            if (code == MeasureReportStatus.COMPLETE) {
                return "complete";
            }
            if (code == MeasureReportStatus.PENDING) {
                return "pending";
            }
            if (code == MeasureReportStatus.ERROR) {
                return "error";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasureReportStatus code) {
            return code.getSystem();
        }
    }

    public static enum MeasureReportStatus {
        COMPLETE,
        PENDING,
        ERROR,
        NULL;


        public static MeasureReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("pending".equals(codeString)) {
                return PENDING;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            throw new FHIRException("Unknown MeasureReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case COMPLETE: {
                    return "complete";
                }
                case PENDING: {
                    return "pending";
                }
                case ERROR: {
                    return "error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case COMPLETE: {
                    return "http://hl7.org/fhir/measure-report-status";
                }
                case PENDING: {
                    return "http://hl7.org/fhir/measure-report-status";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/measure-report-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case COMPLETE: {
                    return "The report is complete and ready for use";
                }
                case PENDING: {
                    return "The report is currently being generated";
                }
                case ERROR: {
                    return "An error occurred attempting to generate the report";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case COMPLETE: {
                    return "Complete";
                }
                case PENDING: {
                    return "Pending";
                }
                case ERROR: {
                    return "Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class MeasureReportTypeEnumFactory
    implements EnumFactory<MeasureReportType> {
        @Override
        public MeasureReportType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("individual".equals(codeString)) {
                return MeasureReportType.INDIVIDUAL;
            }
            if ("patient-list".equals(codeString)) {
                return MeasureReportType.PATIENTLIST;
            }
            if ("summary".equals(codeString)) {
                return MeasureReportType.SUMMARY;
            }
            throw new IllegalArgumentException("Unknown MeasureReportType code '" + codeString + "'");
        }

        public Enumeration<MeasureReportType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("individual".equals(codeString)) {
                return new Enumeration<MeasureReportType>(this, MeasureReportType.INDIVIDUAL);
            }
            if ("patient-list".equals(codeString)) {
                return new Enumeration<MeasureReportType>(this, MeasureReportType.PATIENTLIST);
            }
            if ("summary".equals(codeString)) {
                return new Enumeration<MeasureReportType>(this, MeasureReportType.SUMMARY);
            }
            throw new FHIRException("Unknown MeasureReportType code '" + codeString + "'");
        }

        @Override
        public String toCode(MeasureReportType code) {
            if (code == MeasureReportType.INDIVIDUAL) {
                return "individual";
            }
            if (code == MeasureReportType.PATIENTLIST) {
                return "patient-list";
            }
            if (code == MeasureReportType.SUMMARY) {
                return "summary";
            }
            return "?";
        }

        @Override
        public String toSystem(MeasureReportType code) {
            return code.getSystem();
        }
    }

    public static enum MeasureReportType {
        INDIVIDUAL,
        PATIENTLIST,
        SUMMARY,
        NULL;


        public static MeasureReportType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("individual".equals(codeString)) {
                return INDIVIDUAL;
            }
            if ("patient-list".equals(codeString)) {
                return PATIENTLIST;
            }
            if ("summary".equals(codeString)) {
                return SUMMARY;
            }
            throw new FHIRException("Unknown MeasureReportType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INDIVIDUAL: {
                    return "individual";
                }
                case PATIENTLIST: {
                    return "patient-list";
                }
                case SUMMARY: {
                    return "summary";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INDIVIDUAL: {
                    return "http://hl7.org/fhir/measure-report-type";
                }
                case PATIENTLIST: {
                    return "http://hl7.org/fhir/measure-report-type";
                }
                case SUMMARY: {
                    return "http://hl7.org/fhir/measure-report-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INDIVIDUAL: {
                    return "An individual report that provides information on the performance for a given measure with respect to a single patient";
                }
                case PATIENTLIST: {
                    return "A patient list report that includes a listing of patients that satisfied each population criteria in the measure";
                }
                case SUMMARY: {
                    return "A summary report that returns the number of patients in each population criteria for the measure";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INDIVIDUAL: {
                    return "Individual";
                }
                case PATIENTLIST: {
                    return "Patient List";
                }
                case SUMMARY: {
                    return "Summary";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

