/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Group;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.PositiveIntType;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.Specimen;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Media", profile="http://hl7.org/fhir/Profile/Media")
public class Media
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier(s) for the image", formalDefinition="Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="photo | video | audio", formalDefinition="Whether the media is a photo (still image), an audio recording, or a video recording.")
    protected Enumeration<DigitalMediaType> type;
    @Child(name="subtype", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The type of acquisition equipment/process", formalDefinition="Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.")
    protected CodeableConcept subtype;
    @Child(name="view", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Imaging view, e.g. Lateral or Antero-posterior", formalDefinition="The name of the imaging view e.g. Lateral or Antero-posterior (AP).")
    protected CodeableConcept view;
    @Child(name="subject", type={Patient.class, Practitioner.class, Group.class, Device.class, Specimen.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/What this Media is a record of", formalDefinition="Who/What this Media is a record of.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="operator", type={Practitioner.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person who generated the image", formalDefinition="The person who administered the collection of the image.")
    protected Reference operator;
    protected Practitioner operatorTarget;
    @Child(name="deviceName", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the device/manufacturer", formalDefinition="The name of the device / manufacturer of the device  that was used to make the recording.")
    protected StringType deviceName;
    @Child(name="height", type={PositiveIntType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Height of the image in pixels (photo/video)", formalDefinition="Height of the image in pixels (photo/video).")
    protected PositiveIntType height;
    @Child(name="width", type={PositiveIntType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Width of the image in pixels (photo/video)", formalDefinition="Width of the image in pixels (photo/video).")
    protected PositiveIntType width;
    @Child(name="frames", type={PositiveIntType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of frames if > 1 (photo)", formalDefinition="The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.")
    protected PositiveIntType frames;
    @Child(name="duration", type={UnsignedIntType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Length in seconds (audio / video)", formalDefinition="The duration of the recording in seconds - for audio and video.")
    protected UnsignedIntType duration;
    @Child(name="content", type={Attachment.class}, order=11, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Actual Media - reference or data", formalDefinition="The actual content of the media - inline or by direct reference to the media source file.")
    protected Attachment content;
    private static final long serialVersionUID = -2144305643L;
    @SearchParamDefinition(name="patient", path="Media.subject", description="Who/What this Media is a record of", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Media:patient").toLocked();
    @SearchParamDefinition(name="created", path="Media.content.creation", description="Date attachment was first created", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="subject", path="Media.subject", description="Who/What this Media is a record of", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Media:subject").toLocked();
    @SearchParamDefinition(name="subtype", path="Media.subtype", description="The type of acquisition equipment/process", type="token")
    public static final String SP_SUBTYPE = "subtype";
    public static final TokenClientParam SUBTYPE = new TokenClientParam("subtype");
    @SearchParamDefinition(name="view", path="Media.view", description="Imaging view, e.g. Lateral or Antero-posterior", type="token")
    public static final String SP_VIEW = "view";
    public static final TokenClientParam VIEW = new TokenClientParam("view");
    @SearchParamDefinition(name="type", path="Media.type", description="photo | video | audio", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="identifier", path="Media.identifier", description="Identifier(s) for the image", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="operator", path="Media.operator", description="The person who generated the image", type="reference")
    public static final String SP_OPERATOR = "operator";
    public static final ReferenceClientParam OPERATOR = new ReferenceClientParam("operator");
    public static final Include INCLUDE_OPERATOR = new Include("Media:operator").toLocked();

    public Media() {
    }

    public Media(Enumeration<DigitalMediaType> type, Attachment content) {
        this.type = type;
        this.content = content;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Media addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<DigitalMediaType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<DigitalMediaType>(new DigitalMediaTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Media setTypeElement(Enumeration<DigitalMediaType> value) {
        this.type = value;
        return this;
    }

    public DigitalMediaType getType() {
        return this.type == null ? null : (DigitalMediaType)((Object)this.type.getValue());
    }

    public Media setType(DigitalMediaType value) {
        if (this.type == null) {
            this.type = new Enumeration<DigitalMediaType>(new DigitalMediaTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public CodeableConcept getSubtype() {
        if (this.subtype == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.subtype");
            }
            if (Configuration.doAutoCreate()) {
                this.subtype = new CodeableConcept();
            }
        }
        return this.subtype;
    }

    public boolean hasSubtype() {
        return this.subtype != null && !this.subtype.isEmpty();
    }

    public Media setSubtype(CodeableConcept value) {
        this.subtype = value;
        return this;
    }

    public CodeableConcept getView() {
        if (this.view == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.view");
            }
            if (Configuration.doAutoCreate()) {
                this.view = new CodeableConcept();
            }
        }
        return this.view;
    }

    public boolean hasView() {
        return this.view != null && !this.view.isEmpty();
    }

    public Media setView(CodeableConcept value) {
        this.view = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Media setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Media setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getOperator() {
        if (this.operator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.operator");
            }
            if (Configuration.doAutoCreate()) {
                this.operator = new Reference();
            }
        }
        return this.operator;
    }

    public boolean hasOperator() {
        return this.operator != null && !this.operator.isEmpty();
    }

    public Media setOperator(Reference value) {
        this.operator = value;
        return this;
    }

    public Practitioner getOperatorTarget() {
        if (this.operatorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.operator");
            }
            if (Configuration.doAutoCreate()) {
                this.operatorTarget = new Practitioner();
            }
        }
        return this.operatorTarget;
    }

    public Media setOperatorTarget(Practitioner value) {
        this.operatorTarget = value;
        return this;
    }

    public StringType getDeviceNameElement() {
        if (this.deviceName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.deviceName");
            }
            if (Configuration.doAutoCreate()) {
                this.deviceName = new StringType();
            }
        }
        return this.deviceName;
    }

    public boolean hasDeviceNameElement() {
        return this.deviceName != null && !this.deviceName.isEmpty();
    }

    public boolean hasDeviceName() {
        return this.deviceName != null && !this.deviceName.isEmpty();
    }

    public Media setDeviceNameElement(StringType value) {
        this.deviceName = value;
        return this;
    }

    public String getDeviceName() {
        return this.deviceName == null ? null : (String)this.deviceName.getValue();
    }

    public Media setDeviceName(String value) {
        if (Utilities.noString((String)value)) {
            this.deviceName = null;
        } else {
            if (this.deviceName == null) {
                this.deviceName = new StringType();
            }
            this.deviceName.setValue(value);
        }
        return this;
    }

    public PositiveIntType getHeightElement() {
        if (this.height == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.height");
            }
            if (Configuration.doAutoCreate()) {
                this.height = new PositiveIntType();
            }
        }
        return this.height;
    }

    public boolean hasHeightElement() {
        return this.height != null && !this.height.isEmpty();
    }

    public boolean hasHeight() {
        return this.height != null && !this.height.isEmpty();
    }

    public Media setHeightElement(PositiveIntType value) {
        this.height = value;
        return this;
    }

    public int getHeight() {
        return this.height == null || this.height.isEmpty() ? 0 : (Integer)this.height.getValue();
    }

    public Media setHeight(int value) {
        if (this.height == null) {
            this.height = new PositiveIntType();
        }
        this.height.setValue((Object)value);
        return this;
    }

    public PositiveIntType getWidthElement() {
        if (this.width == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.width");
            }
            if (Configuration.doAutoCreate()) {
                this.width = new PositiveIntType();
            }
        }
        return this.width;
    }

    public boolean hasWidthElement() {
        return this.width != null && !this.width.isEmpty();
    }

    public boolean hasWidth() {
        return this.width != null && !this.width.isEmpty();
    }

    public Media setWidthElement(PositiveIntType value) {
        this.width = value;
        return this;
    }

    public int getWidth() {
        return this.width == null || this.width.isEmpty() ? 0 : (Integer)this.width.getValue();
    }

    public Media setWidth(int value) {
        if (this.width == null) {
            this.width = new PositiveIntType();
        }
        this.width.setValue((Object)value);
        return this;
    }

    public PositiveIntType getFramesElement() {
        if (this.frames == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.frames");
            }
            if (Configuration.doAutoCreate()) {
                this.frames = new PositiveIntType();
            }
        }
        return this.frames;
    }

    public boolean hasFramesElement() {
        return this.frames != null && !this.frames.isEmpty();
    }

    public boolean hasFrames() {
        return this.frames != null && !this.frames.isEmpty();
    }

    public Media setFramesElement(PositiveIntType value) {
        this.frames = value;
        return this;
    }

    public int getFrames() {
        return this.frames == null || this.frames.isEmpty() ? 0 : (Integer)this.frames.getValue();
    }

    public Media setFrames(int value) {
        if (this.frames == null) {
            this.frames = new PositiveIntType();
        }
        this.frames.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getDurationElement() {
        if (this.duration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.duration");
            }
            if (Configuration.doAutoCreate()) {
                this.duration = new UnsignedIntType();
            }
        }
        return this.duration;
    }

    public boolean hasDurationElement() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public boolean hasDuration() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public Media setDurationElement(UnsignedIntType value) {
        this.duration = value;
        return this;
    }

    public int getDuration() {
        return this.duration == null || this.duration.isEmpty() ? 0 : (Integer)this.duration.getValue();
    }

    public Media setDuration(int value) {
        if (this.duration == null) {
            this.duration = new UnsignedIntType();
        }
        this.duration.setValue((Object)value);
        return this;
    }

    public Attachment getContent() {
        if (this.content == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Media.content");
            }
            if (Configuration.doAutoCreate()) {
                this.content = new Attachment();
            }
        }
        return this.content;
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public Media setContent(Attachment value) {
        this.content = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_TYPE, "code", "Whether the media is a photo (still image), an audio recording, or a video recording.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_SUBTYPE, "CodeableConcept", "Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.", 0, Integer.MAX_VALUE, this.subtype));
        childrenList.add(new Property(SP_VIEW, "CodeableConcept", "The name of the imaging view e.g. Lateral or Antero-posterior (AP).", 0, Integer.MAX_VALUE, this.view));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group|Device|Specimen)", "Who/What this Media is a record of.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_OPERATOR, "Reference(Practitioner)", "The person who administered the collection of the image.", 0, Integer.MAX_VALUE, this.operator));
        childrenList.add(new Property("deviceName", "string", "The name of the device / manufacturer of the device  that was used to make the recording.", 0, Integer.MAX_VALUE, this.deviceName));
        childrenList.add(new Property("height", "positiveInt", "Height of the image in pixels (photo/video).", 0, Integer.MAX_VALUE, this.height));
        childrenList.add(new Property("width", "positiveInt", "Width of the image in pixels (photo/video).", 0, Integer.MAX_VALUE, this.width));
        childrenList.add(new Property("frames", "positiveInt", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.", 0, Integer.MAX_VALUE, this.frames));
        childrenList.add(new Property("duration", "unsignedInt", "The duration of the recording in seconds - for audio and video.", 0, Integer.MAX_VALUE, this.duration));
        childrenList.add(new Property("content", "Attachment", "The actual content of the media - inline or by direct reference to the media source file.", 0, Integer.MAX_VALUE, this.content));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -1867567750: {
                Base[] baseArray;
                if (this.subtype == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subtype;
                }
                return baseArray;
            }
            case 3619493: {
                Base[] baseArray;
                if (this.view == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.view;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case -500553564: {
                Base[] baseArray;
                if (this.operator == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.operator;
                }
                return baseArray;
            }
            case 780988929: {
                Base[] baseArray;
                if (this.deviceName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.deviceName;
                }
                return baseArray;
            }
            case -1221029593: {
                Base[] baseArray;
                if (this.height == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.height;
                }
                return baseArray;
            }
            case 113126854: {
                Base[] baseArray;
                if (this.width == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.width;
                }
                return baseArray;
            }
            case -1266514778: {
                Base[] baseArray;
                if (this.frames == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.frames;
                }
                return baseArray;
            }
            case -1992012396: {
                Base[] baseArray;
                if (this.duration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.duration;
                }
                return baseArray;
            }
            case 951530617: {
                Base[] baseArray;
                if (this.content == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.content;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 3575610: {
                this.type = new DigitalMediaTypeEnumFactory().fromType(value);
                break;
            }
            case -1867567750: {
                this.subtype = this.castToCodeableConcept(value);
                break;
            }
            case 3619493: {
                this.view = this.castToCodeableConcept(value);
                break;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                break;
            }
            case -500553564: {
                this.operator = this.castToReference(value);
                break;
            }
            case 780988929: {
                this.deviceName = this.castToString(value);
                break;
            }
            case -1221029593: {
                this.height = this.castToPositiveInt(value);
                break;
            }
            case 113126854: {
                this.width = this.castToPositiveInt(value);
                break;
            }
            case -1266514778: {
                this.frames = this.castToPositiveInt(value);
                break;
            }
            case -1992012396: {
                this.duration = this.castToUnsignedInt(value);
                break;
            }
            case 951530617: {
                this.content = this.castToAttachment(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = new DigitalMediaTypeEnumFactory().fromType(value);
        } else if (name.equals(SP_SUBTYPE)) {
            this.subtype = this.castToCodeableConcept(value);
        } else if (name.equals(SP_VIEW)) {
            this.view = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_OPERATOR)) {
            this.operator = this.castToReference(value);
        } else if (name.equals("deviceName")) {
            this.deviceName = this.castToString(value);
        } else if (name.equals("height")) {
            this.height = this.castToPositiveInt(value);
        } else if (name.equals("width")) {
            this.width = this.castToPositiveInt(value);
        } else if (name.equals("frames")) {
            this.frames = this.castToPositiveInt(value);
        } else if (name.equals("duration")) {
            this.duration = this.castToUnsignedInt(value);
        } else if (name.equals("content")) {
            this.content = this.castToAttachment(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                throw new FHIRException("Cannot make property type as it is not a complex type");
            }
            case -1867567750: {
                return this.getSubtype();
            }
            case 3619493: {
                return this.getView();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -500553564: {
                return this.getOperator();
            }
            case 780988929: {
                throw new FHIRException("Cannot make property deviceName as it is not a complex type");
            }
            case -1221029593: {
                throw new FHIRException("Cannot make property height as it is not a complex type");
            }
            case 113126854: {
                throw new FHIRException("Cannot make property width as it is not a complex type");
            }
            case -1266514778: {
                throw new FHIRException("Cannot make property frames as it is not a complex type");
            }
            case -1992012396: {
                throw new FHIRException("Cannot make property duration as it is not a complex type");
            }
            case 951530617: {
                return this.getContent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Media.type");
        }
        if (name.equals(SP_SUBTYPE)) {
            this.subtype = new CodeableConcept();
            return this.subtype;
        }
        if (name.equals(SP_VIEW)) {
            this.view = new CodeableConcept();
            return this.view;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_OPERATOR)) {
            this.operator = new Reference();
            return this.operator;
        }
        if (name.equals("deviceName")) {
            throw new FHIRException("Cannot call addChild on a singleton property Media.deviceName");
        }
        if (name.equals("height")) {
            throw new FHIRException("Cannot call addChild on a singleton property Media.height");
        }
        if (name.equals("width")) {
            throw new FHIRException("Cannot call addChild on a singleton property Media.width");
        }
        if (name.equals("frames")) {
            throw new FHIRException("Cannot call addChild on a singleton property Media.frames");
        }
        if (name.equals("duration")) {
            throw new FHIRException("Cannot call addChild on a singleton property Media.duration");
        }
        if (name.equals("content")) {
            this.content = new Attachment();
            return this.content;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Media";
    }

    @Override
    public Media copy() {
        Media dst = new Media();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.subtype = this.subtype == null ? null : this.subtype.copy();
        dst.view = this.view == null ? null : this.view.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.operator = this.operator == null ? null : this.operator.copy();
        dst.deviceName = this.deviceName == null ? null : this.deviceName.copy();
        dst.height = this.height == null ? null : this.height.copy();
        dst.width = this.width == null ? null : this.width.copy();
        dst.frames = this.frames == null ? null : this.frames.copy();
        dst.duration = this.duration == null ? null : this.duration.copy();
        dst.content = this.content == null ? null : this.content.copy();
        return dst;
    }

    protected Media typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Media)) {
            return false;
        }
        Media o = (Media)other;
        return Media.compareDeep(this.identifier, o.identifier, true) && Media.compareDeep(this.type, o.type, true) && Media.compareDeep(this.subtype, o.subtype, true) && Media.compareDeep(this.view, o.view, true) && Media.compareDeep(this.subject, o.subject, true) && Media.compareDeep(this.operator, o.operator, true) && Media.compareDeep(this.deviceName, o.deviceName, true) && Media.compareDeep(this.height, o.height, true) && Media.compareDeep(this.width, o.width, true) && Media.compareDeep(this.frames, o.frames, true) && Media.compareDeep(this.duration, o.duration, true) && Media.compareDeep(this.content, o.content, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Media)) {
            return false;
        }
        Media o = (Media)other;
        return Media.compareValues(this.type, o.type, true) && Media.compareValues(this.deviceName, o.deviceName, true) && Media.compareValues(this.height, o.height, true) && Media.compareValues(this.width, o.width, true) && Media.compareValues(this.frames, o.frames, true) && Media.compareValues(this.duration, o.duration, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.type != null && !this.type.isEmpty() || this.subtype != null && !this.subtype.isEmpty() || this.view != null && !this.view.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.operator != null && !this.operator.isEmpty() || this.deviceName != null && !this.deviceName.isEmpty() || this.height != null && !this.height.isEmpty() || this.width != null && !this.width.isEmpty() || this.frames != null && !this.frames.isEmpty() || this.duration != null && !this.duration.isEmpty() || this.content != null && !this.content.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Media;
    }

    public static class DigitalMediaTypeEnumFactory
    implements EnumFactory<DigitalMediaType> {
        @Override
        public DigitalMediaType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("photo".equals(codeString)) {
                return DigitalMediaType.PHOTO;
            }
            if ("video".equals(codeString)) {
                return DigitalMediaType.VIDEO;
            }
            if ("audio".equals(codeString)) {
                return DigitalMediaType.AUDIO;
            }
            throw new IllegalArgumentException("Unknown DigitalMediaType code '" + codeString + "'");
        }

        public Enumeration<DigitalMediaType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("photo".equals(codeString)) {
                return new Enumeration<DigitalMediaType>(this, DigitalMediaType.PHOTO);
            }
            if ("video".equals(codeString)) {
                return new Enumeration<DigitalMediaType>(this, DigitalMediaType.VIDEO);
            }
            if ("audio".equals(codeString)) {
                return new Enumeration<DigitalMediaType>(this, DigitalMediaType.AUDIO);
            }
            throw new FHIRException("Unknown DigitalMediaType code '" + codeString + "'");
        }

        @Override
        public String toCode(DigitalMediaType code) {
            if (code == DigitalMediaType.PHOTO) {
                return "photo";
            }
            if (code == DigitalMediaType.VIDEO) {
                return "video";
            }
            if (code == DigitalMediaType.AUDIO) {
                return "audio";
            }
            return "?";
        }

        @Override
        public String toSystem(DigitalMediaType code) {
            return code.getSystem();
        }
    }

    public static enum DigitalMediaType {
        PHOTO,
        VIDEO,
        AUDIO,
        NULL;


        public static DigitalMediaType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("photo".equals(codeString)) {
                return PHOTO;
            }
            if ("video".equals(codeString)) {
                return VIDEO;
            }
            if ("audio".equals(codeString)) {
                return AUDIO;
            }
            throw new FHIRException("Unknown DigitalMediaType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PHOTO: {
                    return "photo";
                }
                case VIDEO: {
                    return "video";
                }
                case AUDIO: {
                    return "audio";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PHOTO: {
                    return "http://hl7.org/fhir/digital-media-type";
                }
                case VIDEO: {
                    return "http://hl7.org/fhir/digital-media-type";
                }
                case AUDIO: {
                    return "http://hl7.org/fhir/digital-media-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PHOTO: {
                    return "The media consists of one or more unmoving images, including photographs, computer-generated graphs and charts, and scanned documents";
                }
                case VIDEO: {
                    return "The media consists of a series of frames that capture a moving image";
                }
                case AUDIO: {
                    return "The media consists of a sound recording";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PHOTO: {
                    return "Photo";
                }
                case VIDEO: {
                    return "Video";
                }
                case AUDIO: {
                    return "Audio";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

