/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ClaimTypeLink;

public class ClaimTypeLinkEnumFactory
implements EnumFactory<ClaimTypeLink> {
    @Override
    public ClaimTypeLink fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("institutional".equals(codeString)) {
            return ClaimTypeLink.INSTITUTIONAL;
        }
        if ("oral".equals(codeString)) {
            return ClaimTypeLink.ORAL;
        }
        if ("pharmacy".equals(codeString)) {
            return ClaimTypeLink.PHARMACY;
        }
        if ("professional".equals(codeString)) {
            return ClaimTypeLink.PROFESSIONAL;
        }
        if ("vision".equals(codeString)) {
            return ClaimTypeLink.VISION;
        }
        throw new IllegalArgumentException("Unknown ClaimTypeLink code '" + codeString + "'");
    }

    @Override
    public String toCode(ClaimTypeLink code) {
        if (code == ClaimTypeLink.INSTITUTIONAL) {
            return "institutional";
        }
        if (code == ClaimTypeLink.ORAL) {
            return "oral";
        }
        if (code == ClaimTypeLink.PHARMACY) {
            return "pharmacy";
        }
        if (code == ClaimTypeLink.PROFESSIONAL) {
            return "professional";
        }
        if (code == ClaimTypeLink.VISION) {
            return "vision";
        }
        return "?";
    }

    @Override
    public String toSystem(ClaimTypeLink code) {
        return code.getSystem();
    }
}

