/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ResponseCode;

public class ResponseCodeEnumFactory
implements EnumFactory<ResponseCode> {
    @Override
    public ResponseCode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ok".equals(codeString)) {
            return ResponseCode.OK;
        }
        if ("transient-error".equals(codeString)) {
            return ResponseCode.TRANSIENTERROR;
        }
        if ("fatal-error".equals(codeString)) {
            return ResponseCode.FATALERROR;
        }
        throw new IllegalArgumentException("Unknown ResponseCode code '" + codeString + "'");
    }

    @Override
    public String toCode(ResponseCode code) {
        if (code == ResponseCode.OK) {
            return "ok";
        }
        if (code == ResponseCode.TRANSIENTERROR) {
            return "transient-error";
        }
        if (code == ResponseCode.FATALERROR) {
            return "fatal-error";
        }
        return "?";
    }

    @Override
    public String toSystem(ResponseCode code) {
        return code.getSystem();
    }
}

