/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils.client;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Resource;

public class ResourceRequest<T extends Resource> {
    private T payload;
    private int httpStatus = -1;
    private String location;
    private List<Integer> successfulStatuses = new ArrayList<Integer>();
    private List<Integer> errorStatuses = new ArrayList<Integer>();

    public ResourceRequest(T payload, int httpStatus, List<Integer> successfulStatuses, List<Integer> errorStatuses, String location) {
        this.payload = payload;
        this.httpStatus = httpStatus;
        if (successfulStatuses != null) {
            this.successfulStatuses.addAll(successfulStatuses);
        }
        if (errorStatuses != null) {
            this.errorStatuses.addAll(errorStatuses);
        }
        this.location = location;
    }

    public ResourceRequest(T payload, int httpStatus, String location) {
        this.payload = payload;
        this.httpStatus = httpStatus;
        this.location = location;
    }

    public ResourceRequest(T payload, int httpStatus, int successfulStatus, String location) {
        this.payload = payload;
        this.httpStatus = httpStatus;
        this.successfulStatuses.add(successfulStatus);
        this.location = location;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public T getPayload() {
        return this.payload;
    }

    public T getReference() {
        T payloadResource = null;
        if (this.payload != null) {
            payloadResource = this.payload;
        }
        return payloadResource;
    }

    public boolean isSuccessfulRequest() {
        return this.successfulStatuses.contains(this.httpStatus) && !this.errorStatuses.contains(this.httpStatus) && this.httpStatus > 0;
    }

    public boolean isUnsuccessfulRequest() {
        return !this.isSuccessfulRequest();
    }

    public void addSuccessStatus(int status) {
        this.successfulStatuses.add(status);
    }

    public void addErrorStatus(int status) {
        this.errorStatuses.add(status);
    }

    public String getLocation() {
        return this.location;
    }
}

