package org.hl7.fhir.r5.formats;

// generated

/*
 * #%L
 * org.hl7.fhir.r5
 * %%
 * Copyright (C) 2014 - 2019 Health Level 7
 * %%
 * Licensed under the Apache License, Version 2.0 (the \"License\");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an \"AS IS\" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Tue, Dec 31, 2019 12:12+1100 for FHIR vcurrent



import org.hl7.fhir.r5.model.*;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.json.JsonTrackingParser.PresentedBigDecimal;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;

public class JsonParser extends JsonParserBase {

  public JsonParser() {
    super();
  }

  public JsonParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }

  protected void parseBaseProperties(JsonObject json, Base res) throws IOException, FHIRFormatError {
    // nothing
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    if (s != null)
      res.setValue((E) e.fromCode(s));
    return res;
  }

  protected DateType parseDate(String v) throws IOException, FHIRFormatError {
    DateType res = new DateType(v);
    return res;
  }

  protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(v);
    return res;
  }

  protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
    CodeType res = new CodeType(v);
    return res;
  }

  protected StringType parseString(String v) throws IOException, FHIRFormatError {
    StringType res = new StringType(v);
    return res;
  }

  protected IntegerType parseInteger(java.lang.Long v) throws IOException, FHIRFormatError {
    IntegerType res = new IntegerType(v);
    return res;
  }

  protected Integer64Type parseInteger64(java.lang.Long v) throws IOException, FHIRFormatError {
    Integer64Type res = new Integer64Type(v);
    return res;
  }

  protected OidType parseOid(String v) throws IOException, FHIRFormatError {
    OidType res = new OidType(v);
    return res;
  }

  protected CanonicalType parseCanonical(String v) throws IOException, FHIRFormatError {
    CanonicalType res = new CanonicalType(v);
    return res;
  }

  protected UriType parseUri(String v) throws IOException, FHIRFormatError {
    UriType res = new UriType(v);
    return res;
  }

  protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
    UuidType res = new UuidType(v);
    return res;
  }

  protected UrlType parseUrl(String v) throws IOException, FHIRFormatError {
    UrlType res = new UrlType(v);
    return res;
  }

  protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
    InstantType res = new InstantType(v);
    return res;
  }

  protected BooleanType parseBoolean(java.lang.Boolean v) throws IOException, FHIRFormatError {
    BooleanType res = new BooleanType(v);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(v);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(v);
    return res;
  }

  protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(v);
    return res;
  }

  protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
    TimeType res = new TimeType(v);
    return res;
  }

  protected IdType parseId(String v) throws IOException, FHIRFormatError {
    IdType res = new IdType(v);
    return res;
  }

  protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(v);
    return res;
  }

  protected DecimalType parseDecimal(java.math.BigDecimal v) throws IOException, FHIRFormatError {
    DecimalType res = new DecimalType(v);
    if (v instanceof PresentedBigDecimal)
      res.setRepresentation(((PresentedBigDecimal) v).getPresentation());
    return res;
  }



  protected void parseBackboneElementProperties(JsonObject json, BackboneElement res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected void parseBackboneTypeProperties(JsonObject json, BackboneType res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected void parseDataTypeProperties(JsonObject json, DataType res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
  }

  protected void parseElementProperties(JsonObject json, Element res) throws IOException, FHIRFormatError {
    parseBaseProperties(json, res);
    if (json.has("id"))
      res.setIdElement(parseString(json.get("id").getAsString()));
    if (json.has("_id"))
      parseElementProperties(json.getAsJsonObject("_id"), res.getIdElement());
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        res.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
    Address res = new Address();
    parseAddressProperties(json, res);
    return res;
  }

  protected void parseAddressProperties(JsonObject json, Address res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("line")) {
      JsonArray array = json.getAsJsonArray("line");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLine().add(new StringType());
        } else {;
          res.getLine().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_line")) {
      JsonArray array = json.getAsJsonArray("_line");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLine().size())
          res.getLine().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLine().get(i));
      }
    };
    if (json.has("city"))
      res.setCityElement(parseString(json.get("city").getAsString()));
    if (json.has("_city"))
      parseElementProperties(json.getAsJsonObject("_city"), res.getCityElement());
    if (json.has("district"))
      res.setDistrictElement(parseString(json.get("district").getAsString()));
    if (json.has("_district"))
      parseElementProperties(json.getAsJsonObject("_district"), res.getDistrictElement());
    if (json.has("state"))
      res.setStateElement(parseString(json.get("state").getAsString()));
    if (json.has("_state"))
      parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
    if (json.has("postalCode"))
      res.setPostalCodeElement(parseString(json.get("postalCode").getAsString()));
    if (json.has("_postalCode"))
      parseElementProperties(json.getAsJsonObject("_postalCode"), res.getPostalCodeElement());
    if (json.has("country"))
      res.setCountryElement(parseString(json.get("country").getAsString()));
    if (json.has("_country"))
      parseElementProperties(json.getAsJsonObject("_country"), res.getCountryElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
    Age res = new Age();
    parseAgeProperties(json, res);
    return res;
  }

  protected void parseAgeProperties(JsonObject json, Age res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseAnnotationProperties(json, res);
    return res;
  }

  protected void parseAnnotationProperties(JsonObject json, Annotation res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    DataType author = parseType("author", json);
    if (author != null)
      res.setAuthor(author);
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("text"))
      res.setTextElement(parseMarkdown(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseAttachmentProperties(json, res);
    return res;
  }

  protected void parseAttachmentProperties(JsonObject json, Attachment res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("size"))
      res.setSizeElement(parseInteger64(json.get("size").getAsLong()));
    if (json.has("_size"))
      parseElementProperties(json.getAsJsonObject("_size"), res.getSizeElement());
    if (json.has("hash"))
      res.setHashElement(parseBase64Binary(json.get("hash").getAsString()));
    if (json.has("_hash"))
      parseElementProperties(json.getAsJsonObject("_hash"), res.getHashElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("creation"))
      res.setCreationElement(parseDateTime(json.get("creation").getAsString()));
    if (json.has("_creation"))
      parseElementProperties(json.getAsJsonObject("_creation"), res.getCreationElement());
    if (json.has("height"))
      res.setHeightElement(parsePositiveInt(json.get("height").getAsString()));
    if (json.has("_height"))
      parseElementProperties(json.getAsJsonObject("_height"), res.getHeightElement());
    if (json.has("width"))
      res.setWidthElement(parsePositiveInt(json.get("width").getAsString()));
    if (json.has("_width"))
      parseElementProperties(json.getAsJsonObject("_width"), res.getWidthElement());
    if (json.has("frames"))
      res.setFramesElement(parsePositiveInt(json.get("frames").getAsString()));
    if (json.has("_frames"))
      parseElementProperties(json.getAsJsonObject("_frames"), res.getFramesElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("pages"))
      res.setPagesElement(parsePositiveInt(json.get("pages").getAsString()));
    if (json.has("_pages"))
      parseElementProperties(json.getAsJsonObject("_pages"), res.getPagesElement());
  }

  protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseCodeableConceptProperties(json, res);
    return res;
  }

  protected void parseCodeableConceptProperties(JsonObject json, CodeableConcept res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("coding")) {
      JsonArray array = json.getAsJsonArray("coding");
      for (int i = 0; i < array.size(); i++) {
        res.getCoding().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected CodeableReference parseCodeableReference(JsonObject json) throws IOException, FHIRFormatError {
    CodeableReference res = new CodeableReference();
    parseCodeableReferenceProperties(json, res);
    return res;
  }

  protected void parseCodeableReferenceProperties(JsonObject json, CodeableReference res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("concept"))
      res.setConcept(parseCodeableConcept(json.getAsJsonObject("concept")));
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
    Coding res = new Coding();
    parseCodingProperties(json, res);
    return res;
  }

  protected void parseCodingProperties(JsonObject json, Coding res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("userSelected"))
      res.setUserSelectedElement(parseBoolean(json.get("userSelected").getAsBoolean()));
    if (json.has("_userSelected"))
      parseElementProperties(json.getAsJsonObject("_userSelected"), res.getUserSelectedElement());
  }

  protected ContactDetail parseContactDetail(JsonObject json) throws IOException, FHIRFormatError {
    ContactDetail res = new ContactDetail();
    parseContactDetailProperties(json, res);
    return res;
  }

  protected void parseContactDetailProperties(JsonObject json, ContactDetail res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseContactPointProperties(json, res);
    return res;
  }

  protected void parseContactPointProperties(JsonObject json, ContactPoint res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Contributor parseContributor(JsonObject json) throws IOException, FHIRFormatError {
    Contributor res = new Contributor();
    parseContributorProperties(json, res);
    return res;
  }

  protected void parseContributorProperties(JsonObject json, Contributor res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
    Count res = new Count();
    parseCountProperties(json, res);
    return res;
  }

  protected void parseCountProperties(JsonObject json, Count res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseDataRequirementProperties(json, res);
    return res;
  }

  protected void parseDataRequirementProperties(JsonObject json, DataRequirement res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.FHIRAllTypes.NULL, new Enumerations.FHIRAllTypesEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {;
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("mustSupport")) {
      JsonArray array = json.getAsJsonArray("mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getMustSupport().add(new StringType());
        } else {;
          res.getMustSupport().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_mustSupport")) {
      JsonArray array = json.getAsJsonArray("_mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMustSupport().size())
          res.getMustSupport().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getMustSupport().get(i));
      }
    };
    if (json.has("codeFilter")) {
      JsonArray array = json.getAsJsonArray("codeFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeFilter().add(parseDataRequirementCodeFilterComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dateFilter")) {
      JsonArray array = json.getAsJsonArray("dateFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getDateFilter().add(parseDataRequirementDateFilterComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("limit"))
      res.setLimitElement(parsePositiveInt(json.get("limit").getAsString()));
    if (json.has("_limit"))
      parseElementProperties(json.getAsJsonObject("_limit"), res.getLimitElement());
    if (json.has("sort")) {
      JsonArray array = json.getAsJsonArray("sort");
      for (int i = 0; i < array.size(); i++) {
        res.getSort().add(parseDataRequirementSortComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementCodeFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseDataRequirementCodeFilterComponentProperties(json, res);
    return res;
  }

  protected void parseDataRequirementCodeFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementCodeFilterComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(json.getAsJsonObject("_searchParam"), res.getSearchParamElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDateFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseDataRequirementDateFilterComponentProperties(json, res);
    return res;
  }

  protected void parseDataRequirementDateFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementDateFilterComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(json.getAsJsonObject("_searchParam"), res.getSearchParamElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DataRequirement.DataRequirementSortComponent parseDataRequirementSortComponent(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
    parseDataRequirementSortComponentProperties(json, res);
    return res;
  }

  protected void parseDataRequirementSortComponentProperties(JsonObject json, DataRequirement.DataRequirementSortComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("direction"))
      res.setDirectionElement(parseEnumeration(json.get("direction").getAsString(), DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
    if (json.has("_direction"))
      parseElementProperties(json.getAsJsonObject("_direction"), res.getDirectionElement());
  }

  protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
    Distance res = new Distance();
    parseDistanceProperties(json, res);
    return res;
  }

  protected void parseDistanceProperties(JsonObject json, Distance res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Dosage parseDosage(JsonObject json) throws IOException, FHIRFormatError {
    Dosage res = new Dosage();
    parseDosageProperties(json, res);
    return res;
  }

  protected void parseDosageProperties(JsonObject json, Dosage res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parseInteger(json.get("sequence").getAsLong()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("additionalInstruction")) {
      JsonArray array = json.getAsJsonArray("additionalInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalInstruction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patientInstruction"))
      res.setPatientInstructionElement(parseString(json.get("patientInstruction").getAsString()));
    if (json.has("_patientInstruction"))
      parseElementProperties(json.getAsJsonObject("_patientInstruction"), res.getPatientInstructionElement());
    if (json.has("timing"))
      res.setTiming(parseTiming(json.getAsJsonObject("timing")));
    DataType asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("doseAndRate")) {
      JsonArray array = json.getAsJsonArray("doseAndRate");
      for (int i = 0; i < array.size(); i++) {
        res.getDoseAndRate().add(parseDosageDoseAndRateComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("maxDosePerPeriod"))
      res.setMaxDosePerPeriod(parseRatio(json.getAsJsonObject("maxDosePerPeriod")));
    if (json.has("maxDosePerAdministration"))
      res.setMaxDosePerAdministration(parseQuantity(json.getAsJsonObject("maxDosePerAdministration")));
    if (json.has("maxDosePerLifetime"))
      res.setMaxDosePerLifetime(parseQuantity(json.getAsJsonObject("maxDosePerLifetime")));
  }

  protected Dosage.DosageDoseAndRateComponent parseDosageDoseAndRateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
    parseDosageDoseAndRateComponentProperties(json, res);
    return res;
  }

  protected void parseDosageDoseAndRateComponentProperties(JsonObject json, Dosage.DosageDoseAndRateComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType dose = parseType("dose", json);
    if (dose != null)
      res.setDose(dose);
    DataType rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
    Duration res = new Duration();
    parseDurationProperties(json, res);
    return res;
  }

  protected void parseDurationProperties(JsonObject json, Duration res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementDefinitionProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionProperties(JsonObject json, ElementDefinition res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("representation")) {
      JsonArray array = json.getAsJsonArray("representation");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getRepresentation().add(new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory(), ElementDefinition.PropertyRepresentation.NULL));
        } else {;
          res.getRepresentation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        }
      }
    };
    if (json.has("_representation")) {
      JsonArray array = json.getAsJsonArray("_representation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRepresentation().size())
          res.getRepresentation().add(parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getRepresentation().get(i));
      }
    };
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(json.getAsJsonObject("_sliceName"), res.getSliceNameElement());
    if (json.has("sliceIsConstraining"))
      res.setSliceIsConstrainingElement(parseBoolean(json.get("sliceIsConstraining").getAsBoolean()));
    if (json.has("_sliceIsConstraining"))
      parseElementProperties(json.getAsJsonObject("_sliceIsConstraining"), res.getSliceIsConstrainingElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("slicing"))
      res.setSlicing(parseElementDefinitionSlicingComponent(json.getAsJsonObject("slicing")));
    if (json.has("short"))
      res.setShortElement(parseString(json.get("short").getAsString()));
    if (json.has("_short"))
      parseElementProperties(json.getAsJsonObject("_short"), res.getShortElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseMarkdown(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseMarkdown(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {;
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("base"))
      res.setBase(parseElementDefinitionBaseComponent(json.getAsJsonObject("base")));
    if (json.has("contentReference"))
      res.setContentReferenceElement(parseUri(json.get("contentReference").getAsString()));
    if (json.has("_contentReference"))
      parseElementProperties(json.getAsJsonObject("_contentReference"), res.getContentReferenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseElementDefinitionTypeRefComponent(array.get(i).getAsJsonObject()));
      }
    };
    DataType defaultValue = parseType("defaultValue", json);
    if (defaultValue != null)
      res.setDefaultValue(defaultValue);
    if (json.has("meaningWhenMissing"))
      res.setMeaningWhenMissingElement(parseMarkdown(json.get("meaningWhenMissing").getAsString()));
    if (json.has("_meaningWhenMissing"))
      parseElementProperties(json.getAsJsonObject("_meaningWhenMissing"), res.getMeaningWhenMissingElement());
    if (json.has("orderMeaning"))
      res.setOrderMeaningElement(parseString(json.get("orderMeaning").getAsString()));
    if (json.has("_orderMeaning"))
      parseElementProperties(json.getAsJsonObject("_orderMeaning"), res.getOrderMeaningElement());
    DataType fixed = parseType("fixed", json);
    if (fixed != null)
      res.setFixed(fixed);
    DataType pattern = parseType("pattern", json);
    if (pattern != null)
      res.setPattern(pattern);
    if (json.has("example")) {
      JsonArray array = json.getAsJsonArray("example");
      for (int i = 0; i < array.size(); i++) {
        res.getExample().add(parseElementDefinitionExampleComponent(array.get(i).getAsJsonObject()));
      }
    };
    DataType minValue = parseType("minValue", json);
    if (minValue != null)
      res.setMinValue(minValue);
    DataType maxValue = parseType("maxValue", json);
    if (maxValue != null)
      res.setMaxValue(maxValue);
    if (json.has("maxLength"))
      res.setMaxLengthElement(parseInteger(json.get("maxLength").getAsLong()));
    if (json.has("_maxLength"))
      parseElementProperties(json.getAsJsonObject("_maxLength"), res.getMaxLengthElement());
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCondition().add(new IdType());
        } else {;
          res.getCondition().add(parseId(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_condition")) {
      JsonArray array = json.getAsJsonArray("_condition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCondition().size())
          res.getCondition().add(parseId(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCondition().get(i));
      }
    };
    if (json.has("constraint")) {
      JsonArray array = json.getAsJsonArray("constraint");
      for (int i = 0; i < array.size(); i++) {
        res.getConstraint().add(parseElementDefinitionConstraintComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("mustSupport"))
      res.setMustSupportElement(parseBoolean(json.get("mustSupport").getAsBoolean()));
    if (json.has("_mustSupport"))
      parseElementProperties(json.getAsJsonObject("_mustSupport"), res.getMustSupportElement());
    if (json.has("isModifier"))
      res.setIsModifierElement(parseBoolean(json.get("isModifier").getAsBoolean()));
    if (json.has("_isModifier"))
      parseElementProperties(json.getAsJsonObject("_isModifier"), res.getIsModifierElement());
    if (json.has("isModifierReason"))
      res.setIsModifierReasonElement(parseString(json.get("isModifierReason").getAsString()));
    if (json.has("_isModifierReason"))
      parseElementProperties(json.getAsJsonObject("_isModifierReason"), res.getIsModifierReasonElement());
    if (json.has("isSummary"))
      res.setIsSummaryElement(parseBoolean(json.get("isSummary").getAsBoolean()));
    if (json.has("_isSummary"))
      parseElementProperties(json.getAsJsonObject("_isSummary"), res.getIsSummaryElement());
    if (json.has("binding"))
      res.setBinding(parseElementDefinitionBindingComponent(json.getAsJsonObject("binding")));
    if (json.has("mapping")) {
      JsonArray array = json.getAsJsonArray("mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping().add(parseElementDefinitionMappingComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionSlicingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementDefinitionSlicingComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionSlicingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionSlicingComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("discriminator")) {
      JsonArray array = json.getAsJsonArray("discriminator");
      for (int i = 0; i < array.size(); i++) {
        res.getDiscriminator().add(parseElementDefinitionSlicingDiscriminatorComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("ordered"))
      res.setOrderedElement(parseBoolean(json.get("ordered").getAsBoolean()));
    if (json.has("_ordered"))
      parseElementProperties(json.getAsJsonObject("_ordered"), res.getOrderedElement());
    if (json.has("rules"))
      res.setRulesElement(parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
    if (json.has("_rules"))
      parseElementProperties(json.getAsJsonObject("_rules"), res.getRulesElement());
  }

  protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionSlicingDiscriminatorComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
    parseElementDefinitionSlicingDiscriminatorComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionSlicingDiscriminatorComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionBaseComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementDefinitionBaseComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionBaseComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBaseComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementDefinitionTypeRefComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionTypeRefComponentProperties(JsonObject json, ElementDefinition.TypeRefComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseUri(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {;
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    if (json.has("targetProfile")) {
      JsonArray array = json.getAsJsonArray("targetProfile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getTargetProfile().add(new CanonicalType());
        } else {;
          res.getTargetProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_targetProfile")) {
      JsonArray array = json.getAsJsonArray("_targetProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTargetProfile().size())
          res.getTargetProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTargetProfile().get(i));
      }
    };
    if (json.has("aggregation")) {
      JsonArray array = json.getAsJsonArray("aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAggregation().add(new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory(), ElementDefinition.AggregationMode.NULL));
        } else {;
          res.getAggregation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        }
      }
    };
    if (json.has("_aggregation")) {
      JsonArray array = json.getAsJsonArray("_aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAggregation().size())
          res.getAggregation().add(parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAggregation().get(i));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
  }

  protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionExampleComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
    parseElementDefinitionExampleComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionExampleComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionExampleComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionConstraintComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementDefinitionConstraintComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionConstraintComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionConstraintComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseId(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(json.getAsJsonObject("_key"), res.getKeyElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseString(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(json.getAsJsonObject("_requirements"), res.getRequirementsElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("human"))
      res.setHumanElement(parseString(json.get("human").getAsString()));
    if (json.has("_human"))
      parseElementProperties(json.getAsJsonObject("_human"), res.getHumanElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("xpath"))
      res.setXpathElement(parseString(json.get("xpath").getAsString()));
    if (json.has("_xpath"))
      parseElementProperties(json.getAsJsonObject("_xpath"), res.getXpathElement());
    if (json.has("source"))
      res.setSourceElement(parseCanonical(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionBindingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementDefinitionBindingComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionBindingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBindingComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(json.getAsJsonObject("_strength"), res.getStrengthElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionMappingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementDefinitionMappingComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionMappingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionMappingComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(json.getAsJsonObject("_identity"), res.getIdentityElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("map"))
      res.setMapElement(parseString(json.get("map").getAsString()));
    if (json.has("_map"))
      parseElementProperties(json.getAsJsonObject("_map"), res.getMapElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected Expression parseExpression(JsonObject json) throws IOException, FHIRFormatError {
    Expression res = new Expression();
    parseExpressionProperties(json, res);
    return res;
  }

  protected void parseExpressionProperties(JsonObject json, Expression res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("name"))
      res.setNameElement(parseId(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
  }

  protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
    Extension res = new Extension();
    parseExtensionProperties(json, res);
    return res;
  }

  protected void parseExtensionProperties(JsonObject json, Extension res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseHumanNameProperties(json, res);
    return res;
  }

  protected void parseHumanNameProperties(JsonObject json, HumanName res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("family"))
      res.setFamilyElement(parseString(json.get("family").getAsString()));
    if (json.has("_family"))
      parseElementProperties(json.getAsJsonObject("_family"), res.getFamilyElement());
    if (json.has("given")) {
      JsonArray array = json.getAsJsonArray("given");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getGiven().add(new StringType());
        } else {;
          res.getGiven().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_given")) {
      JsonArray array = json.getAsJsonArray("_given");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGiven().size())
          res.getGiven().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGiven().get(i));
      }
    };
    if (json.has("prefix")) {
      JsonArray array = json.getAsJsonArray("prefix");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPrefix().add(new StringType());
        } else {;
          res.getPrefix().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_prefix")) {
      JsonArray array = json.getAsJsonArray("_prefix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPrefix().size())
          res.getPrefix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPrefix().get(i));
      }
    };
    if (json.has("suffix")) {
      JsonArray array = json.getAsJsonArray("suffix");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSuffix().add(new StringType());
        } else {;
          res.getSuffix().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_suffix")) {
      JsonArray array = json.getAsJsonArray("_suffix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSuffix().size())
          res.getSuffix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSuffix().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseIdentifierProperties(json, res);
    return res;
  }

  protected void parseIdentifierProperties(JsonObject json, Identifier res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("assigner"))
      res.setAssigner(parseReference(json.getAsJsonObject("assigner")));
  }

  protected MarketingStatus parseMarketingStatus(JsonObject json) throws IOException, FHIRFormatError {
    MarketingStatus res = new MarketingStatus();
    parseMarketingStatusProperties(json, res);
    return res;
  }

  protected void parseMarketingStatusProperties(JsonObject json, MarketingStatus res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(json.getAsJsonObject("country")));
    if (json.has("jurisdiction"))
      res.setJurisdiction(parseCodeableConcept(json.getAsJsonObject("jurisdiction")));
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
    if (json.has("dateRange"))
      res.setDateRange(parsePeriod(json.getAsJsonObject("dateRange")));
    if (json.has("restoreDate"))
      res.setRestoreDateElement(parseDateTime(json.get("restoreDate").getAsString()));
    if (json.has("_restoreDate"))
      parseElementProperties(json.getAsJsonObject("_restoreDate"), res.getRestoreDateElement());
  }

  protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
    Meta res = new Meta();
    parseMetaProperties(json, res);
    return res;
  }

  protected void parseMetaProperties(JsonObject json, Meta res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseId(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
    if (json.has("lastUpdated"))
      res.setLastUpdatedElement(parseInstant(json.get("lastUpdated").getAsString()));
    if (json.has("_lastUpdated"))
      parseElementProperties(json.getAsJsonObject("_lastUpdated"), res.getLastUpdatedElement());
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("profile")) {
      JsonArray array = json.getAsJsonArray("profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {;
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = json.getAsJsonArray("_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProfile().get(i));
      }
    };
    if (json.has("security")) {
      JsonArray array = json.getAsJsonArray("security");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurity().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("tag")) {
      JsonArray array = json.getAsJsonArray("tag");
      for (int i = 0; i < array.size(); i++) {
        res.getTag().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
    Money res = new Money();
    parseMoneyProperties(json, res);
    return res;
  }

  protected void parseMoneyProperties(JsonObject json, Money res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("currency"))
      res.setCurrencyElement(parseCode(json.get("currency").getAsString()));
    if (json.has("_currency"))
      parseElementProperties(json.getAsJsonObject("_currency"), res.getCurrencyElement());
  }

  protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseNarrativeProperties(json, res);
    return res;
  }

  protected void parseNarrativeProperties(JsonObject json, Narrative res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("div"))
      res.setDiv(parseXhtml(json.get("div").getAsString()));
  }

  protected OrderedDistribution parseOrderedDistribution(JsonObject json) throws IOException, FHIRFormatError {
    OrderedDistribution res = new OrderedDistribution();
    parseOrderedDistributionProperties(json, res);
    return res;
  }

  protected void parseOrderedDistributionProperties(JsonObject json, OrderedDistribution res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("numberOfIntervals"))
      res.setNumberOfIntervalsElement(parseInteger(json.get("numberOfIntervals").getAsLong()));
    if (json.has("_numberOfIntervals"))
      parseElementProperties(json.getAsJsonObject("_numberOfIntervals"), res.getNumberOfIntervalsElement());
    if (json.has("bottomOfFirstInterval"))
      res.setBottomOfFirstInterval(parseQuantity(json.getAsJsonObject("bottomOfFirstInterval")));
    if (json.has("interval")) {
      JsonArray array = json.getAsJsonArray("interval");
      for (int i = 0; i < array.size(); i++) {
        res.getInterval().add(parseOrderedDistributionIntervalComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topOfInterval"))
      res.setTopOfInterval(parseQuantity(json.getAsJsonObject("topOfInterval")));
  }

  protected OrderedDistribution.OrderedDistributionIntervalComponent parseOrderedDistributionIntervalComponent(JsonObject json) throws IOException, FHIRFormatError {
    OrderedDistribution.OrderedDistributionIntervalComponent res = new OrderedDistribution.OrderedDistributionIntervalComponent();
    parseOrderedDistributionIntervalComponentProperties(json, res);
    return res;
  }

  protected void parseOrderedDistributionIntervalComponentProperties(JsonObject json, OrderedDistribution.OrderedDistributionIntervalComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("rankOrder"))
      res.setRankOrderElement(parseInteger(json.get("rankOrder").getAsLong()));
    if (json.has("_rankOrder"))
      parseElementProperties(json.getAsJsonObject("_rankOrder"), res.getRankOrderElement());
    if (json.has("intervalStatistic")) {
      JsonArray array = json.getAsJsonArray("intervalStatistic");
      for (int i = 0; i < array.size(); i++) {
        res.getIntervalStatistic().add(parseStatistic(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseParameterDefinitionProperties(json, res);
    return res;
  }

  protected void parseParameterDefinitionProperties(JsonObject json, ParameterDefinition res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Enumerations.OperationParameterUse.NULL, new Enumerations.OperationParameterUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.FHIRAllTypes.NULL, new Enumerations.FHIRAllTypesEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
  }

  protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
    Period res = new Period();
    parsePeriodProperties(json, res);
    return res;
  }

  protected void parsePeriodProperties(JsonObject json, Period res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseDateTime(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseDateTime(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
  }

  protected Population parsePopulation(JsonObject json) throws IOException, FHIRFormatError {
    Population res = new Population();
    parsePopulationProperties(json, res);
    return res;
  }

  protected void parsePopulationProperties(JsonObject json, Population res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    DataType age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("gender"))
      res.setGender(parseCodeableConcept(json.getAsJsonObject("gender")));
    if (json.has("race"))
      res.setRace(parseCodeableConcept(json.getAsJsonObject("race")));
    if (json.has("physiologicalCondition"))
      res.setPhysiologicalCondition(parseCodeableConcept(json.getAsJsonObject("physiologicalCondition")));
  }

  protected ProdCharacteristic parseProdCharacteristic(JsonObject json) throws IOException, FHIRFormatError {
    ProdCharacteristic res = new ProdCharacteristic();
    parseProdCharacteristicProperties(json, res);
    return res;
  }

  protected void parseProdCharacteristicProperties(JsonObject json, ProdCharacteristic res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("height"))
      res.setHeight(parseQuantity(json.getAsJsonObject("height")));
    if (json.has("width"))
      res.setWidth(parseQuantity(json.getAsJsonObject("width")));
    if (json.has("depth"))
      res.setDepth(parseQuantity(json.getAsJsonObject("depth")));
    if (json.has("weight"))
      res.setWeight(parseQuantity(json.getAsJsonObject("weight")));
    if (json.has("nominalVolume"))
      res.setNominalVolume(parseQuantity(json.getAsJsonObject("nominalVolume")));
    if (json.has("externalDiameter"))
      res.setExternalDiameter(parseQuantity(json.getAsJsonObject("externalDiameter")));
    if (json.has("shape"))
      res.setShapeElement(parseString(json.get("shape").getAsString()));
    if (json.has("_shape"))
      parseElementProperties(json.getAsJsonObject("_shape"), res.getShapeElement());
    if (json.has("color")) {
      JsonArray array = json.getAsJsonArray("color");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getColor().add(new StringType());
        } else {;
          res.getColor().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_color")) {
      JsonArray array = json.getAsJsonArray("_color");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getColor().size())
          res.getColor().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getColor().get(i));
      }
    };
    if (json.has("imprint")) {
      JsonArray array = json.getAsJsonArray("imprint");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImprint().add(new StringType());
        } else {;
          res.getImprint().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_imprint")) {
      JsonArray array = json.getAsJsonArray("_imprint");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImprint().size())
          res.getImprint().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImprint().get(i));
      }
    };
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("scoring"))
      res.setScoring(parseCodeableConcept(json.getAsJsonObject("scoring")));
  }

  protected ProductShelfLife parseProductShelfLife(JsonObject json) throws IOException, FHIRFormatError {
    ProductShelfLife res = new ProductShelfLife();
    parseProductShelfLifeProperties(json, res);
    return res;
  }

  protected void parseProductShelfLifeProperties(JsonObject json, ProductShelfLife res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("period"))
      res.setPeriod(parseQuantity(json.getAsJsonObject("period")));
    if (json.has("specialPrecautionsForStorage")) {
      JsonArray array = json.getAsJsonArray("specialPrecautionsForStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialPrecautionsForStorage().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseQuantityProperties(json, res);
    return res;
  }

  protected void parseQuantityProperties(JsonObject json, Quantity res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Enumerations.QuantityComparator.NULL, new Enumerations.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(json.getAsJsonObject("_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(json.getAsJsonObject("_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
  }

  protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
    Range res = new Range();
    parseRangeProperties(json, res);
    return res;
  }

  protected void parseRangeProperties(JsonObject json, Range res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("low"))
      res.setLow(parseQuantity(json.getAsJsonObject("low")));
    if (json.has("high"))
      res.setHigh(parseQuantity(json.getAsJsonObject("high")));
  }

  protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseRatioProperties(json, res);
    return res;
  }

  protected void parseRatioProperties(JsonObject json, Ratio res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("numerator"))
      res.setNumerator(parseQuantity(json.getAsJsonObject("numerator")));
    if (json.has("denominator"))
      res.setDenominator(parseQuantity(json.getAsJsonObject("denominator")));
  }

  protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
    Reference res = new Reference();
    parseReferenceProperties(json, res);
    return res;
  }

  protected void parseReferenceProperties(JsonObject json, Reference res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("reference"))
      res.setReferenceElement(parseString(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("type"))
      res.setTypeElement(parseUri(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
  }

  protected RelatedArtifact parseRelatedArtifact(JsonObject json) throws IOException, FHIRFormatError {
    RelatedArtifact res = new RelatedArtifact();
    parseRelatedArtifactProperties(json, res);
    return res;
  }

  protected void parseRelatedArtifactProperties(JsonObject json, RelatedArtifact res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(json.getAsJsonObject("_label"), res.getLabelElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("citation"))
      res.setCitationElement(parseMarkdown(json.get("citation").getAsString()));
    if (json.has("_citation"))
      parseElementProperties(json.getAsJsonObject("_citation"), res.getCitationElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("document"))
      res.setDocument(parseAttachment(json.getAsJsonObject("document")));
    if (json.has("resource"))
      res.setResourceElement(parseCanonical(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(json.getAsJsonObject("_resource"), res.getResourceElement());
  }

  protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseSampledDataProperties(json, res);
    return res;
  }

  protected void parseSampledDataProperties(JsonObject json, SampledData res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("origin"))
      res.setOrigin(parseQuantity(json.getAsJsonObject("origin")));
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("lowerLimit"))
      res.setLowerLimitElement(parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
    if (json.has("_lowerLimit"))
      parseElementProperties(json.getAsJsonObject("_lowerLimit"), res.getLowerLimitElement());
    if (json.has("upperLimit"))
      res.setUpperLimitElement(parseDecimal(json.get("upperLimit").getAsBigDecimal()));
    if (json.has("_upperLimit"))
      parseElementProperties(json.getAsJsonObject("_upperLimit"), res.getUpperLimitElement());
    if (json.has("dimensions"))
      res.setDimensionsElement(parsePositiveInt(json.get("dimensions").getAsString()));
    if (json.has("_dimensions"))
      parseElementProperties(json.getAsJsonObject("_dimensions"), res.getDimensionsElement());
    if (json.has("data"))
      res.setDataElement(parseString(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
  }

  protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
    Signature res = new Signature();
    parseSignatureProperties(json, res);
    return res;
  }

  protected void parseSignatureProperties(JsonObject json, Signature res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("when"))
      res.setWhenElement(parseInstant(json.get("when").getAsString()));
    if (json.has("_when"))
      parseElementProperties(json.getAsJsonObject("_when"), res.getWhenElement());
    if (json.has("who"))
      res.setWho(parseReference(json.getAsJsonObject("who")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
    if (json.has("targetFormat"))
      res.setTargetFormatElement(parseCode(json.get("targetFormat").getAsString()));
    if (json.has("_targetFormat"))
      parseElementProperties(json.getAsJsonObject("_targetFormat"), res.getTargetFormatElement());
    if (json.has("sigFormat"))
      res.setSigFormatElement(parseCode(json.get("sigFormat").getAsString()));
    if (json.has("_sigFormat"))
      parseElementProperties(json.getAsJsonObject("_sigFormat"), res.getSigFormatElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
  }

  protected Statistic parseStatistic(JsonObject json) throws IOException, FHIRFormatError {
    Statistic res = new Statistic();
    parseStatisticProperties(json, res);
    return res;
  }

  protected void parseStatisticProperties(JsonObject json, Statistic res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("statisticType"))
      res.setStatisticType(parseCodeableConcept(json.getAsJsonObject("statisticType")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("sampleSize"))
      res.setSampleSize(parseStatisticSampleSizeComponent(json.getAsJsonObject("sampleSize")));
    if (json.has("attributeEstimate")) {
      JsonArray array = json.getAsJsonArray("attributeEstimate");
      for (int i = 0; i < array.size(); i++) {
        res.getAttributeEstimate().add(parseStatisticAttributeEstimateComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Statistic.StatisticSampleSizeComponent parseStatisticSampleSizeComponent(JsonObject json) throws IOException, FHIRFormatError {
    Statistic.StatisticSampleSizeComponent res = new Statistic.StatisticSampleSizeComponent();
    parseStatisticSampleSizeComponentProperties(json, res);
    return res;
  }

  protected void parseStatisticSampleSizeComponentProperties(JsonObject json, Statistic.StatisticSampleSizeComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("numberOfStudies"))
      res.setNumberOfStudiesElement(parseInteger(json.get("numberOfStudies").getAsLong()));
    if (json.has("_numberOfStudies"))
      parseElementProperties(json.getAsJsonObject("_numberOfStudies"), res.getNumberOfStudiesElement());
    if (json.has("numberOfParticipants"))
      res.setNumberOfParticipantsElement(parseInteger(json.get("numberOfParticipants").getAsLong()));
    if (json.has("_numberOfParticipants"))
      parseElementProperties(json.getAsJsonObject("_numberOfParticipants"), res.getNumberOfParticipantsElement());
    if (json.has("knownDataCount"))
      res.setKnownDataCountElement(parseInteger(json.get("knownDataCount").getAsLong()));
    if (json.has("_knownDataCount"))
      parseElementProperties(json.getAsJsonObject("_knownDataCount"), res.getKnownDataCountElement());
    if (json.has("numeratorCount"))
      res.setNumeratorCountElement(parseInteger(json.get("numeratorCount").getAsLong()));
    if (json.has("_numeratorCount"))
      parseElementProperties(json.getAsJsonObject("_numeratorCount"), res.getNumeratorCountElement());
  }

  protected Statistic.StatisticAttributeEstimateComponent parseStatisticAttributeEstimateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Statistic.StatisticAttributeEstimateComponent res = new Statistic.StatisticAttributeEstimateComponent();
    parseStatisticAttributeEstimateComponentProperties(json, res);
    return res;
  }

  protected void parseStatisticAttributeEstimateComponentProperties(JsonObject json, Statistic.StatisticAttributeEstimateComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("level"))
      res.setLevelElement(parseDecimal(json.get("level").getAsBigDecimal()));
    if (json.has("_level"))
      parseElementProperties(json.getAsJsonObject("_level"), res.getLevelElement());
    if (json.has("range"))
      res.setRange(parseRange(json.getAsJsonObject("range")));
    if (json.has("estimateQualifier")) {
      JsonArray array = json.getAsJsonArray("estimateQualifier");
      for (int i = 0; i < array.size(); i++) {
        res.getEstimateQualifier().add(parseStatisticAttributeEstimateEstimateQualifierComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Statistic.StatisticAttributeEstimateEstimateQualifierComponent parseStatisticAttributeEstimateEstimateQualifierComponent(JsonObject json) throws IOException, FHIRFormatError {
    Statistic.StatisticAttributeEstimateEstimateQualifierComponent res = new Statistic.StatisticAttributeEstimateEstimateQualifierComponent();
    parseStatisticAttributeEstimateEstimateQualifierComponentProperties(json, res);
    return res;
  }

  protected void parseStatisticAttributeEstimateEstimateQualifierComponentProperties(JsonObject json, Statistic.StatisticAttributeEstimateEstimateQualifierComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("level"))
      res.setLevelElement(parseDecimal(json.get("level").getAsBigDecimal()));
    if (json.has("_level"))
      parseElementProperties(json.getAsJsonObject("_level"), res.getLevelElement());
    if (json.has("range"))
      res.setRange(parseRange(json.getAsJsonObject("range")));
  }

  protected SubstanceAmount parseSubstanceAmount(JsonObject json) throws IOException, FHIRFormatError {
    SubstanceAmount res = new SubstanceAmount();
    parseSubstanceAmountProperties(json, res);
    return res;
  }

  protected void parseSubstanceAmountProperties(JsonObject json, SubstanceAmount res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    DataType amount = parseType("amount", json);
    if (amount != null)
      res.setAmount(amount);
    if (json.has("amountType"))
      res.setAmountType(parseCodeableConcept(json.getAsJsonObject("amountType")));
    if (json.has("amountText"))
      res.setAmountTextElement(parseString(json.get("amountText").getAsString()));
    if (json.has("_amountText"))
      parseElementProperties(json.getAsJsonObject("_amountText"), res.getAmountTextElement());
    if (json.has("referenceRange"))
      res.setReferenceRange(parseSubstanceAmountReferenceRangeComponent(json.getAsJsonObject("referenceRange")));
  }

  protected SubstanceAmount.SubstanceAmountReferenceRangeComponent parseSubstanceAmountReferenceRangeComponent(JsonObject json) throws IOException, FHIRFormatError {
    SubstanceAmount.SubstanceAmountReferenceRangeComponent res = new SubstanceAmount.SubstanceAmountReferenceRangeComponent();
    parseSubstanceAmountReferenceRangeComponentProperties(json, res);
    return res;
  }

  protected void parseSubstanceAmountReferenceRangeComponentProperties(JsonObject json, SubstanceAmount.SubstanceAmountReferenceRangeComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("lowLimit"))
      res.setLowLimit(parseQuantity(json.getAsJsonObject("lowLimit")));
    if (json.has("highLimit"))
      res.setHighLimit(parseQuantity(json.getAsJsonObject("highLimit")));
  }

  protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
    Timing res = new Timing();
    parseTimingProperties(json, res);
    return res;
  }

  protected void parseTimingProperties(JsonObject json, Timing res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getEvent().add(new DateTimeType());
        } else {;
          res.getEvent().add(parseDateTime(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_event")) {
      JsonArray array = json.getAsJsonArray("_event");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getEvent().size())
          res.getEvent().add(parseDateTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getEvent().get(i));
      }
    };
    if (json.has("repeat"))
      res.setRepeat(parseTimingRepeatComponent(json.getAsJsonObject("repeat")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected Timing.TimingRepeatComponent parseTimingRepeatComponent(JsonObject json) throws IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseTimingRepeatComponentProperties(json, res);
    return res;
  }

  protected void parseTimingRepeatComponentProperties(JsonObject json, Timing.TimingRepeatComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    DataType bounds = parseType("bounds", json);
    if (bounds != null)
      res.setBounds(bounds);
    if (json.has("count"))
      res.setCountElement(parsePositiveInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("countMax"))
      res.setCountMaxElement(parsePositiveInt(json.get("countMax").getAsString()));
    if (json.has("_countMax"))
      parseElementProperties(json.getAsJsonObject("_countMax"), res.getCountMaxElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(json.getAsJsonObject("_duration"), res.getDurationElement());
    if (json.has("durationMax"))
      res.setDurationMaxElement(parseDecimal(json.get("durationMax").getAsBigDecimal()));
    if (json.has("_durationMax"))
      parseElementProperties(json.getAsJsonObject("_durationMax"), res.getDurationMaxElement());
    if (json.has("durationUnit"))
      res.setDurationUnitElement(parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_durationUnit"))
      parseElementProperties(json.getAsJsonObject("_durationUnit"), res.getDurationUnitElement());
    if (json.has("frequency"))
      res.setFrequencyElement(parsePositiveInt(json.get("frequency").getAsString()));
    if (json.has("_frequency"))
      parseElementProperties(json.getAsJsonObject("_frequency"), res.getFrequencyElement());
    if (json.has("frequencyMax"))
      res.setFrequencyMaxElement(parsePositiveInt(json.get("frequencyMax").getAsString()));
    if (json.has("_frequencyMax"))
      parseElementProperties(json.getAsJsonObject("_frequencyMax"), res.getFrequencyMaxElement());
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(json.getAsJsonObject("_period"), res.getPeriodElement());
    if (json.has("periodMax"))
      res.setPeriodMaxElement(parseDecimal(json.get("periodMax").getAsBigDecimal()));
    if (json.has("_periodMax"))
      parseElementProperties(json.getAsJsonObject("_periodMax"), res.getPeriodMaxElement());
    if (json.has("periodUnit"))
      res.setPeriodUnitElement(parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_periodUnit"))
      parseElementProperties(json.getAsJsonObject("_periodUnit"), res.getPeriodUnitElement());
    if (json.has("dayOfWeek")) {
      JsonArray array = json.getAsJsonArray("dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDayOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
        } else {;
          res.getDayOfWeek().add(parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        }
      }
    };
    if (json.has("_dayOfWeek")) {
      JsonArray array = json.getAsJsonArray("_dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDayOfWeek().size())
          res.getDayOfWeek().add(parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDayOfWeek().get(i));
      }
    };
    if (json.has("timeOfDay")) {
      JsonArray array = json.getAsJsonArray("timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getTimeOfDay().add(new TimeType());
        } else {;
          res.getTimeOfDay().add(parseTime(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_timeOfDay")) {
      JsonArray array = json.getAsJsonArray("_timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTimeOfDay().size())
          res.getTimeOfDay().add(parseTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getTimeOfDay().get(i));
      }
    };
    if (json.has("when")) {
      JsonArray array = json.getAsJsonArray("when");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getWhen().add(new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory(), Timing.EventTiming.NULL));
        } else {;
          res.getWhen().add(parseEnumeration(array.get(i).getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        }
      }
    };
    if (json.has("_when")) {
      JsonArray array = json.getAsJsonArray("_when");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getWhen().size())
          res.getWhen().add(parseEnumeration(null, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getWhen().get(i));
      }
    };
    if (json.has("offset"))
      res.setOffsetElement(parseUnsignedInt(json.get("offset").getAsString()));
    if (json.has("_offset"))
      parseElementProperties(json.getAsJsonObject("_offset"), res.getOffsetElement());
  }

  protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseTriggerDefinitionProperties(json, res);
    return res;
  }

  protected void parseTriggerDefinitionProperties(JsonObject json, TriggerDefinition res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition"))
      res.setCondition(parseExpression(json.getAsJsonObject("condition")));
  }

  protected UsageContext parseUsageContext(JsonObject json) throws IOException, FHIRFormatError {
    UsageContext res = new UsageContext();
    parseUsageContextProperties(json, res);
    return res;
  }

  protected void parseUsageContextProperties(JsonObject json, UsageContext res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(json.getAsJsonObject("code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected void parseCanonicalResourceProperties(JsonObject json, CanonicalResource res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
  }

  protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("text"))
      res.setText(parseNarrative(json.getAsJsonObject("text")));
    if (json.has("contained")) {
      JsonArray array = json.getAsJsonArray("contained");
      for (int i = 0; i < array.size(); i++) {
        res.getContained().add(parseResource(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("extension")) {
      JsonArray array = json.getAsJsonArray("extension");
      for (int i = 0; i < array.size(); i++) {
        res.getExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("modifierExtension")) {
      JsonArray array = json.getAsJsonArray("modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected void parseMetadataResourceProperties(JsonObject json, MetadataResource res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
  }

  protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
    parseBaseProperties(json, res);
    if (json.has("id"))
      res.setIdElement(parseId(json.get("id").getAsString()));
    if (json.has("_id"))
      parseElementProperties(json.getAsJsonObject("_id"), res.getIdElement());
    if (json.has("meta"))
      res.setMeta(parseMeta(json.getAsJsonObject("meta")));
    if (json.has("implicitRules"))
      res.setImplicitRulesElement(parseUri(json.get("implicitRules").getAsString()));
    if (json.has("_implicitRules"))
      parseElementProperties(json.getAsJsonObject("_implicitRules"), res.getImplicitRulesElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
  }

  protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
    Account res = new Account();
    parseAccountProperties(json, res);
    return res;
  }

  protected void parseAccountProperties(JsonObject json, Account res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("servicePeriod"))
      res.setServicePeriod(parsePeriod(json.getAsJsonObject("servicePeriod")));
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseAccountCoverageComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("guarantor")) {
      JsonArray array = json.getAsJsonArray("guarantor");
      for (int i = 0; i < array.size(); i++) {
        res.getGuarantor().add(parseAccountGuarantorComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
  }

  protected Account.CoverageComponent parseAccountCoverageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Account.CoverageComponent res = new Account.CoverageComponent();
    parseAccountCoverageComponentProperties(json, res);
    return res;
  }

  protected void parseAccountCoverageComponentProperties(JsonObject json, Account.CoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("priority"))
      res.setPriorityElement(parsePositiveInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
  }

  protected Account.GuarantorComponent parseAccountGuarantorComponent(JsonObject json) throws IOException, FHIRFormatError {
    Account.GuarantorComponent res = new Account.GuarantorComponent();
    parseAccountGuarantorComponentProperties(json, res);
    return res;
  }

  protected void parseAccountGuarantorComponentProperties(JsonObject json, Account.GuarantorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
    if (json.has("onHold"))
      res.setOnHoldElement(parseBoolean(json.get("onHold").getAsBoolean()));
    if (json.has("_onHold"))
      parseElementProperties(json.getAsJsonObject("_onHold"), res.getOnHoldElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected ActivityDefinition parseActivityDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition res = new ActivityDefinition();
    parseActivityDefinitionProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionProperties(JsonObject json, ActivityDefinition res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLibrary().add(new CanonicalType());
        } else {;
          res.getLibrary().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_library")) {
      JsonArray array = json.getAsJsonArray("_library");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLibrary().size())
          res.getLibrary().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLibrary().get(i));
      }
    };
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), ActivityDefinition.RequestResourceType.NULL, new ActivityDefinition.RequestResourceTypeEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseActivityDefinitionParticipantComponent(array.get(i).getAsJsonObject()));
      }
    };
    DataType product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specimenRequirement")) {
      JsonArray array = json.getAsJsonArray("specimenRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimenRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("observationRequirement")) {
      JsonArray array = json.getAsJsonArray("observationRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getObservationRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("observationResultRequirement")) {
      JsonArray array = json.getAsJsonArray("observationResultRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getObservationResultRequirement().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("transform"))
      res.setTransformElement(parseCanonical(json.get("transform").getAsString()));
    if (json.has("_transform"))
      parseElementProperties(json.getAsJsonObject("_transform"), res.getTransformElement());
    if (json.has("dynamicValue")) {
      JsonArray array = json.getAsJsonArray("dynamicValue");
      for (int i = 0; i < array.size(); i++) {
        res.getDynamicValue().add(parseActivityDefinitionDynamicValueComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
    parseActivityDefinitionParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionParticipantComponentProperties(JsonObject json, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.ActionParticipantType.NULL, new Enumerations.ActionParticipantTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
  }

  protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionDynamicValueComponent(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
    parseActivityDefinitionDynamicValueComponentProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionDynamicValueComponentProperties(JsonObject json, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("expression"))
      res.setExpression(parseExpression(json.getAsJsonObject("expression")));
  }

  protected AdministrableProductDefinition parseAdministrableProductDefinition(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition res = new AdministrableProductDefinition();
    parseAdministrableProductDefinitionProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionProperties(JsonObject json, AdministrableProductDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("administrableDoseForm"))
      res.setAdministrableDoseForm(parseCodeableConcept(json.getAsJsonObject("administrableDoseForm")));
    if (json.has("unitOfPresentation"))
      res.setUnitOfPresentation(parseCodeableConcept(json.getAsJsonObject("unitOfPresentation")));
    if (json.has("producedFrom")) {
      JsonArray array = json.getAsJsonArray("producedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getProducedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseAdministrableProductDefinitionCharacteristicComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("routeOfAdministration")) {
      JsonArray array = json.getAsJsonArray("routeOfAdministration");
      for (int i = 0; i < array.size(); i++) {
        res.getRouteOfAdministration().add(parseAdministrableProductDefinitionRouteOfAdministrationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionCharacteristicComponent parseAdministrableProductDefinitionCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionCharacteristicComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionCharacteristicComponent();
    parseAdministrableProductDefinitionCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionCharacteristicComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent parseAdministrableProductDefinitionRouteOfAdministrationComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent();
    parseAdministrableProductDefinitionRouteOfAdministrationComponentProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionRouteOfAdministrationComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("firstDose"))
      res.setFirstDose(parseQuantity(json.getAsJsonObject("firstDose")));
    if (json.has("maxSingleDose"))
      res.setMaxSingleDose(parseQuantity(json.getAsJsonObject("maxSingleDose")));
    if (json.has("maxDosePerDay"))
      res.setMaxDosePerDay(parseQuantity(json.getAsJsonObject("maxDosePerDay")));
    if (json.has("maxDosePerTreatmentPeriod"))
      res.setMaxDosePerTreatmentPeriod(parseRatio(json.getAsJsonObject("maxDosePerTreatmentPeriod")));
    if (json.has("maxTreatmentPeriod"))
      res.setMaxTreatmentPeriod(parseDuration(json.getAsJsonObject("maxTreatmentPeriod")));
    if (json.has("targetSpecies")) {
      JsonArray array = json.getAsJsonArray("targetSpecies");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetSpecies().add(parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
    parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("withdrawalPeriod")) {
      JsonArray array = json.getAsJsonArray("withdrawalPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getWithdrawalPeriod().add(parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
    parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("tissue"))
      res.setTissue(parseCodeableConcept(json.getAsJsonObject("tissue")));
    if (json.has("value"))
      res.setValue(parseQuantity(json.getAsJsonObject("value")));
    if (json.has("supportingInformation"))
      res.setSupportingInformationElement(parseString(json.get("supportingInformation").getAsString()));
    if (json.has("_supportingInformation"))
      parseElementProperties(json.getAsJsonObject("_supportingInformation"), res.getSupportingInformationElement());
  }

  protected AdverseEvent parseAdverseEvent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent res = new AdverseEvent();
    parseAdverseEventProperties(json, res);
    return res;
  }

  protected void parseAdverseEventProperties(JsonObject json, AdverseEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), AdverseEvent.AdverseEventStatus.NULL, new AdverseEvent.AdverseEventStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("actuality"))
      res.setActualityElement(parseEnumeration(json.get("actuality").getAsString(), AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
    if (json.has("_actuality"))
      parseElementProperties(json.getAsJsonObject("_actuality"), res.getActualityElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("detected"))
      res.setDetectedElement(parseDateTime(json.get("detected").getAsString()));
    if (json.has("_detected"))
      parseElementProperties(json.getAsJsonObject("_detected"), res.getDetectedElement());
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
    if (json.has("resultingCondition")) {
      JsonArray array = json.getAsJsonArray("resultingCondition");
      for (int i = 0; i < array.size(); i++) {
        res.getResultingCondition().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("seriousness"))
      res.setSeriousness(parseCodeableConcept(json.getAsJsonObject("seriousness")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAdverseEventParticipantComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("suspectEntity")) {
      JsonArray array = json.getAsJsonArray("suspectEntity");
      for (int i = 0; i < array.size(); i++) {
        res.getSuspectEntity().add(parseAdverseEventSuspectEntityComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contributingFactor")) {
      JsonArray array = json.getAsJsonArray("contributingFactor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributingFactor().add(parseAdverseEventContributingFactorComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("preventiveAction")) {
      JsonArray array = json.getAsJsonArray("preventiveAction");
      for (int i = 0; i < array.size(); i++) {
        res.getPreventiveAction().add(parseAdverseEventPreventiveActionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("mitigatingAction")) {
      JsonArray array = json.getAsJsonArray("mitigatingAction");
      for (int i = 0; i < array.size(); i++) {
        res.getMitigatingAction().add(parseAdverseEventMitigatingActionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseAdverseEventSupportingInfoComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("study")) {
      JsonArray array = json.getAsJsonArray("study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AdverseEvent.AdverseEventParticipantComponent parseAdverseEventParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventParticipantComponent res = new AdverseEvent.AdverseEventParticipantComponent();
    parseAdverseEventParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventParticipantComponentProperties(JsonObject json, AdverseEvent.AdverseEventParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventSuspectEntityComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
    parseAdverseEventSuspectEntityComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventSuspectEntityComponentProperties(JsonObject json, AdverseEvent.AdverseEventSuspectEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType instance = parseType("instance", json);
    if (instance != null)
      res.setInstance(instance);
    if (json.has("causality"))
      res.setCausality(parseAdverseEventSuspectEntityCausalityComponent(json.getAsJsonObject("causality")));
  }

  protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventSuspectEntityCausalityComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
    parseAdverseEventSuspectEntityCausalityComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventSuspectEntityCausalityComponentProperties(JsonObject json, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("assessmentMethod"))
      res.setAssessmentMethod(parseCodeableConcept(json.getAsJsonObject("assessmentMethod")));
    if (json.has("entityRelatedness"))
      res.setEntityRelatedness(parseCodeableConcept(json.getAsJsonObject("entityRelatedness")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected AdverseEvent.AdverseEventContributingFactorComponent parseAdverseEventContributingFactorComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventContributingFactorComponent res = new AdverseEvent.AdverseEventContributingFactorComponent();
    parseAdverseEventContributingFactorComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventContributingFactorComponentProperties(JsonObject json, AdverseEvent.AdverseEventContributingFactorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected AdverseEvent.AdverseEventPreventiveActionComponent parseAdverseEventPreventiveActionComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventPreventiveActionComponent res = new AdverseEvent.AdverseEventPreventiveActionComponent();
    parseAdverseEventPreventiveActionComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventPreventiveActionComponentProperties(JsonObject json, AdverseEvent.AdverseEventPreventiveActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected AdverseEvent.AdverseEventMitigatingActionComponent parseAdverseEventMitigatingActionComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventMitigatingActionComponent res = new AdverseEvent.AdverseEventMitigatingActionComponent();
    parseAdverseEventMitigatingActionComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventMitigatingActionComponentProperties(JsonObject json, AdverseEvent.AdverseEventMitigatingActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected AdverseEvent.AdverseEventSupportingInfoComponent parseAdverseEventSupportingInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSupportingInfoComponent res = new AdverseEvent.AdverseEventSupportingInfoComponent();
    parseAdverseEventSupportingInfoComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventSupportingInfoComponentProperties(JsonObject json, AdverseEvent.AdverseEventSupportingInfoComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseAllergyIntoleranceProperties(json, res);
    return res;
  }

  protected void parseAllergyIntoleranceProperties(JsonObject json, AllergyIntolerance res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatus(parseCodeableConcept(json.getAsJsonObject("clinicalStatus")));
    if (json.has("verificationStatus"))
      res.setVerificationStatus(parseCodeableConcept(json.getAsJsonObject("verificationStatus")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCategory().add(new Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>(new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory(), AllergyIntolerance.AllergyIntoleranceCategory.NULL));
        } else {;
          res.getCategory().add(parseEnumeration(array.get(i).getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        }
      }
    };
    if (json.has("_category")) {
      JsonArray array = json.getAsJsonArray("_category");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCategory().size())
          res.getCategory().add(parseEnumeration(null, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCategory().get(i));
      }
    };
    if (json.has("criticality"))
      res.setCriticalityElement(parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
    if (json.has("_criticality"))
      parseElementProperties(json.getAsJsonObject("_criticality"), res.getCriticalityElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("asserter"))
      res.setAsserter(parseReference(json.getAsJsonObject("asserter")));
    if (json.has("lastOccurrence"))
      res.setLastOccurrenceElement(parseDateTime(json.get("lastOccurrence").getAsString()));
    if (json.has("_lastOccurrence"))
      parseElementProperties(json.getAsJsonObject("_lastOccurrence"), res.getLastOccurrenceElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseAllergyIntoleranceReactionComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceReactionComponent(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseAllergyIntoleranceReactionComponentProperties(json, res);
    return res;
  }

  protected void parseAllergyIntoleranceReactionComponentProperties(JsonObject json, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("manifestation")) {
      JsonArray array = json.getAsJsonArray("manifestation");
      for (int i = 0; i < array.size(); i++) {
        res.getManifestation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("onset"))
      res.setOnsetElement(parseDateTime(json.get("onset").getAsString()));
    if (json.has("_onset"))
      parseElementProperties(json.getAsJsonObject("_onset"), res.getOnsetElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("exposureRoute"))
      res.setExposureRoute(parseCodeableConcept(json.getAsJsonObject("exposureRoute")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseAppointmentProperties(json, res);
    return res;
  }

  protected void parseAppointmentProperties(JsonObject json, Appointment res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("cancelationReason"))
      res.setCancelationReason(parseCodeableConcept(json.getAsJsonObject("cancelationReason")));
    if (json.has("serviceCategory")) {
      JsonArray array = json.getAsJsonArray("serviceCategory");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceType")) {
      JsonArray array = json.getAsJsonArray("serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentType"))
      res.setAppointmentType(parseCodeableConcept(json.getAsJsonObject("appointmentType")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseUnsignedInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("minutesDuration"))
      res.setMinutesDurationElement(parsePositiveInt(json.get("minutesDuration").getAsString()));
    if (json.has("_minutesDuration"))
      parseElementProperties(json.getAsJsonObject("_minutesDuration"), res.getMinutesDurationElement());
    if (json.has("slot")) {
      JsonArray array = json.getAsJsonArray("slot");
      for (int i = 0; i < array.size(); i++) {
        res.getSlot().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("patientInstruction"))
      res.setPatientInstructionElement(parseString(json.get("patientInstruction").getAsString()));
    if (json.has("_patientInstruction"))
      parseElementProperties(json.getAsJsonObject("_patientInstruction"), res.getPatientInstructionElement());
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAppointmentParticipantComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("requestedPeriod")) {
      JsonArray array = json.getAsJsonArray("requestedPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getRequestedPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseAppointmentParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseAppointmentParticipantComponentProperties(JsonObject json, Appointment.AppointmentParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("required"))
      res.setRequiredElement(parseEnumeration(json.get("required").getAsString(), Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
    if (json.has("_required"))
      parseElementProperties(json.getAsJsonObject("_required"), res.getRequiredElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.ParticipationStatus.NULL, new Enumerations.ParticipationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseAppointmentResponseProperties(json, res);
    return res;
  }

  protected void parseAppointmentResponseProperties(JsonObject json, AppointmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointment"))
      res.setAppointment(parseReference(json.getAsJsonObject("appointment")));
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("participantType")) {
      JsonArray array = json.getAsJsonArray("participantType");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipantType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
    if (json.has("participantStatus"))
      res.setParticipantStatusElement(parseEnumeration(json.get("participantStatus").getAsString(), Enumerations.ParticipationStatus.NULL, new Enumerations.ParticipationStatusEnumFactory()));
    if (json.has("_participantStatus"))
      parseElementProperties(json.getAsJsonObject("_participantStatus"), res.getParticipantStatusElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseAuditEventProperties(json, res);
    return res;
  }

  protected void parseAuditEventProperties(JsonObject json, AuditEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("subtype")) {
      JsonArray array = json.getAsJsonArray("subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action"))
      res.setActionElement(parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
    if (json.has("_action"))
      parseElementProperties(json.getAsJsonObject("_action"), res.getActionElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), AuditEvent.AuditEventSeverity.NULL, new AuditEvent.AuditEventSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("recorded"))
      res.setRecordedElement(parseInstant(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("outcomeDesc"))
      res.setOutcomeDescElement(parseString(json.get("outcomeDesc").getAsString()));
    if (json.has("_outcomeDesc"))
      parseElementProperties(json.getAsJsonObject("_outcomeDesc"), res.getOutcomeDescElement());
    if (json.has("purposeOfEvent")) {
      JsonArray array = json.getAsJsonArray("purposeOfEvent");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("agent")) {
      JsonArray array = json.getAsJsonArray("agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseAuditEventAgentComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("source"))
      res.setSource(parseAuditEventSourceComponent(json.getAsJsonObject("source")));
    if (json.has("entity")) {
      JsonArray array = json.getAsJsonArray("entity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntity().add(parseAuditEventEntityComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAgentComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseAuditEventAgentComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventAgentComponentProperties(JsonObject json, AuditEvent.AuditEventAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("role")) {
      JsonArray array = json.getAsJsonArray("role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("who"))
      res.setWho(parseReference(json.getAsJsonObject("who")));
    if (json.has("altId"))
      res.setAltIdElement(parseString(json.get("altId").getAsString()));
    if (json.has("_altId"))
      parseElementProperties(json.getAsJsonObject("_altId"), res.getAltIdElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("requestor"))
      res.setRequestorElement(parseBoolean(json.get("requestor").getAsBoolean()));
    if (json.has("_requestor"))
      parseElementProperties(json.getAsJsonObject("_requestor"), res.getRequestorElement());
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPolicy().add(new UriType());
        } else {;
          res.getPolicy().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_policy")) {
      JsonArray array = json.getAsJsonArray("_policy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPolicy().size())
          res.getPolicy().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPolicy().get(i));
      }
    };
    if (json.has("media"))
      res.setMedia(parseCoding(json.getAsJsonObject("media")));
    if (json.has("network"))
      res.setNetwork(parseAuditEventAgentNetworkComponent(json.getAsJsonObject("network")));
    if (json.has("purposeOfUse")) {
      JsonArray array = json.getAsJsonArray("purposeOfUse");
      for (int i = 0; i < array.size(); i++) {
        res.getPurposeOfUse().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAgentNetworkComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
    parseAuditEventAgentNetworkComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventAgentNetworkComponentProperties(JsonObject json, AuditEvent.AuditEventAgentNetworkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("address"))
      res.setAddressElement(parseString(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventSourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseAuditEventSourceComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventSourceComponentProperties(JsonObject json, AuditEvent.AuditEventSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("site"))
      res.setSiteElement(parseString(json.get("site").getAsString()));
    if (json.has("_site"))
      parseElementProperties(json.getAsJsonObject("_site"), res.getSiteElement());
    if (json.has("observer"))
      res.setObserver(parseReference(json.getAsJsonObject("observer")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventEntityComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseAuditEventEntityComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventEntityComponentProperties(JsonObject json, AuditEvent.AuditEventEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("what"))
      res.setWhat(parseReference(json.getAsJsonObject("what")));
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("role"))
      res.setRole(parseCoding(json.getAsJsonObject("role")));
    if (json.has("lifecycle"))
      res.setLifecycle(parseCoding(json.getAsJsonObject("lifecycle")));
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("query"))
      res.setQueryElement(parseBase64Binary(json.get("query").getAsString()));
    if (json.has("_query"))
      parseElementProperties(json.getAsJsonObject("_query"), res.getQueryElement());
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseAuditEventEntityDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventEntityDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseAuditEventEntityDetailComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventEntityDetailComponentProperties(JsonObject json, AuditEvent.AuditEventEntityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
    Basic res = new Basic();
    parseBasicProperties(json, res);
    return res;
  }

  protected void parseBasicProperties(JsonObject json, Basic res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDate(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
    Binary res = new Binary();
    parseBinaryProperties(json, res);
    return res;
  }

  protected void parseBinaryProperties(JsonObject json, Binary res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(json.getAsJsonObject("_contentType"), res.getContentTypeElement());
    if (json.has("securityContext"))
      res.setSecurityContext(parseReference(json.getAsJsonObject("securityContext")));
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(json.getAsJsonObject("_data"), res.getDataElement());
  }

  protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
    parseBiologicallyDerivedProductProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductProperties(JsonObject json, BiologicallyDerivedProduct res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productCategory"))
      res.setProductCategoryElement(parseEnumeration(json.get("productCategory").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory()));
    if (json.has("_productCategory"))
      parseElementProperties(json.getAsJsonObject("_productCategory"), res.getProductCategoryElement());
    if (json.has("productCode"))
      res.setProductCode(parseCodeableConcept(json.getAsJsonObject("productCode")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("request")) {
      JsonArray array = json.getAsJsonArray("request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantityElement(parseInteger(json.get("quantity").getAsLong()));
    if (json.has("_quantity"))
      parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        res.getParent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("collection"))
      res.setCollection(parseBiologicallyDerivedProductCollectionComponent(json.getAsJsonObject("collection")));
    if (json.has("processing")) {
      JsonArray array = json.getAsJsonArray("processing");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessing().add(parseBiologicallyDerivedProductProcessingComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manipulation"))
      res.setManipulation(parseBiologicallyDerivedProductManipulationComponent(json.getAsJsonObject("manipulation")));
    if (json.has("storage")) {
      JsonArray array = json.getAsJsonArray("storage");
      for (int i = 0; i < array.size(); i++) {
        res.getStorage().add(parseBiologicallyDerivedProductStorageComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductCollectionComponent(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
    parseBiologicallyDerivedProductCollectionComponentProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductCollectionComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("collector"))
      res.setCollector(parseReference(json.getAsJsonObject("collector")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    DataType collected = parseType("collected", json);
    if (collected != null)
      res.setCollected(collected);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent parseBiologicallyDerivedProductProcessingComponent(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
    parseBiologicallyDerivedProductProcessingComponentProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductProcessingComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("procedure"))
      res.setProcedure(parseCodeableConcept(json.getAsJsonObject("procedure")));
    if (json.has("additive"))
      res.setAdditive(parseReference(json.getAsJsonObject("additive")));
    DataType time = parseType("time", json);
    if (time != null)
      res.setTime(time);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent parseBiologicallyDerivedProductManipulationComponent(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
    parseBiologicallyDerivedProductManipulationComponentProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductManipulationComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    DataType time = parseType("time", json);
    if (time != null)
      res.setTime(time);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent parseBiologicallyDerivedProductStorageComponent(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
    parseBiologicallyDerivedProductStorageComponentProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductStorageComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("temperature"))
      res.setTemperatureElement(parseDecimal(json.get("temperature").getAsBigDecimal()));
    if (json.has("_temperature"))
      parseElementProperties(json.getAsJsonObject("_temperature"), res.getTemperatureElement());
    if (json.has("scale"))
      res.setScaleElement(parseEnumeration(json.get("scale").getAsString(), BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory()));
    if (json.has("_scale"))
      parseElementProperties(json.getAsJsonObject("_scale"), res.getScaleElement());
    if (json.has("duration"))
      res.setDuration(parsePeriod(json.getAsJsonObject("duration")));
  }

  protected BodyStructure parseBodyStructure(JsonObject json) throws IOException, FHIRFormatError {
    BodyStructure res = new BodyStructure();
    parseBodyStructureProperties(json, res);
    return res;
  }

  protected void parseBodyStructureProperties(JsonObject json, BodyStructure res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("morphology"))
      res.setMorphology(parseCodeableConcept(json.getAsJsonObject("morphology")));
    if (json.has("location"))
      res.setLocation(parseCodeableConcept(json.getAsJsonObject("location")));
    if (json.has("locationQualifier")) {
      JsonArray array = json.getAsJsonArray("locationQualifier");
      for (int i = 0; i < array.size(); i++) {
        res.getLocationQualifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
  }

  protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseBundleProperties(json, res);
    return res;
  }

  protected void parseBundleProperties(JsonObject json, Bundle res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("timestamp"))
      res.setTimestampElement(parseInstant(json.get("timestamp").getAsString()));
    if (json.has("_timestamp"))
      parseElementProperties(json.getAsJsonObject("_timestamp"), res.getTimestampElement());
    if (json.has("total"))
      res.setTotalElement(parseUnsignedInt(json.get("total").getAsString()));
    if (json.has("_total"))
      parseElementProperties(json.getAsJsonObject("_total"), res.getTotalElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleLinkComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseBundleEntryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("signature"))
      res.setSignature(parseSignature(json.getAsJsonObject("signature")));
  }

  protected Bundle.BundleLinkComponent parseBundleLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseBundleLinkComponentProperties(json, res);
    return res;
  }

  protected void parseBundleLinkComponentProperties(JsonObject json, Bundle.BundleLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relation"))
      res.setRelationElement(parseString(json.get("relation").getAsString()));
    if (json.has("_relation"))
      parseElementProperties(json.getAsJsonObject("_relation"), res.getRelationElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
  }

  protected Bundle.BundleEntryComponent parseBundleEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseBundleEntryComponentProperties(json, res);
    return res;
  }

  protected void parseBundleEntryComponentProperties(JsonObject json, Bundle.BundleEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleLinkComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fullUrl"))
      res.setFullUrlElement(parseUri(json.get("fullUrl").getAsString()));
    if (json.has("_fullUrl"))
      parseElementProperties(json.getAsJsonObject("_fullUrl"), res.getFullUrlElement());
    if (json.has("resource"))
      res.setResource(parseResource(json.getAsJsonObject("resource")));
    if (json.has("search"))
      res.setSearch(parseBundleEntrySearchComponent(json.getAsJsonObject("search")));
    if (json.has("request"))
      res.setRequest(parseBundleEntryRequestComponent(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseBundleEntryResponseComponent(json.getAsJsonObject("response")));
  }

  protected Bundle.BundleEntrySearchComponent parseBundleEntrySearchComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseBundleEntrySearchComponentProperties(json, res);
    return res;
  }

  protected void parseBundleEntrySearchComponentProperties(JsonObject json, Bundle.BundleEntrySearchComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("score"))
      res.setScoreElement(parseDecimal(json.get("score").getAsBigDecimal()));
    if (json.has("_score"))
      parseElementProperties(json.getAsJsonObject("_score"), res.getScoreElement());
  }

  protected Bundle.BundleEntryRequestComponent parseBundleEntryRequestComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseBundleEntryRequestComponentProperties(json, res);
    return res;
  }

  protected void parseBundleEntryRequestComponentProperties(JsonObject json, Bundle.BundleEntryRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("method"))
      res.setMethodElement(parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
    if (json.has("_method"))
      parseElementProperties(json.getAsJsonObject("_method"), res.getMethodElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("ifNoneMatch"))
      res.setIfNoneMatchElement(parseString(json.get("ifNoneMatch").getAsString()));
    if (json.has("_ifNoneMatch"))
      parseElementProperties(json.getAsJsonObject("_ifNoneMatch"), res.getIfNoneMatchElement());
    if (json.has("ifModifiedSince"))
      res.setIfModifiedSinceElement(parseInstant(json.get("ifModifiedSince").getAsString()));
    if (json.has("_ifModifiedSince"))
      parseElementProperties(json.getAsJsonObject("_ifModifiedSince"), res.getIfModifiedSinceElement());
    if (json.has("ifMatch"))
      res.setIfMatchElement(parseString(json.get("ifMatch").getAsString()));
    if (json.has("_ifMatch"))
      parseElementProperties(json.getAsJsonObject("_ifMatch"), res.getIfMatchElement());
    if (json.has("ifNoneExist"))
      res.setIfNoneExistElement(parseString(json.get("ifNoneExist").getAsString()));
    if (json.has("_ifNoneExist"))
      parseElementProperties(json.getAsJsonObject("_ifNoneExist"), res.getIfNoneExistElement());
  }

  protected Bundle.BundleEntryResponseComponent parseBundleEntryResponseComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseBundleEntryResponseComponentProperties(json, res);
    return res;
  }

  protected void parseBundleEntryResponseComponentProperties(JsonObject json, Bundle.BundleEntryResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseString(json.get("status").getAsString()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("location"))
      res.setLocationElement(parseUri(json.get("location").getAsString()));
    if (json.has("_location"))
      parseElementProperties(json.getAsJsonObject("_location"), res.getLocationElement());
    if (json.has("etag"))
      res.setEtagElement(parseString(json.get("etag").getAsString()));
    if (json.has("_etag"))
      parseElementProperties(json.getAsJsonObject("_etag"), res.getEtagElement());
    if (json.has("lastModified"))
      res.setLastModifiedElement(parseInstant(json.get("lastModified").getAsString()));
    if (json.has("_lastModified"))
      parseElementProperties(json.getAsJsonObject("_lastModified"), res.getLastModifiedElement());
    if (json.has("outcome"))
      res.setOutcome(parseResource(json.getAsJsonObject("outcome")));
  }

  protected CapabilityStatement parseCapabilityStatement(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement res = new CapabilityStatement();
    parseCapabilityStatementProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementProperties(JsonObject json, CapabilityStatement res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), Enumerations.CapabilityStatementKind.NULL, new Enumerations.CapabilityStatementKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiates().add(new CanonicalType());
        } else {;
          res.getInstantiates().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("imports")) {
      JsonArray array = json.getAsJsonArray("imports");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImports().add(new CanonicalType());
        } else {;
          res.getImports().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_imports")) {
      JsonArray array = json.getAsJsonArray("_imports");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImports().size())
          res.getImports().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImports().get(i));
      }
    };
    if (json.has("software"))
      res.setSoftware(parseCapabilityStatementSoftwareComponent(json.getAsJsonObject("software")));
    if (json.has("implementation"))
      res.setImplementation(parseCapabilityStatementImplementationComponent(json.getAsJsonObject("implementation")));
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseEnumeration(json.get("fhirVersion").getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("format")) {
      JsonArray array = json.getAsJsonArray("format");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFormat().add(new CodeType());
        } else {;
          res.getFormat().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_format")) {
      JsonArray array = json.getAsJsonArray("_format");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFormat().size())
          res.getFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
      }
    };
    if (json.has("patchFormat")) {
      JsonArray array = json.getAsJsonArray("patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPatchFormat().add(new CodeType());
        } else {;
          res.getPatchFormat().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_patchFormat")) {
      JsonArray array = json.getAsJsonArray("_patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPatchFormat().size())
          res.getPatchFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPatchFormat().get(i));
      }
    };
    if (json.has("implementationGuide")) {
      JsonArray array = json.getAsJsonArray("implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImplementationGuide().add(new CanonicalType());
        } else {;
          res.getImplementationGuide().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_implementationGuide")) {
      JsonArray array = json.getAsJsonArray("_implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImplementationGuide().size())
          res.getImplementationGuide().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImplementationGuide().get(i));
      }
    };
    if (json.has("rest")) {
      JsonArray array = json.getAsJsonArray("rest");
      for (int i = 0; i < array.size(); i++) {
        res.getRest().add(parseCapabilityStatementRestComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("messaging")) {
      JsonArray array = json.getAsJsonArray("messaging");
      for (int i = 0; i < array.size(); i++) {
        res.getMessaging().add(parseCapabilityStatementMessagingComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("document")) {
      JsonArray array = json.getAsJsonArray("document");
      for (int i = 0; i < array.size(); i++) {
        res.getDocument().add(parseCapabilityStatementDocumentComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementSoftwareComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
    parseCapabilityStatementSoftwareComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementSoftwareComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("releaseDate"))
      res.setReleaseDateElement(parseDateTime(json.get("releaseDate").getAsString()));
    if (json.has("_releaseDate"))
      parseElementProperties(json.getAsJsonObject("_releaseDate"), res.getReleaseDateElement());
  }

  protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementImplementationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
    parseCapabilityStatementImplementationComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementImplementationComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementImplementationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
  }

  protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementRestComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
    parseCapabilityStatementRestComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Enumerations.RestfulCapabilityMode.NULL, new Enumerations.RestfulCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("security"))
      res.setSecurity(parseCapabilityStatementRestSecurityComponent(json.getAsJsonObject("security")));
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCapabilityStatementRestResourceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementSystemInteractionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementRestResourceOperationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCompartment().add(new CanonicalType());
        } else {;
          res.getCompartment().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_compartment")) {
      JsonArray array = json.getAsJsonArray("_compartment");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCompartment().size())
          res.getCompartment().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementRestSecurityComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
    parseCapabilityStatementRestSecurityComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestSecurityComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("cors"))
      res.setCorsElement(parseBoolean(json.get("cors").getAsBoolean()));
    if (json.has("_cors"))
      parseElementProperties(json.getAsJsonObject("_cors"), res.getCorsElement());
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementRestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
    parseCapabilityStatementRestResourceComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestResourceComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("supportedProfile")) {
      JsonArray array = json.getAsJsonArray("supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSupportedProfile().add(new CanonicalType());
        } else {;
          res.getSupportedProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_supportedProfile")) {
      JsonArray array = json.getAsJsonArray("_supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportedProfile().size())
          res.getSupportedProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportedProfile().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementResourceInteractionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(json.getAsJsonObject("_versioning"), res.getVersioningElement());
    if (json.has("readHistory"))
      res.setReadHistoryElement(parseBoolean(json.get("readHistory").getAsBoolean()));
    if (json.has("_readHistory"))
      parseElementProperties(json.getAsJsonObject("_readHistory"), res.getReadHistoryElement());
    if (json.has("updateCreate"))
      res.setUpdateCreateElement(parseBoolean(json.get("updateCreate").getAsBoolean()));
    if (json.has("_updateCreate"))
      parseElementProperties(json.getAsJsonObject("_updateCreate"), res.getUpdateCreateElement());
    if (json.has("conditionalCreate"))
      res.setConditionalCreateElement(parseBoolean(json.get("conditionalCreate").getAsBoolean()));
    if (json.has("_conditionalCreate"))
      parseElementProperties(json.getAsJsonObject("_conditionalCreate"), res.getConditionalCreateElement());
    if (json.has("conditionalRead"))
      res.setConditionalReadElement(parseEnumeration(json.get("conditionalRead").getAsString(), CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
    if (json.has("_conditionalRead"))
      parseElementProperties(json.getAsJsonObject("_conditionalRead"), res.getConditionalReadElement());
    if (json.has("conditionalUpdate"))
      res.setConditionalUpdateElement(parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
    if (json.has("_conditionalUpdate"))
      parseElementProperties(json.getAsJsonObject("_conditionalUpdate"), res.getConditionalUpdateElement());
    if (json.has("conditionalDelete"))
      res.setConditionalDeleteElement(parseEnumeration(json.get("conditionalDelete").getAsString(), CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
    if (json.has("_conditionalDelete"))
      parseElementProperties(json.getAsJsonObject("_conditionalDelete"), res.getConditionalDeleteElement());
    if (json.has("referencePolicy")) {
      JsonArray array = json.getAsJsonArray("referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReferencePolicy().add(new Enumeration<CapabilityStatement.ReferenceHandlingPolicy>(new CapabilityStatement.ReferenceHandlingPolicyEnumFactory(), CapabilityStatement.ReferenceHandlingPolicy.NULL));
        } else {;
          res.getReferencePolicy().add(parseEnumeration(array.get(i).getAsString(), CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        }
      }
    };
    if (json.has("_referencePolicy")) {
      JsonArray array = json.getAsJsonArray("_referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReferencePolicy().size())
          res.getReferencePolicy().add(parseEnumeration(null, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReferencePolicy().get(i));
      }
    };
    if (json.has("searchInclude")) {
      JsonArray array = json.getAsJsonArray("searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSearchInclude().add(new StringType());
        } else {;
          res.getSearchInclude().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_searchInclude")) {
      JsonArray array = json.getAsJsonArray("_searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchInclude().size())
          res.getSearchInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchInclude().get(i));
      }
    };
    if (json.has("searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSearchRevInclude().add(new StringType());
        } else {;
          res.getSearchRevInclude().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_searchRevInclude")) {
      JsonArray array = json.getAsJsonArray("_searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchRevInclude().size())
          res.getSearchRevInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSearchRevInclude().get(i));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementRestResourceSearchParamComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementRestResourceOperationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
    parseCapabilityStatementResourceInteractionComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementResourceInteractionComponentProperties(JsonObject json, CapabilityStatement.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementRestResourceSearchParamComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
    parseCapabilityStatementRestResourceSearchParamComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementRestResourceOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
    parseCapabilityStatementRestResourceOperationComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestResourceOperationComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
    parseCapabilityStatementSystemInteractionComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementSystemInteractionComponentProperties(JsonObject json, CapabilityStatement.SystemInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementMessagingComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
    parseCapabilityStatementMessagingComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementMessagingComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseCapabilityStatementMessagingEndpointComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reliableCache"))
      res.setReliableCacheElement(parseUnsignedInt(json.get("reliableCache").getAsString()));
    if (json.has("_reliableCache"))
      parseElementProperties(json.getAsJsonObject("_reliableCache"), res.getReliableCacheElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("supportedMessage")) {
      JsonArray array = json.getAsJsonArray("supportedMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportedMessage().add(parseCapabilityStatementMessagingSupportedMessageComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementMessagingEndpointComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
    parseCapabilityStatementMessagingEndpointComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementMessagingEndpointComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("protocol"))
      res.setProtocol(parseCoding(json.getAsJsonObject("protocol")));
    if (json.has("address"))
      res.setAddressElement(parseUrl(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementMessagingSupportedMessageComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
    parseCapabilityStatementMessagingSupportedMessageComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementMessagingSupportedMessageComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
  }

  protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementDocumentComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
    parseCapabilityStatementDocumentComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementDocumentComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementDocumentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
  }

  protected CapabilityStatement2 parseCapabilityStatement2(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2 res = new CapabilityStatement2();
    parseCapabilityStatement2Properties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2Properties(JsonObject json, CapabilityStatement2 res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), Enumerations.CapabilityStatementKind.NULL, new Enumerations.CapabilityStatementKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiates().add(new CanonicalType());
        } else {;
          res.getInstantiates().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("imports")) {
      JsonArray array = json.getAsJsonArray("imports");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImports().add(new CanonicalType());
        } else {;
          res.getImports().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_imports")) {
      JsonArray array = json.getAsJsonArray("_imports");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImports().size())
          res.getImports().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImports().get(i));
      }
    };
    if (json.has("software"))
      res.setSoftware(parseCapabilityStatement2SoftwareComponent(json.getAsJsonObject("software")));
    if (json.has("implementation"))
      res.setImplementation(parseCapabilityStatement2ImplementationComponent(json.getAsJsonObject("implementation")));
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseEnumeration(json.get("fhirVersion").getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
    if (json.has("_fhirVersion"))
      parseElementProperties(json.getAsJsonObject("_fhirVersion"), res.getFhirVersionElement());
    if (json.has("format")) {
      JsonArray array = json.getAsJsonArray("format");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFormat().add(new CodeType());
        } else {;
          res.getFormat().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_format")) {
      JsonArray array = json.getAsJsonArray("_format");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFormat().size())
          res.getFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFormat().get(i));
      }
    };
    if (json.has("patchFormat")) {
      JsonArray array = json.getAsJsonArray("patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPatchFormat().add(new CodeType());
        } else {;
          res.getPatchFormat().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_patchFormat")) {
      JsonArray array = json.getAsJsonArray("_patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPatchFormat().size())
          res.getPatchFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPatchFormat().get(i));
      }
    };
    if (json.has("implementationGuide")) {
      JsonArray array = json.getAsJsonArray("implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImplementationGuide().add(new CanonicalType());
        } else {;
          res.getImplementationGuide().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_implementationGuide")) {
      JsonArray array = json.getAsJsonArray("_implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImplementationGuide().size())
          res.getImplementationGuide().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImplementationGuide().get(i));
      }
    };
    if (json.has("rest")) {
      JsonArray array = json.getAsJsonArray("rest");
      for (int i = 0; i < array.size(); i++) {
        res.getRest().add(parseCapabilityStatement2RestComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CapabilityStatement2.CapabilityStatement2SoftwareComponent parseCapabilityStatement2SoftwareComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2SoftwareComponent res = new CapabilityStatement2.CapabilityStatement2SoftwareComponent();
    parseCapabilityStatement2SoftwareComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2SoftwareComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2SoftwareComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("releaseDate"))
      res.setReleaseDateElement(parseDateTime(json.get("releaseDate").getAsString()));
    if (json.has("_releaseDate"))
      parseElementProperties(json.getAsJsonObject("_releaseDate"), res.getReleaseDateElement());
  }

  protected CapabilityStatement2.CapabilityStatement2ImplementationComponent parseCapabilityStatement2ImplementationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2ImplementationComponent res = new CapabilityStatement2.CapabilityStatement2ImplementationComponent();
    parseCapabilityStatement2ImplementationComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2ImplementationComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2ImplementationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
  }

  protected CapabilityStatement2.CapabilityStatement2RestComponent parseCapabilityStatement2RestComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2RestComponent res = new CapabilityStatement2.CapabilityStatement2RestComponent();
    parseCapabilityStatement2RestComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2RestComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2RestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Enumerations.RestfulCapabilityMode.NULL, new Enumerations.RestfulCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCapabilityStatement2RestResourceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatement2SystemInteractionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatement2RestResourceSearchParamComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatement2RestResourceOperationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCompartment().add(new CanonicalType());
        } else {;
          res.getCompartment().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_compartment")) {
      JsonArray array = json.getAsJsonArray("_compartment");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCompartment().size())
          res.getCompartment().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCompartment().get(i));
      }
    };
  }

  protected CapabilityStatement2.CapabilityStatement2RestResourceComponent parseCapabilityStatement2RestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2RestResourceComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceComponent();
    parseCapabilityStatement2RestResourceComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2RestResourceComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2RestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("supportedProfile")) {
      JsonArray array = json.getAsJsonArray("supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSupportedProfile().add(new CanonicalType());
        } else {;
          res.getSupportedProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_supportedProfile")) {
      JsonArray array = json.getAsJsonArray("_supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportedProfile().size())
          res.getSupportedProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportedProfile().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
    if (json.has("interaction")) {
      JsonArray array = json.getAsJsonArray("interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatement2ResourceInteractionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = json.getAsJsonArray("searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatement2RestResourceSearchParamComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("operation")) {
      JsonArray array = json.getAsJsonArray("operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatement2RestResourceOperationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CapabilityStatement2.ResourceInteractionComponent parseCapabilityStatement2ResourceInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2.ResourceInteractionComponent res = new CapabilityStatement2.ResourceInteractionComponent();
    parseCapabilityStatement2ResourceInteractionComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2ResourceInteractionComponentProperties(JsonObject json, CapabilityStatement2.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement2.TypeRestfulInteraction.NULL, new CapabilityStatement2.TypeRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent parseCapabilityStatement2RestResourceSearchParamComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent();
    parseCapabilityStatement2RestResourceSearchParamComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2RestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2RestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent parseCapabilityStatement2RestResourceOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent res = new CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent();
    parseCapabilityStatement2RestResourceOperationComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2RestResourceOperationComponentProperties(JsonObject json, CapabilityStatement2.CapabilityStatement2RestResourceOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement2.SystemInteractionComponent parseCapabilityStatement2SystemInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement2.SystemInteractionComponent res = new CapabilityStatement2.SystemInteractionComponent();
    parseCapabilityStatement2SystemInteractionComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatement2SystemInteractionComponentProperties(JsonObject json, CapabilityStatement2.SystemInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement2.SystemRestfulInteraction.NULL, new CapabilityStatement2.SystemRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseCarePlanProperties(json, res);
    return res;
  }

  protected void parseCarePlanProperties(JsonObject json, CarePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("activity")) {
      JsonArray array = json.getAsJsonArray("activity");
      for (int i = 0; i < array.size(); i++) {
        res.getActivity().add(parseCarePlanActivityComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanActivityComponent(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseCarePlanActivityComponentProperties(json, res);
    return res;
  }

  protected void parseCarePlanActivityComponentProperties(JsonObject json, CarePlan.CarePlanActivityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("outcome")) {
      JsonArray array = json.getAsJsonArray("outcome");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcome().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("progress")) {
      JsonArray array = json.getAsJsonArray("progress");
      for (int i = 0; i < array.size(); i++) {
        res.getProgress().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("detail"))
      res.setDetail(parseCarePlanActivityDetailComponent(json.getAsJsonObject("detail")));
  }

  protected CarePlan.CarePlanActivityDetailComponent parseCarePlanActivityDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
    parseCarePlanActivityDetailComponentProperties(json, res);
    return res;
  }

  protected void parseCarePlanActivityDetailComponentProperties(JsonObject json, CarePlan.CarePlanActivityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("goal")) {
      JsonArray array = json.getAsJsonArray("goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    DataType scheduled = parseType("scheduled", json);
    if (scheduled != null)
      res.setScheduled(scheduled);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    DataType reported = parseType("reported", json);
    if (reported != null)
      res.setReported(reported);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    DataType product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("dailyAmount"))
      res.setDailyAmount(parseQuantity(json.getAsJsonObject("dailyAmount")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseCareTeamProperties(json, res);
    return res;
  }

  protected void parseCareTeamProperties(JsonObject json, CareTeam res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseCareTeamParticipantComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("managingOrganization")) {
      JsonArray array = json.getAsJsonArray("managingOrganization");
      for (int i = 0; i < array.size(); i++) {
        res.getManagingOrganization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseCareTeamParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseCareTeamParticipantComponentProperties(JsonObject json, CareTeam.CareTeamParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("member"))
      res.setMember(parseReference(json.getAsJsonObject("member")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(json.getAsJsonObject("onBehalfOf")));
    DataType coverage = parseType("coverage", json);
    if (coverage != null)
      res.setCoverage(coverage);
  }

  protected CatalogEntry parseCatalogEntry(JsonObject json) throws IOException, FHIRFormatError {
    CatalogEntry res = new CatalogEntry();
    parseCatalogEntryProperties(json, res);
    return res;
  }

  protected void parseCatalogEntryProperties(JsonObject json, CatalogEntry res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), CatalogEntry.CatalogEntryType.NULL, new CatalogEntry.CatalogEntryTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CatalogEntry.CatalogEntryStatus.NULL, new CatalogEntry.CatalogEntryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("orderable"))
      res.setOrderableElement(parseBoolean(json.get("orderable").getAsBoolean()));
    if (json.has("_orderable"))
      parseElementProperties(json.getAsJsonObject("_orderable"), res.getOrderableElement());
    if (json.has("referencedItem"))
      res.setReferencedItem(parseReference(json.getAsJsonObject("referencedItem")));
    if (json.has("relatedEntry")) {
      JsonArray array = json.getAsJsonArray("relatedEntry");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedEntry().add(parseCatalogEntryRelatedEntryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("updatedBy"))
      res.setUpdatedBy(parseReference(json.getAsJsonObject("updatedBy")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("estimatedDuration"))
      res.setEstimatedDuration(parseDuration(json.getAsJsonObject("estimatedDuration")));
    if (json.has("billingCode")) {
      JsonArray array = json.getAsJsonArray("billingCode");
      for (int i = 0; i < array.size(); i++) {
        res.getBillingCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("billingSummary"))
      res.setBillingSummaryElement(parseString(json.get("billingSummary").getAsString()));
    if (json.has("_billingSummary"))
      parseElementProperties(json.getAsJsonObject("_billingSummary"), res.getBillingSummaryElement());
    if (json.has("scheduleSummary"))
      res.setScheduleSummaryElement(parseString(json.get("scheduleSummary").getAsString()));
    if (json.has("_scheduleSummary"))
      parseElementProperties(json.getAsJsonObject("_scheduleSummary"), res.getScheduleSummaryElement());
    if (json.has("limitationSummary"))
      res.setLimitationSummaryElement(parseString(json.get("limitationSummary").getAsString()));
    if (json.has("_limitationSummary"))
      parseElementProperties(json.getAsJsonObject("_limitationSummary"), res.getLimitationSummaryElement());
    if (json.has("regulatorySummary"))
      res.setRegulatorySummaryElement(parseString(json.get("regulatorySummary").getAsString()));
    if (json.has("_regulatorySummary"))
      parseElementProperties(json.getAsJsonObject("_regulatorySummary"), res.getRegulatorySummaryElement());
  }

  protected CatalogEntry.CatalogEntryRelatedEntryComponent parseCatalogEntryRelatedEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
    CatalogEntry.CatalogEntryRelatedEntryComponent res = new CatalogEntry.CatalogEntryRelatedEntryComponent();
    parseCatalogEntryRelatedEntryComponentProperties(json, res);
    return res;
  }

  protected void parseCatalogEntryRelatedEntryComponentProperties(JsonObject json, CatalogEntry.CatalogEntryRelatedEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relationship"))
      res.setRelationshipElement(parseEnumeration(json.get("relationship").getAsString(), CatalogEntry.CatalogEntryRelationType.NULL, new CatalogEntry.CatalogEntryRelationTypeEnumFactory()));
    if (json.has("_relationship"))
      parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
  }

  protected ChargeItem parseChargeItem(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItem res = new ChargeItem();
    parseChargeItemProperties(json, res);
    return res;
  }

  protected void parseChargeItemProperties(JsonObject json, ChargeItem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definitionUri")) {
      JsonArray array = json.getAsJsonArray("definitionUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinitionUri().add(new UriType());
        } else {;
          res.getDefinitionUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definitionUri")) {
      JsonArray array = json.getAsJsonArray("_definitionUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinitionUri().size())
          res.getDefinitionUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinitionUri().get(i));
      }
    };
    if (json.has("definitionCanonical")) {
      JsonArray array = json.getAsJsonArray("definitionCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinitionCanonical().add(new CanonicalType());
        } else {;
          res.getDefinitionCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definitionCanonical")) {
      JsonArray array = json.getAsJsonArray("_definitionCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinitionCanonical().size())
          res.getDefinitionCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinitionCanonical().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseChargeItemPerformerComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("performingOrganization"))
      res.setPerformingOrganization(parseReference(json.getAsJsonObject("performingOrganization")));
    if (json.has("requestingOrganization"))
      res.setRequestingOrganization(parseReference(json.getAsJsonObject("requestingOrganization")));
    if (json.has("costCenter"))
      res.setCostCenter(parseReference(json.getAsJsonObject("costCenter")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("bodysite")) {
      JsonArray array = json.getAsJsonArray("bodysite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodysite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("factorOverride"))
      res.setFactorOverrideElement(parseDecimal(json.get("factorOverride").getAsBigDecimal()));
    if (json.has("_factorOverride"))
      parseElementProperties(json.getAsJsonObject("_factorOverride"), res.getFactorOverrideElement());
    if (json.has("priceOverride"))
      res.setPriceOverride(parseMoney(json.getAsJsonObject("priceOverride")));
    if (json.has("overrideReason"))
      res.setOverrideReasonElement(parseString(json.get("overrideReason").getAsString()));
    if (json.has("_overrideReason"))
      parseElementProperties(json.getAsJsonObject("_overrideReason"), res.getOverrideReasonElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("enteredDate"))
      res.setEnteredDateElement(parseDateTime(json.get("enteredDate").getAsString()));
    if (json.has("_enteredDate"))
      parseElementProperties(json.getAsJsonObject("_enteredDate"), res.getEnteredDateElement());
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("service")) {
      JsonArray array = json.getAsJsonArray("service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    DataType product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ChargeItem.ChargeItemPerformerComponent parseChargeItemPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
    parseChargeItemPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseChargeItemPerformerComponentProperties(JsonObject json, ChargeItem.ChargeItemPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected ChargeItemDefinition parseChargeItemDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition res = new ChargeItemDefinition();
    parseChargeItemDefinitionProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionProperties(JsonObject json, ChargeItemDefinition res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("derivedFromUri")) {
      JsonArray array = json.getAsJsonArray("derivedFromUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDerivedFromUri().add(new UriType());
        } else {;
          res.getDerivedFromUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_derivedFromUri")) {
      JsonArray array = json.getAsJsonArray("_derivedFromUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDerivedFromUri().size())
          res.getDerivedFromUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDerivedFromUri().get(i));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPartOf().add(new CanonicalType());
        } else {;
          res.getPartOf().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_partOf")) {
      JsonArray array = json.getAsJsonArray("_partOf");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPartOf().size())
          res.getPartOf().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPartOf().get(i));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReplaces().add(new CanonicalType());
        } else {;
          res.getReplaces().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_replaces")) {
      JsonArray array = json.getAsJsonArray("_replaces");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReplaces().size())
          res.getReplaces().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReplaces().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("applicability")) {
      JsonArray array = json.getAsJsonArray("applicability");
      for (int i = 0; i < array.size(); i++) {
        res.getApplicability().add(parseChargeItemDefinitionApplicabilityComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("propertyGroup")) {
      JsonArray array = json.getAsJsonArray("propertyGroup");
      for (int i = 0; i < array.size(); i++) {
        res.getPropertyGroup().add(parseChargeItemDefinitionPropertyGroupComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionApplicabilityComponent(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
    parseChargeItemDefinitionApplicabilityComponentProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionApplicabilityComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("language"))
      res.setLanguageElement(parseString(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionPropertyGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
    parseChargeItemDefinitionPropertyGroupComponentProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionPropertyGroupComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("applicability")) {
      JsonArray array = json.getAsJsonArray("applicability");
      for (int i = 0; i < array.size(); i++) {
        res.getApplicability().add(parseChargeItemDefinitionApplicabilityComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priceComponent")) {
      JsonArray array = json.getAsJsonArray("priceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getPriceComponent().add(parseChargeItemDefinitionPropertyGroupPriceComponentComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent parseChargeItemDefinitionPropertyGroupPriceComponentComponent(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
    parseChargeItemDefinitionPropertyGroupPriceComponentComponentProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionPropertyGroupPriceComponentComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.InvoicePriceComponentType.NULL, new Enumerations.InvoicePriceComponentTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
    Claim res = new Claim();
    parseClaimProperties(json, res);
    return res;
  }

  protected void parseClaimProperties(JsonObject json, Claim res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(json.getAsJsonObject("billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(json.getAsJsonObject("fundsReserve")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseClaimRelatedClaimComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(json.getAsJsonObject("prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(json.getAsJsonObject("originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseClaimPayeeComponent(json.getAsJsonObject("payee")));
    if (json.has("referral"))
      res.setReferral(parseReference(json.getAsJsonObject("referral")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseClaimCareTeamComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseClaimSupportingInformationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseClaimDiagnosisComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseClaimProcedureComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimInsuranceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseClaimAccidentComponent(json.getAsJsonObject("accident")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimItemComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("total"))
      res.setTotal(parseMoney(json.getAsJsonObject("total")));
  }

  protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
    parseClaimRelatedClaimComponentProperties(json, res);
    return res;
  }

  protected void parseClaimRelatedClaimComponentProperties(JsonObject json, Claim.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(json.getAsJsonObject("reference")));
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseClaimPayeeComponentProperties(json, res);
    return res;
  }

  protected void parseClaimPayeeComponentProperties(JsonObject json, Claim.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected Claim.CareTeamComponent parseClaimCareTeamComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.CareTeamComponent res = new Claim.CareTeamComponent();
    parseClaimCareTeamComponentProperties(json, res);
    return res;
  }

  protected void parseClaimCareTeamComponentProperties(JsonObject json, Claim.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("qualification"))
      res.setQualification(parseCodeableConcept(json.getAsJsonObject("qualification")));
  }

  protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
    parseClaimSupportingInformationComponentProperties(json, res);
    return res;
  }

  protected void parseClaimSupportingInformationComponentProperties(JsonObject json, Claim.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseClaimDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseClaimDiagnosisComponentProperties(JsonObject json, Claim.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    DataType diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmission(parseCodeableConcept(json.getAsJsonObject("onAdmission")));
    if (json.has("packageCode"))
      res.setPackageCode(parseCodeableConcept(json.getAsJsonObject("packageCode")));
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseClaimProcedureComponentProperties(json, res);
    return res;
  }

  protected void parseClaimProcedureComponentProperties(JsonObject json, Claim.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    DataType procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Claim.InsuranceComponent parseClaimInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.InsuranceComponent res = new Claim.InsuranceComponent();
    parseClaimInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseClaimInsuranceComponentProperties(JsonObject json, Claim.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {;
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
  }

  protected Claim.AccidentComponent parseClaimAccidentComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.AccidentComponent res = new Claim.AccidentComponent();
    parseClaimAccidentComponentProperties(json, res);
    return res;
  }

  protected void parseClaimAccidentComponentProperties(JsonObject json, Claim.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected Claim.ItemComponent parseClaimItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.ItemComponent res = new Claim.ItemComponent();
    parseClaimItemComponentProperties(json, res);
    return res;
  }

  protected void parseClaimItemComponentProperties(JsonObject json, Claim.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCareTeamSequence().add(new PositiveIntType());
        } else {;
          res.getCareTeamSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("_careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamSequence().size())
          res.getCareTeamSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCareTeamSequence().get(i));
      }
    };
    if (json.has("diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDiagnosisSequence().add(new PositiveIntType());
        } else {;
          res.getDiagnosisSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("_diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisSequence().size())
          res.getDiagnosisSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisSequence().get(i));
      }
    };
    if (json.has("procedureSequence")) {
      JsonArray array = json.getAsJsonArray("procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProcedureSequence().add(new PositiveIntType());
        } else {;
          res.getProcedureSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_procedureSequence")) {
      JsonArray array = json.getAsJsonArray("_procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureSequence().size())
          res.getProcedureSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProcedureSequence().get(i));
      }
    };
    if (json.has("informationSequence")) {
      JsonArray array = json.getAsJsonArray("informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInformationSequence().add(new PositiveIntType());
        } else {;
          res.getInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_informationSequence")) {
      JsonArray array = json.getAsJsonArray("_informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationSequence().size())
          res.getInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInformationSequence().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseClaimDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimDetailComponentProperties(JsonObject json, Claim.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimSubDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseClaimSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimSubDetailComponentProperties(JsonObject json, Claim.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseClaimResponseProperties(json, res);
    return res;
  }

  protected void parseClaimResponseProperties(JsonObject json, ClaimResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("requestor"))
      res.setRequestor(parseReference(json.getAsJsonObject("requestor")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(json.getAsJsonObject("_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("preAuthPeriod"))
      res.setPreAuthPeriod(parsePeriod(json.getAsJsonObject("preAuthPeriod")));
    if (json.has("payeeType"))
      res.setPayeeType(parseCodeableConcept(json.getAsJsonObject("payeeType")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimResponseItemComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseClaimResponseAddedItemComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("total")) {
      JsonArray array = json.getAsJsonArray("total");
      for (int i = 0; i < array.size(); i++) {
        res.getTotal().add(parseClaimResponseTotalComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payment"))
      res.setPayment(parseClaimResponsePaymentComponent(json.getAsJsonObject("payment")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(json.getAsJsonObject("fundsReserve")));
    if (json.has("formCode"))
      res.setFormCode(parseCodeableConcept(json.getAsJsonObject("formCode")));
    if (json.has("form"))
      res.setForm(parseAttachment(json.getAsJsonObject("form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseClaimResponseNoteComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("communicationRequest")) {
      JsonArray array = json.getAsJsonArray("communicationRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunicationRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimResponseInsuranceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseClaimResponseErrorComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
    parseClaimResponseItemComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseItemComponentProperties(JsonObject json, ClaimResponse.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence"))
      res.setItemSequenceElement(parsePositiveInt(json.get("itemSequence").getAsString()));
    if (json.has("_itemSequence"))
      parseElementProperties(json.getAsJsonObject("_itemSequence"), res.getItemSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseItemDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
    parseClaimResponseAdjudicationComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseAdjudicationComponentProperties(JsonObject json, ClaimResponse.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseClaimResponseItemDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseItemDetailComponentProperties(JsonObject json, ClaimResponse.ItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("detailSequence"))
      res.setDetailSequenceElement(parsePositiveInt(json.get("detailSequence").getAsString()));
    if (json.has("_detailSequence"))
      parseElementProperties(json.getAsJsonObject("_detailSequence"), res.getDetailSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseSubDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseClaimResponseSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseSubDetailComponentProperties(JsonObject json, ClaimResponse.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("subDetailSequence"))
      res.setSubDetailSequenceElement(parsePositiveInt(json.get("subDetailSequence").getAsString()));
    if (json.has("_subDetailSequence"))
      parseElementProperties(json.getAsJsonObject("_subDetailSequence"), res.getSubDetailSequenceElement());
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseClaimResponseAddedItemComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseAddedItemComponentProperties(JsonObject json, ClaimResponse.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence")) {
      JsonArray array = json.getAsJsonArray("itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getItemSequence().add(new PositiveIntType());
        } else {;
          res.getItemSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_itemSequence")) {
      JsonArray array = json.getAsJsonArray("_itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getItemSequence().size())
          res.getItemSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getItemSequence().get(i));
      }
    };
    if (json.has("detailSequence")) {
      JsonArray array = json.getAsJsonArray("detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDetailSequence().add(new PositiveIntType());
        } else {;
          res.getDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_detailSequence")) {
      JsonArray array = json.getAsJsonArray("_detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDetailSequence().size())
          res.getDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDetailSequence().get(i));
      }
    };
    if (json.has("subdetailSequence")) {
      JsonArray array = json.getAsJsonArray("subdetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSubdetailSequence().add(new PositiveIntType());
        } else {;
          res.getSubdetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_subdetailSequence")) {
      JsonArray array = json.getAsJsonArray("_subdetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubdetailSequence().size())
          res.getSubdetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSubdetailSequence().get(i));
      }
    };
    if (json.has("provider")) {
      JsonArray array = json.getAsJsonArray("provider");
      for (int i = 0; i < array.size(); i++) {
        res.getProvider().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseAddedItemDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
    parseClaimResponseAddedItemDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseAddedItemDetailComponentProperties(JsonObject json, ClaimResponse.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseAddedItemSubDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
    parseClaimResponseAddedItemSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseAddedItemSubDetailComponentProperties(JsonObject json, ClaimResponse.AddedItemSubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
    parseClaimResponseTotalComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseTotalComponentProperties(JsonObject json, ClaimResponse.TotalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
    parseClaimResponsePaymentComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponsePaymentComponentProperties(JsonObject json, ClaimResponse.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(json.getAsJsonObject("adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(json.getAsJsonObject("adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
  }

  protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
    parseClaimResponseNoteComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseNoteComponentProperties(JsonObject json, ClaimResponse.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
  }

  protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
    parseClaimResponseInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseInsuranceComponentProperties(JsonObject json, ClaimResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
  }

  protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
    parseClaimResponseErrorComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseErrorComponentProperties(JsonObject json, ClaimResponse.ErrorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence"))
      res.setItemSequenceElement(parsePositiveInt(json.get("itemSequence").getAsString()));
    if (json.has("_itemSequence"))
      parseElementProperties(json.getAsJsonObject("_itemSequence"), res.getItemSequenceElement());
    if (json.has("detailSequence"))
      res.setDetailSequenceElement(parsePositiveInt(json.get("detailSequence").getAsString()));
    if (json.has("_detailSequence"))
      parseElementProperties(json.getAsJsonObject("_detailSequence"), res.getDetailSequenceElement());
    if (json.has("subDetailSequence"))
      res.setSubDetailSequenceElement(parsePositiveInt(json.get("subDetailSequence").getAsString()));
    if (json.has("_subDetailSequence"))
      parseElementProperties(json.getAsJsonObject("_subDetailSequence"), res.getSubDetailSequenceElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseClinicalImpressionProperties(json, res);
    return res;
  }

  protected void parseClinicalImpressionProperties(JsonObject json, ClinicalImpression res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("previous"))
      res.setPrevious(parseReference(json.getAsJsonObject("previous")));
    if (json.has("problem")) {
      JsonArray array = json.getAsJsonArray("problem");
      for (int i = 0; i < array.size(); i++) {
        res.getProblem().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("protocol")) {
      JsonArray array = json.getAsJsonArray("protocol");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProtocol().add(new UriType());
        } else {;
          res.getProtocol().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_protocol")) {
      JsonArray array = json.getAsJsonArray("_protocol");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProtocol().size())
          res.getProtocol().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProtocol().get(i));
      }
    };
    if (json.has("summary"))
      res.setSummaryElement(parseString(json.get("summary").getAsString()));
    if (json.has("_summary"))
      parseElementProperties(json.getAsJsonObject("_summary"), res.getSummaryElement());
    if (json.has("finding")) {
      JsonArray array = json.getAsJsonArray("finding");
      for (int i = 0; i < array.size(); i++) {
        res.getFinding().add(parseClinicalImpressionFindingComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prognosisCodeableConcept")) {
      JsonArray array = json.getAsJsonArray("prognosisCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisCodeableConcept().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prognosisReference")) {
      JsonArray array = json.getAsJsonArray("prognosisReference");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionFindingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseClinicalImpressionFindingComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalImpressionFindingComponentProperties(JsonObject json, ClinicalImpression.ClinicalImpressionFindingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("item"))
      res.setItem(parseCodeableReference(json.getAsJsonObject("item")));
    if (json.has("basis"))
      res.setBasisElement(parseString(json.get("basis").getAsString()));
    if (json.has("_basis"))
      parseElementProperties(json.getAsJsonObject("_basis"), res.getBasisElement());
  }

  protected ClinicalUseIssue parseClinicalUseIssue(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseIssue res = new ClinicalUseIssue();
    parseClinicalUseIssueProperties(json, res);
    return res;
  }

  protected void parseClinicalUseIssueProperties(JsonObject json, ClinicalUseIssue res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ClinicalUseIssue.ClinicalUseIssueType.NULL, new ClinicalUseIssue.ClinicalUseIssueTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("contraindication"))
      res.setContraindication(parseClinicalUseIssueContraindicationComponent(json.getAsJsonObject("contraindication")));
    if (json.has("indication"))
      res.setIndication(parseClinicalUseIssueIndicationComponent(json.getAsJsonObject("indication")));
    if (json.has("interaction"))
      res.setInteraction(parseClinicalUseIssueInteractionComponent(json.getAsJsonObject("interaction")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parsePopulation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("undesirableEffect"))
      res.setUndesirableEffect(parseClinicalUseIssueUndesirableEffectComponent(json.getAsJsonObject("undesirableEffect")));
  }

  protected ClinicalUseIssue.ClinicalUseIssueContraindicationComponent parseClinicalUseIssueContraindicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueContraindicationComponent res = new ClinicalUseIssue.ClinicalUseIssueContraindicationComponent();
    parseClinicalUseIssueContraindicationComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseIssueContraindicationComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueContraindicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("diseaseSymptomProcedure"))
      res.setDiseaseSymptomProcedure(parseCodeableConcept(json.getAsJsonObject("diseaseSymptomProcedure")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableConcept(json.getAsJsonObject("diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = json.getAsJsonArray("comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("indication")) {
      JsonArray array = json.getAsJsonArray("indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("otherTherapy")) {
      JsonArray array = json.getAsJsonArray("otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseClinicalUseIssueContraindicationOtherTherapyComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent parseClinicalUseIssueContraindicationOtherTherapyComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent res = new ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent();
    parseClinicalUseIssueContraindicationOtherTherapyComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseIssueContraindicationOtherTherapyComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueContraindicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("therapyRelationshipType"))
      res.setTherapyRelationshipType(parseCodeableConcept(json.getAsJsonObject("therapyRelationshipType")));
    DataType medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
  }

  protected ClinicalUseIssue.ClinicalUseIssueIndicationComponent parseClinicalUseIssueIndicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueIndicationComponent res = new ClinicalUseIssue.ClinicalUseIssueIndicationComponent();
    parseClinicalUseIssueIndicationComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseIssueIndicationComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueIndicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("diseaseSymptomProcedure"))
      res.setDiseaseSymptomProcedure(parseCodeableConcept(json.getAsJsonObject("diseaseSymptomProcedure")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableConcept(json.getAsJsonObject("diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = json.getAsJsonArray("comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("intendedEffect"))
      res.setIntendedEffect(parseCodeableConcept(json.getAsJsonObject("intendedEffect")));
    if (json.has("duration"))
      res.setDuration(parseQuantity(json.getAsJsonObject("duration")));
    if (json.has("undesirableEffect")) {
      JsonArray array = json.getAsJsonArray("undesirableEffect");
      for (int i = 0; i < array.size(); i++) {
        res.getUndesirableEffect().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("otherTherapy")) {
      JsonArray array = json.getAsJsonArray("otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseClinicalUseIssueContraindicationOtherTherapyComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ClinicalUseIssue.ClinicalUseIssueInteractionComponent parseClinicalUseIssueInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueInteractionComponent res = new ClinicalUseIssue.ClinicalUseIssueInteractionComponent();
    parseClinicalUseIssueInteractionComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseIssueInteractionComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("interactant")) {
      JsonArray array = json.getAsJsonArray("interactant");
      for (int i = 0; i < array.size(); i++) {
        res.getInteractant().add(parseClinicalUseIssueInteractionInteractantComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("effect"))
      res.setEffect(parseCodeableConcept(json.getAsJsonObject("effect")));
    if (json.has("incidence"))
      res.setIncidence(parseCodeableConcept(json.getAsJsonObject("incidence")));
    if (json.has("management"))
      res.setManagement(parseCodeableConcept(json.getAsJsonObject("management")));
  }

  protected ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent parseClinicalUseIssueInteractionInteractantComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent res = new ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent();
    parseClinicalUseIssueInteractionInteractantComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseIssueInteractionInteractantComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueInteractionInteractantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent parseClinicalUseIssueUndesirableEffectComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent res = new ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent();
    parseClinicalUseIssueUndesirableEffectComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseIssueUndesirableEffectComponentProperties(JsonObject json, ClinicalUseIssue.ClinicalUseIssueUndesirableEffectComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("symptomConditionEffect"))
      res.setSymptomConditionEffect(parseCodeableConcept(json.getAsJsonObject("symptomConditionEffect")));
    if (json.has("classification"))
      res.setClassification(parseCodeableConcept(json.getAsJsonObject("classification")));
    if (json.has("frequencyOfOccurrence"))
      res.setFrequencyOfOccurrence(parseCodeableConcept(json.getAsJsonObject("frequencyOfOccurrence")));
  }

  protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseCodeSystemProperties(json, res);
    return res;
  }

  protected void parseCodeSystemProperties(JsonObject json, CodeSystem res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("caseSensitive"))
      res.setCaseSensitiveElement(parseBoolean(json.get("caseSensitive").getAsBoolean()));
    if (json.has("_caseSensitive"))
      parseElementProperties(json.getAsJsonObject("_caseSensitive"), res.getCaseSensitiveElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(json.getAsJsonObject("_valueSet"), res.getValueSetElement());
    if (json.has("hierarchyMeaning"))
      res.setHierarchyMeaningElement(parseEnumeration(json.get("hierarchyMeaning").getAsString(), CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
    if (json.has("_hierarchyMeaning"))
      parseElementProperties(json.getAsJsonObject("_hierarchyMeaning"), res.getHierarchyMeaningElement());
    if (json.has("compositional"))
      res.setCompositionalElement(parseBoolean(json.get("compositional").getAsBoolean()));
    if (json.has("_compositional"))
      parseElementProperties(json.getAsJsonObject("_compositional"), res.getCompositionalElement());
    if (json.has("versionNeeded"))
      res.setVersionNeededElement(parseBoolean(json.get("versionNeeded").getAsBoolean()));
    if (json.has("_versionNeeded"))
      parseElementProperties(json.getAsJsonObject("_versionNeeded"), res.getVersionNeededElement());
    if (json.has("content"))
      res.setContentElement(parseEnumeration(json.get("content").getAsString(), CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
    if (json.has("_content"))
      parseElementProperties(json.getAsJsonObject("_content"), res.getContentElement());
    if (json.has("supplements"))
      res.setSupplementsElement(parseCanonical(json.get("supplements").getAsString()));
    if (json.has("_supplements"))
      parseElementProperties(json.getAsJsonObject("_supplements"), res.getSupplementsElement());
    if (json.has("count"))
      res.setCountElement(parseUnsignedInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("filter")) {
      JsonArray array = json.getAsJsonArray("filter");
      for (int i = 0; i < array.size(); i++) {
        res.getFilter().add(parseCodeSystemFilterComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemPropertyComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseCodeSystemFilterComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemFilterComponentProperties(JsonObject json, CodeSystem.CodeSystemFilterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("operator")) {
      JsonArray array = json.getAsJsonArray("operator");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getOperator().add(new Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory(), Enumerations.FilterOperator.NULL));
        } else {;
          res.getOperator().add(parseEnumeration(array.get(i).getAsString(), Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
        }
      }
    };
    if (json.has("_operator")) {
      JsonArray array = json.getAsJsonArray("_operator");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOperator().size())
          res.getOperator().add(parseEnumeration(null, Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOperator().get(i));
      }
    };
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
    parseCodeSystemPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemPropertyComponentProperties(JsonObject json, CodeSystem.PropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseCodeSystemConceptDefinitionComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionComponentProperties(JsonObject json, CodeSystem.ConceptDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseString(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
    if (json.has("designation")) {
      JsonArray array = json.getAsJsonArray("designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation().add(parseCodeSystemConceptDefinitionDesignationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemConceptPropertyComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("concept")) {
      JsonArray array = json.getAsJsonArray("concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseCodeSystemConceptDefinitionDesignationComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionDesignationComponentProperties(JsonObject json, CodeSystem.ConceptDefinitionDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(json.getAsJsonObject("_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(json.getAsJsonObject("use")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
    parseCodeSystemConceptPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemConceptPropertyComponentProperties(JsonObject json, CodeSystem.ConceptPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
    Communication res = new Communication();
    parseCommunicationProperties(json, res);
    return res;
  }

  protected void parseCommunicationProperties(JsonObject json, Communication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("inResponseTo")) {
      JsonArray array = json.getAsJsonArray("inResponseTo");
      for (int i = 0; i < array.size(); i++) {
        res.getInResponseTo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("topic"))
      res.setTopic(parseCodeableConcept(json.getAsJsonObject("topic")));
    if (json.has("about")) {
      JsonArray array = json.getAsJsonArray("about");
      for (int i = 0; i < array.size(); i++) {
        res.getAbout().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("sent"))
      res.setSentElement(parseDateTime(json.get("sent").getAsString()));
    if (json.has("_sent"))
      parseElementProperties(json.getAsJsonObject("_sent"), res.getSentElement());
    if (json.has("received"))
      res.setReceivedElement(parseDateTime(json.get("received").getAsString()));
    if (json.has("_received"))
      parseElementProperties(json.getAsJsonObject("_received"), res.getReceivedElement());
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationPayloadComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseCommunicationPayloadComponentProperties(json, res);
    return res;
  }

  protected void parseCommunicationPayloadComponentProperties(JsonObject json, Communication.CommunicationPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseCommunicationRequestProperties(json, res);
    return res;
  }

  protected void parseCommunicationRequestProperties(JsonObject json, CommunicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("medium")) {
      JsonArray array = json.getAsJsonArray("medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("about")) {
      JsonArray array = json.getAsJsonArray("about");
      for (int i = 0; i < array.size(); i++) {
        res.getAbout().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("payload")) {
      JsonArray array = json.getAsJsonArray("payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationRequestPayloadComponent(array.get(i).getAsJsonObject()));
      }
    };
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("informationProvider")) {
      JsonArray array = json.getAsJsonArray("informationProvider");
      for (int i = 0; i < array.size(); i++) {
        res.getInformationProvider().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseCommunicationRequestPayloadComponentProperties(json, res);
    return res;
  }

  protected void parseCommunicationRequestPayloadComponentProperties(JsonObject json, CommunicationRequest.CommunicationRequestPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseCompartmentDefinitionProperties(json, res);
    return res;
  }

  protected void parseCompartmentDefinitionProperties(JsonObject json, CompartmentDefinition res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("search"))
      res.setSearchElement(parseBoolean(json.get("search").getAsBoolean()));
    if (json.has("_search"))
      parseElementProperties(json.getAsJsonObject("_search"), res.getSearchElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCompartmentDefinitionResourceComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseCompartmentDefinitionResourceComponentProperties(json, res);
    return res;
  }

  protected void parseCompartmentDefinitionResourceComponentProperties(JsonObject json, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("param")) {
      JsonArray array = json.getAsJsonArray("param");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getParam().add(new StringType());
        } else {;
          res.getParam().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_param")) {
      JsonArray array = json.getAsJsonArray("_param");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParam().size())
          res.getParam().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParam().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(json.getAsJsonObject("_documentation"), res.getDocumentationElement());
  }

  protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
    Composition res = new Composition();
    parseCompositionProperties(json, res);
    return res;
  }

  protected void parseCompositionProperties(JsonObject json, Composition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("confidentiality"))
      res.setConfidentialityElement(parseEnumeration(json.get("confidentiality").getAsString(), Composition.V3ConfidentialityClassification.NULL, new Composition.V3ConfidentialityClassificationEnumFactory()));
    if (json.has("_confidentiality"))
      parseElementProperties(json.getAsJsonObject("_confidentiality"), res.getConfidentialityElement());
    if (json.has("attester")) {
      JsonArray array = json.getAsJsonArray("attester");
      for (int i = 0; i < array.size(); i++) {
        res.getAttester().add(parseCompositionAttesterComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseCompositionRelatesToComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCompositionEventComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Composition.CompositionAttesterComponent parseCompositionAttesterComponent(JsonObject json) throws IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseCompositionAttesterComponentProperties(json, res);
    return res;
  }

  protected void parseCompositionAttesterComponentProperties(JsonObject json, Composition.CompositionAttesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected Composition.CompositionRelatesToComponent parseCompositionRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
    Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
    parseCompositionRelatesToComponentProperties(json, res);
    return res;
  }

  protected void parseCompositionRelatesToComponentProperties(JsonObject json, Composition.CompositionRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Enumerations.DocumentRelationshipType.NULL, new Enumerations.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    DataType target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
  }

  protected Composition.CompositionEventComponent parseCompositionEventComponent(JsonObject json) throws IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseCompositionEventComponentProperties(json, res);
    return res;
  }

  protected void parseCompositionEventComponentProperties(JsonObject json, Composition.CompositionEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseCompositionSectionComponentProperties(json, res);
    return res;
  }

  protected void parseCompositionSectionComponentProperties(JsonObject json, Composition.SectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("focus"))
      res.setFocus(parseReference(json.getAsJsonObject("focus")));
    if (json.has("text"))
      res.setText(parseNarrative(json.getAsJsonObject("text")));
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(json.getAsJsonObject("orderedBy")));
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(json.getAsJsonObject("emptyReason")));
    if (json.has("section")) {
      JsonArray array = json.getAsJsonArray("section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseConceptMapProperties(json, res);
    return res;
  }

  protected void parseConceptMapProperties(JsonObject json, ConceptMap res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.addIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    DataType source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    DataType target = parseType("target", json);
    if (target != null)
      res.setTarget(target);
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseConceptMapGroupComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ConceptMap.ConceptMapGroupComponent parseConceptMapGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
    parseConceptMapGroupComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapGroupComponentProperties(JsonObject json, ConceptMap.ConceptMapGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("sourceVersion"))
      res.setSourceVersionElement(parseString(json.get("sourceVersion").getAsString()));
    if (json.has("_sourceVersion"))
      parseElementProperties(json.getAsJsonObject("_sourceVersion"), res.getSourceVersionElement());
    if (json.has("target"))
      res.setTargetElement(parseUri(json.get("target").getAsString()));
    if (json.has("_target"))
      parseElementProperties(json.getAsJsonObject("_target"), res.getTargetElement());
    if (json.has("targetVersion"))
      res.setTargetVersionElement(parseString(json.get("targetVersion").getAsString()));
    if (json.has("_targetVersion"))
      parseElementProperties(json.getAsJsonObject("_targetVersion"), res.getTargetVersionElement());
    if (json.has("element")) {
      JsonArray array = json.getAsJsonArray("element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseConceptMapSourceElementComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("unmapped"))
      res.setUnmapped(parseConceptMapGroupUnmappedComponent(json.getAsJsonObject("unmapped")));
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseConceptMapSourceElementComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapSourceElementComponentProperties(JsonObject json, ConceptMap.SourceElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("noMap"))
      res.setNoMapElement(parseBoolean(json.get("noMap").getAsBoolean()));
    if (json.has("_noMap"))
      parseElementProperties(json.getAsJsonObject("_noMap"), res.getNoMapElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseConceptMapTargetElementComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseConceptMapTargetElementComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapTargetElementComponentProperties(JsonObject json, ConceptMap.TargetElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("relationship"))
      res.setRelationshipElement(parseEnumeration(json.get("relationship").getAsString(), Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
    if (json.has("_relationship"))
      parseElementProperties(json.getAsJsonObject("_relationship"), res.getRelationshipElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("dependsOn")) {
      JsonArray array = json.getAsJsonArray("dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("product")) {
      JsonArray array = json.getAsJsonArray("product");
      for (int i = 0; i < array.size(); i++) {
        res.getProduct().add(parseConceptMapOtherElementComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseConceptMapOtherElementComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapOtherElementComponentProperties(JsonObject json, ConceptMap.OtherElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("property"))
      res.setPropertyElement(parseUri(json.get("property").getAsString()));
    if (json.has("_property"))
      parseElementProperties(json.getAsJsonObject("_property"), res.getPropertyElement());
    if (json.has("system"))
      res.setSystemElement(parseCanonical(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(json.getAsJsonObject("_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
  }

  protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapGroupUnmappedComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
    parseConceptMapGroupUnmappedComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapGroupUnmappedComponentProperties(JsonObject json, ConceptMap.ConceptMapGroupUnmappedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(json.getAsJsonObject("_display"), res.getDisplayElement());
    if (json.has("url"))
      res.setUrlElement(parseCanonical(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
  }

  protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
    Condition res = new Condition();
    parseConditionProperties(json, res);
    return res;
  }

  protected void parseConditionProperties(JsonObject json, Condition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatus(parseCodeableConcept(json.getAsJsonObject("clinicalStatus")));
    if (json.has("verificationStatus"))
      res.setVerificationStatus(parseCodeableConcept(json.getAsJsonObject("verificationStatus")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(json.getAsJsonObject("severity")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("bodySite")) {
      JsonArray array = json.getAsJsonArray("bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    DataType abatement = parseType("abatement", json);
    if (abatement != null)
      res.setAbatement(abatement);
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(json.getAsJsonObject("_recordedDate"), res.getRecordedDateElement());
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("asserter"))
      res.setAsserter(parseReference(json.getAsJsonObject("asserter")));
    if (json.has("stage")) {
      JsonArray array = json.getAsJsonArray("stage");
      for (int i = 0; i < array.size(); i++) {
        res.getStage().add(parseConditionStageComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evidence")) {
      JsonArray array = json.getAsJsonArray("evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseConditionEvidenceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Condition.ConditionStageComponent parseConditionStageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseConditionStageComponentProperties(json, res);
    return res;
  }

  protected void parseConditionStageComponentProperties(JsonObject json, Condition.ConditionStageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("summary"))
      res.setSummary(parseCodeableConcept(json.getAsJsonObject("summary")));
    if (json.has("assessment")) {
      JsonArray array = json.getAsJsonArray("assessment");
      for (int i = 0; i < array.size(); i++) {
        res.getAssessment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
  }

  protected Condition.ConditionEvidenceComponent parseConditionEvidenceComponent(JsonObject json) throws IOException, FHIRFormatError {
    Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
    parseConditionEvidenceComponentProperties(json, res);
    return res;
  }

  protected void parseConditionEvidenceComponentProperties(JsonObject json, Condition.ConditionEvidenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ConditionDefinition parseConditionDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition res = new ConditionDefinition();
    parseConditionDefinitionProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionProperties(JsonObject json, ConditionDefinition res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(json.getAsJsonObject("severity")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("stage"))
      res.setStage(parseCodeableConcept(json.getAsJsonObject("stage")));
    if (json.has("hasSeverity"))
      res.setHasSeverityElement(parseBoolean(json.get("hasSeverity").getAsBoolean()));
    if (json.has("_hasSeverity"))
      parseElementProperties(json.getAsJsonObject("_hasSeverity"), res.getHasSeverityElement());
    if (json.has("hasBodySite"))
      res.setHasBodySiteElement(parseBoolean(json.get("hasBodySite").getAsBoolean()));
    if (json.has("_hasBodySite"))
      parseElementProperties(json.getAsJsonObject("_hasBodySite"), res.getHasBodySiteElement());
    if (json.has("hasStage"))
      res.setHasStageElement(parseBoolean(json.get("hasStage").getAsBoolean()));
    if (json.has("_hasStage"))
      parseElementProperties(json.getAsJsonObject("_hasStage"), res.getHasStageElement());
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinition().add(new UriType());
        } else {;
          res.getDefinition().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definition")) {
      JsonArray array = json.getAsJsonArray("_definition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinition().size())
          res.getDefinition().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
      }
    };
    if (json.has("observation")) {
      JsonArray array = json.getAsJsonArray("observation");
      for (int i = 0; i < array.size(); i++) {
        res.getObservation().add(parseConditionDefinitionObservationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("medication")) {
      JsonArray array = json.getAsJsonArray("medication");
      for (int i = 0; i < array.size(); i++) {
        res.getMedication().add(parseConditionDefinitionMedicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("precondition")) {
      JsonArray array = json.getAsJsonArray("precondition");
      for (int i = 0; i < array.size(); i++) {
        res.getPrecondition().add(parseConditionDefinitionPreconditionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("team")) {
      JsonArray array = json.getAsJsonArray("team");
      for (int i = 0; i < array.size(); i++) {
        res.getTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("questionnaire")) {
      JsonArray array = json.getAsJsonArray("questionnaire");
      for (int i = 0; i < array.size(); i++) {
        res.getQuestionnaire().add(parseConditionDefinitionQuestionnaireComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("plan")) {
      JsonArray array = json.getAsJsonArray("plan");
      for (int i = 0; i < array.size(); i++) {
        res.getPlan().add(parseConditionDefinitionPlanComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ConditionDefinition.ConditionDefinitionObservationComponent parseConditionDefinitionObservationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionObservationComponent res = new ConditionDefinition.ConditionDefinitionObservationComponent();
    parseConditionDefinitionObservationComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionObservationComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionObservationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected ConditionDefinition.ConditionDefinitionMedicationComponent parseConditionDefinitionMedicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionMedicationComponent res = new ConditionDefinition.ConditionDefinitionMedicationComponent();
    parseConditionDefinitionMedicationComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionMedicationComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionMedicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected ConditionDefinition.ConditionDefinitionPreconditionComponent parseConditionDefinitionPreconditionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionPreconditionComponent res = new ConditionDefinition.ConditionDefinitionPreconditionComponent();
    parseConditionDefinitionPreconditionComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionPreconditionComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionPreconditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ConditionDefinition.ConditionPreconditionType.NULL, new ConditionDefinition.ConditionPreconditionTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ConditionDefinition.ConditionDefinitionQuestionnaireComponent parseConditionDefinitionQuestionnaireComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionQuestionnaireComponent res = new ConditionDefinition.ConditionDefinitionQuestionnaireComponent();
    parseConditionDefinitionQuestionnaireComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionQuestionnaireComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionQuestionnaireComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("purpose"))
      res.setPurposeElement(parseEnumeration(json.get("purpose").getAsString(), ConditionDefinition.ConditionQuestionnairePurpose.NULL, new ConditionDefinition.ConditionQuestionnairePurposeEnumFactory()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected ConditionDefinition.ConditionDefinitionPlanComponent parseConditionDefinitionPlanComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionPlanComponent res = new ConditionDefinition.ConditionDefinitionPlanComponent();
    parseConditionDefinitionPlanComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionPlanComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionPlanComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Consent parseConsent(JsonObject json) throws IOException, FHIRFormatError {
    Consent res = new Consent();
    parseConsentProperties(json, res);
    return res;
  }

  protected void parseConsentProperties(JsonObject json, Consent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(json.getAsJsonObject("scope")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("organization")) {
      JsonArray array = json.getAsJsonArray("organization");
      for (int i = 0; i < array.size(); i++) {
        res.getOrganization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("sourceAttachment")) {
      JsonArray array = json.getAsJsonArray("sourceAttachment");
      for (int i = 0; i < array.size(); i++) {
        res.getSourceAttachment().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("sourceReference")) {
      JsonArray array = json.getAsJsonArray("sourceReference");
      for (int i = 0; i < array.size(); i++) {
        res.getSourceReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("policy")) {
      JsonArray array = json.getAsJsonArray("policy");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicy().add(parseConsentPolicyComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("policyRule"))
      res.setPolicyRule(parseCodeableConcept(json.getAsJsonObject("policyRule")));
    if (json.has("verification")) {
      JsonArray array = json.getAsJsonArray("verification");
      for (int i = 0; i < array.size(); i++) {
        res.getVerification().add(parseConsentVerificationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("provision"))
      res.setProvision(parseConsentProvisionComponent(json.getAsJsonObject("provision")));
  }

  protected Consent.ConsentPolicyComponent parseConsentPolicyComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
    parseConsentPolicyComponentProperties(json, res);
    return res;
  }

  protected void parseConsentPolicyComponentProperties(JsonObject json, Consent.ConsentPolicyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("authority"))
      res.setAuthorityElement(parseUri(json.get("authority").getAsString()));
    if (json.has("_authority"))
      parseElementProperties(json.getAsJsonObject("_authority"), res.getAuthorityElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
  }

  protected Consent.ConsentVerificationComponent parseConsentVerificationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
    parseConsentVerificationComponentProperties(json, res);
    return res;
  }

  protected void parseConsentVerificationComponentProperties(JsonObject json, Consent.ConsentVerificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("verified"))
      res.setVerifiedElement(parseBoolean(json.get("verified").getAsBoolean()));
    if (json.has("_verified"))
      parseElementProperties(json.getAsJsonObject("_verified"), res.getVerifiedElement());
    if (json.has("verificationType"))
      res.setVerificationType(parseCodeableConcept(json.getAsJsonObject("verificationType")));
    if (json.has("verifiedBy"))
      res.setVerifiedBy(parseReference(json.getAsJsonObject("verifiedBy")));
    if (json.has("verifiedWith"))
      res.setVerifiedWith(parseReference(json.getAsJsonObject("verifiedWith")));
    if (json.has("verificationDate")) {
      JsonArray array = json.getAsJsonArray("verificationDate");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getVerificationDate().add(new DateTimeType());
        } else {;
          res.getVerificationDate().add(parseDateTime(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_verificationDate")) {
      JsonArray array = json.getAsJsonArray("_verificationDate");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getVerificationDate().size())
          res.getVerificationDate().add(parseDateTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getVerificationDate().get(i));
      }
    };
  }

  protected Consent.ProvisionComponent parseConsentProvisionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ProvisionComponent res = new Consent.ProvisionComponent();
    parseConsentProvisionComponentProperties(json, res);
    return res;
  }

  protected void parseConsentProvisionComponentProperties(JsonObject json, Consent.ProvisionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Consent.ConsentProvisionType.NULL, new Consent.ConsentProvisionTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseConsentProvisionActorComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        res.getPurpose().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("class")) {
      JsonArray array = json.getAsJsonArray("class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataPeriod"))
      res.setDataPeriod(parsePeriod(json.getAsJsonObject("dataPeriod")));
    if (json.has("data")) {
      JsonArray array = json.getAsJsonArray("data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseConsentProvisionDataComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("provision")) {
      JsonArray array = json.getAsJsonArray("provision");
      for (int i = 0; i < array.size(); i++) {
        res.getProvision().add(parseConsentProvisionComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Consent.ProvisionActorComponent parseConsentProvisionActorComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ProvisionActorComponent res = new Consent.ProvisionActorComponent();
    parseConsentProvisionActorComponentProperties(json, res);
    return res;
  }

  protected void parseConsentProvisionActorComponentProperties(JsonObject json, Consent.ProvisionActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Consent.ProvisionDataComponent parseConsentProvisionDataComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ProvisionDataComponent res = new Consent.ProvisionDataComponent();
    parseConsentProvisionDataComponentProperties(json, res);
    return res;
  }

  protected void parseConsentProvisionDataComponentProperties(JsonObject json, Consent.ProvisionDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("meaning"))
      res.setMeaningElement(parseEnumeration(json.get("meaning").getAsString(), Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
    if (json.has("_meaning"))
      parseElementProperties(json.getAsJsonObject("_meaning"), res.getMeaningElement());
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
  }

  protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
    Contract res = new Contract();
    parseContractProperties(json, res);
    return res;
  }

  protected void parseContractProperties(JsonObject json, Contract res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Contract.ContractResourceStatusCodes.NULL, new Contract.ContractResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("legalState"))
      res.setLegalState(parseCodeableConcept(json.getAsJsonObject("legalState")));
    if (json.has("instantiatesCanonical"))
      res.setInstantiatesCanonical(parseReference(json.getAsJsonObject("instantiatesCanonical")));
    if (json.has("instantiatesUri"))
      res.setInstantiatesUriElement(parseUri(json.get("instantiatesUri").getAsString()));
    if (json.has("_instantiatesUri"))
      parseElementProperties(json.getAsJsonObject("_instantiatesUri"), res.getInstantiatesUriElement());
    if (json.has("contentDerivative"))
      res.setContentDerivative(parseCodeableConcept(json.getAsJsonObject("contentDerivative")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(json.getAsJsonObject("applies")));
    if (json.has("expirationType"))
      res.setExpirationType(parseCodeableConcept(json.getAsJsonObject("expirationType")));
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authority")) {
      JsonArray array = json.getAsJsonArray("authority");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthority().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("domain")) {
      JsonArray array = json.getAsJsonArray("domain");
      for (int i = 0; i < array.size(); i++) {
        res.getDomain().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("site")) {
      JsonArray array = json.getAsJsonArray("site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {;
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(json.getAsJsonObject("scope")));
    DataType topic = parseType("topic", json);
    if (topic != null)
      res.setTopic(topic);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType")) {
      JsonArray array = json.getAsJsonArray("subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contentDefinition"))
      res.setContentDefinition(parseContractContentDefinitionComponent(json.getAsJsonObject("contentDefinition")));
    if (json.has("term")) {
      JsonArray array = json.getAsJsonArray("term");
      for (int i = 0; i < array.size(); i++) {
        res.getTerm().add(parseContractTermComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("signer")) {
      JsonArray array = json.getAsJsonArray("signer");
      for (int i = 0; i < array.size(); i++) {
        res.getSigner().add(parseContractSignatoryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("friendly")) {
      JsonArray array = json.getAsJsonArray("friendly");
      for (int i = 0; i < array.size(); i++) {
        res.getFriendly().add(parseContractFriendlyLanguageComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("legal")) {
      JsonArray array = json.getAsJsonArray("legal");
      for (int i = 0; i < array.size(); i++) {
        res.getLegal().add(parseContractLegalLanguageComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("rule")) {
      JsonArray array = json.getAsJsonArray("rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseContractComputableLanguageComponent(array.get(i).getAsJsonObject()));
      }
    };
    DataType legallyBinding = parseType("legallyBinding", json);
    if (legallyBinding != null)
      res.setLegallyBinding(legallyBinding);
  }

  protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
    parseContractContentDefinitionComponentProperties(json, res);
    return res;
  }

  protected void parseContractContentDefinitionComponentProperties(JsonObject json, Contract.ContentDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("publisher"))
      res.setPublisher(parseReference(json.getAsJsonObject("publisher")));
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDateTime(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(json.getAsJsonObject("_publicationDate"), res.getPublicationDateElement());
    if (json.has("publicationStatus"))
      res.setPublicationStatusElement(parseEnumeration(json.get("publicationStatus").getAsString(), Contract.ContractResourcePublicationStatusCodes.NULL, new Contract.ContractResourcePublicationStatusCodesEnumFactory()));
    if (json.has("_publicationStatus"))
      parseElementProperties(json.getAsJsonObject("_publicationStatus"), res.getPublicationStatusElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
  }

  protected Contract.TermComponent parseContractTermComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseContractTermComponentProperties(json, res);
    return res;
  }

  protected void parseContractTermComponentProperties(JsonObject json, Contract.TermComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(json.getAsJsonObject("applies")));
    DataType topic = parseType("topic", json);
    if (topic != null)
      res.setTopic(topic);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseContractSecurityLabelComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("offer"))
      res.setOffer(parseContractOfferComponent(json.getAsJsonObject("offer")));
    if (json.has("asset")) {
      JsonArray array = json.getAsJsonArray("asset");
      for (int i = 0; i < array.size(); i++) {
        res.getAsset().add(parseContractAssetComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("action")) {
      JsonArray array = json.getAsJsonArray("action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseContractActionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseContractTermComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
    parseContractSecurityLabelComponentProperties(json, res);
    return res;
  }

  protected void parseContractSecurityLabelComponentProperties(JsonObject json, Contract.SecurityLabelComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number")) {
      JsonArray array = json.getAsJsonArray("number");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumber().add(new UnsignedIntType());
        } else {;
          res.getNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_number")) {
      JsonArray array = json.getAsJsonArray("_number");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumber().size())
          res.getNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumber().get(i));
      }
    };
    if (json.has("classification"))
      res.setClassification(parseCoding(json.getAsJsonObject("classification")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("control")) {
      JsonArray array = json.getAsJsonArray("control");
      for (int i = 0; i < array.size(); i++) {
        res.getControl().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.ContractOfferComponent parseContractOfferComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
    parseContractOfferComponentProperties(json, res);
    return res;
  }

  protected void parseContractOfferComponentProperties(JsonObject json, Contract.ContractOfferComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("party")) {
      JsonArray array = json.getAsJsonArray("party");
      for (int i = 0; i < array.size(); i++) {
        res.getParty().add(parseContractPartyComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("topic"))
      res.setTopic(parseReference(json.getAsJsonObject("topic")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("decision"))
      res.setDecision(parseCodeableConcept(json.getAsJsonObject("decision")));
    if (json.has("decisionMode")) {
      JsonArray array = json.getAsJsonArray("decisionMode");
      for (int i = 0; i < array.size(); i++) {
        res.getDecisionMode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("answer")) {
      JsonArray array = json.getAsJsonArray("answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseContractAnswerComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {;
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {;
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ContractPartyComponent parseContractPartyComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
    parseContractPartyComponentProperties(json, res);
    return res;
  }

  protected void parseContractPartyComponentProperties(JsonObject json, Contract.ContractPartyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
  }

  protected Contract.AnswerComponent parseContractAnswerComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.AnswerComponent res = new Contract.AnswerComponent();
    parseContractAnswerComponentProperties(json, res);
    return res;
  }

  protected void parseContractAnswerComponentProperties(JsonObject json, Contract.AnswerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Contract.ContractAssetComponent parseContractAssetComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
    parseContractAssetComponentProperties(json, res);
    return res;
  }

  protected void parseContractAssetComponentProperties(JsonObject json, Contract.ContractAssetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(json.getAsJsonObject("scope")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("typeReference")) {
      JsonArray array = json.getAsJsonArray("typeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getTypeReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subtype")) {
      JsonArray array = json.getAsJsonArray("subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relationship"))
      res.setRelationship(parseCoding(json.getAsJsonObject("relationship")));
    if (json.has("context")) {
      JsonArray array = json.getAsJsonArray("context");
      for (int i = 0; i < array.size(); i++) {
        res.getContext().add(parseContractAssetContextComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition"))
      res.setConditionElement(parseString(json.get("condition").getAsString()));
    if (json.has("_condition"))
      parseElementProperties(json.getAsJsonObject("_condition"), res.getConditionElement());
    if (json.has("periodType")) {
      JsonArray array = json.getAsJsonArray("periodType");
      for (int i = 0; i < array.size(); i++) {
        res.getPeriodType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period")) {
      JsonArray array = json.getAsJsonArray("period");
      for (int i = 0; i < array.size(); i++) {
        res.getPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("usePeriod")) {
      JsonArray array = json.getAsJsonArray("usePeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getUsePeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {;
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("answer")) {
      JsonArray array = json.getAsJsonArray("answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseContractAnswerComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {;
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
    if (json.has("valuedItem")) {
      JsonArray array = json.getAsJsonArray("valuedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getValuedItem().add(parseContractValuedItemComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.AssetContextComponent parseContractAssetContextComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.AssetContextComponent res = new Contract.AssetContextComponent();
    parseContractAssetContextComponentProperties(json, res);
    return res;
  }

  protected void parseContractAssetContextComponentProperties(JsonObject json, Contract.AssetContextComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseContractValuedItemComponentProperties(json, res);
    return res;
  }

  protected void parseContractValuedItemComponentProperties(JsonObject json, Contract.ValuedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType entity = parseType("entity", json);
    if (entity != null)
      res.setEntity(entity);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("effectiveTime"))
      res.setEffectiveTimeElement(parseDateTime(json.get("effectiveTime").getAsString()));
    if (json.has("_effectiveTime"))
      parseElementProperties(json.getAsJsonObject("_effectiveTime"), res.getEffectiveTimeElement());
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(json.getAsJsonObject("_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("payment"))
      res.setPaymentElement(parseString(json.get("payment").getAsString()));
    if (json.has("_payment"))
      parseElementProperties(json.getAsJsonObject("_payment"), res.getPaymentElement());
    if (json.has("paymentDate"))
      res.setPaymentDateElement(parseDateTime(json.get("paymentDate").getAsString()));
    if (json.has("_paymentDate"))
      parseElementProperties(json.getAsJsonObject("_paymentDate"), res.getPaymentDateElement());
    if (json.has("responsible"))
      res.setResponsible(parseReference(json.getAsJsonObject("responsible")));
    if (json.has("recipient"))
      res.setRecipient(parseReference(json.getAsJsonObject("recipient")));
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {;
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {;
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ActionComponent parseContractActionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ActionComponent res = new Contract.ActionComponent();
    parseContractActionComponentProperties(json, res);
    return res;
  }

  protected void parseContractActionComponentProperties(JsonObject json, Contract.ActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject")) {
      JsonArray array = json.getAsJsonArray("subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseContractActionSubjectComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("intent"))
      res.setIntent(parseCodeableConcept(json.getAsJsonObject("intent")));
    if (json.has("linkId")) {
      JsonArray array = json.getAsJsonArray("linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {;
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = json.getAsJsonArray("_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLinkId().get(i));
      }
    };
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(json.getAsJsonObject("status")));
    if (json.has("context"))
      res.setContext(parseReference(json.getAsJsonObject("context")));
    if (json.has("contextLinkId")) {
      JsonArray array = json.getAsJsonArray("contextLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getContextLinkId().add(new StringType());
        } else {;
          res.getContextLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_contextLinkId")) {
      JsonArray array = json.getAsJsonArray("_contextLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getContextLinkId().size())
          res.getContextLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getContextLinkId().get(i));
      }
    };
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("requester")) {
      JsonArray array = json.getAsJsonArray("requester");
      for (int i = 0; i < array.size(); i++) {
        res.getRequester().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("requesterLinkId")) {
      JsonArray array = json.getAsJsonArray("requesterLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getRequesterLinkId().add(new StringType());
        } else {;
          res.getRequesterLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_requesterLinkId")) {
      JsonArray array = json.getAsJsonArray("_requesterLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRequesterLinkId().size())
          res.getRequesterLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getRequesterLinkId().get(i));
      }
    };
    if (json.has("performerType")) {
      JsonArray array = json.getAsJsonArray("performerType");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformerType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("performerRole"))
      res.setPerformerRole(parseCodeableConcept(json.getAsJsonObject("performerRole")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("performerLinkId")) {
      JsonArray array = json.getAsJsonArray("performerLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPerformerLinkId().add(new StringType());
        } else {;
          res.getPerformerLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_performerLinkId")) {
      JsonArray array = json.getAsJsonArray("_performerLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPerformerLinkId().size())
          res.getPerformerLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPerformerLinkId().get(i));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonLinkId")) {
      JsonArray array = json.getAsJsonArray("reasonLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReasonLinkId().add(new StringType());
        } else {;
          res.getReasonLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_reasonLinkId")) {
      JsonArray array = json.getAsJsonArray("_reasonLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReasonLinkId().size())
          res.getReasonLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReasonLinkId().get(i));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {;
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = json.getAsJsonArray("_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
    parseContractActionSubjectComponentProperties(json, res);
    return res;
  }

  protected void parseContractActionSubjectComponentProperties(JsonObject json, Contract.ActionSubjectComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseContractSignatoryComponentProperties(json, res);
    return res;
  }

  protected void parseContractSignatoryComponentProperties(JsonObject json, Contract.SignatoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
    if (json.has("signature")) {
      JsonArray array = json.getAsJsonArray("signature");
      for (int i = 0; i < array.size(); i++) {
        res.getSignature().add(parseSignature(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseContractFriendlyLanguageComponentProperties(json, res);
    return res;
  }

  protected void parseContractFriendlyLanguageComponentProperties(JsonObject json, Contract.FriendlyLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseContractLegalLanguageComponentProperties(json, res);
    return res;
  }

  protected void parseContractLegalLanguageComponentProperties(JsonObject json, Contract.LegalLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseContractComputableLanguageComponentProperties(json, res);
    return res;
  }

  protected void parseContractComputableLanguageComponentProperties(JsonObject json, Contract.ComputableLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseCoverageProperties(json, res);
    return res;
  }

  protected void parseCoverageProperties(JsonObject json, Coverage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("policyHolder"))
      res.setPolicyHolder(parseReference(json.getAsJsonObject("policyHolder")));
    if (json.has("subscriber"))
      res.setSubscriber(parseReference(json.getAsJsonObject("subscriber")));
    if (json.has("subscriberId"))
      res.setSubscriberId(parseIdentifier(json.getAsJsonObject("subscriberId")));
    if (json.has("beneficiary"))
      res.setBeneficiary(parseReference(json.getAsJsonObject("beneficiary")));
    if (json.has("dependent"))
      res.setDependentElement(parseString(json.get("dependent").getAsString()));
    if (json.has("_dependent"))
      parseElementProperties(json.getAsJsonObject("_dependent"), res.getDependentElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("payor")) {
      JsonArray array = json.getAsJsonArray("payor");
      for (int i = 0; i < array.size(); i++) {
        res.getPayor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("class")) {
      JsonArray array = json.getAsJsonArray("class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCoverageClassComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("order"))
      res.setOrderElement(parsePositiveInt(json.get("order").getAsString()));
    if (json.has("_order"))
      parseElementProperties(json.getAsJsonObject("_order"), res.getOrderElement());
    if (json.has("network"))
      res.setNetworkElement(parseString(json.get("network").getAsString()));
    if (json.has("_network"))
      parseElementProperties(json.getAsJsonObject("_network"), res.getNetworkElement());
    if (json.has("costToBeneficiary")) {
      JsonArray array = json.getAsJsonArray("costToBeneficiary");
      for (int i = 0; i < array.size(); i++) {
        res.getCostToBeneficiary().add(parseCoverageCostToBeneficiaryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subrogation"))
      res.setSubrogationElement(parseBoolean(json.get("subrogation").getAsBoolean()));
    if (json.has("_subrogation"))
      parseElementProperties(json.getAsJsonObject("_subrogation"), res.getSubrogationElement());
    if (json.has("contract")) {
      JsonArray array = json.getAsJsonArray("contract");
      for (int i = 0; i < array.size(); i++) {
        res.getContract().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Coverage.ClassComponent parseCoverageClassComponent(JsonObject json) throws IOException, FHIRFormatError {
    Coverage.ClassComponent res = new Coverage.ClassComponent();
    parseCoverageClassComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageClassComponentProperties(JsonObject json, Coverage.ClassComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
  }

  protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
    parseCoverageCostToBeneficiaryComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageCostToBeneficiaryComponentProperties(JsonObject json, Coverage.CostToBeneficiaryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exception")) {
      JsonArray array = json.getAsJsonArray("exception");
      for (int i = 0; i < array.size(); i++) {
        res.getException().add(parseCoverageExemptionComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Coverage.ExemptionComponent parseCoverageExemptionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
    parseCoverageExemptionComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageExemptionComponentProperties(JsonObject json, Coverage.ExemptionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected CoverageEligibilityRequest parseCoverageEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest res = new CoverageEligibilityRequest();
    parseCoverageEligibilityRequestProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestProperties(JsonObject json, CoverageEligibilityRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPurpose().add(new Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose>(new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL));
        } else {;
          res.getPurpose().add(parseEnumeration(array.get(i).getAsString(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        }
      }
    };
    if (json.has("_purpose")) {
      JsonArray array = json.getAsJsonArray("_purpose");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPurpose().size())
          res.getPurpose().add(parseEnumeration(null, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPurpose().get(i));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseCoverageEligibilityRequestSupportingInformationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseCoverageEligibilityRequestInsuranceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseCoverageEligibilityRequestDetailsComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
    parseCoverageEligibilityRequestSupportingInformationComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestSupportingInformationComponentProperties(JsonObject json, CoverageEligibilityRequest.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("information"))
      res.setInformation(parseReference(json.getAsJsonObject("information")));
    if (json.has("appliesToAll"))
      res.setAppliesToAllElement(parseBoolean(json.get("appliesToAll").getAsBoolean()));
    if (json.has("_appliesToAll"))
      parseElementProperties(json.getAsJsonObject("_appliesToAll"), res.getAppliesToAllElement());
  }

  protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
    parseCoverageEligibilityRequestInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestInsuranceComponentProperties(JsonObject json, CoverageEligibilityRequest.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(json.getAsJsonObject("_businessArrangement"), res.getBusinessArrangementElement());
  }

  protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
    parseCoverageEligibilityRequestDetailsComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestDetailsComponentProperties(JsonObject json, CoverageEligibilityRequest.DetailsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("supportingInfoSequence")) {
      JsonArray array = json.getAsJsonArray("supportingInfoSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSupportingInfoSequence().add(new PositiveIntType());
        } else {;
          res.getSupportingInfoSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_supportingInfoSequence")) {
      JsonArray array = json.getAsJsonArray("_supportingInfoSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportingInfoSequence().size())
          res.getSupportingInfoSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSupportingInfoSequence().get(i));
      }
    };
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseCoverageEligibilityRequestDiagnosisComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
    parseCoverageEligibilityRequestDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestDiagnosisComponentProperties(JsonObject json, CoverageEligibilityRequest.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
  }

  protected CoverageEligibilityResponse parseCoverageEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse res = new CoverageEligibilityResponse();
    parseCoverageEligibilityResponseProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseProperties(JsonObject json, CoverageEligibilityResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("purpose")) {
      JsonArray array = json.getAsJsonArray("purpose");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPurpose().add(new Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose>(new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL));
        } else {;
          res.getPurpose().add(parseEnumeration(array.get(i).getAsString(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        }
      }
    };
    if (json.has("_purpose")) {
      JsonArray array = json.getAsJsonArray("_purpose");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPurpose().size())
          res.getPurpose().add(parseEnumeration(null, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPurpose().get(i));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("requestor"))
      res.setRequestor(parseReference(json.getAsJsonObject("requestor")));
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseCoverageEligibilityResponseInsuranceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(json.getAsJsonObject("_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("form"))
      res.setForm(parseCodeableConcept(json.getAsJsonObject("form")));
    if (json.has("error")) {
      JsonArray array = json.getAsJsonArray("error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseCoverageEligibilityResponseErrorsComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
    parseCoverageEligibilityResponseInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseInsuranceComponentProperties(JsonObject json, CoverageEligibilityResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("inforce"))
      res.setInforceElement(parseBoolean(json.get("inforce").getAsBoolean()));
    if (json.has("_inforce"))
      parseElementProperties(json.getAsJsonObject("_inforce"), res.getInforceElement());
    if (json.has("benefitPeriod"))
      res.setBenefitPeriod(parsePeriod(json.getAsJsonObject("benefitPeriod")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseCoverageEligibilityResponseItemsComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
    parseCoverageEligibilityResponseItemsComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseItemsComponentProperties(JsonObject json, CoverageEligibilityResponse.ItemsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(json.getAsJsonObject("_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(json.getAsJsonObject("network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(json.getAsJsonObject("term")));
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseCoverageEligibilityResponseBenefitComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authorizationRequired"))
      res.setAuthorizationRequiredElement(parseBoolean(json.get("authorizationRequired").getAsBoolean()));
    if (json.has("_authorizationRequired"))
      parseElementProperties(json.getAsJsonObject("_authorizationRequired"), res.getAuthorizationRequiredElement());
    if (json.has("authorizationSupporting")) {
      JsonArray array = json.getAsJsonArray("authorizationSupporting");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizationSupporting().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authorizationUrl"))
      res.setAuthorizationUrlElement(parseUri(json.get("authorizationUrl").getAsString()));
    if (json.has("_authorizationUrl"))
      parseElementProperties(json.getAsJsonObject("_authorizationUrl"), res.getAuthorizationUrlElement());
  }

  protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
    parseCoverageEligibilityResponseBenefitComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseBenefitComponentProperties(JsonObject json, CoverageEligibilityResponse.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    DataType used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
    parseCoverageEligibilityResponseErrorsComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseErrorsComponentProperties(JsonObject json, CoverageEligibilityResponse.ErrorsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseDetectedIssueProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueProperties(JsonObject json, DetectedIssue res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.ObservationStatus.NULL, new Enumerations.ObservationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(json.getAsJsonObject("_severity"), res.getSeverityElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    DataType identified = parseType("identified", json);
    if (identified != null)
      res.setIdentified(identified);
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("implicated")) {
      JsonArray array = json.getAsJsonArray("implicated");
      for (int i = 0; i < array.size(); i++) {
        res.getImplicated().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evidence")) {
      JsonArray array = json.getAsJsonArray("evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseDetectedIssueEvidenceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail"))
      res.setDetailElement(parseString(json.get("detail").getAsString()));
    if (json.has("_detail"))
      parseElementProperties(json.getAsJsonObject("_detail"), res.getDetailElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("mitigation")) {
      JsonArray array = json.getAsJsonArray("mitigation");
      for (int i = 0; i < array.size(); i++) {
        res.getMitigation().add(parseDetectedIssueMitigationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueEvidenceComponent(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
    parseDetectedIssueEvidenceComponentProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueEvidenceComponentProperties(JsonObject json, DetectedIssue.DetectedIssueEvidenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueMitigationComponent(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseDetectedIssueMitigationComponentProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueMitigationComponentProperties(JsonObject json, DetectedIssue.DetectedIssueMitigationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("action"))
      res.setAction(parseCodeableConcept(json.getAsJsonObject("action")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
    Device res = new Device();
    parseDeviceProperties(json, res);
    return res;
  }

  protected void parseDeviceProperties(JsonObject json, Device res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition"))
      res.setDefinition(parseReference(json.getAsJsonObject("definition")));
    if (json.has("udiCarrier")) {
      JsonArray array = json.getAsJsonArray("udiCarrier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiCarrier().add(parseDeviceUdiCarrierComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("distinctIdentifier"))
      res.setDistinctIdentifierElement(parseString(json.get("distinctIdentifier").getAsString()));
    if (json.has("_distinctIdentifier"))
      parseElementProperties(json.getAsJsonObject("_distinctIdentifier"), res.getDistinctIdentifierElement());
    if (json.has("manufacturer"))
      res.setManufacturerElement(parseString(json.get("manufacturer").getAsString()));
    if (json.has("_manufacturer"))
      parseElementProperties(json.getAsJsonObject("_manufacturer"), res.getManufacturerElement());
    if (json.has("manufactureDate"))
      res.setManufactureDateElement(parseDateTime(json.get("manufactureDate").getAsString()));
    if (json.has("_manufactureDate"))
      parseElementProperties(json.getAsJsonObject("_manufactureDate"), res.getManufactureDateElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("serialNumber"))
      res.setSerialNumberElement(parseString(json.get("serialNumber").getAsString()));
    if (json.has("_serialNumber"))
      parseElementProperties(json.getAsJsonObject("_serialNumber"), res.getSerialNumberElement());
    if (json.has("deviceName")) {
      JsonArray array = json.getAsJsonArray("deviceName");
      for (int i = 0; i < array.size(); i++) {
        res.getDeviceName().add(parseDeviceDeviceNameComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(json.getAsJsonObject("_modelNumber"), res.getModelNumberElement());
    if (json.has("partNumber"))
      res.setPartNumberElement(parseString(json.get("partNumber").getAsString()));
    if (json.has("_partNumber"))
      parseElementProperties(json.getAsJsonObject("_partNumber"), res.getPartNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("specialization")) {
      JsonArray array = json.getAsJsonArray("specialization");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialization().add(parseDeviceSpecializationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseDeviceVersionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseDevicePropertyComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("safety")) {
      JsonArray array = json.getAsJsonArray("safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
  }

  protected Device.DeviceUdiCarrierComponent parseDeviceUdiCarrierComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
    parseDeviceUdiCarrierComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceUdiCarrierComponentProperties(JsonObject json, Device.DeviceUdiCarrierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(json.getAsJsonObject("_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(json.getAsJsonObject("_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(json.getAsJsonObject("_jurisdiction"), res.getJurisdictionElement());
    if (json.has("carrierAIDC"))
      res.setCarrierAIDCElement(parseBase64Binary(json.get("carrierAIDC").getAsString()));
    if (json.has("_carrierAIDC"))
      parseElementProperties(json.getAsJsonObject("_carrierAIDC"), res.getCarrierAIDCElement());
    if (json.has("carrierHRF"))
      res.setCarrierHRFElement(parseString(json.get("carrierHRF").getAsString()));
    if (json.has("_carrierHRF"))
      parseElementProperties(json.getAsJsonObject("_carrierHRF"), res.getCarrierHRFElement());
    if (json.has("entryType"))
      res.setEntryTypeElement(parseEnumeration(json.get("entryType").getAsString(), Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
    if (json.has("_entryType"))
      parseElementProperties(json.getAsJsonObject("_entryType"), res.getEntryTypeElement());
  }

  protected Device.DeviceDeviceNameComponent parseDeviceDeviceNameComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DeviceDeviceNameComponent res = new Device.DeviceDeviceNameComponent();
    parseDeviceDeviceNameComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDeviceNameComponentProperties(JsonObject json, Device.DeviceDeviceNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected Device.DeviceSpecializationComponent parseDeviceSpecializationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DeviceSpecializationComponent res = new Device.DeviceSpecializationComponent();
    parseDeviceSpecializationComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceSpecializationComponentProperties(JsonObject json, Device.DeviceSpecializationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("systemType"))
      res.setSystemType(parseCodeableConcept(json.getAsJsonObject("systemType")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
  }

  protected Device.DeviceVersionComponent parseDeviceVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
    parseDeviceVersionComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceVersionComponentProperties(JsonObject json, Device.DeviceVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("component"))
      res.setComponent(parseIdentifier(json.getAsJsonObject("component")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected Device.DevicePropertyComponent parseDevicePropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
    parseDevicePropertyComponentProperties(json, res);
    return res;
  }

  protected void parseDevicePropertyComponentProperties(JsonObject json, Device.DevicePropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("valueQuantity")) {
      JsonArray array = json.getAsJsonArray("valueQuantity");
      for (int i = 0; i < array.size(); i++) {
        res.getValueQuantity().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition parseDeviceDefinition(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition res = new DeviceDefinition();
    parseDeviceDefinitionProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionProperties(JsonObject json, DeviceDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("udiDeviceIdentifier")) {
      JsonArray array = json.getAsJsonArray("udiDeviceIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiDeviceIdentifier().add(parseDeviceDefinitionUdiDeviceIdentifierComponent(array.get(i).getAsJsonObject()));
      }
    };
    DataType manufacturer = parseType("manufacturer", json);
    if (manufacturer != null)
      res.setManufacturer(manufacturer);
    if (json.has("deviceName")) {
      JsonArray array = json.getAsJsonArray("deviceName");
      for (int i = 0; i < array.size(); i++) {
        res.getDeviceName().add(parseDeviceDefinitionDeviceNameComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(json.getAsJsonObject("_modelNumber"), res.getModelNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("specialization")) {
      JsonArray array = json.getAsJsonArray("specialization");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialization().add(parseDeviceDefinitionSpecializationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getVersion().add(new StringType());
        } else {;
          res.getVersion().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_version")) {
      JsonArray array = json.getAsJsonArray("_version");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getVersion().size())
          res.getVersion().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getVersion().get(i));
      }
    };
    if (json.has("safety")) {
      JsonArray array = json.getAsJsonArray("safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("shelfLifeStorage")) {
      JsonArray array = json.getAsJsonArray("shelfLifeStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getShelfLifeStorage().add(parseProductShelfLife(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("physicalCharacteristics"))
      res.setPhysicalCharacteristics(parseProdCharacteristic(json.getAsJsonObject("physicalCharacteristics")));
    if (json.has("languageCode")) {
      JsonArray array = json.getAsJsonArray("languageCode");
      for (int i = 0; i < array.size(); i++) {
        res.getLanguageCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("capability")) {
      JsonArray array = json.getAsJsonArray("capability");
      for (int i = 0; i < array.size(); i++) {
        res.getCapability().add(parseDeviceDefinitionCapabilityComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("property")) {
      JsonArray array = json.getAsJsonArray("property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseDeviceDefinitionPropertyComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(json.getAsJsonObject("owner")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("onlineInformation"))
      res.setOnlineInformationElement(parseUri(json.get("onlineInformation").getAsString()));
    if (json.has("_onlineInformation"))
      parseElementProperties(json.getAsJsonObject("_onlineInformation"), res.getOnlineInformationElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("parentDevice"))
      res.setParentDevice(parseReference(json.getAsJsonObject("parentDevice")));
    if (json.has("material")) {
      JsonArray array = json.getAsJsonArray("material");
      for (int i = 0; i < array.size(); i++) {
        res.getMaterial().add(parseDeviceDefinitionMaterialComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionUdiDeviceIdentifierComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
    parseDeviceDefinitionUdiDeviceIdentifierComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionUdiDeviceIdentifierComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(json.getAsJsonObject("_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(json.getAsJsonObject("_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(json.getAsJsonObject("_jurisdiction"), res.getJurisdictionElement());
  }

  protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceNameComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
    parseDeviceDefinitionDeviceNameComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceNameComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
  }

  protected DeviceDefinition.DeviceDefinitionSpecializationComponent parseDeviceDefinitionSpecializationComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionSpecializationComponent res = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
    parseDeviceDefinitionSpecializationComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionSpecializationComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionSpecializationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("systemType"))
      res.setSystemTypeElement(parseString(json.get("systemType").getAsString()));
    if (json.has("_systemType"))
      parseElementProperties(json.getAsJsonObject("_systemType"), res.getSystemTypeElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
  }

  protected DeviceDefinition.DeviceDefinitionCapabilityComponent parseDeviceDefinitionCapabilityComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionCapabilityComponent res = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
    parseDeviceDefinitionCapabilityComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionCapabilityComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionCapabilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("description")) {
      JsonArray array = json.getAsJsonArray("description");
      for (int i = 0; i < array.size(); i++) {
        res.getDescription().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
    parseDeviceDefinitionPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionPropertyComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("valueQuantity")) {
      JsonArray array = json.getAsJsonArray("valueQuantity");
      for (int i = 0; i < array.size(); i++) {
        res.getValueQuantity().add(parseQuantity(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("valueCode")) {
      JsonArray array = json.getAsJsonArray("valueCode");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionMaterialComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
    parseDeviceDefinitionMaterialComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionMaterialComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(json.getAsJsonObject("substance")));
    if (json.has("alternate"))
      res.setAlternateElement(parseBoolean(json.get("alternate").getAsBoolean()));
    if (json.has("_alternate"))
      parseElementProperties(json.getAsJsonObject("_alternate"), res.getAlternateElement());
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(json.getAsJsonObject("_allergenicIndicator"), res.getAllergenicIndicatorElement());
  }

  protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseDeviceMetricProperties(json, res);
    return res;
  }

  protected void parseDeviceMetricProperties(JsonObject json, DeviceMetric res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("parent"))
      res.setParent(parseReference(json.getAsJsonObject("parent")));
    if (json.has("operationalStatus"))
      res.setOperationalStatusElement(parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
    if (json.has("_operationalStatus"))
      parseElementProperties(json.getAsJsonObject("_operationalStatus"), res.getOperationalStatusElement());
    if (json.has("color"))
      res.setColorElement(parseEnumeration(json.get("color").getAsString(), DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
    if (json.has("_color"))
      parseElementProperties(json.getAsJsonObject("_color"), res.getColorElement());
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("measurementPeriod"))
      res.setMeasurementPeriod(parseTiming(json.getAsJsonObject("measurementPeriod")));
    if (json.has("calibration")) {
      JsonArray array = json.getAsJsonArray("calibration");
      for (int i = 0; i < array.size(); i++) {
        res.getCalibration().add(parseDeviceMetricCalibrationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricCalibrationComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseDeviceMetricCalibrationComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceMetricCalibrationComponentProperties(JsonObject json, DeviceMetric.DeviceMetricCalibrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("state"))
      res.setStateElement(parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
    if (json.has("_state"))
      parseElementProperties(json.getAsJsonObject("_state"), res.getStateElement());
    if (json.has("time"))
      res.setTimeElement(parseInstant(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(json.getAsJsonObject("_time"), res.getTimeElement());
  }

  protected DeviceRequest parseDeviceRequest(JsonObject json) throws IOException, FHIRFormatError {
    DeviceRequest res = new DeviceRequest();
    parseDeviceRequestProperties(json, res);
    return res;
  }

  protected void parseDeviceRequestProperties(JsonObject json, DeviceRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priorRequest")) {
      JsonArray array = json.getAsJsonArray("priorRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getPriorRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    DataType code = parseType("code", json);
    if (code != null)
      res.setCode(code);
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseDeviceRequestParameterComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("performerType"))
      res.setPerformerType(parseCodeableConcept(json.getAsJsonObject("performerType")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = json.getAsJsonArray("relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestParameterComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
    parseDeviceRequestParameterComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceRequestParameterComponentProperties(JsonObject json, DeviceRequest.DeviceRequestParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DeviceUseStatement parseDeviceUseStatement(JsonObject json) throws IOException, FHIRFormatError {
    DeviceUseStatement res = new DeviceUseStatement();
    parseDeviceUseStatementProperties(json, res);
    return res;
  }

  protected void parseDeviceUseStatementProperties(JsonObject json, DeviceUseStatement res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("recordedOn"))
      res.setRecordedOnElement(parseDateTime(json.get("recordedOn").getAsString()));
    if (json.has("_recordedOn"))
      parseElementProperties(json.getAsJsonObject("_recordedOn"), res.getRecordedOnElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseDiagnosticReportProperties(json, res);
    return res;
  }

  protected void parseDiagnosticReportProperties(JsonObject json, DiagnosticReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("resultsInterpreter")) {
      JsonArray array = json.getAsJsonArray("resultsInterpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getResultsInterpreter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("result")) {
      JsonArray array = json.getAsJsonArray("result");
      for (int i = 0; i < array.size(); i++) {
        res.getResult().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("imagingStudy")) {
      JsonArray array = json.getAsJsonArray("imagingStudy");
      for (int i = 0; i < array.size(); i++) {
        res.getImagingStudy().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("media")) {
      JsonArray array = json.getAsJsonArray("media");
      for (int i = 0; i < array.size(); i++) {
        res.getMedia().add(parseDiagnosticReportMediaComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("conclusion"))
      res.setConclusionElement(parseString(json.get("conclusion").getAsString()));
    if (json.has("_conclusion"))
      parseElementProperties(json.getAsJsonObject("_conclusion"), res.getConclusionElement());
    if (json.has("conclusionCode")) {
      JsonArray array = json.getAsJsonArray("conclusionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getConclusionCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("presentedForm")) {
      JsonArray array = json.getAsJsonArray("presentedForm");
      for (int i = 0; i < array.size(); i++) {
        res.getPresentedForm().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportMediaComponent(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
    parseDiagnosticReportMediaComponentProperties(json, res);
    return res;
  }

  protected void parseDiagnosticReportMediaComponentProperties(JsonObject json, DiagnosticReport.DiagnosticReportMediaComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("link"))
      res.setLink(parseReference(json.getAsJsonObject("link")));
  }

  protected DocumentManifest parseDocumentManifest(JsonObject json) throws IOException, FHIRFormatError {
    DocumentManifest res = new DocumentManifest();
    parseDocumentManifestProperties(json, res);
    return res;
  }

  protected void parseDocumentManifestProperties(JsonObject json, DocumentManifest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(json.getAsJsonObject("masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("recipient")) {
      JsonArray array = json.getAsJsonArray("recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseDocumentManifestRelatedComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestRelatedComponent(JsonObject json) throws IOException, FHIRFormatError {
    DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
    parseDocumentManifestRelatedComponentProperties(json, res);
    return res;
  }

  protected void parseDocumentManifestRelatedComponentProperties(JsonObject json, DocumentManifest.DocumentManifestRelatedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("ref"))
      res.setRef(parseReference(json.getAsJsonObject("ref")));
  }

  protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseDocumentReferenceProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceProperties(JsonObject json, DocumentReference res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("masterIdentifier"))
      res.setMasterIdentifier(parseIdentifier(json.getAsJsonObject("masterIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("docStatus"))
      res.setDocStatusElement(parseEnumeration(json.get("docStatus").getAsString(), Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
    if (json.has("_docStatus"))
      parseElementProperties(json.getAsJsonObject("_docStatus"), res.getDocStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("date"))
      res.setDateElement(parseInstant(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authenticator"))
      res.setAuthenticator(parseReference(json.getAsJsonObject("authenticator")));
    if (json.has("custodian"))
      res.setCustodian(parseReference(json.getAsJsonObject("custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = json.getAsJsonArray("relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseDocumentReferenceRelatesToComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("securityLabel")) {
      JsonArray array = json.getAsJsonArray("securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseDocumentReferenceContentComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("context"))
      res.setContext(parseDocumentReferenceContextComponent(json.getAsJsonObject("context")));
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseDocumentReferenceRelatesToComponentProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceRelatesToComponentProperties(JsonObject json, DocumentReference.DocumentReferenceRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Enumerations.DocumentRelationshipType.NULL, new Enumerations.DocumentRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceContentComponent(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseDocumentReferenceContentComponentProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceContentComponentProperties(JsonObject json, DocumentReference.DocumentReferenceContentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("attachment"))
      res.setAttachment(parseAttachment(json.getAsJsonObject("attachment")));
    if (json.has("format"))
      res.setFormat(parseCoding(json.getAsJsonObject("format")));
  }

  protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceContextComponent(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
    parseDocumentReferenceContextComponentProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceContextComponentProperties(JsonObject json, DocumentReference.DocumentReferenceContextComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("event")) {
      JsonArray array = json.getAsJsonArray("event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("facilityType"))
      res.setFacilityType(parseCodeableConcept(json.getAsJsonObject("facilityType")));
    if (json.has("practiceSetting"))
      res.setPracticeSetting(parseCodeableConcept(json.getAsJsonObject("practiceSetting")));
    if (json.has("sourcePatientInfo"))
      res.setSourcePatientInfo(parseReference(json.getAsJsonObject("sourcePatientInfo")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseEncounterProperties(json, res);
    return res;
  }

  protected void parseEncounterProperties(JsonObject json, Encounter res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEncounterStatusHistoryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("class"))
      res.setClass_(parseCoding(json.getAsJsonObject("class")));
    if (json.has("classHistory")) {
      JsonArray array = json.getAsJsonArray("classHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getClassHistory().add(parseEncounterClassHistoryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceType"))
      res.setServiceType(parseCodeableConcept(json.getAsJsonObject("serviceType")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("subjectStatus"))
      res.setSubjectStatus(parseCodeableConcept(json.getAsJsonObject("subjectStatus")));
    if (json.has("episodeOfCare")) {
      JsonArray array = json.getAsJsonArray("episodeOfCare");
      for (int i = 0; i < array.size(); i++) {
        res.getEpisodeOfCare().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseEncounterParticipantComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointment")) {
      JsonArray array = json.getAsJsonArray("appointment");
      for (int i = 0; i < array.size(); i++) {
        res.getAppointment().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("length"))
      res.setLength(parseDuration(json.getAsJsonObject("length")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEncounterDiagnosisComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("hospitalization"))
      res.setHospitalization(parseEncounterHospitalizationComponent(json.getAsJsonObject("hospitalization")));
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseEncounterLocationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceProvider"))
      res.setServiceProvider(parseReference(json.getAsJsonObject("serviceProvider")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
  }

  protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
    parseEncounterStatusHistoryComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterStatusHistoryComponentProperties(JsonObject json, Encounter.StatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
    parseEncounterClassHistoryComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterClassHistoryComponentProperties(JsonObject json, Encounter.ClassHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("class"))
      res.setClass_(parseCoding(json.getAsJsonObject("class")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Encounter.EncounterParticipantComponent parseEncounterParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseEncounterParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterParticipantComponentProperties(JsonObject json, Encounter.EncounterParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("individual"))
      res.setIndividual(parseReference(json.getAsJsonObject("individual")));
  }

  protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
    parseEncounterDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterDiagnosisComponentProperties(JsonObject json, Encounter.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseReference(json.getAsJsonObject("condition")));
    if (json.has("use"))
      res.setUse(parseCodeableConcept(json.getAsJsonObject("use")));
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
  }

  protected Encounter.EncounterHospitalizationComponent parseEncounterHospitalizationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
    parseEncounterHospitalizationComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterHospitalizationComponentProperties(JsonObject json, Encounter.EncounterHospitalizationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("preAdmissionIdentifier"))
      res.setPreAdmissionIdentifier(parseIdentifier(json.getAsJsonObject("preAdmissionIdentifier")));
    if (json.has("origin"))
      res.setOrigin(parseReference(json.getAsJsonObject("origin")));
    if (json.has("admitSource"))
      res.setAdmitSource(parseCodeableConcept(json.getAsJsonObject("admitSource")));
    if (json.has("reAdmission"))
      res.setReAdmission(parseCodeableConcept(json.getAsJsonObject("reAdmission")));
    if (json.has("dietPreference")) {
      JsonArray array = json.getAsJsonArray("dietPreference");
      for (int i = 0; i < array.size(); i++) {
        res.getDietPreference().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialCourtesy")) {
      JsonArray array = json.getAsJsonArray("specialCourtesy");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialCourtesy().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialArrangement")) {
      JsonArray array = json.getAsJsonArray("specialArrangement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialArrangement().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("dischargeDisposition"))
      res.setDischargeDisposition(parseCodeableConcept(json.getAsJsonObject("dischargeDisposition")));
  }

  protected Encounter.EncounterLocationComponent parseEncounterLocationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseEncounterLocationComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterLocationComponentProperties(JsonObject json, Encounter.EncounterLocationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("physicalType"))
      res.setPhysicalType(parseCodeableConcept(json.getAsJsonObject("physicalType")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Endpoint parseEndpoint(JsonObject json) throws IOException, FHIRFormatError {
    Endpoint res = new Endpoint();
    parseEndpointProperties(json, res);
    return res;
  }

  protected void parseEndpointProperties(JsonObject json, Endpoint res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("connectionType"))
      res.setConnectionType(parseCoding(json.getAsJsonObject("connectionType")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("payloadType")) {
      JsonArray array = json.getAsJsonArray("payloadType");
      for (int i = 0; i < array.size(); i++) {
        res.getPayloadType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payloadMimeType")) {
      JsonArray array = json.getAsJsonArray("payloadMimeType");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPayloadMimeType().add(new CodeType());
        } else {;
          res.getPayloadMimeType().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_payloadMimeType")) {
      JsonArray array = json.getAsJsonArray("_payloadMimeType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPayloadMimeType().size())
          res.getPayloadMimeType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPayloadMimeType().get(i));
      }
    };
    if (json.has("address"))
      res.setAddressElement(parseUrl(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(json.getAsJsonObject("_address"), res.getAddressElement());
    if (json.has("header")) {
      JsonArray array = json.getAsJsonArray("header");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getHeader().add(new StringType());
        } else {;
          res.getHeader().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_header")) {
      JsonArray array = json.getAsJsonArray("_header");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getHeader().size())
          res.getHeader().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getHeader().get(i));
      }
    };
  }

  protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseEnrollmentRequestProperties(json, res);
    return res;
  }

  protected void parseEnrollmentRequestProperties(JsonObject json, EnrollmentRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("candidate"))
      res.setCandidate(parseReference(json.getAsJsonObject("candidate")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
  }

  protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseEnrollmentResponseProperties(json, res);
    return res;
  }

  protected void parseEnrollmentResponseProperties(JsonObject json, EnrollmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(json.getAsJsonObject("organization")));
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(json.getAsJsonObject("requestProvider")));
  }

  protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseEpisodeOfCareProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareProperties(JsonObject json, EpisodeOfCare res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = json.getAsJsonArray("statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEpisodeOfCareStatusHistoryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEpisodeOfCareDiagnosisComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("referralRequest")) {
      JsonArray array = json.getAsJsonArray("referralRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralRequest().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careManager"))
      res.setCareManager(parseReference(json.getAsJsonObject("careManager")));
    if (json.has("team")) {
      JsonArray array = json.getAsJsonArray("team");
      for (int i = 0; i < array.size(); i++) {
        res.getTeam().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("account")) {
      JsonArray array = json.getAsJsonArray("account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareStatusHistoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseEpisodeOfCareStatusHistoryComponentProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareStatusHistoryComponentProperties(JsonObject json, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
    parseEpisodeOfCareDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareDiagnosisComponentProperties(JsonObject json, EpisodeOfCare.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseReference(json.getAsJsonObject("condition")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(json.getAsJsonObject("_rank"), res.getRankElement());
  }

  protected EventDefinition parseEventDefinition(JsonObject json) throws IOException, FHIRFormatError {
    EventDefinition res = new EventDefinition();
    parseEventDefinitionProperties(json, res);
    return res;
  }

  protected void parseEventDefinitionProperties(JsonObject json, EventDefinition res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("trigger")) {
      JsonArray array = json.getAsJsonArray("trigger");
      for (int i = 0; i < array.size(); i++) {
        res.getTrigger().add(parseTriggerDefinition(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Evidence parseEvidence(JsonObject json) throws IOException, FHIRFormatError {
    Evidence res = new Evidence();
    parseEvidenceProperties(json, res);
    return res;
  }

  protected void parseEvidenceProperties(JsonObject json, Evidence res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("contributor")) {
      JsonArray array = json.getAsJsonArray("contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseContributor(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("assertion"))
      res.setAssertionElement(parseMarkdown(json.get("assertion").getAsString()));
    if (json.has("_assertion"))
      parseElementProperties(json.getAsJsonObject("_assertion"), res.getAssertionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referentGroup"))
      res.setReferentGroup(parseEvidenceReferentGroupComponent(json.getAsJsonObject("referentGroup")));
    if (json.has("variableDefinition")) {
      JsonArray array = json.getAsJsonArray("variableDefinition");
      for (int i = 0; i < array.size(); i++) {
        res.getVariableDefinition().add(parseEvidenceVariableDefinitionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("synthesisType"))
      res.setSynthesisType(parseCodeableConcept(json.getAsJsonObject("synthesisType")));
    if (json.has("studyType"))
      res.setStudyType(parseCodeableConcept(json.getAsJsonObject("studyType")));
    if (json.has("statistic")) {
      JsonArray array = json.getAsJsonArray("statistic");
      for (int i = 0; i < array.size(); i++) {
        res.getStatistic().add(parseStatistic(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("distribution")) {
      JsonArray array = json.getAsJsonArray("distribution");
      for (int i = 0; i < array.size(); i++) {
        res.getDistribution().add(parseOrderedDistribution(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("certainty")) {
      JsonArray array = json.getAsJsonArray("certainty");
      for (int i = 0; i < array.size(); i++) {
        res.getCertainty().add(parseEvidenceCertaintyComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Evidence.EvidenceReferentGroupComponent parseEvidenceReferentGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceReferentGroupComponent res = new Evidence.EvidenceReferentGroupComponent();
    parseEvidenceReferentGroupComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceReferentGroupComponentProperties(JsonObject json, Evidence.EvidenceReferentGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evidenceSource"))
      res.setEvidenceSource(parseReference(json.getAsJsonObject("evidenceSource")));
    if (json.has("intendedGroup"))
      res.setIntendedGroup(parseReference(json.getAsJsonObject("intendedGroup")));
    if (json.has("directnessMatch"))
      res.setDirectnessMatch(parseCodeableConcept(json.getAsJsonObject("directnessMatch")));
  }

  protected Evidence.EvidenceVariableDefinitionComponent parseEvidenceVariableDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceVariableDefinitionComponent res = new Evidence.EvidenceVariableDefinitionComponent();
    parseEvidenceVariableDefinitionComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableDefinitionComponentProperties(JsonObject json, Evidence.EvidenceVariableDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("variableRole"))
      res.setVariableRole(parseCodeableConcept(json.getAsJsonObject("variableRole")));
    if (json.has("actualDefinition"))
      res.setActualDefinition(parseReference(json.getAsJsonObject("actualDefinition")));
    if (json.has("intendedDefinition"))
      res.setIntendedDefinition(parseReference(json.getAsJsonObject("intendedDefinition")));
    if (json.has("directnessMatch"))
      res.setDirectnessMatch(parseCodeableConcept(json.getAsJsonObject("directnessMatch")));
  }

  protected Evidence.EvidenceCertaintyComponent parseEvidenceCertaintyComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceCertaintyComponent res = new Evidence.EvidenceCertaintyComponent();
    parseEvidenceCertaintyComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceCertaintyComponentProperties(JsonObject json, Evidence.EvidenceCertaintyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note"))
      res.setNote(parseAnnotation(json.getAsJsonObject("note")));
    if (json.has("rating")) {
      JsonArray array = json.getAsJsonArray("rating");
      for (int i = 0; i < array.size(); i++) {
        res.getRating().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("certaintySubcomponent")) {
      JsonArray array = json.getAsJsonArray("certaintySubcomponent");
      for (int i = 0; i < array.size(); i++) {
        res.getCertaintySubcomponent().add(parseEvidenceCertaintyCertaintySubcomponentComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Evidence.EvidenceCertaintyCertaintySubcomponentComponent parseEvidenceCertaintyCertaintySubcomponentComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceCertaintyCertaintySubcomponentComponent res = new Evidence.EvidenceCertaintyCertaintySubcomponentComponent();
    parseEvidenceCertaintyCertaintySubcomponentComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceCertaintyCertaintySubcomponentComponentProperties(JsonObject json, Evidence.EvidenceCertaintyCertaintySubcomponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note"))
      res.setNote(parseAnnotation(json.getAsJsonObject("note")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("rating")) {
      JsonArray array = json.getAsJsonArray("rating");
      for (int i = 0; i < array.size(); i++) {
        res.getRating().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected EvidenceVariable parseEvidenceVariable(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable res = new EvidenceVariable();
    parseEvidenceVariableProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableProperties(JsonObject json, EvidenceVariable res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("shortTitle"))
      res.setShortTitleElement(parseString(json.get("shortTitle").getAsString()));
    if (json.has("_shortTitle"))
      parseElementProperties(json.getAsJsonObject("_shortTitle"), res.getShortTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), EvidenceVariable.EvidenceVariableType.NULL, new EvidenceVariable.EvidenceVariableTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(json.getAsJsonObject("_actual"), res.getActualElement());
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseEvidenceVariableCharacteristicComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
    parseEvidenceVariableCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableCharacteristicComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    DataType definition = parseType("definition", json);
    if (definition != null)
      res.setDefinition(definition);
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("booleanSet")) {
      JsonArray array = json.getAsJsonArray("booleanSet");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getBooleanSet().add(new StringType());
        } else {;
          res.getBooleanSet().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_booleanSet")) {
      JsonArray array = json.getAsJsonArray("_booleanSet");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getBooleanSet().size())
          res.getBooleanSet().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getBooleanSet().get(i));
      }
    };
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(json.getAsJsonObject("_exclude"), res.getExcludeElement());
    DataType participantEffective = parseType("participantEffective", json);
    if (participantEffective != null)
      res.setParticipantEffective(participantEffective);
    if (json.has("timeFromStart"))
      res.setTimeFromStart(parseDuration(json.getAsJsonObject("timeFromStart")));
    if (json.has("groupMeasure"))
      res.setGroupMeasureElement(parseEnumeration(json.get("groupMeasure").getAsString(), EvidenceVariable.GroupMeasure.NULL, new EvidenceVariable.GroupMeasureEnumFactory()));
    if (json.has("_groupMeasure"))
      parseElementProperties(json.getAsJsonObject("_groupMeasure"), res.getGroupMeasureElement());
  }

  protected ExampleScenario parseExampleScenario(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario res = new ExampleScenario();
    parseExampleScenarioProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProperties(JsonObject json, ExampleScenario res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("actor")) {
      JsonArray array = json.getAsJsonArray("actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseExampleScenarioActorComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseExampleScenarioInstanceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("process")) {
      JsonArray array = json.getAsJsonArray("process");
      for (int i = 0; i < array.size(); i++) {
        res.getProcess().add(parseExampleScenarioProcessComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("workflow")) {
      JsonArray array = json.getAsJsonArray("workflow");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getWorkflow().add(new CanonicalType());
        } else {;
          res.getWorkflow().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_workflow")) {
      JsonArray array = json.getAsJsonArray("_workflow");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getWorkflow().size())
          res.getWorkflow().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getWorkflow().get(i));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioActorComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
    parseExampleScenarioActorComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioActorComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("actorId"))
      res.setActorIdElement(parseString(json.get("actorId").getAsString()));
    if (json.has("_actorId"))
      parseElementProperties(json.getAsJsonObject("_actorId"), res.getActorIdElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ExampleScenario.ExampleScenarioActorType.NULL, new ExampleScenario.ExampleScenarioActorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
    parseExampleScenarioInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioInstanceComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("resourceId"))
      res.setResourceIdElement(parseString(json.get("resourceId").getAsString()));
    if (json.has("_resourceId"))
      parseElementProperties(json.getAsJsonObject("_resourceId"), res.getResourceIdElement());
    if (json.has("resourceType"))
      res.setResourceTypeElement(parseCode(json.get("resourceType").getAsString()));
    if (json.has("_resourceType"))
      parseElementProperties(json.getAsJsonObject("_resourceType"), res.getResourceTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("version")) {
      JsonArray array = json.getAsJsonArray("version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseExampleScenarioInstanceVersionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("containedInstance")) {
      JsonArray array = json.getAsJsonArray("containedInstance");
      for (int i = 0; i < array.size(); i++) {
        res.getContainedInstance().add(parseExampleScenarioInstanceContainedInstanceComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioInstanceVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
    parseExampleScenarioInstanceVersionComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioInstanceVersionComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseString(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioInstanceContainedInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
    parseExampleScenarioInstanceContainedInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioInstanceContainedInstanceComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("resourceId"))
      res.setResourceIdElement(parseString(json.get("resourceId").getAsString()));
    if (json.has("_resourceId"))
      parseElementProperties(json.getAsJsonObject("_resourceId"), res.getResourceIdElement());
    if (json.has("versionId"))
      res.setVersionIdElement(parseString(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(json.getAsJsonObject("_versionId"), res.getVersionIdElement());
  }

  protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioProcessComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
    parseExampleScenarioProcessComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProcessComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("preConditions"))
      res.setPreConditionsElement(parseMarkdown(json.get("preConditions").getAsString()));
    if (json.has("_preConditions"))
      parseElementProperties(json.getAsJsonObject("_preConditions"), res.getPreConditionsElement());
    if (json.has("postConditions"))
      res.setPostConditionsElement(parseMarkdown(json.get("postConditions").getAsString()));
    if (json.has("_postConditions"))
      parseElementProperties(json.getAsJsonObject("_postConditions"), res.getPostConditionsElement());
    if (json.has("step")) {
      JsonArray array = json.getAsJsonArray("step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseExampleScenarioProcessStepComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioProcessStepComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
    parseExampleScenarioProcessStepComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProcessStepComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("process")) {
      JsonArray array = json.getAsJsonArray("process");
      for (int i = 0; i < array.size(); i++) {
        res.getProcess().add(parseExampleScenarioProcessComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("pause"))
      res.setPauseElement(parseBoolean(json.get("pause").getAsBoolean()));
    if (json.has("_pause"))
      parseElementProperties(json.getAsJsonObject("_pause"), res.getPauseElement());
    if (json.has("operation"))
      res.setOperation(parseExampleScenarioProcessStepOperationComponent(json.getAsJsonObject("operation")));
    if (json.has("alternative")) {
      JsonArray array = json.getAsJsonArray("alternative");
      for (int i = 0; i < array.size(); i++) {
        res.getAlternative().add(parseExampleScenarioProcessStepAlternativeComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioProcessStepOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
    parseExampleScenarioProcessStepOperationComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProcessStepOperationComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parseString(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseString(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("initiator"))
      res.setInitiatorElement(parseString(json.get("initiator").getAsString()));
    if (json.has("_initiator"))
      parseElementProperties(json.getAsJsonObject("_initiator"), res.getInitiatorElement());
    if (json.has("receiver"))
      res.setReceiverElement(parseString(json.get("receiver").getAsString()));
    if (json.has("_receiver"))
      parseElementProperties(json.getAsJsonObject("_receiver"), res.getReceiverElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("initiatorActive"))
      res.setInitiatorActiveElement(parseBoolean(json.get("initiatorActive").getAsBoolean()));
    if (json.has("_initiatorActive"))
      parseElementProperties(json.getAsJsonObject("_initiatorActive"), res.getInitiatorActiveElement());
    if (json.has("receiverActive"))
      res.setReceiverActiveElement(parseBoolean(json.get("receiverActive").getAsBoolean()));
    if (json.has("_receiverActive"))
      parseElementProperties(json.getAsJsonObject("_receiverActive"), res.getReceiverActiveElement());
    if (json.has("request"))
      res.setRequest(parseExampleScenarioInstanceContainedInstanceComponent(json.getAsJsonObject("request")));
    if (json.has("response"))
      res.setResponse(parseExampleScenarioInstanceContainedInstanceComponent(json.getAsJsonObject("response")));
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioProcessStepAlternativeComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
    parseExampleScenarioProcessStepAlternativeComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProcessStepAlternativeComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("step")) {
      JsonArray array = json.getAsJsonArray("step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseExampleScenarioProcessStepComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseExplanationOfBenefitProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitProperties(JsonObject json, ExplanationOfBenefit res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(json.getAsJsonObject("subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(json.getAsJsonObject("billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(json.getAsJsonObject("_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(json.getAsJsonObject("insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("fundsReserveRequested"))
      res.setFundsReserveRequested(parseCodeableConcept(json.getAsJsonObject("fundsReserveRequested")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(json.getAsJsonObject("fundsReserve")));
    if (json.has("related")) {
      JsonArray array = json.getAsJsonArray("related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseExplanationOfBenefitRelatedClaimComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(json.getAsJsonObject("prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(json.getAsJsonObject("originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseExplanationOfBenefitPayeeComponent(json.getAsJsonObject("payee")));
    if (json.has("referral"))
      res.setReferral(parseReference(json.getAsJsonObject("referral")));
    if (json.has("facility"))
      res.setFacility(parseReference(json.getAsJsonObject("facility")));
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(json.getAsJsonObject("claimResponse")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(json.getAsJsonObject("_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(json.getAsJsonObject("_disposition"), res.getDispositionElement());
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {;
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("preAuthRefPeriod")) {
      JsonArray array = json.getAsJsonArray("preAuthRefPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRefPeriod().add(parsePeriod(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = json.getAsJsonArray("careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseExplanationOfBenefitCareTeamComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = json.getAsJsonArray("supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseExplanationOfBenefitSupportingInformationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = json.getAsJsonArray("diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("precedence"))
      res.setPrecedenceElement(parsePositiveInt(json.get("precedence").getAsString()));
    if (json.has("_precedence"))
      parseElementProperties(json.getAsJsonObject("_precedence"), res.getPrecedenceElement());
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseExplanationOfBenefitInsuranceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseExplanationOfBenefitAccidentComponent(json.getAsJsonObject("accident")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseExplanationOfBenefitItemComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = json.getAsJsonArray("addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("total")) {
      JsonArray array = json.getAsJsonArray("total");
      for (int i = 0; i < array.size(); i++) {
        res.getTotal().add(parseExplanationOfBenefitTotalComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("payment"))
      res.setPayment(parseExplanationOfBenefitPaymentComponent(json.getAsJsonObject("payment")));
    if (json.has("formCode"))
      res.setFormCode(parseCodeableConcept(json.getAsJsonObject("formCode")));
    if (json.has("form"))
      res.setForm(parseAttachment(json.getAsJsonObject("form")));
    if (json.has("processNote")) {
      JsonArray array = json.getAsJsonArray("processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseExplanationOfBenefitNoteComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("benefitPeriod"))
      res.setBenefitPeriod(parsePeriod(json.getAsJsonObject("benefitPeriod")));
    if (json.has("benefitBalance")) {
      JsonArray array = json.getAsJsonArray("benefitBalance");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefitBalance().add(parseExplanationOfBenefitBenefitBalanceComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
    parseExplanationOfBenefitRelatedClaimComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitRelatedClaimComponentProperties(JsonObject json, ExplanationOfBenefit.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(json.getAsJsonObject("claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(json.getAsJsonObject("reference")));
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseExplanationOfBenefitPayeeComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitPayeeComponentProperties(JsonObject json, ExplanationOfBenefit.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("party"))
      res.setParty(parseReference(json.getAsJsonObject("party")));
  }

  protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
    parseExplanationOfBenefitCareTeamComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitCareTeamComponentProperties(JsonObject json, ExplanationOfBenefit.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(json.getAsJsonObject("provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("qualification"))
      res.setQualification(parseCodeableConcept(json.getAsJsonObject("qualification")));
  }

  protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
    parseExplanationOfBenefitSupportingInformationComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitSupportingInformationComponentProperties(JsonObject json, ExplanationOfBenefit.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCoding(json.getAsJsonObject("reason")));
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseExplanationOfBenefitDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitDiagnosisComponentProperties(JsonObject json, ExplanationOfBenefit.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    DataType diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmission(parseCodeableConcept(json.getAsJsonObject("onAdmission")));
    if (json.has("packageCode"))
      res.setPackageCode(parseCodeableConcept(json.getAsJsonObject("packageCode")));
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseExplanationOfBenefitProcedureComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitProcedureComponentProperties(JsonObject json, ExplanationOfBenefit.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    DataType procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
    parseExplanationOfBenefitInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitInsuranceComponentProperties(JsonObject json, ExplanationOfBenefit.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(json.getAsJsonObject("_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(json.getAsJsonObject("coverage")));
    if (json.has("preAuthRef")) {
      JsonArray array = json.getAsJsonArray("preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {;
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = json.getAsJsonArray("_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPreAuthRef().get(i));
      }
    };
  }

  protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
    parseExplanationOfBenefitAccidentComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAccidentComponentProperties(JsonObject json, ExplanationOfBenefit.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
    parseExplanationOfBenefitItemComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitItemComponentProperties(JsonObject json, ExplanationOfBenefit.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCareTeamSequence().add(new PositiveIntType());
        } else {;
          res.getCareTeamSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_careTeamSequence")) {
      JsonArray array = json.getAsJsonArray("_careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamSequence().size())
          res.getCareTeamSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getCareTeamSequence().get(i));
      }
    };
    if (json.has("diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDiagnosisSequence().add(new PositiveIntType());
        } else {;
          res.getDiagnosisSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_diagnosisSequence")) {
      JsonArray array = json.getAsJsonArray("_diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisSequence().size())
          res.getDiagnosisSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDiagnosisSequence().get(i));
      }
    };
    if (json.has("procedureSequence")) {
      JsonArray array = json.getAsJsonArray("procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProcedureSequence().add(new PositiveIntType());
        } else {;
          res.getProcedureSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_procedureSequence")) {
      JsonArray array = json.getAsJsonArray("_procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureSequence().size())
          res.getProcedureSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getProcedureSequence().get(i));
      }
    };
    if (json.has("informationSequence")) {
      JsonArray array = json.getAsJsonArray("informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInformationSequence().add(new PositiveIntType());
        } else {;
          res.getInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_informationSequence")) {
      JsonArray array = json.getAsJsonArray("_informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationSequence().size())
          res.getInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInformationSequence().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = json.getAsJsonArray("encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
    parseExplanationOfBenefitAdjudicationComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAdjudicationComponentProperties(JsonObject json, ExplanationOfBenefit.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseExplanationOfBenefitDetailComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitDetailComponentProperties(JsonObject json, ExplanationOfBenefit.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseExplanationOfBenefitSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(json.getAsJsonObject("revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("udi")) {
      JsonArray array = json.getAsJsonArray("udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseExplanationOfBenefitAddedItemComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence")) {
      JsonArray array = json.getAsJsonArray("itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getItemSequence().add(new PositiveIntType());
        } else {;
          res.getItemSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_itemSequence")) {
      JsonArray array = json.getAsJsonArray("_itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getItemSequence().size())
          res.getItemSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getItemSequence().get(i));
      }
    };
    if (json.has("detailSequence")) {
      JsonArray array = json.getAsJsonArray("detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDetailSequence().add(new PositiveIntType());
        } else {;
          res.getDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_detailSequence")) {
      JsonArray array = json.getAsJsonArray("_detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDetailSequence().size())
          res.getDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDetailSequence().get(i));
      }
    };
    if (json.has("subDetailSequence")) {
      JsonArray array = json.getAsJsonArray("subDetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSubDetailSequence().add(new PositiveIntType());
        } else {;
          res.getSubDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_subDetailSequence")) {
      JsonArray array = json.getAsJsonArray("_subDetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubDetailSequence().size())
          res.getSubDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSubDetailSequence().get(i));
      }
    };
    if (json.has("provider")) {
      JsonArray array = json.getAsJsonArray("provider");
      for (int i = 0; i < array.size(); i++) {
        res.getProvider().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = json.getAsJsonArray("programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("subSite")) {
      JsonArray array = json.getAsJsonArray("subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("detail")) {
      JsonArray array = json.getAsJsonArray("detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitAddedItemDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
    parseExplanationOfBenefitAddedItemDetailComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemDetailComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = json.getAsJsonArray("subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitAddedItemDetailSubDetailComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
    parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(json.getAsJsonObject("productOrService")));
    if (json.has("modifier")) {
      JsonArray array = json.getAsJsonArray("modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(json.getAsJsonObject("unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("net"))
      res.setNet(parseMoney(json.getAsJsonObject("net")));
    if (json.has("noteNumber")) {
      JsonArray array = json.getAsJsonArray("noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = json.getAsJsonArray("_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNoteNumber().get(i));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = json.getAsJsonArray("adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
    parseExplanationOfBenefitTotalComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitTotalComponentProperties(JsonObject json, ExplanationOfBenefit.TotalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
    parseExplanationOfBenefitPaymentComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitPaymentComponentProperties(JsonObject json, ExplanationOfBenefit.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(json.getAsJsonObject("adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(json.getAsJsonObject("adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
  }

  protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
    parseExplanationOfBenefitNoteComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitNoteComponentProperties(JsonObject json, ExplanationOfBenefit.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseExplanationOfBenefitBenefitBalanceComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitBalanceComponentProperties(JsonObject json, ExplanationOfBenefit.BenefitBalanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(json.getAsJsonObject("_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(json.getAsJsonObject("network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(json.getAsJsonObject("unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(json.getAsJsonObject("term")));
    if (json.has("financial")) {
      JsonArray array = json.getAsJsonArray("financial");
      for (int i = 0; i < array.size(); i++) {
        res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseExplanationOfBenefitBenefitComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitComponentProperties(JsonObject json, ExplanationOfBenefit.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    DataType used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseFamilyMemberHistoryProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryProperties(JsonObject json, FamilyMemberHistory res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(json.getAsJsonObject("relationship")));
    if (json.has("sex"))
      res.setSex(parseCodeableConcept(json.getAsJsonObject("sex")));
    DataType born = parseType("born", json);
    if (born != null)
      res.setBorn(born);
    DataType age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("estimatedAge"))
      res.setEstimatedAgeElement(parseBoolean(json.get("estimatedAge").getAsBoolean()));
    if (json.has("_estimatedAge"))
      parseElementProperties(json.getAsJsonObject("_estimatedAge"), res.getEstimatedAgeElement());
    DataType deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("condition")) {
      JsonArray array = json.getAsJsonArray("condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseFamilyMemberHistoryConditionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseFamilyMemberHistoryProcedureComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryConditionComponent(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseFamilyMemberHistoryConditionComponentProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryConditionComponentProperties(JsonObject json, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("contributedToDeath"))
      res.setContributedToDeathElement(parseBoolean(json.get("contributedToDeath").getAsBoolean()));
    if (json.has("_contributedToDeath"))
      parseElementProperties(json.getAsJsonObject("_contributedToDeath"), res.getContributedToDeathElement());
    DataType onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected FamilyMemberHistory.FamilyMemberHistoryProcedureComponent parseFamilyMemberHistoryProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res = new FamilyMemberHistory.FamilyMemberHistoryProcedureComponent();
    parseFamilyMemberHistoryProcedureComponentProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryProcedureComponentProperties(JsonObject json, FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(json.getAsJsonObject("outcome")));
    if (json.has("contributedToDeath"))
      res.setContributedToDeathElement(parseBoolean(json.get("contributedToDeath").getAsBoolean()));
    if (json.has("_contributedToDeath"))
      parseElementProperties(json.getAsJsonObject("_contributedToDeath"), res.getContributedToDeathElement());
    DataType performed = parseType("performed", json);
    if (performed != null)
      res.setPerformed(performed);
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
    Flag res = new Flag();
    parseFlagProperties(json, res);
    return res;
  }

  protected void parseFlagProperties(JsonObject json, Flag res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
  }

  protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
    Goal res = new Goal();
    parseGoalProperties(json, res);
    return res;
  }

  protected void parseGoalProperties(JsonObject json, Goal res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("lifecycleStatus"))
      res.setLifecycleStatusElement(parseEnumeration(json.get("lifecycleStatus").getAsString(), Goal.GoalLifecycleStatus.NULL, new Goal.GoalLifecycleStatusEnumFactory()));
    if (json.has("_lifecycleStatus"))
      parseElementProperties(json.getAsJsonObject("_lifecycleStatus"), res.getLifecycleStatusElement());
    if (json.has("achievementStatus"))
      res.setAchievementStatus(parseCodeableConcept(json.getAsJsonObject("achievementStatus")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("continuous"))
      res.setContinuousElement(parseBoolean(json.get("continuous").getAsBoolean()));
    if (json.has("_continuous"))
      parseElementProperties(json.getAsJsonObject("_continuous"), res.getContinuousElement());
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(json.getAsJsonObject("priority")));
    if (json.has("description"))
      res.setDescription(parseCodeableConcept(json.getAsJsonObject("description")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    DataType start = parseType("start", json);
    if (start != null)
      res.setStart(start);
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseGoalTargetComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(json.getAsJsonObject("_statusDate"), res.getStatusDateElement());
    if (json.has("statusReason"))
      res.setStatusReasonElement(parseString(json.get("statusReason").getAsString()));
    if (json.has("_statusReason"))
      parseElementProperties(json.getAsJsonObject("_statusReason"), res.getStatusReasonElement());
    if (json.has("expressedBy"))
      res.setExpressedBy(parseReference(json.getAsJsonObject("expressedBy")));
    if (json.has("addresses")) {
      JsonArray array = json.getAsJsonArray("addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outcome")) {
      JsonArray array = json.getAsJsonArray("outcome");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcome().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Goal.GoalTargetComponent parseGoalTargetComponent(JsonObject json) throws IOException, FHIRFormatError {
    Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
    parseGoalTargetComponentProperties(json, res);
    return res;
  }

  protected void parseGoalTargetComponentProperties(JsonObject json, Goal.GoalTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("measure"))
      res.setMeasure(parseCodeableConcept(json.getAsJsonObject("measure")));
    DataType detail = parseType("detail", json);
    if (detail != null)
      res.setDetail(detail);
    DataType due = parseType("due", json);
    if (due != null)
      res.setDue(due);
  }

  protected GraphDefinition parseGraphDefinition(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition res = new GraphDefinition();
    parseGraphDefinitionProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionProperties(JsonObject json, GraphDefinition res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("start"))
      res.setStartElement(parseCode(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionLinkComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
    parseGraphDefinitionLinkComponentProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionLinkComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(json.getAsJsonObject("_path"), res.getPathElement());
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(json.getAsJsonObject("_sliceName"), res.getSliceNameElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("target")) {
      JsonArray array = json.getAsJsonArray("target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseGraphDefinitionLinkTargetComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionLinkTargetComponent(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
    parseGraphDefinitionLinkTargetComponentProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionLinkTargetComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("params"))
      res.setParamsElement(parseString(json.get("params").getAsString()));
    if (json.has("_params"))
      parseElementProperties(json.getAsJsonObject("_params"), res.getParamsElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("compartment")) {
      JsonArray array = json.getAsJsonArray("compartment");
      for (int i = 0; i < array.size(); i++) {
        res.getCompartment().add(parseGraphDefinitionLinkTargetCompartmentComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("link")) {
      JsonArray array = json.getAsJsonArray("link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionLinkComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionLinkTargetCompartmentComponent(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
    parseGraphDefinitionLinkTargetCompartmentComponentProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionLinkTargetCompartmentComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(json.getAsJsonObject("_use"), res.getUseElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("rule"))
      res.setRuleElement(parseEnumeration(json.get("rule").getAsString(), GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
    if (json.has("_rule"))
      parseElementProperties(json.getAsJsonObject("_rule"), res.getRuleElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(json.getAsJsonObject("_expression"), res.getExpressionElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
    Group res = new Group();
    parseGroupProperties(json, res);
    return res;
  }

  protected void parseGroupProperties(JsonObject json, Group res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(json.getAsJsonObject("_actual"), res.getActualElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("quantity"))
      res.setQuantityElement(parseUnsignedInt(json.get("quantity").getAsString()));
    if (json.has("_quantity"))
      parseElementProperties(json.getAsJsonObject("_quantity"), res.getQuantityElement());
    if (json.has("managingEntity"))
      res.setManagingEntity(parseReference(json.getAsJsonObject("managingEntity")));
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseGroupCharacteristicComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("member")) {
      JsonArray array = json.getAsJsonArray("member");
      for (int i = 0; i < array.size(); i++) {
        res.getMember().add(parseGroupMemberComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Group.GroupCharacteristicComponent parseGroupCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseGroupCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseGroupCharacteristicComponentProperties(JsonObject json, Group.GroupCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(json.getAsJsonObject("_exclude"), res.getExcludeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected Group.GroupMemberComponent parseGroupMemberComponent(JsonObject json) throws IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseGroupMemberComponentProperties(json, res);
    return res;
  }

  protected void parseGroupMemberComponentProperties(JsonObject json, Group.GroupMemberComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("entity"))
      res.setEntity(parseReference(json.getAsJsonObject("entity")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("inactive"))
      res.setInactiveElement(parseBoolean(json.get("inactive").getAsBoolean()));
    if (json.has("_inactive"))
      parseElementProperties(json.getAsJsonObject("_inactive"), res.getInactiveElement());
  }

  protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseGuidanceResponseProperties(json, res);
    return res;
  }

  protected void parseGuidanceResponseProperties(JsonObject json, GuidanceResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("requestIdentifier"))
      res.setRequestIdentifier(parseIdentifier(json.getAsJsonObject("requestIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    DataType module = parseType("module", json);
    if (module != null)
      res.setModule(module);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("occurrenceDateTime"))
      res.setOccurrenceDateTimeElement(parseDateTime(json.get("occurrenceDateTime").getAsString()));
    if (json.has("_occurrenceDateTime"))
      parseElementProperties(json.getAsJsonObject("_occurrenceDateTime"), res.getOccurrenceDateTimeElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evaluationMessage")) {
      JsonArray array = json.getAsJsonArray("evaluationMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getEvaluationMessage().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("outputParameters"))
      res.setOutputParameters(parseReference(json.getAsJsonObject("outputParameters")));
    if (json.has("result"))
      res.setResult(parseReference(json.getAsJsonObject("result")));
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseHealthcareServiceProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceProperties(JsonObject json, HealthcareService res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("providedBy"))
      res.setProvidedBy(parseReference(json.getAsJsonObject("providedBy")));
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = json.getAsJsonArray("specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location")) {
      JsonArray array = json.getAsJsonArray("location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("extraDetails"))
      res.setExtraDetailsElement(parseMarkdown(json.get("extraDetails").getAsString()));
    if (json.has("_extraDetails"))
      parseElementProperties(json.getAsJsonObject("_extraDetails"), res.getExtraDetailsElement());
    if (json.has("photo"))
      res.setPhoto(parseAttachment(json.getAsJsonObject("photo")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("serviceProvisionCode")) {
      JsonArray array = json.getAsJsonArray("serviceProvisionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceProvisionCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eligibility")) {
      JsonArray array = json.getAsJsonArray("eligibility");
      for (int i = 0; i < array.size(); i++) {
        res.getEligibility().add(parseHealthcareServiceEligibilityComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("program")) {
      JsonArray array = json.getAsJsonArray("program");
      for (int i = 0; i < array.size(); i++) {
        res.getProgram().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("communication")) {
      JsonArray array = json.getAsJsonArray("communication");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunication().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referralMethod")) {
      JsonArray array = json.getAsJsonArray("referralMethod");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralMethod().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("appointmentRequired"))
      res.setAppointmentRequiredElement(parseBoolean(json.get("appointmentRequired").getAsBoolean()));
    if (json.has("_appointmentRequired"))
      parseElementProperties(json.getAsJsonObject("_appointmentRequired"), res.getAppointmentRequiredElement());
    if (json.has("availableTime")) {
      JsonArray array = json.getAsJsonArray("availableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailableTime().add(parseHealthcareServiceAvailableTimeComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("notAvailable")) {
      JsonArray array = json.getAsJsonArray("notAvailable");
      for (int i = 0; i < array.size(); i++) {
        res.getNotAvailable().add(parseHealthcareServiceNotAvailableComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected HealthcareService.HealthcareServiceEligibilityComponent parseHealthcareServiceEligibilityComponent(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceEligibilityComponent res = new HealthcareService.HealthcareServiceEligibilityComponent();
    parseHealthcareServiceEligibilityComponentProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceEligibilityComponentProperties(JsonObject json, HealthcareService.HealthcareServiceEligibilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceAvailableTimeComponent(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
    parseHealthcareServiceAvailableTimeComponentProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceAvailableTimeComponentProperties(JsonObject json, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDaysOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
        } else {;
          res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        }
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
    if (json.has("availableStartTime"))
      res.setAvailableStartTimeElement(parseTime(json.get("availableStartTime").getAsString()));
    if (json.has("_availableStartTime"))
      parseElementProperties(json.getAsJsonObject("_availableStartTime"), res.getAvailableStartTimeElement());
    if (json.has("availableEndTime"))
      res.setAvailableEndTimeElement(parseTime(json.get("availableEndTime").getAsString()));
    if (json.has("_availableEndTime"))
      parseElementProperties(json.getAsJsonObject("_availableEndTime"), res.getAvailableEndTimeElement());
  }

  protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceNotAvailableComponent(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
    parseHealthcareServiceNotAvailableComponentProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceNotAvailableComponentProperties(JsonObject json, HealthcareService.HealthcareServiceNotAvailableComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("during"))
      res.setDuring(parsePeriod(json.getAsJsonObject("during")));
  }

  protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseImagingStudyProperties(json, res);
    return res;
  }

  protected void parseImagingStudyProperties(JsonObject json, ImagingStudy res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("modality")) {
      JsonArray array = json.getAsJsonArray("modality");
      for (int i = 0; i < array.size(); i++) {
        res.getModality().add(parseCoding(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referrer"))
      res.setReferrer(parseReference(json.getAsJsonObject("referrer")));
    if (json.has("interpreter")) {
      JsonArray array = json.getAsJsonArray("interpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpreter().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("numberOfSeries"))
      res.setNumberOfSeriesElement(parseUnsignedInt(json.get("numberOfSeries").getAsString()));
    if (json.has("_numberOfSeries"))
      parseElementProperties(json.getAsJsonObject("_numberOfSeries"), res.getNumberOfSeriesElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("procedure")) {
      JsonArray array = json.getAsJsonArray("procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseImagingStudyProcedureComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("series")) {
      JsonArray array = json.getAsJsonArray("series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingStudySeriesComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImagingStudy.ImagingStudyProcedureComponent parseImagingStudyProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudyProcedureComponent res = new ImagingStudy.ImagingStudyProcedureComponent();
    parseImagingStudyProcedureComponentProperties(json, res);
    return res;
  }

  protected void parseImagingStudyProcedureComponentProperties(JsonObject json, ImagingStudy.ImagingStudyProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudySeriesComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseImagingStudySeriesComponentProperties(json, res);
    return res;
  }

  protected void parseImagingStudySeriesComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseId(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("modality"))
      res.setModality(parseCoding(json.getAsJsonObject("modality")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(json.getAsJsonObject("_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCoding(json.getAsJsonObject("bodySite")));
    if (json.has("laterality"))
      res.setLaterality(parseCoding(json.getAsJsonObject("laterality")));
    if (json.has("specimen")) {
      JsonArray array = json.getAsJsonArray("specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(json.getAsJsonObject("_started"), res.getStartedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImagingStudySeriesPerformerComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instance")) {
      JsonArray array = json.getAsJsonArray("instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingStudySeriesInstanceComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudySeriesPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
    parseImagingStudySeriesPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseImagingStudySeriesPerformerComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudySeriesInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseImagingStudySeriesInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseImagingStudySeriesInstanceComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseId(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(json.getAsJsonObject("_uid"), res.getUidElement());
    if (json.has("sopClass"))
      res.setSopClass(parseCoding(json.getAsJsonObject("sopClass")));
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(json.getAsJsonObject("_number"), res.getNumberElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
  }

  protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseImmunizationProperties(json, res);
    return res;
  }

  protected void parseImmunizationProperties(JsonObject json, Immunization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Immunization.ImmunizationStatusCodes.NULL, new Immunization.ImmunizationStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("vaccineCode"))
      res.setVaccineCode(parseCodeableConcept(json.getAsJsonObject("vaccineCode")));
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("recorded"))
      res.setRecordedElement(parseDateTime(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("primarySource"))
      res.setPrimarySourceElement(parseBoolean(json.get("primarySource").getAsBoolean()));
    if (json.has("_primarySource"))
      parseElementProperties(json.getAsJsonObject("_primarySource"), res.getPrimarySourceElement());
    DataType informationSource = parseType("informationSource", json);
    if (informationSource != null)
      res.setInformationSource(informationSource);
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDate(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("doseQuantity"))
      res.setDoseQuantity(parseQuantity(json.getAsJsonObject("doseQuantity")));
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImmunizationPerformerComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("isSubpotent"))
      res.setIsSubpotentElement(parseBoolean(json.get("isSubpotent").getAsBoolean()));
    if (json.has("_isSubpotent"))
      parseElementProperties(json.getAsJsonObject("_isSubpotent"), res.getIsSubpotentElement());
    if (json.has("subpotentReason")) {
      JsonArray array = json.getAsJsonArray("subpotentReason");
      for (int i = 0; i < array.size(); i++) {
        res.getSubpotentReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("education")) {
      JsonArray array = json.getAsJsonArray("education");
      for (int i = 0; i < array.size(); i++) {
        res.getEducation().add(parseImmunizationEducationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("programEligibility")) {
      JsonArray array = json.getAsJsonArray("programEligibility");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramEligibility().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fundingSource"))
      res.setFundingSource(parseCodeableConcept(json.getAsJsonObject("fundingSource")));
    if (json.has("reaction")) {
      JsonArray array = json.getAsJsonArray("reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseImmunizationReactionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("protocolApplied")) {
      JsonArray array = json.getAsJsonArray("protocolApplied");
      for (int i = 0; i < array.size(); i++) {
        res.getProtocolApplied().add(parseImmunizationProtocolAppliedComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Immunization.ImmunizationPerformerComponent parseImmunizationPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
    parseImmunizationPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationPerformerComponentProperties(JsonObject json, Immunization.ImmunizationPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected Immunization.ImmunizationEducationComponent parseImmunizationEducationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Immunization.ImmunizationEducationComponent res = new Immunization.ImmunizationEducationComponent();
    parseImmunizationEducationComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationEducationComponentProperties(JsonObject json, Immunization.ImmunizationEducationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("documentType"))
      res.setDocumentTypeElement(parseString(json.get("documentType").getAsString()));
    if (json.has("_documentType"))
      parseElementProperties(json.getAsJsonObject("_documentType"), res.getDocumentTypeElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(json.getAsJsonObject("_reference"), res.getReferenceElement());
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDateTime(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(json.getAsJsonObject("_publicationDate"), res.getPublicationDateElement());
    if (json.has("presentationDate"))
      res.setPresentationDateElement(parseDateTime(json.get("presentationDate").getAsString()));
    if (json.has("_presentationDate"))
      parseElementProperties(json.getAsJsonObject("_presentationDate"), res.getPresentationDateElement());
  }

  protected Immunization.ImmunizationReactionComponent parseImmunizationReactionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
    parseImmunizationReactionComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationReactionComponentProperties(JsonObject json, Immunization.ImmunizationReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("detail"))
      res.setDetail(parseReference(json.getAsJsonObject("detail")));
    if (json.has("reported"))
      res.setReportedElement(parseBoolean(json.get("reported").getAsBoolean()));
    if (json.has("_reported"))
      parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
  }

  protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationProtocolAppliedComponent(JsonObject json) throws IOException, FHIRFormatError {
    Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
    parseImmunizationProtocolAppliedComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationProtocolAppliedComponentProperties(JsonObject json, Immunization.ImmunizationProtocolAppliedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("targetDisease")) {
      JsonArray array = json.getAsJsonArray("targetDisease");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetDisease().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    DataType doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
    DataType seriesDoses = parseType("seriesDoses", json);
    if (seriesDoses != null)
      res.setSeriesDoses(seriesDoses);
  }

  protected ImmunizationEvaluation parseImmunizationEvaluation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationEvaluation res = new ImmunizationEvaluation();
    parseImmunizationEvaluationProperties(json, res);
    return res;
  }

  protected void parseImmunizationEvaluationProperties(JsonObject json, ImmunizationEvaluation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImmunizationEvaluation.ImmunizationEvaluationStatusCodes.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("targetDisease"))
      res.setTargetDisease(parseCodeableConcept(json.getAsJsonObject("targetDisease")));
    if (json.has("immunizationEvent"))
      res.setImmunizationEvent(parseReference(json.getAsJsonObject("immunizationEvent")));
    if (json.has("doseStatus"))
      res.setDoseStatus(parseCodeableConcept(json.getAsJsonObject("doseStatus")));
    if (json.has("doseStatusReason")) {
      JsonArray array = json.getAsJsonArray("doseStatusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getDoseStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    DataType doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
    DataType seriesDoses = parseType("seriesDoses", json);
    if (seriesDoses != null)
      res.setSeriesDoses(seriesDoses);
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseImmunizationRecommendationProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationProperties(JsonObject json, ImmunizationRecommendation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(json.getAsJsonObject("authority")));
    if (json.has("recommendation")) {
      JsonArray array = json.getAsJsonArray("recommendation");
      for (int i = 0; i < array.size(); i++) {
        res.getRecommendation().add(parseImmunizationRecommendationRecommendationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationRecommendationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseImmunizationRecommendationRecommendationComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationRecommendationComponentProperties(JsonObject json, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("vaccineCode")) {
      JsonArray array = json.getAsJsonArray("vaccineCode");
      for (int i = 0; i < array.size(); i++) {
        res.getVaccineCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("targetDisease")) {
      JsonArray array = json.getAsJsonArray("targetDisease");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetDisease().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contraindicatedVaccineCode")) {
      JsonArray array = json.getAsJsonArray("contraindicatedVaccineCode");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindicatedVaccineCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("forecastStatus"))
      res.setForecastStatus(parseCodeableConcept(json.getAsJsonObject("forecastStatus")));
    if (json.has("forecastReason")) {
      JsonArray array = json.getAsJsonArray("forecastReason");
      for (int i = 0; i < array.size(); i++) {
        res.getForecastReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dateCriterion")) {
      JsonArray array = json.getAsJsonArray("dateCriterion");
      for (int i = 0; i < array.size(); i++) {
        res.getDateCriterion().add(parseImmunizationRecommendationRecommendationDateCriterionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(json.getAsJsonObject("_series"), res.getSeriesElement());
    DataType doseNumber = parseType("doseNumber", json);
    if (doseNumber != null)
      res.setDoseNumber(doseNumber);
    DataType seriesDoses = parseType("seriesDoses", json);
    if (seriesDoses != null)
      res.setSeriesDoses(seriesDoses);
    if (json.has("supportingImmunization")) {
      JsonArray array = json.getAsJsonArray("supportingImmunization");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingImmunization().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supportingPatientInformation")) {
      JsonArray array = json.getAsJsonArray("supportingPatientInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingPatientInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseImmunizationRecommendationRecommendationDateCriterionComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationRecommendationDateCriterionComponentProperties(JsonObject json, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("value"))
      res.setValueElement(parseDateTime(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseImplementationGuideProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideProperties(JsonObject json, ImplementationGuide res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("packageId"))
      res.setPackageIdElement(parseId(json.get("packageId").getAsString()));
    if (json.has("_packageId"))
      parseElementProperties(json.getAsJsonObject("_packageId"), res.getPackageIdElement());
    if (json.has("license"))
      res.setLicenseElement(parseEnumeration(json.get("license").getAsString(), ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
    if (json.has("_license"))
      parseElementProperties(json.getAsJsonObject("_license"), res.getLicenseElement());
    if (json.has("fhirVersion")) {
      JsonArray array = json.getAsJsonArray("fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFhirVersion().add(new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory(), Enumerations.FHIRVersion.NULL));
        } else {;
          res.getFhirVersion().add(parseEnumeration(array.get(i).getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
      }
    };
    if (json.has("_fhirVersion")) {
      JsonArray array = json.getAsJsonArray("_fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFhirVersion().size())
          res.getFhirVersion().add(parseEnumeration(null, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFhirVersion().get(i));
      }
    };
    if (json.has("dependsOn")) {
      JsonArray array = json.getAsJsonArray("dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseImplementationGuideDependsOnComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("global")) {
      JsonArray array = json.getAsJsonArray("global");
      for (int i = 0; i < array.size(); i++) {
        res.getGlobal().add(parseImplementationGuideGlobalComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition"))
      res.setDefinition(parseImplementationGuideDefinitionComponent(json.getAsJsonObject("definition")));
    if (json.has("manifest"))
      res.setManifest(parseImplementationGuideManifestComponent(json.getAsJsonObject("manifest")));
  }

  protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideDependsOnComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
    parseImplementationGuideDependsOnComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDependsOnComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uri"))
      res.setUriElement(parseCanonical(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(json.getAsJsonObject("_uri"), res.getUriElement());
    if (json.has("packageId"))
      res.setPackageIdElement(parseId(json.get("packageId").getAsString()));
    if (json.has("_packageId"))
      parseElementProperties(json.getAsJsonObject("_packageId"), res.getPackageIdElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideGlobalComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseImplementationGuideGlobalComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideGlobalComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideGlobalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
    parseImplementationGuideDefinitionComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("grouping")) {
      JsonArray array = json.getAsJsonArray("grouping");
      for (int i = 0; i < array.size(); i++) {
        res.getGrouping().add(parseImplementationGuideDefinitionGroupingComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideDefinitionResourceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("page"))
      res.setPage(parseImplementationGuideDefinitionPageComponent(json.getAsJsonObject("page")));
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseImplementationGuideDefinitionParameterComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("template")) {
      JsonArray array = json.getAsJsonArray("template");
      for (int i = 0; i < array.size(); i++) {
        res.getTemplate().add(parseImplementationGuideDefinitionTemplateComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuideDefinitionGroupingComponent parseImplementationGuideDefinitionGroupingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
    parseImplementationGuideDefinitionGroupingComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionGroupingComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideDefinitionResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
    parseImplementationGuideDefinitionResourceComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionResourceComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    if (json.has("fhirVersion")) {
      JsonArray array = json.getAsJsonArray("fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFhirVersion().add(new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory(), Enumerations.FHIRVersion.NULL));
        } else {;
          res.getFhirVersion().add(parseEnumeration(array.get(i).getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
      }
    };
    if (json.has("_fhirVersion")) {
      JsonArray array = json.getAsJsonArray("_fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFhirVersion().size())
          res.getFhirVersion().add(parseEnumeration(null, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFhirVersion().get(i));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    DataType example = parseType("example", json);
    if (example != null)
      res.setExample(example);
    if (json.has("groupingId"))
      res.setGroupingIdElement(parseId(json.get("groupingId").getAsString()));
    if (json.has("_groupingId"))
      parseElementProperties(json.getAsJsonObject("_groupingId"), res.getGroupingIdElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideDefinitionPageComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
    parseImplementationGuideDefinitionPageComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionPageComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType name = parseType("name", json);
    if (name != null)
      res.setName(name);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("generation"))
      res.setGenerationElement(parseEnumeration(json.get("generation").getAsString(), ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
    if (json.has("_generation"))
      parseElementProperties(json.getAsJsonObject("_generation"), res.getGenerationElement());
    if (json.has("page")) {
      JsonArray array = json.getAsJsonArray("page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideDefinitionPageComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideDefinitionParameterComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
    parseImplementationGuideDefinitionParameterComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionParameterComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseString(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideDefinitionTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
    parseImplementationGuideDefinitionTemplateComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionTemplateComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("source"))
      res.setSourceElement(parseString(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("scope"))
      res.setScopeElement(parseString(json.get("scope").getAsString()));
    if (json.has("_scope"))
      parseElementProperties(json.getAsJsonObject("_scope"), res.getScopeElement());
  }

  protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideManifestComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
    parseImplementationGuideManifestComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideManifestComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideManifestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("rendering"))
      res.setRenderingElement(parseUrl(json.get("rendering").getAsString()));
    if (json.has("_rendering"))
      parseElementProperties(json.getAsJsonObject("_rendering"), res.getRenderingElement());
    if (json.has("resource")) {
      JsonArray array = json.getAsJsonArray("resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideManifestResourceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("page")) {
      JsonArray array = json.getAsJsonArray("page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideManifestPageComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("image")) {
      JsonArray array = json.getAsJsonArray("image");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImage().add(new StringType());
        } else {;
          res.getImage().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_image")) {
      JsonArray array = json.getAsJsonArray("_image");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImage().size())
          res.getImage().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getImage().get(i));
      }
    };
    if (json.has("other")) {
      JsonArray array = json.getAsJsonArray("other");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getOther().add(new StringType());
        } else {;
          res.getOther().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_other")) {
      JsonArray array = json.getAsJsonArray("_other");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOther().size())
          res.getOther().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getOther().get(i));
      }
    };
  }

  protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
    parseImplementationGuideManifestResourceComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideManifestResourceComponentProperties(JsonObject json, ImplementationGuide.ManifestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(json.getAsJsonObject("reference")));
    DataType example = parseType("example", json);
    if (example != null)
      res.setExample(example);
    if (json.has("relativePath"))
      res.setRelativePathElement(parseUrl(json.get("relativePath").getAsString()));
    if (json.has("_relativePath"))
      parseElementProperties(json.getAsJsonObject("_relativePath"), res.getRelativePathElement());
  }

  protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
    parseImplementationGuideManifestPageComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideManifestPageComponentProperties(JsonObject json, ImplementationGuide.ManifestPageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("anchor")) {
      JsonArray array = json.getAsJsonArray("anchor");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAnchor().add(new StringType());
        } else {;
          res.getAnchor().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_anchor")) {
      JsonArray array = json.getAsJsonArray("_anchor");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAnchor().size())
          res.getAnchor().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAnchor().get(i));
      }
    };
  }

  protected Ingredient parseIngredient(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient res = new Ingredient();
    parseIngredientProperties(json, res);
    return res;
  }

  protected void parseIngredientProperties(JsonObject json, Ingredient res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(json.getAsJsonObject("identifier")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(json.getAsJsonObject("_allergenicIndicator"), res.getAllergenicIndicatorElement());
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specifiedSubstance")) {
      JsonArray array = json.getAsJsonArray("specifiedSubstance");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecifiedSubstance().add(parseIngredientSpecifiedSubstanceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("substance"))
      res.setSubstance(parseIngredientSubstanceComponent(json.getAsJsonObject("substance")));
  }

  protected Ingredient.IngredientSpecifiedSubstanceComponent parseIngredientSpecifiedSubstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient.IngredientSpecifiedSubstanceComponent res = new Ingredient.IngredientSpecifiedSubstanceComponent();
    parseIngredientSpecifiedSubstanceComponentProperties(json, res);
    return res;
  }

  protected void parseIngredientSpecifiedSubstanceComponentProperties(JsonObject json, Ingredient.IngredientSpecifiedSubstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType code = parseType("code", json);
    if (code != null)
      res.setCode(code);
    if (json.has("group"))
      res.setGroup(parseCodeableConcept(json.getAsJsonObject("group")));
    if (json.has("confidentiality"))
      res.setConfidentiality(parseCodeableConcept(json.getAsJsonObject("confidentiality")));
    if (json.has("strength")) {
      JsonArray array = json.getAsJsonArray("strength");
      for (int i = 0; i < array.size(); i++) {
        res.getStrength().add(parseIngredientSpecifiedSubstanceStrengthComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Ingredient.IngredientSpecifiedSubstanceStrengthComponent parseIngredientSpecifiedSubstanceStrengthComponent(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient.IngredientSpecifiedSubstanceStrengthComponent res = new Ingredient.IngredientSpecifiedSubstanceStrengthComponent();
    parseIngredientSpecifiedSubstanceStrengthComponentProperties(json, res);
    return res;
  }

  protected void parseIngredientSpecifiedSubstanceStrengthComponentProperties(JsonObject json, Ingredient.IngredientSpecifiedSubstanceStrengthComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("presentation"))
      res.setPresentation(parseRatio(json.getAsJsonObject("presentation")));
    if (json.has("presentationHighLimit"))
      res.setPresentationHighLimit(parseRatio(json.getAsJsonObject("presentationHighLimit")));
    if (json.has("concentration"))
      res.setConcentration(parseRatio(json.getAsJsonObject("concentration")));
    if (json.has("concentrationHighLimit"))
      res.setConcentrationHighLimit(parseRatio(json.getAsJsonObject("concentrationHighLimit")));
    if (json.has("measurementPoint"))
      res.setMeasurementPointElement(parseString(json.get("measurementPoint").getAsString()));
    if (json.has("_measurementPoint"))
      parseElementProperties(json.getAsJsonObject("_measurementPoint"), res.getMeasurementPointElement());
    if (json.has("country")) {
      JsonArray array = json.getAsJsonArray("country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("referenceStrength")) {
      JsonArray array = json.getAsJsonArray("referenceStrength");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceStrength().add(parseIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Ingredient.IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent parseIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient.IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res = new Ingredient.IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
    parseIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentProperties(json, res);
    return res;
  }

  protected void parseIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentProperties(JsonObject json, Ingredient.IngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType substance = parseType("substance", json);
    if (substance != null)
      res.setSubstance(substance);
    if (json.has("strength"))
      res.setStrength(parseRatio(json.getAsJsonObject("strength")));
    if (json.has("strengthHighLimit"))
      res.setStrengthHighLimit(parseRatio(json.getAsJsonObject("strengthHighLimit")));
    if (json.has("measurementPoint"))
      res.setMeasurementPointElement(parseString(json.get("measurementPoint").getAsString()));
    if (json.has("_measurementPoint"))
      parseElementProperties(json.getAsJsonObject("_measurementPoint"), res.getMeasurementPointElement());
    if (json.has("country")) {
      JsonArray array = json.getAsJsonArray("country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Ingredient.IngredientSubstanceComponent parseIngredientSubstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient.IngredientSubstanceComponent res = new Ingredient.IngredientSubstanceComponent();
    parseIngredientSubstanceComponentProperties(json, res);
    return res;
  }

  protected void parseIngredientSubstanceComponentProperties(JsonObject json, Ingredient.IngredientSubstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType code = parseType("code", json);
    if (code != null)
      res.setCode(code);
    if (json.has("strength")) {
      JsonArray array = json.getAsJsonArray("strength");
      for (int i = 0; i < array.size(); i++) {
        res.getStrength().add(parseIngredientSpecifiedSubstanceStrengthComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected InsurancePlan parseInsurancePlan(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan res = new InsurancePlan();
    parseInsurancePlanProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanProperties(JsonObject json, InsurancePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {;
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("ownedBy"))
      res.setOwnedBy(parseReference(json.getAsJsonObject("ownedBy")));
    if (json.has("administeredBy"))
      res.setAdministeredBy(parseReference(json.getAsJsonObject("administeredBy")));
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseInsurancePlanContactComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("coverage")) {
      JsonArray array = json.getAsJsonArray("coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseInsurancePlanCoverageComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("plan")) {
      JsonArray array = json.getAsJsonArray("plan");
      for (int i = 0; i < array.size(); i++) {
        res.getPlan().add(parseInsurancePlanPlanComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected InsurancePlan.InsurancePlanContactComponent parseInsurancePlanContactComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanContactComponent res = new InsurancePlan.InsurancePlanContactComponent();
    parseInsurancePlanContactComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanContactComponentProperties(JsonObject json, InsurancePlan.InsurancePlanContactComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("purpose"))
      res.setPurpose(parseCodeableConcept(json.getAsJsonObject("purpose")));
    if (json.has("name"))
      res.setName(parseHumanName(json.getAsJsonObject("name")));
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
  }

  protected InsurancePlan.InsurancePlanCoverageComponent parseInsurancePlanCoverageComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanCoverageComponent res = new InsurancePlan.InsurancePlanCoverageComponent();
    parseInsurancePlanCoverageComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanCoverageComponentProperties(JsonObject json, InsurancePlan.InsurancePlanCoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseInsurancePlanCoverageBenefitComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected InsurancePlan.CoverageBenefitComponent parseInsurancePlanCoverageBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitComponent res = new InsurancePlan.CoverageBenefitComponent();
    parseInsurancePlanCoverageBenefitComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanCoverageBenefitComponentProperties(JsonObject json, InsurancePlan.CoverageBenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("requirement"))
      res.setRequirementElement(parseString(json.get("requirement").getAsString()));
    if (json.has("_requirement"))
      parseElementProperties(json.getAsJsonObject("_requirement"), res.getRequirementElement());
    if (json.has("limit")) {
      JsonArray array = json.getAsJsonArray("limit");
      for (int i = 0; i < array.size(); i++) {
        res.getLimit().add(parseInsurancePlanCoverageBenefitLimitComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected InsurancePlan.CoverageBenefitLimitComponent parseInsurancePlanCoverageBenefitLimitComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitLimitComponent res = new InsurancePlan.CoverageBenefitLimitComponent();
    parseInsurancePlanCoverageBenefitLimitComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanCoverageBenefitLimitComponentProperties(JsonObject json, InsurancePlan.CoverageBenefitLimitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValue(parseQuantity(json.getAsJsonObject("value")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
  }

  protected InsurancePlan.InsurancePlanPlanComponent parseInsurancePlanPlanComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanComponent res = new InsurancePlan.InsurancePlanPlanComponent();
    parseInsurancePlanPlanComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanComponentProperties(JsonObject json, InsurancePlan.InsurancePlanPlanComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("coverageArea")) {
      JsonArray array = json.getAsJsonArray("coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("network")) {
      JsonArray array = json.getAsJsonArray("network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("generalCost")) {
      JsonArray array = json.getAsJsonArray("generalCost");
      for (int i = 0; i < array.size(); i++) {
        res.getGeneralCost().add(parseInsurancePlanPlanGeneralCostComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("specificCost")) {
      JsonArray array = json.getAsJsonArray("specificCost");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecificCost().add(parseInsurancePlanPlanSpecificCostComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected InsurancePlan.InsurancePlanPlanGeneralCostComponent parseInsurancePlanPlanGeneralCostComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanGeneralCostComponent res = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
    parseInsurancePlanPlanGeneralCostComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanGeneralCostComponentProperties(JsonObject json, InsurancePlan.InsurancePlanPlanGeneralCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("groupSize"))
      res.setGroupSizeElement(parsePositiveInt(json.get("groupSize").getAsString()));
    if (json.has("_groupSize"))
      parseElementProperties(json.getAsJsonObject("_groupSize"), res.getGroupSizeElement());
    if (json.has("cost"))
      res.setCost(parseMoney(json.getAsJsonObject("cost")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
  }

  protected InsurancePlan.InsurancePlanPlanSpecificCostComponent parseInsurancePlanPlanSpecificCostComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanSpecificCostComponent res = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
    parseInsurancePlanPlanSpecificCostComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanSpecificCostComponentProperties(JsonObject json, InsurancePlan.InsurancePlanPlanSpecificCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(json.getAsJsonObject("category")));
    if (json.has("benefit")) {
      JsonArray array = json.getAsJsonArray("benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseInsurancePlanPlanBenefitComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected InsurancePlan.PlanBenefitComponent parseInsurancePlanPlanBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitComponent res = new InsurancePlan.PlanBenefitComponent();
    parseInsurancePlanPlanBenefitComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanBenefitComponentProperties(JsonObject json, InsurancePlan.PlanBenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("cost")) {
      JsonArray array = json.getAsJsonArray("cost");
      for (int i = 0; i < array.size(); i++) {
        res.getCost().add(parseInsurancePlanPlanBenefitCostComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected InsurancePlan.PlanBenefitCostComponent parseInsurancePlanPlanBenefitCostComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitCostComponent res = new InsurancePlan.PlanBenefitCostComponent();
    parseInsurancePlanPlanBenefitCostComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanBenefitCostComponentProperties(JsonObject json, InsurancePlan.PlanBenefitCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("applicability"))
      res.setApplicability(parseCodeableConcept(json.getAsJsonObject("applicability")));
    if (json.has("qualifiers")) {
      JsonArray array = json.getAsJsonArray("qualifiers");
      for (int i = 0; i < array.size(); i++) {
        res.getQualifiers().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("value"))
      res.setValue(parseQuantity(json.getAsJsonObject("value")));
  }

  protected Invoice parseInvoice(JsonObject json) throws IOException, FHIRFormatError {
    Invoice res = new Invoice();
    parseInvoiceProperties(json, res);
    return res;
  }

  protected void parseInvoiceProperties(JsonObject json, Invoice res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Invoice.InvoiceStatus.NULL, new Invoice.InvoiceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("cancelledReason"))
      res.setCancelledReasonElement(parseString(json.get("cancelledReason").getAsString()));
    if (json.has("_cancelledReason"))
      parseElementProperties(json.getAsJsonObject("_cancelledReason"), res.getCancelledReasonElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("recipient"))
      res.setRecipient(parseReference(json.getAsJsonObject("recipient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("participant")) {
      JsonArray array = json.getAsJsonArray("participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseInvoiceParticipantComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("issuer"))
      res.setIssuer(parseReference(json.getAsJsonObject("issuer")));
    if (json.has("account"))
      res.setAccount(parseReference(json.getAsJsonObject("account")));
    if (json.has("lineItem")) {
      JsonArray array = json.getAsJsonArray("lineItem");
      for (int i = 0; i < array.size(); i++) {
        res.getLineItem().add(parseInvoiceLineItemComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("totalPriceComponent")) {
      JsonArray array = json.getAsJsonArray("totalPriceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getTotalPriceComponent().add(parseInvoiceLineItemPriceComponentComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("totalNet"))
      res.setTotalNet(parseMoney(json.getAsJsonObject("totalNet")));
    if (json.has("totalGross"))
      res.setTotalGross(parseMoney(json.getAsJsonObject("totalGross")));
    if (json.has("paymentTerms"))
      res.setPaymentTermsElement(parseMarkdown(json.get("paymentTerms").getAsString()));
    if (json.has("_paymentTerms"))
      parseElementProperties(json.getAsJsonObject("_paymentTerms"), res.getPaymentTermsElement());
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Invoice.InvoiceParticipantComponent parseInvoiceParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    Invoice.InvoiceParticipantComponent res = new Invoice.InvoiceParticipantComponent();
    parseInvoiceParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseInvoiceParticipantComponentProperties(JsonObject json, Invoice.InvoiceParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(json.getAsJsonObject("role")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected Invoice.InvoiceLineItemComponent parseInvoiceLineItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    Invoice.InvoiceLineItemComponent res = new Invoice.InvoiceLineItemComponent();
    parseInvoiceLineItemComponentProperties(json, res);
    return res;
  }

  protected void parseInvoiceLineItemComponentProperties(JsonObject json, Invoice.InvoiceLineItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(json.getAsJsonObject("_sequence"), res.getSequenceElement());
    DataType chargeItem = parseType("chargeItem", json);
    if (chargeItem != null)
      res.setChargeItem(chargeItem);
    if (json.has("priceComponent")) {
      JsonArray array = json.getAsJsonArray("priceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getPriceComponent().add(parseInvoiceLineItemPriceComponentComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Invoice.InvoiceLineItemPriceComponentComponent parseInvoiceLineItemPriceComponentComponent(JsonObject json) throws IOException, FHIRFormatError {
    Invoice.InvoiceLineItemPriceComponentComponent res = new Invoice.InvoiceLineItemPriceComponentComponent();
    parseInvoiceLineItemPriceComponentComponentProperties(json, res);
    return res;
  }

  protected void parseInvoiceLineItemPriceComponentComponentProperties(JsonObject json, Invoice.InvoiceLineItemPriceComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.InvoicePriceComponentType.NULL, new Enumerations.InvoicePriceComponentTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(json.getAsJsonObject("_factor"), res.getFactorElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(json.getAsJsonObject("amount")));
  }

  protected Library parseLibrary(JsonObject json) throws IOException, FHIRFormatError {
    Library res = new Library();
    parseLibraryProperties(json, res);
    return res;
  }

  protected void parseLibraryProperties(JsonObject json, Library res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("parameter")) {
      JsonArray array = json.getAsJsonArray("parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParameterDefinition(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dataRequirement")) {
      JsonArray array = json.getAsJsonArray("dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("content")) {
      JsonArray array = json.getAsJsonArray("content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseAttachment(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Linkage parseLinkage(JsonObject json) throws IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseLinkageProperties(json, res);
    return res;
  }

  protected void parseLinkageProperties(JsonObject json, Linkage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(json.getAsJsonObject("_active"), res.getActiveElement());
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("item")) {
      JsonArray array = json.getAsJsonArray("item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseLinkageItemComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Linkage.LinkageItemComponent parseLinkageItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseLinkageItemComponentProperties(json, res);
    return res;
  }

  protected void parseLinkageItemComponentProperties(JsonObject json, Linkage.LinkageItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("resource"))
      res.setResource(parseReference(json.getAsJsonObject("resource")));
  }

  protected ListResource parseListResource(JsonObject json) throws IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseListResourceProperties(json, res);
    return res;
  }

  protected void parseListResourceProperties(JsonObject json, ListResource res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(json.getAsJsonObject("orderedBy")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("entry")) {
      JsonArray array = json.getAsJsonArray("entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseListResourceEntryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(json.getAsJsonObject("emptyReason")));
  }

  protected ListResource.ListResourceEntryComponent parseListResourceEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
    ListResource.ListResourceEntryComponent res = new ListResource.ListResourceEntryComponent();
    parseListResourceEntryComponentProperties(json, res);
    return res;
  }

  protected void parseListResourceEntryComponentProperties(JsonObject json, ListResource.ListResourceEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("flag"))
      res.setFlag(parseCodeableConcept(json.getAsJsonObject("flag")));
    if (json.has("deleted"))
      res.setDeletedElement(parseBoolean(json.get("deleted").getAsBoolean()));
    if (json.has("_deleted"))
      parseElementProperties(json.getAsJsonObject("_deleted"), res.getDeletedElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("item"))
      res.setItem(parseReference(json.getAsJsonObject("item")));
  }

  protected Location parseLocation(JsonObject json) throws IOException, FHIRFormatError {
    Location res = new Location();
    parseLocationProperties(json, res);
    return res;
  }

  protected void parseLocationProperties(JsonObject json, Location res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("operationalStatus"))
      res.setOperationalStatus(parseCoding(json.getAsJsonObject("operationalStatus")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = json.getAsJsonArray("alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {;
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = json.getAsJsonArray("_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getAlias().get(i));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(json.getAsJsonObject("_mode"), res.getModeElement());
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = json.getAsJsonArray("telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(json.getAsJsonObject("address")));
    if (json.has("physicalType"))
      res.setPhysicalType(parseCodeableConcept(json.getAsJsonObject("physicalType")));
    if (json.has("position"))
      res.setPosition(parseLocationPositionComponent(json.getAsJsonObject("position")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(json.getAsJsonObject("managingOrganization")));
    if (json.has("partOf"))
      res.setPartOf(parseReference(json.getAsJsonObject("partOf")));
    if (json.has("hoursOfOperation")) {
      JsonArray array = json.getAsJsonArray("hoursOfOperation");
      for (int i = 0; i < array.size(); i++) {
        res.getHoursOfOperation().add(parseLocationHoursOfOperationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("availabilityExceptions"))
      res.setAvailabilityExceptionsElement(parseString(json.get("availabilityExceptions").getAsString()));
    if (json.has("_availabilityExceptions"))
      parseElementProperties(json.getAsJsonObject("_availabilityExceptions"), res.getAvailabilityExceptionsElement());
    if (json.has("endpoint")) {
      JsonArray array = json.getAsJsonArray("endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Location.LocationPositionComponent parseLocationPositionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Location.LocationPositionComponent res = new Location.LocationPositionComponent();
    parseLocationPositionComponentProperties(json, res);
    return res;
  }

  protected void parseLocationPositionComponentProperties(JsonObject json, Location.LocationPositionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("longitude"))
      res.setLongitudeElement(parseDecimal(json.get("longitude").getAsBigDecimal()));
    if (json.has("_longitude"))
      parseElementProperties(json.getAsJsonObject("_longitude"), res.getLongitudeElement());
    if (json.has("latitude"))
      res.setLatitudeElement(parseDecimal(json.get("latitude").getAsBigDecimal()));
    if (json.has("_latitude"))
      parseElementProperties(json.getAsJsonObject("_latitude"), res.getLatitudeElement());
    if (json.has("altitude"))
      res.setAltitudeElement(parseDecimal(json.get("altitude").getAsBigDecimal()));
    if (json.has("_altitude"))
      parseElementProperties(json.getAsJsonObject("_altitude"), res.getAltitudeElement());
  }

  protected Location.LocationHoursOfOperationComponent parseLocationHoursOfOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Location.LocationHoursOfOperationComponent res = new Location.LocationHoursOfOperationComponent();
    parseLocationHoursOfOperationComponentProperties(json, res);
    return res;
  }

  protected void parseLocationHoursOfOperationComponentProperties(JsonObject json, Location.LocationHoursOfOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDaysOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
        } else {;
          res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        }
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = json.getAsJsonArray("_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(json.getAsJsonObject("_allDay"), res.getAllDayElement());
    if (json.has("openingTime"))
      res.setOpeningTimeElement(parseTime(json.get("openingTime").getAsString()));
    if (json.has("_openingTime"))
      parseElementProperties(json.getAsJsonObject("_openingTime"), res.getOpeningTimeElement());
    if (json.has("closingTime"))
      res.setClosingTimeElement(parseTime(json.get("closingTime").getAsString()));
    if (json.has("_closingTime"))
      parseElementProperties(json.getAsJsonObject("_closingTime"), res.getClosingTimeElement());
  }

  protected ManufacturedItemDefinition parseManufacturedItemDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ManufacturedItemDefinition res = new ManufacturedItemDefinition();
    parseManufacturedItemDefinitionProperties(json, res);
    return res;
  }

  protected void parseManufacturedItemDefinitionProperties(JsonObject json, ManufacturedItemDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturedDoseForm"))
      res.setManufacturedDoseForm(parseCodeableConcept(json.getAsJsonObject("manufacturedDoseForm")));
    if (json.has("unitOfPresentation"))
      res.setUnitOfPresentation(parseCodeableConcept(json.getAsJsonObject("unitOfPresentation")));
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("characteristic")) {
      JsonArray array = json.getAsJsonArray("characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseManufacturedItemDefinitionCharacteristicComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected ManufacturedItemDefinition.ManufacturedItemDefinitionCharacteristicComponent parseManufacturedItemDefinitionCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    ManufacturedItemDefinition.ManufacturedItemDefinitionCharacteristicComponent res = new ManufacturedItemDefinition.ManufacturedItemDefinitionCharacteristicComponent();
    parseManufacturedItemDefinitionCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseManufacturedItemDefinitionCharacteristicComponentProperties(JsonObject json, ManufacturedItemDefinition.ManufacturedItemDefinitionCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Measure parseMeasure(JsonObject json) throws IOException, FHIRFormatError {
    Measure res = new Measure();
    parseMeasureProperties(json, res);
    return res;
  }

  protected void parseMeasureProperties(JsonObject json, Measure res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(json.getAsJsonObject("_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(json.getAsJsonObject("_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(json.getAsJsonObject("_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(json.getAsJsonObject("effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = json.getAsJsonArray("topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("author")) {
      JsonArray array = json.getAsJsonArray("author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("editor")) {
      JsonArray array = json.getAsJsonArray("editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = json.getAsJsonArray("reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = json.getAsJsonArray("endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = json.getAsJsonArray("relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("library")) {
      JsonArray array = json.getAsJsonArray("library");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLibrary().add(new CanonicalType());
        } else {;
          res.getLibrary().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_library")) {
      JsonArray array = json.getAsJsonArray("_library");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLibrary().size())
          res.getLibrary().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getLibrary().get(i));
      }
    };
    if (json.has("disclaimer"))
      res.setDisclaimerElement(parseMarkdown(json.get("disclaimer").getAsString()));
    if (json.has("_disclaimer"))
      parseElementProperties(json.getAsJsonObject("_disclaimer"), res.getDisclaimerElement());
    if (json.has("scoring"))
      res.setScoring(parseCodeableConcept(json.getAsJsonObject("scoring")));
    if (json.has("compositeScoring"))
      res.setCompositeScoring(parseCodeableConcept(json.getAsJsonObject("compositeScoring")));
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("riskAdjustment"))
      res.setRiskAdjustmentElement(parseString(json.get("riskAdjustment").getAsString()));
    if (json.has("_riskAdjustment"))
      parseElementProperties(json.getAsJsonObject("_riskAdjustment"), res.getRiskAdjustmentElement());
    if (json.has("rateAggregation"))
      res.setRateAggregationElement(parseString(json.get("rateAggregation").getAsString()));
    if (json.has("_rateAggregation"))
      parseElementProperties(json.getAsJsonObject("_rateAggregation"), res.getRateAggregationElement());
    if (json.has("rationale"))
      res.setRationaleElement(parseMarkdown(json.get("rationale").getAsString()));
    if (json.has("_rationale"))
      parseElementProperties(json.getAsJsonObject("_rationale"), res.getRationaleElement());
    if (json.has("clinicalRecommendationStatement"))
      res.setClinicalRecommendationStatementElement(parseMarkdown(json.get("clinicalRecommendationStatement").getAsString()));
    if (json.has("_clinicalRecommendationStatement"))
      parseElementProperties(json.getAsJsonObject("_clinicalRecommendationStatement"), res.getClinicalRecommendationStatementElement());
    if (json.has("improvementNotation"))
      res.setImprovementNotation(parseCodeableConcept(json.getAsJsonObject("improvementNotation")));
    if (json.has("definition")) {
      JsonArray array = json.getAsJsonArray("definition");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinition().add(new MarkdownType());
        } else {;
          res.getDefinition().add(parseMarkdown(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definition")) {
      JsonArray array = json.getAsJsonArray("_definition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinition().size())
          res.getDefinition().add(parseMarkdown(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getDefinition().get(i));
      }
    };
    if (json.has("guidance"))
      res.setGuidanceElement(parseMarkdown(json.get("guidance").getAsString()));
    if (json.has("_guidance"))
      parseElementProperties(json.getAsJsonObject("_guidance"), res.getGuidanceElement());
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureGroupComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("supplementalData")) {
      JsonArray array = json.getAsJsonArray("supplementalData");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplementalData().add(parseMeasureSupplementalDataComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Measure.MeasureGroupComponent parseMeasureGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
    Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
    parseMeasureGroupComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureGroupComponentProperties(JsonObject json, Measure.MeasureGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureGroupPopulationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureGroupStratifierComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Measure.MeasureGroupPopulationComponent parseMeasureGroupPopulationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
    parseMeasureGroupPopulationComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureGroupPopulationComponentProperties(JsonObject json, Measure.MeasureGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(json.getAsJsonObject("criteria")));
  }

  protected Measure.MeasureGroupStratifierComponent parseMeasureGroupStratifierComponent(JsonObject json) throws IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
    parseMeasureGroupStratifierComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureGroupStratifierComponentProperties(JsonObject json, Measure.MeasureGroupStratifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(json.getAsJsonObject("criteria")));
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseMeasureGroupStratifierComponentComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected Measure.MeasureGroupStratifierComponentComponent parseMeasureGroupStratifierComponentComponent(JsonObject json) throws IOException, FHIRFormatError {
    Measure.MeasureGroupStratifierComponentComponent res = new Measure.MeasureGroupStratifierComponentComponent();
    parseMeasureGroupStratifierComponentComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureGroupStratifierComponentComponentProperties(JsonObject json, Measure.MeasureGroupStratifierComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(json.getAsJsonObject("criteria")));
  }

  protected Measure.MeasureSupplementalDataComponent parseMeasureSupplementalDataComponent(JsonObject json) throws IOException, FHIRFormatError {
    Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
    parseMeasureSupplementalDataComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureSupplementalDataComponentProperties(JsonObject json, Measure.MeasureSupplementalDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("usage")) {
      JsonArray array = json.getAsJsonArray("usage");
      for (int i = 0; i < array.size(); i++) {
        res.getUsage().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("criteria"))
      res.setCriteria(parseExpression(json.getAsJsonObject("criteria")));
  }

  protected MeasureReport parseMeasureReport(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport res = new MeasureReport();
    parseMeasureReportProperties(json, res);
    return res;
  }

  protected void parseMeasureReportProperties(JsonObject json, MeasureReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("measure"))
      res.setMeasureElement(parseCanonical(json.get("measure").getAsString()));
    if (json.has("_measure"))
      parseElementProperties(json.getAsJsonObject("_measure"), res.getMeasureElement());
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("reporter"))
      res.setReporter(parseReference(json.getAsJsonObject("reporter")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
    if (json.has("improvementNotation"))
      res.setImprovementNotation(parseCodeableConcept(json.getAsJsonObject("improvementNotation")));
    if (json.has("group")) {
      JsonArray array = json.getAsJsonArray("group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseMeasureReportGroupComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("evaluatedResource")) {
      JsonArray array = json.getAsJsonArray("evaluatedResource");
      for (int i = 0; i < array.size(); i++) {
        res.getEvaluatedResource().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MeasureReport.MeasureReportGroupComponent parseMeasureReportGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
    parseMeasureReportGroupComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureReportGroupComponentProperties(JsonObject json, MeasureReport.MeasureReportGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportGroupPopulationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("measureScore"))
      res.setMeasureScore(parseQuantity(json.getAsJsonObject("measureScore")));
    if (json.has("stratifier")) {
      JsonArray array = json.getAsJsonArray("stratifier");
      for (int i = 0; i < array.size(); i++) {
        res.getStratifier().add(parseMeasureReportGroupStratifierComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportGroupPopulationComponent(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
    parseMeasureReportGroupPopulationComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureReportGroupPopulationComponentProperties(JsonObject json, MeasureReport.MeasureReportGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("subjectResults"))
      res.setSubjectResults(parseReference(json.getAsJsonObject("subjectResults")));
  }

  protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportGroupStratifierComponent(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
    parseMeasureReportGroupStratifierComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureReportGroupStratifierComponentProperties(JsonObject json, MeasureReport.MeasureReportGroupStratifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = json.getAsJsonArray("code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("stratum")) {
      JsonArray array = json.getAsJsonArray("stratum");
      for (int i = 0; i < array.size(); i++) {
        res.getStratum().add(parseMeasureReportStratifierGroupComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
    parseMeasureReportStratifierGroupComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupComponentProperties(JsonObject json, MeasureReport.StratifierGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValue(parseCodeableConcept(json.getAsJsonObject("value")));
    if (json.has("component")) {
      JsonArray array = json.getAsJsonArray("component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseMeasureReportStratifierGroupComponentComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("population")) {
      JsonArray array = json.getAsJsonArray("population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseMeasureReportStratifierGroupPopulationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("measureScore"))
      res.setMeasureScore(parseQuantity(json.getAsJsonObject("measureScore")));
  }

  protected MeasureReport.StratifierGroupComponentComponent parseMeasureReportStratifierGroupComponentComponent(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupComponentComponent res = new MeasureReport.StratifierGroupComponentComponent();
    parseMeasureReportStratifierGroupComponentComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupComponentComponentProperties(JsonObject json, MeasureReport.StratifierGroupComponentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("value"))
      res.setValue(parseCodeableConcept(json.getAsJsonObject("value")));
  }

  protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(JsonObject json) throws IOException, FHIRFormatError {
    MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
    parseMeasureReportStratifierGroupPopulationComponentProperties(json, res);
    return res;
  }

  protected void parseMeasureReportStratifierGroupPopulationComponentProperties(JsonObject json, MeasureReport.StratifierGroupPopulationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(json.getAsJsonObject("_count"), res.getCountElement());
    if (json.has("subjectResults"))
      res.setSubjectResults(parseReference(json.getAsJsonObject("subjectResults")));
  }

  protected Medication parseMedication(JsonObject json) throws IOException, FHIRFormatError {
    Medication res = new Medication();
    parseMedicationProperties(json, res);
    return res;
  }

  protected void parseMedicationProperties(JsonObject json, Medication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Medication.MedicationStatusCodes.NULL, new Medication.MedicationStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("doseForm"))
      res.setDoseForm(parseCodeableConcept(json.getAsJsonObject("doseForm")));
    if (json.has("amount"))
      res.setAmount(parseRatio(json.getAsJsonObject("amount")));
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseMedicationIngredientComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("batch"))
      res.setBatch(parseMedicationBatchComponent(json.getAsJsonObject("batch")));
  }

  protected Medication.MedicationIngredientComponent parseMedicationIngredientComponent(JsonObject json) throws IOException, FHIRFormatError {
    Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
    parseMedicationIngredientComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationIngredientComponentProperties(JsonObject json, Medication.MedicationIngredientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("isActive"))
      res.setIsActiveElement(parseBoolean(json.get("isActive").getAsBoolean()));
    if (json.has("_isActive"))
      parseElementProperties(json.getAsJsonObject("_isActive"), res.getIsActiveElement());
    DataType strength = parseType("strength", json);
    if (strength != null)
      res.setStrength(strength);
  }

  protected Medication.MedicationBatchComponent parseMedicationBatchComponent(JsonObject json) throws IOException, FHIRFormatError {
    Medication.MedicationBatchComponent res = new Medication.MedicationBatchComponent();
    parseMedicationBatchComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationBatchComponentProperties(JsonObject json, Medication.MedicationBatchComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(json.getAsJsonObject("_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(json.getAsJsonObject("_expirationDate"), res.getExpirationDateElement());
  }

  protected MedicationAdministration parseMedicationAdministration(JsonObject json) throws IOException, FHIRFormatError {
    MedicationAdministration res = new MedicationAdministration();
    parseMedicationAdministrationProperties(json, res);
    return res;
  }

  protected void parseMedicationAdministrationProperties(JsonObject json, MedicationAdministration res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationAdministration.MedicationAdministrationStatusCodes.NULL, new MedicationAdministration.MedicationAdministrationStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    DataType medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    DataType occurence = parseType("occurence", json);
    if (occurence != null)
      res.setOccurence(occurence);
    if (json.has("recorded"))
      res.setRecordedElement(parseDateTime(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(json.getAsJsonObject("_recorded"), res.getRecordedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseMedicationAdministrationPerformerComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("request"))
      res.setRequest(parseReference(json.getAsJsonObject("request")));
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dosage"))
      res.setDosage(parseMedicationAdministrationDosageComponent(json.getAsJsonObject("dosage")));
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
    parseMedicationAdministrationPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationAdministrationPerformerComponentProperties(JsonObject json, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationDosageComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
    parseMedicationAdministrationDosageComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationAdministrationDosageComponentProperties(JsonObject json, MedicationAdministration.MedicationAdministrationDosageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(json.getAsJsonObject("_text"), res.getTextElement());
    if (json.has("site"))
      res.setSite(parseCodeableConcept(json.getAsJsonObject("site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(json.getAsJsonObject("route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("dose"))
      res.setDose(parseQuantity(json.getAsJsonObject("dose")));
    DataType rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected MedicationDispense parseMedicationDispense(JsonObject json) throws IOException, FHIRFormatError {
    MedicationDispense res = new MedicationDispense();
    parseMedicationDispenseProperties(json, res);
    return res;
  }

  protected void parseMedicationDispenseProperties(JsonObject json, MedicationDispense res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationDispense.MedicationDispenseStatusCodes.NULL, new MedicationDispense.MedicationDispenseStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    DataType statusReason = parseType("statusReason", json);
    if (statusReason != null)
      res.setStatusReason(statusReason);
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    DataType medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseMedicationDispensePerformerComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(json.getAsJsonObject("location")));
    if (json.has("authorizingPrescription")) {
      JsonArray array = json.getAsJsonArray("authorizingPrescription");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizingPrescription().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("daysSupply"))
      res.setDaysSupply(parseQuantity(json.getAsJsonObject("daysSupply")));
    if (json.has("whenPrepared"))
      res.setWhenPreparedElement(parseDateTime(json.get("whenPrepared").getAsString()));
    if (json.has("_whenPrepared"))
      parseElementProperties(json.getAsJsonObject("_whenPrepared"), res.getWhenPreparedElement());
    if (json.has("whenHandedOver"))
      res.setWhenHandedOverElement(parseDateTime(json.get("whenHandedOver").getAsString()));
    if (json.has("_whenHandedOver"))
      parseElementProperties(json.getAsJsonObject("_whenHandedOver"), res.getWhenHandedOverElement());
    if (json.has("destination"))
      res.setDestination(parseReference(json.getAsJsonObject("destination")));
    if (json.has("receiver")) {
      JsonArray array = json.getAsJsonArray("receiver");
      for (int i = 0; i < array.size(); i++) {
        res.getReceiver().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("renderedDosageInstruction"))
      res.setRenderedDosageInstructionElement(parseString(json.get("renderedDosageInstruction").getAsString()));
    if (json.has("_renderedDosageInstruction"))
      parseElementProperties(json.getAsJsonObject("_renderedDosageInstruction"), res.getRenderedDosageInstructionElement());
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("substitution"))
      res.setSubstitution(parseMedicationDispenseSubstitutionComponent(json.getAsJsonObject("substitution")));
    if (json.has("detectedIssue")) {
      JsonArray array = json.getAsJsonArray("detectedIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getDetectedIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispensePerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
    parseMedicationDispensePerformerComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationDispensePerformerComponentProperties(JsonObject json, MedicationDispense.MedicationDispensePerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(json.getAsJsonObject("function")));
    if (json.has("actor"))
      res.setActor(parseReference(json.getAsJsonObject("actor")));
  }

  protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseSubstitutionComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
    parseMedicationDispenseSubstitutionComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationDispenseSubstitutionComponentProperties(JsonObject json, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("wasSubstituted"))
      res.setWasSubstitutedElement(parseBoolean(json.get("wasSubstituted").getAsBoolean()));
    if (json.has("_wasSubstituted"))
      parseElementProperties(json.getAsJsonObject("_wasSubstituted"), res.getWasSubstitutedElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responsibleParty"))
      res.setResponsibleParty(parseReference(json.getAsJsonObject("responsibleParty")));
  }

  protected MedicationKnowledge parseMedicationKnowledge(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge res = new MedicationKnowledge();
    parseMedicationKnowledgeProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeProperties(JsonObject json, MedicationKnowledge res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationKnowledge.MedicationKnowledgeStatusCodes.NULL, new MedicationKnowledge.MedicationKnowledgeStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(json.getAsJsonObject("manufacturer")));
    if (json.has("doseForm"))
      res.setDoseForm(parseCodeableConcept(json.getAsJsonObject("doseForm")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(json.getAsJsonObject("amount")));
    if (json.has("synonym")) {
      JsonArray array = json.getAsJsonArray("synonym");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSynonym().add(new StringType());
        } else {;
          res.getSynonym().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_synonym")) {
      JsonArray array = json.getAsJsonArray("_synonym");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSynonym().size())
          res.getSynonym().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSynonym().get(i));
      }
    };
    if (json.has("relatedMedicationKnowledge")) {
      JsonArray array = json.getAsJsonArray("relatedMedicationKnowledge");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedMedicationKnowledge().add(parseMedicationKnowledgeRelatedMedicationKnowledgeComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("associatedMedication")) {
      JsonArray array = json.getAsJsonArray("associatedMedication");
      for (int i = 0; i < array.size(); i++) {
        res.getAssociatedMedication().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("productType")) {
      JsonArray array = json.getAsJsonArray("productType");
      for (int i = 0; i < array.size(); i++) {
        res.getProductType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("monograph")) {
      JsonArray array = json.getAsJsonArray("monograph");
      for (int i = 0; i < array.size(); i++) {
        res.getMonograph().add(parseMedicationKnowledgeMonographComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseMedicationKnowledgeIngredientComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("device")) {
      JsonArray array = json.getAsJsonArray("device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("preparationInstruction"))
      res.setPreparationInstructionElement(parseMarkdown(json.get("preparationInstruction").getAsString()));
    if (json.has("_preparationInstruction"))
      parseElementProperties(json.getAsJsonObject("_preparationInstruction"), res.getPreparationInstructionElement());
    if (json.has("intendedRoute")) {
      JsonArray array = json.getAsJsonArray("intendedRoute");
      for (int i = 0; i < array.size(); i++) {
        res.getIntendedRoute().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("cost")) {
      JsonArray array = json.getAsJsonArray("cost");
      for (int i = 0; i < array.size(); i++) {
        res.getCost().add(parseMedicationKnowledgeCostComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("monitoringProgram")) {
      JsonArray array = json.getAsJsonArray("monitoringProgram");
      for (int i = 0; i < array.size(); i++) {
        res.getMonitoringProgram().add(parseMedicationKnowledgeMonitoringProgramComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("administrationGuideline")) {
      JsonArray array = json.getAsJsonArray("administrationGuideline");
      for (int i = 0; i < array.size(); i++) {
        res.getAdministrationGuideline().add(parseMedicationKnowledgeAdministrationGuidelineComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("medicineClassification")) {
      JsonArray array = json.getAsJsonArray("medicineClassification");
      for (int i = 0; i < array.size(); i++) {
        res.getMedicineClassification().add(parseMedicationKnowledgeMedicineClassificationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("packaging"))
      res.setPackaging(parseMedicationKnowledgePackagingComponent(json.getAsJsonObject("packaging")));
    if (json.has("drugCharacteristic")) {
      JsonArray array = json.getAsJsonArray("drugCharacteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getDrugCharacteristic().add(parseMedicationKnowledgeDrugCharacteristicComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalUseIssue")) {
      JsonArray array = json.getAsJsonArray("clinicalUseIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getClinicalUseIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("regulatory")) {
      JsonArray array = json.getAsJsonArray("regulatory");
      for (int i = 0; i < array.size(); i++) {
        res.getRegulatory().add(parseMedicationKnowledgeRegulatoryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("kineticCharacteristic")) {
      JsonArray array = json.getAsJsonArray("kineticCharacteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getKineticCharacteristic().add(parseMedicationKnowledgeKineticCharacteristicComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent parseMedicationKnowledgeRelatedMedicationKnowledgeComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res = new MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent();
    parseMedicationKnowledgeRelatedMedicationKnowledgeComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeRelatedMedicationKnowledgeComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("reference")) {
      JsonArray array = json.getAsJsonArray("reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeMonographComponent parseMedicationKnowledgeMonographComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonographComponent res = new MedicationKnowledge.MedicationKnowledgeMonographComponent();
    parseMedicationKnowledgeMonographComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeMonographComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeMonographComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("source"))
      res.setSource(parseReference(json.getAsJsonObject("source")));
  }

  protected MedicationKnowledge.MedicationKnowledgeIngredientComponent parseMedicationKnowledgeIngredientComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeIngredientComponent res = new MedicationKnowledge.MedicationKnowledgeIngredientComponent();
    parseMedicationKnowledgeIngredientComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeIngredientComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeIngredientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
    if (json.has("isActive"))
      res.setIsActiveElement(parseBoolean(json.get("isActive").getAsBoolean()));
    if (json.has("_isActive"))
      parseElementProperties(json.getAsJsonObject("_isActive"), res.getIsActiveElement());
    DataType strength = parseType("strength", json);
    if (strength != null)
      res.setStrength(strength);
  }

  protected MedicationKnowledge.MedicationKnowledgeCostComponent parseMedicationKnowledgeCostComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeCostComponent res = new MedicationKnowledge.MedicationKnowledgeCostComponent();
    parseMedicationKnowledgeCostComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeCostComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("source"))
      res.setSourceElement(parseString(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(json.getAsJsonObject("_source"), res.getSourceElement());
    if (json.has("cost"))
      res.setCost(parseMoney(json.getAsJsonObject("cost")));
  }

  protected MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent parseMedicationKnowledgeMonitoringProgramComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res = new MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent();
    parseMedicationKnowledgeMonitoringProgramComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeMonitoringProgramComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineComponent parseMedicationKnowledgeAdministrationGuidelineComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineComponent();
    parseMedicationKnowledgeAdministrationGuidelineComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeAdministrationGuidelineComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseMedicationKnowledgeAdministrationGuidelineDosageComponent(array.get(i).getAsJsonObject()));
      }
    };
    DataType indication = parseType("indication", json);
    if (indication != null)
      res.setIndication(indication);
    if (json.has("patientCharacteristic")) {
      JsonArray array = json.getAsJsonArray("patientCharacteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getPatientCharacteristic().add(parseMedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineDosageComponent parseMedicationKnowledgeAdministrationGuidelineDosageComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineDosageComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineDosageComponent();
    parseMedicationKnowledgeAdministrationGuidelineDosageComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeAdministrationGuidelineDosageComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelineDosageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent parseMedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent();
    parseMedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinePatientCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType characteristic = parseType("characteristic", json);
    if (characteristic != null)
      res.setCharacteristic(characteristic);
    if (json.has("value")) {
      JsonArray array = json.getAsJsonArray("value");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getValue().add(new StringType());
        } else {;
          res.getValue().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_value")) {
      JsonArray array = json.getAsJsonArray("_value");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getValue().size())
          res.getValue().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getValue().get(i));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent parseMedicationKnowledgeMedicineClassificationComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res = new MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent();
    parseMedicationKnowledgeMedicineClassificationComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeMedicineClassificationComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("classification")) {
      JsonArray array = json.getAsJsonArray("classification");
      for (int i = 0; i < array.size(); i++) {
        res.getClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgePackagingComponent parseMedicationKnowledgePackagingComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgePackagingComponent res = new MedicationKnowledge.MedicationKnowledgePackagingComponent();
    parseMedicationKnowledgePackagingComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgePackagingComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgePackagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("material"))
      res.setMaterial(parseCodeableConcept(json.getAsJsonObject("material")));
    if (json.has("packaging")) {
      JsonArray array = json.getAsJsonArray("packaging");
      for (int i = 0; i < array.size(); i++) {
        res.getPackaging().add(parseMedicationKnowledgePackagingComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent parseMedicationKnowledgeDrugCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent();
    parseMedicationKnowledgeDrugCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeDrugCharacteristicComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryComponent parseMedicationKnowledgeRegulatoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryComponent();
    parseMedicationKnowledgeRegulatoryComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeRegulatoryComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("regulatoryAuthority"))
      res.setRegulatoryAuthority(parseReference(json.getAsJsonObject("regulatoryAuthority")));
    if (json.has("substitution")) {
      JsonArray array = json.getAsJsonArray("substitution");
      for (int i = 0; i < array.size(); i++) {
        res.getSubstitution().add(parseMedicationKnowledgeRegulatorySubstitutionComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("maxDispense"))
      res.setMaxDispense(parseMedicationKnowledgeRegulatoryMaxDispenseComponent(json.getAsJsonObject("maxDispense")));
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent parseMedicationKnowledgeRegulatorySubstitutionComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent();
    parseMedicationKnowledgeRegulatorySubstitutionComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeRegulatorySubstitutionComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("allowed"))
      res.setAllowedElement(parseBoolean(json.get("allowed").getAsBoolean()));
    if (json.has("_allowed"))
      parseElementProperties(json.getAsJsonObject("_allowed"), res.getAllowedElement());
  }

  protected MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent parseMedicationKnowledgeRegulatoryMaxDispenseComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent();
    parseMedicationKnowledgeRegulatoryMaxDispenseComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeRegulatoryMaxDispenseComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("period"))
      res.setPeriod(parseDuration(json.getAsJsonObject("period")));
  }

  protected MedicationKnowledge.MedicationKnowledgeKineticCharacteristicComponent parseMedicationKnowledgeKineticCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationKnowledge.MedicationKnowledgeKineticCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeKineticCharacteristicComponent();
    parseMedicationKnowledgeKineticCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationKnowledgeKineticCharacteristicComponentProperties(JsonObject json, MedicationKnowledge.MedicationKnowledgeKineticCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected MedicationRequest parseMedicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    MedicationRequest res = new MedicationRequest();
    parseMedicationRequestProperties(json, res);
    return res;
  }

  protected void parseMedicationRequestProperties(JsonObject json, MedicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationRequest.MedicationrequestStatus.NULL, new MedicationRequest.MedicationrequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(json.getAsJsonObject("statusReason")));
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(json.getAsJsonObject("_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(json.getAsJsonObject("_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("reported"))
      res.setReportedElement(parseBoolean(json.get("reported").getAsBoolean()));
    if (json.has("_reported"))
      parseElementProperties(json.getAsJsonObject("_reported"), res.getReportedElement());
    if (json.has("informationSource"))
      res.setInformationSource(parseReference(json.getAsJsonObject("informationSource")));
    DataType medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("supportingInformation")) {
      JsonArray array = json.getAsJsonArray("supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(json.getAsJsonObject("_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(json.getAsJsonObject("requester")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("performerType"))
      res.setPerformerType(parseCodeableConcept(json.getAsJsonObject("performerType")));
    if (json.has("recorder"))
      res.setRecorder(parseReference(json.getAsJsonObject("recorder")));
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(json.getAsJsonObject("groupIdentifier")));
    if (json.has("courseOfTherapyType"))
      res.setCourseOfTherapyType(parseCodeableConcept(json.getAsJsonObject("courseOfTherapyType")));
    if (json.has("insurance")) {
      JsonArray array = json.getAsJsonArray("insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("renderedDosageInstruction"))
      res.setRenderedDosageInstructionElement(parseString(json.get("renderedDosageInstruction").getAsString()));
    if (json.has("_renderedDosageInstruction"))
      parseElementProperties(json.getAsJsonObject("_renderedDosageInstruction"), res.getRenderedDosageInstructionElement());
    if (json.has("dosageInstruction")) {
      JsonArray array = json.getAsJsonArray("dosageInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getDosageInstruction().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("dispenseRequest"))
      res.setDispenseRequest(parseMedicationRequestDispenseRequestComponent(json.getAsJsonObject("dispenseRequest")));
    if (json.has("substitution"))
      res.setSubstitution(parseMedicationRequestSubstitutionComponent(json.getAsJsonObject("substitution")));
    if (json.has("priorPrescription"))
      res.setPriorPrescription(parseReference(json.getAsJsonObject("priorPrescription")));
    if (json.has("detectedIssue")) {
      JsonArray array = json.getAsJsonArray("detectedIssue");
      for (int i = 0; i < array.size(); i++) {
        res.getDetectedIssue().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("eventHistory")) {
      JsonArray array = json.getAsJsonArray("eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestDispenseRequestComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
    parseMedicationRequestDispenseRequestComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationRequestDispenseRequestComponentProperties(JsonObject json, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("initialFill"))
      res.setInitialFill(parseMedicationRequestDispenseRequestInitialFillComponent(json.getAsJsonObject("initialFill")));
    if (json.has("dispenseInterval"))
      res.setDispenseInterval(parseDuration(json.getAsJsonObject("dispenseInterval")));
    if (json.has("validityPeriod"))
      res.setValidityPeriod(parsePeriod(json.getAsJsonObject("validityPeriod")));
    if (json.has("numberOfRepeatsAllowed"))
      res.setNumberOfRepeatsAllowedElement(parseUnsignedInt(json.get("numberOfRepeatsAllowed").getAsString()));
    if (json.has("_numberOfRepeatsAllowed"))
      parseElementProperties(json.getAsJsonObject("_numberOfRepeatsAllowed"), res.getNumberOfRepeatsAllowedElement());
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("expectedSupplyDuration"))
      res.setExpectedSupplyDuration(parseDuration(json.getAsJsonObject("expectedSupplyDuration")));
    if (json.has("dispenser"))
      res.setDispenser(parseReference(json.getAsJsonObject("dispenser")));
  }

  protected MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent parseMedicationRequestDispenseRequestInitialFillComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res = new MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent();
    parseMedicationRequestDispenseRequestInitialFillComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationRequestDispenseRequestInitialFillComponentProperties(JsonObject json, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("duration"))
      res.setDuration(parseDuration(json.getAsJsonObject("duration")));
  }

  protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestSubstitutionComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
    parseMedicationRequestSubstitutionComponentProperties(json, res);
    return res;
  }

  protected void parseMedicationRequestSubstitutionComponentProperties(JsonObject json, MedicationRequest.MedicationRequestSubstitutionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
  }

  protected MedicationUsage parseMedicationUsage(JsonObject json) throws IOException, FHIRFormatError {
    MedicationUsage res = new MedicationUsage();
    parseMedicationUsageProperties(json, res);
    return res;
  }

  protected void parseMedicationUsageProperties(JsonObject json, MedicationUsage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), MedicationUsage.MedicationUsageStatusCodes.NULL, new MedicationUsage.MedicationUsageStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    DataType medication = parseType("medication", json);
    if (medication != null)
      res.setMedication(medication);
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("dateAsserted"))
      res.setDateAssertedElement(parseDateTime(json.get("dateAsserted").getAsString()));
    if (json.has("_dateAsserted"))
      parseElementProperties(json.getAsJsonObject("_dateAsserted"), res.getDateAssertedElement());
    if (json.has("informationSource"))
      res.setInformationSource(parseReference(json.getAsJsonObject("informationSource")));
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reason")) {
      JsonArray array = json.getAsJsonArray("reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("renderedDosageInstruction"))
      res.setRenderedDosageInstructionElement(parseString(json.get("renderedDosageInstruction").getAsString()));
    if (json.has("_renderedDosageInstruction"))
      parseElementProperties(json.getAsJsonObject("_renderedDosageInstruction"), res.getRenderedDosageInstructionElement());
    if (json.has("dosage")) {
      JsonArray array = json.getAsJsonArray("dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("takenAsOrdered"))
      res.setTakenAsOrderedElement(parseBoolean(json.get("takenAsOrdered").getAsBoolean()));
    if (json.has("_takenAsOrdered"))
      parseElementProperties(json.getAsJsonObject("_takenAsOrdered"), res.getTakenAsOrderedElement());
  }

  protected MedicinalProductDefinition parseMedicinalProductDefinition(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductDefinition res = new MedicinalProductDefinition();
    parseMedicinalProductDefinitionProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductDefinitionProperties(JsonObject json, MedicinalProductDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("domain"))
      res.setDomain(parseCoding(json.getAsJsonObject("domain")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatus(parseCoding(json.getAsJsonObject("status")));
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("combinedPharmaceuticalDoseForm"))
      res.setCombinedPharmaceuticalDoseForm(parseCodeableConcept(json.getAsJsonObject("combinedPharmaceuticalDoseForm")));
    if (json.has("indication"))
      res.setIndicationElement(parseMarkdown(json.get("indication").getAsString()));
    if (json.has("_indication"))
      parseElementProperties(json.getAsJsonObject("_indication"), res.getIndicationElement());
    if (json.has("legalStatusOfSupply"))
      res.setLegalStatusOfSupply(parseCodeableConcept(json.getAsJsonObject("legalStatusOfSupply")));
    if (json.has("additionalMonitoringIndicator"))
      res.setAdditionalMonitoringIndicator(parseCodeableConcept(json.getAsJsonObject("additionalMonitoringIndicator")));
    if (json.has("specialMeasures")) {
      JsonArray array = json.getAsJsonArray("specialMeasures");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialMeasures().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("paediatricUseIndicator"))
      res.setPaediatricUseIndicator(parseCodeableConcept(json.getAsJsonObject("paediatricUseIndicator")));
    if (json.has("productClassification")) {
      JsonArray array = json.getAsJsonArray("productClassification");
      for (int i = 0; i < array.size(); i++) {
        res.getProductClassification().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("marketingStatus")) {
      JsonArray array = json.getAsJsonArray("marketingStatus");
      for (int i = 0; i < array.size(); i++) {
        res.getMarketingStatus().add(parseMarketingStatus(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("pharmaceuticalProduct")) {
      JsonArray array = json.getAsJsonArray("pharmaceuticalProduct");
      for (int i = 0; i < array.size(); i++) {
        res.getPharmaceuticalProduct().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("packagedMedicinalProduct")) {
      JsonArray array = json.getAsJsonArray("packagedMedicinalProduct");
      for (int i = 0; i < array.size(); i++) {
        res.getPackagedMedicinalProduct().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = json.getAsJsonArray("ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("attachedDocument")) {
      JsonArray array = json.getAsJsonArray("attachedDocument");
      for (int i = 0; i < array.size(); i++) {
        res.getAttachedDocument().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("masterFile")) {
      JsonArray array = json.getAsJsonArray("masterFile");
      for (int i = 0; i < array.size(); i++) {
        res.getMasterFile().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseMedicinalProductDefinitionContactComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("clinicalTrial")) {
      JsonArray array = json.getAsJsonArray("clinicalTrial");
      for (int i = 0; i < array.size(); i++) {
        res.getClinicalTrial().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("name")) {
      JsonArray array = json.getAsJsonArray("name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseMedicinalProductDefinitionNameComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("crossReference")) {
      JsonArray array = json.getAsJsonArray("crossReference");
      for (int i = 0; i < array.size(); i++) {
        res.getCrossReference().add(parseMedicinalProductDefinitionCrossReferenceComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("manufacturingBusinessOperation")) {
      JsonArray array = json.getAsJsonArray("manufacturingBusinessOperation");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturingBusinessOperation().add(parseMedicinalProductDefinitionManufacturingBusinessOperationComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionContactComponent parseMedicinalProductDefinitionContactComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionContactComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionContactComponent();
    parseMedicinalProductDefinitionContactComponentProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductDefinitionContactComponentProperties(JsonObject json, MedicinalProductDefinition.MedicinalProductDefinitionContactComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("contact"))
      res.setContact(parseReference(json.getAsJsonObject("contact")));
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameComponent parseMedicinalProductDefinitionNameComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameComponent();
    parseMedicinalProductDefinitionNameComponentProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductDefinitionNameComponentProperties(JsonObject json, MedicinalProductDefinition.MedicinalProductDefinitionNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("productName"))
      res.setProductNameElement(parseString(json.get("productName").getAsString()));
    if (json.has("_productName"))
      parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
    if (json.has("namePart")) {
      JsonArray array = json.getAsJsonArray("namePart");
      for (int i = 0; i < array.size(); i++) {
        res.getNamePart().add(parseMedicinalProductDefinitionNameNamePartComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("countryLanguage")) {
      JsonArray array = json.getAsJsonArray("countryLanguage");
      for (int i = 0; i < array.size(); i++) {
        res.getCountryLanguage().add(parseMedicinalProductDefinitionNameCountryLanguageComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent parseMedicinalProductDefinitionNameNamePartComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent();
    parseMedicinalProductDefinitionNameNamePartComponentProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductDefinitionNameNamePartComponentProperties(JsonObject json, MedicinalProductDefinition.MedicinalProductDefinitionNameNamePartComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("part"))
      res.setPartElement(parseString(json.get("part").getAsString()));
    if (json.has("_part"))
      parseElementProperties(json.getAsJsonObject("_part"), res.getPartElement());
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent parseMedicinalProductDefinitionNameCountryLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent();
    parseMedicinalProductDefinitionNameCountryLanguageComponentProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductDefinitionNameCountryLanguageComponentProperties(JsonObject json, MedicinalProductDefinition.MedicinalProductDefinitionNameCountryLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(json.getAsJsonObject("country")));
    if (json.has("jurisdiction"))
      res.setJurisdiction(parseCodeableConcept(json.getAsJsonObject("jurisdiction")));
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(json.getAsJsonObject("language")));
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent parseMedicinalProductDefinitionCrossReferenceComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent();
    parseMedicinalProductDefinitionCrossReferenceComponentProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductDefinitionCrossReferenceComponentProperties(JsonObject json, MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("type"))
      res.setType(parseCoding(json.getAsJsonObject("type")));
  }

  protected MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent parseMedicinalProductDefinitionManufacturingBusinessOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
    MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent res = new MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent();
    parseMedicinalProductDefinitionManufacturingBusinessOperationComponentProperties(json, res);
    return res;
  }

  protected void parseMedicinalProductDefinitionManufacturingBusinessOperationComponentProperties(JsonObject json, MedicinalProductDefinition.MedicinalProductDefinitionManufacturingBusinessOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType type = parseType("type", json);
    if (type != null)
      res.setType(type);
    if (json.has("effectiveDate"))
      res.setEffectiveDate(parsePeriod(json.getAsJsonObject("effectiveDate")));
    if (json.has("manufacturer")) {
      JsonArray array = json.getAsJsonArray("manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("authorization"))
      res.setAuthorization(parseReference(json.getAsJsonObject("authorization")));
    if (json.has("confidentialityIndicator"))
      res.setConfidentialityIndicator(parseCodeableConcept(json.getAsJsonObject("confidentialityIndicator")));
  }

  protected MessageDefinition parseMessageDefinition(JsonObject json) throws IOException, FHIRFormatError {
    MessageDefinition res = new MessageDefinition();
    parseMessageDefinitionProperties(json, res);
    return res;
  }

  protected void parseMessageDefinitionProperties(JsonObject json, MessageDefinition res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(json.getAsJsonObject("_title"), res.getTitleElement());
    if (json.has("replaces")) {
      JsonArray array = json.getAsJsonArray("replaces");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReplaces().add(new CanonicalType());
        } else {;
          res.getReplaces().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_replaces")) {
      JsonArray array = json.getAsJsonArray("_replaces");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReplaces().size())
          res.getReplaces().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getReplaces().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(json.getAsJsonObject("_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(json.getAsJsonObject("_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(json.getAsJsonObject("_copyright"), res.getCopyrightElement());
    if (json.has("base"))
      res.setBaseElement(parseCanonical(json.get("base").getAsString()));
    if (json.has("_base"))
      parseElementProperties(json.getAsJsonObject("_base"), res.getBaseElement());
    if (json.has("parent")) {
      JsonArray array = json.getAsJsonArray("parent");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getParent().add(new CanonicalType());
        } else {;
          res.getParent().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_parent")) {
      JsonArray array = json.getAsJsonArray("_parent");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParent().size())
          res.getParent().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getParent().get(i));
      }
    };
    DataType event = parseType("event", json);
    if (event != null)
      res.setEvent(event);
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(json.getAsJsonObject("_category"), res.getCategoryElement());
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseMessageDefinitionFocusComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responseRequired"))
      res.setResponseRequiredElement(parseEnumeration(json.get("responseRequired").getAsString(), MessageDefinition.MessageheaderResponseRequest.NULL, new MessageDefinition.MessageheaderResponseRequestEnumFactory()));
    if (json.has("_responseRequired"))
      parseElementProperties(json.getAsJsonObject("_responseRequired"), res.getResponseRequiredElement());
    if (json.has("allowedResponse")) {
      JsonArray array = json.getAsJsonArray("allowedResponse");
      for (int i = 0; i < array.size(); i++) {
        res.getAllowedResponse().add(parseMessageDefinitionAllowedResponseComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("graph")) {
      JsonArray array = json.getAsJsonArray("graph");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getGraph().add(new CanonicalType());
        } else {;
          res.getGraph().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_graph")) {
      JsonArray array = json.getAsJsonArray("_graph");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGraph().size())
          res.getGraph().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getGraph().get(i));
      }
    };
  }

  protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionFocusComponent(JsonObject json) throws IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
    parseMessageDefinitionFocusComponentProperties(json, res);
    return res;
  }

  protected void parseMessageDefinitionFocusComponentProperties(JsonObject json, MessageDefinition.MessageDefinitionFocusComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(json.getAsJsonObject("_profile"), res.getProfileElement());
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(json.getAsJsonObject("_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(json.getAsJsonObject("_max"), res.getMaxElement());
  }

  protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionAllowedResponseComponent(JsonObject json) throws IOException, FHIRFormatError {
    MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
    parseMessageDefinitionAllowedResponseComponentProperties(json, res);
    return res;
  }

  protected void parseMessageDefinitionAllowedResponseComponentProperties(JsonObject json, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("message"))
      res.setMessageElement(parseCanonical(json.get("message").getAsString()));
    if (json.has("_message"))
      parseElementProperties(json.getAsJsonObject("_message"), res.getMessageElement());
    if (json.has("situation"))
      res.setSituationElement(parseMarkdown(json.get("situation").getAsString()));
    if (json.has("_situation"))
      parseElementProperties(json.getAsJsonObject("_situation"), res.getSituationElement());
  }

  protected MessageHeader parseMessageHeader(JsonObject json) throws IOException, FHIRFormatError {
    MessageHeader res = new MessageHeader();
    parseMessageHeaderProperties(json, res);
    return res;
  }

  protected void parseMessageHeaderProperties(JsonObject json, MessageHeader res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    DataType event = parseType("event", json);
    if (event != null)
      res.setEvent(event);
    if (json.has("destination")) {
      JsonArray array = json.getAsJsonArray("destination");
      for (int i = 0; i < array.size(); i++) {
        res.getDestination().add(parseMessageHeaderMessageDestinationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(json.getAsJsonObject("sender")));
    if (json.has("enterer"))
      res.setEnterer(parseReference(json.getAsJsonObject("enterer")));
    if (json.has("author"))
      res.setAuthor(parseReference(json.getAsJsonObject("author")));
    if (json.has("source"))
      res.setSource(parseMessageHeaderMessageSourceComponent(json.getAsJsonObject("source")));
    if (json.has("responsible"))
      res.setResponsible(parseReference(json.getAsJsonObject("responsible")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(json.getAsJsonObject("reason")));
    if (json.has("response"))
      res.setResponse(parseMessageHeaderResponseComponent(json.getAsJsonObject("response")));
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(json.getAsJsonObject("_definition"), res.getDefinitionElement());
  }

  protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(JsonObject json) throws IOException, FHIRFormatError {
    MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
    parseMessageHeaderMessageDestinationComponentProperties(json, res);
    return res;
  }

  protected void parseMessageHeaderMessageDestinationComponentProperties(JsonObject json, MessageHeader.MessageDestinationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("target"))
      res.setTarget(parseReference(json.getAsJsonObject("target")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUrl(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
    if (json.has("receiver"))
      res.setReceiver(parseReference(json.getAsJsonObject("receiver")));
  }

  protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
    parseMessageHeaderMessageSourceComponentProperties(json, res);
    return res;
  }

  protected void parseMessageHeaderMessageSourceComponentProperties(JsonObject json, MessageHeader.MessageSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("software"))
      res.setSoftwareElement(parseString(json.get("software").getAsString()));
    if (json.has("_software"))
      parseElementProperties(json.getAsJsonObject("_software"), res.getSoftwareElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("contact"))
      res.setContact(parseContactPoint(json.getAsJsonObject("contact")));
    if (json.has("endpoint"))
      res.setEndpointElement(parseUrl(json.get("endpoint").getAsString()));
    if (json.has("_endpoint"))
      parseElementProperties(json.getAsJsonObject("_endpoint"), res.getEndpointElement());
  }

  protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderResponseComponent(JsonObject json) throws IOException, FHIRFormatError {
    MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
    parseMessageHeaderResponseComponentProperties(json, res);
    return res;
  }

  protected void parseMessageHeaderResponseComponentProperties(JsonObject json, MessageHeader.MessageHeaderResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifierElement(parseId(json.get("identifier").getAsString()));
    if (json.has("_identifier"))
      parseElementProperties(json.getAsJsonObject("_identifier"), res.getIdentifierElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(json.getAsJsonObject("_code"), res.getCodeElement());
    if (json.has("details"))
      res.setDetails(parseReference(json.getAsJsonObject("details")));
  }

  protected MolecularSequence parseMolecularSequence(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence res = new MolecularSequence();
    parseMolecularSequenceProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceProperties(JsonObject json, MolecularSequence res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MolecularSequence.SequenceType.NULL, new MolecularSequence.SequenceTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("coordinateSystem"))
      res.setCoordinateSystemElement(parseInteger(json.get("coordinateSystem").getAsLong()));
    if (json.has("_coordinateSystem"))
      parseElementProperties(json.getAsJsonObject("_coordinateSystem"), res.getCoordinateSystemElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(json.getAsJsonObject("specimen")));
    if (json.has("device"))
      res.setDevice(parseReference(json.getAsJsonObject("device")));
    if (json.has("performer"))
      res.setPerformer(parseReference(json.getAsJsonObject("performer")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("referenceSeq"))
      res.setReferenceSeq(parseMolecularSequenceReferenceSeqComponent(json.getAsJsonObject("referenceSeq")));
    if (json.has("variant")) {
      JsonArray array = json.getAsJsonArray("variant");
      for (int i = 0; i < array.size(); i++) {
        res.getVariant().add(parseMolecularSequenceVariantComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("observedSeq"))
      res.setObservedSeqElement(parseString(json.get("observedSeq").getAsString()));
    if (json.has("_observedSeq"))
      parseElementProperties(json.getAsJsonObject("_observedSeq"), res.getObservedSeqElement());
    if (json.has("quality")) {
      JsonArray array = json.getAsJsonArray("quality");
      for (int i = 0; i < array.size(); i++) {
        res.getQuality().add(parseMolecularSequenceQualityComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("readCoverage"))
      res.setReadCoverageElement(parseInteger(json.get("readCoverage").getAsLong()));
    if (json.has("_readCoverage"))
      parseElementProperties(json.getAsJsonObject("_readCoverage"), res.getReadCoverageElement());
    if (json.has("repository")) {
      JsonArray array = json.getAsJsonArray("repository");
      for (int i = 0; i < array.size(); i++) {
        res.getRepository().add(parseMolecularSequenceRepositoryComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("pointer")) {
      JsonArray array = json.getAsJsonArray("pointer");
      for (int i = 0; i < array.size(); i++) {
        res.getPointer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("structureVariant")) {
      JsonArray array = json.getAsJsonArray("structureVariant");
      for (int i = 0; i < array.size(); i++) {
        res.getStructureVariant().add(parseMolecularSequenceStructureVariantComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected MolecularSequence.MolecularSequenceReferenceSeqComponent parseMolecularSequenceReferenceSeqComponent(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceReferenceSeqComponent res = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
    parseMolecularSequenceReferenceSeqComponentProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceReferenceSeqComponentProperties(JsonObject json, MolecularSequence.MolecularSequenceReferenceSeqComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("chromosome"))
      res.setChromosome(parseCodeableConcept(json.getAsJsonObject("chromosome")));
    if (json.has("genomeBuild"))
      res.setGenomeBuildElement(parseString(json.get("genomeBuild").getAsString()));
    if (json.has("_genomeBuild"))
      parseElementProperties(json.getAsJsonObject("_genomeBuild"), res.getGenomeBuildElement());
    if (json.has("orientation"))
      res.setOrientationElement(parseEnumeration(json.get("orientation").getAsString(), MolecularSequence.OrientationType.NULL, new MolecularSequence.OrientationTypeEnumFactory()));
    if (json.has("_orientation"))
      parseElementProperties(json.getAsJsonObject("_orientation"), res.getOrientationElement());
    if (json.has("referenceSeqId"))
      res.setReferenceSeqId(parseCodeableConcept(json.getAsJsonObject("referenceSeqId")));
    if (json.has("referenceSeqPointer"))
      res.setReferenceSeqPointer(parseReference(json.getAsJsonObject("referenceSeqPointer")));
    if (json.has("referenceSeqString"))
      res.setReferenceSeqStringElement(parseString(json.get("referenceSeqString").getAsString()));
    if (json.has("_referenceSeqString"))
      parseElementProperties(json.getAsJsonObject("_referenceSeqString"), res.getReferenceSeqStringElement());
    if (json.has("strand"))
      res.setStrandElement(parseEnumeration(json.get("strand").getAsString(), MolecularSequence.StrandType.NULL, new MolecularSequence.StrandTypeEnumFactory()));
    if (json.has("_strand"))
      parseElementProperties(json.getAsJsonObject("_strand"), res.getStrandElement());
    if (json.has("windowStart"))
      res.setWindowStartElement(parseInteger(json.get("windowStart").getAsLong()));
    if (json.has("_windowStart"))
      parseElementProperties(json.getAsJsonObject("_windowStart"), res.getWindowStartElement());
    if (json.has("windowEnd"))
      res.setWindowEndElement(parseInteger(json.get("windowEnd").getAsLong()));
    if (json.has("_windowEnd"))
      parseElementProperties(json.getAsJsonObject("_windowEnd"), res.getWindowEndElement());
  }

  protected MolecularSequence.MolecularSequenceVariantComponent parseMolecularSequenceVariantComponent(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceVariantComponent res = new MolecularSequence.MolecularSequenceVariantComponent();
    parseMolecularSequenceVariantComponentProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceVariantComponentProperties(JsonObject json, MolecularSequence.MolecularSequenceVariantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("observedAllele"))
      res.setObservedAlleleElement(parseString(json.get("observedAllele").getAsString()));
    if (json.has("_observedAllele"))
      parseElementProperties(json.getAsJsonObject("_observedAllele"), res.getObservedAlleleElement());
    if (json.has("referenceAllele"))
      res.setReferenceAlleleElement(parseString(json.get("referenceAllele").getAsString()));
    if (json.has("_referenceAllele"))
      parseElementProperties(json.getAsJsonObject("_referenceAllele"), res.getReferenceAlleleElement());
    if (json.has("cigar"))
      res.setCigarElement(parseString(json.get("cigar").getAsString()));
    if (json.has("_cigar"))
      parseElementProperties(json.getAsJsonObject("_cigar"), res.getCigarElement());
    if (json.has("variantPointer"))
      res.setVariantPointer(parseReference(json.getAsJsonObject("variantPointer")));
  }

  protected MolecularSequence.MolecularSequenceQualityComponent parseMolecularSequenceQualityComponent(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceQualityComponent res = new MolecularSequence.MolecularSequenceQualityComponent();
    parseMolecularSequenceQualityComponentProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceQualityComponentProperties(JsonObject json, MolecularSequence.MolecularSequenceQualityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MolecularSequence.QualityType.NULL, new MolecularSequence.QualityTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("standardSequence"))
      res.setStandardSequence(parseCodeableConcept(json.getAsJsonObject("standardSequence")));
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
    if (json.has("score"))
      res.setScore(parseQuantity(json.getAsJsonObject("score")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("truthTP"))
      res.setTruthTPElement(parseDecimal(json.get("truthTP").getAsBigDecimal()));
    if (json.has("_truthTP"))
      parseElementProperties(json.getAsJsonObject("_truthTP"), res.getTruthTPElement());
    if (json.has("queryTP"))
      res.setQueryTPElement(parseDecimal(json.get("queryTP").getAsBigDecimal()));
    if (json.has("_queryTP"))
      parseElementProperties(json.getAsJsonObject("_queryTP"), res.getQueryTPElement());
    if (json.has("truthFN"))
      res.setTruthFNElement(parseDecimal(json.get("truthFN").getAsBigDecimal()));
    if (json.has("_truthFN"))
      parseElementProperties(json.getAsJsonObject("_truthFN"), res.getTruthFNElement());
    if (json.has("queryFP"))
      res.setQueryFPElement(parseDecimal(json.get("queryFP").getAsBigDecimal()));
    if (json.has("_queryFP"))
      parseElementProperties(json.getAsJsonObject("_queryFP"), res.getQueryFPElement());
    if (json.has("gtFP"))
      res.setGtFPElement(parseDecimal(json.get("gtFP").getAsBigDecimal()));
    if (json.has("_gtFP"))
      parseElementProperties(json.getAsJsonObject("_gtFP"), res.getGtFPElement());
    if (json.has("precision"))
      res.setPrecisionElement(parseDecimal(json.get("precision").getAsBigDecimal()));
    if (json.has("_precision"))
      parseElementProperties(json.getAsJsonObject("_precision"), res.getPrecisionElement());
    if (json.has("recall"))
      res.setRecallElement(parseDecimal(json.get("recall").getAsBigDecimal()));
    if (json.has("_recall"))
      parseElementProperties(json.getAsJsonObject("_recall"), res.getRecallElement());
    if (json.has("fScore"))
      res.setFScoreElement(parseDecimal(json.get("fScore").getAsBigDecimal()));
    if (json.has("_fScore"))
      parseElementProperties(json.getAsJsonObject("_fScore"), res.getFScoreElement());
    if (json.has("roc"))
      res.setRoc(parseMolecularSequenceQualityRocComponent(json.getAsJsonObject("roc")));
  }

  protected MolecularSequence.MolecularSequenceQualityRocComponent parseMolecularSequenceQualityRocComponent(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceQualityRocComponent res = new MolecularSequence.MolecularSequenceQualityRocComponent();
    parseMolecularSequenceQualityRocComponentProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceQualityRocComponentProperties(JsonObject json, MolecularSequence.MolecularSequenceQualityRocComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("score")) {
      JsonArray array = json.getAsJsonArray("score");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getScore().add(new IntegerType());
        } else {;
          res.getScore().add(parseInteger(array.get(i).getAsLong()));
        }
      }
    };
    if (json.has("_score")) {
      JsonArray array = json.getAsJsonArray("_score");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getScore().size())
          res.getScore().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getScore().get(i));
      }
    };
    if (json.has("numTP")) {
      JsonArray array = json.getAsJsonArray("numTP");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumTP().add(new IntegerType());
        } else {;
          res.getNumTP().add(parseInteger(array.get(i).getAsLong()));
        }
      }
    };
    if (json.has("_numTP")) {
      JsonArray array = json.getAsJsonArray("_numTP");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumTP().size())
          res.getNumTP().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumTP().get(i));
      }
    };
    if (json.has("numFP")) {
      JsonArray array = json.getAsJsonArray("numFP");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumFP().add(new IntegerType());
        } else {;
          res.getNumFP().add(parseInteger(array.get(i).getAsLong()));
        }
      }
    };
    if (json.has("_numFP")) {
      JsonArray array = json.getAsJsonArray("_numFP");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumFP().size())
          res.getNumFP().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumFP().get(i));
      }
    };
    if (json.has("numFN")) {
      JsonArray array = json.getAsJsonArray("numFN");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumFN().add(new IntegerType());
        } else {;
          res.getNumFN().add(parseInteger(array.get(i).getAsLong()));
        }
      }
    };
    if (json.has("_numFN")) {
      JsonArray array = json.getAsJsonArray("_numFN");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumFN().size())
          res.getNumFN().add(parseInteger(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getNumFN().get(i));
      }
    };
    if (json.has("precision")) {
      JsonArray array = json.getAsJsonArray("precision");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPrecision().add(new DecimalType());
        } else {;
          res.getPrecision().add(parseDecimal(array.get(i).getAsBigDecimal()));
        }
      }
    };
    if (json.has("_precision")) {
      JsonArray array = json.getAsJsonArray("_precision");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPrecision().size())
          res.getPrecision().add(parseDecimal(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getPrecision().get(i));
      }
    };
    if (json.has("sensitivity")) {
      JsonArray array = json.getAsJsonArray("sensitivity");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSensitivity().add(new DecimalType());
        } else {;
          res.getSensitivity().add(parseDecimal(array.get(i).getAsBigDecimal()));
        }
      }
    };
    if (json.has("_sensitivity")) {
      JsonArray array = json.getAsJsonArray("_sensitivity");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSensitivity().size())
          res.getSensitivity().add(parseDecimal(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getSensitivity().get(i));
      }
    };
    if (json.has("fMeasure")) {
      JsonArray array = json.getAsJsonArray("fMeasure");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFMeasure().add(new DecimalType());
        } else {;
          res.getFMeasure().add(parseDecimal(array.get(i).getAsBigDecimal()));
        }
      }
    };
    if (json.has("_fMeasure")) {
      JsonArray array = json.getAsJsonArray("_fMeasure");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFMeasure().size())
          res.getFMeasure().add(parseDecimal(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getFMeasure().get(i));
      }
    };
  }

  protected MolecularSequence.MolecularSequenceRepositoryComponent parseMolecularSequenceRepositoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceRepositoryComponent res = new MolecularSequence.MolecularSequenceRepositoryComponent();
    parseMolecularSequenceRepositoryComponentProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceRepositoryComponentProperties(JsonObject json, MolecularSequence.MolecularSequenceRepositoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MolecularSequence.RepositoryType.NULL, new MolecularSequence.RepositoryTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("datasetId"))
      res.setDatasetIdElement(parseString(json.get("datasetId").getAsString()));
    if (json.has("_datasetId"))
      parseElementProperties(json.getAsJsonObject("_datasetId"), res.getDatasetIdElement());
    if (json.has("variantsetId"))
      res.setVariantsetIdElement(parseString(json.get("variantsetId").getAsString()));
    if (json.has("_variantsetId"))
      parseElementProperties(json.getAsJsonObject("_variantsetId"), res.getVariantsetIdElement());
    if (json.has("readsetId"))
      res.setReadsetIdElement(parseString(json.get("readsetId").getAsString()));
    if (json.has("_readsetId"))
      parseElementProperties(json.getAsJsonObject("_readsetId"), res.getReadsetIdElement());
  }

  protected MolecularSequence.MolecularSequenceStructureVariantComponent parseMolecularSequenceStructureVariantComponent(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantComponent res = new MolecularSequence.MolecularSequenceStructureVariantComponent();
    parseMolecularSequenceStructureVariantComponentProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceStructureVariantComponentProperties(JsonObject json, MolecularSequence.MolecularSequenceStructureVariantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("variantType"))
      res.setVariantType(parseCodeableConcept(json.getAsJsonObject("variantType")));
    if (json.has("exact"))
      res.setExactElement(parseBoolean(json.get("exact").getAsBoolean()));
    if (json.has("_exact"))
      parseElementProperties(json.getAsJsonObject("_exact"), res.getExactElement());
    if (json.has("length"))
      res.setLengthElement(parseInteger(json.get("length").getAsLong()));
    if (json.has("_length"))
      parseElementProperties(json.getAsJsonObject("_length"), res.getLengthElement());
    if (json.has("outer"))
      res.setOuter(parseMolecularSequenceStructureVariantOuterComponent(json.getAsJsonObject("outer")));
    if (json.has("inner"))
      res.setInner(parseMolecularSequenceStructureVariantInnerComponent(json.getAsJsonObject("inner")));
  }

  protected MolecularSequence.MolecularSequenceStructureVariantOuterComponent parseMolecularSequenceStructureVariantOuterComponent(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantOuterComponent res = new MolecularSequence.MolecularSequenceStructureVariantOuterComponent();
    parseMolecularSequenceStructureVariantOuterComponentProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceStructureVariantOuterComponentProperties(JsonObject json, MolecularSequence.MolecularSequenceStructureVariantOuterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
  }

  protected MolecularSequence.MolecularSequenceStructureVariantInnerComponent parseMolecularSequenceStructureVariantInnerComponent(JsonObject json) throws IOException, FHIRFormatError {
    MolecularSequence.MolecularSequenceStructureVariantInnerComponent res = new MolecularSequence.MolecularSequenceStructureVariantInnerComponent();
    parseMolecularSequenceStructureVariantInnerComponentProperties(json, res);
    return res;
  }

  protected void parseMolecularSequenceStructureVariantInnerComponentProperties(JsonObject json, MolecularSequence.MolecularSequenceStructureVariantInnerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseInteger(json.get("start").getAsLong()));
    if (json.has("_start"))
      parseElementProperties(json.getAsJsonObject("_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInteger(json.get("end").getAsLong()));
    if (json.has("_end"))
      parseElementProperties(json.getAsJsonObject("_end"), res.getEndElement());
  }

  protected NamingSystem parseNamingSystem(JsonObject json) throws IOException, FHIRFormatError {
    NamingSystem res = new NamingSystem();
    parseNamingSystemProperties(json, res);
    return res;
  }

  protected void parseNamingSystemProperties(JsonObject json, NamingSystem res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(json.getAsJsonObject("_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(json.getAsJsonObject("_version"), res.getVersionElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(json.getAsJsonObject("_name"), res.getNameElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(json.getAsJsonObject("_kind"), res.getKindElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(json.getAsJsonObject("_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(json.getAsJsonObject("_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = json.getAsJsonArray("contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("responsible"))
      res.setResponsibleElement(parseString(json.get("responsible").getAsString()));
    if (json.has("_responsible"))
      parseElementProperties(json.getAsJsonObject("_responsible"), res.getResponsibleElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(json.getAsJsonObject("_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = json.getAsJsonArray("useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = json.getAsJsonArray("jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("usage"))
      res.setUsageElement(parseString(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(json.getAsJsonObject("_usage"), res.getUsageElement());
    if (json.has("uniqueId")) {
      JsonArray array = json.getAsJsonArray("uniqueId");
      for (int i = 0; i < array.size(); i++) {
        res.getUniqueId().add(parseNamingSystemUniqueIdComponent(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemUniqueIdComponent(JsonObject json) throws IOException, FHIRFormatError {
    NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
    parseNamingSystemUniqueIdComponentProperties(json, res);
    return res;
  }

  protected void parseNamingSystemUniqueIdComponentProperties(JsonObject json, NamingSystem.NamingSystemUniqueIdComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(json.getAsJsonObject("_type"), res.getTypeElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(json.getAsJsonObject("_value"), res.getValueElement());
    if (json.has("preferred"))
      res.setPreferredElement(parseBoolean(json.get("preferred").getAsBoolean()));
    if (json.has("_preferred"))
      parseElementProperties(json.getAsJsonObject("_preferred"), res.getPreferredElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(json.getAsJsonObject("_comment"), res.getCommentElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(json.getAsJsonObject("period")));
  }

  protected NutritionIntake parseNutritionIntake(JsonObject json) throws IOException, FHIRFormatError {
    NutritionIntake res = new NutritionIntake();
    parseNutritionIntakeProperties(json, res);
    return res;
  }

  protected void parseNutritionIntakeProperties(JsonObject json, NutritionIntake res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), NutritionIntake.NutritionIntakeStatusCodes.NULL, new NutritionIntake.NutritionIntakeStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("statusReason")) {
      JsonArray array = json.getAsJsonArray("statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("consumedItem")) {
      JsonArray array = json.getAsJsonArray("consumedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getConsumedItem().add(parseNutritionIntakeConsumedItemComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("ingredientLabel")) {
      JsonArray array = json.getAsJsonArray("ingredientLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredientLabel().add(parseNutritionIntakeIngredientLabelComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("dateAsserted"))
      res.setDateAssertedElement(parseDateTime(json.get("dateAsserted").getAsString()));
    if (json.has("_dateAsserted"))
      parseElementProperties(json.getAsJsonObject("_dateAsserted"), res.getDateAssertedElement());
    if (json.has("informationSource"))
      res.setInformationSource(parseReference(json.getAsJsonObject("informationSource")));
    if (json.has("derivedFrom")) {
      JsonArray array = json.getAsJsonArray("derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("reasonCode")) {
      JsonArray array = json.getAsJsonArray("reasonCode");
      for (int i = 0; i < array.size(); i++) {
        res.getReasonCode().add(parseCodeableReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected NutritionIntake.NutritionIntakeConsumedItemComponent parseNutritionIntakeConsumedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    NutritionIntake.NutritionIntakeConsumedItemComponent res = new NutritionIntake.NutritionIntakeConsumedItemComponent();
    parseNutritionIntakeConsumedItemComponentProperties(json, res);
    return res;
  }

  protected void parseNutritionIntakeConsumedItemComponentProperties(JsonObject json, NutritionIntake.NutritionIntakeConsumedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("nutritionProduct"))
      res.setNutritionProduct(parseCodeableConcept(json.getAsJsonObject("nutritionProduct")));
    if (json.has("schedule"))
      res.setSchedule(parseTiming(json.getAsJsonObject("schedule")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(json.getAsJsonObject("amount")));
    if (json.has("rate"))
      res.setRate(parseQuantity(json.getAsJsonObject("rate")));
    if (json.has("notConsumed"))
      res.setNotConsumedElement(parseBoolean(json.get("notConsumed").getAsBoolean()));
    if (json.has("_notConsumed"))
      parseElementProperties(json.getAsJsonObject("_notConsumed"), res.getNotConsumedElement());
    if (json.has("notConsumedReason"))
      res.setNotConsumedReason(parseCodeableConcept(json.getAsJsonObject("notConsumedReason")));
  }

  protected NutritionIntake.NutritionIntakeIngredientLabelComponent parseNutritionIntakeIngredientLabelComponent(JsonObject json) throws IOException, FHIRFormatError {
    NutritionIntake.NutritionIntakeIngredientLabelComponent res = new NutritionIntake.NutritionIntakeIngredientLabelComponent();
    parseNutritionIntakeIngredientLabelComponentProperties(json, res);
    return res;
  }

  protected void parseNutritionIntakeIngredientLabelComponentProperties(JsonObject json, NutritionIntake.NutritionIntakeIngredientLabelComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("nutrient"))
      res.setNutrient(parseCodeableConcept(json.getAsJsonObject("nutrient")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(json.getAsJsonObject("amount")));
  }

  protected NutritionOrder parseNutritionOrder(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder res = new NutritionOrder();
    parseNutritionOrderProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderProperties(JsonObject json, NutritionOrder res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = json.getAsJsonArray("_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = json.getAsJsonArray("_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("instantiates")) {
      JsonArray array = json.getAsJsonArray("instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiates().add(new UriType());
        } else {;
          res.getInstantiates().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = json.getAsJsonArray("_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(array.get(i).getAsJsonObject(), res.getInstantiates().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(json.getAsJsonObject("_intent"), res.getIntentElement());
    if (json.has("patient"))
      res.setPatient(parseReference(json.getAsJsonObject("patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    if (json.has("dateTime"))
      res.setDateTimeElement(parseDateTime(json.get("dateTime").getAsString()));
    if (json.has("_dateTime"))
      parseElementProperties(json.getAsJsonObject("_dateTime"), res.getDateTimeElement());
    if (json.has("orderer"))
      res.setOrderer(parseReference(json.getAsJsonObject("orderer")));
    if (json.has("allergyIntolerance")) {
      JsonArray array = json.getAsJsonArray("allergyIntolerance");
      for (int i = 0; i < array.size(); i++) {
        res.getAllergyIntolerance().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("foodPreferenceModifier")) {
      JsonArray array = json.getAsJsonArray("foodPreferenceModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getFoodPreferenceModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("excludeFoodModifier")) {
      JsonArray array = json.getAsJsonArray("excludeFoodModifier");
      for (int i = 0; i < array.size(); i++) {
        res.getExcludeFoodModifier().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("oralDiet"))
      res.setOralDiet(parseNutritionOrderOralDietComponent(json.getAsJsonObject("oralDiet")));
    if (json.has("supplement")) {
      JsonArray array = json.getAsJsonArray("supplement");
      for (int i = 0; i < array.size(); i++) {
        res.getSupplement().add(parseNutritionOrderSupplementComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("enteralFormula"))
      res.setEnteralFormula(parseNutritionOrderEnteralFormulaComponent(json.getAsJsonObject("enteralFormula")));
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
  }

  protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderOralDietComponent(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
    parseNutritionOrderOralDietComponentProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderOralDietComponentProperties(JsonObject json, NutritionOrder.NutritionOrderOralDietComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = json.getAsJsonArray("type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("nutrient")) {
      JsonArray array = json.getAsJsonArray("nutrient");
      for (int i = 0; i < array.size(); i++) {
        res.getNutrient().add(parseNutritionOrderOralDietNutrientComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("texture")) {
      JsonArray array = json.getAsJsonArray("texture");
      for (int i = 0; i < array.size(); i++) {
        res.getTexture().add(parseNutritionOrderOralDietTextureComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("fluidConsistencyType")) {
      JsonArray array = json.getAsJsonArray("fluidConsistencyType");
      for (int i = 0; i < array.size(); i++) {
        res.getFluidConsistencyType().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
  }

  protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderOralDietNutrientComponent(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
    parseNutritionOrderOralDietNutrientComponentProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderOralDietNutrientComponentProperties(JsonObject json, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(json.getAsJsonObject("modifier")));
    if (json.has("amount"))
      res.setAmount(parseQuantity(json.getAsJsonObject("amount")));
  }

  protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderOralDietTextureComponent(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
    parseNutritionOrderOralDietTextureComponentProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderOralDietTextureComponentProperties(JsonObject json, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("modifier"))
      res.setModifier(parseCodeableConcept(json.getAsJsonObject("modifier")));
    if (json.has("foodType"))
      res.setFoodType(parseCodeableConcept(json.getAsJsonObject("foodType")));
  }

  protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderSupplementComponent(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
    parseNutritionOrderSupplementComponentProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderSupplementComponentProperties(JsonObject json, NutritionOrder.NutritionOrderSupplementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(json.getAsJsonObject("type")));
    if (json.has("productName"))
      res.setProductNameElement(parseString(json.get("productName").getAsString()));
    if (json.has("_productName"))
      parseElementProperties(json.getAsJsonObject("_productName"), res.getProductNameElement());
    if (json.has("schedule")) {
      JsonArray array = json.getAsJsonArray("schedule");
      for (int i = 0; i < array.size(); i++) {
        res.getSchedule().add(parseTiming(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    if (json.has("instruction"))
      res.setInstructionElement(parseString(json.get("instruction").getAsString()));
    if (json.has("_instruction"))
      parseElementProperties(json.getAsJsonObject("_instruction"), res.getInstructionElement());
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderEnteralFormulaComponent(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
    parseNutritionOrderEnteralFormulaComponentProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderEnteralFormulaComponentProperties(JsonObject json, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("baseFormulaType"))
      res.setBaseFormulaType(parseCodeableConcept(json.getAsJsonObject("baseFormulaType")));
    if (json.has("baseFormulaProductName"))
      res.setBaseFormulaProductNameElement(parseString(json.get("baseFormulaProductName").getAsString()));
    if (json.has("_baseFormulaProductName"))
      parseElementProperties(json.getAsJsonObject("_baseFormulaProductName"), res.getBaseFormulaProductNameElement());
    if (json.has("additiveType"))
      res.setAdditiveType(parseCodeableConcept(json.getAsJsonObject("additiveType")));
    if (json.has("additiveProductName"))
      res.setAdditiveProductNameElement(parseString(json.get("additiveProductName").getAsString()));
    if (json.has("_additiveProductName"))
      parseElementProperties(json.getAsJsonObject("_additiveProductName"), res.getAdditiveProductNameElement());
    if (json.has("caloricDensity"))
      res.setCaloricDensity(parseQuantity(json.getAsJsonObject("caloricDensity")));
    if (json.has("routeofAdministration"))
      res.setRouteofAdministration(parseCodeableConcept(json.getAsJsonObject("routeofAdministration")));
    if (json.has("administration")) {
      JsonArray array = json.getAsJsonArray("administration");
      for (int i = 0; i < array.size(); i++) {
        res.getAdministration().add(parseNutritionOrderEnteralFormulaAdministrationComponent(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("maxVolumeToDeliver"))
      res.setMaxVolumeToDeliver(parseQuantity(json.getAsJsonObject("maxVolumeToDeliver")));
    if (json.has("administrationInstruction"))
      res.setAdministrationInstructionElement(parseString(json.get("administrationInstruction").getAsString()));
    if (json.has("_administrationInstruction"))
      parseElementProperties(json.getAsJsonObject("_administrationInstruction"), res.getAdministrationInstructionElement());
  }

  protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderEnteralFormulaAdministrationComponent(JsonObject json) throws IOException, FHIRFormatError {
    NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
    parseNutritionOrderEnteralFormulaAdministrationComponentProperties(json, res);
    return res;
  }

  protected void parseNutritionOrderEnteralFormulaAdministrationComponentProperties(JsonObject json, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("schedule"))
      res.setSchedule(parseTiming(json.getAsJsonObject("schedule")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(json.getAsJsonObject("quantity")));
    DataType rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected Observation parseObservation(JsonObject json) throws IOException, FHIRFormatError {
    Observation res = new Observation();
    parseObservationProperties(json, res);
    return res;
  }

  protected void parseObservationProperties(JsonObject json, Observation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = json.getAsJsonArray("identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = json.getAsJsonArray("basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = json.getAsJsonArray("partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.ObservationStatus.NULL, new Enumerations.ObservationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(json.getAsJsonObject("_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = json.getAsJsonArray("category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(json.getAsJsonObject("code")));
    if (json.has("subject"))
      res.setSubject(parseReference(json.getAsJsonObject("subject")));
    if (json.has("focus")) {
      JsonArray array = json.getAsJsonArray("focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(json.getAsJsonObject("encounter")));
    DataType effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(json.getAsJsonObject("_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = json.getAsJsonArray("performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(array.get(i).getAsJsonObject()));
      }
    };
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(json.getAsJsonObject("dataAbsentReason")));
    if (json.has("interpretation")) {
      JsonArray array = json.getAsJsonArray("interpretation");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpretation().add(parseCodeableConcept(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("note")) {
      JsonArray array = json.getAsJsonArray("note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(array.get(i).getAsJsonObject()));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(json.getAsJsonObject("bodySite")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(json.getAsJsonObject("method")));
    if (json.has("specimen"))
      res.setSpecimen(parseReference(json.getAsJsonObject("specime