package org.hl7.fhir.r5.extensions;

import org.hl7.fhir.utilities.Utilities;

// generated

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Thu, Mar 23, 2023 19:59+1100 for FHIR v5.0.0



public class ExtensionConstants {
  
  public static final String EXT_CAPABILITIES = "http://fhir-registry.smarthealthit.org/StructureDefinition/capabilities"; // Capabilities
  public static final String EXT_OAUTH_URIS = "http://fhir-registry.smarthealthit.org/StructureDefinition/oauth-uris"; // OAuth URIs
  public static final String EXT_OBJECT_CLASS = "http://hl7.org/fhir/StructureDefinition/11179-objectClass"; // object class
  public static final String EXT_OBJECT_CLASS_PROPERTY = "http://hl7.org/fhir/StructureDefinition/11179-objectClassProperty"; // object class property
  public static final String EXT_PERMITTED_VALUE_CONCEPTMAP = "http://hl7.org/fhir/StructureDefinition/11179-permitted-value-conceptmap"; // Permitted Value Conceptmap
  public static final String EXT_PERMITTED_VALUE_VALUESET = "http://hl7.org/fhir/StructureDefinition/11179-permitted-value-valueset"; // Permitted Value Valueset
  public static final String EXT_DATATYPE = "http://hl7.org/fhir/StructureDefinition/_datatype"; // Datatype
  public static final String EXT_ADDITIONAL_IDENTIFIER = "http://hl7.org/fhir/StructureDefinition/additionalIdentifier"; // additional identifier
  public static final String EXT_ABATEMENT = "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement"; // Abatement
  public static final String EXT_AIASSERTED_DATE = "http://hl7.org/fhir/StructureDefinition/allergyintolerance-assertedDate"; // AllergyIntolerance AssertedDate
  public static final String EXT_AICERTAINTY = "http://hl7.org/fhir/StructureDefinition/allergyintolerance-certainty"; // AllergyIntolerance Certainty
  public static final String EXT_AIDURATION = "http://hl7.org/fhir/StructureDefinition/allergyintolerance-duration"; // AllergyIntolerance Duration
  public static final String EXT_AIREASON_REFUTED = "http://hl7.org/fhir/StructureDefinition/allergyintolerance-reasonRefuted"; // AllergyIntolerance Reason Refuted
  public static final String EXT_AIRESOLUTION_AGE = "http://hl7.org/fhir/StructureDefinition/allergyintolerance-resolutionAge"; // AllergyIntolerance Resolution Age
  public static final String EXT_AISUBSTANCE_EXPOSURE_RISK = "http://hl7.org/fhir/StructureDefinition/allergyintolerance-substanceExposureRisk"; // AllergyIntolerance Substance Exposure Risk
  public static final String EXT_ALTERNATE_CANONICAL = "http://hl7.org/fhir/StructureDefinition/alternate-canonical"; // Alternate Canonical
  public static final String EXT_ALTERNATE_CODES = "http://hl7.org/fhir/StructureDefinition/alternate-codes"; // Alternate Codes
  public static final String EXT_ALTERNATE_REFERENCE = "http://hl7.org/fhir/StructureDefinition/alternate-reference"; // Alternate Reference
  public static final String EXT_ARTIFACT_AUTHOR = "http://hl7.org/fhir/StructureDefinition/artifact-author"; // Artifact Author
  public static final String EXT_ARTIFACT_CONTACT = "http://hl7.org/fhir/StructureDefinition/artifact-contact"; // Artifact Contact
  public static final String EXT_CONTACT_DETAIL_REFERENCE = "http://hl7.org/fhir/StructureDefinition/artifact-contactDetailReference"; // contact detail reference
  public static final String EXT_ARTIFACT_COPYRIGHT = "http://hl7.org/fhir/StructureDefinition/artifact-copyright"; // Artifact Copyright
  public static final String EXT_ARTIFACT_COPYRIGHT_LABEL = "http://hl7.org/fhir/StructureDefinition/artifact-copyrightLabel"; // Artifact Copyright Label
  public static final String EXT_ARTIFACT_DATE = "http://hl7.org/fhir/StructureDefinition/artifact-date"; // Artifact Date
  public static final String EXT_ARTIFACT_DESCRIPTION = "http://hl7.org/fhir/StructureDefinition/artifact-description"; // Artifact Description
  public static final String EXT_ARTIFACT_EDITOR = "http://hl7.org/fhir/StructureDefinition/artifact-editor"; // Artifact Editor
  public static final String EXT_ARTIFACT_ENDORSER = "http://hl7.org/fhir/StructureDefinition/artifact-endorser"; // Artifact Endorser
  public static final String EXT_ARTIFACT_EXPERIMENTAL = "http://hl7.org/fhir/StructureDefinition/artifact-experimental"; // Artifact Experimental
  public static final String EXT_ARTIFACT_IDENTIFIER = "http://hl7.org/fhir/StructureDefinition/artifact-identifier"; // Artifact Identifier
  public static final String EXT_ARTIFACT_JURISDICTION = "http://hl7.org/fhir/StructureDefinition/artifact-jurisdiction"; // Artifact Jurisdiction
  public static final String EXT_KNOWLEDGE_CAPABILITY = "http://hl7.org/fhir/StructureDefinition/artifact-knowledgeCapability"; // knowledge capability
  public static final String EXT_KNOWLEDGE_REPRESENTATION_LEVEL = "http://hl7.org/fhir/StructureDefinition/artifact-knowledgeRepresentationLevel"; // knowledge representation level
  public static final String EXT_ARTIFACT_NAME = "http://hl7.org/fhir/StructureDefinition/artifact-name"; // ArtifactName
  public static final String EXT_PERIOD_DURATION = "http://hl7.org/fhir/StructureDefinition/artifact-periodDuration"; // period duration
  public static final String EXT_ARTIFACT_PUBLISHER = "http://hl7.org/fhir/StructureDefinition/artifact-publisher"; // Artifact Publisher
  public static final String EXT_ARTIFACT_PURPOSE = "http://hl7.org/fhir/StructureDefinition/artifact-purpose"; // Artifact Purpose
  public static final String EXT_ARTIFACT_RELATED_ARTIFACT = "http://hl7.org/fhir/StructureDefinition/artifact-relatedArtifact"; // Artifact related artifact
  public static final String EXT_ARTIFACT_REVIEWER = "http://hl7.org/fhir/StructureDefinition/artifact-reviewer"; // Artifact Reviewer
  public static final String EXT_ARTIFACT_STATUS = "http://hl7.org/fhir/StructureDefinition/artifact-status"; // Artifact Status
  public static final String EXT_ARTIFACT_TITLE = "http://hl7.org/fhir/StructureDefinition/artifact-title"; // Artifact Title
  public static final String EXT_ARTIFACT_TOPIC = "http://hl7.org/fhir/StructureDefinition/artifact-topic"; // Artifact Topic
  public static final String EXT_ARTIFACT_URL = "http://hl7.org/fhir/StructureDefinition/artifact-url"; // Artifact URL
  public static final String EXT_ARTIFACT_USE_CONTEXT = "http://hl7.org/fhir/StructureDefinition/artifact-useContext"; // Artifact use context
  public static final String EXT_ARTIFACT_VERSION = "http://hl7.org/fhir/StructureDefinition/artifact-version"; // ArtifactVersion
  public static final String EXT_ARTIFACT_VERSION_ALGORITHM = "http://hl7.org/fhir/StructureDefinition/artifact-versionAlgorithm"; // Artifact Version Algorithm
  public static final String EXT_AEACCESSION = "http://hl7.org/fhir/StructureDefinition/auditevent-Accession"; // AuditEvent Accession
  public static final String EXT_AEALTERNATIVE_USER_I_D = "http://hl7.org/fhir/StructureDefinition/auditevent-AlternativeUserID"; // AuditEvent Alternative User ID
  public static final String EXT_AEANONYMIZED = "http://hl7.org/fhir/StructureDefinition/auditevent-Anonymized"; // AuditEvent Anonymized
  public static final String EXT_AEENCRYPTED = "http://hl7.org/fhir/StructureDefinition/auditevent-Encrypted"; // AuditEvent Encrypted
  public static final String EXT_AEINSTANCE = "http://hl7.org/fhir/StructureDefinition/auditevent-Instance"; // AuditEvent Instance
  public static final String EXT_AELIFECYCLE = "http://hl7.org/fhir/StructureDefinition/auditevent-Lifecycle"; // AuditEvent Lifecycle
  public static final String EXT_AEMPPS = "http://hl7.org/fhir/StructureDefinition/auditevent-MPPS"; // AuditEvent MPPS
  public static final String EXT_AENUMBER_OF_INSTANCES = "http://hl7.org/fhir/StructureDefinition/auditevent-NumberOfInstances"; // AuditEvent Number Of Instances
  public static final String EXT_AEPARTICIPANT_OBJECT_CONTAINS_STUDY = "http://hl7.org/fhir/StructureDefinition/auditevent-ParticipantObjectContainsStudy"; // AuditEvent Participant Object Contains Study
  public static final String EXT_AESOPCLASS = "http://hl7.org/fhir/StructureDefinition/auditevent-SOPClass"; // AuditEvent SOPClass
  public static final String EXT_BDPCOLLECTION_PROCEDURE = "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-collection-procedure"; // BiologicallyDerivedProduct Collection Procedure
  public static final String EXT_BDPMANIPULATION = "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-manipulation"; // BiologicallyDerivedProduct Manipulation
  public static final String EXT_BDPPROCESSING = "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-processing"; // BiologicallyDerivedProduct Processing
  public static final String EXT_BODY_STRUCTURE_REFERENCE = "http://hl7.org/fhir/StructureDefinition/bodySite"; // BodyStructure Reference
  public static final String EXT_CRSHORT_DESCRIPTION = "http://hl7.org/fhir/StructureDefinition/canonicalresource-short-description"; // CanonicalResource Short Description
  public static final String EXT_CSDECLARED_PROFILE = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-declared-profile"; // CapabilityStatement Declared Profile
  public static final String EXT_CSEXPECTATION = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation"; // CapabilityStatement Expectation
  public static final String EXT_CSPROHIBITED = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-prohibited"; // CapabilityStatement Prohibition
  public static final String EXT_CSSEARCH_MODE = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-mode"; // CapabilityStatement Search Mode
  public static final String EXT_CSSEARCH_PARAMETER_COMBINATION = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"; // CapabilityStatement Search Parameter Combination
  public static final String EXT_CSSEARCH_PARAMETER_USE = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-use"; // CapabilityStatement Search Parameter Use
  public static final String EXT_CSSUPPORTED_SYSTEM = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-supported-system"; // CapabilityStatement Supported CodeSystem
  public static final String EXT_CSWEBSOCKET = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-websocket"; // CapabilityStatement WebSocket
  public static final String EXT_CPACTIVITY_TITLE = "http://hl7.org/fhir/StructureDefinition/careplan-activity-title"; // CarePlan Activity Title
  public static final String EXT_CTALIAS = "http://hl7.org/fhir/StructureDefinition/careteam-alias"; // CareTeam Alias
  public static final String EXT_CHARACTERISTIC_EXPRESSION = "http://hl7.org/fhir/StructureDefinition/characteristicExpression"; // Characteristic Expression
  public static final String EXT_CSALTERNATE = "http://hl7.org/fhir/StructureDefinition/codesystem-alternate"; // CodeSystem Alternate
  public static final String EXT_CSAUTHORITATIVE_SOURCE = "http://hl7.org/fhir/StructureDefinition/codesystem-authoritativeSource"; // CodeSystem Authoritative Source
  public static final String EXT_CSCONCEPT_COMMENTS = "http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments"; // CodeSystem Concept Comment
  public static final String EXT_CSCONCEPT_ORDER = "http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder"; // CodeSystem ConceptOrder
  public static final String EXT_CSHISTORY = "http://hl7.org/fhir/StructureDefinition/codesystem-history"; // CodeSystem History
  public static final String EXT_CSKEY_WORD = "http://hl7.org/fhir/StructureDefinition/codesystem-keyWord"; // CodeSystem KeyWord
  public static final String EXT_CSLABEL = "http://hl7.org/fhir/StructureDefinition/codesystem-label"; // CodeSystem Label
  public static final String EXT_CSMAP = "http://hl7.org/fhir/StructureDefinition/codesystem-map"; // CodeSystem Map
  public static final String EXT_CSOTHER_NAME = "http://hl7.org/fhir/StructureDefinition/codesystem-otherName"; // CodeSystem Other Name
  public static final String EXT_CSPROPERTIES_MODE = "http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode"; // CodeSystem Properties Mode
  public static final String EXT_CSREPLACEDBY = "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby"; // CodeSystem Replacedby
  public static final String EXT_CSSOURCE_REFERENCE = "http://hl7.org/fhir/StructureDefinition/codesystem-sourceReference"; // CodeSystem Source Reference
  public static final String EXT_CSTRUSTED_EXPANSION = "http://hl7.org/fhir/StructureDefinition/codesystem-trusted-expansion"; // CodeSystem Trusted Expansion
  public static final String EXT_CSUSAGE = "http://hl7.org/fhir/StructureDefinition/codesystem-usage"; // CodeSystem Usage
  public static final String EXT_CSUSE_MARKDOWN = "http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown"; // CodeSystem Use Markdown
  public static final String EXT_CSWARNING = "http://hl7.org/fhir/StructureDefinition/codesystem-warning"; // CodeSystem Warning
  public static final String EXT_CSWORKFLOW_STATUS = "http://hl7.org/fhir/StructureDefinition/codesystem-workflowStatus"; // CodeSystem Workflow Status
  public static final String EXT_CODING_CONFORMANCE = "http://hl7.org/fhir/StructureDefinition/coding-conformance"; // Coding Conformance
  public static final String EXT_CODING_PURPOSE = "http://hl7.org/fhir/StructureDefinition/coding-purpose"; // Coding Purpose
  public static final String EXT_SCTDESCID = "http://hl7.org/fhir/StructureDefinition/coding-sctdescid"; // SNOMED CT Description Id
  public static final String EXT_CMEDIA = "http://hl7.org/fhir/StructureDefinition/communication-media"; // Communication Media
  public static final String EXT_CRINITIATING_LOCATION = "http://hl7.org/fhir/StructureDefinition/communicationrequest-initiatingLocation"; // CommunicationRequest Initiating Location
  public static final String EXT_COTHER_CONFIDENTIALITY = "http://hl7.org/fhir/StructureDefinition/composition-clinicaldocument-otherConfidentiality"; // Composition Other Confidentiality
  public static final String EXT_CDVERSION_NUMBER = "http://hl7.org/fhir/StructureDefinition/composition-clinicaldocument-versionNumber"; // Composition Version Number
  public static final String EXT_CSECTION_SUBJECT = "http://hl7.org/fhir/StructureDefinition/composition-section-subject"; // Composition Section Subject
  public static final String EXT_CMBIDIRECTIONAL = "http://hl7.org/fhir/StructureDefinition/concept-bidirectional"; // ConceptMap Bi-directional
  public static final String EXT_CONDITION_ASSERTED_DATE = "http://hl7.org/fhir/StructureDefinition/condition-assertedDate"; // Condition Asserted Date
  public static final String EXT_CONDITION_DISEASE_COURSE = "http://hl7.org/fhir/StructureDefinition/condition-diseaseCourse"; // Condition Disease Course
  public static final String EXT_CONDITION_DUE_TO = "http://hl7.org/fhir/StructureDefinition/condition-dueTo"; // Condition Due To
  public static final String EXT_CONDITION_OCCURRED_FOLLOWING = "http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing"; // Condition Occurred Following
  public static final String EXT_CONDITION_OUTCOME = "http://hl7.org/fhir/StructureDefinition/condition-outcome"; // Condition Outcome
  public static final String EXT_CONDITION_RELATED = "http://hl7.org/fhir/StructureDefinition/condition-related"; // Condition Related
  public static final String EXT_CONDITION_REVIEWED = "http://hl7.org/fhir/StructureDefinition/condition-reviewed"; // Condition Reviewed
  public static final String EXT_CONDITION_RULED_OUT = "http://hl7.org/fhir/StructureDefinition/condition-ruledOut"; // Condition Ruled Out
  public static final String EXT_CONSENT_NOTIFICATION_ENDPOINT = "http://hl7.org/fhir/StructureDefinition/consent-NotificationEndpoint"; // Consent Disclosure Notification Endpoint
  public static final String EXT_CONSENT_RESEARCH_STUDY_CONTEXT = "http://hl7.org/fhir/StructureDefinition/consent-ResearchStudyContext"; // Consent Research Study Context
  public static final String EXT_CONSENT_TRANSCRIBER = "http://hl7.org/fhir/StructureDefinition/consent-Transcriber"; // Consent Transcriber
  public static final String EXT_CONSENT_WITNESS = "http://hl7.org/fhir/StructureDefinition/consent-Witness"; // Consent Witness
  public static final String EXT_CONSENT_LOCATION = "http://hl7.org/fhir/StructureDefinition/consent-location"; // Consent Location of Access restriction
  public static final String EXT_CONTACT_POINT_AREA = "http://hl7.org/fhir/StructureDefinition/contactpoint-area"; // ContactPoint Area
  public static final String EXT_CONTACT_POINT_COMMENT = "http://hl7.org/fhir/StructureDefinition/contactpoint-comment"; // ContactPoint Comment
  public static final String EXT_CONTACT_POINT_COUNTRY = "http://hl7.org/fhir/StructureDefinition/contactpoint-country"; // ContactPoint Country
  public static final String EXT_CONTACT_POINT_EXTENSION = "http://hl7.org/fhir/StructureDefinition/contactpoint-extension"; // ContactPoint Extension
  public static final String EXT_CONTACT_POINT_LOCAL = "http://hl7.org/fhir/StructureDefinition/contactpoint-local"; // ContactPoint Local
  public static final String EXT_ALTERNATIVE_EXPRESSION = "http://hl7.org/fhir/StructureDefinition/cqf-alternativeExpression"; // Alternative expression
  public static final String EXT_ARTIFACT_COMMENT = "http://hl7.org/fhir/StructureDefinition/cqf-artifactComment"; // artifact comment
  public static final String EXT_CALCULATED_VALUE = "http://hl7.org/fhir/StructureDefinition/cqf-calculatedValue"; // calculated value
  public static final String EXT_CDS_HOOKS_ENDPOINT = "http://hl7.org/fhir/StructureDefinition/cqf-cdsHooksEndpoint"; // cds hooks endpoint
  public static final String EXT_CQFCERTAINTY = "http://hl7.org/fhir/StructureDefinition/cqf-certainty"; // CQF Certainty
  public static final String EXT_CQFCITATION = "http://hl7.org/fhir/StructureDefinition/cqf-citation"; // CQF Citation
  public static final String EXT_CONTACT_ADDRESS = "http://hl7.org/fhir/StructureDefinition/cqf-contactAddress"; // Contact address
  public static final String EXT_CONTACT_REFERENCE = "http://hl7.org/fhir/StructureDefinition/cqf-contactReference"; // Contact Reference
  public static final String EXT_CONTRIBUTION_TIME = "http://hl7.org/fhir/StructureDefinition/cqf-contributionTime"; // Contribution time
  public static final String EXT_CQFCQLOPTIONS = "http://hl7.org/fhir/StructureDefinition/cqf-cqlOptions"; // CQF CQL Options
  public static final String EXT_DIRECT_REFERENCE_CODE = "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode"; // direct reference code
  public static final String EXT_ENCOUNTER_CLASS = "http://hl7.org/fhir/StructureDefinition/cqf-encounterClass"; // encounter class
  public static final String EXT_ENCOUNTER_TYPE = "http://hl7.org/fhir/StructureDefinition/cqf-encounterType"; // encounter type
  public static final String EXT_CQFEXPRESSION = "http://hl7.org/fhir/StructureDefinition/cqf-expression"; // CQF Expression
  public static final String EXT_INITIAL_VALUE = "http://hl7.org/fhir/StructureDefinition/cqf-initialValue"; // initial value
  public static final String EXT_INITIATING_ORGANIZATION = "http://hl7.org/fhir/StructureDefinition/cqf-initiatingOrganization"; // initiating organization
  public static final String EXT_INITIATING_PERSON = "http://hl7.org/fhir/StructureDefinition/cqf-initiatingPerson"; // initiating person
  public static final String EXT_INPUT_PARAMETERS = "http://hl7.org/fhir/StructureDefinition/cqf-inputParameters"; // input parameters
  public static final String EXT_IS_PREFETCH_TOKEN = "http://hl7.org/fhir/StructureDefinition/cqf-isPrefetchToken"; // Is prefetch token
  public static final String EXT_CQFKNOWLEDGE_CAPABILITY = "http://hl7.org/fhir/StructureDefinition/cqf-knowledgeCapability"; // knowledge capability
  public static final String EXT_CQFKNOWLEDGE_REPRESENTATION_LEVEL = "http://hl7.org/fhir/StructureDefinition/cqf-knowledgeRepresentationLevel"; // knowledge representation level
  public static final String EXT_CQFLIBRARY = "http://hl7.org/fhir/StructureDefinition/cqf-library"; // CQF Library
  public static final String EXT_LOGIC_DEFINITION = "http://hl7.org/fhir/StructureDefinition/cqf-logicDefinition"; // logic definition
  public static final String EXT_MEASURE_INFO = "http://hl7.org/fhir/StructureDefinition/cqf-measureInfo"; // measure info
  public static final String EXT_PARAMETER_DEFINITION = "http://hl7.org/fhir/StructureDefinition/cqf-parameterDefinition"; // Parameter definition
  public static final String EXT_QUALITY_OF_EVIDENCE = "http://hl7.org/fhir/StructureDefinition/cqf-qualityOfEvidence"; // quality of evidence
  public static final String EXT_RECEIVING_ORGANIZATION = "http://hl7.org/fhir/StructureDefinition/cqf-receivingOrganization"; // receiving organization
  public static final String EXT_RECEIVING_PERSON = "http://hl7.org/fhir/StructureDefinition/cqf-receivingPerson"; // receiving person
  public static final String EXT_RECIPIENT_LANGUAGE = "http://hl7.org/fhir/StructureDefinition/cqf-recipientLanguage"; // recipient language
  public static final String EXT_RECIPIENT_TYPE = "http://hl7.org/fhir/StructureDefinition/cqf-recipientType"; // recipient type
  public static final String EXT_RELATIVE_DATE_TIME = "http://hl7.org/fhir/StructureDefinition/cqf-relativeDateTime"; // relative date time
  public static final String EXT_STRENGTH_OF_RECOMMENDATION = "http://hl7.org/fhir/StructureDefinition/cqf-strengthOfRecommendation"; // strength of recommendation
  public static final String EXT_SUPPORTED_CQL_VERSION = "http://hl7.org/fhir/StructureDefinition/cqf-supportedCqlVersion"; // supported cql version
  public static final String EXT_SYSTEM_USER_LANGUAGE = "http://hl7.org/fhir/StructureDefinition/cqf-systemUserLanguage"; // system user language
  public static final String EXT_SYSTEM_USER_TASK_CONTEXT = "http://hl7.org/fhir/StructureDefinition/cqf-systemUserTaskContext"; // system user task context
  public static final String EXT_SYSTEM_USER_TYPE = "http://hl7.org/fhir/StructureDefinition/cqf-systemUserType"; // system user type
  public static final String EXT_TARGET_INVARIANT = "http://hl7.org/fhir/StructureDefinition/cqf-targetInvariant"; // target invariant
  public static final String EXT_CVALIDITY_PERIOD = "http://hl7.org/fhir/StructureDefinition/cqm-ValidityPeriod"; // Composition Validity Period
  public static final String EXT_DATA_ABSENT_REASON = "http://hl7.org/fhir/StructureDefinition/data-absent-reason"; // Data Absent Reason
  public static final String EXT_RESOURCE_DERIVATION_REFERENCE = "http://hl7.org/fhir/StructureDefinition/derivation-reference"; // Resource Derivation Reference
  public static final String EXT_DESIGN_NOTE = "http://hl7.org/fhir/StructureDefinition/designNote"; // Design Note
  public static final String EXT_DEV_COMMERCIAL_BRAND = "http://hl7.org/fhir/StructureDefinition/device-commercialBrand"; // Device Commercial Brand
  public static final String EXT_DEV_IMPLANT_STATUS = "http://hl7.org/fhir/StructureDefinition/device-implantStatus"; // Device Implantable Status
  public static final String EXT_DRPATIENT_INSTRUCTION = "http://hl7.org/fhir/StructureDefinition/devicerequest-patientInstruction"; // DeviceRequest Patient Directions
  public static final String EXT_DRADDENDUM_OF = "http://hl7.org/fhir/StructureDefinition/diagnosticReport-addendumOf"; // DiagnosticReport Addendum Of
  public static final String EXT_DREXTENDS = "http://hl7.org/fhir/StructureDefinition/diagnosticReport-extends"; // DiagnosticReport Extends
  public static final String EXT_DRFOCUS = "http://hl7.org/fhir/StructureDefinition/diagnosticReport-focus"; // DiagnosticReport Delta
  public static final String EXT_DRLOCATION_PERFORMED = "http://hl7.org/fhir/StructureDefinition/diagnosticReport-locationPerformed"; // DiagnosticReport Location Performed
  public static final String EXT_DRREPLACES = "http://hl7.org/fhir/StructureDefinition/diagnosticReport-replaces"; // DiagnosticReport Replaces
  public static final String EXT_DRRISK = "http://hl7.org/fhir/StructureDefinition/diagnosticReport-risk"; // DiagnosticReport Risk
  public static final String EXT_DRSUMMARY_OF = "http://hl7.org/fhir/StructureDefinition/diagnosticReport-summaryOf"; // DocumentReference Summary Of
  public static final String EXT_DISPLAY_NAME = "http://hl7.org/fhir/StructureDefinition/display"; // Display Name
  public static final String EXT_DRSOURCEPATIENT = "http://hl7.org/fhir/StructureDefinition/documentreference-sourcepatient"; // DocumentReference Source Patient
  public static final String EXT_DRTHUMBNAIL = "http://hl7.org/fhir/StructureDefinition/documentreference-thumbnail"; // DocumentReference Thumbnail
  public static final String EXT_CONDITIONS = "http://hl7.org/fhir/StructureDefinition/dosage-conditions"; // Conditions
  public static final String EXT_ALLOWED_UNITS = "http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits"; // Allowed Units
  public static final String EXT_BEST_PRACTICE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice"; // Best Practice
  public static final String EXT_BEST_PRACTICE_EXPLANATION = "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice-explanation"; // Best Practice Explanation
  public static final String EXT_BINDING_NAME = "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName"; // Binding name
  public static final String EXT_CONCEPTMAP = "http://hl7.org/fhir/StructureDefinition/elementdefinition-conceptmap"; // Conceptmap
  public static final String EXT_DEFAULT_TYPE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype"; // Default Type
  public static final String EXT_EQUIVALENCE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-equivalence"; // Equivalence
  public static final String EXT_GRAPH_CONSTRAINT = "http://hl7.org/fhir/StructureDefinition/elementdefinition-graphConstraint"; // Graph constraint
  public static final String EXT_IDENTIFIER = "http://hl7.org/fhir/StructureDefinition/elementdefinition-identifier"; // Identifier
  public static final String EXT_INHERITED_EXTENSIBLE_VALUE_SET = "http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet"; // Inherited extensible value set
  public static final String EXT_IS_COMMON_BINDING = "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding"; // Is common binding
  public static final String EXT_MAX_VALUE_SET = "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet"; // Max value set
  public static final String EXT_MIN_VALUE_SET = "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet"; // Min value set
  public static final String EXT_NAMESPACE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"; // Namespace
  public static final String EXT_PATTERN = "http://hl7.org/fhir/StructureDefinition/elementdefinition-pattern"; // Pattern
  public static final String EXT_PROFILE_ELEMENT = "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element"; // Profile Element
  public static final String EXT_QUESTION = "http://hl7.org/fhir/StructureDefinition/elementdefinition-question"; // Question
  public static final String EXT_SELECTOR = "http://hl7.org/fhir/StructureDefinition/elementdefinition-selector"; // Selector
  public static final String EXT_SUPPRESS = "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress"; // Suppress
  public static final String EXT_TRANSLATABLE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable"; // Translatable
  public static final String EXT_TYPE_MUST_SUPPORT = "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"; // Type must support
  public static final String EXT_ENC_ASSOCIATED_ENCOUNTER = "http://hl7.org/fhir/StructureDefinition/encounter-associatedEncounter"; // Encounter Associated Encounter
  public static final String EXT_ENC_MODE_OF_ARRIVAL = "http://hl7.org/fhir/StructureDefinition/encounter-modeOfArrival"; // Encounter Mode Of Arrival
  public static final String EXT_ENC_REASON_CANCELLED = "http://hl7.org/fhir/StructureDefinition/encounter-reasonCancelled"; // Encounter Reason Cancelled
  public static final String EXT_ENTRY_FORMAT = "http://hl7.org/fhir/StructureDefinition/entryFormat"; // entry format
  public static final String EXT_BASED_ON = "http://hl7.org/fhir/StructureDefinition/event-basedOn"; // based on
  public static final String EXT_EVENT_HISTORY = "http://hl7.org/fhir/StructureDefinition/event-eventHistory"; // event history
  public static final String EXT_EVENT_LOCATION = "http://hl7.org/fhir/StructureDefinition/event-location"; // Event Location
  public static final String EXT_PART_OF = "http://hl7.org/fhir/StructureDefinition/event-partOf"; // part of
  public static final String EXT_PERFORMER_FUNCTION = "http://hl7.org/fhir/StructureDefinition/event-performerFunction"; // performer function
  public static final String EXT_EVENT_STATUS_REASON = "http://hl7.org/fhir/StructureDefinition/event-statusReason"; // status reason
  public static final String EXT_EXTENDED_CONTACT_AVAILABILITY = "http://hl7.org/fhir/StructureDefinition/extended-contact-availability"; // Extended Contact Availability
  public static final String EXT_QUANTITY_TRANSLATION = "http://hl7.org/fhir/StructureDefinition/extension-quantity-translation"; // Quantity Translation
  public static final String EXT_FMHOBSERVATION = "http://hl7.org/fhir/StructureDefinition/family-member-history-genetics-observation"; // FamilyMemberHistory Observation
  public static final String EXT_FMHPARENT = "http://hl7.org/fhir/StructureDefinition/family-member-history-genetics-parent"; // FamilyMemberHistory Parent
  public static final String EXT_FMHSIBLING = "http://hl7.org/fhir/StructureDefinition/family-member-history-genetics-sibling"; // FamilyMemberHistory Sibling
  public static final String EXT_FMHABATEMENT = "http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement"; // FamilyMemberHistory Abatement
  public static final String EXT_FMHPATIENT_RECORD = "http://hl7.org/fhir/StructureDefinition/familymemberhistory-patient-record"; // FamilyMemberHistory Patient Record
  public static final String EXT_FMHSEVERITY = "http://hl7.org/fhir/StructureDefinition/familymemberhistory-severity"; // FamilyMemberHistory Severity
  public static final String EXT_FMHTYPE = "http://hl7.org/fhir/StructureDefinition/familymemberhistory-type"; // FamilyMemberHistory Type
  public static final String EXT_FIRST_CREATED = "http://hl7.org/fhir/StructureDefinition/firstCreated"; // First created
  public static final String EXT_FLAG_DETAIL = "http://hl7.org/fhir/StructureDefinition/flag-detail"; // Flag details
  public static final String EXT_FLAG_PRIORITY = "http://hl7.org/fhir/StructureDefinition/flag-priority"; // Flag Priority
  public static final String EXT_GEOLOCATION = "http://hl7.org/fhir/StructureDefinition/geolocation"; // Geolocation
  public static final String EXT_GOAL_ACCEPTANCE = "http://hl7.org/fhir/StructureDefinition/goal-acceptance"; // Goal acceptance
  public static final String EXT_GOAL_REASON_REJECTED = "http://hl7.org/fhir/StructureDefinition/goal-reasonRejected"; // Goal Reason Rejected
  public static final String EXT_GOAL_RELATIONSHIP = "http://hl7.org/fhir/StructureDefinition/goal-relationship"; // Goal: Related Goal
  public static final String EXT_BUNDLE_HTTP_RESPONSE_HEADER = "http://hl7.org/fhir/StructureDefinition/http-response-header"; // Bundle HTTP Response header
  public static final String EXT_ASSEMBLY_ORDER = "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order"; // Assembly Order
  public static final String EXT_FATHERS_FAMILY = "http://hl7.org/fhir/StructureDefinition/humanname-fathers-family"; // Fathers Family
  public static final String EXT_MOTHERS_FAMILY = "http://hl7.org/fhir/StructureDefinition/humanname-mothers-family"; // Mothers Family
  public static final String EXT_OWN_NAME = "http://hl7.org/fhir/StructureDefinition/humanname-own-name"; // Own Name
  public static final String EXT_OWN_PREFIX = "http://hl7.org/fhir/StructureDefinition/humanname-own-prefix"; // Own Prefix
  public static final String EXT_PARTNER_NAME = "http://hl7.org/fhir/StructureDefinition/humanname-partner-name"; // Partner Name
  public static final String EXT_PARTNER_PREFIX = "http://hl7.org/fhir/StructureDefinition/humanname-partner-prefix"; // Partner Prefix
  public static final String EXT_IDCHECK_DIGIT = "http://hl7.org/fhir/StructureDefinition/identifier-checkDigit"; // ID Check digit
  public static final String EXT_VALID_DATE = "http://hl7.org/fhir/StructureDefinition/identifier-validDate"; // Valid date
  public static final String EXT_IMM_PROCEDURE = "http://hl7.org/fhir/StructureDefinition/immunization-procedure"; // Immunization Procedure
  public static final String EXT_IGSOURCE_FILE = "http://hl7.org/fhir/StructureDefinition/implementationguide-sourceFile"; // ImplementationGuide Source File
  public static final String EXT_PGENDER_IDENTITY = "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity"; // Individual Gender Identity
  public static final String EXT_PPRONOUNS = "http://hl7.org/fhir/StructureDefinition/individual-pronouns"; // Individual Pronouns
  public static final String EXT_RECORDED_SEX_OR_GENDER = "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender"; // Person Recorded Sex Or Gender
  public static final String EXT_ADUSE = "http://hl7.org/fhir/StructureDefinition/iso21090-AD-use"; // AD Use
  public static final String EXT_ADXPADDITIONAL_LOCATOR = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-additionalLocator"; // ADXP Additional Locator
  public static final String EXT_ADXPBUILDING_NUMBER_SUFFIX = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-buildingNumberSuffix"; // ADXP Building Number Suffix
  public static final String EXT_ADXPCARE_OF = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-careOf"; // ADXP Care Of
  public static final String EXT_ADXPCENSUS_TRACT = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-censusTract"; // ADXP Census Tract
  public static final String EXT_ADXPDELIMITER = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-delimiter"; // ADXP Delimiter
  public static final String EXT_ADXPDELIVERY_ADDRESS_LINE = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryAddressLine"; // ADXP Delivery Address Line
  public static final String EXT_ADXPDELIVERY_INSTALLATION_AREA = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationArea"; // ADXP Delivery Installation Area
  public static final String EXT_ADXPDELIVERY_INSTALLATION_QUALIFIER = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationQualifier"; // ADXP Delivery Installation Qualifier
  public static final String EXT_ADXPDELIVERY_INSTALLATION_TYPE = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationType"; // ADXP Delivery Installation Type
  public static final String EXT_ADXPDELIVERY_MODE = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryMode"; // ADXP Delivery Mode
  public static final String EXT_ADXPDELIVERY_MODE_IDENTIFIER = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryModeIdentifier"; // ADXP Delivery Mode Identifier
  public static final String EXT_ADXPDIRECTION = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-direction"; // ADXP Direction
  public static final String EXT_ADXPHOUSE_NUMBER = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber"; // ADXP House Number
  public static final String EXT_ADXPHOUSE_NUMBER_NUMERIC = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumberNumeric"; // ADXP House Number Numeric
  public static final String EXT_ADXPPOST_BOX = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox"; // ADXP Post Box
  public static final String EXT_ADXPPRECINCT = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-precinct"; // ADXP Precinct
  public static final String EXT_ADXPSTREET_ADDRESS_LINE = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetAddressLine"; // ADXP Street Address Line
  public static final String EXT_ADXPSTREET_NAME = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName"; // ADXP Street Name
  public static final String EXT_ADXPSTREET_NAME_BASE = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameBase"; // ADXP Street Name Base
  public static final String EXT_ADXPSTREET_NAME_TYPE = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameType"; // ADXP Street Name Type
  public static final String EXT_ADXPUNIT_I_D = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitID"; // ADXP Unit ID
  public static final String EXT_ADXPUNIT_TYPE = "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitType"; // ADXP Unit Type
  public static final String EXT_ENQUALIFIER = "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier"; // EN Qualifier
  public static final String EXT_ENREPRESENTATION = "http://hl7.org/fhir/StructureDefinition/iso21090-EN-representation"; // EN Representation
  public static final String EXT_ENUSE = "http://hl7.org/fhir/StructureDefinition/iso21090-EN-use"; // EN use
  public static final String EXT_TELADDRESS = "http://hl7.org/fhir/StructureDefinition/iso21090-TEL-address"; // TEL address
  public static final String EXT_CODED_STRING = "http://hl7.org/fhir/StructureDefinition/iso21090-codedString"; // Coded string
  public static final String EXT_NULL_FLAVOR = "http://hl7.org/fhir/StructureDefinition/iso21090-nullFlavor"; // null flavor
  public static final String EXT_PREFERRED = "http://hl7.org/fhir/StructureDefinition/iso21090-preferred"; // Preferred
  public static final String EXT_UNCERTAINTY = "http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty"; // Uncertainty
  public static final String EXT_UNCERTAINTY_TYPE = "http://hl7.org/fhir/StructureDefinition/iso21090-uncertaintyType"; // Uncertainty type
  public static final String EXT_ITEM_WEIGHT = "http://hl7.org/fhir/StructureDefinition/itemWeight"; // Item Weight
  public static final String EXT_HUMAN_LANGUAGE = "http://hl7.org/fhir/StructureDefinition/language"; // Human Language
  public static final String EXT_LARGE_VALUE = "http://hl7.org/fhir/StructureDefinition/largeValue"; // Large Value
  public static final String EXT_LAST_SOURCE_SYNC = "http://hl7.org/fhir/StructureDefinition/lastSourceSync"; // Last source sync
  public static final String EXT_LIST_CATEGORY = "http://hl7.org/fhir/StructureDefinition/list-category"; // List Category
  public static final String EXT_LIST_CHANGE_BASE = "http://hl7.org/fhir/StructureDefinition/list-changeBase"; // List Change Base
  public static final String EXT_LIST_FOR = "http://hl7.org/fhir/StructureDefinition/list-for"; // List For Extension
  public static final String EXT_LOC_BOUNDARY_GEOJSON = "http://hl7.org/fhir/StructureDefinition/location-boundary-geojson"; // Location Boundary (GeoJSON)
  public static final String EXT_LOC_COMMUNICATION = "http://hl7.org/fhir/StructureDefinition/location-communication"; // Location Communication
  public static final String EXT_BUNDLE_LOCATION_DISTANCE = "http://hl7.org/fhir/StructureDefinition/location-distance"; // Bundle Location Distance
  public static final String EXT_BUNDLE_MATCH_GRADE = "http://hl7.org/fhir/StructureDefinition/match-grade"; // Bundle Match Grade
  public static final String EXT_MAX_DECIMAL_PLACES = "http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces"; // max decimal places
  public static final String EXT_MAX_SIZE = "http://hl7.org/fhir/StructureDefinition/maxSize"; // max size
  public static final String EXT_MAX_VALUE = "http://hl7.org/fhir/StructureDefinition/maxValue"; // max value
  public static final String EXT_MED_MANUFACTURING_BATCH = "http://hl7.org/fhir/StructureDefinition/medication-manufacturingBatch"; // Medication Manufacturing Batch
  public static final String EXT_MED_QUANTITY_REMAINING = "http://hl7.org/fhir/StructureDefinition/medicationdispense-quantityRemaining"; // MedicationDispense Quantity Remaining
  public static final String EXT_MED_REFILLS_REMAINING = "http://hl7.org/fhir/StructureDefinition/medicationdispense-refillsRemaining"; // MedicationDispense Refills Remaining
  public static final String EXT_MSG_RESPONSE_REQUEST = "http://hl7.org/fhir/StructureDefinition/messageheader-response-request"; // MessageHeader Response Request
  public static final String EXT_MIME_TYPE = "http://hl7.org/fhir/StructureDefinition/mimeType"; // mime type
  public static final String EXT_MIN_LENGTH = "http://hl7.org/fhir/StructureDefinition/minLength"; // min length
  public static final String EXT_MIN_VALUE = "http://hl7.org/fhir/StructureDefinition/minValue"; // min value
  public static final String EXT_NSCHECK_DIGIT = "http://hl7.org/fhir/StructureDefinition/namingsystem-checkDigit"; // NamingSystem Check Digit
  public static final String EXT_NARRATIVE_LINK = "http://hl7.org/fhir/StructureDefinition/narrativeLink"; // Narrative Link
  public static final String EXT_PAT_NO_FIXED_ADDRESS = "http://hl7.org/fhir/StructureDefinition/no-fixed-address"; // Patient No Fixed Address
  public static final String EXT_NTT_ADAPTIVE_FEEDING_DEVICE = "http://hl7.org/fhir/StructureDefinition/nutritionorder-adaptiveFeedingDevice"; // NutritionOrder Adaptive Feeding Device
  public static final String EXT_OBLIGATION = "http://hl7.org/fhir/StructureDefinition/obligation"; // Obligation
  public static final String EXT_OBS_BODY_POSITION = "http://hl7.org/fhir/StructureDefinition/observation-bodyPosition"; // Observation Body Position
  public static final String EXT_OBS_DELTA = "http://hl7.org/fhir/StructureDefinition/observation-delta"; // Observation Delta
  public static final String EXT_OBS_DEVICE_CODE = "http://hl7.org/fhir/StructureDefinition/observation-deviceCode"; // Observation Device Code
  public static final String EXT_OBS_FOCUS_CODE = "http://hl7.org/fhir/StructureDefinition/observation-focusCode"; // Observation Focal Subject Code
  public static final String EXT_OBS_GATEWAY_DEVICE = "http://hl7.org/fhir/StructureDefinition/observation-gatewayDevice"; // Observation Gateway Device
  public static final String EXT_OBS_PRECONDITION = "http://hl7.org/fhir/StructureDefinition/observation-precondition"; // Observation Precondition
  public static final String EXT_OBS_REAGENT = "http://hl7.org/fhir/StructureDefinition/observation-reagent"; // Observation Reagent
  public static final String EXT_OBS_REPLACES = "http://hl7.org/fhir/StructureDefinition/observation-replaces"; // Observation Replaces
  public static final String EXT_OBS_SECONDARY_FINDING = "http://hl7.org/fhir/StructureDefinition/observation-secondaryFinding"; // Observation Secondary Finding
  public static final String EXT_OBS_SEQUEL_TO = "http://hl7.org/fhir/StructureDefinition/observation-sequelTo"; // Observation Sequel To
  public static final String EXT_OBS_SPECIMEN_CODE = "http://hl7.org/fhir/StructureDefinition/observation-specimenCode"; // Observation Specimen Code
  public static final String EXT_OBS_TIME_OFFSET = "http://hl7.org/fhir/StructureDefinition/observation-timeOffset"; // Observation Time Offset
  public static final String EXT_AIADMINISTRATION = "http://hl7.org/fhir/StructureDefinition/openEHR-administration"; // AllergyIntolerance Administration
  public static final String EXT_AICAREPLAN = "http://hl7.org/fhir/StructureDefinition/openEHR-careplan"; // AllergyIntolerance Careplan
  public static final String EXT_AIEXPOSURE_DATE = "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDate"; // AllergyIntolerance Exposure Date
  public static final String EXT_AIEXPOSURE_DESCRIPTION = "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDescription"; // AllergyIntolerance ExposureDescription
  public static final String EXT_AIEXPOSURE_DURATION = "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDuration"; // AllergyIntolerance Exposure Duration
  public static final String EXT_AILOCATION = "http://hl7.org/fhir/StructureDefinition/openEHR-location"; // AllergyIntolerance Location
  public static final String EXT_AIMANAGEMENT = "http://hl7.org/fhir/StructureDefinition/openEHR-management"; // AllergyIntolerance Management
  public static final String EXT_ODPROFILE = "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile"; // OperationDefinition Profile
  public static final String EXT_OOAUTHORITY = "http://hl7.org/fhir/StructureDefinition/operationoutcome-authority"; // OperationOutcome Authority for Rule
  public static final String EXT_OODETECTED_ISSUE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-detectedIssue"; // OperationOutcome Detected Clinical Issue
  public static final String EXT_OOSOURCE_FILE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-file"; // OperationOutcome Source File
  public static final String EXT_OOISSUE_COL = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col"; // OperationOutcome Column of Issue
  public static final String EXT_OOISSUELINE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line"; // OperationOutcome Line of Issue
  public static final String EXT_OOISSUESOURCE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source"; // OperationOutcome Source of Issue
  public static final String EXT_OOISSUE_SOURCE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id"; // OperationOutcome Source of Issue
  public static final String EXT_ORG_PERIOD = "http://hl7.org/fhir/StructureDefinition/organization-period"; // Organization Period
  public static final String EXT_ORG_PREFERRED_CONTACT = "http://hl7.org/fhir/StructureDefinition/organization-preferredContact"; // Organization Preferred Contact
  public static final String EXT_ORG_PRIMARY_IND = "http://hl7.org/fhir/StructureDefinition/organizationaffiliation-primaryInd"; // Organization Primary Indicator
  public static final String EXT_ORIGINAL_TEXT = "http://hl7.org/fhir/StructureDefinition/originalText"; // Original Text
  public static final String EXT_PARAMETERS_DEFINITION = "http://hl7.org/fhir/StructureDefinition/parameters-definition"; // Parameters Definition for parameter
  public static final String EXT_PARAM_FULL_URL = "http://hl7.org/fhir/StructureDefinition/parameters-fullUrl"; // Parameters FullUrl for resource
  public static final String EXT_PAT_ADOPTION_INFO = "http://hl7.org/fhir/StructureDefinition/patient-adoptionInfo"; // Patient Adoption Info
  public static final String EXT_PAT_ANIMAL = "http://hl7.org/fhir/StructureDefinition/patient-animal"; // Patient Animal
  public static final String EXT_PAT_BIRTH_PLACE = "http://hl7.org/fhir/StructureDefinition/patient-birthPlace"; // Patient Birth Place
  public static final String EXT_PAT_BIRTH_TIME = "http://hl7.org/fhir/StructureDefinition/patient-birthTime"; // Patient Birth Time
  public static final String EXT_PAT_CADAVERIC_DONOR = "http://hl7.org/fhir/StructureDefinition/patient-cadavericDonor"; // Patient Is-Cadaveric Donor
  public static final String EXT_PAT_CITIZENSHIP = "http://hl7.org/fhir/StructureDefinition/patient-citizenship"; // Patient Citizenship
  public static final String EXT_PAT_CONGREGATION = "http://hl7.org/fhir/StructureDefinition/patient-congregation"; // Patient Congregation
  public static final String EXT_PAT_DISABILITY = "http://hl7.org/fhir/StructureDefinition/patient-disability"; // Patient Disability
  public static final String EXT_PAT_IMPORTANCE = "http://hl7.org/fhir/StructureDefinition/patient-importance"; // Patient Importance
  public static final String EXT_PAT_INTERPRETER_REQUIRED = "http://hl7.org/fhir/StructureDefinition/patient-interpreterRequired"; // Patient Interpreter Required
  public static final String EXT_PAT_MOTHERS_MAIDEN_NAME = "http://hl7.org/fhir/StructureDefinition/patient-mothersMaidenName"; // Patient Mother's Maiden Name
  public static final String EXT_PAT_MULTIPLE_BIRTH_TOTAL = "http://hl7.org/fhir/StructureDefinition/patient-multipleBirthTotal"; // Patient Multiple Birth Total
  public static final String EXT_PAT_NATIONALITY = "http://hl7.org/fhir/StructureDefinition/patient-nationality"; // Patient Nationality
  public static final String EXT_PAT_PREFERENCE_TYPE = "http://hl7.org/fhir/StructureDefinition/patient-preferenceType"; // Patient Preference Type
  public static final String EXT_PAT_PROFICIENCY = "http://hl7.org/fhir/StructureDefinition/patient-proficiency"; // Patient Proficiency
  public static final String EXT_PAT_RELATED_PERSON = "http://hl7.org/fhir/StructureDefinition/patient-relatedPerson"; // Patient Related Person
  public static final String EXT_PAT_RELIGION = "http://hl7.org/fhir/StructureDefinition/patient-religion"; // Patient Religion
  public static final String EXT_PAT_SEX_FOR_CLINICAL_USE = "http://hl7.org/fhir/StructureDefinition/patient-sexForClinicalUse"; // Patient Sex For Clinical Use
  public static final String EXT_PRANIMAL_SPECIES = "http://hl7.org/fhir/StructureDefinition/practitioner-animalSpecies"; // Practitioner Animal Species
  public static final String EXT_PRJOB_TITLE = "http://hl7.org/fhir/StructureDefinition/practitioner-job-title"; // Practitioner Job title
  public static final String EXT_PRPRIMARY_IND = "http://hl7.org/fhir/StructureDefinition/practitionerrole-primaryInd"; // PractitionerRole Primary Indicator
  public static final String EXT_PRAPPROACH_BODY_STRUCTURE = "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure"; // Procedure Approach Body Structure
  public static final String EXT_PRCAUSED_BY = "http://hl7.org/fhir/StructureDefinition/procedure-causedBy"; // Procedure Caused By
  public static final String EXT_PRDIRECTED_BY = "http://hl7.org/fhir/StructureDefinition/procedure-directedBy"; // Procedure Directed By
  public static final String EXT_PRINCISION_DATE_TIME = "http://hl7.org/fhir/StructureDefinition/procedure-incisionDateTime"; // Procedure Incision DateTime
  public static final String EXT_PRMETHOD = "http://hl7.org/fhir/StructureDefinition/procedure-method"; // Procedure Method
  public static final String EXT_PRPROGRESS_STATUS = "http://hl7.org/fhir/StructureDefinition/procedure-progressStatus"; // Procedure Progress Status
  public static final String EXT_PRTARGET_BODY_STRUCTURE = "http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure"; // Procedure Target Body Structure
  public static final String EXT_PRECISION = "http://hl7.org/fhir/StructureDefinition/quantity-precision"; // Precision
  public static final String EXT_QBASE_TYPE = "http://hl7.org/fhir/StructureDefinition/questionnaire-baseType"; // Questionnaire Base Type
  public static final String EXT_QCHOICE_ORIENTATION = "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation"; // Questionnaire ChoiceOrientation
  public static final String EXT_QCONSTRAINT = "http://hl7.org/fhir/StructureDefinition/questionnaire-constraint"; // Questionnaire Constraint
  public static final String EXT_QDEFINITION_BASED = "http://hl7.org/fhir/StructureDefinition/questionnaire-definitionBased"; // Questionnaire is Definition Based
  public static final String EXT_QDISPLAY_CATEGORY = "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory"; // Questionnaire Display Category
  public static final String EXT_QFHIR_TYPE = "http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType"; // Questionnaire FHIR Type
  public static final String EXT_QHIDDEN = "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden"; // Questionnaire Hidden
  public static final String EXT_QITEM_CONTROL = "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl"; // Questionnaire Item Control
  public static final String EXT_QMAX_OCCURS = "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs"; // Questionnaire Max Occurs
  public static final String EXT_QMIN_OCCURS = "http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs"; // Questionnaire Min Occurs
  public static final String EXT_QOPTION_EXCLUSIVE = "http://hl7.org/fhir/StructureDefinition/questionnaire-optionExclusive"; // Questionnaire Option Exclusive
  public static final String EXT_QOPTION_PREFIX = "http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix"; // Questionnaire Option Prefix
  public static final String EXT_QOPTION_RESTRICTION = "http://hl7.org/fhir/StructureDefinition/questionnaire-optionRestriction"; // Questionnaire Option Restriction
  public static final String EXT_REFERENCE_FILTER = "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter"; // referenceFilter
  public static final String EXT_QREFERENCE_PROFILE = "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceProfile"; // Questionnaire Reference Profile
  public static final String EXT_QREFERENCE_RESOURCE = "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceResource"; // Questionnaire Reference Resource
  public static final String EXT_QSIGNATURE_REQUIRED = "http://hl7.org/fhir/StructureDefinition/questionnaire-signatureRequired"; // Questionnaire Signature Required
  public static final String EXT_QSLIDER_STEP_VALUE = "http://hl7.org/fhir/StructureDefinition/questionnaire-sliderStepValue"; // Questionnaire Slider Step Value
  public static final String EXT_QSUPPORT_LINK = "http://hl7.org/fhir/StructureDefinition/questionnaire-supportLink"; // Questionnaire Support Link
  public static final String EXT_QUNIT = "http://hl7.org/fhir/StructureDefinition/questionnaire-unit"; // Questionnaire Unit
  public static final String EXT_QRUNIT_OPTION = "http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption"; // QuestionnaireResponse Unit Option
  public static final String EXT_QRUNIT_VALUE_SET = "http://hl7.org/fhir/StructureDefinition/questionnaire-unitValueSet"; // QuestionnaireResponse Unit ValueSet
  public static final String EXT_QRUSAGE_MODE = "http://hl7.org/fhir/StructureDefinition/questionnaire-usageMode"; // QuestionnaireResponse Usage Mode
  public static final String EXT_QRATTESTER = "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-attester"; // QuestionnaireResponse Attester
  public static final String EXT_QRAUTHOR = "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author"; // QuestionnaireResponse Author
  public static final String EXT_QRCOMPLETION_MODE = "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-completionMode"; // QuestionnaireResponse Completion Mode
  public static final String EXT_QRREASON = "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-reason"; // QuestionnaireResponse Reason
  public static final String EXT_QRREVIEWER = "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-reviewer"; // QuestionnaireResponse Reviewer
  public static final String EXT_QRSIGNATURE = "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-signature"; // QuestionnaireResponse Signature
  public static final String EXT_REFERENCES_CONTAINED = "http://hl7.org/fhir/StructureDefinition/referencesContained"; // References Contained
  public static final String EXT_RELATIVE_DATE_CRITERIA = "http://hl7.org/fhir/StructureDefinition/relative-date"; // Relative Date Criteria
  public static final String EXT_RENDERED_VALUE = "http://hl7.org/fhir/StructureDefinition/rendered-value"; // Rendered Value
  public static final String EXT_MARKDOWN = "http://hl7.org/fhir/StructureDefinition/rendering-markdown"; // Markdown
  public static final String EXT_RENDERING_STYLE = "http://hl7.org/fhir/StructureDefinition/rendering-style"; // Rendering Style
  public static final String EXT_STYLE_SENSITIVE = "http://hl7.org/fhir/StructureDefinition/rendering-styleSensitive"; // style sensitive
  public static final String EXT_XHTML_REPRESENTATION = "http://hl7.org/fhir/StructureDefinition/rendering-xhtml"; // XHTML Representation
  public static final String EXT_REPLACES = "http://hl7.org/fhir/StructureDefinition/replaces"; // Replaces
  public static final String EXT_DO_NOT_PERFORM = "http://hl7.org/fhir/StructureDefinition/request-doNotPerform"; // do not perform
  public static final String EXT_REQUEST_INSURANCE = "http://hl7.org/fhir/StructureDefinition/request-insurance"; // Request Insurance
  public static final String EXT_PERFORMER_ORDER = "http://hl7.org/fhir/StructureDefinition/request-performerOrder"; // performer order
  public static final String EXT_RELEVANT_HISTORY = "http://hl7.org/fhir/StructureDefinition/request-relevantHistory"; // relevant history
  public static final String EXT_REQUEST_REPLACES = "http://hl7.org/fhir/StructureDefinition/request-replaces"; // Request Replaces
  public static final String EXT_REQUEST_STATUS_REASON = "http://hl7.org/fhir/StructureDefinition/request-statusReason"; // status reason
  public static final String EXT_RSSITE_RECRUITMENT = "http://hl7.org/fhir/StructureDefinition/researchStudy-siteRecruitment"; // ResearchStudy Site Recruitment
  public static final String EXT_RSSTUDY_REGISTRATION = "http://hl7.org/fhir/StructureDefinition/researchStudy-studyRegistration"; // ResearchStudy Study Registration
  public static final String EXT_RESOLVE_AS_VERSION_SPECIFIC = "http://hl7.org/fhir/StructureDefinition/resolve-as-version-specific"; // Resolve as version specific
  public static final String EXT_RESOURCE_APPROVAL_DATE = "http://hl7.org/fhir/StructureDefinition/resource-approvalDate"; // Resource Approval Date
  public static final String EXT_RESOURCE_EFFECTIVE_PERIOD = "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod"; // Resource Effective Period
  public static final String EXT_RESOURCE_INSTANCE_DESCRIPTION = "http://hl7.org/fhir/StructureDefinition/resource-instance-description"; // Resource instance description
  public static final String EXT_RESOURCE_INSTANCE_NAME = "http://hl7.org/fhir/StructureDefinition/resource-instance-name"; // Resource instance name
  public static final String EXT_RESLAST_REVIEW_DATE = "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate"; // Resource Last Review Date
  public static final String EXT_SRPERTAINS_TO_GOAL = "http://hl7.org/fhir/StructureDefinition/resource-pertainsToGoal"; // ServiceRequest Pertains To Goal
  public static final String EXT_RESOURCE_SATIFIES_REQUIREMENT = "http://hl7.org/fhir/StructureDefinition/satisfies-requirement"; // Resource Satifies Requirement
  public static final String EXT_SRPRECONDITION = "http://hl7.org/fhir/StructureDefinition/servicerequest-precondition"; // ServiceRequest Precondition
  public static final String EXT_SRQUESTIONNAIRE_REQUEST = "http://hl7.org/fhir/StructureDefinition/servicerequest-questionnaireRequest"; // ServiceRequest Questionnaire Requested
  public static final String EXT_SPEC_COLLECTION_PRIORITY = "http://hl7.org/fhir/StructureDefinition/specimen-collectionPriority"; // Specimen Collection Priority
  public static final String EXT_SPEC_IS_DRY_WEIGHT = "http://hl7.org/fhir/StructureDefinition/specimen-isDryWeight"; // Specimen Is Dry Weight
  public static final String EXT_SPEC_PROCESSING_TIME = "http://hl7.org/fhir/StructureDefinition/specimen-processingTime"; // Specimen Processing Time
  public static final String EXT_SPEC_SEQUENCE_NUMBER = "http://hl7.org/fhir/StructureDefinition/specimen-sequenceNumber"; // Specimen Sequence Number
  public static final String EXT_SPEC_SPECIAL_HANDLING = "http://hl7.org/fhir/StructureDefinition/specimen-specialHandling"; // Specimen Special handling
  public static final String EXT_SDANCESTOR = "http://hl7.org/fhir/StructureDefinition/structuredefinition-ancestor"; // StructureDefinition Ancestor
  public static final String EXT_SDAPPLICABLE_VERSION = "http://hl7.org/fhir/StructureDefinition/structuredefinition-applicable-version"; // StructureDefinition Applicable Version
  public static final String EXT_SDCATEGORY = "http://hl7.org/fhir/StructureDefinition/structuredefinition-category"; // StructureDefinition Category
  public static final String EXT_SDCODEGEN_SUPER = "http://hl7.org/fhir/StructureDefinition/structuredefinition-codegen-super"; // StructureDefinition Codegen Super
  public static final String EXT_SDCOMPLIES_WITH_PROFILE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile"; // StructureDefinition Compiles With Profile
  public static final String EXT_SDSTATUS_DERIVATION = "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom"; // StructureDefinition Status Derivation
  public static final String EXT_SDDISPLAY_HINT = "http://hl7.org/fhir/StructureDefinition/structuredefinition-display-hint"; // StructureDefinition Display Hint
  public static final String EXT_SDEXPLICIT_TYPE_NAME = "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name"; // StructureDefinition Explicit Type Name
  public static final String EXT_SDEXTENSION_MEANING = "http://hl7.org/fhir/StructureDefinition/structuredefinition-extension-meaning"; // StructureDefinition Extension Meaning
  public static final String EXT_SDFHIR_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type"; // StructureDefinition FHIR Type
  public static final String EXT_SDFMM = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm"; // StructureDefinition FMM Level
  public static final String EXT_SDFMM_NO_WARNINGS = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-no-warnings"; // StructureDefinition FMM If No Warnings
  public static final String EXT_SDFMM_SUPPORT_DOCO = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support"; // StructureDefinition FMM Supporting Documentation
  public static final String EXT_SDHIERARCHY = "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy"; // StructureDefinition Hierarchy
  public static final String EXT_SDIMPOSE_PROFILE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile"; // StructureDefinition Dependent Profiles
  public static final String EXT_SDINHERITANCE_CONTROL = "http://hl7.org/fhir/StructureDefinition/structuredefinition-inheritance-control"; // StructureDefinition Inheritance Control (for Extensions)
  public static final String EXT_SDINTERFACE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-interface"; // StructureDefinition Interface
  public static final String EXT_SDNORMATIVE_VERSION = "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version"; // StructureDefinition First Normative Version
  public static final String EXT_SDSECURITY_CATEGORY = "http://hl7.org/fhir/StructureDefinition/structuredefinition-security-category"; // StructureDefinition Security Category
  public static final String EXT_SDSTANDARDS_STATUS = "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status"; // StructureDefinition Standards Status
  public static final String EXT_SDSTANDARDS_STATUS_REASON = "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status-reason"; // StructureDefinition Standards Status Reason
  public static final String EXT_SDSUMMARY = "http://hl7.org/fhir/StructureDefinition/structuredefinition-summary"; // Structure Definition Summary
  public static final String EXT_SDTABLE_NAME = "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name"; // StructureDefinition Table Name
  public static final String EXT_SDTEMPLATE_STATUS = "http://hl7.org/fhir/StructureDefinition/structuredefinition-template-status"; // StructureDefinition Template Status
  public static final String EXT_SDTYPE_CHARACTERISTICS = "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics"; // Structure Type Characterstics (Constraint Control)
  public static final String EXT_SDWORK_GROUP = "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg"; // StructureDefinition Work Group
  public static final String EXT_SDXML_HAS_NO_ORDER = "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order"; // StructureDefinition Xml Has No Order
  public static final String EXT_TARGET_ELEMENT = "http://hl7.org/fhir/StructureDefinition/targetElement"; // Target element
  public static final String EXT_TARGET_PATH = "http://hl7.org/fhir/StructureDefinition/targetPath"; // Target path
  public static final String EXT_TASK_REPLACES = "http://hl7.org/fhir/StructureDefinition/task-replaces"; // Task Replaces
  public static final String EXT_TX_RESOURCE_IDENTIFIER_METADATA = "http://hl7.org/fhir/StructureDefinition/terminology-resource-identifier-metadata"; // Terminology Resource Identifier Metadata
  public static final String EXT_TIMEZONE_CODE = "http://hl7.org/fhir/StructureDefinition/timezone"; // Timezone Code
  public static final String EXT_TIMING_DAY_OF_MONTH = "http://hl7.org/fhir/StructureDefinition/timing-dayOfMonth"; // Timing day of month
  public static final String EXT_DAYS_OF_CYCLE = "http://hl7.org/fhir/StructureDefinition/timing-daysOfCycle"; // days of cycle
  public static final String EXT_TIMING_EXACT = "http://hl7.org/fhir/StructureDefinition/timing-exact"; // Timing Exact
  public static final String EXT_UNCERTAIN_DATE = "http://hl7.org/fhir/StructureDefinition/timing-uncertainDate"; // Uncertain date
  public static final String EXT_TRANSLATION = "http://hl7.org/fhir/StructureDefinition/translation"; // Translation
  public static final String EXT_TIMEZONE_OFFSET = "http://hl7.org/fhir/StructureDefinition/tz-offset"; // Timezone Offset
  public static final String EXT_UNCERTAIN_PERIOD = "http://hl7.org/fhir/StructureDefinition/uncertainPeriod"; // Uncertain period
  public static final String EXT_GROUP = "http://hl7.org/fhir/StructureDefinition/usagecontext-group"; // Group
  public static final String EXT_VSAUTHORITATIVE_SOURCE = "http://hl7.org/fhir/StructureDefinition/valueset-authoritativeSource"; // ValueSet Authoritative Source
  public static final String EXT_VSCASE_SENSITIVE = "http://hl7.org/fhir/StructureDefinition/valueset-caseSensitive"; // ValueSet Case Sensitive
  public static final String EXT_VSCOMPOSE_CREATED_BY = "http://hl7.org/fhir/StructureDefinition/valueset-compose-createdBy"; // ValueSet Compose CreatedBy
  public static final String EXT_VSCOMPOSE_CREATION_DATE = "http://hl7.org/fhir/StructureDefinition/valueset-compose-creationDate"; // ValueSet Compose Creation Date
  public static final String EXT_VSINCLUDE_V_S_TITLE = "http://hl7.org/fhir/StructureDefinition/valueset-compose-include-valueSetTitle"; // ValueSet Include ValueSet Title
  public static final String EXT_VSCONCEPT_COMMENTS = "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments"; // ValueSet Concept Comments
  public static final String EXT_VSCONCEPT_DEFINITION = "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition"; // ValueSet Concept Definition
  public static final String EXT_VSCONCEPT_ORDER = "http://hl7.org/fhir/StructureDefinition/valueset-conceptOrder"; // ValueSet Concept Order
  public static final String EXT_VSDEPRECATED = "http://hl7.org/fhir/StructureDefinition/valueset-deprecated"; // ValueSet Deprecated
  public static final String EXT_VSEXPANSION_SOURCE = "http://hl7.org/fhir/StructureDefinition/valueset-expansionSource"; // ValueSet Expansion Source
  public static final String EXT_VSEXPRESSION = "http://hl7.org/fhir/StructureDefinition/valueset-expression"; // ValueSet Expression
  public static final String EXT_VSEXTENSIBLE = "http://hl7.org/fhir/StructureDefinition/valueset-extensible"; // ValueSet Extensible
  public static final String EXT_VSKEYWORD = "http://hl7.org/fhir/StructureDefinition/valueset-keyWord"; // ValueSet Keyword
  public static final String EXT_VSLABEL = "http://hl7.org/fhir/StructureDefinition/valueset-label"; // ValueSet Label
  public static final String EXT_VSMAP = "http://hl7.org/fhir/StructureDefinition/valueset-map"; // ValueSet Map
  public static final String EXT_VSOTHER_NAME = "http://hl7.org/fhir/StructureDefinition/valueset-otherName"; // ValueSet Other Name
  public static final String EXT_VSOTHER_TITLE = "http://hl7.org/fhir/StructureDefinition/valueset-otherTitle"; // ValueSet Other Title
  public static final String EXT_VSPARAMETER_SOURCE = "http://hl7.org/fhir/StructureDefinition/valueset-parameterSource"; // ValueSet Parameter Source
  public static final String EXT_VSREFERENCE = "http://hl7.org/fhir/StructureDefinition/valueset-reference"; // ValueSet Reference
  public static final String EXT_VSRULES_TEXT = "http://hl7.org/fhir/StructureDefinition/valueset-rules-text"; // ValueSet Rules Text
  public static final String EXT_VSSOURCE_REFERENCE = "http://hl7.org/fhir/StructureDefinition/valueset-sourceReference"; // ValueSet Source Reference
  public static final String EXT_VSSPECIAL_STATUS = "http://hl7.org/fhir/StructureDefinition/valueset-special-status"; // ValueSet Special Status
  public static final String EXT_VSSUPPLEMENT = "http://hl7.org/fhir/StructureDefinition/valueset-supplement"; // ValueSet Supplement
  public static final String EXT_VSSYSTEM = "http://hl7.org/fhir/StructureDefinition/valueset-system"; // ValueSet System
  public static final String EXT_VSSYSTEM_NAME = "http://hl7.org/fhir/StructureDefinition/valueset-systemName"; // ValueSet System Name
  public static final String EXT_VSSYSTEM_REFERENCE = "http://hl7.org/fhir/StructureDefinition/valueset-systemRef"; // ValueSet System Reference
  public static final String EXT_VSSYSTEM_TITLE = "http://hl7.org/fhir/StructureDefinition/valueset-systemTitle"; // Value Set System Title
  public static final String EXT_VSTOOCOSTLY = "http://hl7.org/fhir/StructureDefinition/valueset-toocostly"; // Valueset Too Costly (Expansion Truncated)
  public static final String EXT_VSTRUSTED_EXPANSION = "http://hl7.org/fhir/StructureDefinition/valueset-trusted-expansion"; // Valueset Trusted Expansion
  public static final String EXT_VSUNCLOSED = "http://hl7.org/fhir/StructureDefinition/valueset-unclosed"; // ValueSet Unclosed
  public static final String EXT_VSUSAGE = "http://hl7.org/fhir/StructureDefinition/valueset-usage"; // ValueSet Usage
  public static final String EXT_VSWARNING = "http://hl7.org/fhir/StructureDefinition/valueset-warning"; // ValueSet Warning
  public static final String EXT_WORKFLOW_STATUS_DESCRIPTION = "http://hl7.org/fhir/StructureDefinition/valueset-workflowStatusDescription"; // Workflow Status Description
  public static final String EXT_VARIABLE = "http://hl7.org/fhir/StructureDefinition/variable"; // Variable
  public static final String EXT_ADHERES_TO = "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo"; // adheres to
  public static final String EXT_WORKFLOW_BARRIER = "http://hl7.org/fhir/StructureDefinition/workflow-barrier"; // Workflow Barrier
  public static final String EXT_COMPLIES_WITH = "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith"; // complies with
  public static final String EXT_EPISODE_OF_CARE = "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare"; // episode of care
  public static final String EXT_FOLLOW_ON_OF = "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf"; // follow on of
  public static final String EXT_GENERATED_FROM = "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom"; // generated from
  public static final String EXT_PROTECTIVE_FACTOR = "http://hl7.org/fhir/StructureDefinition/workflow-protectiveFactor"; // protective factor
  public static final String EXT_WORKFLOW_REASON = "http://hl7.org/fhir/StructureDefinition/workflow-reason"; // Workflow Reason
  public static final String EXT_RELATED_ARTIFACT = "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact"; // related artifact
  public static final String EXT_RELEASE_DATE = "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate"; // release date
  public static final String EXT_RESEARCH_STUDY = "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy"; // research study
  public static final String EXT_SHALL_COMPLY_WITH = "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith"; // shall comply with
  public static final String EXT_SUPPORTING_INFO = "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo"; // supporting info
  public static final String EXT_TRIGGERED_BY = "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy"; // triggered by
  public static final String EXT_ADDITIONAL_BINDING = "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"; // Additional Binding Extension
  public static final String EXT_BINDING_DEFINITION = "http://hl7.org/fhir/tools/StructureDefinition/binding-definition"; // Binding Definition
  public static final String EXT_VOCAB_BINDING_STYLES_E_X_T = "http://hl7.org/fhir/tools/StructureDefinition/binding-style"; // Vocab Binding Style Extension
  public static final String EXT_DATE_FORMAT = "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format"; // Date Format String
  public static final String EXT_JSON_PROPERTY_NAME = "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name"; // Json Property Name Extension
  public static final String EXT_EXTENSION_STYLES_E_X_T = "http://hl7.org/fhir/tools/StructureDefinition/extension-style"; // Extension Style Extension
  public static final String EXT_ID_EXPECTATION_EXT = "http://hl7.org/fhir/tools/StructureDefinition/id-expectation"; // Id Expectation Extension
  public static final String EXT_IGPAGE_NAME = "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name"; // IG Page Name
  public static final String EXT_IGPARAMETER = "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"; // IG Parameter
  public static final String EXT_IGDEPENDENCY_COMMENT = "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment"; // IG Dependency Comment
  public static final String EXT_BINARY_RESOURCE_FORMAT = "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format"; // Binary Resource Format
  public static final String EXT_BINARY_RESOURCE_LOGICAL = "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical"; // Binary Resource Logical
  public static final String EXT_IMPLIED_STRING_PREFIX = "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix"; // Implied String Prefix
  public static final String EXT_JSON_EMPTY_BEHAVIOR = "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior"; // Json Empty Behavior Extension
  public static final String EXT_JSON_NULLABLE_EXT = "http://hl7.org/fhir/tools/StructureDefinition/json-nullable"; // Json Nullable Extension
  public static final String EXT_JSON_PRIMITIVE_CHOICE_EXT = "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice"; // Json Primitive Choice Extension
  public static final String EXT_JSON_PROPERTY_KEY = "http://hl7.org/fhir/tools/StructureDefinition/json-property-key"; // Json Property Key Extension
  public static final String EXT_NO_BINDING = "http://hl7.org/fhir/tools/StructureDefinition/no-binding"; // No Binding Extension
  public static final String EXT_OBLIGATION_TOOLS = "http://hl7.org/fhir/tools/StructureDefinition/obligation"; // Obligation Extension
  public static final String EXT_PROFILE_MAPPING = "http://hl7.org/fhir/tools/StructureDefinition/profile-mapping"; // Profile Mapping Extension
  public static final String EXT_PROFILE_SUMMARY = "http://hl7.org/fhir/tools/StructureDefinition/profile-summary"; // ProfileSummary
  public static final String EXT_SELECT_BY_MAP = "http://hl7.org/fhir/tools/StructureDefinition/select-by-map"; // Select By Map
  public static final String EXT_TYPE_SPECIFIER = "http://hl7.org/fhir/tools/StructureDefinition/type-specifier"; // Type Specifier Extension
  public static final String EXT_ASSOCIATED_CONCEPT_PROPERTY = "http://terminology.hl7.org/StructureDefinition/ext-mif-assocConceptProp"; // MIF Associated concept property
  public static final String EXT_SUPPORTED_CONCEPT_RELATIONSHIP_INVERSE_NAME = "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName"; // MIF concept relationship inverse name
  public static final String EXT_SUPPORTED_CONCEPT_RELATIONSHIP_IS_NAVIGABLE = "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable"; // MIF concept relationship is navigable
  public static final String EXT_SUPPORTED_CONCEPT_RELATIONSHIP_REFLEXIVITY = "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity"; // MIF concept relationship is reflexivity
  public static final String EXT_SUPPORTED_CONCEPT_RELATIONSHIP_RELATIONSHIP_KIND = "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind"; // MIF concept relationship kind
  public static final String EXT_SUPPORTED_CONCEPT_RELATIONSHIP_SYMMETRY = "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry"; // MIF concept relationship symmetry
  public static final String EXT_SUPPORTED_CONCEPT_RELATIONSHIP_TRANSITIVITY = "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity"; // MIF concept relationship transitivity
  public static final String EXT_NAMING_SYSTEM_TITLE = "http://terminology.hl7.org/StructureDefinition/ext-namingsystem-title"; // NamingSystem title
  public static final String EXT_NAMING_SYSTEM_VERSION = "http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version"; // NamingSystem version


  public static boolean isModifier(String url) {
    return Utilities.existsInList(url, "http://hl7.org/fhir/StructureDefinition/artifact-status", "http://hl7.org/fhir/StructureDefinition/capabilitystatement-prohibited", "http://hl7.org/fhir/StructureDefinition/request-doNotPerform");
  }



}