package org.hl7.fhir.r5.formats;

// generated

/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Thu, Mar 23, 2023 19:59+1100 for FHIR v5.0.0



import org.hl7.fhir.r5.model.*;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.json.JsonTrackingParser.PresentedBigDecimal;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;

public class JsonParser extends JsonParserBase {

  public JsonParser() {
    super();
  }

  public JsonParser(boolean allowUnknownContent) {
    super();
    setAllowUnknownContent(allowUnknownContent);
  }

  public JsonParser(boolean allowUnknownContent, boolean allowComments) {
    super();
    setAllowUnknownContent(allowUnknownContent);
    setAllowComments(allowComments);
  }

  protected void parseBaseProperties(JsonObject json, Base res) throws IOException, FHIRFormatError {
    // nothing
  }

  @SuppressWarnings("unchecked")
  protected <E extends Enum<E>> Enumeration<E> parseEnumeration(String s, E item, EnumFactory e) throws IOException, FHIRFormatError {
    Enumeration<E> res = new Enumeration<E>(e);
    if (s != null)
      res.setValue((E) e.fromCode(s));
    return res;
  }

  protected DateType parseDate(String v) throws IOException, FHIRFormatError {
    DateType res = new DateType(v);
    return res;
  }

  protected DateTimeType parseDateTime(String v) throws IOException, FHIRFormatError {
    DateTimeType res = new DateTimeType(v);
    return res;
  }

  protected CodeType parseCode(String v) throws IOException, FHIRFormatError {
    CodeType res = new CodeType(v);
    return res;
  }

  protected StringType parseString(String v) throws IOException, FHIRFormatError {
    StringType res = new StringType(v);
    return res;
  }

  protected IntegerType parseInteger(java.lang.Long v) throws IOException, FHIRFormatError {
    IntegerType res = new IntegerType(v);
    return res;
  }

  protected Integer64Type parseInteger64(java.lang.Long v) throws IOException, FHIRFormatError {
    Integer64Type res = new Integer64Type(v);
    return res;
  }

  protected OidType parseOid(String v) throws IOException, FHIRFormatError {
    OidType res = new OidType(v);
    return res;
  }

  protected CanonicalType parseCanonical(String v) throws IOException, FHIRFormatError {
    CanonicalType res = new CanonicalType(v);
    return res;
  }

  protected UriType parseUri(String v) throws IOException, FHIRFormatError {
    UriType res = new UriType(v);
    return res;
  }

  protected UuidType parseUuid(String v) throws IOException, FHIRFormatError {
    UuidType res = new UuidType(v);
    return res;
  }

  protected UrlType parseUrl(String v) throws IOException, FHIRFormatError {
    UrlType res = new UrlType(v);
    return res;
  }

  protected InstantType parseInstant(String v) throws IOException, FHIRFormatError {
    InstantType res = new InstantType(v);
    return res;
  }

  protected BooleanType parseBoolean(java.lang.Boolean v) throws IOException, FHIRFormatError {
    BooleanType res = new BooleanType(v);
    return res;
  }

  protected Base64BinaryType parseBase64Binary(String v) throws IOException, FHIRFormatError {
    Base64BinaryType res = new Base64BinaryType(v);
    return res;
  }

  protected UnsignedIntType parseUnsignedInt(String v) throws IOException, FHIRFormatError {
    UnsignedIntType res = new UnsignedIntType(v);
    return res;
  }

  protected MarkdownType parseMarkdown(String v) throws IOException, FHIRFormatError {
    MarkdownType res = new MarkdownType(v);
    return res;
  }

  protected TimeType parseTime(String v) throws IOException, FHIRFormatError {
    TimeType res = new TimeType(v);
    return res;
  }

  protected IdType parseId(String v) throws IOException, FHIRFormatError {
    IdType res = new IdType(v);
    return res;
  }

  protected PositiveIntType parsePositiveInt(String v) throws IOException, FHIRFormatError {
    PositiveIntType res = new PositiveIntType(v);
    return res;
  }

  protected DecimalType parseDecimal(java.math.BigDecimal v) throws IOException, FHIRFormatError {
    DecimalType res = new DecimalType(v);
    if (v instanceof PresentedBigDecimal)
      res.setRepresentation(((PresentedBigDecimal) v).getPresentation());
    return res;
  }



  protected void parseBackboneElementProperties(JsonObject json, BackboneElement res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("modifierExtension")) {
      JsonArray array = getJArray(json, "modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected void parseBackboneTypeProperties(JsonObject json, BackboneType res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("modifierExtension")) {
      JsonArray array = getJArray(json, "modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected void parseDataTypeProperties(JsonObject json, DataType res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
  }

  protected void parseElementProperties(JsonObject json, Element res) throws IOException, FHIRFormatError {
    if (json.has("id"))
      res.setIdElement(parseString(json.get("id").getAsString()));
    if (json.has("_id"))
      parseElementProperties(getJObject(json, "_id"), res.getIdElement());
    if (json.has("extension")) {
      JsonArray array = getJArray(json, "extension");
      for (int i = 0; i < array.size(); i++) {
        res.getExtension().add(parseExtension(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Address parseAddress(JsonObject json) throws IOException, FHIRFormatError {
    Address res = new Address();
    parseAddressProperties(json, res);
    return res;
  }

  protected void parseAddressProperties(JsonObject json, Address res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("line")) {
      JsonArray array = getJArray(json, "line");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLine().add(new StringType());
        } else {;
          res.getLine().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_line")) {
      JsonArray array = getJArray(json, "_line");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLine().size())
          res.getLine().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getLine().get(i));
      }
    };
    if (json.has("city"))
      res.setCityElement(parseString(json.get("city").getAsString()));
    if (json.has("_city"))
      parseElementProperties(getJObject(json, "_city"), res.getCityElement());
    if (json.has("district"))
      res.setDistrictElement(parseString(json.get("district").getAsString()));
    if (json.has("_district"))
      parseElementProperties(getJObject(json, "_district"), res.getDistrictElement());
    if (json.has("state"))
      res.setStateElement(parseString(json.get("state").getAsString()));
    if (json.has("_state"))
      parseElementProperties(getJObject(json, "_state"), res.getStateElement());
    if (json.has("postalCode"))
      res.setPostalCodeElement(parseString(json.get("postalCode").getAsString()));
    if (json.has("_postalCode"))
      parseElementProperties(getJObject(json, "_postalCode"), res.getPostalCodeElement());
    if (json.has("country"))
      res.setCountryElement(parseString(json.get("country").getAsString()));
    if (json.has("_country"))
      parseElementProperties(getJObject(json, "_country"), res.getCountryElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Age parseAge(JsonObject json) throws IOException, FHIRFormatError {
    Age res = new Age();
    parseAgeProperties(json, res);
    return res;
  }

  protected void parseAgeProperties(JsonObject json, Age res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Annotation parseAnnotation(JsonObject json) throws IOException, FHIRFormatError {
    Annotation res = new Annotation();
    parseAnnotationProperties(json, res);
    return res;
  }

  protected void parseAnnotationProperties(JsonObject json, Annotation res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    DataType author = parseType("author", json);
    if (author != null)
      res.setAuthor(author);
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(getJObject(json, "_time"), res.getTimeElement());
    if (json.has("text"))
      res.setTextElement(parseMarkdown(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected Attachment parseAttachment(JsonObject json) throws IOException, FHIRFormatError {
    Attachment res = new Attachment();
    parseAttachmentProperties(json, res);
    return res;
  }

  protected void parseAttachmentProperties(JsonObject json, Attachment res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(getJObject(json, "_contentType"), res.getContentTypeElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(getJObject(json, "_data"), res.getDataElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("size"))
      res.setSizeElement(parseInteger64(json.get("size").getAsLong()));
    if (json.has("_size"))
      parseElementProperties(getJObject(json, "_size"), res.getSizeElement());
    if (json.has("hash"))
      res.setHashElement(parseBase64Binary(json.get("hash").getAsString()));
    if (json.has("_hash"))
      parseElementProperties(getJObject(json, "_hash"), res.getHashElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("creation"))
      res.setCreationElement(parseDateTime(json.get("creation").getAsString()));
    if (json.has("_creation"))
      parseElementProperties(getJObject(json, "_creation"), res.getCreationElement());
    if (json.has("height"))
      res.setHeightElement(parsePositiveInt(json.get("height").getAsString()));
    if (json.has("_height"))
      parseElementProperties(getJObject(json, "_height"), res.getHeightElement());
    if (json.has("width"))
      res.setWidthElement(parsePositiveInt(json.get("width").getAsString()));
    if (json.has("_width"))
      parseElementProperties(getJObject(json, "_width"), res.getWidthElement());
    if (json.has("frames"))
      res.setFramesElement(parsePositiveInt(json.get("frames").getAsString()));
    if (json.has("_frames"))
      parseElementProperties(getJObject(json, "_frames"), res.getFramesElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(getJObject(json, "_duration"), res.getDurationElement());
    if (json.has("pages"))
      res.setPagesElement(parsePositiveInt(json.get("pages").getAsString()));
    if (json.has("_pages"))
      parseElementProperties(getJObject(json, "_pages"), res.getPagesElement());
  }

  protected Availability parseAvailability(JsonObject json) throws IOException, FHIRFormatError {
    Availability res = new Availability();
    parseAvailabilityProperties(json, res);
    return res;
  }

  protected void parseAvailabilityProperties(JsonObject json, Availability res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("availableTime")) {
      JsonArray array = getJArray(json, "availableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailableTime().add(parseAvailabilityAvailableTimeComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("notAvailableTime")) {
      JsonArray array = getJArray(json, "notAvailableTime");
      for (int i = 0; i < array.size(); i++) {
        res.getNotAvailableTime().add(parseAvailabilityNotAvailableTimeComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Availability.AvailabilityAvailableTimeComponent parseAvailabilityAvailableTimeComponent(JsonObject json) throws IOException, FHIRFormatError {
    Availability.AvailabilityAvailableTimeComponent res = new Availability.AvailabilityAvailableTimeComponent();
    parseAvailabilityAvailableTimeComponentProperties(json, res);
    return res;
  }

  protected void parseAvailabilityAvailableTimeComponentProperties(JsonObject json, Availability.AvailabilityAvailableTimeComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("daysOfWeek")) {
      JsonArray array = getJArray(json, "daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDaysOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
        } else {;
          res.getDaysOfWeek().add(parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        }
      }
    };
    if (json.has("_daysOfWeek")) {
      JsonArray array = getJArray(json, "_daysOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDaysOfWeek().size())
          res.getDaysOfWeek().add(parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDaysOfWeek().get(i));
      }
    };
    if (json.has("allDay"))
      res.setAllDayElement(parseBoolean(json.get("allDay").getAsBoolean()));
    if (json.has("_allDay"))
      parseElementProperties(getJObject(json, "_allDay"), res.getAllDayElement());
    if (json.has("availableStartTime"))
      res.setAvailableStartTimeElement(parseTime(json.get("availableStartTime").getAsString()));
    if (json.has("_availableStartTime"))
      parseElementProperties(getJObject(json, "_availableStartTime"), res.getAvailableStartTimeElement());
    if (json.has("availableEndTime"))
      res.setAvailableEndTimeElement(parseTime(json.get("availableEndTime").getAsString()));
    if (json.has("_availableEndTime"))
      parseElementProperties(getJObject(json, "_availableEndTime"), res.getAvailableEndTimeElement());
  }

  protected Availability.AvailabilityNotAvailableTimeComponent parseAvailabilityNotAvailableTimeComponent(JsonObject json) throws IOException, FHIRFormatError {
    Availability.AvailabilityNotAvailableTimeComponent res = new Availability.AvailabilityNotAvailableTimeComponent();
    parseAvailabilityNotAvailableTimeComponentProperties(json, res);
    return res;
  }

  protected void parseAvailabilityNotAvailableTimeComponentProperties(JsonObject json, Availability.AvailabilityNotAvailableTimeComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("during"))
      res.setDuring(parsePeriod(getJObject(json, "during")));
  }

  protected CodeableConcept parseCodeableConcept(JsonObject json) throws IOException, FHIRFormatError {
    CodeableConcept res = new CodeableConcept();
    parseCodeableConceptProperties(json, res);
    return res;
  }

  protected void parseCodeableConceptProperties(JsonObject json, CodeableConcept res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("coding")) {
      JsonArray array = getJArray(json, "coding");
      for (int i = 0; i < array.size(); i++) {
        res.getCoding().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected CodeableReference parseCodeableReference(JsonObject json) throws IOException, FHIRFormatError {
    CodeableReference res = new CodeableReference();
    parseCodeableReferenceProperties(json, res);
    return res;
  }

  protected void parseCodeableReferenceProperties(JsonObject json, CodeableReference res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("concept"))
      res.setConcept(parseCodeableConcept(getJObject(json, "concept")));
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
  }

  protected Coding parseCoding(JsonObject json) throws IOException, FHIRFormatError {
    Coding res = new Coding();
    parseCodingProperties(json, res);
    return res;
  }

  protected void parseCodingProperties(JsonObject json, Coding res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("userSelected"))
      res.setUserSelectedElement(parseBoolean(json.get("userSelected").getAsBoolean()));
    if (json.has("_userSelected"))
      parseElementProperties(getJObject(json, "_userSelected"), res.getUserSelectedElement());
  }

  protected ContactDetail parseContactDetail(JsonObject json) throws IOException, FHIRFormatError {
    ContactDetail res = new ContactDetail();
    parseContactDetailProperties(json, res);
    return res;
  }

  protected void parseContactDetailProperties(JsonObject json, ContactDetail res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("telecom")) {
      JsonArray array = getJArray(json, "telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ContactPoint parseContactPoint(JsonObject json) throws IOException, FHIRFormatError {
    ContactPoint res = new ContactPoint();
    parseContactPointProperties(json, res);
    return res;
  }

  protected void parseContactPointProperties(JsonObject json, ContactPoint res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("system"))
      res.setSystemElement(parseEnumeration(json.get("system").getAsString(), ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("rank"))
      res.setRankElement(parsePositiveInt(json.get("rank").getAsString()));
    if (json.has("_rank"))
      parseElementProperties(getJObject(json, "_rank"), res.getRankElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Contributor parseContributor(JsonObject json) throws IOException, FHIRFormatError {
    Contributor res = new Contributor();
    parseContributorProperties(json, res);
    return res;
  }

  protected void parseContributorProperties(JsonObject json, Contributor res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Count parseCount(JsonObject json) throws IOException, FHIRFormatError {
    Count res = new Count();
    parseCountProperties(json, res);
    return res;
  }

  protected void parseCountProperties(JsonObject json, Count res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected DataRequirement parseDataRequirement(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement res = new DataRequirement();
    parseDataRequirementProperties(json, res);
    return res;
  }

  protected void parseDataRequirementProperties(JsonObject json, DataRequirement res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.FHIRTypes.NULL, new Enumerations.FHIRTypesEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile")) {
      JsonArray array = getJArray(json, "profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {;
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = getJArray(json, "_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProfile().get(i));
      }
    };
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("mustSupport")) {
      JsonArray array = getJArray(json, "mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getMustSupport().add(new StringType());
        } else {;
          res.getMustSupport().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_mustSupport")) {
      JsonArray array = getJArray(json, "_mustSupport");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMustSupport().size())
          res.getMustSupport().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getMustSupport().get(i));
      }
    };
    if (json.has("codeFilter")) {
      JsonArray array = getJArray(json, "codeFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getCodeFilter().add(parseDataRequirementCodeFilterComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("dateFilter")) {
      JsonArray array = getJArray(json, "dateFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getDateFilter().add(parseDataRequirementDateFilterComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("valueFilter")) {
      JsonArray array = getJArray(json, "valueFilter");
      for (int i = 0; i < array.size(); i++) {
        res.getValueFilter().add(parseDataRequirementValueFilterComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("limit"))
      res.setLimitElement(parsePositiveInt(json.get("limit").getAsString()));
    if (json.has("_limit"))
      parseElementProperties(getJObject(json, "_limit"), res.getLimitElement());
    if (json.has("sort")) {
      JsonArray array = getJArray(json, "sort");
      for (int i = 0; i < array.size(); i++) {
        res.getSort().add(parseDataRequirementSortComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementCodeFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
    parseDataRequirementCodeFilterComponentProperties(json, res);
    return res;
  }

  protected void parseDataRequirementCodeFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementCodeFilterComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(getJObject(json, "_searchParam"), res.getSearchParamElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("code")) {
      JsonArray array = getJArray(json, "code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDateFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
    parseDataRequirementDateFilterComponentProperties(json, res);
    return res;
  }

  protected void parseDataRequirementDateFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementDateFilterComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(getJObject(json, "_searchParam"), res.getSearchParamElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DataRequirement.DataRequirementValueFilterComponent parseDataRequirementValueFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementValueFilterComponent res = new DataRequirement.DataRequirementValueFilterComponent();
    parseDataRequirementValueFilterComponentProperties(json, res);
    return res;
  }

  protected void parseDataRequirementValueFilterComponentProperties(JsonObject json, DataRequirement.DataRequirementValueFilterComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("searchParam"))
      res.setSearchParamElement(parseString(json.get("searchParam").getAsString()));
    if (json.has("_searchParam"))
      parseElementProperties(getJObject(json, "_searchParam"), res.getSearchParamElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), DataRequirement.ValueFilterComparator.NULL, new DataRequirement.ValueFilterComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(getJObject(json, "_comparator"), res.getComparatorElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DataRequirement.DataRequirementSortComponent parseDataRequirementSortComponent(JsonObject json) throws IOException, FHIRFormatError {
    DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
    parseDataRequirementSortComponentProperties(json, res);
    return res;
  }

  protected void parseDataRequirementSortComponentProperties(JsonObject json, DataRequirement.DataRequirementSortComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("direction"))
      res.setDirectionElement(parseEnumeration(json.get("direction").getAsString(), DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
    if (json.has("_direction"))
      parseElementProperties(getJObject(json, "_direction"), res.getDirectionElement());
  }

  protected Distance parseDistance(JsonObject json) throws IOException, FHIRFormatError {
    Distance res = new Distance();
    parseDistanceProperties(json, res);
    return res;
  }

  protected void parseDistanceProperties(JsonObject json, Distance res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected Dosage parseDosage(JsonObject json) throws IOException, FHIRFormatError {
    Dosage res = new Dosage();
    parseDosageProperties(json, res);
    return res;
  }

  protected void parseDosageProperties(JsonObject json, Dosage res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parseInteger(json.get("sequence").getAsLong()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("additionalInstruction")) {
      JsonArray array = getJArray(json, "additionalInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalInstruction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patientInstruction"))
      res.setPatientInstructionElement(parseString(json.get("patientInstruction").getAsString()));
    if (json.has("_patientInstruction"))
      parseElementProperties(getJObject(json, "_patientInstruction"), res.getPatientInstructionElement());
    if (json.has("timing"))
      res.setTiming(parseTiming(getJObject(json, "timing")));
    if (json.has("asNeeded"))
      res.setAsNeededElement(parseBoolean(json.get("asNeeded").getAsBoolean()));
    if (json.has("_asNeeded"))
      parseElementProperties(getJObject(json, "_asNeeded"), res.getAsNeededElement());
    if (json.has("asNeededFor")) {
      JsonArray array = getJArray(json, "asNeededFor");
      for (int i = 0; i < array.size(); i++) {
        res.getAsNeededFor().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("site"))
      res.setSite(parseCodeableConcept(getJObject(json, "site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(getJObject(json, "route")));
    if (json.has("method"))
      res.setMethod(parseCodeableConcept(getJObject(json, "method")));
    if (json.has("doseAndRate")) {
      JsonArray array = getJArray(json, "doseAndRate");
      for (int i = 0; i < array.size(); i++) {
        res.getDoseAndRate().add(parseDosageDoseAndRateComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("maxDosePerPeriod")) {
      JsonArray array = getJArray(json, "maxDosePerPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getMaxDosePerPeriod().add(parseRatio(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("maxDosePerAdministration"))
      res.setMaxDosePerAdministration(parseQuantity(getJObject(json, "maxDosePerAdministration")));
    if (json.has("maxDosePerLifetime"))
      res.setMaxDosePerLifetime(parseQuantity(getJObject(json, "maxDosePerLifetime")));
  }

  protected Dosage.DosageDoseAndRateComponent parseDosageDoseAndRateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
    parseDosageDoseAndRateComponentProperties(json, res);
    return res;
  }

  protected void parseDosageDoseAndRateComponentProperties(JsonObject json, Dosage.DosageDoseAndRateComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType dose = parseType("dose", json);
    if (dose != null)
      res.setDose(dose);
    DataType rate = parseType("rate", json);
    if (rate != null)
      res.setRate(rate);
  }

  protected Duration parseDuration(JsonObject json) throws IOException, FHIRFormatError {
    Duration res = new Duration();
    parseDurationProperties(json, res);
    return res;
  }

  protected void parseDurationProperties(JsonObject json, Duration res) throws IOException, FHIRFormatError {
    parseQuantityProperties(json, res);
  }

  protected ElementDefinition parseElementDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition res = new ElementDefinition();
    parseElementDefinitionProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionProperties(JsonObject json, ElementDefinition res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("representation")) {
      JsonArray array = getJArray(json, "representation");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getRepresentation().add(new Enumeration<ElementDefinition.PropertyRepresentation>(new ElementDefinition.PropertyRepresentationEnumFactory(), ElementDefinition.PropertyRepresentation.NULL));
        } else {;
          res.getRepresentation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        }
      }
    };
    if (json.has("_representation")) {
      JsonArray array = getJArray(json, "_representation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRepresentation().size())
          res.getRepresentation().add(parseEnumeration(null, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getRepresentation().get(i));
      }
    };
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(getJObject(json, "_sliceName"), res.getSliceNameElement());
    if (json.has("sliceIsConstraining"))
      res.setSliceIsConstrainingElement(parseBoolean(json.get("sliceIsConstraining").getAsBoolean()));
    if (json.has("_sliceIsConstraining"))
      parseElementProperties(getJObject(json, "_sliceIsConstraining"), res.getSliceIsConstrainingElement());
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(getJObject(json, "_label"), res.getLabelElement());
    if (json.has("code")) {
      JsonArray array = getJArray(json, "code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("slicing"))
      res.setSlicing(parseElementDefinitionSlicingComponent(getJObject(json, "slicing")));
    if (json.has("short"))
      res.setShortElement(parseString(json.get("short").getAsString()));
    if (json.has("_short"))
      parseElementProperties(getJObject(json, "_short"), res.getShortElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseMarkdown(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseMarkdown(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(getJObject(json, "_requirements"), res.getRequirementsElement());
    if (json.has("alias")) {
      JsonArray array = getJArray(json, "alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {;
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = getJArray(json, "_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getAlias().get(i));
      }
    };
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
    if (json.has("base"))
      res.setBase(parseElementDefinitionBaseComponent(getJObject(json, "base")));
    if (json.has("contentReference"))
      res.setContentReferenceElement(parseUri(json.get("contentReference").getAsString()));
    if (json.has("_contentReference"))
      parseElementProperties(getJObject(json, "_contentReference"), res.getContentReferenceElement());
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseElementDefinitionTypeRefComponent(getJsonObjectFromArray(array, i)));
      }
    };
    DataType defaultValue = parseType("defaultValue", json);
    if (defaultValue != null)
      res.setDefaultValue(defaultValue);
    if (json.has("meaningWhenMissing"))
      res.setMeaningWhenMissingElement(parseMarkdown(json.get("meaningWhenMissing").getAsString()));
    if (json.has("_meaningWhenMissing"))
      parseElementProperties(getJObject(json, "_meaningWhenMissing"), res.getMeaningWhenMissingElement());
    if (json.has("orderMeaning"))
      res.setOrderMeaningElement(parseString(json.get("orderMeaning").getAsString()));
    if (json.has("_orderMeaning"))
      parseElementProperties(getJObject(json, "_orderMeaning"), res.getOrderMeaningElement());
    DataType fixed = parseType("fixed", json);
    if (fixed != null)
      res.setFixed(fixed);
    DataType pattern = parseType("pattern", json);
    if (pattern != null)
      res.setPattern(pattern);
    if (json.has("example")) {
      JsonArray array = getJArray(json, "example");
      for (int i = 0; i < array.size(); i++) {
        res.getExample().add(parseElementDefinitionExampleComponent(getJsonObjectFromArray(array, i)));
      }
    };
    DataType minValue = parseType("minValue", json);
    if (minValue != null)
      res.setMinValue(minValue);
    DataType maxValue = parseType("maxValue", json);
    if (maxValue != null)
      res.setMaxValue(maxValue);
    if (json.has("maxLength"))
      res.setMaxLengthElement(parseInteger(json.get("maxLength").getAsLong()));
    if (json.has("_maxLength"))
      parseElementProperties(getJObject(json, "_maxLength"), res.getMaxLengthElement());
    if (json.has("condition")) {
      JsonArray array = getJArray(json, "condition");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCondition().add(new IdType());
        } else {;
          res.getCondition().add(parseId(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_condition")) {
      JsonArray array = getJArray(json, "_condition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCondition().size())
          res.getCondition().add(parseId(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getCondition().get(i));
      }
    };
    if (json.has("constraint")) {
      JsonArray array = getJArray(json, "constraint");
      for (int i = 0; i < array.size(); i++) {
        res.getConstraint().add(parseElementDefinitionConstraintComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("mustHaveValue"))
      res.setMustHaveValueElement(parseBoolean(json.get("mustHaveValue").getAsBoolean()));
    if (json.has("_mustHaveValue"))
      parseElementProperties(getJObject(json, "_mustHaveValue"), res.getMustHaveValueElement());
    if (json.has("valueAlternatives")) {
      JsonArray array = getJArray(json, "valueAlternatives");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getValueAlternatives().add(new CanonicalType());
        } else {;
          res.getValueAlternatives().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_valueAlternatives")) {
      JsonArray array = getJArray(json, "_valueAlternatives");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getValueAlternatives().size())
          res.getValueAlternatives().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getValueAlternatives().get(i));
      }
    };
    if (json.has("mustSupport"))
      res.setMustSupportElement(parseBoolean(json.get("mustSupport").getAsBoolean()));
    if (json.has("_mustSupport"))
      parseElementProperties(getJObject(json, "_mustSupport"), res.getMustSupportElement());
    if (json.has("isModifier"))
      res.setIsModifierElement(parseBoolean(json.get("isModifier").getAsBoolean()));
    if (json.has("_isModifier"))
      parseElementProperties(getJObject(json, "_isModifier"), res.getIsModifierElement());
    if (json.has("isModifierReason"))
      res.setIsModifierReasonElement(parseString(json.get("isModifierReason").getAsString()));
    if (json.has("_isModifierReason"))
      parseElementProperties(getJObject(json, "_isModifierReason"), res.getIsModifierReasonElement());
    if (json.has("isSummary"))
      res.setIsSummaryElement(parseBoolean(json.get("isSummary").getAsBoolean()));
    if (json.has("_isSummary"))
      parseElementProperties(getJObject(json, "_isSummary"), res.getIsSummaryElement());
    if (json.has("binding"))
      res.setBinding(parseElementDefinitionBindingComponent(getJObject(json, "binding")));
    if (json.has("mapping")) {
      JsonArray array = getJArray(json, "mapping");
      for (int i = 0; i < array.size(); i++) {
        res.getMapping().add(parseElementDefinitionMappingComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionSlicingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
    parseElementDefinitionSlicingComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionSlicingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionSlicingComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("discriminator")) {
      JsonArray array = getJArray(json, "discriminator");
      for (int i = 0; i < array.size(); i++) {
        res.getDiscriminator().add(parseElementDefinitionSlicingDiscriminatorComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("ordered"))
      res.setOrderedElement(parseBoolean(json.get("ordered").getAsBoolean()));
    if (json.has("_ordered"))
      parseElementProperties(getJObject(json, "_ordered"), res.getOrderedElement());
    if (json.has("rules"))
      res.setRulesElement(parseEnumeration(json.get("rules").getAsString(), ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
    if (json.has("_rules"))
      parseElementProperties(getJObject(json, "_rules"), res.getRulesElement());
  }

  protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionSlicingDiscriminatorComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
    parseElementDefinitionSlicingDiscriminatorComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionSlicingDiscriminatorComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
  }

  protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionBaseComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
    parseElementDefinitionBaseComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionBaseComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBaseComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("min"))
      res.setMinElement(parseUnsignedInt(json.get("min").getAsString()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
  }

  protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
    parseElementDefinitionTypeRefComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionTypeRefComponentProperties(JsonObject json, ElementDefinition.TypeRefComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseUri(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("profile")) {
      JsonArray array = getJArray(json, "profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {;
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = getJArray(json, "_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProfile().get(i));
      }
    };
    if (json.has("targetProfile")) {
      JsonArray array = getJArray(json, "targetProfile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getTargetProfile().add(new CanonicalType());
        } else {;
          res.getTargetProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_targetProfile")) {
      JsonArray array = getJArray(json, "_targetProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTargetProfile().size())
          res.getTargetProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getTargetProfile().get(i));
      }
    };
    if (json.has("aggregation")) {
      JsonArray array = getJArray(json, "aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAggregation().add(new Enumeration<ElementDefinition.AggregationMode>(new ElementDefinition.AggregationModeEnumFactory(), ElementDefinition.AggregationMode.NULL));
        } else {;
          res.getAggregation().add(parseEnumeration(array.get(i).getAsString(), ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        }
      }
    };
    if (json.has("_aggregation")) {
      JsonArray array = getJArray(json, "_aggregation");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAggregation().size())
          res.getAggregation().add(parseEnumeration(null, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getAggregation().get(i));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(getJObject(json, "_versioning"), res.getVersioningElement());
  }

  protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionExampleComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
    parseElementDefinitionExampleComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionExampleComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionExampleComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(getJObject(json, "_label"), res.getLabelElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionConstraintComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
    parseElementDefinitionConstraintComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionConstraintComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionConstraintComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseId(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(getJObject(json, "_key"), res.getKeyElement());
    if (json.has("requirements"))
      res.setRequirementsElement(parseMarkdown(json.get("requirements").getAsString()));
    if (json.has("_requirements"))
      parseElementProperties(getJObject(json, "_requirements"), res.getRequirementsElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(getJObject(json, "_severity"), res.getSeverityElement());
    if (json.has("suppress"))
      res.setSuppressElement(parseBoolean(json.get("suppress").getAsBoolean()));
    if (json.has("_suppress"))
      parseElementProperties(getJObject(json, "_suppress"), res.getSuppressElement());
    if (json.has("human"))
      res.setHumanElement(parseString(json.get("human").getAsString()));
    if (json.has("_human"))
      parseElementProperties(getJObject(json, "_human"), res.getHumanElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(getJObject(json, "_expression"), res.getExpressionElement());
    if (json.has("source"))
      res.setSourceElement(parseCanonical(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
  }

  protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionBindingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
    parseElementDefinitionBindingComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionBindingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBindingComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("strength"))
      res.setStrengthElement(parseEnumeration(json.get("strength").getAsString(), Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
    if (json.has("_strength"))
      parseElementProperties(getJObject(json, "_strength"), res.getStrengthElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("additional")) {
      JsonArray array = getJArray(json, "additional");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditional().add(parseElementDefinitionBindingAdditionalComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ElementDefinition.ElementDefinitionBindingAdditionalComponent parseElementDefinitionBindingAdditionalComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionBindingAdditionalComponent res = new ElementDefinition.ElementDefinitionBindingAdditionalComponent();
    parseElementDefinitionBindingAdditionalComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionBindingAdditionalComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionBindingAdditionalComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("purpose"))
      res.setPurposeElement(parseEnumeration(json.get("purpose").getAsString(), ElementDefinition.AdditionalBindingPurposeVS.NULL, new ElementDefinition.AdditionalBindingPurposeVSEnumFactory()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("shortDoco"))
      res.setShortDocoElement(parseString(json.get("shortDoco").getAsString()));
    if (json.has("_shortDoco"))
      parseElementProperties(getJObject(json, "_shortDoco"), res.getShortDocoElement());
    if (json.has("usage")) {
      JsonArray array = getJArray(json, "usage");
      for (int i = 0; i < array.size(); i++) {
        res.getUsage().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("any"))
      res.setAnyElement(parseBoolean(json.get("any").getAsBoolean()));
    if (json.has("_any"))
      parseElementProperties(getJObject(json, "_any"), res.getAnyElement());
  }

  protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionMappingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
    parseElementDefinitionMappingComponentProperties(json, res);
    return res;
  }

  protected void parseElementDefinitionMappingComponentProperties(JsonObject json, ElementDefinition.ElementDefinitionMappingComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    if (json.has("identity"))
      res.setIdentityElement(parseId(json.get("identity").getAsString()));
    if (json.has("_identity"))
      parseElementProperties(getJObject(json, "_identity"), res.getIdentityElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("map"))
      res.setMapElement(parseString(json.get("map").getAsString()));
    if (json.has("_map"))
      parseElementProperties(getJObject(json, "_map"), res.getMapElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
  }

  protected Expression parseExpression(JsonObject json) throws IOException, FHIRFormatError {
    Expression res = new Expression();
    parseExpressionProperties(json, res);
    return res;
  }

  protected void parseExpressionProperties(JsonObject json, Expression res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(getJObject(json, "_expression"), res.getExpressionElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(getJObject(json, "_reference"), res.getReferenceElement());
  }

  protected ExtendedContactDetail parseExtendedContactDetail(JsonObject json) throws IOException, FHIRFormatError {
    ExtendedContactDetail res = new ExtendedContactDetail();
    parseExtendedContactDetailProperties(json, res);
    return res;
  }

  protected void parseExtendedContactDetailProperties(JsonObject json, ExtendedContactDetail res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("purpose"))
      res.setPurpose(parseCodeableConcept(getJObject(json, "purpose")));
    if (json.has("name")) {
      JsonArray array = getJArray(json, "name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseHumanName(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = getJArray(json, "telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("address"))
      res.setAddress(parseAddress(getJObject(json, "address")));
    if (json.has("organization"))
      res.setOrganization(parseReference(getJObject(json, "organization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Extension parseExtension(JsonObject json) throws IOException, FHIRFormatError {
    Extension res = new Extension();
    parseExtensionProperties(json, res);
    return res;
  }

  protected void parseExtensionProperties(JsonObject json, Extension res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected HumanName parseHumanName(JsonObject json) throws IOException, FHIRFormatError {
    HumanName res = new HumanName();
    parseHumanNameProperties(json, res);
    return res;
  }

  protected void parseHumanNameProperties(JsonObject json, HumanName res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("family"))
      res.setFamilyElement(parseString(json.get("family").getAsString()));
    if (json.has("_family"))
      parseElementProperties(getJObject(json, "_family"), res.getFamilyElement());
    if (json.has("given")) {
      JsonArray array = getJArray(json, "given");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getGiven().add(new StringType());
        } else {;
          res.getGiven().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_given")) {
      JsonArray array = getJArray(json, "_given");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getGiven().size())
          res.getGiven().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getGiven().get(i));
      }
    };
    if (json.has("prefix")) {
      JsonArray array = getJArray(json, "prefix");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPrefix().add(new StringType());
        } else {;
          res.getPrefix().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_prefix")) {
      JsonArray array = getJArray(json, "_prefix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPrefix().size())
          res.getPrefix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPrefix().get(i));
      }
    };
    if (json.has("suffix")) {
      JsonArray array = getJArray(json, "suffix");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSuffix().add(new StringType());
        } else {;
          res.getSuffix().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_suffix")) {
      JsonArray array = getJArray(json, "_suffix");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSuffix().size())
          res.getSuffix().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSuffix().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Identifier parseIdentifier(JsonObject json) throws IOException, FHIRFormatError {
    Identifier res = new Identifier();
    parseIdentifierProperties(json, res);
    return res;
  }

  protected void parseIdentifierProperties(JsonObject json, Identifier res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("assigner"))
      res.setAssigner(parseReference(getJObject(json, "assigner")));
  }

  protected MarketingStatus parseMarketingStatus(JsonObject json) throws IOException, FHIRFormatError {
    MarketingStatus res = new MarketingStatus();
    parseMarketingStatusProperties(json, res);
    return res;
  }

  protected void parseMarketingStatusProperties(JsonObject json, MarketingStatus res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("country"))
      res.setCountry(parseCodeableConcept(getJObject(json, "country")));
    if (json.has("jurisdiction"))
      res.setJurisdiction(parseCodeableConcept(getJObject(json, "jurisdiction")));
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("dateRange"))
      res.setDateRange(parsePeriod(getJObject(json, "dateRange")));
    if (json.has("restoreDate"))
      res.setRestoreDateElement(parseDateTime(json.get("restoreDate").getAsString()));
    if (json.has("_restoreDate"))
      parseElementProperties(getJObject(json, "_restoreDate"), res.getRestoreDateElement());
  }

  protected Meta parseMeta(JsonObject json) throws IOException, FHIRFormatError {
    Meta res = new Meta();
    parseMetaProperties(json, res);
    return res;
  }

  protected void parseMetaProperties(JsonObject json, Meta res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("versionId"))
      res.setVersionIdElement(parseId(json.get("versionId").getAsString()));
    if (json.has("_versionId"))
      parseElementProperties(getJObject(json, "_versionId"), res.getVersionIdElement());
    if (json.has("lastUpdated"))
      res.setLastUpdatedElement(parseInstant(json.get("lastUpdated").getAsString()));
    if (json.has("_lastUpdated"))
      parseElementProperties(getJObject(json, "_lastUpdated"), res.getLastUpdatedElement());
    if (json.has("source"))
      res.setSourceElement(parseUri(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
    if (json.has("profile")) {
      JsonArray array = getJArray(json, "profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {;
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = getJArray(json, "_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProfile().get(i));
      }
    };
    if (json.has("security")) {
      JsonArray array = getJArray(json, "security");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurity().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("tag")) {
      JsonArray array = getJArray(json, "tag");
      for (int i = 0; i < array.size(); i++) {
        res.getTag().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected MonetaryComponent parseMonetaryComponent(JsonObject json) throws IOException, FHIRFormatError {
    MonetaryComponent res = new MonetaryComponent();
    parseMonetaryComponentProperties(json, res);
    return res;
  }

  protected void parseMonetaryComponentProperties(JsonObject json, MonetaryComponent res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), MonetaryComponent.PriceComponentType.NULL, new MonetaryComponent.PriceComponentTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
  }

  protected Money parseMoney(JsonObject json) throws IOException, FHIRFormatError {
    Money res = new Money();
    parseMoneyProperties(json, res);
    return res;
  }

  protected void parseMoneyProperties(JsonObject json, Money res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("currency"))
      res.setCurrencyElement(parseCode(json.get("currency").getAsString()));
    if (json.has("_currency"))
      parseElementProperties(getJObject(json, "_currency"), res.getCurrencyElement());
  }

  protected Narrative parseNarrative(JsonObject json) throws IOException, FHIRFormatError {
    Narrative res = new Narrative();
    parseNarrativeProperties(json, res);
    return res;
  }

  protected void parseNarrativeProperties(JsonObject json, Narrative res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("div"))
      res.setDiv(parseXhtml(json.get("div").getAsString()));
  }

  protected ParameterDefinition parseParameterDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ParameterDefinition res = new ParameterDefinition();
    parseParameterDefinitionProperties(json, res);
    return res;
  }

  protected void parseParameterDefinitionProperties(JsonObject json, ParameterDefinition res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseCode(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Enumerations.OperationParameterUse.NULL, new Enumerations.OperationParameterUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.FHIRTypes.NULL, new Enumerations.FHIRTypesEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
  }

  protected Period parsePeriod(JsonObject json) throws IOException, FHIRFormatError {
    Period res = new Period();
    parsePeriodProperties(json, res);
    return res;
  }

  protected void parsePeriodProperties(JsonObject json, Period res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("start"))
      res.setStartElement(parseDateTime(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseDateTime(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
  }

  protected ProductShelfLife parseProductShelfLife(JsonObject json) throws IOException, FHIRFormatError {
    ProductShelfLife res = new ProductShelfLife();
    parseProductShelfLifeProperties(json, res);
    return res;
  }

  protected void parseProductShelfLifeProperties(JsonObject json, ProductShelfLife res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType period = parseType("period", json);
    if (period != null)
      res.setPeriod(period);
    if (json.has("specialPrecautionsForStorage")) {
      JsonArray array = getJArray(json, "specialPrecautionsForStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialPrecautionsForStorage().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Quantity parseQuantity(JsonObject json) throws IOException, FHIRFormatError {
    Quantity res = new Quantity();
    parseQuantityProperties(json, res);
    return res;
  }

  protected void parseQuantityProperties(JsonObject json, Quantity res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseDecimal(json.get("value").getAsBigDecimal()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("comparator"))
      res.setComparatorElement(parseEnumeration(json.get("comparator").getAsString(), Enumerations.QuantityComparator.NULL, new Enumerations.QuantityComparatorEnumFactory()));
    if (json.has("_comparator"))
      parseElementProperties(getJObject(json, "_comparator"), res.getComparatorElement());
    if (json.has("unit"))
      res.setUnitElement(parseString(json.get("unit").getAsString()));
    if (json.has("_unit"))
      parseElementProperties(getJObject(json, "_unit"), res.getUnitElement());
    if (json.has("system"))
      res.setSystemElement(parseUri(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
  }

  protected Range parseRange(JsonObject json) throws IOException, FHIRFormatError {
    Range res = new Range();
    parseRangeProperties(json, res);
    return res;
  }

  protected void parseRangeProperties(JsonObject json, Range res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("low"))
      res.setLow(parseQuantity(getJObject(json, "low")));
    if (json.has("high"))
      res.setHigh(parseQuantity(getJObject(json, "high")));
  }

  protected Ratio parseRatio(JsonObject json) throws IOException, FHIRFormatError {
    Ratio res = new Ratio();
    parseRatioProperties(json, res);
    return res;
  }

  protected void parseRatioProperties(JsonObject json, Ratio res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("numerator"))
      res.setNumerator(parseQuantity(getJObject(json, "numerator")));
    if (json.has("denominator"))
      res.setDenominator(parseQuantity(getJObject(json, "denominator")));
  }

  protected RatioRange parseRatioRange(JsonObject json) throws IOException, FHIRFormatError {
    RatioRange res = new RatioRange();
    parseRatioRangeProperties(json, res);
    return res;
  }

  protected void parseRatioRangeProperties(JsonObject json, RatioRange res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("lowNumerator"))
      res.setLowNumerator(parseQuantity(getJObject(json, "lowNumerator")));
    if (json.has("highNumerator"))
      res.setHighNumerator(parseQuantity(getJObject(json, "highNumerator")));
    if (json.has("denominator"))
      res.setDenominator(parseQuantity(getJObject(json, "denominator")));
  }

  protected Reference parseReference(JsonObject json) throws IOException, FHIRFormatError {
    Reference res = new Reference();
    parseReferenceProperties(json, res);
    return res;
  }

  protected void parseReferenceProperties(JsonObject json, Reference res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("reference"))
      res.setReferenceElement(parseString(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(getJObject(json, "_reference"), res.getReferenceElement());
    if (json.has("type"))
      res.setTypeElement(parseUri(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
  }

  protected RelatedArtifact parseRelatedArtifact(JsonObject json) throws IOException, FHIRFormatError {
    RelatedArtifact res = new RelatedArtifact();
    parseRelatedArtifactProperties(json, res);
    return res;
  }

  protected void parseRelatedArtifactProperties(JsonObject json, RelatedArtifact res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("classifier")) {
      JsonArray array = getJArray(json, "classifier");
      for (int i = 0; i < array.size(); i++) {
        res.getClassifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(getJObject(json, "_label"), res.getLabelElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("citation"))
      res.setCitationElement(parseMarkdown(json.get("citation").getAsString()));
    if (json.has("_citation"))
      parseElementProperties(getJObject(json, "_citation"), res.getCitationElement());
    if (json.has("document"))
      res.setDocument(parseAttachment(getJObject(json, "document")));
    if (json.has("resource"))
      res.setResourceElement(parseCanonical(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(getJObject(json, "_resource"), res.getResourceElement());
    if (json.has("resourceReference"))
      res.setResourceReference(parseReference(getJObject(json, "resourceReference")));
    if (json.has("publicationStatus"))
      res.setPublicationStatusElement(parseEnumeration(json.get("publicationStatus").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_publicationStatus"))
      parseElementProperties(getJObject(json, "_publicationStatus"), res.getPublicationStatusElement());
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDate(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(getJObject(json, "_publicationDate"), res.getPublicationDateElement());
  }

  protected SampledData parseSampledData(JsonObject json) throws IOException, FHIRFormatError {
    SampledData res = new SampledData();
    parseSampledDataProperties(json, res);
    return res;
  }

  protected void parseSampledDataProperties(JsonObject json, SampledData res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("origin"))
      res.setOrigin(parseQuantity(getJObject(json, "origin")));
    if (json.has("interval"))
      res.setIntervalElement(parseDecimal(json.get("interval").getAsBigDecimal()));
    if (json.has("_interval"))
      parseElementProperties(getJObject(json, "_interval"), res.getIntervalElement());
    if (json.has("intervalUnit"))
      res.setIntervalUnitElement(parseCode(json.get("intervalUnit").getAsString()));
    if (json.has("_intervalUnit"))
      parseElementProperties(getJObject(json, "_intervalUnit"), res.getIntervalUnitElement());
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("lowerLimit"))
      res.setLowerLimitElement(parseDecimal(json.get("lowerLimit").getAsBigDecimal()));
    if (json.has("_lowerLimit"))
      parseElementProperties(getJObject(json, "_lowerLimit"), res.getLowerLimitElement());
    if (json.has("upperLimit"))
      res.setUpperLimitElement(parseDecimal(json.get("upperLimit").getAsBigDecimal()));
    if (json.has("_upperLimit"))
      parseElementProperties(getJObject(json, "_upperLimit"), res.getUpperLimitElement());
    if (json.has("dimensions"))
      res.setDimensionsElement(parsePositiveInt(json.get("dimensions").getAsString()));
    if (json.has("_dimensions"))
      parseElementProperties(getJObject(json, "_dimensions"), res.getDimensionsElement());
    if (json.has("codeMap"))
      res.setCodeMapElement(parseCanonical(json.get("codeMap").getAsString()));
    if (json.has("_codeMap"))
      parseElementProperties(getJObject(json, "_codeMap"), res.getCodeMapElement());
    if (json.has("offsets"))
      res.setOffsetsElement(parseString(json.get("offsets").getAsString()));
    if (json.has("_offsets"))
      parseElementProperties(getJObject(json, "_offsets"), res.getOffsetsElement());
    if (json.has("data"))
      res.setDataElement(parseString(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(getJObject(json, "_data"), res.getDataElement());
  }

  protected Signature parseSignature(JsonObject json) throws IOException, FHIRFormatError {
    Signature res = new Signature();
    parseSignatureProperties(json, res);
    return res;
  }

  protected void parseSignatureProperties(JsonObject json, Signature res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("when"))
      res.setWhenElement(parseInstant(json.get("when").getAsString()));
    if (json.has("_when"))
      parseElementProperties(getJObject(json, "_when"), res.getWhenElement());
    if (json.has("who"))
      res.setWho(parseReference(getJObject(json, "who")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(getJObject(json, "onBehalfOf")));
    if (json.has("targetFormat"))
      res.setTargetFormatElement(parseCode(json.get("targetFormat").getAsString()));
    if (json.has("_targetFormat"))
      parseElementProperties(getJObject(json, "_targetFormat"), res.getTargetFormatElement());
    if (json.has("sigFormat"))
      res.setSigFormatElement(parseCode(json.get("sigFormat").getAsString()));
    if (json.has("_sigFormat"))
      parseElementProperties(getJObject(json, "_sigFormat"), res.getSigFormatElement());
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(getJObject(json, "_data"), res.getDataElement());
  }

  protected Timing parseTiming(JsonObject json) throws IOException, FHIRFormatError {
    Timing res = new Timing();
    parseTimingProperties(json, res);
    return res;
  }

  protected void parseTimingProperties(JsonObject json, Timing res) throws IOException, FHIRFormatError {
    parseBackboneTypeProperties(json, res);
    if (json.has("event")) {
      JsonArray array = getJArray(json, "event");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getEvent().add(new DateTimeType());
        } else {;
          res.getEvent().add(parseDateTime(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_event")) {
      JsonArray array = getJArray(json, "_event");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getEvent().size())
          res.getEvent().add(parseDateTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getEvent().get(i));
      }
    };
    if (json.has("repeat"))
      res.setRepeat(parseTimingRepeatComponent(getJObject(json, "repeat")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected Timing.TimingRepeatComponent parseTimingRepeatComponent(JsonObject json) throws IOException, FHIRFormatError {
    Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
    parseTimingRepeatComponentProperties(json, res);
    return res;
  }

  protected void parseTimingRepeatComponentProperties(JsonObject json, Timing.TimingRepeatComponent res) throws IOException, FHIRFormatError {
    parseElementProperties(json, res);
    DataType bounds = parseType("bounds", json);
    if (bounds != null)
      res.setBounds(bounds);
    if (json.has("count"))
      res.setCountElement(parsePositiveInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(getJObject(json, "_count"), res.getCountElement());
    if (json.has("countMax"))
      res.setCountMaxElement(parsePositiveInt(json.get("countMax").getAsString()));
    if (json.has("_countMax"))
      parseElementProperties(getJObject(json, "_countMax"), res.getCountMaxElement());
    if (json.has("duration"))
      res.setDurationElement(parseDecimal(json.get("duration").getAsBigDecimal()));
    if (json.has("_duration"))
      parseElementProperties(getJObject(json, "_duration"), res.getDurationElement());
    if (json.has("durationMax"))
      res.setDurationMaxElement(parseDecimal(json.get("durationMax").getAsBigDecimal()));
    if (json.has("_durationMax"))
      parseElementProperties(getJObject(json, "_durationMax"), res.getDurationMaxElement());
    if (json.has("durationUnit"))
      res.setDurationUnitElement(parseEnumeration(json.get("durationUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_durationUnit"))
      parseElementProperties(getJObject(json, "_durationUnit"), res.getDurationUnitElement());
    if (json.has("frequency"))
      res.setFrequencyElement(parsePositiveInt(json.get("frequency").getAsString()));
    if (json.has("_frequency"))
      parseElementProperties(getJObject(json, "_frequency"), res.getFrequencyElement());
    if (json.has("frequencyMax"))
      res.setFrequencyMaxElement(parsePositiveInt(json.get("frequencyMax").getAsString()));
    if (json.has("_frequencyMax"))
      parseElementProperties(getJObject(json, "_frequencyMax"), res.getFrequencyMaxElement());
    if (json.has("period"))
      res.setPeriodElement(parseDecimal(json.get("period").getAsBigDecimal()));
    if (json.has("_period"))
      parseElementProperties(getJObject(json, "_period"), res.getPeriodElement());
    if (json.has("periodMax"))
      res.setPeriodMaxElement(parseDecimal(json.get("periodMax").getAsBigDecimal()));
    if (json.has("_periodMax"))
      parseElementProperties(getJObject(json, "_periodMax"), res.getPeriodMaxElement());
    if (json.has("periodUnit"))
      res.setPeriodUnitElement(parseEnumeration(json.get("periodUnit").getAsString(), Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
    if (json.has("_periodUnit"))
      parseElementProperties(getJObject(json, "_periodUnit"), res.getPeriodUnitElement());
    if (json.has("dayOfWeek")) {
      JsonArray array = getJArray(json, "dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDayOfWeek().add(new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory(), Enumerations.DaysOfWeek.NULL));
        } else {;
          res.getDayOfWeek().add(parseEnumeration(array.get(i).getAsString(), Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        }
      }
    };
    if (json.has("_dayOfWeek")) {
      JsonArray array = getJArray(json, "_dayOfWeek");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDayOfWeek().size())
          res.getDayOfWeek().add(parseEnumeration(null, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDayOfWeek().get(i));
      }
    };
    if (json.has("timeOfDay")) {
      JsonArray array = getJArray(json, "timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getTimeOfDay().add(new TimeType());
        } else {;
          res.getTimeOfDay().add(parseTime(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_timeOfDay")) {
      JsonArray array = getJArray(json, "_timeOfDay");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getTimeOfDay().size())
          res.getTimeOfDay().add(parseTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getTimeOfDay().get(i));
      }
    };
    if (json.has("when")) {
      JsonArray array = getJArray(json, "when");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getWhen().add(new Enumeration<Timing.EventTiming>(new Timing.EventTimingEnumFactory(), Timing.EventTiming.NULL));
        } else {;
          res.getWhen().add(parseEnumeration(array.get(i).getAsString(), Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        }
      }
    };
    if (json.has("_when")) {
      JsonArray array = getJArray(json, "_when");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getWhen().size())
          res.getWhen().add(parseEnumeration(null, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getWhen().get(i));
      }
    };
    if (json.has("offset"))
      res.setOffsetElement(parseUnsignedInt(json.get("offset").getAsString()));
    if (json.has("_offset"))
      parseElementProperties(getJObject(json, "_offset"), res.getOffsetElement());
  }

  protected TriggerDefinition parseTriggerDefinition(JsonObject json) throws IOException, FHIRFormatError {
    TriggerDefinition res = new TriggerDefinition();
    parseTriggerDefinitionProperties(json, res);
    return res;
  }

  protected void parseTriggerDefinitionProperties(JsonObject json, TriggerDefinition res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subscriptionTopic"))
      res.setSubscriptionTopicElement(parseCanonical(json.get("subscriptionTopic").getAsString()));
    if (json.has("_subscriptionTopic"))
      parseElementProperties(getJObject(json, "_subscriptionTopic"), res.getSubscriptionTopicElement());
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("data")) {
      JsonArray array = getJArray(json, "data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseDataRequirement(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("condition"))
      res.setCondition(parseExpression(getJObject(json, "condition")));
  }

  protected UsageContext parseUsageContext(JsonObject json) throws IOException, FHIRFormatError {
    UsageContext res = new UsageContext();
    parseUsageContextProperties(json, res);
    return res;
  }

  protected void parseUsageContextProperties(JsonObject json, UsageContext res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(getJObject(json, "code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected VirtualServiceDetail parseVirtualServiceDetail(JsonObject json) throws IOException, FHIRFormatError {
    VirtualServiceDetail res = new VirtualServiceDetail();
    parseVirtualServiceDetailProperties(json, res);
    return res;
  }

  protected void parseVirtualServiceDetailProperties(JsonObject json, VirtualServiceDetail res) throws IOException, FHIRFormatError {
    parseDataTypeProperties(json, res);
    if (json.has("channelType"))
      res.setChannelType(parseCoding(getJObject(json, "channelType")));
    DataType address = parseType("address", json);
    if (address != null)
      res.setAddress(address);
    if (json.has("additionalInfo")) {
      JsonArray array = getJArray(json, "additionalInfo");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAdditionalInfo().add(new UrlType());
        } else {;
          res.getAdditionalInfo().add(parseUrl(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_additionalInfo")) {
      JsonArray array = getJArray(json, "_additionalInfo");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAdditionalInfo().size())
          res.getAdditionalInfo().add(parseUrl(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getAdditionalInfo().get(i));
      }
    };
    if (json.has("maxParticipants"))
      res.setMaxParticipantsElement(parsePositiveInt(json.get("maxParticipants").getAsString()));
    if (json.has("_maxParticipants"))
      parseElementProperties(getJObject(json, "_maxParticipants"), res.getMaxParticipantsElement());
    if (json.has("sessionKey"))
      res.setSessionKeyElement(parseString(json.get("sessionKey").getAsString()));
    if (json.has("_sessionKey"))
      parseElementProperties(getJObject(json, "_sessionKey"), res.getSessionKeyElement());
  }

  protected void parseCanonicalResourceProperties(JsonObject json, CanonicalResource res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
  }

  protected void parseDomainResourceProperties(JsonObject json, DomainResource res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("text"))
      res.setText(parseNarrative(getJObject(json, "text")));
    if (json.has("contained")) {
      JsonArray array = getJArray(json, "contained");
      for (int i = 0; i < array.size(); i++) {
        res.getContained().add(parseResource(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("extension")) {
      JsonArray array = getJArray(json, "extension");
      for (int i = 0; i < array.size(); i++) {
        res.getExtension().add(parseExtension(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("modifierExtension")) {
      JsonArray array = getJArray(json, "modifierExtension");
      for (int i = 0; i < array.size(); i++) {
        res.getModifierExtension().add(parseExtension(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected void parseMetadataResourceProperties(JsonObject json, MetadataResource res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
  }

  protected void parseResourceProperties(JsonObject json, Resource res) throws IOException, FHIRFormatError {
    parseBaseProperties(json, res);
    if (json.has("id"))
      res.setIdElement(parseId(json.get("id").getAsString()));
    if (json.has("_id"))
      parseElementProperties(getJObject(json, "_id"), res.getIdElement());
    if (json.has("meta"))
      res.setMeta(parseMeta(getJObject(json, "meta")));
    if (json.has("implicitRules"))
      res.setImplicitRulesElement(parseUri(json.get("implicitRules").getAsString()));
    if (json.has("_implicitRules"))
      parseElementProperties(getJObject(json, "_implicitRules"), res.getImplicitRulesElement());
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
  }

  protected Account parseAccount(JsonObject json) throws IOException, FHIRFormatError {
    Account res = new Account();
    parseAccountProperties(json, res);
    return res;
  }

  protected void parseAccountProperties(JsonObject json, Account res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("billingStatus"))
      res.setBillingStatus(parseCodeableConcept(getJObject(json, "billingStatus")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("subject")) {
      JsonArray array = getJArray(json, "subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("servicePeriod"))
      res.setServicePeriod(parsePeriod(getJObject(json, "servicePeriod")));
    if (json.has("coverage")) {
      JsonArray array = getJArray(json, "coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseAccountCoverageComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(getJObject(json, "owner")));
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("guarantor")) {
      JsonArray array = getJArray(json, "guarantor");
      for (int i = 0; i < array.size(); i++) {
        res.getGuarantor().add(parseAccountGuarantorComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = getJArray(json, "diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseAccountDiagnosisComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = getJArray(json, "procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseAccountProcedureComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedAccount")) {
      JsonArray array = getJArray(json, "relatedAccount");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedAccount().add(parseAccountRelatedAccountComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("currency"))
      res.setCurrency(parseCodeableConcept(getJObject(json, "currency")));
    if (json.has("balance")) {
      JsonArray array = getJArray(json, "balance");
      for (int i = 0; i < array.size(); i++) {
        res.getBalance().add(parseAccountBalanceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("calculatedAt"))
      res.setCalculatedAtElement(parseInstant(json.get("calculatedAt").getAsString()));
    if (json.has("_calculatedAt"))
      parseElementProperties(getJObject(json, "_calculatedAt"), res.getCalculatedAtElement());
  }

  protected Account.CoverageComponent parseAccountCoverageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Account.CoverageComponent res = new Account.CoverageComponent();
    parseAccountCoverageComponentProperties(json, res);
    return res;
  }

  protected void parseAccountCoverageComponentProperties(JsonObject json, Account.CoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("priority"))
      res.setPriorityElement(parsePositiveInt(json.get("priority").getAsString()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
  }

  protected Account.GuarantorComponent parseAccountGuarantorComponent(JsonObject json) throws IOException, FHIRFormatError {
    Account.GuarantorComponent res = new Account.GuarantorComponent();
    parseAccountGuarantorComponentProperties(json, res);
    return res;
  }

  protected void parseAccountGuarantorComponentProperties(JsonObject json, Account.GuarantorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
    if (json.has("onHold"))
      res.setOnHoldElement(parseBoolean(json.get("onHold").getAsBoolean()));
    if (json.has("_onHold"))
      parseElementProperties(getJObject(json, "_onHold"), res.getOnHoldElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Account.AccountDiagnosisComponent parseAccountDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    Account.AccountDiagnosisComponent res = new Account.AccountDiagnosisComponent();
    parseAccountDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseAccountDiagnosisComponentProperties(JsonObject json, Account.AccountDiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("condition"))
      res.setCondition(parseCodeableReference(getJObject(json, "condition")));
    if (json.has("dateOfDiagnosis"))
      res.setDateOfDiagnosisElement(parseDateTime(json.get("dateOfDiagnosis").getAsString()));
    if (json.has("_dateOfDiagnosis"))
      parseElementProperties(getJObject(json, "_dateOfDiagnosis"), res.getDateOfDiagnosisElement());
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmissionElement(parseBoolean(json.get("onAdmission").getAsBoolean()));
    if (json.has("_onAdmission"))
      parseElementProperties(getJObject(json, "_onAdmission"), res.getOnAdmissionElement());
    if (json.has("packageCode")) {
      JsonArray array = getJArray(json, "packageCode");
      for (int i = 0; i < array.size(); i++) {
        res.getPackageCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Account.AccountProcedureComponent parseAccountProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
    Account.AccountProcedureComponent res = new Account.AccountProcedureComponent();
    parseAccountProcedureComponentProperties(json, res);
    return res;
  }

  protected void parseAccountProcedureComponentProperties(JsonObject json, Account.AccountProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("code"))
      res.setCode(parseCodeableReference(getJObject(json, "code")));
    if (json.has("dateOfService"))
      res.setDateOfServiceElement(parseDateTime(json.get("dateOfService").getAsString()));
    if (json.has("_dateOfService"))
      parseElementProperties(getJObject(json, "_dateOfService"), res.getDateOfServiceElement());
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("packageCode")) {
      JsonArray array = getJArray(json, "packageCode");
      for (int i = 0; i < array.size(); i++) {
        res.getPackageCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("device")) {
      JsonArray array = getJArray(json, "device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Account.AccountRelatedAccountComponent parseAccountRelatedAccountComponent(JsonObject json) throws IOException, FHIRFormatError {
    Account.AccountRelatedAccountComponent res = new Account.AccountRelatedAccountComponent();
    parseAccountRelatedAccountComponentProperties(json, res);
    return res;
  }

  protected void parseAccountRelatedAccountComponentProperties(JsonObject json, Account.AccountRelatedAccountComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("account"))
      res.setAccount(parseReference(getJObject(json, "account")));
  }

  protected Account.AccountBalanceComponent parseAccountBalanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    Account.AccountBalanceComponent res = new Account.AccountBalanceComponent();
    parseAccountBalanceComponentProperties(json, res);
    return res;
  }

  protected void parseAccountBalanceComponentProperties(JsonObject json, Account.AccountBalanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("aggregate"))
      res.setAggregate(parseCodeableConcept(getJObject(json, "aggregate")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(getJObject(json, "term")));
    if (json.has("estimate"))
      res.setEstimateElement(parseBoolean(json.get("estimate").getAsBoolean()));
    if (json.has("_estimate"))
      parseElementProperties(getJObject(json, "_estimate"), res.getEstimateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
  }

  protected ActivityDefinition parseActivityDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition res = new ActivityDefinition();
    parseActivityDefinitionProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionProperties(JsonObject json, ActivityDefinition res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseMarkdown(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(getJObject(json, "_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = getJArray(json, "topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("library")) {
      JsonArray array = getJArray(json, "library");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLibrary().add(new CanonicalType());
        } else {;
          res.getLibrary().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_library")) {
      JsonArray array = getJArray(json, "_library");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLibrary().size())
          res.getLibrary().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getLibrary().get(i));
      }
    };
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), ActivityDefinition.RequestResourceTypes.NULL, new ActivityDefinition.RequestResourceTypesEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(getJObject(json, "_kind"), res.getKindElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    DataType asNeeded = parseType("asNeeded", json);
    if (asNeeded != null)
      res.setAsNeeded(asNeeded);
    if (json.has("location"))
      res.setLocation(parseCodeableReference(getJObject(json, "location")));
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseActivityDefinitionParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    DataType product = parseType("product", json);
    if (product != null)
      res.setProduct(product);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("dosage")) {
      JsonArray array = getJArray(json, "dosage");
      for (int i = 0; i < array.size(); i++) {
        res.getDosage().add(parseDosage(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = getJArray(json, "bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("specimenRequirement")) {
      JsonArray array = getJArray(json, "specimenRequirement");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSpecimenRequirement().add(new CanonicalType());
        } else {;
          res.getSpecimenRequirement().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_specimenRequirement")) {
      JsonArray array = getJArray(json, "_specimenRequirement");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSpecimenRequirement().size())
          res.getSpecimenRequirement().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSpecimenRequirement().get(i));
      }
    };
    if (json.has("observationRequirement")) {
      JsonArray array = getJArray(json, "observationRequirement");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getObservationRequirement().add(new CanonicalType());
        } else {;
          res.getObservationRequirement().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_observationRequirement")) {
      JsonArray array = getJArray(json, "_observationRequirement");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getObservationRequirement().size())
          res.getObservationRequirement().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getObservationRequirement().get(i));
      }
    };
    if (json.has("observationResultRequirement")) {
      JsonArray array = getJArray(json, "observationResultRequirement");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getObservationResultRequirement().add(new CanonicalType());
        } else {;
          res.getObservationResultRequirement().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_observationResultRequirement")) {
      JsonArray array = getJArray(json, "_observationResultRequirement");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getObservationResultRequirement().size())
          res.getObservationResultRequirement().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getObservationResultRequirement().get(i));
      }
    };
    if (json.has("transform"))
      res.setTransformElement(parseCanonical(json.get("transform").getAsString()));
    if (json.has("_transform"))
      parseElementProperties(getJObject(json, "_transform"), res.getTransformElement());
    if (json.has("dynamicValue")) {
      JsonArray array = getJArray(json, "dynamicValue");
      for (int i = 0; i < array.size(); i++) {
        res.getDynamicValue().add(parseActivityDefinitionDynamicValueComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
    parseActivityDefinitionParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionParticipantComponentProperties(JsonObject json, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.ActionParticipantType.NULL, new Enumerations.ActionParticipantTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("typeCanonical"))
      res.setTypeCanonicalElement(parseCanonical(json.get("typeCanonical").getAsString()));
    if (json.has("_typeCanonical"))
      parseElementProperties(getJObject(json, "_typeCanonical"), res.getTypeCanonicalElement());
    if (json.has("typeReference"))
      res.setTypeReference(parseReference(getJObject(json, "typeReference")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
  }

  protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionDynamicValueComponent(JsonObject json) throws IOException, FHIRFormatError {
    ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
    parseActivityDefinitionDynamicValueComponentProperties(json, res);
    return res;
  }

  protected void parseActivityDefinitionDynamicValueComponentProperties(JsonObject json, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("expression"))
      res.setExpression(parseExpression(getJObject(json, "expression")));
  }

  protected ActorDefinition parseActorDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ActorDefinition res = new ActorDefinition();
    parseActorDefinitionProperties(json, res);
    return res;
  }

  protected void parseActorDefinitionProperties(JsonObject json, ActorDefinition res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.ExampleScenarioActorType.NULL, new Enumerations.ExampleScenarioActorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("reference")) {
      JsonArray array = getJArray(json, "reference");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReference().add(new UrlType());
        } else {;
          res.getReference().add(parseUrl(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_reference")) {
      JsonArray array = getJArray(json, "_reference");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReference().size())
          res.getReference().add(parseUrl(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getReference().get(i));
      }
    };
    if (json.has("capabilities"))
      res.setCapabilitiesElement(parseCanonical(json.get("capabilities").getAsString()));
    if (json.has("_capabilities"))
      parseElementProperties(getJObject(json, "_capabilities"), res.getCapabilitiesElement());
    if (json.has("derivedFrom")) {
      JsonArray array = getJArray(json, "derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDerivedFrom().add(new CanonicalType());
        } else {;
          res.getDerivedFrom().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_derivedFrom")) {
      JsonArray array = getJArray(json, "_derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDerivedFrom().size())
          res.getDerivedFrom().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDerivedFrom().get(i));
      }
    };
  }

  protected AdministrableProductDefinition parseAdministrableProductDefinition(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition res = new AdministrableProductDefinition();
    parseAdministrableProductDefinitionProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionProperties(JsonObject json, AdministrableProductDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("formOf")) {
      JsonArray array = getJArray(json, "formOf");
      for (int i = 0; i < array.size(); i++) {
        res.getFormOf().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("administrableDoseForm"))
      res.setAdministrableDoseForm(parseCodeableConcept(getJObject(json, "administrableDoseForm")));
    if (json.has("unitOfPresentation"))
      res.setUnitOfPresentation(parseCodeableConcept(getJObject(json, "unitOfPresentation")));
    if (json.has("producedFrom")) {
      JsonArray array = getJArray(json, "producedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getProducedFrom().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("ingredient")) {
      JsonArray array = getJArray(json, "ingredient");
      for (int i = 0; i < array.size(); i++) {
        res.getIngredient().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("property")) {
      JsonArray array = getJArray(json, "property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseAdministrableProductDefinitionPropertyComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("routeOfAdministration")) {
      JsonArray array = getJArray(json, "routeOfAdministration");
      for (int i = 0; i < array.size(); i++) {
        res.getRouteOfAdministration().add(parseAdministrableProductDefinitionRouteOfAdministrationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent parseAdministrableProductDefinitionPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent();
    parseAdministrableProductDefinitionPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionPropertyComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent parseAdministrableProductDefinitionRouteOfAdministrationComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent();
    parseAdministrableProductDefinitionRouteOfAdministrationComponentProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionRouteOfAdministrationComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("firstDose"))
      res.setFirstDose(parseQuantity(getJObject(json, "firstDose")));
    if (json.has("maxSingleDose"))
      res.setMaxSingleDose(parseQuantity(getJObject(json, "maxSingleDose")));
    if (json.has("maxDosePerDay"))
      res.setMaxDosePerDay(parseQuantity(getJObject(json, "maxDosePerDay")));
    if (json.has("maxDosePerTreatmentPeriod"))
      res.setMaxDosePerTreatmentPeriod(parseRatio(getJObject(json, "maxDosePerTreatmentPeriod")));
    if (json.has("maxTreatmentPeriod"))
      res.setMaxTreatmentPeriod(parseDuration(getJObject(json, "maxTreatmentPeriod")));
    if (json.has("targetSpecies")) {
      JsonArray array = getJArray(json, "targetSpecies");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetSpecies().add(parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
    parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("withdrawalPeriod")) {
      JsonArray array = getJArray(json, "withdrawalPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getWithdrawalPeriod().add(parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
    parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(json, res);
    return res;
  }

  protected void parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentProperties(JsonObject json, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("tissue"))
      res.setTissue(parseCodeableConcept(getJObject(json, "tissue")));
    if (json.has("value"))
      res.setValue(parseQuantity(getJObject(json, "value")));
    if (json.has("supportingInformation"))
      res.setSupportingInformationElement(parseString(json.get("supportingInformation").getAsString()));
    if (json.has("_supportingInformation"))
      parseElementProperties(getJObject(json, "_supportingInformation"), res.getSupportingInformationElement());
  }

  protected AdverseEvent parseAdverseEvent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent res = new AdverseEvent();
    parseAdverseEventProperties(json, res);
    return res;
  }

  protected void parseAdverseEventProperties(JsonObject json, AdverseEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), AdverseEvent.AdverseEventStatus.NULL, new AdverseEvent.AdverseEventStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("actuality"))
      res.setActualityElement(parseEnumeration(json.get("actuality").getAsString(), AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
    if (json.has("_actuality"))
      parseElementProperties(getJObject(json, "_actuality"), res.getActualityElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("detected"))
      res.setDetectedElement(parseDateTime(json.get("detected").getAsString()));
    if (json.has("_detected"))
      parseElementProperties(getJObject(json, "_detected"), res.getDetectedElement());
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(getJObject(json, "_recordedDate"), res.getRecordedDateElement());
    if (json.has("resultingEffect")) {
      JsonArray array = getJArray(json, "resultingEffect");
      for (int i = 0; i < array.size(); i++) {
        res.getResultingEffect().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("seriousness"))
      res.setSeriousness(parseCodeableConcept(getJObject(json, "seriousness")));
    if (json.has("outcome")) {
      JsonArray array = getJArray(json, "outcome");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcome().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("recorder"))
      res.setRecorder(parseReference(getJObject(json, "recorder")));
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAdverseEventParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("study")) {
      JsonArray array = getJArray(json, "study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("expectedInResearchStudy"))
      res.setExpectedInResearchStudyElement(parseBoolean(json.get("expectedInResearchStudy").getAsBoolean()));
    if (json.has("_expectedInResearchStudy"))
      parseElementProperties(getJObject(json, "_expectedInResearchStudy"), res.getExpectedInResearchStudyElement());
    if (json.has("suspectEntity")) {
      JsonArray array = getJArray(json, "suspectEntity");
      for (int i = 0; i < array.size(); i++) {
        res.getSuspectEntity().add(parseAdverseEventSuspectEntityComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("contributingFactor")) {
      JsonArray array = getJArray(json, "contributingFactor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributingFactor().add(parseAdverseEventContributingFactorComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("preventiveAction")) {
      JsonArray array = getJArray(json, "preventiveAction");
      for (int i = 0; i < array.size(); i++) {
        res.getPreventiveAction().add(parseAdverseEventPreventiveActionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("mitigatingAction")) {
      JsonArray array = getJArray(json, "mitigatingAction");
      for (int i = 0; i < array.size(); i++) {
        res.getMitigatingAction().add(parseAdverseEventMitigatingActionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseAdverseEventSupportingInfoComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AdverseEvent.AdverseEventParticipantComponent parseAdverseEventParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventParticipantComponent res = new AdverseEvent.AdverseEventParticipantComponent();
    parseAdverseEventParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventParticipantComponentProperties(JsonObject json, AdverseEvent.AdverseEventParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventSuspectEntityComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
    parseAdverseEventSuspectEntityComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventSuspectEntityComponentProperties(JsonObject json, AdverseEvent.AdverseEventSuspectEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType instance = parseType("instance", json);
    if (instance != null)
      res.setInstance(instance);
    if (json.has("causality"))
      res.setCausality(parseAdverseEventSuspectEntityCausalityComponent(getJObject(json, "causality")));
  }

  protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventSuspectEntityCausalityComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
    parseAdverseEventSuspectEntityCausalityComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventSuspectEntityCausalityComponentProperties(JsonObject json, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("assessmentMethod"))
      res.setAssessmentMethod(parseCodeableConcept(getJObject(json, "assessmentMethod")));
    if (json.has("entityRelatedness"))
      res.setEntityRelatedness(parseCodeableConcept(getJObject(json, "entityRelatedness")));
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
  }

  protected AdverseEvent.AdverseEventContributingFactorComponent parseAdverseEventContributingFactorComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventContributingFactorComponent res = new AdverseEvent.AdverseEventContributingFactorComponent();
    parseAdverseEventContributingFactorComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventContributingFactorComponentProperties(JsonObject json, AdverseEvent.AdverseEventContributingFactorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected AdverseEvent.AdverseEventPreventiveActionComponent parseAdverseEventPreventiveActionComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventPreventiveActionComponent res = new AdverseEvent.AdverseEventPreventiveActionComponent();
    parseAdverseEventPreventiveActionComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventPreventiveActionComponentProperties(JsonObject json, AdverseEvent.AdverseEventPreventiveActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected AdverseEvent.AdverseEventMitigatingActionComponent parseAdverseEventMitigatingActionComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventMitigatingActionComponent res = new AdverseEvent.AdverseEventMitigatingActionComponent();
    parseAdverseEventMitigatingActionComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventMitigatingActionComponentProperties(JsonObject json, AdverseEvent.AdverseEventMitigatingActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected AdverseEvent.AdverseEventSupportingInfoComponent parseAdverseEventSupportingInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
    AdverseEvent.AdverseEventSupportingInfoComponent res = new AdverseEvent.AdverseEventSupportingInfoComponent();
    parseAdverseEventSupportingInfoComponentProperties(json, res);
    return res;
  }

  protected void parseAdverseEventSupportingInfoComponentProperties(JsonObject json, AdverseEvent.AdverseEventSupportingInfoComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected AllergyIntolerance parseAllergyIntolerance(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance res = new AllergyIntolerance();
    parseAllergyIntoleranceProperties(json, res);
    return res;
  }

  protected void parseAllergyIntoleranceProperties(JsonObject json, AllergyIntolerance res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatus(parseCodeableConcept(getJObject(json, "clinicalStatus")));
    if (json.has("verificationStatus"))
      res.setVerificationStatus(parseCodeableConcept(getJObject(json, "verificationStatus")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCategory().add(new Enumeration<AllergyIntolerance.AllergyIntoleranceCategory>(new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory(), AllergyIntolerance.AllergyIntoleranceCategory.NULL));
        } else {;
          res.getCategory().add(parseEnumeration(array.get(i).getAsString(), AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        }
      }
    };
    if (json.has("_category")) {
      JsonArray array = getJArray(json, "_category");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCategory().size())
          res.getCategory().add(parseEnumeration(null, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getCategory().get(i));
      }
    };
    if (json.has("criticality"))
      res.setCriticalityElement(parseEnumeration(json.get("criticality").getAsString(), AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
    if (json.has("_criticality"))
      parseElementProperties(getJObject(json, "_criticality"), res.getCriticalityElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    DataType onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(getJObject(json, "_recordedDate"), res.getRecordedDateElement());
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAllergyIntoleranceParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("lastOccurrence"))
      res.setLastOccurrenceElement(parseDateTime(json.get("lastOccurrence").getAsString()));
    if (json.has("_lastOccurrence"))
      parseElementProperties(getJObject(json, "_lastOccurrence"), res.getLastOccurrenceElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reaction")) {
      JsonArray array = getJArray(json, "reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseAllergyIntoleranceReactionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AllergyIntolerance.AllergyIntoleranceParticipantComponent parseAllergyIntoleranceParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceParticipantComponent res = new AllergyIntolerance.AllergyIntoleranceParticipantComponent();
    parseAllergyIntoleranceParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseAllergyIntoleranceParticipantComponentProperties(JsonObject json, AllergyIntolerance.AllergyIntoleranceParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceReactionComponent(JsonObject json) throws IOException, FHIRFormatError {
    AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
    parseAllergyIntoleranceReactionComponentProperties(json, res);
    return res;
  }

  protected void parseAllergyIntoleranceReactionComponentProperties(JsonObject json, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(getJObject(json, "substance")));
    if (json.has("manifestation")) {
      JsonArray array = getJArray(json, "manifestation");
      for (int i = 0; i < array.size(); i++) {
        res.getManifestation().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("onset"))
      res.setOnsetElement(parseDateTime(json.get("onset").getAsString()));
    if (json.has("_onset"))
      parseElementProperties(getJObject(json, "_onset"), res.getOnsetElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(getJObject(json, "_severity"), res.getSeverityElement());
    if (json.has("exposureRoute"))
      res.setExposureRoute(parseCodeableConcept(getJObject(json, "exposureRoute")));
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Appointment parseAppointment(JsonObject json) throws IOException, FHIRFormatError {
    Appointment res = new Appointment();
    parseAppointmentProperties(json, res);
    return res;
  }

  protected void parseAppointmentProperties(JsonObject json, Appointment res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("cancellationReason"))
      res.setCancellationReason(parseCodeableConcept(getJObject(json, "cancellationReason")));
    if (json.has("class")) {
      JsonArray array = getJArray(json, "class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("serviceCategory")) {
      JsonArray array = getJArray(json, "serviceCategory");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("serviceType")) {
      JsonArray array = getJArray(json, "serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = getJArray(json, "specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("appointmentType"))
      res.setAppointmentType(parseCodeableConcept(getJObject(json, "appointmentType")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("replaces")) {
      JsonArray array = getJArray(json, "replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("virtualService")) {
      JsonArray array = getJArray(json, "virtualService");
      for (int i = 0; i < array.size(); i++) {
        res.getVirtualService().add(parseVirtualServiceDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInformation")) {
      JsonArray array = getJArray(json, "supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("previousAppointment"))
      res.setPreviousAppointment(parseReference(getJObject(json, "previousAppointment")));
    if (json.has("originatingAppointment"))
      res.setOriginatingAppointment(parseReference(getJObject(json, "originatingAppointment")));
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
    if (json.has("minutesDuration"))
      res.setMinutesDurationElement(parsePositiveInt(json.get("minutesDuration").getAsString()));
    if (json.has("_minutesDuration"))
      parseElementProperties(getJObject(json, "_minutesDuration"), res.getMinutesDurationElement());
    if (json.has("requestedPeriod")) {
      JsonArray array = getJArray(json, "requestedPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getRequestedPeriod().add(parsePeriod(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("slot")) {
      JsonArray array = getJArray(json, "slot");
      for (int i = 0; i < array.size(); i++) {
        res.getSlot().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("account")) {
      JsonArray array = getJArray(json, "account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("cancellationDate"))
      res.setCancellationDateElement(parseDateTime(json.get("cancellationDate").getAsString()));
    if (json.has("_cancellationDate"))
      parseElementProperties(getJObject(json, "_cancellationDate"), res.getCancellationDateElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patientInstruction")) {
      JsonArray array = getJArray(json, "patientInstruction");
      for (int i = 0; i < array.size(); i++) {
        res.getPatientInstruction().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseAppointmentParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("recurrenceId"))
      res.setRecurrenceIdElement(parsePositiveInt(json.get("recurrenceId").getAsString()));
    if (json.has("_recurrenceId"))
      parseElementProperties(getJObject(json, "_recurrenceId"), res.getRecurrenceIdElement());
    if (json.has("occurrenceChanged"))
      res.setOccurrenceChangedElement(parseBoolean(json.get("occurrenceChanged").getAsBoolean()));
    if (json.has("_occurrenceChanged"))
      parseElementProperties(getJObject(json, "_occurrenceChanged"), res.getOccurrenceChangedElement());
    if (json.has("recurrenceTemplate")) {
      JsonArray array = getJArray(json, "recurrenceTemplate");
      for (int i = 0; i < array.size(); i++) {
        res.getRecurrenceTemplate().add(parseAppointmentRecurrenceTemplateComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Appointment.AppointmentParticipantComponent parseAppointmentParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
    parseAppointmentParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseAppointmentParticipantComponentProperties(JsonObject json, Appointment.AppointmentParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
    if (json.has("required"))
      res.setRequiredElement(parseBoolean(json.get("required").getAsBoolean()));
    if (json.has("_required"))
      parseElementProperties(getJObject(json, "_required"), res.getRequiredElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
  }

  protected Appointment.AppointmentRecurrenceTemplateComponent parseAppointmentRecurrenceTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Appointment.AppointmentRecurrenceTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateComponent();
    parseAppointmentRecurrenceTemplateComponentProperties(json, res);
    return res;
  }

  protected void parseAppointmentRecurrenceTemplateComponentProperties(JsonObject json, Appointment.AppointmentRecurrenceTemplateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("timezone"))
      res.setTimezone(parseCodeableConcept(getJObject(json, "timezone")));
    if (json.has("recurrenceType"))
      res.setRecurrenceType(parseCodeableConcept(getJObject(json, "recurrenceType")));
    if (json.has("lastOccurrenceDate"))
      res.setLastOccurrenceDateElement(parseDate(json.get("lastOccurrenceDate").getAsString()));
    if (json.has("_lastOccurrenceDate"))
      parseElementProperties(getJObject(json, "_lastOccurrenceDate"), res.getLastOccurrenceDateElement());
    if (json.has("occurrenceCount"))
      res.setOccurrenceCountElement(parsePositiveInt(json.get("occurrenceCount").getAsString()));
    if (json.has("_occurrenceCount"))
      parseElementProperties(getJObject(json, "_occurrenceCount"), res.getOccurrenceCountElement());
    if (json.has("occurrenceDate")) {
      JsonArray array = getJArray(json, "occurrenceDate");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getOccurrenceDate().add(new DateType());
        } else {;
          res.getOccurrenceDate().add(parseDate(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_occurrenceDate")) {
      JsonArray array = getJArray(json, "_occurrenceDate");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOccurrenceDate().size())
          res.getOccurrenceDate().add(parseDate(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getOccurrenceDate().get(i));
      }
    };
    if (json.has("weeklyTemplate"))
      res.setWeeklyTemplate(parseAppointmentRecurrenceTemplateWeeklyTemplateComponent(getJObject(json, "weeklyTemplate")));
    if (json.has("monthlyTemplate"))
      res.setMonthlyTemplate(parseAppointmentRecurrenceTemplateMonthlyTemplateComponent(getJObject(json, "monthlyTemplate")));
    if (json.has("yearlyTemplate"))
      res.setYearlyTemplate(parseAppointmentRecurrenceTemplateYearlyTemplateComponent(getJObject(json, "yearlyTemplate")));
    if (json.has("excludingDate")) {
      JsonArray array = getJArray(json, "excludingDate");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getExcludingDate().add(new DateType());
        } else {;
          res.getExcludingDate().add(parseDate(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_excludingDate")) {
      JsonArray array = getJArray(json, "_excludingDate");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExcludingDate().size())
          res.getExcludingDate().add(parseDate(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getExcludingDate().get(i));
      }
    };
    if (json.has("excludingRecurrenceId")) {
      JsonArray array = getJArray(json, "excludingRecurrenceId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getExcludingRecurrenceId().add(new PositiveIntType());
        } else {;
          res.getExcludingRecurrenceId().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_excludingRecurrenceId")) {
      JsonArray array = getJArray(json, "_excludingRecurrenceId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExcludingRecurrenceId().size())
          res.getExcludingRecurrenceId().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getExcludingRecurrenceId().get(i));
      }
    };
  }

  protected Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent parseAppointmentRecurrenceTemplateWeeklyTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent();
    parseAppointmentRecurrenceTemplateWeeklyTemplateComponentProperties(json, res);
    return res;
  }

  protected void parseAppointmentRecurrenceTemplateWeeklyTemplateComponentProperties(JsonObject json, Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("monday"))
      res.setMondayElement(parseBoolean(json.get("monday").getAsBoolean()));
    if (json.has("_monday"))
      parseElementProperties(getJObject(json, "_monday"), res.getMondayElement());
    if (json.has("tuesday"))
      res.setTuesdayElement(parseBoolean(json.get("tuesday").getAsBoolean()));
    if (json.has("_tuesday"))
      parseElementProperties(getJObject(json, "_tuesday"), res.getTuesdayElement());
    if (json.has("wednesday"))
      res.setWednesdayElement(parseBoolean(json.get("wednesday").getAsBoolean()));
    if (json.has("_wednesday"))
      parseElementProperties(getJObject(json, "_wednesday"), res.getWednesdayElement());
    if (json.has("thursday"))
      res.setThursdayElement(parseBoolean(json.get("thursday").getAsBoolean()));
    if (json.has("_thursday"))
      parseElementProperties(getJObject(json, "_thursday"), res.getThursdayElement());
    if (json.has("friday"))
      res.setFridayElement(parseBoolean(json.get("friday").getAsBoolean()));
    if (json.has("_friday"))
      parseElementProperties(getJObject(json, "_friday"), res.getFridayElement());
    if (json.has("saturday"))
      res.setSaturdayElement(parseBoolean(json.get("saturday").getAsBoolean()));
    if (json.has("_saturday"))
      parseElementProperties(getJObject(json, "_saturday"), res.getSaturdayElement());
    if (json.has("sunday"))
      res.setSundayElement(parseBoolean(json.get("sunday").getAsBoolean()));
    if (json.has("_sunday"))
      parseElementProperties(getJObject(json, "_sunday"), res.getSundayElement());
    if (json.has("weekInterval"))
      res.setWeekIntervalElement(parsePositiveInt(json.get("weekInterval").getAsString()));
    if (json.has("_weekInterval"))
      parseElementProperties(getJObject(json, "_weekInterval"), res.getWeekIntervalElement());
  }

  protected Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent parseAppointmentRecurrenceTemplateMonthlyTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent();
    parseAppointmentRecurrenceTemplateMonthlyTemplateComponentProperties(json, res);
    return res;
  }

  protected void parseAppointmentRecurrenceTemplateMonthlyTemplateComponentProperties(JsonObject json, Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("dayOfMonth"))
      res.setDayOfMonthElement(parsePositiveInt(json.get("dayOfMonth").getAsString()));
    if (json.has("_dayOfMonth"))
      parseElementProperties(getJObject(json, "_dayOfMonth"), res.getDayOfMonthElement());
    if (json.has("nthWeekOfMonth"))
      res.setNthWeekOfMonth(parseCoding(getJObject(json, "nthWeekOfMonth")));
    if (json.has("dayOfWeek"))
      res.setDayOfWeek(parseCoding(getJObject(json, "dayOfWeek")));
    if (json.has("monthInterval"))
      res.setMonthIntervalElement(parsePositiveInt(json.get("monthInterval").getAsString()));
    if (json.has("_monthInterval"))
      parseElementProperties(getJObject(json, "_monthInterval"), res.getMonthIntervalElement());
  }

  protected Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent parseAppointmentRecurrenceTemplateYearlyTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent();
    parseAppointmentRecurrenceTemplateYearlyTemplateComponentProperties(json, res);
    return res;
  }

  protected void parseAppointmentRecurrenceTemplateYearlyTemplateComponentProperties(JsonObject json, Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("yearInterval"))
      res.setYearIntervalElement(parsePositiveInt(json.get("yearInterval").getAsString()));
    if (json.has("_yearInterval"))
      parseElementProperties(getJObject(json, "_yearInterval"), res.getYearIntervalElement());
  }

  protected AppointmentResponse parseAppointmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    AppointmentResponse res = new AppointmentResponse();
    parseAppointmentResponseProperties(json, res);
    return res;
  }

  protected void parseAppointmentResponseProperties(JsonObject json, AppointmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("appointment"))
      res.setAppointment(parseReference(getJObject(json, "appointment")));
    if (json.has("proposedNewTime"))
      res.setProposedNewTimeElement(parseBoolean(json.get("proposedNewTime").getAsBoolean()));
    if (json.has("_proposedNewTime"))
      parseElementProperties(getJObject(json, "_proposedNewTime"), res.getProposedNewTimeElement());
    if (json.has("start"))
      res.setStartElement(parseInstant(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("end"))
      res.setEndElement(parseInstant(json.get("end").getAsString()));
    if (json.has("_end"))
      parseElementProperties(getJObject(json, "_end"), res.getEndElement());
    if (json.has("participantType")) {
      JsonArray array = getJArray(json, "participantType");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipantType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
    if (json.has("participantStatus"))
      res.setParticipantStatusElement(parseEnumeration(json.get("participantStatus").getAsString(), AppointmentResponse.AppointmentResponseStatus.NULL, new AppointmentResponse.AppointmentResponseStatusEnumFactory()));
    if (json.has("_participantStatus"))
      parseElementProperties(getJObject(json, "_participantStatus"), res.getParticipantStatusElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("recurring"))
      res.setRecurringElement(parseBoolean(json.get("recurring").getAsBoolean()));
    if (json.has("_recurring"))
      parseElementProperties(getJObject(json, "_recurring"), res.getRecurringElement());
    if (json.has("occurrenceDate"))
      res.setOccurrenceDateElement(parseDate(json.get("occurrenceDate").getAsString()));
    if (json.has("_occurrenceDate"))
      parseElementProperties(getJObject(json, "_occurrenceDate"), res.getOccurrenceDateElement());
    if (json.has("recurrenceId"))
      res.setRecurrenceIdElement(parsePositiveInt(json.get("recurrenceId").getAsString()));
    if (json.has("_recurrenceId"))
      parseElementProperties(getJObject(json, "_recurrenceId"), res.getRecurrenceIdElement());
  }

  protected ArtifactAssessment parseArtifactAssessment(JsonObject json) throws IOException, FHIRFormatError {
    ArtifactAssessment res = new ArtifactAssessment();
    parseArtifactAssessmentProperties(json, res);
    return res;
  }

  protected void parseArtifactAssessmentProperties(JsonObject json, ArtifactAssessment res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    DataType citeAs = parseType("citeAs", json);
    if (citeAs != null)
      res.setCiteAs(citeAs);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    DataType artifact = parseType("artifact", json);
    if (artifact != null)
      res.setArtifact(artifact);
    if (json.has("content")) {
      JsonArray array = getJArray(json, "content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseArtifactAssessmentContentComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("workflowStatus"))
      res.setWorkflowStatusElement(parseEnumeration(json.get("workflowStatus").getAsString(), ArtifactAssessment.ArtifactAssessmentWorkflowStatus.NULL, new ArtifactAssessment.ArtifactAssessmentWorkflowStatusEnumFactory()));
    if (json.has("_workflowStatus"))
      parseElementProperties(getJObject(json, "_workflowStatus"), res.getWorkflowStatusElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseEnumeration(json.get("disposition").getAsString(), ArtifactAssessment.ArtifactAssessmentDisposition.NULL, new ArtifactAssessment.ArtifactAssessmentDispositionEnumFactory()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
  }

  protected ArtifactAssessment.ArtifactAssessmentContentComponent parseArtifactAssessmentContentComponent(JsonObject json) throws IOException, FHIRFormatError {
    ArtifactAssessment.ArtifactAssessmentContentComponent res = new ArtifactAssessment.ArtifactAssessmentContentComponent();
    parseArtifactAssessmentContentComponentProperties(json, res);
    return res;
  }

  protected void parseArtifactAssessmentContentComponentProperties(JsonObject json, ArtifactAssessment.ArtifactAssessmentContentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("informationType"))
      res.setInformationTypeElement(parseEnumeration(json.get("informationType").getAsString(), ArtifactAssessment.ArtifactAssessmentInformationType.NULL, new ArtifactAssessment.ArtifactAssessmentInformationTypeEnumFactory()));
    if (json.has("_informationType"))
      parseElementProperties(getJObject(json, "_informationType"), res.getInformationTypeElement());
    if (json.has("summary"))
      res.setSummaryElement(parseMarkdown(json.get("summary").getAsString()));
    if (json.has("_summary"))
      parseElementProperties(getJObject(json, "_summary"), res.getSummaryElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("classifier")) {
      JsonArray array = getJArray(json, "classifier");
      for (int i = 0; i < array.size(); i++) {
        res.getClassifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("path")) {
      JsonArray array = getJArray(json, "path");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPath().add(new UriType());
        } else {;
          res.getPath().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_path")) {
      JsonArray array = getJArray(json, "_path");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPath().size())
          res.getPath().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPath().get(i));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("freeToShare"))
      res.setFreeToShareElement(parseBoolean(json.get("freeToShare").getAsBoolean()));
    if (json.has("_freeToShare"))
      parseElementProperties(getJObject(json, "_freeToShare"), res.getFreeToShareElement());
    if (json.has("component")) {
      JsonArray array = getJArray(json, "component");
      for (int i = 0; i < array.size(); i++) {
        res.getComponent().add(parseArtifactAssessmentContentComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AuditEvent parseAuditEvent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent res = new AuditEvent();
    parseAuditEventProperties(json, res);
    return res;
  }

  protected void parseAuditEventProperties(JsonObject json, AuditEvent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("action"))
      res.setActionElement(parseEnumeration(json.get("action").getAsString(), AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
    if (json.has("_action"))
      parseElementProperties(getJObject(json, "_action"), res.getActionElement());
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), AuditEvent.AuditEventSeverity.NULL, new AuditEvent.AuditEventSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(getJObject(json, "_severity"), res.getSeverityElement());
    DataType occurred = parseType("occurred", json);
    if (occurred != null)
      res.setOccurred(occurred);
    if (json.has("recorded"))
      res.setRecordedElement(parseInstant(json.get("recorded").getAsString()));
    if (json.has("_recorded"))
      parseElementProperties(getJObject(json, "_recorded"), res.getRecordedElement());
    if (json.has("outcome"))
      res.setOutcome(parseAuditEventOutcomeComponent(getJObject(json, "outcome")));
    if (json.has("authorization")) {
      JsonArray array = getJArray(json, "authorization");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorization().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("agent")) {
      JsonArray array = getJArray(json, "agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseAuditEventAgentComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("source"))
      res.setSource(parseAuditEventSourceComponent(getJObject(json, "source")));
    if (json.has("entity")) {
      JsonArray array = getJArray(json, "entity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntity().add(parseAuditEventEntityComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AuditEvent.AuditEventOutcomeComponent parseAuditEventOutcomeComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventOutcomeComponent res = new AuditEvent.AuditEventOutcomeComponent();
    parseAuditEventOutcomeComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventOutcomeComponentProperties(JsonObject json, AuditEvent.AuditEventOutcomeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(getJObject(json, "code")));
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AuditEvent.AuditEventAgentComponent parseAuditEventAgentComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
    parseAuditEventAgentComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventAgentComponentProperties(JsonObject json, AuditEvent.AuditEventAgentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("role")) {
      JsonArray array = getJArray(json, "role");
      for (int i = 0; i < array.size(); i++) {
        res.getRole().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("who"))
      res.setWho(parseReference(getJObject(json, "who")));
    if (json.has("requestor"))
      res.setRequestorElement(parseBoolean(json.get("requestor").getAsBoolean()));
    if (json.has("_requestor"))
      parseElementProperties(getJObject(json, "_requestor"), res.getRequestorElement());
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("policy")) {
      JsonArray array = getJArray(json, "policy");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPolicy().add(new UriType());
        } else {;
          res.getPolicy().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_policy")) {
      JsonArray array = getJArray(json, "_policy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPolicy().size())
          res.getPolicy().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPolicy().get(i));
      }
    };
    DataType network = parseType("network", json);
    if (network != null)
      res.setNetwork(network);
    if (json.has("authorization")) {
      JsonArray array = getJArray(json, "authorization");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorization().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AuditEvent.AuditEventSourceComponent parseAuditEventSourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
    parseAuditEventSourceComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventSourceComponentProperties(JsonObject json, AuditEvent.AuditEventSourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("site"))
      res.setSite(parseReference(getJObject(json, "site")));
    if (json.has("observer"))
      res.setObserver(parseReference(getJObject(json, "observer")));
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AuditEvent.AuditEventEntityComponent parseAuditEventEntityComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
    parseAuditEventEntityComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventEntityComponentProperties(JsonObject json, AuditEvent.AuditEventEntityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("what"))
      res.setWhat(parseReference(getJObject(json, "what")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("securityLabel")) {
      JsonArray array = getJArray(json, "securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("query"))
      res.setQueryElement(parseBase64Binary(json.get("query").getAsString()));
    if (json.has("_query"))
      parseElementProperties(getJObject(json, "_query"), res.getQueryElement());
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseAuditEventEntityDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("agent")) {
      JsonArray array = getJArray(json, "agent");
      for (int i = 0; i < array.size(); i++) {
        res.getAgent().add(parseAuditEventAgentComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventEntityDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
    parseAuditEventEntityDetailComponentProperties(json, res);
    return res;
  }

  protected void parseAuditEventEntityDetailComponentProperties(JsonObject json, AuditEvent.AuditEventEntityDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Basic parseBasic(JsonObject json) throws IOException, FHIRFormatError {
    Basic res = new Basic();
    parseBasicProperties(json, res);
    return res;
  }

  protected void parseBasicProperties(JsonObject json, Basic res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
  }

  protected Binary parseBinary(JsonObject json) throws IOException, FHIRFormatError {
    Binary res = new Binary();
    parseBinaryProperties(json, res);
    return res;
  }

  protected void parseBinaryProperties(JsonObject json, Binary res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("contentType"))
      res.setContentTypeElement(parseCode(json.get("contentType").getAsString()));
    if (json.has("_contentType"))
      parseElementProperties(getJObject(json, "_contentType"), res.getContentTypeElement());
    if (json.has("securityContext"))
      res.setSecurityContext(parseReference(getJObject(json, "securityContext")));
    if (json.has("data"))
      res.setDataElement(parseBase64Binary(json.get("data").getAsString()));
    if (json.has("_data"))
      parseElementProperties(getJObject(json, "_data"), res.getDataElement());
  }

  protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
    parseBiologicallyDerivedProductProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductProperties(JsonObject json, BiologicallyDerivedProduct res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("productCategory"))
      res.setProductCategory(parseCoding(getJObject(json, "productCategory")));
    if (json.has("productCode"))
      res.setProductCode(parseCodeableConcept(getJObject(json, "productCode")));
    if (json.has("parent")) {
      JsonArray array = getJArray(json, "parent");
      for (int i = 0; i < array.size(); i++) {
        res.getParent().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("request")) {
      JsonArray array = getJArray(json, "request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("biologicalSourceEvent"))
      res.setBiologicalSourceEvent(parseIdentifier(getJObject(json, "biologicalSourceEvent")));
    if (json.has("processingFacility")) {
      JsonArray array = getJArray(json, "processingFacility");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessingFacility().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("division"))
      res.setDivisionElement(parseString(json.get("division").getAsString()));
    if (json.has("_division"))
      parseElementProperties(getJObject(json, "_division"), res.getDivisionElement());
    if (json.has("productStatus"))
      res.setProductStatus(parseCoding(getJObject(json, "productStatus")));
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(getJObject(json, "_expirationDate"), res.getExpirationDateElement());
    if (json.has("collection"))
      res.setCollection(parseBiologicallyDerivedProductCollectionComponent(getJObject(json, "collection")));
    if (json.has("storageTempRequirements"))
      res.setStorageTempRequirements(parseRange(getJObject(json, "storageTempRequirements")));
    if (json.has("property")) {
      JsonArray array = getJArray(json, "property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseBiologicallyDerivedProductPropertyComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductCollectionComponent(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
    parseBiologicallyDerivedProductCollectionComponentProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductCollectionComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("collector"))
      res.setCollector(parseReference(getJObject(json, "collector")));
    if (json.has("source"))
      res.setSource(parseReference(getJObject(json, "source")));
    DataType collected = parseType("collected", json);
    if (collected != null)
      res.setCollected(collected);
  }

  protected BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent parseBiologicallyDerivedProductPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent();
    parseBiologicallyDerivedProductPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductPropertyComponentProperties(JsonObject json, BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected BiologicallyDerivedProductDispense parseBiologicallyDerivedProductDispense(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProductDispense res = new BiologicallyDerivedProductDispense();
    parseBiologicallyDerivedProductDispenseProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductDispenseProperties(JsonObject json, BiologicallyDerivedProductDispense res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = getJArray(json, "partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispenseCodes.NULL, new BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispenseCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("originRelationshipType"))
      res.setOriginRelationshipType(parseCodeableConcept(getJObject(json, "originRelationshipType")));
    if (json.has("product"))
      res.setProduct(parseReference(getJObject(json, "product")));
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("matchStatus"))
      res.setMatchStatus(parseCodeableConcept(getJObject(json, "matchStatus")));
    if (json.has("performer")) {
      JsonArray array = getJArray(json, "performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseBiologicallyDerivedProductDispensePerformerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("preparedDate"))
      res.setPreparedDateElement(parseDateTime(json.get("preparedDate").getAsString()));
    if (json.has("_preparedDate"))
      parseElementProperties(getJObject(json, "_preparedDate"), res.getPreparedDateElement());
    if (json.has("whenHandedOver"))
      res.setWhenHandedOverElement(parseDateTime(json.get("whenHandedOver").getAsString()));
    if (json.has("_whenHandedOver"))
      parseElementProperties(getJObject(json, "_whenHandedOver"), res.getWhenHandedOverElement());
    if (json.has("destination"))
      res.setDestination(parseReference(getJObject(json, "destination")));
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("usageInstruction"))
      res.setUsageInstructionElement(parseString(json.get("usageInstruction").getAsString()));
    if (json.has("_usageInstruction"))
      parseElementProperties(getJObject(json, "_usageInstruction"), res.getUsageInstructionElement());
  }

  protected BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispensePerformerComponent parseBiologicallyDerivedProductDispensePerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispensePerformerComponent res = new BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispensePerformerComponent();
    parseBiologicallyDerivedProductDispensePerformerComponentProperties(json, res);
    return res;
  }

  protected void parseBiologicallyDerivedProductDispensePerformerComponentProperties(JsonObject json, BiologicallyDerivedProductDispense.BiologicallyDerivedProductDispensePerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected BodyStructure parseBodyStructure(JsonObject json) throws IOException, FHIRFormatError {
    BodyStructure res = new BodyStructure();
    parseBodyStructureProperties(json, res);
    return res;
  }

  protected void parseBodyStructureProperties(JsonObject json, BodyStructure res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(getJObject(json, "_active"), res.getActiveElement());
    if (json.has("morphology"))
      res.setMorphology(parseCodeableConcept(getJObject(json, "morphology")));
    if (json.has("includedStructure")) {
      JsonArray array = getJArray(json, "includedStructure");
      for (int i = 0; i < array.size(); i++) {
        res.getIncludedStructure().add(parseBodyStructureIncludedStructureComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("excludedStructure")) {
      JsonArray array = getJArray(json, "excludedStructure");
      for (int i = 0; i < array.size(); i++) {
        res.getExcludedStructure().add(parseBodyStructureIncludedStructureComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("image")) {
      JsonArray array = getJArray(json, "image");
      for (int i = 0; i < array.size(); i++) {
        res.getImage().add(parseAttachment(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
  }

  protected BodyStructure.BodyStructureIncludedStructureComponent parseBodyStructureIncludedStructureComponent(JsonObject json) throws IOException, FHIRFormatError {
    BodyStructure.BodyStructureIncludedStructureComponent res = new BodyStructure.BodyStructureIncludedStructureComponent();
    parseBodyStructureIncludedStructureComponentProperties(json, res);
    return res;
  }

  protected void parseBodyStructureIncludedStructureComponentProperties(JsonObject json, BodyStructure.BodyStructureIncludedStructureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("structure"))
      res.setStructure(parseCodeableConcept(getJObject(json, "structure")));
    if (json.has("laterality"))
      res.setLaterality(parseCodeableConcept(getJObject(json, "laterality")));
    if (json.has("bodyLandmarkOrientation")) {
      JsonArray array = getJArray(json, "bodyLandmarkOrientation");
      for (int i = 0; i < array.size(); i++) {
        res.getBodyLandmarkOrientation().add(parseBodyStructureIncludedStructureBodyLandmarkOrientationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("spatialReference")) {
      JsonArray array = getJArray(json, "spatialReference");
      for (int i = 0; i < array.size(); i++) {
        res.getSpatialReference().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("qualifier")) {
      JsonArray array = getJArray(json, "qualifier");
      for (int i = 0; i < array.size(); i++) {
        res.getQualifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationComponent parseBodyStructureIncludedStructureBodyLandmarkOrientationComponent(JsonObject json) throws IOException, FHIRFormatError {
    BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationComponent res = new BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationComponent();
    parseBodyStructureIncludedStructureBodyLandmarkOrientationComponentProperties(json, res);
    return res;
  }

  protected void parseBodyStructureIncludedStructureBodyLandmarkOrientationComponentProperties(JsonObject json, BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("landmarkDescription")) {
      JsonArray array = getJArray(json, "landmarkDescription");
      for (int i = 0; i < array.size(); i++) {
        res.getLandmarkDescription().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("clockFacePosition")) {
      JsonArray array = getJArray(json, "clockFacePosition");
      for (int i = 0; i < array.size(); i++) {
        res.getClockFacePosition().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("distanceFromLandmark")) {
      JsonArray array = getJArray(json, "distanceFromLandmark");
      for (int i = 0; i < array.size(); i++) {
        res.getDistanceFromLandmark().add(parseBodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("surfaceOrientation")) {
      JsonArray array = getJArray(json, "surfaceOrientation");
      for (int i = 0; i < array.size(); i++) {
        res.getSurfaceOrientation().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent parseBodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent(JsonObject json) throws IOException, FHIRFormatError {
    BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent res = new BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent();
    parseBodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponentProperties(json, res);
    return res;
  }

  protected void parseBodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponentProperties(JsonObject json, BodyStructure.BodyStructureIncludedStructureBodyLandmarkOrientationDistanceFromLandmarkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("device")) {
      JsonArray array = getJArray(json, "device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("value")) {
      JsonArray array = getJArray(json, "value");
      for (int i = 0; i < array.size(); i++) {
        res.getValue().add(parseQuantity(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Bundle parseBundle(JsonObject json) throws IOException, FHIRFormatError {
    Bundle res = new Bundle();
    parseBundleProperties(json, res);
    return res;
  }

  protected void parseBundleProperties(JsonObject json, Bundle res) throws IOException, FHIRFormatError {
    parseResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("timestamp"))
      res.setTimestampElement(parseInstant(json.get("timestamp").getAsString()));
    if (json.has("_timestamp"))
      parseElementProperties(getJObject(json, "_timestamp"), res.getTimestampElement());
    if (json.has("total"))
      res.setTotalElement(parseUnsignedInt(json.get("total").getAsString()));
    if (json.has("_total"))
      parseElementProperties(getJObject(json, "_total"), res.getTotalElement());
    if (json.has("link")) {
      JsonArray array = getJArray(json, "link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleLinkComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("entry")) {
      JsonArray array = getJArray(json, "entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseBundleEntryComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("signature"))
      res.setSignature(parseSignature(getJObject(json, "signature")));
    if (json.has("issues"))
      res.setIssues(parseResource(getJObject(json, "issues")));
  }

  protected Bundle.BundleLinkComponent parseBundleLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
    parseBundleLinkComponentProperties(json, res);
    return res;
  }

  protected void parseBundleLinkComponentProperties(JsonObject json, Bundle.BundleLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relation"))
      res.setRelationElement(parseEnumeration(json.get("relation").getAsString(), Bundle.LinkRelationTypes.NULL, new Bundle.LinkRelationTypesEnumFactory()));
    if (json.has("_relation"))
      parseElementProperties(getJObject(json, "_relation"), res.getRelationElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
  }

  protected Bundle.BundleEntryComponent parseBundleEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
    parseBundleEntryComponentProperties(json, res);
    return res;
  }

  protected void parseBundleEntryComponentProperties(JsonObject json, Bundle.BundleEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("link")) {
      JsonArray array = getJArray(json, "link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseBundleLinkComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("fullUrl"))
      res.setFullUrlElement(parseUri(json.get("fullUrl").getAsString()));
    if (json.has("_fullUrl"))
      parseElementProperties(getJObject(json, "_fullUrl"), res.getFullUrlElement());
    if (json.has("resource"))
      res.setResource(parseResource(getJObject(json, "resource")));
    if (json.has("search"))
      res.setSearch(parseBundleEntrySearchComponent(getJObject(json, "search")));
    if (json.has("request"))
      res.setRequest(parseBundleEntryRequestComponent(getJObject(json, "request")));
    if (json.has("response"))
      res.setResponse(parseBundleEntryResponseComponent(getJObject(json, "response")));
  }

  protected Bundle.BundleEntrySearchComponent parseBundleEntrySearchComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
    parseBundleEntrySearchComponentProperties(json, res);
    return res;
  }

  protected void parseBundleEntrySearchComponentProperties(JsonObject json, Bundle.BundleEntrySearchComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("score"))
      res.setScoreElement(parseDecimal(json.get("score").getAsBigDecimal()));
    if (json.has("_score"))
      parseElementProperties(getJObject(json, "_score"), res.getScoreElement());
  }

  protected Bundle.BundleEntryRequestComponent parseBundleEntryRequestComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
    parseBundleEntryRequestComponentProperties(json, res);
    return res;
  }

  protected void parseBundleEntryRequestComponentProperties(JsonObject json, Bundle.BundleEntryRequestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("method"))
      res.setMethodElement(parseEnumeration(json.get("method").getAsString(), Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
    if (json.has("_method"))
      parseElementProperties(getJObject(json, "_method"), res.getMethodElement());
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("ifNoneMatch"))
      res.setIfNoneMatchElement(parseString(json.get("ifNoneMatch").getAsString()));
    if (json.has("_ifNoneMatch"))
      parseElementProperties(getJObject(json, "_ifNoneMatch"), res.getIfNoneMatchElement());
    if (json.has("ifModifiedSince"))
      res.setIfModifiedSinceElement(parseInstant(json.get("ifModifiedSince").getAsString()));
    if (json.has("_ifModifiedSince"))
      parseElementProperties(getJObject(json, "_ifModifiedSince"), res.getIfModifiedSinceElement());
    if (json.has("ifMatch"))
      res.setIfMatchElement(parseString(json.get("ifMatch").getAsString()));
    if (json.has("_ifMatch"))
      parseElementProperties(getJObject(json, "_ifMatch"), res.getIfMatchElement());
    if (json.has("ifNoneExist"))
      res.setIfNoneExistElement(parseString(json.get("ifNoneExist").getAsString()));
    if (json.has("_ifNoneExist"))
      parseElementProperties(getJObject(json, "_ifNoneExist"), res.getIfNoneExistElement());
  }

  protected Bundle.BundleEntryResponseComponent parseBundleEntryResponseComponent(JsonObject json) throws IOException, FHIRFormatError {
    Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
    parseBundleEntryResponseComponentProperties(json, res);
    return res;
  }

  protected void parseBundleEntryResponseComponentProperties(JsonObject json, Bundle.BundleEntryResponseComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseString(json.get("status").getAsString()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("location"))
      res.setLocationElement(parseUri(json.get("location").getAsString()));
    if (json.has("_location"))
      parseElementProperties(getJObject(json, "_location"), res.getLocationElement());
    if (json.has("etag"))
      res.setEtagElement(parseString(json.get("etag").getAsString()));
    if (json.has("_etag"))
      parseElementProperties(getJObject(json, "_etag"), res.getEtagElement());
    if (json.has("lastModified"))
      res.setLastModifiedElement(parseInstant(json.get("lastModified").getAsString()));
    if (json.has("_lastModified"))
      parseElementProperties(getJObject(json, "_lastModified"), res.getLastModifiedElement());
    if (json.has("outcome"))
      res.setOutcome(parseResource(getJObject(json, "outcome")));
  }

  protected CapabilityStatement parseCapabilityStatement(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement res = new CapabilityStatement();
    parseCapabilityStatementProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementProperties(JsonObject json, CapabilityStatement res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), Enumerations.CapabilityStatementKind.NULL, new Enumerations.CapabilityStatementKindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(getJObject(json, "_kind"), res.getKindElement());
    if (json.has("instantiates")) {
      JsonArray array = getJArray(json, "instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiates().add(new CanonicalType());
        } else {;
          res.getInstantiates().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiates")) {
      JsonArray array = getJArray(json, "_instantiates");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiates().size())
          res.getInstantiates().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiates().get(i));
      }
    };
    if (json.has("imports")) {
      JsonArray array = getJArray(json, "imports");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImports().add(new CanonicalType());
        } else {;
          res.getImports().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_imports")) {
      JsonArray array = getJArray(json, "_imports");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImports().size())
          res.getImports().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getImports().get(i));
      }
    };
    if (json.has("software"))
      res.setSoftware(parseCapabilityStatementSoftwareComponent(getJObject(json, "software")));
    if (json.has("implementation"))
      res.setImplementation(parseCapabilityStatementImplementationComponent(getJObject(json, "implementation")));
    if (json.has("fhirVersion"))
      res.setFhirVersionElement(parseEnumeration(json.get("fhirVersion").getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
    if (json.has("_fhirVersion"))
      parseElementProperties(getJObject(json, "_fhirVersion"), res.getFhirVersionElement());
    if (json.has("format")) {
      JsonArray array = getJArray(json, "format");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFormat().add(new CodeType());
        } else {;
          res.getFormat().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_format")) {
      JsonArray array = getJArray(json, "_format");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFormat().size())
          res.getFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getFormat().get(i));
      }
    };
    if (json.has("patchFormat")) {
      JsonArray array = getJArray(json, "patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPatchFormat().add(new CodeType());
        } else {;
          res.getPatchFormat().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_patchFormat")) {
      JsonArray array = getJArray(json, "_patchFormat");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPatchFormat().size())
          res.getPatchFormat().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPatchFormat().get(i));
      }
    };
    if (json.has("acceptLanguage")) {
      JsonArray array = getJArray(json, "acceptLanguage");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAcceptLanguage().add(new CodeType());
        } else {;
          res.getAcceptLanguage().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_acceptLanguage")) {
      JsonArray array = getJArray(json, "_acceptLanguage");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAcceptLanguage().size())
          res.getAcceptLanguage().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getAcceptLanguage().get(i));
      }
    };
    if (json.has("implementationGuide")) {
      JsonArray array = getJArray(json, "implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImplementationGuide().add(new CanonicalType());
        } else {;
          res.getImplementationGuide().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_implementationGuide")) {
      JsonArray array = getJArray(json, "_implementationGuide");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImplementationGuide().size())
          res.getImplementationGuide().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getImplementationGuide().get(i));
      }
    };
    if (json.has("rest")) {
      JsonArray array = getJArray(json, "rest");
      for (int i = 0; i < array.size(); i++) {
        res.getRest().add(parseCapabilityStatementRestComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("messaging")) {
      JsonArray array = getJArray(json, "messaging");
      for (int i = 0; i < array.size(); i++) {
        res.getMessaging().add(parseCapabilityStatementMessagingComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("document")) {
      JsonArray array = getJArray(json, "document");
      for (int i = 0; i < array.size(); i++) {
        res.getDocument().add(parseCapabilityStatementDocumentComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementSoftwareComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
    parseCapabilityStatementSoftwareComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementSoftwareComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("releaseDate"))
      res.setReleaseDateElement(parseDateTime(json.get("releaseDate").getAsString()));
    if (json.has("_releaseDate"))
      parseElementProperties(getJObject(json, "_releaseDate"), res.getReleaseDateElement());
  }

  protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementImplementationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
    parseCapabilityStatementImplementationComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementImplementationComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementImplementationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("custodian"))
      res.setCustodian(parseReference(getJObject(json, "custodian")));
  }

  protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementRestComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
    parseCapabilityStatementRestComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("security"))
      res.setSecurity(parseCapabilityStatementRestSecurityComponent(getJObject(json, "security")));
    if (json.has("resource")) {
      JsonArray array = getJArray(json, "resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCapabilityStatementRestResourceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("interaction")) {
      JsonArray array = getJArray(json, "interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementSystemInteractionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = getJArray(json, "searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementRestResourceSearchParamComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("operation")) {
      JsonArray array = getJArray(json, "operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementRestResourceOperationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("compartment")) {
      JsonArray array = getJArray(json, "compartment");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCompartment().add(new CanonicalType());
        } else {;
          res.getCompartment().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_compartment")) {
      JsonArray array = getJArray(json, "_compartment");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCompartment().size())
          res.getCompartment().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getCompartment().get(i));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementRestSecurityComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
    parseCapabilityStatementRestSecurityComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestSecurityComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("cors"))
      res.setCorsElement(parseBoolean(json.get("cors").getAsBoolean()));
    if (json.has("_cors"))
      parseElementProperties(getJObject(json, "_cors"), res.getCorsElement());
    if (json.has("service")) {
      JsonArray array = getJArray(json, "service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementRestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
    parseCapabilityStatementRestResourceComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestResourceComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
    if (json.has("supportedProfile")) {
      JsonArray array = getJArray(json, "supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSupportedProfile().add(new CanonicalType());
        } else {;
          res.getSupportedProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_supportedProfile")) {
      JsonArray array = getJArray(json, "_supportedProfile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportedProfile().size())
          res.getSupportedProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSupportedProfile().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("interaction")) {
      JsonArray array = getJArray(json, "interaction");
      for (int i = 0; i < array.size(); i++) {
        res.getInteraction().add(parseCapabilityStatementResourceInteractionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("versioning"))
      res.setVersioningElement(parseEnumeration(json.get("versioning").getAsString(), CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
    if (json.has("_versioning"))
      parseElementProperties(getJObject(json, "_versioning"), res.getVersioningElement());
    if (json.has("readHistory"))
      res.setReadHistoryElement(parseBoolean(json.get("readHistory").getAsBoolean()));
    if (json.has("_readHistory"))
      parseElementProperties(getJObject(json, "_readHistory"), res.getReadHistoryElement());
    if (json.has("updateCreate"))
      res.setUpdateCreateElement(parseBoolean(json.get("updateCreate").getAsBoolean()));
    if (json.has("_updateCreate"))
      parseElementProperties(getJObject(json, "_updateCreate"), res.getUpdateCreateElement());
    if (json.has("conditionalCreate"))
      res.setConditionalCreateElement(parseBoolean(json.get("conditionalCreate").getAsBoolean()));
    if (json.has("_conditionalCreate"))
      parseElementProperties(getJObject(json, "_conditionalCreate"), res.getConditionalCreateElement());
    if (json.has("conditionalRead"))
      res.setConditionalReadElement(parseEnumeration(json.get("conditionalRead").getAsString(), CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
    if (json.has("_conditionalRead"))
      parseElementProperties(getJObject(json, "_conditionalRead"), res.getConditionalReadElement());
    if (json.has("conditionalUpdate"))
      res.setConditionalUpdateElement(parseBoolean(json.get("conditionalUpdate").getAsBoolean()));
    if (json.has("_conditionalUpdate"))
      parseElementProperties(getJObject(json, "_conditionalUpdate"), res.getConditionalUpdateElement());
    if (json.has("conditionalPatch"))
      res.setConditionalPatchElement(parseBoolean(json.get("conditionalPatch").getAsBoolean()));
    if (json.has("_conditionalPatch"))
      parseElementProperties(getJObject(json, "_conditionalPatch"), res.getConditionalPatchElement());
    if (json.has("conditionalDelete"))
      res.setConditionalDeleteElement(parseEnumeration(json.get("conditionalDelete").getAsString(), CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
    if (json.has("_conditionalDelete"))
      parseElementProperties(getJObject(json, "_conditionalDelete"), res.getConditionalDeleteElement());
    if (json.has("referencePolicy")) {
      JsonArray array = getJArray(json, "referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReferencePolicy().add(new Enumeration<CapabilityStatement.ReferenceHandlingPolicy>(new CapabilityStatement.ReferenceHandlingPolicyEnumFactory(), CapabilityStatement.ReferenceHandlingPolicy.NULL));
        } else {;
          res.getReferencePolicy().add(parseEnumeration(array.get(i).getAsString(), CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        }
      }
    };
    if (json.has("_referencePolicy")) {
      JsonArray array = getJArray(json, "_referencePolicy");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReferencePolicy().size())
          res.getReferencePolicy().add(parseEnumeration(null, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getReferencePolicy().get(i));
      }
    };
    if (json.has("searchInclude")) {
      JsonArray array = getJArray(json, "searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSearchInclude().add(new StringType());
        } else {;
          res.getSearchInclude().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_searchInclude")) {
      JsonArray array = getJArray(json, "_searchInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchInclude().size())
          res.getSearchInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSearchInclude().get(i));
      }
    };
    if (json.has("searchRevInclude")) {
      JsonArray array = getJArray(json, "searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSearchRevInclude().add(new StringType());
        } else {;
          res.getSearchRevInclude().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_searchRevInclude")) {
      JsonArray array = getJArray(json, "_searchRevInclude");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSearchRevInclude().size())
          res.getSearchRevInclude().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSearchRevInclude().get(i));
      }
    };
    if (json.has("searchParam")) {
      JsonArray array = getJArray(json, "searchParam");
      for (int i = 0; i < array.size(); i++) {
        res.getSearchParam().add(parseCapabilityStatementRestResourceSearchParamComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("operation")) {
      JsonArray array = getJArray(json, "operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseCapabilityStatementRestResourceOperationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
    parseCapabilityStatementResourceInteractionComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementResourceInteractionComponentProperties(JsonObject json, CapabilityStatement.ResourceInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementRestResourceSearchParamComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
    parseCapabilityStatementRestResourceSearchParamComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestResourceSearchParamComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementRestResourceOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
    parseCapabilityStatementRestResourceOperationComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementRestResourceOperationComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
    parseCapabilityStatementSystemInteractionComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementSystemInteractionComponentProperties(JsonObject json, CapabilityStatement.SystemInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementMessagingComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
    parseCapabilityStatementMessagingComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementMessagingComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("endpoint")) {
      JsonArray array = getJArray(json, "endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseCapabilityStatementMessagingEndpointComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reliableCache"))
      res.setReliableCacheElement(parseUnsignedInt(json.get("reliableCache").getAsString()));
    if (json.has("_reliableCache"))
      parseElementProperties(getJObject(json, "_reliableCache"), res.getReliableCacheElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("supportedMessage")) {
      JsonArray array = getJArray(json, "supportedMessage");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportedMessage().add(parseCapabilityStatementMessagingSupportedMessageComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementMessagingEndpointComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
    parseCapabilityStatementMessagingEndpointComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementMessagingEndpointComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("protocol"))
      res.setProtocol(parseCoding(getJObject(json, "protocol")));
    if (json.has("address"))
      res.setAddressElement(parseUrl(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(getJObject(json, "_address"), res.getAddressElement());
  }

  protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementMessagingSupportedMessageComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
    parseCapabilityStatementMessagingSupportedMessageComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementMessagingSupportedMessageComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseCanonical(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
  }

  protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementDocumentComponent(JsonObject json) throws IOException, FHIRFormatError {
    CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
    parseCapabilityStatementDocumentComponentProperties(json, res);
    return res;
  }

  protected void parseCapabilityStatementDocumentComponentProperties(JsonObject json, CapabilityStatement.CapabilityStatementDocumentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("documentation"))
      res.setDocumentationElement(parseMarkdown(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
  }

  protected CarePlan parseCarePlan(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan res = new CarePlan();
    parseCarePlanProperties(json, res);
    return res;
  }

  protected void parseCarePlanProperties(JsonObject json, CarePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = getJArray(json, "instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = getJArray(json, "_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = getJArray(json, "instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = getJArray(json, "_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = getJArray(json, "replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = getJArray(json, "partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("custodian"))
      res.setCustodian(parseReference(getJObject(json, "custodian")));
    if (json.has("contributor")) {
      JsonArray array = getJArray(json, "contributor");
      for (int i = 0; i < array.size(); i++) {
        res.getContributor().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = getJArray(json, "careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("addresses")) {
      JsonArray array = getJArray(json, "addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("goal")) {
      JsonArray array = getJArray(json, "goal");
      for (int i = 0; i < array.size(); i++) {
        res.getGoal().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("activity")) {
      JsonArray array = getJArray(json, "activity");
      for (int i = 0; i < array.size(); i++) {
        res.getActivity().add(parseCarePlanActivityComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CarePlan.CarePlanActivityComponent parseCarePlanActivityComponent(JsonObject json) throws IOException, FHIRFormatError {
    CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
    parseCarePlanActivityComponentProperties(json, res);
    return res;
  }

  protected void parseCarePlanActivityComponentProperties(JsonObject json, CarePlan.CarePlanActivityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("performedActivity")) {
      JsonArray array = getJArray(json, "performedActivity");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformedActivity().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("progress")) {
      JsonArray array = getJArray(json, "progress");
      for (int i = 0; i < array.size(); i++) {
        res.getProgress().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("plannedActivityReference"))
      res.setPlannedActivityReference(parseReference(getJObject(json, "plannedActivityReference")));
  }

  protected CareTeam parseCareTeam(JsonObject json) throws IOException, FHIRFormatError {
    CareTeam res = new CareTeam();
    parseCareTeamProperties(json, res);
    return res;
  }

  protected void parseCareTeamProperties(JsonObject json, CareTeam res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseCareTeamParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("managingOrganization")) {
      JsonArray array = getJArray(json, "managingOrganization");
      for (int i = 0; i < array.size(); i++) {
        res.getManagingOrganization().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("telecom")) {
      JsonArray array = getJArray(json, "telecom");
      for (int i = 0; i < array.size(); i++) {
        res.getTelecom().add(parseContactPoint(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CareTeam.CareTeamParticipantComponent parseCareTeamParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
    parseCareTeamParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseCareTeamParticipantComponentProperties(JsonObject json, CareTeam.CareTeamParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("member"))
      res.setMember(parseReference(getJObject(json, "member")));
    if (json.has("onBehalfOf"))
      res.setOnBehalfOf(parseReference(getJObject(json, "onBehalfOf")));
    DataType coverage = parseType("coverage", json);
    if (coverage != null)
      res.setCoverage(coverage);
  }

  protected ChargeItem parseChargeItem(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItem res = new ChargeItem();
    parseChargeItemProperties(json, res);
    return res;
  }

  protected void parseChargeItemProperties(JsonObject json, ChargeItem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("definitionUri")) {
      JsonArray array = getJArray(json, "definitionUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinitionUri().add(new UriType());
        } else {;
          res.getDefinitionUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definitionUri")) {
      JsonArray array = getJArray(json, "_definitionUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinitionUri().size())
          res.getDefinitionUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDefinitionUri().get(i));
      }
    };
    if (json.has("definitionCanonical")) {
      JsonArray array = getJArray(json, "definitionCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinitionCanonical().add(new CanonicalType());
        } else {;
          res.getDefinitionCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definitionCanonical")) {
      JsonArray array = getJArray(json, "_definitionCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinitionCanonical().size())
          res.getDefinitionCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDefinitionCanonical().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("partOf")) {
      JsonArray array = getJArray(json, "partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("performer")) {
      JsonArray array = getJArray(json, "performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseChargeItemPerformerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("performingOrganization"))
      res.setPerformingOrganization(parseReference(getJObject(json, "performingOrganization")));
    if (json.has("requestingOrganization"))
      res.setRequestingOrganization(parseReference(getJObject(json, "requestingOrganization")));
    if (json.has("costCenter"))
      res.setCostCenter(parseReference(getJObject(json, "costCenter")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("bodysite")) {
      JsonArray array = getJArray(json, "bodysite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodysite().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("unitPriceComponent"))
      res.setUnitPriceComponent(parseMonetaryComponent(getJObject(json, "unitPriceComponent")));
    if (json.has("totalPriceComponent"))
      res.setTotalPriceComponent(parseMonetaryComponent(getJObject(json, "totalPriceComponent")));
    if (json.has("overrideReason"))
      res.setOverrideReason(parseCodeableConcept(getJObject(json, "overrideReason")));
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("enteredDate"))
      res.setEnteredDateElement(parseDateTime(json.get("enteredDate").getAsString()));
    if (json.has("_enteredDate"))
      parseElementProperties(getJObject(json, "_enteredDate"), res.getEnteredDateElement());
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("service")) {
      JsonArray array = getJArray(json, "service");
      for (int i = 0; i < array.size(); i++) {
        res.getService().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("product")) {
      JsonArray array = getJArray(json, "product");
      for (int i = 0; i < array.size(); i++) {
        res.getProduct().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("account")) {
      JsonArray array = getJArray(json, "account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInformation")) {
      JsonArray array = getJArray(json, "supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ChargeItem.ChargeItemPerformerComponent parseChargeItemPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
    parseChargeItemPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseChargeItemPerformerComponentProperties(JsonObject json, ChargeItem.ChargeItemPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected ChargeItemDefinition parseChargeItemDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition res = new ChargeItemDefinition();
    parseChargeItemDefinitionProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionProperties(JsonObject json, ChargeItemDefinition res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("derivedFromUri")) {
      JsonArray array = getJArray(json, "derivedFromUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDerivedFromUri().add(new UriType());
        } else {;
          res.getDerivedFromUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_derivedFromUri")) {
      JsonArray array = getJArray(json, "_derivedFromUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDerivedFromUri().size())
          res.getDerivedFromUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDerivedFromUri().get(i));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = getJArray(json, "partOf");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPartOf().add(new CanonicalType());
        } else {;
          res.getPartOf().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_partOf")) {
      JsonArray array = getJArray(json, "_partOf");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPartOf().size())
          res.getPartOf().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPartOf().get(i));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = getJArray(json, "replaces");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReplaces().add(new CanonicalType());
        } else {;
          res.getReplaces().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_replaces")) {
      JsonArray array = getJArray(json, "_replaces");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReplaces().size())
          res.getReplaces().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getReplaces().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("instance")) {
      JsonArray array = getJArray(json, "instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("applicability")) {
      JsonArray array = getJArray(json, "applicability");
      for (int i = 0; i < array.size(); i++) {
        res.getApplicability().add(parseChargeItemDefinitionApplicabilityComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("propertyGroup")) {
      JsonArray array = getJArray(json, "propertyGroup");
      for (int i = 0; i < array.size(); i++) {
        res.getPropertyGroup().add(parseChargeItemDefinitionPropertyGroupComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionApplicabilityComponent(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
    parseChargeItemDefinitionApplicabilityComponentProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionApplicabilityComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition"))
      res.setCondition(parseExpression(getJObject(json, "condition")));
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("relatedArtifact"))
      res.setRelatedArtifact(parseRelatedArtifact(getJObject(json, "relatedArtifact")));
  }

  protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionPropertyGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
    ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
    parseChargeItemDefinitionPropertyGroupComponentProperties(json, res);
    return res;
  }

  protected void parseChargeItemDefinitionPropertyGroupComponentProperties(JsonObject json, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("applicability")) {
      JsonArray array = getJArray(json, "applicability");
      for (int i = 0; i < array.size(); i++) {
        res.getApplicability().add(parseChargeItemDefinitionApplicabilityComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("priceComponent")) {
      JsonArray array = getJArray(json, "priceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getPriceComponent().add(parseMonetaryComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Citation parseCitation(JsonObject json) throws IOException, FHIRFormatError {
    Citation res = new Citation();
    parseCitationProperties(json, res);
    return res;
  }

  protected void parseCitationProperties(JsonObject json, Citation res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("summary")) {
      JsonArray array = getJArray(json, "summary");
      for (int i = 0; i < array.size(); i++) {
        res.getSummary().add(parseCitationSummaryComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("classification")) {
      JsonArray array = getJArray(json, "classification");
      for (int i = 0; i < array.size(); i++) {
        res.getClassification().add(parseCitationClassificationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("currentState")) {
      JsonArray array = getJArray(json, "currentState");
      for (int i = 0; i < array.size(); i++) {
        res.getCurrentState().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("statusDate")) {
      JsonArray array = getJArray(json, "statusDate");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusDate().add(parseCitationStatusDateComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("citedArtifact"))
      res.setCitedArtifact(parseCitationCitedArtifactComponent(getJObject(json, "citedArtifact")));
  }

  protected Citation.CitationSummaryComponent parseCitationSummaryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationSummaryComponent res = new Citation.CitationSummaryComponent();
    parseCitationSummaryComponentProperties(json, res);
    return res;
  }

  protected void parseCitationSummaryComponentProperties(JsonObject json, Citation.CitationSummaryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("style"))
      res.setStyle(parseCodeableConcept(getJObject(json, "style")));
    if (json.has("text"))
      res.setTextElement(parseMarkdown(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected Citation.CitationClassificationComponent parseCitationClassificationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationClassificationComponent res = new Citation.CitationClassificationComponent();
    parseCitationClassificationComponentProperties(json, res);
    return res;
  }

  protected void parseCitationClassificationComponentProperties(JsonObject json, Citation.CitationClassificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("classifier")) {
      JsonArray array = getJArray(json, "classifier");
      for (int i = 0; i < array.size(); i++) {
        res.getClassifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Citation.CitationStatusDateComponent parseCitationStatusDateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationStatusDateComponent res = new Citation.CitationStatusDateComponent();
    parseCitationStatusDateComponentProperties(json, res);
    return res;
  }

  protected void parseCitationStatusDateComponentProperties(JsonObject json, Citation.CitationStatusDateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("activity"))
      res.setActivity(parseCodeableConcept(getJObject(json, "activity")));
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(getJObject(json, "_actual"), res.getActualElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Citation.CitationCitedArtifactComponent parseCitationCitedArtifactComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactComponent res = new Citation.CitationCitedArtifactComponent();
    parseCitationCitedArtifactComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactComponentProperties(JsonObject json, Citation.CitationCitedArtifactComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedIdentifier")) {
      JsonArray array = getJArray(json, "relatedIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("dateAccessed"))
      res.setDateAccessedElement(parseDateTime(json.get("dateAccessed").getAsString()));
    if (json.has("_dateAccessed"))
      parseElementProperties(getJObject(json, "_dateAccessed"), res.getDateAccessedElement());
    if (json.has("version"))
      res.setVersion(parseCitationCitedArtifactVersionComponent(getJObject(json, "version")));
    if (json.has("currentState")) {
      JsonArray array = getJArray(json, "currentState");
      for (int i = 0; i < array.size(); i++) {
        res.getCurrentState().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("statusDate")) {
      JsonArray array = getJArray(json, "statusDate");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusDate().add(parseCitationCitedArtifactStatusDateComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("title")) {
      JsonArray array = getJArray(json, "title");
      for (int i = 0; i < array.size(); i++) {
        res.getTitle().add(parseCitationCitedArtifactTitleComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("abstract")) {
      JsonArray array = getJArray(json, "abstract");
      for (int i = 0; i < array.size(); i++) {
        res.getAbstract().add(parseCitationCitedArtifactAbstractComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("part"))
      res.setPart(parseCitationCitedArtifactPartComponent(getJObject(json, "part")));
    if (json.has("relatesTo")) {
      JsonArray array = getJArray(json, "relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseCitationCitedArtifactRelatesToComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("publicationForm")) {
      JsonArray array = getJArray(json, "publicationForm");
      for (int i = 0; i < array.size(); i++) {
        res.getPublicationForm().add(parseCitationCitedArtifactPublicationFormComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("webLocation")) {
      JsonArray array = getJArray(json, "webLocation");
      for (int i = 0; i < array.size(); i++) {
        res.getWebLocation().add(parseCitationCitedArtifactWebLocationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("classification")) {
      JsonArray array = getJArray(json, "classification");
      for (int i = 0; i < array.size(); i++) {
        res.getClassification().add(parseCitationCitedArtifactClassificationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("contributorship"))
      res.setContributorship(parseCitationCitedArtifactContributorshipComponent(getJObject(json, "contributorship")));
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Citation.CitationCitedArtifactVersionComponent parseCitationCitedArtifactVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactVersionComponent res = new Citation.CitationCitedArtifactVersionComponent();
    parseCitationCitedArtifactVersionComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactVersionComponentProperties(JsonObject json, Citation.CitationCitedArtifactVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("baseCitation"))
      res.setBaseCitation(parseReference(getJObject(json, "baseCitation")));
  }

  protected Citation.CitationCitedArtifactStatusDateComponent parseCitationCitedArtifactStatusDateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactStatusDateComponent res = new Citation.CitationCitedArtifactStatusDateComponent();
    parseCitationCitedArtifactStatusDateComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactStatusDateComponentProperties(JsonObject json, Citation.CitationCitedArtifactStatusDateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("activity"))
      res.setActivity(parseCodeableConcept(getJObject(json, "activity")));
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(getJObject(json, "_actual"), res.getActualElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Citation.CitationCitedArtifactTitleComponent parseCitationCitedArtifactTitleComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactTitleComponent res = new Citation.CitationCitedArtifactTitleComponent();
    parseCitationCitedArtifactTitleComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactTitleComponentProperties(JsonObject json, Citation.CitationCitedArtifactTitleComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(getJObject(json, "language")));
    if (json.has("text"))
      res.setTextElement(parseMarkdown(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected Citation.CitationCitedArtifactAbstractComponent parseCitationCitedArtifactAbstractComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactAbstractComponent res = new Citation.CitationCitedArtifactAbstractComponent();
    parseCitationCitedArtifactAbstractComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactAbstractComponentProperties(JsonObject json, Citation.CitationCitedArtifactAbstractComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(getJObject(json, "language")));
    if (json.has("text"))
      res.setTextElement(parseMarkdown(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
  }

  protected Citation.CitationCitedArtifactPartComponent parseCitationCitedArtifactPartComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactPartComponent res = new Citation.CitationCitedArtifactPartComponent();
    parseCitationCitedArtifactPartComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactPartComponentProperties(JsonObject json, Citation.CitationCitedArtifactPartComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("baseCitation"))
      res.setBaseCitation(parseReference(getJObject(json, "baseCitation")));
  }

  protected Citation.CitationCitedArtifactRelatesToComponent parseCitationCitedArtifactRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactRelatesToComponent res = new Citation.CitationCitedArtifactRelatesToComponent();
    parseCitationCitedArtifactRelatesToComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactRelatesToComponentProperties(JsonObject json, Citation.CitationCitedArtifactRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Citation.RelatedArtifactTypeExpanded.NULL, new Citation.RelatedArtifactTypeExpandedEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("classifier")) {
      JsonArray array = getJArray(json, "classifier");
      for (int i = 0; i < array.size(); i++) {
        res.getClassifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("label"))
      res.setLabelElement(parseString(json.get("label").getAsString()));
    if (json.has("_label"))
      parseElementProperties(getJObject(json, "_label"), res.getLabelElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("citation"))
      res.setCitationElement(parseMarkdown(json.get("citation").getAsString()));
    if (json.has("_citation"))
      parseElementProperties(getJObject(json, "_citation"), res.getCitationElement());
    if (json.has("document"))
      res.setDocument(parseAttachment(getJObject(json, "document")));
    if (json.has("resource"))
      res.setResourceElement(parseCanonical(json.get("resource").getAsString()));
    if (json.has("_resource"))
      parseElementProperties(getJObject(json, "_resource"), res.getResourceElement());
    if (json.has("resourceReference"))
      res.setResourceReference(parseReference(getJObject(json, "resourceReference")));
  }

  protected Citation.CitationCitedArtifactPublicationFormComponent parseCitationCitedArtifactPublicationFormComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactPublicationFormComponent res = new Citation.CitationCitedArtifactPublicationFormComponent();
    parseCitationCitedArtifactPublicationFormComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactPublicationFormComponentProperties(JsonObject json, Citation.CitationCitedArtifactPublicationFormComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("publishedIn"))
      res.setPublishedIn(parseCitationCitedArtifactPublicationFormPublishedInComponent(getJObject(json, "publishedIn")));
    if (json.has("citedMedium"))
      res.setCitedMedium(parseCodeableConcept(getJObject(json, "citedMedium")));
    if (json.has("volume"))
      res.setVolumeElement(parseString(json.get("volume").getAsString()));
    if (json.has("_volume"))
      parseElementProperties(getJObject(json, "_volume"), res.getVolumeElement());
    if (json.has("issue"))
      res.setIssueElement(parseString(json.get("issue").getAsString()));
    if (json.has("_issue"))
      parseElementProperties(getJObject(json, "_issue"), res.getIssueElement());
    if (json.has("articleDate"))
      res.setArticleDateElement(parseDateTime(json.get("articleDate").getAsString()));
    if (json.has("_articleDate"))
      parseElementProperties(getJObject(json, "_articleDate"), res.getArticleDateElement());
    if (json.has("publicationDateText"))
      res.setPublicationDateTextElement(parseString(json.get("publicationDateText").getAsString()));
    if (json.has("_publicationDateText"))
      parseElementProperties(getJObject(json, "_publicationDateText"), res.getPublicationDateTextElement());
    if (json.has("publicationDateSeason"))
      res.setPublicationDateSeasonElement(parseString(json.get("publicationDateSeason").getAsString()));
    if (json.has("_publicationDateSeason"))
      parseElementProperties(getJObject(json, "_publicationDateSeason"), res.getPublicationDateSeasonElement());
    if (json.has("lastRevisionDate"))
      res.setLastRevisionDateElement(parseDateTime(json.get("lastRevisionDate").getAsString()));
    if (json.has("_lastRevisionDate"))
      parseElementProperties(getJObject(json, "_lastRevisionDate"), res.getLastRevisionDateElement());
    if (json.has("language")) {
      JsonArray array = getJArray(json, "language");
      for (int i = 0; i < array.size(); i++) {
        res.getLanguage().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("accessionNumber"))
      res.setAccessionNumberElement(parseString(json.get("accessionNumber").getAsString()));
    if (json.has("_accessionNumber"))
      parseElementProperties(getJObject(json, "_accessionNumber"), res.getAccessionNumberElement());
    if (json.has("pageString"))
      res.setPageStringElement(parseString(json.get("pageString").getAsString()));
    if (json.has("_pageString"))
      parseElementProperties(getJObject(json, "_pageString"), res.getPageStringElement());
    if (json.has("firstPage"))
      res.setFirstPageElement(parseString(json.get("firstPage").getAsString()));
    if (json.has("_firstPage"))
      parseElementProperties(getJObject(json, "_firstPage"), res.getFirstPageElement());
    if (json.has("lastPage"))
      res.setLastPageElement(parseString(json.get("lastPage").getAsString()));
    if (json.has("_lastPage"))
      parseElementProperties(getJObject(json, "_lastPage"), res.getLastPageElement());
    if (json.has("pageCount"))
      res.setPageCountElement(parseString(json.get("pageCount").getAsString()));
    if (json.has("_pageCount"))
      parseElementProperties(getJObject(json, "_pageCount"), res.getPageCountElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
  }

  protected Citation.CitationCitedArtifactPublicationFormPublishedInComponent parseCitationCitedArtifactPublicationFormPublishedInComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactPublicationFormPublishedInComponent res = new Citation.CitationCitedArtifactPublicationFormPublishedInComponent();
    parseCitationCitedArtifactPublicationFormPublishedInComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactPublicationFormPublishedInComponentProperties(JsonObject json, Citation.CitationCitedArtifactPublicationFormPublishedInComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("publisher"))
      res.setPublisher(parseReference(getJObject(json, "publisher")));
    if (json.has("publisherLocation"))
      res.setPublisherLocationElement(parseString(json.get("publisherLocation").getAsString()));
    if (json.has("_publisherLocation"))
      parseElementProperties(getJObject(json, "_publisherLocation"), res.getPublisherLocationElement());
  }

  protected Citation.CitationCitedArtifactWebLocationComponent parseCitationCitedArtifactWebLocationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactWebLocationComponent res = new Citation.CitationCitedArtifactWebLocationComponent();
    parseCitationCitedArtifactWebLocationComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactWebLocationComponentProperties(JsonObject json, Citation.CitationCitedArtifactWebLocationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("classifier")) {
      JsonArray array = getJArray(json, "classifier");
      for (int i = 0; i < array.size(); i++) {
        res.getClassifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
  }

  protected Citation.CitationCitedArtifactClassificationComponent parseCitationCitedArtifactClassificationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactClassificationComponent res = new Citation.CitationCitedArtifactClassificationComponent();
    parseCitationCitedArtifactClassificationComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactClassificationComponentProperties(JsonObject json, Citation.CitationCitedArtifactClassificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("classifier")) {
      JsonArray array = getJArray(json, "classifier");
      for (int i = 0; i < array.size(); i++) {
        res.getClassifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("artifactAssessment")) {
      JsonArray array = getJArray(json, "artifactAssessment");
      for (int i = 0; i < array.size(); i++) {
        res.getArtifactAssessment().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Citation.CitationCitedArtifactContributorshipComponent parseCitationCitedArtifactContributorshipComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactContributorshipComponent res = new Citation.CitationCitedArtifactContributorshipComponent();
    parseCitationCitedArtifactContributorshipComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactContributorshipComponentProperties(JsonObject json, Citation.CitationCitedArtifactContributorshipComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("complete"))
      res.setCompleteElement(parseBoolean(json.get("complete").getAsBoolean()));
    if (json.has("_complete"))
      parseElementProperties(getJObject(json, "_complete"), res.getCompleteElement());
    if (json.has("entry")) {
      JsonArray array = getJArray(json, "entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseCitationCitedArtifactContributorshipEntryComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("summary")) {
      JsonArray array = getJArray(json, "summary");
      for (int i = 0; i < array.size(); i++) {
        res.getSummary().add(parseCitationContributorshipSummaryComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Citation.CitationCitedArtifactContributorshipEntryComponent parseCitationCitedArtifactContributorshipEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactContributorshipEntryComponent res = new Citation.CitationCitedArtifactContributorshipEntryComponent();
    parseCitationCitedArtifactContributorshipEntryComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactContributorshipEntryComponentProperties(JsonObject json, Citation.CitationCitedArtifactContributorshipEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("contributor"))
      res.setContributor(parseReference(getJObject(json, "contributor")));
    if (json.has("forenameInitials"))
      res.setForenameInitialsElement(parseString(json.get("forenameInitials").getAsString()));
    if (json.has("_forenameInitials"))
      parseElementProperties(getJObject(json, "_forenameInitials"), res.getForenameInitialsElement());
    if (json.has("affiliation")) {
      JsonArray array = getJArray(json, "affiliation");
      for (int i = 0; i < array.size(); i++) {
        res.getAffiliation().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("contributionType")) {
      JsonArray array = getJArray(json, "contributionType");
      for (int i = 0; i < array.size(); i++) {
        res.getContributionType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("contributionInstance")) {
      JsonArray array = getJArray(json, "contributionInstance");
      for (int i = 0; i < array.size(); i++) {
        res.getContributionInstance().add(parseCitationCitedArtifactContributorshipEntryContributionInstanceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("correspondingContact"))
      res.setCorrespondingContactElement(parseBoolean(json.get("correspondingContact").getAsBoolean()));
    if (json.has("_correspondingContact"))
      parseElementProperties(getJObject(json, "_correspondingContact"), res.getCorrespondingContactElement());
    if (json.has("rankingOrder"))
      res.setRankingOrderElement(parsePositiveInt(json.get("rankingOrder").getAsString()));
    if (json.has("_rankingOrder"))
      parseElementProperties(getJObject(json, "_rankingOrder"), res.getRankingOrderElement());
  }

  protected Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent parseCitationCitedArtifactContributorshipEntryContributionInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent res = new Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent();
    parseCitationCitedArtifactContributorshipEntryContributionInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseCitationCitedArtifactContributorshipEntryContributionInstanceComponentProperties(JsonObject json, Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(getJObject(json, "_time"), res.getTimeElement());
  }

  protected Citation.ContributorshipSummaryComponent parseCitationContributorshipSummaryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Citation.ContributorshipSummaryComponent res = new Citation.ContributorshipSummaryComponent();
    parseCitationContributorshipSummaryComponentProperties(json, res);
    return res;
  }

  protected void parseCitationContributorshipSummaryComponentProperties(JsonObject json, Citation.ContributorshipSummaryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("style"))
      res.setStyle(parseCodeableConcept(getJObject(json, "style")));
    if (json.has("source"))
      res.setSource(parseCodeableConcept(getJObject(json, "source")));
    if (json.has("value"))
      res.setValueElement(parseMarkdown(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected Claim parseClaim(JsonObject json) throws IOException, FHIRFormatError {
    Claim res = new Claim();
    parseClaimProperties(json, res);
    return res;
  }

  protected void parseClaimProperties(JsonObject json, Claim res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(getJObject(json, "billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(getJObject(json, "fundsReserve")));
    if (json.has("related")) {
      JsonArray array = getJArray(json, "related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseClaimRelatedClaimComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(getJObject(json, "prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(getJObject(json, "originalPrescription")));
    if (json.has("payee"))
      res.setPayee(parseClaimPayeeComponent(getJObject(json, "payee")));
    if (json.has("referral"))
      res.setReferral(parseReference(getJObject(json, "referral")));
    if (json.has("encounter")) {
      JsonArray array = getJArray(json, "encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("facility"))
      res.setFacility(parseReference(getJObject(json, "facility")));
    if (json.has("diagnosisRelatedGroup"))
      res.setDiagnosisRelatedGroup(parseCodeableConcept(getJObject(json, "diagnosisRelatedGroup")));
    if (json.has("event")) {
      JsonArray array = getJArray(json, "event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseClaimEventComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = getJArray(json, "careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseClaimCareTeamComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseClaimSupportingInformationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = getJArray(json, "diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseClaimDiagnosisComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = getJArray(json, "procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseClaimProcedureComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = getJArray(json, "insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimInsuranceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseClaimAccidentComponent(getJObject(json, "accident")));
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("item")) {
      JsonArray array = getJArray(json, "item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("total"))
      res.setTotal(parseMoney(getJObject(json, "total")));
  }

  protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
    parseClaimRelatedClaimComponentProperties(json, res);
    return res;
  }

  protected void parseClaimRelatedClaimComponentProperties(JsonObject json, Claim.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(getJObject(json, "claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(getJObject(json, "reference")));
  }

  protected Claim.PayeeComponent parseClaimPayeeComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.PayeeComponent res = new Claim.PayeeComponent();
    parseClaimPayeeComponentProperties(json, res);
    return res;
  }

  protected void parseClaimPayeeComponentProperties(JsonObject json, Claim.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
  }

  protected Claim.ClaimEventComponent parseClaimEventComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.ClaimEventComponent res = new Claim.ClaimEventComponent();
    parseClaimEventComponentProperties(json, res);
    return res;
  }

  protected void parseClaimEventComponentProperties(JsonObject json, Claim.ClaimEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType when = parseType("when", json);
    if (when != null)
      res.setWhen(when);
  }

  protected Claim.CareTeamComponent parseClaimCareTeamComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.CareTeamComponent res = new Claim.CareTeamComponent();
    parseClaimCareTeamComponentProperties(json, res);
    return res;
  }

  protected void parseClaimCareTeamComponentProperties(JsonObject json, Claim.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(getJObject(json, "_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("specialty"))
      res.setSpecialty(parseCodeableConcept(getJObject(json, "specialty")));
  }

  protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
    parseClaimSupportingInformationComponentProperties(json, res);
    return res;
  }

  protected void parseClaimSupportingInformationComponentProperties(JsonObject json, Claim.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(getJObject(json, "reason")));
  }

  protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
    parseClaimDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseClaimDiagnosisComponentProperties(JsonObject json, Claim.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    DataType diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmission(parseCodeableConcept(getJObject(json, "onAdmission")));
  }

  protected Claim.ProcedureComponent parseClaimProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.ProcedureComponent res = new Claim.ProcedureComponent();
    parseClaimProcedureComponentProperties(json, res);
    return res;
  }

  protected void parseClaimProcedureComponentProperties(JsonObject json, Claim.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    DataType procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
    if (json.has("udi")) {
      JsonArray array = getJArray(json, "udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Claim.InsuranceComponent parseClaimInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.InsuranceComponent res = new Claim.InsuranceComponent();
    parseClaimInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseClaimInsuranceComponentProperties(JsonObject json, Claim.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(getJObject(json, "_focal"), res.getFocalElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("preAuthRef")) {
      JsonArray array = getJArray(json, "preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {;
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = getJArray(json, "_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(getJObject(json, "claimResponse")));
  }

  protected Claim.AccidentComponent parseClaimAccidentComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.AccidentComponent res = new Claim.AccidentComponent();
    parseClaimAccidentComponentProperties(json, res);
    return res;
  }

  protected void parseClaimAccidentComponentProperties(JsonObject json, Claim.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected Claim.ItemComponent parseClaimItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.ItemComponent res = new Claim.ItemComponent();
    parseClaimItemComponentProperties(json, res);
    return res;
  }

  protected void parseClaimItemComponentProperties(JsonObject json, Claim.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("careTeamSequence")) {
      JsonArray array = getJArray(json, "careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCareTeamSequence().add(new PositiveIntType());
        } else {;
          res.getCareTeamSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_careTeamSequence")) {
      JsonArray array = getJArray(json, "_careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamSequence().size())
          res.getCareTeamSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getCareTeamSequence().get(i));
      }
    };
    if (json.has("diagnosisSequence")) {
      JsonArray array = getJArray(json, "diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDiagnosisSequence().add(new PositiveIntType());
        } else {;
          res.getDiagnosisSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_diagnosisSequence")) {
      JsonArray array = getJArray(json, "_diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisSequence().size())
          res.getDiagnosisSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDiagnosisSequence().get(i));
      }
    };
    if (json.has("procedureSequence")) {
      JsonArray array = getJArray(json, "procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProcedureSequence().add(new PositiveIntType());
        } else {;
          res.getProcedureSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_procedureSequence")) {
      JsonArray array = getJArray(json, "_procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureSequence().size())
          res.getProcedureSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProcedureSequence().get(i));
      }
    };
    if (json.has("informationSequence")) {
      JsonArray array = getJArray(json, "informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInformationSequence().add(new PositiveIntType());
        } else {;
          res.getInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_informationSequence")) {
      JsonArray array = getJArray(json, "_informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationSequence().size())
          res.getInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInformationSequence().get(i));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("request")) {
      JsonArray array = getJArray(json, "request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = getJArray(json, "programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = getJArray(json, "udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = getJArray(json, "bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseClaimBodySiteComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = getJArray(json, "encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Claim.BodySiteComponent parseClaimBodySiteComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.BodySiteComponent res = new Claim.BodySiteComponent();
    parseClaimBodySiteComponentProperties(json, res);
    return res;
  }

  protected void parseClaimBodySiteComponentProperties(JsonObject json, Claim.BodySiteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("site")) {
      JsonArray array = getJArray(json, "site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subSite")) {
      JsonArray array = getJArray(json, "subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Claim.DetailComponent parseClaimDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.DetailComponent res = new Claim.DetailComponent();
    parseClaimDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimDetailComponentProperties(JsonObject json, Claim.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = getJArray(json, "programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = getJArray(json, "udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = getJArray(json, "subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimSubDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Claim.SubDetailComponent parseClaimSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    Claim.SubDetailComponent res = new Claim.SubDetailComponent();
    parseClaimSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimSubDetailComponentProperties(JsonObject json, Claim.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = getJArray(json, "programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = getJArray(json, "udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse parseClaimResponse(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse res = new ClaimResponse();
    parseClaimResponseProperties(json, res);
    return res;
  }

  protected void parseClaimResponseProperties(JsonObject json, ClaimResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("requestor"))
      res.setRequestor(parseReference(getJObject(json, "requestor")));
    if (json.has("request"))
      res.setRequest(parseReference(getJObject(json, "request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("decision"))
      res.setDecision(parseCodeableConcept(getJObject(json, "decision")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("preAuthPeriod"))
      res.setPreAuthPeriod(parsePeriod(getJObject(json, "preAuthPeriod")));
    if (json.has("event")) {
      JsonArray array = getJArray(json, "event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseClaimResponseEventComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("payeeType"))
      res.setPayeeType(parseCodeableConcept(getJObject(json, "payeeType")));
    if (json.has("encounter")) {
      JsonArray array = getJArray(json, "encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("diagnosisRelatedGroup"))
      res.setDiagnosisRelatedGroup(parseCodeableConcept(getJObject(json, "diagnosisRelatedGroup")));
    if (json.has("item")) {
      JsonArray array = getJArray(json, "item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseClaimResponseItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = getJArray(json, "addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseClaimResponseAddedItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("total")) {
      JsonArray array = getJArray(json, "total");
      for (int i = 0; i < array.size(); i++) {
        res.getTotal().add(parseClaimResponseTotalComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("payment"))
      res.setPayment(parseClaimResponsePaymentComponent(getJObject(json, "payment")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(getJObject(json, "fundsReserve")));
    if (json.has("formCode"))
      res.setFormCode(parseCodeableConcept(getJObject(json, "formCode")));
    if (json.has("form"))
      res.setForm(parseAttachment(getJObject(json, "form")));
    if (json.has("processNote")) {
      JsonArray array = getJArray(json, "processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseClaimResponseNoteComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("communicationRequest")) {
      JsonArray array = getJArray(json, "communicationRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunicationRequest().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = getJArray(json, "insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseClaimResponseInsuranceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("error")) {
      JsonArray array = getJArray(json, "error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseClaimResponseErrorComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse.ClaimResponseEventComponent parseClaimResponseEventComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.ClaimResponseEventComponent res = new ClaimResponse.ClaimResponseEventComponent();
    parseClaimResponseEventComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseEventComponentProperties(JsonObject json, ClaimResponse.ClaimResponseEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType when = parseType("when", json);
    if (when != null)
      res.setWhen(when);
  }

  protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
    parseClaimResponseItemComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseItemComponentProperties(JsonObject json, ClaimResponse.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence"))
      res.setItemSequenceElement(parsePositiveInt(json.get("itemSequence").getAsString()));
    if (json.has("_itemSequence"))
      parseElementProperties(getJObject(json, "_itemSequence"), res.getItemSequenceElement());
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseClaimResponseReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseItemDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse.ReviewOutcomeComponent parseClaimResponseReviewOutcomeComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.ReviewOutcomeComponent res = new ClaimResponse.ReviewOutcomeComponent();
    parseClaimResponseReviewOutcomeComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseReviewOutcomeComponentProperties(JsonObject json, ClaimResponse.ReviewOutcomeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("decision"))
      res.setDecision(parseCodeableConcept(getJObject(json, "decision")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("preAuthPeriod"))
      res.setPreAuthPeriod(parsePeriod(getJObject(json, "preAuthPeriod")));
  }

  protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
    parseClaimResponseAdjudicationComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseAdjudicationComponentProperties(JsonObject json, ClaimResponse.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(getJObject(json, "reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
  }

  protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
    parseClaimResponseItemDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseItemDetailComponentProperties(JsonObject json, ClaimResponse.ItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("detailSequence"))
      res.setDetailSequenceElement(parsePositiveInt(json.get("detailSequence").getAsString()));
    if (json.has("_detailSequence"))
      parseElementProperties(getJObject(json, "_detailSequence"), res.getDetailSequenceElement());
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseClaimResponseReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = getJArray(json, "subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseSubDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
    parseClaimResponseSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseSubDetailComponentProperties(JsonObject json, ClaimResponse.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("subDetailSequence"))
      res.setSubDetailSequenceElement(parsePositiveInt(json.get("subDetailSequence").getAsString()));
    if (json.has("_subDetailSequence"))
      parseElementProperties(getJObject(json, "_subDetailSequence"), res.getSubDetailSequenceElement());
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseClaimResponseReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
    parseClaimResponseAddedItemComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseAddedItemComponentProperties(JsonObject json, ClaimResponse.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence")) {
      JsonArray array = getJArray(json, "itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getItemSequence().add(new PositiveIntType());
        } else {;
          res.getItemSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_itemSequence")) {
      JsonArray array = getJArray(json, "_itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getItemSequence().size())
          res.getItemSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getItemSequence().get(i));
      }
    };
    if (json.has("detailSequence")) {
      JsonArray array = getJArray(json, "detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDetailSequence().add(new PositiveIntType());
        } else {;
          res.getDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_detailSequence")) {
      JsonArray array = getJArray(json, "_detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDetailSequence().size())
          res.getDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDetailSequence().get(i));
      }
    };
    if (json.has("subdetailSequence")) {
      JsonArray array = getJArray(json, "subdetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSubdetailSequence().add(new PositiveIntType());
        } else {;
          res.getSubdetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_subdetailSequence")) {
      JsonArray array = getJArray(json, "_subdetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubdetailSequence().size())
          res.getSubdetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSubdetailSequence().get(i));
      }
    };
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("provider")) {
      JsonArray array = getJArray(json, "provider");
      for (int i = 0; i < array.size(); i++) {
        res.getProvider().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("request")) {
      JsonArray array = getJArray(json, "request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = getJArray(json, "programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("bodySite")) {
      JsonArray array = getJArray(json, "bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseClaimResponseBodySiteComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseClaimResponseReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseClaimResponseAddedItemDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse.BodySiteComponent parseClaimResponseBodySiteComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.BodySiteComponent res = new ClaimResponse.BodySiteComponent();
    parseClaimResponseBodySiteComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseBodySiteComponentProperties(JsonObject json, ClaimResponse.BodySiteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("site")) {
      JsonArray array = getJArray(json, "site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subSite")) {
      JsonArray array = getJArray(json, "subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
    parseClaimResponseAddedItemDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseAddedItemDetailComponentProperties(JsonObject json, ClaimResponse.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseClaimResponseReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = getJArray(json, "subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseClaimResponseAddedItemSubDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
    parseClaimResponseAddedItemSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseAddedItemSubDetailComponentProperties(JsonObject json, ClaimResponse.AddedItemSubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseClaimResponseReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseClaimResponseAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
    parseClaimResponseTotalComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseTotalComponentProperties(JsonObject json, ClaimResponse.TotalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
  }

  protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
    parseClaimResponsePaymentComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponsePaymentComponentProperties(JsonObject json, ClaimResponse.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(getJObject(json, "adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(getJObject(json, "adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
  }

  protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
    parseClaimResponseNoteComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseNoteComponentProperties(JsonObject json, ClaimResponse.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(getJObject(json, "language")));
  }

  protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
    parseClaimResponseInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseInsuranceComponentProperties(JsonObject json, ClaimResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(getJObject(json, "_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(getJObject(json, "claimResponse")));
  }

  protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
    parseClaimResponseErrorComponentProperties(json, res);
    return res;
  }

  protected void parseClaimResponseErrorComponentProperties(JsonObject json, ClaimResponse.ErrorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence"))
      res.setItemSequenceElement(parsePositiveInt(json.get("itemSequence").getAsString()));
    if (json.has("_itemSequence"))
      parseElementProperties(getJObject(json, "_itemSequence"), res.getItemSequenceElement());
    if (json.has("detailSequence"))
      res.setDetailSequenceElement(parsePositiveInt(json.get("detailSequence").getAsString()));
    if (json.has("_detailSequence"))
      parseElementProperties(getJObject(json, "_detailSequence"), res.getDetailSequenceElement());
    if (json.has("subDetailSequence"))
      res.setSubDetailSequenceElement(parsePositiveInt(json.get("subDetailSequence").getAsString()));
    if (json.has("_subDetailSequence"))
      parseElementProperties(getJObject(json, "_subDetailSequence"), res.getSubDetailSequenceElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("expression")) {
      JsonArray array = getJArray(json, "expression");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getExpression().add(new StringType());
        } else {;
          res.getExpression().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_expression")) {
      JsonArray array = getJArray(json, "_expression");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExpression().size())
          res.getExpression().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getExpression().get(i));
      }
    };
  }

  protected ClinicalImpression parseClinicalImpression(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalImpression res = new ClinicalImpression();
    parseClinicalImpressionProperties(json, res);
    return res;
  }

  protected void parseClinicalImpressionProperties(JsonObject json, ClinicalImpression res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    DataType effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
    if (json.has("previous"))
      res.setPrevious(parseReference(getJObject(json, "previous")));
    if (json.has("problem")) {
      JsonArray array = getJArray(json, "problem");
      for (int i = 0; i < array.size(); i++) {
        res.getProblem().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("changePattern"))
      res.setChangePattern(parseCodeableConcept(getJObject(json, "changePattern")));
    if (json.has("protocol")) {
      JsonArray array = getJArray(json, "protocol");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProtocol().add(new UriType());
        } else {;
          res.getProtocol().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_protocol")) {
      JsonArray array = getJArray(json, "_protocol");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProtocol().size())
          res.getProtocol().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProtocol().get(i));
      }
    };
    if (json.has("summary"))
      res.setSummaryElement(parseString(json.get("summary").getAsString()));
    if (json.has("_summary"))
      parseElementProperties(getJObject(json, "_summary"), res.getSummaryElement());
    if (json.has("finding")) {
      JsonArray array = getJArray(json, "finding");
      for (int i = 0; i < array.size(); i++) {
        res.getFinding().add(parseClinicalImpressionFindingComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("prognosisCodeableConcept")) {
      JsonArray array = getJArray(json, "prognosisCodeableConcept");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisCodeableConcept().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("prognosisReference")) {
      JsonArray array = getJArray(json, "prognosisReference");
      for (int i = 0; i < array.size(); i++) {
        res.getPrognosisReference().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionFindingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
    parseClinicalImpressionFindingComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalImpressionFindingComponentProperties(JsonObject json, ClinicalImpression.ClinicalImpressionFindingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("item"))
      res.setItem(parseCodeableReference(getJObject(json, "item")));
    if (json.has("basis"))
      res.setBasisElement(parseString(json.get("basis").getAsString()));
    if (json.has("_basis"))
      parseElementProperties(getJObject(json, "_basis"), res.getBasisElement());
  }

  protected ClinicalUseDefinition parseClinicalUseDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseDefinition res = new ClinicalUseDefinition();
    parseClinicalUseDefinitionProperties(json, res);
    return res;
  }

  protected void parseClinicalUseDefinitionProperties(JsonObject json, ClinicalUseDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ClinicalUseDefinition.ClinicalUseDefinitionType.NULL, new ClinicalUseDefinition.ClinicalUseDefinitionTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject")) {
      JsonArray array = getJArray(json, "subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("contraindication"))
      res.setContraindication(parseClinicalUseDefinitionContraindicationComponent(getJObject(json, "contraindication")));
    if (json.has("indication"))
      res.setIndication(parseClinicalUseDefinitionIndicationComponent(getJObject(json, "indication")));
    if (json.has("interaction"))
      res.setInteraction(parseClinicalUseDefinitionInteractionComponent(getJObject(json, "interaction")));
    if (json.has("population")) {
      JsonArray array = getJArray(json, "population");
      for (int i = 0; i < array.size(); i++) {
        res.getPopulation().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("library")) {
      JsonArray array = getJArray(json, "library");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLibrary().add(new CanonicalType());
        } else {;
          res.getLibrary().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_library")) {
      JsonArray array = getJArray(json, "_library");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLibrary().size())
          res.getLibrary().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getLibrary().get(i));
      }
    };
    if (json.has("undesirableEffect"))
      res.setUndesirableEffect(parseClinicalUseDefinitionUndesirableEffectComponent(getJObject(json, "undesirableEffect")));
    if (json.has("warning"))
      res.setWarning(parseClinicalUseDefinitionWarningComponent(getJObject(json, "warning")));
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent parseClinicalUseDefinitionContraindicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent();
    parseClinicalUseDefinitionContraindicationComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseDefinitionContraindicationComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("diseaseSymptomProcedure"))
      res.setDiseaseSymptomProcedure(parseCodeableReference(getJObject(json, "diseaseSymptomProcedure")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableReference(getJObject(json, "diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = getJArray(json, "comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("indication")) {
      JsonArray array = getJArray(json, "indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("applicability"))
      res.setApplicability(parseExpression(getJObject(json, "applicability")));
    if (json.has("otherTherapy")) {
      JsonArray array = getJArray(json, "otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseClinicalUseDefinitionContraindicationOtherTherapyComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent parseClinicalUseDefinitionContraindicationOtherTherapyComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent();
    parseClinicalUseDefinitionContraindicationOtherTherapyComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseDefinitionContraindicationOtherTherapyComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relationshipType"))
      res.setRelationshipType(parseCodeableConcept(getJObject(json, "relationshipType")));
    if (json.has("treatment"))
      res.setTreatment(parseCodeableReference(getJObject(json, "treatment")));
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent parseClinicalUseDefinitionIndicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent();
    parseClinicalUseDefinitionIndicationComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseDefinitionIndicationComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("diseaseSymptomProcedure"))
      res.setDiseaseSymptomProcedure(parseCodeableReference(getJObject(json, "diseaseSymptomProcedure")));
    if (json.has("diseaseStatus"))
      res.setDiseaseStatus(parseCodeableReference(getJObject(json, "diseaseStatus")));
    if (json.has("comorbidity")) {
      JsonArray array = getJArray(json, "comorbidity");
      for (int i = 0; i < array.size(); i++) {
        res.getComorbidity().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("intendedEffect"))
      res.setIntendedEffect(parseCodeableReference(getJObject(json, "intendedEffect")));
    DataType duration = parseType("duration", json);
    if (duration != null)
      res.setDuration(duration);
    if (json.has("undesirableEffect")) {
      JsonArray array = getJArray(json, "undesirableEffect");
      for (int i = 0; i < array.size(); i++) {
        res.getUndesirableEffect().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("applicability"))
      res.setApplicability(parseExpression(getJObject(json, "applicability")));
    if (json.has("otherTherapy")) {
      JsonArray array = getJArray(json, "otherTherapy");
      for (int i = 0; i < array.size(); i++) {
        res.getOtherTherapy().add(parseClinicalUseDefinitionContraindicationOtherTherapyComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent parseClinicalUseDefinitionInteractionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent();
    parseClinicalUseDefinitionInteractionComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseDefinitionInteractionComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("interactant")) {
      JsonArray array = getJArray(json, "interactant");
      for (int i = 0; i < array.size(); i++) {
        res.getInteractant().add(parseClinicalUseDefinitionInteractionInteractantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("effect"))
      res.setEffect(parseCodeableReference(getJObject(json, "effect")));
    if (json.has("incidence"))
      res.setIncidence(parseCodeableConcept(getJObject(json, "incidence")));
    if (json.has("management")) {
      JsonArray array = getJArray(json, "management");
      for (int i = 0; i < array.size(); i++) {
        res.getManagement().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent parseClinicalUseDefinitionInteractionInteractantComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent();
    parseClinicalUseDefinitionInteractionInteractantComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseDefinitionInteractionInteractantComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType item = parseType("item", json);
    if (item != null)
      res.setItem(item);
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent parseClinicalUseDefinitionUndesirableEffectComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent();
    parseClinicalUseDefinitionUndesirableEffectComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseDefinitionUndesirableEffectComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("symptomConditionEffect"))
      res.setSymptomConditionEffect(parseCodeableReference(getJObject(json, "symptomConditionEffect")));
    if (json.has("classification"))
      res.setClassification(parseCodeableConcept(getJObject(json, "classification")));
    if (json.has("frequencyOfOccurrence"))
      res.setFrequencyOfOccurrence(parseCodeableConcept(getJObject(json, "frequencyOfOccurrence")));
  }

  protected ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent parseClinicalUseDefinitionWarningComponent(JsonObject json) throws IOException, FHIRFormatError {
    ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent();
    parseClinicalUseDefinitionWarningComponentProperties(json, res);
    return res;
  }

  protected void parseClinicalUseDefinitionWarningComponentProperties(JsonObject json, ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected CodeSystem parseCodeSystem(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem res = new CodeSystem();
    parseCodeSystemProperties(json, res);
    return res;
  }

  protected void parseCodeSystemProperties(JsonObject json, CodeSystem res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = getJArray(json, "topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("caseSensitive"))
      res.setCaseSensitiveElement(parseBoolean(json.get("caseSensitive").getAsBoolean()));
    if (json.has("_caseSensitive"))
      parseElementProperties(getJObject(json, "_caseSensitive"), res.getCaseSensitiveElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("hierarchyMeaning"))
      res.setHierarchyMeaningElement(parseEnumeration(json.get("hierarchyMeaning").getAsString(), CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
    if (json.has("_hierarchyMeaning"))
      parseElementProperties(getJObject(json, "_hierarchyMeaning"), res.getHierarchyMeaningElement());
    if (json.has("compositional"))
      res.setCompositionalElement(parseBoolean(json.get("compositional").getAsBoolean()));
    if (json.has("_compositional"))
      parseElementProperties(getJObject(json, "_compositional"), res.getCompositionalElement());
    if (json.has("versionNeeded"))
      res.setVersionNeededElement(parseBoolean(json.get("versionNeeded").getAsBoolean()));
    if (json.has("_versionNeeded"))
      parseElementProperties(getJObject(json, "_versionNeeded"), res.getVersionNeededElement());
    if (json.has("content"))
      res.setContentElement(parseEnumeration(json.get("content").getAsString(), Enumerations.CodeSystemContentMode.NULL, new Enumerations.CodeSystemContentModeEnumFactory()));
    if (json.has("_content"))
      parseElementProperties(getJObject(json, "_content"), res.getContentElement());
    if (json.has("supplements"))
      res.setSupplementsElement(parseCanonical(json.get("supplements").getAsString()));
    if (json.has("_supplements"))
      parseElementProperties(getJObject(json, "_supplements"), res.getSupplementsElement());
    if (json.has("count"))
      res.setCountElement(parseUnsignedInt(json.get("count").getAsString()));
    if (json.has("_count"))
      parseElementProperties(getJObject(json, "_count"), res.getCountElement());
    if (json.has("filter")) {
      JsonArray array = getJArray(json, "filter");
      for (int i = 0; i < array.size(); i++) {
        res.getFilter().add(parseCodeSystemFilterComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("property")) {
      JsonArray array = getJArray(json, "property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemPropertyComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("concept")) {
      JsonArray array = getJArray(json, "concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CodeSystem.CodeSystemFilterComponent parseCodeSystemFilterComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
    parseCodeSystemFilterComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemFilterComponentProperties(JsonObject json, CodeSystem.CodeSystemFilterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("operator")) {
      JsonArray array = getJArray(json, "operator");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getOperator().add(new Enumeration<Enumerations.FilterOperator>(new Enumerations.FilterOperatorEnumFactory(), Enumerations.FilterOperator.NULL));
        } else {;
          res.getOperator().add(parseEnumeration(array.get(i).getAsString(), Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
        }
      }
    };
    if (json.has("_operator")) {
      JsonArray array = getJArray(json, "_operator");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOperator().size())
          res.getOperator().add(parseEnumeration(null, Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getOperator().get(i));
      }
    };
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
    parseCodeSystemPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemPropertyComponentProperties(JsonObject json, CodeSystem.PropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(getJObject(json, "_uri"), res.getUriElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
  }

  protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
    parseCodeSystemConceptDefinitionComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionComponentProperties(JsonObject json, CodeSystem.ConceptDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("definition"))
      res.setDefinitionElement(parseString(json.get("definition").getAsString()));
    if (json.has("_definition"))
      parseElementProperties(getJObject(json, "_definition"), res.getDefinitionElement());
    if (json.has("designation")) {
      JsonArray array = getJArray(json, "designation");
      for (int i = 0; i < array.size(); i++) {
        res.getDesignation().add(parseCodeSystemConceptDefinitionDesignationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("property")) {
      JsonArray array = getJArray(json, "property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseCodeSystemConceptPropertyComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("concept")) {
      JsonArray array = getJArray(json, "concept");
      for (int i = 0; i < array.size(); i++) {
        res.getConcept().add(parseCodeSystemConceptDefinitionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
    parseCodeSystemConceptDefinitionDesignationComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemConceptDefinitionDesignationComponentProperties(JsonObject json, CodeSystem.ConceptDefinitionDesignationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseCode(json.get("language").getAsString()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("use"))
      res.setUse(parseCoding(getJObject(json, "use")));
    if (json.has("additionalUse")) {
      JsonArray array = getJArray(json, "additionalUse");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalUse().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
    parseCodeSystemConceptPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseCodeSystemConceptPropertyComponentProperties(JsonObject json, CodeSystem.ConceptPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Communication parseCommunication(JsonObject json) throws IOException, FHIRFormatError {
    Communication res = new Communication();
    parseCommunicationProperties(json, res);
    return res;
  }

  protected void parseCommunicationProperties(JsonObject json, Communication res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = getJArray(json, "instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = getJArray(json, "_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = getJArray(json, "instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = getJArray(json, "_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = getJArray(json, "partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("inResponseTo")) {
      JsonArray array = getJArray(json, "inResponseTo");
      for (int i = 0; i < array.size(); i++) {
        res.getInResponseTo().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("medium")) {
      JsonArray array = getJArray(json, "medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("topic"))
      res.setTopic(parseCodeableConcept(getJObject(json, "topic")));
    if (json.has("about")) {
      JsonArray array = getJArray(json, "about");
      for (int i = 0; i < array.size(); i++) {
        res.getAbout().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("sent"))
      res.setSentElement(parseDateTime(json.get("sent").getAsString()));
    if (json.has("_sent"))
      parseElementProperties(getJObject(json, "_sent"), res.getSentElement());
    if (json.has("received"))
      res.setReceivedElement(parseDateTime(json.get("received").getAsString()));
    if (json.has("_received"))
      parseElementProperties(getJObject(json, "_received"), res.getReceivedElement());
    if (json.has("recipient")) {
      JsonArray array = getJArray(json, "recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("sender"))
      res.setSender(parseReference(getJObject(json, "sender")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("payload")) {
      JsonArray array = getJArray(json, "payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationPayloadComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Communication.CommunicationPayloadComponent parseCommunicationPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
    Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
    parseCommunicationPayloadComponentProperties(json, res);
    return res;
  }

  protected void parseCommunicationPayloadComponentProperties(JsonObject json, Communication.CommunicationPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CommunicationRequest parseCommunicationRequest(JsonObject json) throws IOException, FHIRFormatError {
    CommunicationRequest res = new CommunicationRequest();
    parseCommunicationRequestProperties(json, res);
    return res;
  }

  protected void parseCommunicationRequestProperties(JsonObject json, CommunicationRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = getJArray(json, "replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(getJObject(json, "groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("medium")) {
      JsonArray array = getJArray(json, "medium");
      for (int i = 0; i < array.size(); i++) {
        res.getMedium().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("about")) {
      JsonArray array = getJArray(json, "about");
      for (int i = 0; i < array.size(); i++) {
        res.getAbout().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("payload")) {
      JsonArray array = getJArray(json, "payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseCommunicationRequestPayloadComponent(getJsonObjectFromArray(array, i)));
      }
    };
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(getJObject(json, "requester")));
    if (json.has("recipient")) {
      JsonArray array = getJArray(json, "recipient");
      for (int i = 0; i < array.size(); i++) {
        res.getRecipient().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("informationProvider")) {
      JsonArray array = getJArray(json, "informationProvider");
      for (int i = 0; i < array.size(); i++) {
        res.getInformationProvider().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
    CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
    parseCommunicationRequestPayloadComponentProperties(json, res);
    return res;
  }

  protected void parseCommunicationRequestPayloadComponentProperties(JsonObject json, CommunicationRequest.CommunicationRequestPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected CompartmentDefinition parseCompartmentDefinition(JsonObject json) throws IOException, FHIRFormatError {
    CompartmentDefinition res = new CompartmentDefinition();
    parseCompartmentDefinitionProperties(json, res);
    return res;
  }

  protected void parseCompartmentDefinitionProperties(JsonObject json, CompartmentDefinition res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("search"))
      res.setSearchElement(parseBoolean(json.get("search").getAsBoolean()));
    if (json.has("_search"))
      parseElementProperties(getJObject(json, "_search"), res.getSearchElement());
    if (json.has("resource")) {
      JsonArray array = getJArray(json, "resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseCompartmentDefinitionResourceComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
    parseCompartmentDefinitionResourceComponentProperties(json, res);
    return res;
  }

  protected void parseCompartmentDefinitionResourceComponentProperties(JsonObject json, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("param")) {
      JsonArray array = getJArray(json, "param");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getParam().add(new StringType());
        } else {;
          res.getParam().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_param")) {
      JsonArray array = getJArray(json, "_param");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getParam().size())
          res.getParam().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getParam().get(i));
      }
    };
    if (json.has("documentation"))
      res.setDocumentationElement(parseString(json.get("documentation").getAsString()));
    if (json.has("_documentation"))
      parseElementProperties(getJObject(json, "_documentation"), res.getDocumentationElement());
    if (json.has("startParam"))
      res.setStartParamElement(parseUri(json.get("startParam").getAsString()));
    if (json.has("_startParam"))
      parseElementProperties(getJObject(json, "_startParam"), res.getStartParamElement());
    if (json.has("endParam"))
      res.setEndParamElement(parseUri(json.get("endParam").getAsString()));
    if (json.has("_endParam"))
      parseElementProperties(getJObject(json, "_endParam"), res.getEndParamElement());
  }

  protected Composition parseComposition(JsonObject json) throws IOException, FHIRFormatError {
    Composition res = new Composition();
    parseCompositionProperties(json, res);
    return res;
  }

  protected void parseCompositionProperties(JsonObject json, Composition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject")) {
      JsonArray array = getJArray(json, "subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("attester")) {
      JsonArray array = getJArray(json, "attester");
      for (int i = 0; i < array.size(); i++) {
        res.getAttester().add(parseCompositionAttesterComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("custodian"))
      res.setCustodian(parseReference(getJObject(json, "custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = getJArray(json, "relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("event")) {
      JsonArray array = getJArray(json, "event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCompositionEventComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("section")) {
      JsonArray array = getJArray(json, "section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Composition.CompositionAttesterComponent parseCompositionAttesterComponent(JsonObject json) throws IOException, FHIRFormatError {
    Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
    parseCompositionAttesterComponentProperties(json, res);
    return res;
  }

  protected void parseCompositionAttesterComponentProperties(JsonObject json, Composition.CompositionAttesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setMode(parseCodeableConcept(getJObject(json, "mode")));
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(getJObject(json, "_time"), res.getTimeElement());
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
  }

  protected Composition.CompositionEventComponent parseCompositionEventComponent(JsonObject json) throws IOException, FHIRFormatError {
    Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
    parseCompositionEventComponentProperties(json, res);
    return res;
  }

  protected void parseCompositionEventComponentProperties(JsonObject json, Composition.CompositionEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Composition.SectionComponent parseCompositionSectionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Composition.SectionComponent res = new Composition.SectionComponent();
    parseCompositionSectionComponentProperties(json, res);
    return res;
  }

  protected void parseCompositionSectionComponentProperties(JsonObject json, Composition.SectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("focus"))
      res.setFocus(parseReference(getJObject(json, "focus")));
    if (json.has("text"))
      res.setText(parseNarrative(getJObject(json, "text")));
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(getJObject(json, "orderedBy")));
    if (json.has("entry")) {
      JsonArray array = getJArray(json, "entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(getJObject(json, "emptyReason")));
    if (json.has("section")) {
      JsonArray array = getJArray(json, "section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseCompositionSectionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ConceptMap parseConceptMap(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap res = new ConceptMap();
    parseConceptMapProperties(json, res);
    return res;
  }

  protected void parseConceptMapProperties(JsonObject json, ConceptMap res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = getJArray(json, "topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("property")) {
      JsonArray array = getJArray(json, "property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseConceptMapPropertyComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("additionalAttribute")) {
      JsonArray array = getJArray(json, "additionalAttribute");
      for (int i = 0; i < array.size(); i++) {
        res.getAdditionalAttribute().add(parseConceptMapAdditionalAttributeComponent(getJsonObjectFromArray(array, i)));
      }
    };
    DataType sourceScope = parseType("sourceScope", json);
    if (sourceScope != null)
      res.setSourceScope(sourceScope);
    DataType targetScope = parseType("targetScope", json);
    if (targetScope != null)
      res.setTargetScope(targetScope);
    if (json.has("group")) {
      JsonArray array = getJArray(json, "group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseConceptMapGroupComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ConceptMap.PropertyComponent parseConceptMapPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.PropertyComponent res = new ConceptMap.PropertyComponent();
    parseConceptMapPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapPropertyComponentProperties(JsonObject json, ConceptMap.PropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(getJObject(json, "_uri"), res.getUriElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ConceptMap.ConceptMapPropertyType.NULL, new ConceptMap.ConceptMapPropertyTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("system"))
      res.setSystemElement(parseCanonical(json.get("system").getAsString()));
    if (json.has("_system"))
      parseElementProperties(getJObject(json, "_system"), res.getSystemElement());
  }

  protected ConceptMap.AdditionalAttributeComponent parseConceptMapAdditionalAttributeComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.AdditionalAttributeComponent res = new ConceptMap.AdditionalAttributeComponent();
    parseConceptMapAdditionalAttributeComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapAdditionalAttributeComponentProperties(JsonObject json, ConceptMap.AdditionalAttributeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("uri"))
      res.setUriElement(parseUri(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(getJObject(json, "_uri"), res.getUriElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ConceptMap.ConceptMapAttributeType.NULL, new ConceptMap.ConceptMapAttributeTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
  }

  protected ConceptMap.ConceptMapGroupComponent parseConceptMapGroupComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
    parseConceptMapGroupComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapGroupComponentProperties(JsonObject json, ConceptMap.ConceptMapGroupComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("source"))
      res.setSourceElement(parseCanonical(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
    if (json.has("target"))
      res.setTargetElement(parseCanonical(json.get("target").getAsString()));
    if (json.has("_target"))
      parseElementProperties(getJObject(json, "_target"), res.getTargetElement());
    if (json.has("element")) {
      JsonArray array = getJArray(json, "element");
      for (int i = 0; i < array.size(); i++) {
        res.getElement().add(parseConceptMapSourceElementComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("unmapped"))
      res.setUnmapped(parseConceptMapGroupUnmappedComponent(getJObject(json, "unmapped")));
  }

  protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
    parseConceptMapSourceElementComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapSourceElementComponentProperties(JsonObject json, ConceptMap.SourceElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("noMap"))
      res.setNoMapElement(parseBoolean(json.get("noMap").getAsBoolean()));
    if (json.has("_noMap"))
      parseElementProperties(getJObject(json, "_noMap"), res.getNoMapElement());
    if (json.has("target")) {
      JsonArray array = getJArray(json, "target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseConceptMapTargetElementComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
    parseConceptMapTargetElementComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapTargetElementComponentProperties(JsonObject json, ConceptMap.TargetElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("relationship"))
      res.setRelationshipElement(parseEnumeration(json.get("relationship").getAsString(), Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
    if (json.has("_relationship"))
      parseElementProperties(getJObject(json, "_relationship"), res.getRelationshipElement());
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("property")) {
      JsonArray array = getJArray(json, "property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseConceptMapMappingPropertyComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("dependsOn")) {
      JsonArray array = getJArray(json, "dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseConceptMapOtherElementComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("product")) {
      JsonArray array = getJArray(json, "product");
      for (int i = 0; i < array.size(); i++) {
        res.getProduct().add(parseConceptMapOtherElementComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ConceptMap.MappingPropertyComponent parseConceptMapMappingPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.MappingPropertyComponent res = new ConceptMap.MappingPropertyComponent();
    parseConceptMapMappingPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapMappingPropertyComponentProperties(JsonObject json, ConceptMap.MappingPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
    parseConceptMapOtherElementComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapOtherElementComponentProperties(JsonObject json, ConceptMap.OtherElementComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("attribute"))
      res.setAttributeElement(parseCode(json.get("attribute").getAsString()));
    if (json.has("_attribute"))
      parseElementProperties(getJObject(json, "_attribute"), res.getAttributeElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
  }

  protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapGroupUnmappedComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
    parseConceptMapGroupUnmappedComponentProperties(json, res);
    return res;
  }

  protected void parseConceptMapGroupUnmappedComponentProperties(JsonObject json, ConceptMap.ConceptMapGroupUnmappedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("display"))
      res.setDisplayElement(parseString(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("valueSet"))
      res.setValueSetElement(parseCanonical(json.get("valueSet").getAsString()));
    if (json.has("_valueSet"))
      parseElementProperties(getJObject(json, "_valueSet"), res.getValueSetElement());
    if (json.has("relationship"))
      res.setRelationshipElement(parseEnumeration(json.get("relationship").getAsString(), Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
    if (json.has("_relationship"))
      parseElementProperties(getJObject(json, "_relationship"), res.getRelationshipElement());
    if (json.has("otherMap"))
      res.setOtherMapElement(parseCanonical(json.get("otherMap").getAsString()));
    if (json.has("_otherMap"))
      parseElementProperties(getJObject(json, "_otherMap"), res.getOtherMapElement());
  }

  protected Condition parseCondition(JsonObject json) throws IOException, FHIRFormatError {
    Condition res = new Condition();
    parseConditionProperties(json, res);
    return res;
  }

  protected void parseConditionProperties(JsonObject json, Condition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("clinicalStatus"))
      res.setClinicalStatus(parseCodeableConcept(getJObject(json, "clinicalStatus")));
    if (json.has("verificationStatus"))
      res.setVerificationStatus(parseCodeableConcept(getJObject(json, "verificationStatus")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(getJObject(json, "severity")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("bodySite")) {
      JsonArray array = getJArray(json, "bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    DataType onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    DataType abatement = parseType("abatement", json);
    if (abatement != null)
      res.setAbatement(abatement);
    if (json.has("recordedDate"))
      res.setRecordedDateElement(parseDateTime(json.get("recordedDate").getAsString()));
    if (json.has("_recordedDate"))
      parseElementProperties(getJObject(json, "_recordedDate"), res.getRecordedDateElement());
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseConditionParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("stage")) {
      JsonArray array = getJArray(json, "stage");
      for (int i = 0; i < array.size(); i++) {
        res.getStage().add(parseConditionStageComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("evidence")) {
      JsonArray array = getJArray(json, "evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Condition.ConditionParticipantComponent parseConditionParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    Condition.ConditionParticipantComponent res = new Condition.ConditionParticipantComponent();
    parseConditionParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseConditionParticipantComponentProperties(JsonObject json, Condition.ConditionParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected Condition.ConditionStageComponent parseConditionStageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
    parseConditionStageComponentProperties(json, res);
    return res;
  }

  protected void parseConditionStageComponentProperties(JsonObject json, Condition.ConditionStageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("summary"))
      res.setSummary(parseCodeableConcept(getJObject(json, "summary")));
    if (json.has("assessment")) {
      JsonArray array = getJArray(json, "assessment");
      for (int i = 0; i < array.size(); i++) {
        res.getAssessment().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
  }

  protected ConditionDefinition parseConditionDefinition(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition res = new ConditionDefinition();
    parseConditionDefinitionProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionProperties(JsonObject json, ConditionDefinition res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("severity"))
      res.setSeverity(parseCodeableConcept(getJObject(json, "severity")));
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableConcept(getJObject(json, "bodySite")));
    if (json.has("stage"))
      res.setStage(parseCodeableConcept(getJObject(json, "stage")));
    if (json.has("hasSeverity"))
      res.setHasSeverityElement(parseBoolean(json.get("hasSeverity").getAsBoolean()));
    if (json.has("_hasSeverity"))
      parseElementProperties(getJObject(json, "_hasSeverity"), res.getHasSeverityElement());
    if (json.has("hasBodySite"))
      res.setHasBodySiteElement(parseBoolean(json.get("hasBodySite").getAsBoolean()));
    if (json.has("_hasBodySite"))
      parseElementProperties(getJObject(json, "_hasBodySite"), res.getHasBodySiteElement());
    if (json.has("hasStage"))
      res.setHasStageElement(parseBoolean(json.get("hasStage").getAsBoolean()));
    if (json.has("_hasStage"))
      parseElementProperties(getJObject(json, "_hasStage"), res.getHasStageElement());
    if (json.has("definition")) {
      JsonArray array = getJArray(json, "definition");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDefinition().add(new UriType());
        } else {;
          res.getDefinition().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_definition")) {
      JsonArray array = getJArray(json, "_definition");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDefinition().size())
          res.getDefinition().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDefinition().get(i));
      }
    };
    if (json.has("observation")) {
      JsonArray array = getJArray(json, "observation");
      for (int i = 0; i < array.size(); i++) {
        res.getObservation().add(parseConditionDefinitionObservationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("medication")) {
      JsonArray array = getJArray(json, "medication");
      for (int i = 0; i < array.size(); i++) {
        res.getMedication().add(parseConditionDefinitionMedicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("precondition")) {
      JsonArray array = getJArray(json, "precondition");
      for (int i = 0; i < array.size(); i++) {
        res.getPrecondition().add(parseConditionDefinitionPreconditionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("team")) {
      JsonArray array = getJArray(json, "team");
      for (int i = 0; i < array.size(); i++) {
        res.getTeam().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("questionnaire")) {
      JsonArray array = getJArray(json, "questionnaire");
      for (int i = 0; i < array.size(); i++) {
        res.getQuestionnaire().add(parseConditionDefinitionQuestionnaireComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("plan")) {
      JsonArray array = getJArray(json, "plan");
      for (int i = 0; i < array.size(); i++) {
        res.getPlan().add(parseConditionDefinitionPlanComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ConditionDefinition.ConditionDefinitionObservationComponent parseConditionDefinitionObservationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionObservationComponent res = new ConditionDefinition.ConditionDefinitionObservationComponent();
    parseConditionDefinitionObservationComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionObservationComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionObservationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected ConditionDefinition.ConditionDefinitionMedicationComponent parseConditionDefinitionMedicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionMedicationComponent res = new ConditionDefinition.ConditionDefinitionMedicationComponent();
    parseConditionDefinitionMedicationComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionMedicationComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionMedicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected ConditionDefinition.ConditionDefinitionPreconditionComponent parseConditionDefinitionPreconditionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionPreconditionComponent res = new ConditionDefinition.ConditionDefinitionPreconditionComponent();
    parseConditionDefinitionPreconditionComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionPreconditionComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionPreconditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), ConditionDefinition.ConditionPreconditionType.NULL, new ConditionDefinition.ConditionPreconditionTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ConditionDefinition.ConditionDefinitionQuestionnaireComponent parseConditionDefinitionQuestionnaireComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionQuestionnaireComponent res = new ConditionDefinition.ConditionDefinitionQuestionnaireComponent();
    parseConditionDefinitionQuestionnaireComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionQuestionnaireComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionQuestionnaireComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("purpose"))
      res.setPurposeElement(parseEnumeration(json.get("purpose").getAsString(), ConditionDefinition.ConditionQuestionnairePurpose.NULL, new ConditionDefinition.ConditionQuestionnairePurposeEnumFactory()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
  }

  protected ConditionDefinition.ConditionDefinitionPlanComponent parseConditionDefinitionPlanComponent(JsonObject json) throws IOException, FHIRFormatError {
    ConditionDefinition.ConditionDefinitionPlanComponent res = new ConditionDefinition.ConditionDefinitionPlanComponent();
    parseConditionDefinitionPlanComponentProperties(json, res);
    return res;
  }

  protected void parseConditionDefinitionPlanComponentProperties(JsonObject json, ConditionDefinition.ConditionDefinitionPlanComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
  }

  protected Consent parseConsent(JsonObject json) throws IOException, FHIRFormatError {
    Consent res = new Consent();
    parseConsentProperties(json, res);
    return res;
  }

  protected void parseConsentProperties(JsonObject json, Consent res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("grantor")) {
      JsonArray array = getJArray(json, "grantor");
      for (int i = 0; i < array.size(); i++) {
        res.getGrantor().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("grantee")) {
      JsonArray array = getJArray(json, "grantee");
      for (int i = 0; i < array.size(); i++) {
        res.getGrantee().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("manager")) {
      JsonArray array = getJArray(json, "manager");
      for (int i = 0; i < array.size(); i++) {
        res.getManager().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("controller")) {
      JsonArray array = getJArray(json, "controller");
      for (int i = 0; i < array.size(); i++) {
        res.getController().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("sourceAttachment")) {
      JsonArray array = getJArray(json, "sourceAttachment");
      for (int i = 0; i < array.size(); i++) {
        res.getSourceAttachment().add(parseAttachment(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("sourceReference")) {
      JsonArray array = getJArray(json, "sourceReference");
      for (int i = 0; i < array.size(); i++) {
        res.getSourceReference().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("regulatoryBasis")) {
      JsonArray array = getJArray(json, "regulatoryBasis");
      for (int i = 0; i < array.size(); i++) {
        res.getRegulatoryBasis().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("policyBasis"))
      res.setPolicyBasis(parseConsentPolicyBasisComponent(getJObject(json, "policyBasis")));
    if (json.has("policyText")) {
      JsonArray array = getJArray(json, "policyText");
      for (int i = 0; i < array.size(); i++) {
        res.getPolicyText().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("verification")) {
      JsonArray array = getJArray(json, "verification");
      for (int i = 0; i < array.size(); i++) {
        res.getVerification().add(parseConsentVerificationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("decision"))
      res.setDecisionElement(parseEnumeration(json.get("decision").getAsString(), Enumerations.ConsentProvisionType.NULL, new Enumerations.ConsentProvisionTypeEnumFactory()));
    if (json.has("_decision"))
      parseElementProperties(getJObject(json, "_decision"), res.getDecisionElement());
    if (json.has("provision")) {
      JsonArray array = getJArray(json, "provision");
      for (int i = 0; i < array.size(); i++) {
        res.getProvision().add(parseConsentProvisionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Consent.ConsentPolicyBasisComponent parseConsentPolicyBasisComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ConsentPolicyBasisComponent res = new Consent.ConsentPolicyBasisComponent();
    parseConsentPolicyBasisComponentProperties(json, res);
    return res;
  }

  protected void parseConsentPolicyBasisComponentProperties(JsonObject json, Consent.ConsentPolicyBasisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    if (json.has("url"))
      res.setUrlElement(parseUrl(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
  }

  protected Consent.ConsentVerificationComponent parseConsentVerificationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
    parseConsentVerificationComponentProperties(json, res);
    return res;
  }

  protected void parseConsentVerificationComponentProperties(JsonObject json, Consent.ConsentVerificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("verified"))
      res.setVerifiedElement(parseBoolean(json.get("verified").getAsBoolean()));
    if (json.has("_verified"))
      parseElementProperties(getJObject(json, "_verified"), res.getVerifiedElement());
    if (json.has("verificationType"))
      res.setVerificationType(parseCodeableConcept(getJObject(json, "verificationType")));
    if (json.has("verifiedBy"))
      res.setVerifiedBy(parseReference(getJObject(json, "verifiedBy")));
    if (json.has("verifiedWith"))
      res.setVerifiedWith(parseReference(getJObject(json, "verifiedWith")));
    if (json.has("verificationDate")) {
      JsonArray array = getJArray(json, "verificationDate");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getVerificationDate().add(new DateTimeType());
        } else {;
          res.getVerificationDate().add(parseDateTime(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_verificationDate")) {
      JsonArray array = getJArray(json, "_verificationDate");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getVerificationDate().size())
          res.getVerificationDate().add(parseDateTime(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getVerificationDate().get(i));
      }
    };
  }

  protected Consent.ProvisionComponent parseConsentProvisionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ProvisionComponent res = new Consent.ProvisionComponent();
    parseConsentProvisionComponentProperties(json, res);
    return res;
  }

  protected void parseConsentProvisionComponentProperties(JsonObject json, Consent.ProvisionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("actor")) {
      JsonArray array = getJArray(json, "actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseConsentProvisionActorComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("action")) {
      JsonArray array = getJArray(json, "action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("securityLabel")) {
      JsonArray array = getJArray(json, "securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose")) {
      JsonArray array = getJArray(json, "purpose");
      for (int i = 0; i < array.size(); i++) {
        res.getPurpose().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("documentType")) {
      JsonArray array = getJArray(json, "documentType");
      for (int i = 0; i < array.size(); i++) {
        res.getDocumentType().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("resourceType")) {
      JsonArray array = getJArray(json, "resourceType");
      for (int i = 0; i < array.size(); i++) {
        res.getResourceType().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code")) {
      JsonArray array = getJArray(json, "code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("dataPeriod"))
      res.setDataPeriod(parsePeriod(getJObject(json, "dataPeriod")));
    if (json.has("data")) {
      JsonArray array = getJArray(json, "data");
      for (int i = 0; i < array.size(); i++) {
        res.getData().add(parseConsentProvisionDataComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("expression"))
      res.setExpression(parseExpression(getJObject(json, "expression")));
    if (json.has("provision")) {
      JsonArray array = getJArray(json, "provision");
      for (int i = 0; i < array.size(); i++) {
        res.getProvision().add(parseConsentProvisionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Consent.ProvisionActorComponent parseConsentProvisionActorComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ProvisionActorComponent res = new Consent.ProvisionActorComponent();
    parseConsentProvisionActorComponentProperties(json, res);
    return res;
  }

  protected void parseConsentProvisionActorComponentProperties(JsonObject json, Consent.ProvisionActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
  }

  protected Consent.ProvisionDataComponent parseConsentProvisionDataComponent(JsonObject json) throws IOException, FHIRFormatError {
    Consent.ProvisionDataComponent res = new Consent.ProvisionDataComponent();
    parseConsentProvisionDataComponentProperties(json, res);
    return res;
  }

  protected void parseConsentProvisionDataComponentProperties(JsonObject json, Consent.ProvisionDataComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("meaning"))
      res.setMeaningElement(parseEnumeration(json.get("meaning").getAsString(), Enumerations.ConsentDataMeaning.NULL, new Enumerations.ConsentDataMeaningEnumFactory()));
    if (json.has("_meaning"))
      parseElementProperties(getJObject(json, "_meaning"), res.getMeaningElement());
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
  }

  protected Contract parseContract(JsonObject json) throws IOException, FHIRFormatError {
    Contract res = new Contract();
    parseContractProperties(json, res);
    return res;
  }

  protected void parseContractProperties(JsonObject json, Contract res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Contract.ContractResourceStatusCodes.NULL, new Contract.ContractResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("legalState"))
      res.setLegalState(parseCodeableConcept(getJObject(json, "legalState")));
    if (json.has("instantiatesCanonical"))
      res.setInstantiatesCanonical(parseReference(getJObject(json, "instantiatesCanonical")));
    if (json.has("instantiatesUri"))
      res.setInstantiatesUriElement(parseUri(json.get("instantiatesUri").getAsString()));
    if (json.has("_instantiatesUri"))
      parseElementProperties(getJObject(json, "_instantiatesUri"), res.getInstantiatesUriElement());
    if (json.has("contentDerivative"))
      res.setContentDerivative(parseCodeableConcept(getJObject(json, "contentDerivative")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(getJObject(json, "applies")));
    if (json.has("expirationType"))
      res.setExpirationType(parseCodeableConcept(getJObject(json, "expirationType")));
    if (json.has("subject")) {
      JsonArray array = getJArray(json, "subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("authority")) {
      JsonArray array = getJArray(json, "authority");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthority().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("domain")) {
      JsonArray array = getJArray(json, "domain");
      for (int i = 0; i < array.size(); i++) {
        res.getDomain().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("site")) {
      JsonArray array = getJArray(json, "site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("alias")) {
      JsonArray array = getJArray(json, "alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {;
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = getJArray(json, "_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getAlias().get(i));
      }
    };
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(getJObject(json, "scope")));
    DataType topic = parseType("topic", json);
    if (topic != null)
      res.setTopic(topic);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType")) {
      JsonArray array = getJArray(json, "subType");
      for (int i = 0; i < array.size(); i++) {
        res.getSubType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("contentDefinition"))
      res.setContentDefinition(parseContractContentDefinitionComponent(getJObject(json, "contentDefinition")));
    if (json.has("term")) {
      JsonArray array = getJArray(json, "term");
      for (int i = 0; i < array.size(); i++) {
        res.getTerm().add(parseContractTermComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = getJArray(json, "relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("signer")) {
      JsonArray array = getJArray(json, "signer");
      for (int i = 0; i < array.size(); i++) {
        res.getSigner().add(parseContractSignatoryComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("friendly")) {
      JsonArray array = getJArray(json, "friendly");
      for (int i = 0; i < array.size(); i++) {
        res.getFriendly().add(parseContractFriendlyLanguageComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("legal")) {
      JsonArray array = getJArray(json, "legal");
      for (int i = 0; i < array.size(); i++) {
        res.getLegal().add(parseContractLegalLanguageComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("rule")) {
      JsonArray array = getJArray(json, "rule");
      for (int i = 0; i < array.size(); i++) {
        res.getRule().add(parseContractComputableLanguageComponent(getJsonObjectFromArray(array, i)));
      }
    };
    DataType legallyBinding = parseType("legallyBinding", json);
    if (legallyBinding != null)
      res.setLegallyBinding(legallyBinding);
  }

  protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
    parseContractContentDefinitionComponentProperties(json, res);
    return res;
  }

  protected void parseContractContentDefinitionComponentProperties(JsonObject json, Contract.ContentDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("publisher"))
      res.setPublisher(parseReference(getJObject(json, "publisher")));
    if (json.has("publicationDate"))
      res.setPublicationDateElement(parseDateTime(json.get("publicationDate").getAsString()));
    if (json.has("_publicationDate"))
      parseElementProperties(getJObject(json, "_publicationDate"), res.getPublicationDateElement());
    if (json.has("publicationStatus"))
      res.setPublicationStatusElement(parseEnumeration(json.get("publicationStatus").getAsString(), Contract.ContractResourcePublicationStatusCodes.NULL, new Contract.ContractResourcePublicationStatusCodesEnumFactory()));
    if (json.has("_publicationStatus"))
      parseElementProperties(getJObject(json, "_publicationStatus"), res.getPublicationStatusElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
  }

  protected Contract.TermComponent parseContractTermComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.TermComponent res = new Contract.TermComponent();
    parseContractTermComponentProperties(json, res);
    return res;
  }

  protected void parseContractTermComponentProperties(JsonObject json, Contract.TermComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("issued"))
      res.setIssuedElement(parseDateTime(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("applies"))
      res.setApplies(parsePeriod(getJObject(json, "applies")));
    DataType topic = parseType("topic", json);
    if (topic != null)
      res.setTopic(topic);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("securityLabel")) {
      JsonArray array = getJArray(json, "securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseContractSecurityLabelComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("offer"))
      res.setOffer(parseContractOfferComponent(getJObject(json, "offer")));
    if (json.has("asset")) {
      JsonArray array = getJArray(json, "asset");
      for (int i = 0; i < array.size(); i++) {
        res.getAsset().add(parseContractAssetComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("action")) {
      JsonArray array = getJArray(json, "action");
      for (int i = 0; i < array.size(); i++) {
        res.getAction().add(parseContractActionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("group")) {
      JsonArray array = getJArray(json, "group");
      for (int i = 0; i < array.size(); i++) {
        res.getGroup().add(parseContractTermComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
    parseContractSecurityLabelComponentProperties(json, res);
    return res;
  }

  protected void parseContractSecurityLabelComponentProperties(JsonObject json, Contract.SecurityLabelComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number")) {
      JsonArray array = getJArray(json, "number");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNumber().add(new UnsignedIntType());
        } else {;
          res.getNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_number")) {
      JsonArray array = getJArray(json, "_number");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNumber().size())
          res.getNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNumber().get(i));
      }
    };
    if (json.has("classification"))
      res.setClassification(parseCoding(getJObject(json, "classification")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("control")) {
      JsonArray array = getJArray(json, "control");
      for (int i = 0; i < array.size(); i++) {
        res.getControl().add(parseCoding(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Contract.ContractOfferComponent parseContractOfferComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
    parseContractOfferComponentProperties(json, res);
    return res;
  }

  protected void parseContractOfferComponentProperties(JsonObject json, Contract.ContractOfferComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("party")) {
      JsonArray array = getJArray(json, "party");
      for (int i = 0; i < array.size(); i++) {
        res.getParty().add(parseContractPartyComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("topic"))
      res.setTopic(parseReference(getJObject(json, "topic")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("decision"))
      res.setDecision(parseCodeableConcept(getJObject(json, "decision")));
    if (json.has("decisionMode")) {
      JsonArray array = getJArray(json, "decisionMode");
      for (int i = 0; i < array.size(); i++) {
        res.getDecisionMode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("answer")) {
      JsonArray array = getJArray(json, "answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseContractAnswerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("linkId")) {
      JsonArray array = getJArray(json, "linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {;
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = getJArray(json, "_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getLinkId().get(i));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = getJArray(json, "securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {;
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = getJArray(json, "_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ContractPartyComponent parseContractPartyComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
    parseContractPartyComponentProperties(json, res);
    return res;
  }

  protected void parseContractPartyComponentProperties(JsonObject json, Contract.ContractPartyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference")) {
      JsonArray array = getJArray(json, "reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
  }

  protected Contract.AnswerComponent parseContractAnswerComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.AnswerComponent res = new Contract.AnswerComponent();
    parseContractAnswerComponentProperties(json, res);
    return res;
  }

  protected void parseContractAnswerComponentProperties(JsonObject json, Contract.AnswerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Contract.ContractAssetComponent parseContractAssetComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
    parseContractAssetComponentProperties(json, res);
    return res;
  }

  protected void parseContractAssetComponentProperties(JsonObject json, Contract.ContractAssetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("scope"))
      res.setScope(parseCodeableConcept(getJObject(json, "scope")));
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("typeReference")) {
      JsonArray array = getJArray(json, "typeReference");
      for (int i = 0; i < array.size(); i++) {
        res.getTypeReference().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subtype")) {
      JsonArray array = getJArray(json, "subtype");
      for (int i = 0; i < array.size(); i++) {
        res.getSubtype().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relationship"))
      res.setRelationship(parseCoding(getJObject(json, "relationship")));
    if (json.has("context")) {
      JsonArray array = getJArray(json, "context");
      for (int i = 0; i < array.size(); i++) {
        res.getContext().add(parseContractAssetContextComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("condition"))
      res.setConditionElement(parseString(json.get("condition").getAsString()));
    if (json.has("_condition"))
      parseElementProperties(getJObject(json, "_condition"), res.getConditionElement());
    if (json.has("periodType")) {
      JsonArray array = getJArray(json, "periodType");
      for (int i = 0; i < array.size(); i++) {
        res.getPeriodType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("period")) {
      JsonArray array = getJArray(json, "period");
      for (int i = 0; i < array.size(); i++) {
        res.getPeriod().add(parsePeriod(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("usePeriod")) {
      JsonArray array = getJArray(json, "usePeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getUsePeriod().add(parsePeriod(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("linkId")) {
      JsonArray array = getJArray(json, "linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {;
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = getJArray(json, "_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getLinkId().get(i));
      }
    };
    if (json.has("answer")) {
      JsonArray array = getJArray(json, "answer");
      for (int i = 0; i < array.size(); i++) {
        res.getAnswer().add(parseContractAnswerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = getJArray(json, "securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {;
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = getJArray(json, "_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSecurityLabelNumber().get(i));
      }
    };
    if (json.has("valuedItem")) {
      JsonArray array = getJArray(json, "valuedItem");
      for (int i = 0; i < array.size(); i++) {
        res.getValuedItem().add(parseContractValuedItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Contract.AssetContextComponent parseContractAssetContextComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.AssetContextComponent res = new Contract.AssetContextComponent();
    parseContractAssetContextComponentProperties(json, res);
    return res;
  }

  protected void parseContractAssetContextComponentProperties(JsonObject json, Contract.AssetContextComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    if (json.has("code")) {
      JsonArray array = getJArray(json, "code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
  }

  protected Contract.ValuedItemComponent parseContractValuedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
    parseContractValuedItemComponentProperties(json, res);
    return res;
  }

  protected void parseContractValuedItemComponentProperties(JsonObject json, Contract.ValuedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType entity = parseType("entity", json);
    if (entity != null)
      res.setEntity(entity);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("effectiveTime"))
      res.setEffectiveTimeElement(parseDateTime(json.get("effectiveTime").getAsString()));
    if (json.has("_effectiveTime"))
      parseElementProperties(getJObject(json, "_effectiveTime"), res.getEffectiveTimeElement());
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("points"))
      res.setPointsElement(parseDecimal(json.get("points").getAsBigDecimal()));
    if (json.has("_points"))
      parseElementProperties(getJObject(json, "_points"), res.getPointsElement());
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("payment"))
      res.setPaymentElement(parseString(json.get("payment").getAsString()));
    if (json.has("_payment"))
      parseElementProperties(getJObject(json, "_payment"), res.getPaymentElement());
    if (json.has("paymentDate"))
      res.setPaymentDateElement(parseDateTime(json.get("paymentDate").getAsString()));
    if (json.has("_paymentDate"))
      parseElementProperties(getJObject(json, "_paymentDate"), res.getPaymentDateElement());
    if (json.has("responsible"))
      res.setResponsible(parseReference(getJObject(json, "responsible")));
    if (json.has("recipient"))
      res.setRecipient(parseReference(getJObject(json, "recipient")));
    if (json.has("linkId")) {
      JsonArray array = getJArray(json, "linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {;
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = getJArray(json, "_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getLinkId().get(i));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = getJArray(json, "securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {;
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = getJArray(json, "_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ActionComponent parseContractActionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ActionComponent res = new Contract.ActionComponent();
    parseContractActionComponentProperties(json, res);
    return res;
  }

  protected void parseContractActionComponentProperties(JsonObject json, Contract.ActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subject")) {
      JsonArray array = getJArray(json, "subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseContractActionSubjectComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("intent"))
      res.setIntent(parseCodeableConcept(getJObject(json, "intent")));
    if (json.has("linkId")) {
      JsonArray array = getJArray(json, "linkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getLinkId().add(new StringType());
        } else {;
          res.getLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_linkId")) {
      JsonArray array = getJArray(json, "_linkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getLinkId().size())
          res.getLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getLinkId().get(i));
      }
    };
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("context"))
      res.setContext(parseReference(getJObject(json, "context")));
    if (json.has("contextLinkId")) {
      JsonArray array = getJArray(json, "contextLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getContextLinkId().add(new StringType());
        } else {;
          res.getContextLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_contextLinkId")) {
      JsonArray array = getJArray(json, "_contextLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getContextLinkId().size())
          res.getContextLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getContextLinkId().get(i));
      }
    };
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("requester")) {
      JsonArray array = getJArray(json, "requester");
      for (int i = 0; i < array.size(); i++) {
        res.getRequester().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("requesterLinkId")) {
      JsonArray array = getJArray(json, "requesterLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getRequesterLinkId().add(new StringType());
        } else {;
          res.getRequesterLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_requesterLinkId")) {
      JsonArray array = getJArray(json, "_requesterLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getRequesterLinkId().size())
          res.getRequesterLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getRequesterLinkId().get(i));
      }
    };
    if (json.has("performerType")) {
      JsonArray array = getJArray(json, "performerType");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformerType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("performerRole"))
      res.setPerformerRole(parseCodeableConcept(getJObject(json, "performerRole")));
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
    if (json.has("performerLinkId")) {
      JsonArray array = getJArray(json, "performerLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPerformerLinkId().add(new StringType());
        } else {;
          res.getPerformerLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_performerLinkId")) {
      JsonArray array = getJArray(json, "_performerLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPerformerLinkId().size())
          res.getPerformerLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPerformerLinkId().get(i));
      }
    };
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reasonLinkId")) {
      JsonArray array = getJArray(json, "reasonLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getReasonLinkId().add(new StringType());
        } else {;
          res.getReasonLinkId().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_reasonLinkId")) {
      JsonArray array = getJArray(json, "_reasonLinkId");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getReasonLinkId().size())
          res.getReasonLinkId().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getReasonLinkId().get(i));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("securityLabelNumber")) {
      JsonArray array = getJArray(json, "securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSecurityLabelNumber().add(new UnsignedIntType());
        } else {;
          res.getSecurityLabelNumber().add(parseUnsignedInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_securityLabelNumber")) {
      JsonArray array = getJArray(json, "_securityLabelNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSecurityLabelNumber().size())
          res.getSecurityLabelNumber().add(parseUnsignedInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSecurityLabelNumber().get(i));
      }
    };
  }

  protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
    parseContractActionSubjectComponentProperties(json, res);
    return res;
  }

  protected void parseContractActionSubjectComponentProperties(JsonObject json, Contract.ActionSubjectComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference")) {
      JsonArray array = getJArray(json, "reference");
      for (int i = 0; i < array.size(); i++) {
        res.getReference().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
  }

  protected Contract.SignatoryComponent parseContractSignatoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.SignatoryComponent res = new Contract.SignatoryComponent();
    parseContractSignatoryComponentProperties(json, res);
    return res;
  }

  protected void parseContractSignatoryComponentProperties(JsonObject json, Contract.SignatoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(getJObject(json, "type")));
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
    if (json.has("signature")) {
      JsonArray array = getJArray(json, "signature");
      for (int i = 0; i < array.size(); i++) {
        res.getSignature().add(parseSignature(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
    parseContractFriendlyLanguageComponentProperties(json, res);
    return res;
  }

  protected void parseContractFriendlyLanguageComponentProperties(JsonObject json, Contract.FriendlyLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
    parseContractLegalLanguageComponentProperties(json, res);
    return res;
  }

  protected void parseContractLegalLanguageComponentProperties(JsonObject json, Contract.LegalLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(JsonObject json) throws IOException, FHIRFormatError {
    Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
    parseContractComputableLanguageComponentProperties(json, res);
    return res;
  }

  protected void parseContractComputableLanguageComponentProperties(JsonObject json, Contract.ComputableLanguageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType content = parseType("content", json);
    if (content != null)
      res.setContent(content);
  }

  protected Coverage parseCoverage(JsonObject json) throws IOException, FHIRFormatError {
    Coverage res = new Coverage();
    parseCoverageProperties(json, res);
    return res;
  }

  protected void parseCoverageProperties(JsonObject json, Coverage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("kind"))
      res.setKindElement(parseEnumeration(json.get("kind").getAsString(), Coverage.Kind.NULL, new Coverage.KindEnumFactory()));
    if (json.has("_kind"))
      parseElementProperties(getJObject(json, "_kind"), res.getKindElement());
    if (json.has("paymentBy")) {
      JsonArray array = getJArray(json, "paymentBy");
      for (int i = 0; i < array.size(); i++) {
        res.getPaymentBy().add(parseCoveragePaymentByComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("policyHolder"))
      res.setPolicyHolder(parseReference(getJObject(json, "policyHolder")));
    if (json.has("subscriber"))
      res.setSubscriber(parseReference(getJObject(json, "subscriber")));
    if (json.has("subscriberId")) {
      JsonArray array = getJArray(json, "subscriberId");
      for (int i = 0; i < array.size(); i++) {
        res.getSubscriberId().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("beneficiary"))
      res.setBeneficiary(parseReference(getJObject(json, "beneficiary")));
    if (json.has("dependent"))
      res.setDependentElement(parseString(json.get("dependent").getAsString()));
    if (json.has("_dependent"))
      parseElementProperties(getJObject(json, "_dependent"), res.getDependentElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("class")) {
      JsonArray array = getJArray(json, "class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCoverageClassComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("order"))
      res.setOrderElement(parsePositiveInt(json.get("order").getAsString()));
    if (json.has("_order"))
      parseElementProperties(getJObject(json, "_order"), res.getOrderElement());
    if (json.has("network"))
      res.setNetworkElement(parseString(json.get("network").getAsString()));
    if (json.has("_network"))
      parseElementProperties(getJObject(json, "_network"), res.getNetworkElement());
    if (json.has("costToBeneficiary")) {
      JsonArray array = getJArray(json, "costToBeneficiary");
      for (int i = 0; i < array.size(); i++) {
        res.getCostToBeneficiary().add(parseCoverageCostToBeneficiaryComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subrogation"))
      res.setSubrogationElement(parseBoolean(json.get("subrogation").getAsBoolean()));
    if (json.has("_subrogation"))
      parseElementProperties(getJObject(json, "_subrogation"), res.getSubrogationElement());
    if (json.has("contract")) {
      JsonArray array = getJArray(json, "contract");
      for (int i = 0; i < array.size(); i++) {
        res.getContract().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("insurancePlan"))
      res.setInsurancePlan(parseReference(getJObject(json, "insurancePlan")));
  }

  protected Coverage.CoveragePaymentByComponent parseCoveragePaymentByComponent(JsonObject json) throws IOException, FHIRFormatError {
    Coverage.CoveragePaymentByComponent res = new Coverage.CoveragePaymentByComponent();
    parseCoveragePaymentByComponentProperties(json, res);
    return res;
  }

  protected void parseCoveragePaymentByComponentProperties(JsonObject json, Coverage.CoveragePaymentByComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
    if (json.has("responsibility"))
      res.setResponsibilityElement(parseString(json.get("responsibility").getAsString()));
    if (json.has("_responsibility"))
      parseElementProperties(getJObject(json, "_responsibility"), res.getResponsibilityElement());
  }

  protected Coverage.ClassComponent parseCoverageClassComponent(JsonObject json) throws IOException, FHIRFormatError {
    Coverage.ClassComponent res = new Coverage.ClassComponent();
    parseCoverageClassComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageClassComponentProperties(JsonObject json, Coverage.ClassComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("value"))
      res.setValue(parseIdentifier(getJObject(json, "value")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
  }

  protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(JsonObject json) throws IOException, FHIRFormatError {
    Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
    parseCoverageCostToBeneficiaryComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageCostToBeneficiaryComponentProperties(JsonObject json, Coverage.CostToBeneficiaryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(getJObject(json, "network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(getJObject(json, "unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(getJObject(json, "term")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exception")) {
      JsonArray array = getJArray(json, "exception");
      for (int i = 0; i < array.size(); i++) {
        res.getException().add(parseCoverageExemptionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Coverage.ExemptionComponent parseCoverageExemptionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
    parseCoverageExemptionComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageExemptionComponentProperties(JsonObject json, Coverage.ExemptionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected CoverageEligibilityRequest parseCoverageEligibilityRequest(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest res = new CoverageEligibilityRequest();
    parseCoverageEligibilityRequestProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestProperties(JsonObject json, CoverageEligibilityRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("purpose")) {
      JsonArray array = getJArray(json, "purpose");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPurpose().add(new Enumeration<CoverageEligibilityRequest.EligibilityRequestPurpose>(new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL));
        } else {;
          res.getPurpose().add(parseEnumeration(array.get(i).getAsString(), CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        }
      }
    };
    if (json.has("_purpose")) {
      JsonArray array = getJArray(json, "_purpose");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPurpose().size())
          res.getPurpose().add(parseEnumeration(null, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPurpose().get(i));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("event")) {
      JsonArray array = getJArray(json, "event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCoverageEligibilityRequestEventComponent(getJsonObjectFromArray(array, i)));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("facility"))
      res.setFacility(parseReference(getJObject(json, "facility")));
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseCoverageEligibilityRequestSupportingInformationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("insurance")) {
      JsonArray array = getJArray(json, "insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseCoverageEligibilityRequestInsuranceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("item")) {
      JsonArray array = getJArray(json, "item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseCoverageEligibilityRequestDetailsComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CoverageEligibilityRequest.CoverageEligibilityRequestEventComponent parseCoverageEligibilityRequestEventComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.CoverageEligibilityRequestEventComponent res = new CoverageEligibilityRequest.CoverageEligibilityRequestEventComponent();
    parseCoverageEligibilityRequestEventComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestEventComponentProperties(JsonObject json, CoverageEligibilityRequest.CoverageEligibilityRequestEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType when = parseType("when", json);
    if (when != null)
      res.setWhen(when);
  }

  protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
    parseCoverageEligibilityRequestSupportingInformationComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestSupportingInformationComponentProperties(JsonObject json, CoverageEligibilityRequest.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("information"))
      res.setInformation(parseReference(getJObject(json, "information")));
    if (json.has("appliesToAll"))
      res.setAppliesToAllElement(parseBoolean(json.get("appliesToAll").getAsBoolean()));
    if (json.has("_appliesToAll"))
      parseElementProperties(getJObject(json, "_appliesToAll"), res.getAppliesToAllElement());
  }

  protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
    parseCoverageEligibilityRequestInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestInsuranceComponentProperties(JsonObject json, CoverageEligibilityRequest.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(getJObject(json, "_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("businessArrangement"))
      res.setBusinessArrangementElement(parseString(json.get("businessArrangement").getAsString()));
    if (json.has("_businessArrangement"))
      parseElementProperties(getJObject(json, "_businessArrangement"), res.getBusinessArrangementElement());
  }

  protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
    parseCoverageEligibilityRequestDetailsComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestDetailsComponentProperties(JsonObject json, CoverageEligibilityRequest.DetailsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("supportingInfoSequence")) {
      JsonArray array = getJArray(json, "supportingInfoSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSupportingInfoSequence().add(new PositiveIntType());
        } else {;
          res.getSupportingInfoSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_supportingInfoSequence")) {
      JsonArray array = getJArray(json, "_supportingInfoSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSupportingInfoSequence().size())
          res.getSupportingInfoSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSupportingInfoSequence().get(i));
      }
    };
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("facility"))
      res.setFacility(parseReference(getJObject(json, "facility")));
    if (json.has("diagnosis")) {
      JsonArray array = getJArray(json, "diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseCoverageEligibilityRequestDiagnosisComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
    parseCoverageEligibilityRequestDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityRequestDiagnosisComponentProperties(JsonObject json, CoverageEligibilityRequest.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
  }

  protected CoverageEligibilityResponse parseCoverageEligibilityResponse(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse res = new CoverageEligibilityResponse();
    parseCoverageEligibilityResponseProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseProperties(JsonObject json, CoverageEligibilityResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("purpose")) {
      JsonArray array = getJArray(json, "purpose");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPurpose().add(new Enumeration<CoverageEligibilityResponse.EligibilityResponsePurpose>(new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL));
        } else {;
          res.getPurpose().add(parseEnumeration(array.get(i).getAsString(), CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        }
      }
    };
    if (json.has("_purpose")) {
      JsonArray array = getJArray(json, "_purpose");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPurpose().size())
          res.getPurpose().add(parseEnumeration(null, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPurpose().get(i));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("event")) {
      JsonArray array = getJArray(json, "event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCoverageEligibilityResponseEventComponent(getJsonObjectFromArray(array, i)));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("requestor"))
      res.setRequestor(parseReference(getJObject(json, "requestor")));
    if (json.has("request"))
      res.setRequest(parseReference(getJObject(json, "request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), CoverageEligibilityResponse.EligibilityOutcome.NULL, new CoverageEligibilityResponse.EligibilityOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("insurance")) {
      JsonArray array = getJArray(json, "insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseCoverageEligibilityResponseInsuranceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("form"))
      res.setForm(parseCodeableConcept(getJObject(json, "form")));
    if (json.has("error")) {
      JsonArray array = getJArray(json, "error");
      for (int i = 0; i < array.size(); i++) {
        res.getError().add(parseCoverageEligibilityResponseErrorsComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CoverageEligibilityResponse.CoverageEligibilityResponseEventComponent parseCoverageEligibilityResponseEventComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.CoverageEligibilityResponseEventComponent res = new CoverageEligibilityResponse.CoverageEligibilityResponseEventComponent();
    parseCoverageEligibilityResponseEventComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseEventComponentProperties(JsonObject json, CoverageEligibilityResponse.CoverageEligibilityResponseEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType when = parseType("when", json);
    if (when != null)
      res.setWhen(when);
  }

  protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
    parseCoverageEligibilityResponseInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseInsuranceComponentProperties(JsonObject json, CoverageEligibilityResponse.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("inforce"))
      res.setInforceElement(parseBoolean(json.get("inforce").getAsBoolean()));
    if (json.has("_inforce"))
      parseElementProperties(getJObject(json, "_inforce"), res.getInforceElement());
    if (json.has("benefitPeriod"))
      res.setBenefitPeriod(parsePeriod(getJObject(json, "benefitPeriod")));
    if (json.has("item")) {
      JsonArray array = getJArray(json, "item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseCoverageEligibilityResponseItemsComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
    parseCoverageEligibilityResponseItemsComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseItemsComponentProperties(JsonObject json, CoverageEligibilityResponse.ItemsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(getJObject(json, "_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(getJObject(json, "network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(getJObject(json, "unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(getJObject(json, "term")));
    if (json.has("benefit")) {
      JsonArray array = getJArray(json, "benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseCoverageEligibilityResponseBenefitComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("authorizationRequired"))
      res.setAuthorizationRequiredElement(parseBoolean(json.get("authorizationRequired").getAsBoolean()));
    if (json.has("_authorizationRequired"))
      parseElementProperties(getJObject(json, "_authorizationRequired"), res.getAuthorizationRequiredElement());
    if (json.has("authorizationSupporting")) {
      JsonArray array = getJArray(json, "authorizationSupporting");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthorizationSupporting().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("authorizationUrl"))
      res.setAuthorizationUrlElement(parseUri(json.get("authorizationUrl").getAsString()));
    if (json.has("_authorizationUrl"))
      parseElementProperties(getJObject(json, "_authorizationUrl"), res.getAuthorizationUrlElement());
  }

  protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
    parseCoverageEligibilityResponseBenefitComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseBenefitComponentProperties(JsonObject json, CoverageEligibilityResponse.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    DataType used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(JsonObject json) throws IOException, FHIRFormatError {
    CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
    parseCoverageEligibilityResponseErrorsComponentProperties(json, res);
    return res;
  }

  protected void parseCoverageEligibilityResponseErrorsComponentProperties(JsonObject json, CoverageEligibilityResponse.ErrorsComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("expression")) {
      JsonArray array = getJArray(json, "expression");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getExpression().add(new StringType());
        } else {;
          res.getExpression().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_expression")) {
      JsonArray array = getJArray(json, "_expression");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getExpression().size())
          res.getExpression().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getExpression().get(i));
      }
    };
  }

  protected DetectedIssue parseDetectedIssue(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue res = new DetectedIssue();
    parseDetectedIssueProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueProperties(JsonObject json, DetectedIssue res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("severity"))
      res.setSeverityElement(parseEnumeration(json.get("severity").getAsString(), DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
    if (json.has("_severity"))
      parseElementProperties(getJObject(json, "_severity"), res.getSeverityElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    DataType identified = parseType("identified", json);
    if (identified != null)
      res.setIdentified(identified);
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("implicated")) {
      JsonArray array = getJArray(json, "implicated");
      for (int i = 0; i < array.size(); i++) {
        res.getImplicated().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("evidence")) {
      JsonArray array = getJArray(json, "evidence");
      for (int i = 0; i < array.size(); i++) {
        res.getEvidence().add(parseDetectedIssueEvidenceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("detail"))
      res.setDetailElement(parseMarkdown(json.get("detail").getAsString()));
    if (json.has("_detail"))
      parseElementProperties(getJObject(json, "_detail"), res.getDetailElement());
    if (json.has("reference"))
      res.setReferenceElement(parseUri(json.get("reference").getAsString()));
    if (json.has("_reference"))
      parseElementProperties(getJObject(json, "_reference"), res.getReferenceElement());
    if (json.has("mitigation")) {
      JsonArray array = getJArray(json, "mitigation");
      for (int i = 0; i < array.size(); i++) {
        res.getMitigation().add(parseDetectedIssueMitigationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueEvidenceComponent(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
    parseDetectedIssueEvidenceComponentProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueEvidenceComponentProperties(JsonObject json, DetectedIssue.DetectedIssueEvidenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code")) {
      JsonArray array = getJArray(json, "code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueMitigationComponent(JsonObject json) throws IOException, FHIRFormatError {
    DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
    parseDetectedIssueMitigationComponentProperties(json, res);
    return res;
  }

  protected void parseDetectedIssueMitigationComponentProperties(JsonObject json, DetectedIssue.DetectedIssueMitigationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("action"))
      res.setAction(parseCodeableConcept(getJObject(json, "action")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Device parseDevice(JsonObject json) throws IOException, FHIRFormatError {
    Device res = new Device();
    parseDeviceProperties(json, res);
    return res;
  }

  protected void parseDeviceProperties(JsonObject json, Device res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("displayName"))
      res.setDisplayNameElement(parseString(json.get("displayName").getAsString()));
    if (json.has("_displayName"))
      parseElementProperties(getJObject(json, "_displayName"), res.getDisplayNameElement());
    if (json.has("definition"))
      res.setDefinition(parseCodeableReference(getJObject(json, "definition")));
    if (json.has("udiCarrier")) {
      JsonArray array = getJArray(json, "udiCarrier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiCarrier().add(parseDeviceUdiCarrierComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("availabilityStatus"))
      res.setAvailabilityStatus(parseCodeableConcept(getJObject(json, "availabilityStatus")));
    if (json.has("biologicalSourceEvent"))
      res.setBiologicalSourceEvent(parseIdentifier(getJObject(json, "biologicalSourceEvent")));
    if (json.has("manufacturer"))
      res.setManufacturerElement(parseString(json.get("manufacturer").getAsString()));
    if (json.has("_manufacturer"))
      parseElementProperties(getJObject(json, "_manufacturer"), res.getManufacturerElement());
    if (json.has("manufactureDate"))
      res.setManufactureDateElement(parseDateTime(json.get("manufactureDate").getAsString()));
    if (json.has("_manufactureDate"))
      parseElementProperties(getJObject(json, "_manufactureDate"), res.getManufactureDateElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDateTime(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(getJObject(json, "_expirationDate"), res.getExpirationDateElement());
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(getJObject(json, "_lotNumber"), res.getLotNumberElement());
    if (json.has("serialNumber"))
      res.setSerialNumberElement(parseString(json.get("serialNumber").getAsString()));
    if (json.has("_serialNumber"))
      parseElementProperties(getJObject(json, "_serialNumber"), res.getSerialNumberElement());
    if (json.has("name")) {
      JsonArray array = getJArray(json, "name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseDeviceNameComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(getJObject(json, "_modelNumber"), res.getModelNumberElement());
    if (json.has("partNumber"))
      res.setPartNumberElement(parseString(json.get("partNumber").getAsString()));
    if (json.has("_partNumber"))
      parseElementProperties(getJObject(json, "_partNumber"), res.getPartNumberElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version")) {
      JsonArray array = getJArray(json, "version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseDeviceVersionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("conformsTo")) {
      JsonArray array = getJArray(json, "conformsTo");
      for (int i = 0; i < array.size(); i++) {
        res.getConformsTo().add(parseDeviceConformsToComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("property")) {
      JsonArray array = getJArray(json, "property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseDevicePropertyComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("mode"))
      res.setMode(parseCodeableConcept(getJObject(json, "mode")));
    if (json.has("cycle"))
      res.setCycle(parseCount(getJObject(json, "cycle")));
    if (json.has("duration"))
      res.setDuration(parseDuration(getJObject(json, "duration")));
    if (json.has("owner"))
      res.setOwner(parseReference(getJObject(json, "owner")));
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("endpoint")) {
      JsonArray array = getJArray(json, "endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("gateway")) {
      JsonArray array = getJArray(json, "gateway");
      for (int i = 0; i < array.size(); i++) {
        res.getGateway().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("safety")) {
      JsonArray array = getJArray(json, "safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("parent"))
      res.setParent(parseReference(getJObject(json, "parent")));
  }

  protected Device.DeviceUdiCarrierComponent parseDeviceUdiCarrierComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
    parseDeviceUdiCarrierComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceUdiCarrierComponentProperties(JsonObject json, Device.DeviceUdiCarrierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(getJObject(json, "_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
    if (json.has("carrierAIDC"))
      res.setCarrierAIDCElement(parseBase64Binary(json.get("carrierAIDC").getAsString()));
    if (json.has("_carrierAIDC"))
      parseElementProperties(getJObject(json, "_carrierAIDC"), res.getCarrierAIDCElement());
    if (json.has("carrierHRF"))
      res.setCarrierHRFElement(parseString(json.get("carrierHRF").getAsString()));
    if (json.has("_carrierHRF"))
      parseElementProperties(getJObject(json, "_carrierHRF"), res.getCarrierHRFElement());
    if (json.has("entryType"))
      res.setEntryTypeElement(parseEnumeration(json.get("entryType").getAsString(), Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
    if (json.has("_entryType"))
      parseElementProperties(getJObject(json, "_entryType"), res.getEntryTypeElement());
  }

  protected Device.DeviceNameComponent parseDeviceNameComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DeviceNameComponent res = new Device.DeviceNameComponent();
    parseDeviceNameComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceNameComponentProperties(JsonObject json, Device.DeviceNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("display"))
      res.setDisplayElement(parseBoolean(json.get("display").getAsBoolean()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
  }

  protected Device.DeviceVersionComponent parseDeviceVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
    parseDeviceVersionComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceVersionComponentProperties(JsonObject json, Device.DeviceVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("component"))
      res.setComponent(parseIdentifier(getJObject(json, "component")));
    if (json.has("installDate"))
      res.setInstallDateElement(parseDateTime(json.get("installDate").getAsString()));
    if (json.has("_installDate"))
      parseElementProperties(getJObject(json, "_installDate"), res.getInstallDateElement());
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected Device.DeviceConformsToComponent parseDeviceConformsToComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DeviceConformsToComponent res = new Device.DeviceConformsToComponent();
    parseDeviceConformsToComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceConformsToComponentProperties(JsonObject json, Device.DeviceConformsToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("specification"))
      res.setSpecification(parseCodeableConcept(getJObject(json, "specification")));
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
  }

  protected Device.DevicePropertyComponent parseDevicePropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
    parseDevicePropertyComponentProperties(json, res);
    return res;
  }

  protected void parseDevicePropertyComponentProperties(JsonObject json, Device.DevicePropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DeviceAssociation parseDeviceAssociation(JsonObject json) throws IOException, FHIRFormatError {
    DeviceAssociation res = new DeviceAssociation();
    parseDeviceAssociationProperties(json, res);
    return res;
  }

  protected void parseDeviceAssociationProperties(JsonObject json, DeviceAssociation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("statusReason")) {
      JsonArray array = getJArray(json, "statusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("bodyStructure"))
      res.setBodyStructure(parseReference(getJObject(json, "bodyStructure")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("operation")) {
      JsonArray array = getJArray(json, "operation");
      for (int i = 0; i < array.size(); i++) {
        res.getOperation().add(parseDeviceAssociationOperationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceAssociation.DeviceAssociationOperationComponent parseDeviceAssociationOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceAssociation.DeviceAssociationOperationComponent res = new DeviceAssociation.DeviceAssociationOperationComponent();
    parseDeviceAssociationOperationComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceAssociationOperationComponentProperties(JsonObject json, DeviceAssociation.DeviceAssociationOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatus(parseCodeableConcept(getJObject(json, "status")));
    if (json.has("operator")) {
      JsonArray array = getJArray(json, "operator");
      for (int i = 0; i < array.size(); i++) {
        res.getOperator().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected DeviceDefinition parseDeviceDefinition(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition res = new DeviceDefinition();
    parseDeviceDefinitionProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionProperties(JsonObject json, DeviceDefinition res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("udiDeviceIdentifier")) {
      JsonArray array = getJArray(json, "udiDeviceIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiDeviceIdentifier().add(parseDeviceDefinitionUdiDeviceIdentifierComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("regulatoryIdentifier")) {
      JsonArray array = getJArray(json, "regulatoryIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getRegulatoryIdentifier().add(parseDeviceDefinitionRegulatoryIdentifierComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("partNumber"))
      res.setPartNumberElement(parseString(json.get("partNumber").getAsString()));
    if (json.has("_partNumber"))
      parseElementProperties(getJObject(json, "_partNumber"), res.getPartNumberElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(getJObject(json, "manufacturer")));
    if (json.has("deviceName")) {
      JsonArray array = getJArray(json, "deviceName");
      for (int i = 0; i < array.size(); i++) {
        res.getDeviceName().add(parseDeviceDefinitionDeviceNameComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("modelNumber"))
      res.setModelNumberElement(parseString(json.get("modelNumber").getAsString()));
    if (json.has("_modelNumber"))
      parseElementProperties(getJObject(json, "_modelNumber"), res.getModelNumberElement());
    if (json.has("classification")) {
      JsonArray array = getJArray(json, "classification");
      for (int i = 0; i < array.size(); i++) {
        res.getClassification().add(parseDeviceDefinitionClassificationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("conformsTo")) {
      JsonArray array = getJArray(json, "conformsTo");
      for (int i = 0; i < array.size(); i++) {
        res.getConformsTo().add(parseDeviceDefinitionConformsToComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("hasPart")) {
      JsonArray array = getJArray(json, "hasPart");
      for (int i = 0; i < array.size(); i++) {
        res.getHasPart().add(parseDeviceDefinitionHasPartComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("packaging")) {
      JsonArray array = getJArray(json, "packaging");
      for (int i = 0; i < array.size(); i++) {
        res.getPackaging().add(parseDeviceDefinitionPackagingComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version")) {
      JsonArray array = getJArray(json, "version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseDeviceDefinitionVersionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("safety")) {
      JsonArray array = getJArray(json, "safety");
      for (int i = 0; i < array.size(); i++) {
        res.getSafety().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("shelfLifeStorage")) {
      JsonArray array = getJArray(json, "shelfLifeStorage");
      for (int i = 0; i < array.size(); i++) {
        res.getShelfLifeStorage().add(parseProductShelfLife(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("languageCode")) {
      JsonArray array = getJArray(json, "languageCode");
      for (int i = 0; i < array.size(); i++) {
        res.getLanguageCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("property")) {
      JsonArray array = getJArray(json, "property");
      for (int i = 0; i < array.size(); i++) {
        res.getProperty().add(parseDeviceDefinitionPropertyComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("owner"))
      res.setOwner(parseReference(getJObject(json, "owner")));
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("link")) {
      JsonArray array = getJArray(json, "link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseDeviceDefinitionLinkComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("material")) {
      JsonArray array = getJArray(json, "material");
      for (int i = 0; i < array.size(); i++) {
        res.getMaterial().add(parseDeviceDefinitionMaterialComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("productionIdentifierInUDI")) {
      JsonArray array = getJArray(json, "productionIdentifierInUDI");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProductionIdentifierInUDI().add(new Enumeration<DeviceDefinition.DeviceProductionIdentifierInUDI>(new DeviceDefinition.DeviceProductionIdentifierInUDIEnumFactory(), DeviceDefinition.DeviceProductionIdentifierInUDI.NULL));
        } else {;
          res.getProductionIdentifierInUDI().add(parseEnumeration(array.get(i).getAsString(), DeviceDefinition.DeviceProductionIdentifierInUDI.NULL, new DeviceDefinition.DeviceProductionIdentifierInUDIEnumFactory()));
        }
      }
    };
    if (json.has("_productionIdentifierInUDI")) {
      JsonArray array = getJArray(json, "_productionIdentifierInUDI");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProductionIdentifierInUDI().size())
          res.getProductionIdentifierInUDI().add(parseEnumeration(null, DeviceDefinition.DeviceProductionIdentifierInUDI.NULL, new DeviceDefinition.DeviceProductionIdentifierInUDIEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProductionIdentifierInUDI().get(i));
      }
    };
    if (json.has("guideline"))
      res.setGuideline(parseDeviceDefinitionGuidelineComponent(getJObject(json, "guideline")));
    if (json.has("correctiveAction"))
      res.setCorrectiveAction(parseDeviceDefinitionCorrectiveActionComponent(getJObject(json, "correctiveAction")));
    if (json.has("chargeItem")) {
      JsonArray array = getJArray(json, "chargeItem");
      for (int i = 0; i < array.size(); i++) {
        res.getChargeItem().add(parseDeviceDefinitionChargeItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionUdiDeviceIdentifierComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
    parseDeviceDefinitionUdiDeviceIdentifierComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionUdiDeviceIdentifierComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(getJObject(json, "_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
    if (json.has("marketDistribution")) {
      JsonArray array = getJArray(json, "marketDistribution");
      for (int i = 0; i < array.size(); i++) {
        res.getMarketDistribution().add(parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent res = new DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent();
    parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponentProperties(JsonObject json, DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("marketPeriod"))
      res.setMarketPeriod(parsePeriod(getJObject(json, "marketPeriod")));
    if (json.has("subJurisdiction"))
      res.setSubJurisdictionElement(parseUri(json.get("subJurisdiction").getAsString()));
    if (json.has("_subJurisdiction"))
      parseElementProperties(getJObject(json, "_subJurisdiction"), res.getSubJurisdictionElement());
  }

  protected DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent parseDeviceDefinitionRegulatoryIdentifierComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent res = new DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent();
    parseDeviceDefinitionRegulatoryIdentifierComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionRegulatoryIdentifierComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceDefinition.DeviceDefinitionRegulatoryIdentifierType.NULL, new DeviceDefinition.DeviceDefinitionRegulatoryIdentifierTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("deviceIdentifier"))
      res.setDeviceIdentifierElement(parseString(json.get("deviceIdentifier").getAsString()));
    if (json.has("_deviceIdentifier"))
      parseElementProperties(getJObject(json, "_deviceIdentifier"), res.getDeviceIdentifierElement());
    if (json.has("issuer"))
      res.setIssuerElement(parseUri(json.get("issuer").getAsString()));
    if (json.has("_issuer"))
      parseElementProperties(getJObject(json, "_issuer"), res.getIssuerElement());
    if (json.has("jurisdiction"))
      res.setJurisdictionElement(parseUri(json.get("jurisdiction").getAsString()));
    if (json.has("_jurisdiction"))
      parseElementProperties(getJObject(json, "_jurisdiction"), res.getJurisdictionElement());
  }

  protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceNameComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
    parseDeviceDefinitionDeviceNameComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionDeviceNameComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
  }

  protected DeviceDefinition.DeviceDefinitionClassificationComponent parseDeviceDefinitionClassificationComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionClassificationComponent res = new DeviceDefinition.DeviceDefinitionClassificationComponent();
    parseDeviceDefinitionClassificationComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionClassificationComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionClassificationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("justification")) {
      JsonArray array = getJArray(json, "justification");
      for (int i = 0; i < array.size(); i++) {
        res.getJustification().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionConformsToComponent parseDeviceDefinitionConformsToComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionConformsToComponent res = new DeviceDefinition.DeviceDefinitionConformsToComponent();
    parseDeviceDefinitionConformsToComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionConformsToComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionConformsToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("specification"))
      res.setSpecification(parseCodeableConcept(getJObject(json, "specification")));
    if (json.has("version")) {
      JsonArray array = getJArray(json, "version");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getVersion().add(new StringType());
        } else {;
          res.getVersion().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_version")) {
      JsonArray array = getJArray(json, "_version");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getVersion().size())
          res.getVersion().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getVersion().get(i));
      }
    };
    if (json.has("source")) {
      JsonArray array = getJArray(json, "source");
      for (int i = 0; i < array.size(); i++) {
        res.getSource().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionHasPartComponent parseDeviceDefinitionHasPartComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionHasPartComponent res = new DeviceDefinition.DeviceDefinitionHasPartComponent();
    parseDeviceDefinitionHasPartComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionHasPartComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionHasPartComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(getJObject(json, "_count"), res.getCountElement());
  }

  protected DeviceDefinition.DeviceDefinitionPackagingComponent parseDeviceDefinitionPackagingComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionPackagingComponent res = new DeviceDefinition.DeviceDefinitionPackagingComponent();
    parseDeviceDefinitionPackagingComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionPackagingComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionPackagingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("count"))
      res.setCountElement(parseInteger(json.get("count").getAsLong()));
    if (json.has("_count"))
      parseElementProperties(getJObject(json, "_count"), res.getCountElement());
    if (json.has("distributor")) {
      JsonArray array = getJArray(json, "distributor");
      for (int i = 0; i < array.size(); i++) {
        res.getDistributor().add(parseDeviceDefinitionPackagingDistributorComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("udiDeviceIdentifier")) {
      JsonArray array = getJArray(json, "udiDeviceIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getUdiDeviceIdentifier().add(parseDeviceDefinitionUdiDeviceIdentifierComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("packaging")) {
      JsonArray array = getJArray(json, "packaging");
      for (int i = 0; i < array.size(); i++) {
        res.getPackaging().add(parseDeviceDefinitionPackagingComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceDefinition.PackagingDistributorComponent parseDeviceDefinitionPackagingDistributorComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.PackagingDistributorComponent res = new DeviceDefinition.PackagingDistributorComponent();
    parseDeviceDefinitionPackagingDistributorComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionPackagingDistributorComponentProperties(JsonObject json, DeviceDefinition.PackagingDistributorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("organizationReference")) {
      JsonArray array = getJArray(json, "organizationReference");
      for (int i = 0; i < array.size(); i++) {
        res.getOrganizationReference().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceDefinition.DeviceDefinitionVersionComponent parseDeviceDefinitionVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionVersionComponent res = new DeviceDefinition.DeviceDefinitionVersionComponent();
    parseDeviceDefinitionVersionComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionVersionComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("component"))
      res.setComponent(parseIdentifier(getJObject(json, "component")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionPropertyComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
    parseDeviceDefinitionPropertyComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionPropertyComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DeviceDefinition.DeviceDefinitionLinkComponent parseDeviceDefinitionLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionLinkComponent res = new DeviceDefinition.DeviceDefinitionLinkComponent();
    parseDeviceDefinitionLinkComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionLinkComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("relation"))
      res.setRelation(parseCoding(getJObject(json, "relation")));
    if (json.has("relatedDevice"))
      res.setRelatedDevice(parseCodeableReference(getJObject(json, "relatedDevice")));
  }

  protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionMaterialComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
    parseDeviceDefinitionMaterialComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionMaterialComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableConcept(getJObject(json, "substance")));
    if (json.has("alternate"))
      res.setAlternateElement(parseBoolean(json.get("alternate").getAsBoolean()));
    if (json.has("_alternate"))
      parseElementProperties(getJObject(json, "_alternate"), res.getAlternateElement());
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(getJObject(json, "_allergenicIndicator"), res.getAllergenicIndicatorElement());
  }

  protected DeviceDefinition.DeviceDefinitionGuidelineComponent parseDeviceDefinitionGuidelineComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionGuidelineComponent res = new DeviceDefinition.DeviceDefinitionGuidelineComponent();
    parseDeviceDefinitionGuidelineComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionGuidelineComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionGuidelineComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("usageInstruction"))
      res.setUsageInstructionElement(parseMarkdown(json.get("usageInstruction").getAsString()));
    if (json.has("_usageInstruction"))
      parseElementProperties(getJObject(json, "_usageInstruction"), res.getUsageInstructionElement());
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("indication")) {
      JsonArray array = getJArray(json, "indication");
      for (int i = 0; i < array.size(); i++) {
        res.getIndication().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("contraindication")) {
      JsonArray array = getJArray(json, "contraindication");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindication().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("warning")) {
      JsonArray array = getJArray(json, "warning");
      for (int i = 0; i < array.size(); i++) {
        res.getWarning().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("intendedUse"))
      res.setIntendedUseElement(parseString(json.get("intendedUse").getAsString()));
    if (json.has("_intendedUse"))
      parseElementProperties(getJObject(json, "_intendedUse"), res.getIntendedUseElement());
  }

  protected DeviceDefinition.DeviceDefinitionCorrectiveActionComponent parseDeviceDefinitionCorrectiveActionComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionCorrectiveActionComponent res = new DeviceDefinition.DeviceDefinitionCorrectiveActionComponent();
    parseDeviceDefinitionCorrectiveActionComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionCorrectiveActionComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionCorrectiveActionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("recall"))
      res.setRecallElement(parseBoolean(json.get("recall").getAsBoolean()));
    if (json.has("_recall"))
      parseElementProperties(getJObject(json, "_recall"), res.getRecallElement());
    if (json.has("scope"))
      res.setScopeElement(parseEnumeration(json.get("scope").getAsString(), DeviceDefinition.DeviceCorrectiveActionScope.NULL, new DeviceDefinition.DeviceCorrectiveActionScopeEnumFactory()));
    if (json.has("_scope"))
      parseElementProperties(getJObject(json, "_scope"), res.getScopeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected DeviceDefinition.DeviceDefinitionChargeItemComponent parseDeviceDefinitionChargeItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDefinition.DeviceDefinitionChargeItemComponent res = new DeviceDefinition.DeviceDefinitionChargeItemComponent();
    parseDeviceDefinitionChargeItemComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDefinitionChargeItemComponentProperties(JsonObject json, DeviceDefinition.DeviceDefinitionChargeItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("chargeItemCode"))
      res.setChargeItemCode(parseCodeableReference(getJObject(json, "chargeItemCode")));
    if (json.has("count"))
      res.setCount(parseQuantity(getJObject(json, "count")));
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceDispense parseDeviceDispense(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDispense res = new DeviceDispense();
    parseDeviceDispenseProperties(json, res);
    return res;
  }

  protected void parseDeviceDispenseProperties(JsonObject json, DeviceDispense res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = getJArray(json, "partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceDispense.DeviceDispenseStatusCodes.NULL, new DeviceDispense.DeviceDispenseStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableReference(getJObject(json, "statusReason")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("device"))
      res.setDevice(parseCodeableReference(getJObject(json, "device")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("receiver"))
      res.setReceiver(parseReference(getJObject(json, "receiver")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("supportingInformation")) {
      JsonArray array = getJArray(json, "supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("performer")) {
      JsonArray array = getJArray(json, "performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseDeviceDispensePerformerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("preparedDate"))
      res.setPreparedDateElement(parseDateTime(json.get("preparedDate").getAsString()));
    if (json.has("_preparedDate"))
      parseElementProperties(getJObject(json, "_preparedDate"), res.getPreparedDateElement());
    if (json.has("whenHandedOver"))
      res.setWhenHandedOverElement(parseDateTime(json.get("whenHandedOver").getAsString()));
    if (json.has("_whenHandedOver"))
      parseElementProperties(getJObject(json, "_whenHandedOver"), res.getWhenHandedOverElement());
    if (json.has("destination"))
      res.setDestination(parseReference(getJObject(json, "destination")));
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("usageInstruction"))
      res.setUsageInstructionElement(parseMarkdown(json.get("usageInstruction").getAsString()));
    if (json.has("_usageInstruction"))
      parseElementProperties(getJObject(json, "_usageInstruction"), res.getUsageInstructionElement());
    if (json.has("eventHistory")) {
      JsonArray array = getJArray(json, "eventHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getEventHistory().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceDispense.DeviceDispensePerformerComponent parseDeviceDispensePerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceDispense.DeviceDispensePerformerComponent res = new DeviceDispense.DeviceDispensePerformerComponent();
    parseDeviceDispensePerformerComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceDispensePerformerComponentProperties(JsonObject json, DeviceDispense.DeviceDispensePerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected DeviceMetric parseDeviceMetric(JsonObject json) throws IOException, FHIRFormatError {
    DeviceMetric res = new DeviceMetric();
    parseDeviceMetricProperties(json, res);
    return res;
  }

  protected void parseDeviceMetricProperties(JsonObject json, DeviceMetric res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(getJObject(json, "unit")));
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    if (json.has("operationalStatus"))
      res.setOperationalStatusElement(parseEnumeration(json.get("operationalStatus").getAsString(), DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
    if (json.has("_operationalStatus"))
      parseElementProperties(getJObject(json, "_operationalStatus"), res.getOperationalStatusElement());
    if (json.has("color"))
      res.setColorElement(parseCode(json.get("color").getAsString()));
    if (json.has("_color"))
      parseElementProperties(getJObject(json, "_color"), res.getColorElement());
    if (json.has("category"))
      res.setCategoryElement(parseEnumeration(json.get("category").getAsString(), DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
    if (json.has("_category"))
      parseElementProperties(getJObject(json, "_category"), res.getCategoryElement());
    if (json.has("measurementFrequency"))
      res.setMeasurementFrequency(parseQuantity(getJObject(json, "measurementFrequency")));
    if (json.has("calibration")) {
      JsonArray array = getJArray(json, "calibration");
      for (int i = 0; i < array.size(); i++) {
        res.getCalibration().add(parseDeviceMetricCalibrationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricCalibrationComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
    parseDeviceMetricCalibrationComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceMetricCalibrationComponentProperties(JsonObject json, DeviceMetric.DeviceMetricCalibrationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("state"))
      res.setStateElement(parseEnumeration(json.get("state").getAsString(), DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
    if (json.has("_state"))
      parseElementProperties(getJObject(json, "_state"), res.getStateElement());
    if (json.has("time"))
      res.setTimeElement(parseInstant(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(getJObject(json, "_time"), res.getTimeElement());
  }

  protected DeviceRequest parseDeviceRequest(JsonObject json) throws IOException, FHIRFormatError {
    DeviceRequest res = new DeviceRequest();
    parseDeviceRequestProperties(json, res);
    return res;
  }

  protected void parseDeviceRequestProperties(JsonObject json, DeviceRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = getJArray(json, "instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = getJArray(json, "_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = getJArray(json, "instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = getJArray(json, "_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("replaces")) {
      JsonArray array = getJArray(json, "replaces");
      for (int i = 0; i < array.size(); i++) {
        res.getReplaces().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("groupIdentifier"))
      res.setGroupIdentifier(parseIdentifier(getJObject(json, "groupIdentifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("intent"))
      res.setIntentElement(parseEnumeration(json.get("intent").getAsString(), Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
    if (json.has("_intent"))
      parseElementProperties(getJObject(json, "_intent"), res.getIntentElement());
    if (json.has("priority"))
      res.setPriorityElement(parseEnumeration(json.get("priority").getAsString(), Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
    if (json.has("_priority"))
      parseElementProperties(getJObject(json, "_priority"), res.getPriorityElement());
    if (json.has("doNotPerform"))
      res.setDoNotPerformElement(parseBoolean(json.get("doNotPerform").getAsBoolean()));
    if (json.has("_doNotPerform"))
      parseElementProperties(getJObject(json, "_doNotPerform"), res.getDoNotPerformElement());
    if (json.has("code"))
      res.setCode(parseCodeableReference(getJObject(json, "code")));
    if (json.has("quantity"))
      res.setQuantityElement(parseInteger(json.get("quantity").getAsLong()));
    if (json.has("_quantity"))
      parseElementProperties(getJObject(json, "_quantity"), res.getQuantityElement());
    if (json.has("parameter")) {
      JsonArray array = getJArray(json, "parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseDeviceRequestParameterComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("authoredOn"))
      res.setAuthoredOnElement(parseDateTime(json.get("authoredOn").getAsString()));
    if (json.has("_authoredOn"))
      parseElementProperties(getJObject(json, "_authoredOn"), res.getAuthoredOnElement());
    if (json.has("requester"))
      res.setRequester(parseReference(getJObject(json, "requester")));
    if (json.has("performer"))
      res.setPerformer(parseCodeableReference(getJObject(json, "performer")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("asNeeded"))
      res.setAsNeededElement(parseBoolean(json.get("asNeeded").getAsBoolean()));
    if (json.has("_asNeeded"))
      parseElementProperties(getJObject(json, "_asNeeded"), res.getAsNeededElement());
    if (json.has("asNeededFor"))
      res.setAsNeededFor(parseCodeableConcept(getJObject(json, "asNeededFor")));
    if (json.has("insurance")) {
      JsonArray array = getJArray(json, "insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relevantHistory")) {
      JsonArray array = getJArray(json, "relevantHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getRelevantHistory().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestParameterComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
    parseDeviceRequestParameterComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceRequestParameterComponentProperties(JsonObject json, DeviceRequest.DeviceRequestParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected DeviceUsage parseDeviceUsage(JsonObject json) throws IOException, FHIRFormatError {
    DeviceUsage res = new DeviceUsage();
    parseDeviceUsageProperties(json, res);
    return res;
  }

  protected void parseDeviceUsageProperties(JsonObject json, DeviceUsage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DeviceUsage.DeviceUsageStatus.NULL, new DeviceUsage.DeviceUsageStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("derivedFrom")) {
      JsonArray array = getJArray(json, "derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("context"))
      res.setContext(parseReference(getJObject(json, "context")));
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    if (json.has("dateAsserted"))
      res.setDateAssertedElement(parseDateTime(json.get("dateAsserted").getAsString()));
    if (json.has("_dateAsserted"))
      parseElementProperties(getJObject(json, "_dateAsserted"), res.getDateAssertedElement());
    if (json.has("usageStatus"))
      res.setUsageStatus(parseCodeableConcept(getJObject(json, "usageStatus")));
    if (json.has("usageReason")) {
      JsonArray array = getJArray(json, "usageReason");
      for (int i = 0; i < array.size(); i++) {
        res.getUsageReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("adherence"))
      res.setAdherence(parseDeviceUsageAdherenceComponent(getJObject(json, "adherence")));
    if (json.has("informationSource"))
      res.setInformationSource(parseReference(getJObject(json, "informationSource")));
    if (json.has("device"))
      res.setDevice(parseCodeableReference(getJObject(json, "device")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableReference(getJObject(json, "bodySite")));
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DeviceUsage.DeviceUsageAdherenceComponent parseDeviceUsageAdherenceComponent(JsonObject json) throws IOException, FHIRFormatError {
    DeviceUsage.DeviceUsageAdherenceComponent res = new DeviceUsage.DeviceUsageAdherenceComponent();
    parseDeviceUsageAdherenceComponentProperties(json, res);
    return res;
  }

  protected void parseDeviceUsageAdherenceComponentProperties(JsonObject json, DeviceUsage.DeviceUsageAdherenceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DiagnosticReport parseDiagnosticReport(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport res = new DiagnosticReport();
    parseDiagnosticReportProperties(json, res);
    return res;
  }

  protected void parseDiagnosticReportProperties(JsonObject json, DiagnosticReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    DataType effective = parseType("effective", json);
    if (effective != null)
      res.setEffective(effective);
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = getJArray(json, "performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("resultsInterpreter")) {
      JsonArray array = getJArray(json, "resultsInterpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getResultsInterpreter().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("specimen")) {
      JsonArray array = getJArray(json, "specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("result")) {
      JsonArray array = getJArray(json, "result");
      for (int i = 0; i < array.size(); i++) {
        res.getResult().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("study")) {
      JsonArray array = getJArray(json, "study");
      for (int i = 0; i < array.size(); i++) {
        res.getStudy().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseDiagnosticReportSupportingInfoComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("media")) {
      JsonArray array = getJArray(json, "media");
      for (int i = 0; i < array.size(); i++) {
        res.getMedia().add(parseDiagnosticReportMediaComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("composition"))
      res.setComposition(parseReference(getJObject(json, "composition")));
    if (json.has("conclusion"))
      res.setConclusionElement(parseMarkdown(json.get("conclusion").getAsString()));
    if (json.has("_conclusion"))
      parseElementProperties(getJObject(json, "_conclusion"), res.getConclusionElement());
    if (json.has("conclusionCode")) {
      JsonArray array = getJArray(json, "conclusionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getConclusionCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("presentedForm")) {
      JsonArray array = getJArray(json, "presentedForm");
      for (int i = 0; i < array.size(); i++) {
        res.getPresentedForm().add(parseAttachment(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DiagnosticReport.DiagnosticReportSupportingInfoComponent parseDiagnosticReportSupportingInfoComponent(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportSupportingInfoComponent res = new DiagnosticReport.DiagnosticReportSupportingInfoComponent();
    parseDiagnosticReportSupportingInfoComponentProperties(json, res);
    return res;
  }

  protected void parseDiagnosticReportSupportingInfoComponentProperties(JsonObject json, DiagnosticReport.DiagnosticReportSupportingInfoComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
  }

  protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportMediaComponent(JsonObject json) throws IOException, FHIRFormatError {
    DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
    parseDiagnosticReportMediaComponentProperties(json, res);
    return res;
  }

  protected void parseDiagnosticReportMediaComponentProperties(JsonObject json, DiagnosticReport.DiagnosticReportMediaComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("link"))
      res.setLink(parseReference(getJObject(json, "link")));
  }

  protected DocumentReference parseDocumentReference(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference res = new DocumentReference();
    parseDocumentReferenceProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceProperties(JsonObject json, DocumentReference res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), DocumentReference.DocumentReferenceStatus.NULL, new DocumentReference.DocumentReferenceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("docStatus"))
      res.setDocStatusElement(parseEnumeration(json.get("docStatus").getAsString(), Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
    if (json.has("_docStatus"))
      parseElementProperties(getJObject(json, "_docStatus"), res.getDocStatusElement());
    if (json.has("modality")) {
      JsonArray array = getJArray(json, "modality");
      for (int i = 0; i < array.size(); i++) {
        res.getModality().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("context")) {
      JsonArray array = getJArray(json, "context");
      for (int i = 0; i < array.size(); i++) {
        res.getContext().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("event")) {
      JsonArray array = getJArray(json, "event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = getJArray(json, "bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("facilityType"))
      res.setFacilityType(parseCodeableConcept(getJObject(json, "facilityType")));
    if (json.has("practiceSetting"))
      res.setPracticeSetting(parseCodeableConcept(getJObject(json, "practiceSetting")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("date"))
      res.setDateElement(parseInstant(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("attester")) {
      JsonArray array = getJArray(json, "attester");
      for (int i = 0; i < array.size(); i++) {
        res.getAttester().add(parseDocumentReferenceAttesterComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("custodian"))
      res.setCustodian(parseReference(getJObject(json, "custodian")));
    if (json.has("relatesTo")) {
      JsonArray array = getJArray(json, "relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseDocumentReferenceRelatesToComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("securityLabel")) {
      JsonArray array = getJArray(json, "securityLabel");
      for (int i = 0; i < array.size(); i++) {
        res.getSecurityLabel().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("content")) {
      JsonArray array = getJArray(json, "content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseDocumentReferenceContentComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DocumentReference.DocumentReferenceAttesterComponent parseDocumentReferenceAttesterComponent(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceAttesterComponent res = new DocumentReference.DocumentReferenceAttesterComponent();
    parseDocumentReferenceAttesterComponentProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceAttesterComponentProperties(JsonObject json, DocumentReference.DocumentReferenceAttesterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("mode"))
      res.setMode(parseCodeableConcept(getJObject(json, "mode")));
    if (json.has("time"))
      res.setTimeElement(parseDateTime(json.get("time").getAsString()));
    if (json.has("_time"))
      parseElementProperties(getJObject(json, "_time"), res.getTimeElement());
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
  }

  protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
    parseDocumentReferenceRelatesToComponentProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceRelatesToComponentProperties(JsonObject json, DocumentReference.DocumentReferenceRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("target"))
      res.setTarget(parseReference(getJObject(json, "target")));
  }

  protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceContentComponent(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
    parseDocumentReferenceContentComponentProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceContentComponentProperties(JsonObject json, DocumentReference.DocumentReferenceContentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("attachment"))
      res.setAttachment(parseAttachment(getJObject(json, "attachment")));
    if (json.has("profile")) {
      JsonArray array = getJArray(json, "profile");
      for (int i = 0; i < array.size(); i++) {
        res.getProfile().add(parseDocumentReferenceContentProfileComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected DocumentReference.DocumentReferenceContentProfileComponent parseDocumentReferenceContentProfileComponent(JsonObject json) throws IOException, FHIRFormatError {
    DocumentReference.DocumentReferenceContentProfileComponent res = new DocumentReference.DocumentReferenceContentProfileComponent();
    parseDocumentReferenceContentProfileComponentProperties(json, res);
    return res;
  }

  protected void parseDocumentReferenceContentProfileComponentProperties(JsonObject json, DocumentReference.DocumentReferenceContentProfileComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected Encounter parseEncounter(JsonObject json) throws IOException, FHIRFormatError {
    Encounter res = new Encounter();
    parseEncounterProperties(json, res);
    return res;
  }

  protected void parseEncounterProperties(JsonObject json, Encounter res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.EncounterStatus.NULL, new Enumerations.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("class")) {
      JsonArray array = getJArray(json, "class");
      for (int i = 0; i < array.size(); i++) {
        res.getClass_().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("serviceType")) {
      JsonArray array = getJArray(json, "serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("subjectStatus"))
      res.setSubjectStatus(parseCodeableConcept(getJObject(json, "subjectStatus")));
    if (json.has("episodeOfCare")) {
      JsonArray array = getJArray(json, "episodeOfCare");
      for (int i = 0; i < array.size(); i++) {
        res.getEpisodeOfCare().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("careTeam")) {
      JsonArray array = getJArray(json, "careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("partOf"))
      res.setPartOf(parseReference(getJObject(json, "partOf")));
    if (json.has("serviceProvider"))
      res.setServiceProvider(parseReference(getJObject(json, "serviceProvider")));
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseEncounterParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("appointment")) {
      JsonArray array = getJArray(json, "appointment");
      for (int i = 0; i < array.size(); i++) {
        res.getAppointment().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("virtualService")) {
      JsonArray array = getJArray(json, "virtualService");
      for (int i = 0; i < array.size(); i++) {
        res.getVirtualService().add(parseVirtualServiceDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("actualPeriod"))
      res.setActualPeriod(parsePeriod(getJObject(json, "actualPeriod")));
    if (json.has("plannedStartDate"))
      res.setPlannedStartDateElement(parseDateTime(json.get("plannedStartDate").getAsString()));
    if (json.has("_plannedStartDate"))
      parseElementProperties(getJObject(json, "_plannedStartDate"), res.getPlannedStartDateElement());
    if (json.has("plannedEndDate"))
      res.setPlannedEndDateElement(parseDateTime(json.get("plannedEndDate").getAsString()));
    if (json.has("_plannedEndDate"))
      parseElementProperties(getJObject(json, "_plannedEndDate"), res.getPlannedEndDateElement());
    if (json.has("length"))
      res.setLength(parseDuration(getJObject(json, "length")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseEncounterReasonComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = getJArray(json, "diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEncounterDiagnosisComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("account")) {
      JsonArray array = getJArray(json, "account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("dietPreference")) {
      JsonArray array = getJArray(json, "dietPreference");
      for (int i = 0; i < array.size(); i++) {
        res.getDietPreference().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("specialArrangement")) {
      JsonArray array = getJArray(json, "specialArrangement");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialArrangement().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("specialCourtesy")) {
      JsonArray array = getJArray(json, "specialCourtesy");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialCourtesy().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("admission"))
      res.setAdmission(parseEncounterAdmissionComponent(getJObject(json, "admission")));
    if (json.has("location")) {
      JsonArray array = getJArray(json, "location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseEncounterLocationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Encounter.EncounterParticipantComponent parseEncounterParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
    parseEncounterParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterParticipantComponentProperties(JsonObject json, Encounter.EncounterParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected Encounter.ReasonComponent parseEncounterReasonComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.ReasonComponent res = new Encounter.ReasonComponent();
    parseEncounterReasonComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterReasonComponentProperties(JsonObject json, Encounter.ReasonComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("use")) {
      JsonArray array = getJArray(json, "use");
      for (int i = 0; i < array.size(); i++) {
        res.getUse().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("value")) {
      JsonArray array = getJArray(json, "value");
      for (int i = 0; i < array.size(); i++) {
        res.getValue().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
    parseEncounterDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterDiagnosisComponentProperties(JsonObject json, Encounter.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition")) {
      JsonArray array = getJArray(json, "condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("use")) {
      JsonArray array = getJArray(json, "use");
      for (int i = 0; i < array.size(); i++) {
        res.getUse().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Encounter.EncounterAdmissionComponent parseEncounterAdmissionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.EncounterAdmissionComponent res = new Encounter.EncounterAdmissionComponent();
    parseEncounterAdmissionComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterAdmissionComponentProperties(JsonObject json, Encounter.EncounterAdmissionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("preAdmissionIdentifier"))
      res.setPreAdmissionIdentifier(parseIdentifier(getJObject(json, "preAdmissionIdentifier")));
    if (json.has("origin"))
      res.setOrigin(parseReference(getJObject(json, "origin")));
    if (json.has("admitSource"))
      res.setAdmitSource(parseCodeableConcept(getJObject(json, "admitSource")));
    if (json.has("reAdmission"))
      res.setReAdmission(parseCodeableConcept(getJObject(json, "reAdmission")));
    if (json.has("destination"))
      res.setDestination(parseReference(getJObject(json, "destination")));
    if (json.has("dischargeDisposition"))
      res.setDischargeDisposition(parseCodeableConcept(getJObject(json, "dischargeDisposition")));
  }

  protected Encounter.EncounterLocationComponent parseEncounterLocationComponent(JsonObject json) throws IOException, FHIRFormatError {
    Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
    parseEncounterLocationComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterLocationComponentProperties(JsonObject json, Encounter.EncounterLocationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("form"))
      res.setForm(parseCodeableConcept(getJObject(json, "form")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected EncounterHistory parseEncounterHistory(JsonObject json) throws IOException, FHIRFormatError {
    EncounterHistory res = new EncounterHistory();
    parseEncounterHistoryProperties(json, res);
    return res;
  }

  protected void parseEncounterHistoryProperties(JsonObject json, EncounterHistory res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.EncounterStatus.NULL, new Enumerations.EncounterStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("class"))
      res.setClass_(parseCodeableConcept(getJObject(json, "class")));
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("serviceType")) {
      JsonArray array = getJArray(json, "serviceType");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceType().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("subjectStatus"))
      res.setSubjectStatus(parseCodeableConcept(getJObject(json, "subjectStatus")));
    if (json.has("actualPeriod"))
      res.setActualPeriod(parsePeriod(getJObject(json, "actualPeriod")));
    if (json.has("plannedStartDate"))
      res.setPlannedStartDateElement(parseDateTime(json.get("plannedStartDate").getAsString()));
    if (json.has("_plannedStartDate"))
      parseElementProperties(getJObject(json, "_plannedStartDate"), res.getPlannedStartDateElement());
    if (json.has("plannedEndDate"))
      res.setPlannedEndDateElement(parseDateTime(json.get("plannedEndDate").getAsString()));
    if (json.has("_plannedEndDate"))
      parseElementProperties(getJObject(json, "_plannedEndDate"), res.getPlannedEndDateElement());
    if (json.has("length"))
      res.setLength(parseDuration(getJObject(json, "length")));
    if (json.has("location")) {
      JsonArray array = getJArray(json, "location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseEncounterHistoryLocationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EncounterHistory.EncounterHistoryLocationComponent parseEncounterHistoryLocationComponent(JsonObject json) throws IOException, FHIRFormatError {
    EncounterHistory.EncounterHistoryLocationComponent res = new EncounterHistory.EncounterHistoryLocationComponent();
    parseEncounterHistoryLocationComponentProperties(json, res);
    return res;
  }

  protected void parseEncounterHistoryLocationComponentProperties(JsonObject json, EncounterHistory.EncounterHistoryLocationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("form"))
      res.setForm(parseCodeableConcept(getJObject(json, "form")));
  }

  protected Endpoint parseEndpoint(JsonObject json) throws IOException, FHIRFormatError {
    Endpoint res = new Endpoint();
    parseEndpointProperties(json, res);
    return res;
  }

  protected void parseEndpointProperties(JsonObject json, Endpoint res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("connectionType")) {
      JsonArray array = getJArray(json, "connectionType");
      for (int i = 0; i < array.size(); i++) {
        res.getConnectionType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("environmentType")) {
      JsonArray array = getJArray(json, "environmentType");
      for (int i = 0; i < array.size(); i++) {
        res.getEnvironmentType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(getJObject(json, "managingOrganization")));
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactPoint(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("payload")) {
      JsonArray array = getJArray(json, "payload");
      for (int i = 0; i < array.size(); i++) {
        res.getPayload().add(parseEndpointPayloadComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("address"))
      res.setAddressElement(parseUrl(json.get("address").getAsString()));
    if (json.has("_address"))
      parseElementProperties(getJObject(json, "_address"), res.getAddressElement());
    if (json.has("header")) {
      JsonArray array = getJArray(json, "header");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getHeader().add(new StringType());
        } else {;
          res.getHeader().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_header")) {
      JsonArray array = getJArray(json, "_header");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getHeader().size())
          res.getHeader().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getHeader().get(i));
      }
    };
  }

  protected Endpoint.EndpointPayloadComponent parseEndpointPayloadComponent(JsonObject json) throws IOException, FHIRFormatError {
    Endpoint.EndpointPayloadComponent res = new Endpoint.EndpointPayloadComponent();
    parseEndpointPayloadComponentProperties(json, res);
    return res;
  }

  protected void parseEndpointPayloadComponentProperties(JsonObject json, Endpoint.EndpointPayloadComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("mimeType")) {
      JsonArray array = getJArray(json, "mimeType");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getMimeType().add(new CodeType());
        } else {;
          res.getMimeType().add(parseCode(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_mimeType")) {
      JsonArray array = getJArray(json, "_mimeType");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getMimeType().size())
          res.getMimeType().add(parseCode(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getMimeType().get(i));
      }
    };
  }

  protected EnrollmentRequest parseEnrollmentRequest(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentRequest res = new EnrollmentRequest();
    parseEnrollmentRequestProperties(json, res);
    return res;
  }

  protected void parseEnrollmentRequestProperties(JsonObject json, EnrollmentRequest res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("candidate"))
      res.setCandidate(parseReference(getJObject(json, "candidate")));
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
  }

  protected EnrollmentResponse parseEnrollmentResponse(JsonObject json) throws IOException, FHIRFormatError {
    EnrollmentResponse res = new EnrollmentResponse();
    parseEnrollmentResponseProperties(json, res);
    return res;
  }

  protected void parseEnrollmentResponseProperties(JsonObject json, EnrollmentResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("request"))
      res.setRequest(parseReference(getJObject(json, "request")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), EnrollmentResponse.EnrollmentOutcome.NULL, new EnrollmentResponse.EnrollmentOutcomeEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("organization"))
      res.setOrganization(parseReference(getJObject(json, "organization")));
    if (json.has("requestProvider"))
      res.setRequestProvider(parseReference(getJObject(json, "requestProvider")));
  }

  protected EpisodeOfCare parseEpisodeOfCare(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare res = new EpisodeOfCare();
    parseEpisodeOfCareProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareProperties(JsonObject json, EpisodeOfCare res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusHistory")) {
      JsonArray array = getJArray(json, "statusHistory");
      for (int i = 0; i < array.size(); i++) {
        res.getStatusHistory().add(parseEpisodeOfCareStatusHistoryComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseEpisodeOfCareReasonComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = getJArray(json, "diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseEpisodeOfCareDiagnosisComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("managingOrganization"))
      res.setManagingOrganization(parseReference(getJObject(json, "managingOrganization")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("referralRequest")) {
      JsonArray array = getJArray(json, "referralRequest");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralRequest().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("careManager"))
      res.setCareManager(parseReference(getJObject(json, "careManager")));
    if (json.has("careTeam")) {
      JsonArray array = getJArray(json, "careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("account")) {
      JsonArray array = getJArray(json, "account");
      for (int i = 0; i < array.size(); i++) {
        res.getAccount().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareStatusHistoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
    parseEpisodeOfCareStatusHistoryComponentProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareStatusHistoryComponentProperties(JsonObject json, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected EpisodeOfCare.ReasonComponent parseEpisodeOfCareReasonComponent(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare.ReasonComponent res = new EpisodeOfCare.ReasonComponent();
    parseEpisodeOfCareReasonComponentProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareReasonComponentProperties(JsonObject json, EpisodeOfCare.ReasonComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("use"))
      res.setUse(parseCodeableConcept(getJObject(json, "use")));
    if (json.has("value")) {
      JsonArray array = getJArray(json, "value");
      for (int i = 0; i < array.size(); i++) {
        res.getValue().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
    parseEpisodeOfCareDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseEpisodeOfCareDiagnosisComponentProperties(JsonObject json, EpisodeOfCare.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("condition")) {
      JsonArray array = getJArray(json, "condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("use"))
      res.setUse(parseCodeableConcept(getJObject(json, "use")));
  }

  protected EventDefinition parseEventDefinition(JsonObject json) throws IOException, FHIRFormatError {
    EventDefinition res = new EventDefinition();
    parseEventDefinitionProperties(json, res);
    return res;
  }

  protected void parseEventDefinitionProperties(JsonObject json, EventDefinition res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseMarkdown(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(getJObject(json, "_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = getJArray(json, "topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("trigger")) {
      JsonArray array = getJArray(json, "trigger");
      for (int i = 0; i < array.size(); i++) {
        res.getTrigger().add(parseTriggerDefinition(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Evidence parseEvidence(JsonObject json) throws IOException, FHIRFormatError {
    Evidence res = new Evidence();
    parseEvidenceProperties(json, res);
    return res;
  }

  protected void parseEvidenceProperties(JsonObject json, Evidence res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    DataType citeAs = parseType("citeAs", json);
    if (citeAs != null)
      res.setCiteAs(citeAs);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("assertion"))
      res.setAssertionElement(parseMarkdown(json.get("assertion").getAsString()));
    if (json.has("_assertion"))
      parseElementProperties(getJObject(json, "_assertion"), res.getAssertionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("variableDefinition")) {
      JsonArray array = getJArray(json, "variableDefinition");
      for (int i = 0; i < array.size(); i++) {
        res.getVariableDefinition().add(parseEvidenceVariableDefinitionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("synthesisType"))
      res.setSynthesisType(parseCodeableConcept(getJObject(json, "synthesisType")));
    if (json.has("studyDesign")) {
      JsonArray array = getJArray(json, "studyDesign");
      for (int i = 0; i < array.size(); i++) {
        res.getStudyDesign().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("statistic")) {
      JsonArray array = getJArray(json, "statistic");
      for (int i = 0; i < array.size(); i++) {
        res.getStatistic().add(parseEvidenceStatisticComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("certainty")) {
      JsonArray array = getJArray(json, "certainty");
      for (int i = 0; i < array.size(); i++) {
        res.getCertainty().add(parseEvidenceCertaintyComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Evidence.EvidenceVariableDefinitionComponent parseEvidenceVariableDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceVariableDefinitionComponent res = new Evidence.EvidenceVariableDefinitionComponent();
    parseEvidenceVariableDefinitionComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableDefinitionComponentProperties(JsonObject json, Evidence.EvidenceVariableDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("variableRole"))
      res.setVariableRole(parseCodeableConcept(getJObject(json, "variableRole")));
    if (json.has("observed"))
      res.setObserved(parseReference(getJObject(json, "observed")));
    if (json.has("intended"))
      res.setIntended(parseReference(getJObject(json, "intended")));
    if (json.has("directnessMatch"))
      res.setDirectnessMatch(parseCodeableConcept(getJObject(json, "directnessMatch")));
  }

  protected Evidence.EvidenceStatisticComponent parseEvidenceStatisticComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceStatisticComponent res = new Evidence.EvidenceStatisticComponent();
    parseEvidenceStatisticComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceStatisticComponentProperties(JsonObject json, Evidence.EvidenceStatisticComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("statisticType"))
      res.setStatisticType(parseCodeableConcept(getJObject(json, "statisticType")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("numberOfEvents"))
      res.setNumberOfEventsElement(parseUnsignedInt(json.get("numberOfEvents").getAsString()));
    if (json.has("_numberOfEvents"))
      parseElementProperties(getJObject(json, "_numberOfEvents"), res.getNumberOfEventsElement());
    if (json.has("numberAffected"))
      res.setNumberAffectedElement(parseUnsignedInt(json.get("numberAffected").getAsString()));
    if (json.has("_numberAffected"))
      parseElementProperties(getJObject(json, "_numberAffected"), res.getNumberAffectedElement());
    if (json.has("sampleSize"))
      res.setSampleSize(parseEvidenceStatisticSampleSizeComponent(getJObject(json, "sampleSize")));
    if (json.has("attributeEstimate")) {
      JsonArray array = getJArray(json, "attributeEstimate");
      for (int i = 0; i < array.size(); i++) {
        res.getAttributeEstimate().add(parseEvidenceStatisticAttributeEstimateComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("modelCharacteristic")) {
      JsonArray array = getJArray(json, "modelCharacteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getModelCharacteristic().add(parseEvidenceStatisticModelCharacteristicComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Evidence.EvidenceStatisticSampleSizeComponent parseEvidenceStatisticSampleSizeComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceStatisticSampleSizeComponent res = new Evidence.EvidenceStatisticSampleSizeComponent();
    parseEvidenceStatisticSampleSizeComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceStatisticSampleSizeComponentProperties(JsonObject json, Evidence.EvidenceStatisticSampleSizeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("numberOfStudies"))
      res.setNumberOfStudiesElement(parseUnsignedInt(json.get("numberOfStudies").getAsString()));
    if (json.has("_numberOfStudies"))
      parseElementProperties(getJObject(json, "_numberOfStudies"), res.getNumberOfStudiesElement());
    if (json.has("numberOfParticipants"))
      res.setNumberOfParticipantsElement(parseUnsignedInt(json.get("numberOfParticipants").getAsString()));
    if (json.has("_numberOfParticipants"))
      parseElementProperties(getJObject(json, "_numberOfParticipants"), res.getNumberOfParticipantsElement());
    if (json.has("knownDataCount"))
      res.setKnownDataCountElement(parseUnsignedInt(json.get("knownDataCount").getAsString()));
    if (json.has("_knownDataCount"))
      parseElementProperties(getJObject(json, "_knownDataCount"), res.getKnownDataCountElement());
  }

  protected Evidence.EvidenceStatisticAttributeEstimateComponent parseEvidenceStatisticAttributeEstimateComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceStatisticAttributeEstimateComponent res = new Evidence.EvidenceStatisticAttributeEstimateComponent();
    parseEvidenceStatisticAttributeEstimateComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceStatisticAttributeEstimateComponentProperties(JsonObject json, Evidence.EvidenceStatisticAttributeEstimateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("level"))
      res.setLevelElement(parseDecimal(json.get("level").getAsBigDecimal()));
    if (json.has("_level"))
      parseElementProperties(getJObject(json, "_level"), res.getLevelElement());
    if (json.has("range"))
      res.setRange(parseRange(getJObject(json, "range")));
    if (json.has("attributeEstimate")) {
      JsonArray array = getJArray(json, "attributeEstimate");
      for (int i = 0; i < array.size(); i++) {
        res.getAttributeEstimate().add(parseEvidenceStatisticAttributeEstimateComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Evidence.EvidenceStatisticModelCharacteristicComponent parseEvidenceStatisticModelCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceStatisticModelCharacteristicComponent res = new Evidence.EvidenceStatisticModelCharacteristicComponent();
    parseEvidenceStatisticModelCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceStatisticModelCharacteristicComponentProperties(JsonObject json, Evidence.EvidenceStatisticModelCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("value"))
      res.setValue(parseQuantity(getJObject(json, "value")));
    if (json.has("variable")) {
      JsonArray array = getJArray(json, "variable");
      for (int i = 0; i < array.size(); i++) {
        res.getVariable().add(parseEvidenceStatisticModelCharacteristicVariableComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("attributeEstimate")) {
      JsonArray array = getJArray(json, "attributeEstimate");
      for (int i = 0; i < array.size(); i++) {
        res.getAttributeEstimate().add(parseEvidenceStatisticAttributeEstimateComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Evidence.EvidenceStatisticModelCharacteristicVariableComponent parseEvidenceStatisticModelCharacteristicVariableComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceStatisticModelCharacteristicVariableComponent res = new Evidence.EvidenceStatisticModelCharacteristicVariableComponent();
    parseEvidenceStatisticModelCharacteristicVariableComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceStatisticModelCharacteristicVariableComponentProperties(JsonObject json, Evidence.EvidenceStatisticModelCharacteristicVariableComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("variableDefinition"))
      res.setVariableDefinition(parseReference(getJObject(json, "variableDefinition")));
    if (json.has("handling"))
      res.setHandlingElement(parseEnumeration(json.get("handling").getAsString(), Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
    if (json.has("_handling"))
      parseElementProperties(getJObject(json, "_handling"), res.getHandlingElement());
    if (json.has("valueCategory")) {
      JsonArray array = getJArray(json, "valueCategory");
      for (int i = 0; i < array.size(); i++) {
        res.getValueCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("valueQuantity")) {
      JsonArray array = getJArray(json, "valueQuantity");
      for (int i = 0; i < array.size(); i++) {
        res.getValueQuantity().add(parseQuantity(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("valueRange")) {
      JsonArray array = getJArray(json, "valueRange");
      for (int i = 0; i < array.size(); i++) {
        res.getValueRange().add(parseRange(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Evidence.EvidenceCertaintyComponent parseEvidenceCertaintyComponent(JsonObject json) throws IOException, FHIRFormatError {
    Evidence.EvidenceCertaintyComponent res = new Evidence.EvidenceCertaintyComponent();
    parseEvidenceCertaintyComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceCertaintyComponentProperties(JsonObject json, Evidence.EvidenceCertaintyComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("rating"))
      res.setRating(parseCodeableConcept(getJObject(json, "rating")));
    if (json.has("rater"))
      res.setRaterElement(parseString(json.get("rater").getAsString()));
    if (json.has("_rater"))
      parseElementProperties(getJObject(json, "_rater"), res.getRaterElement());
    if (json.has("subcomponent")) {
      JsonArray array = getJArray(json, "subcomponent");
      for (int i = 0; i < array.size(); i++) {
        res.getSubcomponent().add(parseEvidenceCertaintyComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EvidenceReport parseEvidenceReport(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceReport res = new EvidenceReport();
    parseEvidenceReportProperties(json, res);
    return res;
  }

  protected void parseEvidenceReportProperties(JsonObject json, EvidenceReport res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedIdentifier")) {
      JsonArray array = getJArray(json, "relatedIdentifier");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    DataType citeAs = parseType("citeAs", json);
    if (citeAs != null)
      res.setCiteAs(citeAs);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseEvidenceReportSubjectComponent(getJObject(json, "subject")));
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatesTo")) {
      JsonArray array = getJArray(json, "relatesTo");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatesTo().add(parseEvidenceReportRelatesToComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("section")) {
      JsonArray array = getJArray(json, "section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseEvidenceReportSectionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EvidenceReport.EvidenceReportSubjectComponent parseEvidenceReportSubjectComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceReport.EvidenceReportSubjectComponent res = new EvidenceReport.EvidenceReportSubjectComponent();
    parseEvidenceReportSubjectComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceReportSubjectComponentProperties(JsonObject json, EvidenceReport.EvidenceReportSubjectComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("characteristic")) {
      JsonArray array = getJArray(json, "characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseEvidenceReportSubjectCharacteristicComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EvidenceReport.EvidenceReportSubjectCharacteristicComponent parseEvidenceReportSubjectCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceReport.EvidenceReportSubjectCharacteristicComponent res = new EvidenceReport.EvidenceReportSubjectCharacteristicComponent();
    parseEvidenceReportSubjectCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceReportSubjectCharacteristicComponentProperties(JsonObject json, EvidenceReport.EvidenceReportSubjectCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(getJObject(json, "_exclude"), res.getExcludeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected EvidenceReport.EvidenceReportRelatesToComponent parseEvidenceReportRelatesToComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceReport.EvidenceReportRelatesToComponent res = new EvidenceReport.EvidenceReportRelatesToComponent();
    parseEvidenceReportRelatesToComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceReportRelatesToComponentProperties(JsonObject json, EvidenceReport.EvidenceReportRelatesToComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), EvidenceReport.ReportRelationshipType.NULL, new EvidenceReport.ReportRelationshipTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("target"))
      res.setTarget(parseEvidenceReportRelatesToTargetComponent(getJObject(json, "target")));
  }

  protected EvidenceReport.EvidenceReportRelatesToTargetComponent parseEvidenceReportRelatesToTargetComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceReport.EvidenceReportRelatesToTargetComponent res = new EvidenceReport.EvidenceReportRelatesToTargetComponent();
    parseEvidenceReportRelatesToTargetComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceReportRelatesToTargetComponentProperties(JsonObject json, EvidenceReport.EvidenceReportRelatesToTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("display"))
      res.setDisplayElement(parseMarkdown(json.get("display").getAsString()));
    if (json.has("_display"))
      parseElementProperties(getJObject(json, "_display"), res.getDisplayElement());
    if (json.has("resource"))
      res.setResource(parseReference(getJObject(json, "resource")));
  }

  protected EvidenceReport.SectionComponent parseEvidenceReportSectionComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceReport.SectionComponent res = new EvidenceReport.SectionComponent();
    parseEvidenceReportSectionComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceReportSectionComponentProperties(JsonObject json, EvidenceReport.SectionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("focus"))
      res.setFocus(parseCodeableConcept(getJObject(json, "focus")));
    if (json.has("focusReference"))
      res.setFocusReference(parseReference(getJObject(json, "focusReference")));
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("text"))
      res.setText(parseNarrative(getJObject(json, "text")));
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(getJObject(json, "orderedBy")));
    if (json.has("entryClassifier")) {
      JsonArray array = getJArray(json, "entryClassifier");
      for (int i = 0; i < array.size(); i++) {
        res.getEntryClassifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("entryReference")) {
      JsonArray array = getJArray(json, "entryReference");
      for (int i = 0; i < array.size(); i++) {
        res.getEntryReference().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("entryQuantity")) {
      JsonArray array = getJArray(json, "entryQuantity");
      for (int i = 0; i < array.size(); i++) {
        res.getEntryQuantity().add(parseQuantity(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(getJObject(json, "emptyReason")));
    if (json.has("section")) {
      JsonArray array = getJArray(json, "section");
      for (int i = 0; i < array.size(); i++) {
        res.getSection().add(parseEvidenceReportSectionComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EvidenceVariable parseEvidenceVariable(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable res = new EvidenceVariable();
    parseEvidenceVariableProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableProperties(JsonObject json, EvidenceVariable res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("shortTitle"))
      res.setShortTitleElement(parseString(json.get("shortTitle").getAsString()));
    if (json.has("_shortTitle"))
      parseElementProperties(getJObject(json, "_shortTitle"), res.getShortTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("actual"))
      res.setActualElement(parseBoolean(json.get("actual").getAsBoolean()));
    if (json.has("_actual"))
      parseElementProperties(getJObject(json, "_actual"), res.getActualElement());
    if (json.has("characteristic")) {
      JsonArray array = getJArray(json, "characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseEvidenceVariableCharacteristicComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("handling"))
      res.setHandlingElement(parseEnumeration(json.get("handling").getAsString(), Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
    if (json.has("_handling"))
      parseElementProperties(getJObject(json, "_handling"), res.getHandlingElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseEvidenceVariableCategoryComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
    parseEvidenceVariableCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableCharacteristicComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("linkId"))
      res.setLinkIdElement(parseId(json.get("linkId").getAsString()));
    if (json.has("_linkId"))
      parseElementProperties(getJObject(json, "_linkId"), res.getLinkIdElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(getJObject(json, "_exclude"), res.getExcludeElement());
    if (json.has("definitionReference"))
      res.setDefinitionReference(parseReference(getJObject(json, "definitionReference")));
    if (json.has("definitionCanonical"))
      res.setDefinitionCanonicalElement(parseCanonical(json.get("definitionCanonical").getAsString()));
    if (json.has("_definitionCanonical"))
      parseElementProperties(getJObject(json, "_definitionCanonical"), res.getDefinitionCanonicalElement());
    if (json.has("definitionCodeableConcept"))
      res.setDefinitionCodeableConcept(parseCodeableConcept(getJObject(json, "definitionCodeableConcept")));
    if (json.has("definitionExpression"))
      res.setDefinitionExpression(parseExpression(getJObject(json, "definitionExpression")));
    if (json.has("definitionId"))
      res.setDefinitionIdElement(parseId(json.get("definitionId").getAsString()));
    if (json.has("_definitionId"))
      parseElementProperties(getJObject(json, "_definitionId"), res.getDefinitionIdElement());
    if (json.has("definitionByTypeAndValue"))
      res.setDefinitionByTypeAndValue(parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(getJObject(json, "definitionByTypeAndValue")));
    if (json.has("definitionByCombination"))
      res.setDefinitionByCombination(parseEvidenceVariableCharacteristicDefinitionByCombinationComponent(getJObject(json, "definitionByCombination")));
    DataType instances = parseType("instances", json);
    if (instances != null)
      res.setInstances(instances);
    DataType duration = parseType("duration", json);
    if (duration != null)
      res.setDuration(duration);
    if (json.has("timeFromEvent")) {
      JsonArray array = getJArray(json, "timeFromEvent");
      for (int i = 0; i < array.size(); i++) {
        res.getTimeFromEvent().add(parseEvidenceVariableCharacteristicTimeFromEventComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent res = new EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent();
    parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("method")) {
      JsonArray array = getJArray(json, "method");
      for (int i = 0; i < array.size(); i++) {
        res.getMethod().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("offset"))
      res.setOffset(parseCodeableConcept(getJObject(json, "offset")));
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent parseEvidenceVariableCharacteristicDefinitionByCombinationComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent res = new EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent();
    parseEvidenceVariableCharacteristicDefinitionByCombinationComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableCharacteristicDefinitionByCombinationComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), EvidenceVariable.CharacteristicCombination.NULL, new EvidenceVariable.CharacteristicCombinationEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("threshold"))
      res.setThresholdElement(parsePositiveInt(json.get("threshold").getAsString()));
    if (json.has("_threshold"))
      parseElementProperties(getJObject(json, "_threshold"), res.getThresholdElement());
    if (json.has("characteristic")) {
      JsonArray array = getJArray(json, "characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseEvidenceVariableCharacteristicComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent parseEvidenceVariableCharacteristicTimeFromEventComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent res = new EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent();
    parseEvidenceVariableCharacteristicTimeFromEventComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableCharacteristicTimeFromEventComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    DataType event = parseType("event", json);
    if (event != null)
      res.setEvent(event);
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("range"))
      res.setRange(parseRange(getJObject(json, "range")));
  }

  protected EvidenceVariable.EvidenceVariableCategoryComponent parseEvidenceVariableCategoryComponent(JsonObject json) throws IOException, FHIRFormatError {
    EvidenceVariable.EvidenceVariableCategoryComponent res = new EvidenceVariable.EvidenceVariableCategoryComponent();
    parseEvidenceVariableCategoryComponentProperties(json, res);
    return res;
  }

  protected void parseEvidenceVariableCategoryComponentProperties(JsonObject json, EvidenceVariable.EvidenceVariableCategoryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected ExampleScenario parseExampleScenario(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario res = new ExampleScenario();
    parseExampleScenarioProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProperties(JsonObject json, ExampleScenario res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("actor")) {
      JsonArray array = getJArray(json, "actor");
      for (int i = 0; i < array.size(); i++) {
        res.getActor().add(parseExampleScenarioActorComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instance")) {
      JsonArray array = getJArray(json, "instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseExampleScenarioInstanceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("process")) {
      JsonArray array = getJArray(json, "process");
      for (int i = 0; i < array.size(); i++) {
        res.getProcess().add(parseExampleScenarioProcessComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioActorComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
    parseExampleScenarioActorComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioActorComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioActorComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseString(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(getJObject(json, "_key"), res.getKeyElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.ExampleScenarioActorType.NULL, new Enumerations.ExampleScenarioActorTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
    parseExampleScenarioInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioInstanceComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseString(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(getJObject(json, "_key"), res.getKeyElement());
    if (json.has("structureType"))
      res.setStructureType(parseCoding(getJObject(json, "structureType")));
    if (json.has("structureVersion"))
      res.setStructureVersionElement(parseString(json.get("structureVersion").getAsString()));
    if (json.has("_structureVersion"))
      parseElementProperties(getJObject(json, "_structureVersion"), res.getStructureVersionElement());
    DataType structureProfile = parseType("structureProfile", json);
    if (structureProfile != null)
      res.setStructureProfile(structureProfile);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("content"))
      res.setContent(parseReference(getJObject(json, "content")));
    if (json.has("version")) {
      JsonArray array = getJArray(json, "version");
      for (int i = 0; i < array.size(); i++) {
        res.getVersion().add(parseExampleScenarioInstanceVersionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("containedInstance")) {
      JsonArray array = getJArray(json, "containedInstance");
      for (int i = 0; i < array.size(); i++) {
        res.getContainedInstance().add(parseExampleScenarioInstanceContainedInstanceComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioInstanceVersionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
    parseExampleScenarioInstanceVersionComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioInstanceVersionComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("key"))
      res.setKeyElement(parseString(json.get("key").getAsString()));
    if (json.has("_key"))
      parseElementProperties(getJObject(json, "_key"), res.getKeyElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("content"))
      res.setContent(parseReference(getJObject(json, "content")));
  }

  protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioInstanceContainedInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
    parseExampleScenarioInstanceContainedInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioInstanceContainedInstanceComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("instanceReference"))
      res.setInstanceReferenceElement(parseString(json.get("instanceReference").getAsString()));
    if (json.has("_instanceReference"))
      parseElementProperties(getJObject(json, "_instanceReference"), res.getInstanceReferenceElement());
    if (json.has("versionReference"))
      res.setVersionReferenceElement(parseString(json.get("versionReference").getAsString()));
    if (json.has("_versionReference"))
      parseElementProperties(getJObject(json, "_versionReference"), res.getVersionReferenceElement());
  }

  protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioProcessComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
    parseExampleScenarioProcessComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProcessComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("preConditions"))
      res.setPreConditionsElement(parseMarkdown(json.get("preConditions").getAsString()));
    if (json.has("_preConditions"))
      parseElementProperties(getJObject(json, "_preConditions"), res.getPreConditionsElement());
    if (json.has("postConditions"))
      res.setPostConditionsElement(parseMarkdown(json.get("postConditions").getAsString()));
    if (json.has("_postConditions"))
      parseElementProperties(getJObject(json, "_postConditions"), res.getPostConditionsElement());
    if (json.has("step")) {
      JsonArray array = getJArray(json, "step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseExampleScenarioProcessStepComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioProcessStepComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
    parseExampleScenarioProcessStepComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProcessStepComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parseString(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("process"))
      res.setProcess(parseExampleScenarioProcessComponent(getJObject(json, "process")));
    if (json.has("workflow"))
      res.setWorkflowElement(parseCanonical(json.get("workflow").getAsString()));
    if (json.has("_workflow"))
      parseElementProperties(getJObject(json, "_workflow"), res.getWorkflowElement());
    if (json.has("operation"))
      res.setOperation(parseExampleScenarioProcessStepOperationComponent(getJObject(json, "operation")));
    if (json.has("alternative")) {
      JsonArray array = getJArray(json, "alternative");
      for (int i = 0; i < array.size(); i++) {
        res.getAlternative().add(parseExampleScenarioProcessStepAlternativeComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("pause"))
      res.setPauseElement(parseBoolean(json.get("pause").getAsBoolean()));
    if (json.has("_pause"))
      parseElementProperties(getJObject(json, "_pause"), res.getPauseElement());
  }

  protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioProcessStepOperationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
    parseExampleScenarioProcessStepOperationComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProcessStepOperationComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCoding(getJObject(json, "type")));
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("initiator"))
      res.setInitiatorElement(parseString(json.get("initiator").getAsString()));
    if (json.has("_initiator"))
      parseElementProperties(getJObject(json, "_initiator"), res.getInitiatorElement());
    if (json.has("receiver"))
      res.setReceiverElement(parseString(json.get("receiver").getAsString()));
    if (json.has("_receiver"))
      parseElementProperties(getJObject(json, "_receiver"), res.getReceiverElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("initiatorActive"))
      res.setInitiatorActiveElement(parseBoolean(json.get("initiatorActive").getAsBoolean()));
    if (json.has("_initiatorActive"))
      parseElementProperties(getJObject(json, "_initiatorActive"), res.getInitiatorActiveElement());
    if (json.has("receiverActive"))
      res.setReceiverActiveElement(parseBoolean(json.get("receiverActive").getAsBoolean()));
    if (json.has("_receiverActive"))
      parseElementProperties(getJObject(json, "_receiverActive"), res.getReceiverActiveElement());
    if (json.has("request"))
      res.setRequest(parseExampleScenarioInstanceContainedInstanceComponent(getJObject(json, "request")));
    if (json.has("response"))
      res.setResponse(parseExampleScenarioInstanceContainedInstanceComponent(getJObject(json, "response")));
  }

  protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioProcessStepAlternativeComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
    parseExampleScenarioProcessStepAlternativeComponentProperties(json, res);
    return res;
  }

  protected void parseExampleScenarioProcessStepAlternativeComponentProperties(JsonObject json, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("step")) {
      JsonArray array = getJArray(json, "step");
      for (int i = 0; i < array.size(); i++) {
        res.getStep().add(parseExampleScenarioProcessStepComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit parseExplanationOfBenefit(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit res = new ExplanationOfBenefit();
    parseExplanationOfBenefitProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitProperties(JsonObject json, ExplanationOfBenefit res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subType"))
      res.setSubType(parseCodeableConcept(getJObject(json, "subType")));
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("billablePeriod"))
      res.setBillablePeriod(parsePeriod(getJObject(json, "billablePeriod")));
    if (json.has("created"))
      res.setCreatedElement(parseDateTime(json.get("created").getAsString()));
    if (json.has("_created"))
      parseElementProperties(getJObject(json, "_created"), res.getCreatedElement());
    if (json.has("enterer"))
      res.setEnterer(parseReference(getJObject(json, "enterer")));
    if (json.has("insurer"))
      res.setInsurer(parseReference(getJObject(json, "insurer")));
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("fundsReserveRequested"))
      res.setFundsReserveRequested(parseCodeableConcept(getJObject(json, "fundsReserveRequested")));
    if (json.has("fundsReserve"))
      res.setFundsReserve(parseCodeableConcept(getJObject(json, "fundsReserve")));
    if (json.has("related")) {
      JsonArray array = getJArray(json, "related");
      for (int i = 0; i < array.size(); i++) {
        res.getRelated().add(parseExplanationOfBenefitRelatedClaimComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("prescription"))
      res.setPrescription(parseReference(getJObject(json, "prescription")));
    if (json.has("originalPrescription"))
      res.setOriginalPrescription(parseReference(getJObject(json, "originalPrescription")));
    if (json.has("event")) {
      JsonArray array = getJArray(json, "event");
      for (int i = 0; i < array.size(); i++) {
        res.getEvent().add(parseExplanationOfBenefitEventComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("payee"))
      res.setPayee(parseExplanationOfBenefitPayeeComponent(getJObject(json, "payee")));
    if (json.has("referral"))
      res.setReferral(parseReference(getJObject(json, "referral")));
    if (json.has("encounter")) {
      JsonArray array = getJArray(json, "encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("facility"))
      res.setFacility(parseReference(getJObject(json, "facility")));
    if (json.has("claim"))
      res.setClaim(parseReference(getJObject(json, "claim")));
    if (json.has("claimResponse"))
      res.setClaimResponse(parseReference(getJObject(json, "claimResponse")));
    if (json.has("outcome"))
      res.setOutcomeElement(parseEnumeration(json.get("outcome").getAsString(), Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
    if (json.has("_outcome"))
      parseElementProperties(getJObject(json, "_outcome"), res.getOutcomeElement());
    if (json.has("decision"))
      res.setDecision(parseCodeableConcept(getJObject(json, "decision")));
    if (json.has("disposition"))
      res.setDispositionElement(parseString(json.get("disposition").getAsString()));
    if (json.has("_disposition"))
      parseElementProperties(getJObject(json, "_disposition"), res.getDispositionElement());
    if (json.has("preAuthRef")) {
      JsonArray array = getJArray(json, "preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {;
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = getJArray(json, "_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPreAuthRef().get(i));
      }
    };
    if (json.has("preAuthRefPeriod")) {
      JsonArray array = getJArray(json, "preAuthRefPeriod");
      for (int i = 0; i < array.size(); i++) {
        res.getPreAuthRefPeriod().add(parsePeriod(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("diagnosisRelatedGroup"))
      res.setDiagnosisRelatedGroup(parseCodeableConcept(getJObject(json, "diagnosisRelatedGroup")));
    if (json.has("careTeam")) {
      JsonArray array = getJArray(json, "careTeam");
      for (int i = 0; i < array.size(); i++) {
        res.getCareTeam().add(parseExplanationOfBenefitCareTeamComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingInfo")) {
      JsonArray array = getJArray(json, "supportingInfo");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInfo().add(parseExplanationOfBenefitSupportingInformationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("diagnosis")) {
      JsonArray array = getJArray(json, "diagnosis");
      for (int i = 0; i < array.size(); i++) {
        res.getDiagnosis().add(parseExplanationOfBenefitDiagnosisComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = getJArray(json, "procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseExplanationOfBenefitProcedureComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("precedence"))
      res.setPrecedenceElement(parsePositiveInt(json.get("precedence").getAsString()));
    if (json.has("_precedence"))
      parseElementProperties(getJObject(json, "_precedence"), res.getPrecedenceElement());
    if (json.has("insurance")) {
      JsonArray array = getJArray(json, "insurance");
      for (int i = 0; i < array.size(); i++) {
        res.getInsurance().add(parseExplanationOfBenefitInsuranceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("accident"))
      res.setAccident(parseExplanationOfBenefitAccidentComponent(getJObject(json, "accident")));
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("item")) {
      JsonArray array = getJArray(json, "item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseExplanationOfBenefitItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("addItem")) {
      JsonArray array = getJArray(json, "addItem");
      for (int i = 0; i < array.size(); i++) {
        res.getAddItem().add(parseExplanationOfBenefitAddedItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("total")) {
      JsonArray array = getJArray(json, "total");
      for (int i = 0; i < array.size(); i++) {
        res.getTotal().add(parseExplanationOfBenefitTotalComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("payment"))
      res.setPayment(parseExplanationOfBenefitPaymentComponent(getJObject(json, "payment")));
    if (json.has("formCode"))
      res.setFormCode(parseCodeableConcept(getJObject(json, "formCode")));
    if (json.has("form"))
      res.setForm(parseAttachment(getJObject(json, "form")));
    if (json.has("processNote")) {
      JsonArray array = getJArray(json, "processNote");
      for (int i = 0; i < array.size(); i++) {
        res.getProcessNote().add(parseExplanationOfBenefitNoteComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("benefitPeriod"))
      res.setBenefitPeriod(parsePeriod(getJObject(json, "benefitPeriod")));
    if (json.has("benefitBalance")) {
      JsonArray array = getJArray(json, "benefitBalance");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefitBalance().add(parseExplanationOfBenefitBenefitBalanceComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
    parseExplanationOfBenefitRelatedClaimComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitRelatedClaimComponentProperties(JsonObject json, ExplanationOfBenefit.RelatedClaimComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("claim"))
      res.setClaim(parseReference(getJObject(json, "claim")));
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("reference"))
      res.setReference(parseIdentifier(getJObject(json, "reference")));
  }

  protected ExplanationOfBenefit.ExplanationOfBenefitEventComponent parseExplanationOfBenefitEventComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ExplanationOfBenefitEventComponent res = new ExplanationOfBenefit.ExplanationOfBenefitEventComponent();
    parseExplanationOfBenefitEventComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitEventComponentProperties(JsonObject json, ExplanationOfBenefit.ExplanationOfBenefitEventComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType when = parseType("when", json);
    if (when != null)
      res.setWhen(when);
  }

  protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
    parseExplanationOfBenefitPayeeComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitPayeeComponentProperties(JsonObject json, ExplanationOfBenefit.PayeeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("party"))
      res.setParty(parseReference(getJObject(json, "party")));
  }

  protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
    parseExplanationOfBenefitCareTeamComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitCareTeamComponentProperties(JsonObject json, ExplanationOfBenefit.CareTeamComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("provider"))
      res.setProvider(parseReference(getJObject(json, "provider")));
    if (json.has("responsible"))
      res.setResponsibleElement(parseBoolean(json.get("responsible").getAsBoolean()));
    if (json.has("_responsible"))
      parseElementProperties(getJObject(json, "_responsible"), res.getResponsibleElement());
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("specialty"))
      res.setSpecialty(parseCodeableConcept(getJObject(json, "specialty")));
  }

  protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
    parseExplanationOfBenefitSupportingInformationComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitSupportingInformationComponentProperties(JsonObject json, ExplanationOfBenefit.SupportingInformationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    DataType timing = parseType("timing", json);
    if (timing != null)
      res.setTiming(timing);
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("reason"))
      res.setReason(parseCoding(getJObject(json, "reason")));
  }

  protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
    parseExplanationOfBenefitDiagnosisComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitDiagnosisComponentProperties(JsonObject json, ExplanationOfBenefit.DiagnosisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    DataType diagnosis = parseType("diagnosis", json);
    if (diagnosis != null)
      res.setDiagnosis(diagnosis);
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("onAdmission"))
      res.setOnAdmission(parseCodeableConcept(getJObject(json, "onAdmission")));
  }

  protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
    parseExplanationOfBenefitProcedureComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitProcedureComponentProperties(JsonObject json, ExplanationOfBenefit.ProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    DataType procedure = parseType("procedure", json);
    if (procedure != null)
      res.setProcedure(procedure);
    if (json.has("udi")) {
      JsonArray array = getJArray(json, "udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
    parseExplanationOfBenefitInsuranceComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitInsuranceComponentProperties(JsonObject json, ExplanationOfBenefit.InsuranceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("focal"))
      res.setFocalElement(parseBoolean(json.get("focal").getAsBoolean()));
    if (json.has("_focal"))
      parseElementProperties(getJObject(json, "_focal"), res.getFocalElement());
    if (json.has("coverage"))
      res.setCoverage(parseReference(getJObject(json, "coverage")));
    if (json.has("preAuthRef")) {
      JsonArray array = getJArray(json, "preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getPreAuthRef().add(new StringType());
        } else {;
          res.getPreAuthRef().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_preAuthRef")) {
      JsonArray array = getJArray(json, "_preAuthRef");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getPreAuthRef().size())
          res.getPreAuthRef().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getPreAuthRef().get(i));
      }
    };
  }

  protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
    parseExplanationOfBenefitAccidentComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAccidentComponentProperties(JsonObject json, ExplanationOfBenefit.AccidentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
  }

  protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
    parseExplanationOfBenefitItemComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitItemComponentProperties(JsonObject json, ExplanationOfBenefit.ItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("careTeamSequence")) {
      JsonArray array = getJArray(json, "careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCareTeamSequence().add(new PositiveIntType());
        } else {;
          res.getCareTeamSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_careTeamSequence")) {
      JsonArray array = getJArray(json, "_careTeamSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCareTeamSequence().size())
          res.getCareTeamSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getCareTeamSequence().get(i));
      }
    };
    if (json.has("diagnosisSequence")) {
      JsonArray array = getJArray(json, "diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDiagnosisSequence().add(new PositiveIntType());
        } else {;
          res.getDiagnosisSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_diagnosisSequence")) {
      JsonArray array = getJArray(json, "_diagnosisSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDiagnosisSequence().size())
          res.getDiagnosisSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDiagnosisSequence().get(i));
      }
    };
    if (json.has("procedureSequence")) {
      JsonArray array = getJArray(json, "procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProcedureSequence().add(new PositiveIntType());
        } else {;
          res.getProcedureSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_procedureSequence")) {
      JsonArray array = getJArray(json, "_procedureSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProcedureSequence().size())
          res.getProcedureSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProcedureSequence().get(i));
      }
    };
    if (json.has("informationSequence")) {
      JsonArray array = getJArray(json, "informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInformationSequence().add(new PositiveIntType());
        } else {;
          res.getInformationSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_informationSequence")) {
      JsonArray array = getJArray(json, "_informationSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInformationSequence().size())
          res.getInformationSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInformationSequence().get(i));
      }
    };
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("request")) {
      JsonArray array = getJArray(json, "request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = getJArray(json, "programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = getJArray(json, "udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("bodySite")) {
      JsonArray array = getJArray(json, "bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseExplanationOfBenefitItemBodySiteComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("encounter")) {
      JsonArray array = getJArray(json, "encounter");
      for (int i = 0; i < array.size(); i++) {
        res.getEncounter().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseExplanationOfBenefitItemReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.ItemBodySiteComponent parseExplanationOfBenefitItemBodySiteComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemBodySiteComponent res = new ExplanationOfBenefit.ItemBodySiteComponent();
    parseExplanationOfBenefitItemBodySiteComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitItemBodySiteComponentProperties(JsonObject json, ExplanationOfBenefit.ItemBodySiteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("site")) {
      JsonArray array = getJArray(json, "site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subSite")) {
      JsonArray array = getJArray(json, "subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.ItemReviewOutcomeComponent parseExplanationOfBenefitItemReviewOutcomeComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.ItemReviewOutcomeComponent res = new ExplanationOfBenefit.ItemReviewOutcomeComponent();
    parseExplanationOfBenefitItemReviewOutcomeComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitItemReviewOutcomeComponentProperties(JsonObject json, ExplanationOfBenefit.ItemReviewOutcomeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("decision"))
      res.setDecision(parseCodeableConcept(getJObject(json, "decision")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("preAuthRef"))
      res.setPreAuthRefElement(parseString(json.get("preAuthRef").getAsString()));
    if (json.has("_preAuthRef"))
      parseElementProperties(getJObject(json, "_preAuthRef"), res.getPreAuthRefElement());
    if (json.has("preAuthPeriod"))
      res.setPreAuthPeriod(parsePeriod(getJObject(json, "preAuthPeriod")));
  }

  protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
    parseExplanationOfBenefitAdjudicationComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAdjudicationComponentProperties(JsonObject json, ExplanationOfBenefit.AdjudicationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("reason"))
      res.setReason(parseCodeableConcept(getJObject(json, "reason")));
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
  }

  protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
    parseExplanationOfBenefitDetailComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitDetailComponentProperties(JsonObject json, ExplanationOfBenefit.DetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = getJArray(json, "programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = getJArray(json, "udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseExplanationOfBenefitItemReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = getJArray(json, "subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitSubDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
    parseExplanationOfBenefitSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit.SubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = getJArray(json, "programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("udi")) {
      JsonArray array = getJArray(json, "udi");
      for (int i = 0; i < array.size(); i++) {
        res.getUdi().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseExplanationOfBenefitItemReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
    parseExplanationOfBenefitAddedItemComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("itemSequence")) {
      JsonArray array = getJArray(json, "itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getItemSequence().add(new PositiveIntType());
        } else {;
          res.getItemSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_itemSequence")) {
      JsonArray array = getJArray(json, "_itemSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getItemSequence().size())
          res.getItemSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getItemSequence().get(i));
      }
    };
    if (json.has("detailSequence")) {
      JsonArray array = getJArray(json, "detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getDetailSequence().add(new PositiveIntType());
        } else {;
          res.getDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_detailSequence")) {
      JsonArray array = getJArray(json, "_detailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getDetailSequence().size())
          res.getDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getDetailSequence().get(i));
      }
    };
    if (json.has("subDetailSequence")) {
      JsonArray array = getJArray(json, "subDetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSubDetailSequence().add(new PositiveIntType());
        } else {;
          res.getSubDetailSequence().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_subDetailSequence")) {
      JsonArray array = getJArray(json, "_subDetailSequence");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubDetailSequence().size())
          res.getSubDetailSequence().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSubDetailSequence().get(i));
      }
    };
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("provider")) {
      JsonArray array = getJArray(json, "provider");
      for (int i = 0; i < array.size(); i++) {
        res.getProvider().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("request")) {
      JsonArray array = getJArray(json, "request");
      for (int i = 0; i < array.size(); i++) {
        res.getRequest().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programCode")) {
      JsonArray array = getJArray(json, "programCode");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType location = parseType("location", json);
    if (location != null)
      res.setLocation(location);
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("bodySite")) {
      JsonArray array = getJArray(json, "bodySite");
      for (int i = 0; i < array.size(); i++) {
        res.getBodySite().add(parseExplanationOfBenefitAddedItemBodySiteComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseExplanationOfBenefitItemReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("detail")) {
      JsonArray array = getJArray(json, "detail");
      for (int i = 0; i < array.size(); i++) {
        res.getDetail().add(parseExplanationOfBenefitAddedItemDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemBodySiteComponent parseExplanationOfBenefitAddedItemBodySiteComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemBodySiteComponent res = new ExplanationOfBenefit.AddedItemBodySiteComponent();
    parseExplanationOfBenefitAddedItemBodySiteComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemBodySiteComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemBodySiteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("site")) {
      JsonArray array = getJArray(json, "site");
      for (int i = 0; i < array.size(); i++) {
        res.getSite().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subSite")) {
      JsonArray array = getJArray(json, "subSite");
      for (int i = 0; i < array.size(); i++) {
        res.getSubSite().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
    parseExplanationOfBenefitAddedItemDetailComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemDetailComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseExplanationOfBenefitItemReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subDetail")) {
      JsonArray array = getJArray(json, "subDetail");
      for (int i = 0; i < array.size(); i++) {
        res.getSubDetail().add(parseExplanationOfBenefitAddedItemDetailSubDetailComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
    parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitAddedItemDetailSubDetailComponentProperties(JsonObject json, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("traceNumber")) {
      JsonArray array = getJArray(json, "traceNumber");
      for (int i = 0; i < array.size(); i++) {
        res.getTraceNumber().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("revenue"))
      res.setRevenue(parseCodeableConcept(getJObject(json, "revenue")));
    if (json.has("productOrService"))
      res.setProductOrService(parseCodeableConcept(getJObject(json, "productOrService")));
    if (json.has("productOrServiceEnd"))
      res.setProductOrServiceEnd(parseCodeableConcept(getJObject(json, "productOrServiceEnd")));
    if (json.has("modifier")) {
      JsonArray array = getJArray(json, "modifier");
      for (int i = 0; i < array.size(); i++) {
        res.getModifier().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patientPaid"))
      res.setPatientPaid(parseMoney(getJObject(json, "patientPaid")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("unitPrice"))
      res.setUnitPrice(parseMoney(getJObject(json, "unitPrice")));
    if (json.has("factor"))
      res.setFactorElement(parseDecimal(json.get("factor").getAsBigDecimal()));
    if (json.has("_factor"))
      parseElementProperties(getJObject(json, "_factor"), res.getFactorElement());
    if (json.has("tax"))
      res.setTax(parseMoney(getJObject(json, "tax")));
    if (json.has("net"))
      res.setNet(parseMoney(getJObject(json, "net")));
    if (json.has("noteNumber")) {
      JsonArray array = getJArray(json, "noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getNoteNumber().add(new PositiveIntType());
        } else {;
          res.getNoteNumber().add(parsePositiveInt(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_noteNumber")) {
      JsonArray array = getJArray(json, "_noteNumber");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getNoteNumber().size())
          res.getNoteNumber().add(parsePositiveInt(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getNoteNumber().get(i));
      }
    };
    if (json.has("reviewOutcome"))
      res.setReviewOutcome(parseExplanationOfBenefitItemReviewOutcomeComponent(getJObject(json, "reviewOutcome")));
    if (json.has("adjudication")) {
      JsonArray array = getJArray(json, "adjudication");
      for (int i = 0; i < array.size(); i++) {
        res.getAdjudication().add(parseExplanationOfBenefitAdjudicationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
    parseExplanationOfBenefitTotalComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitTotalComponentProperties(JsonObject json, ExplanationOfBenefit.TotalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
  }

  protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
    parseExplanationOfBenefitPaymentComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitPaymentComponentProperties(JsonObject json, ExplanationOfBenefit.PaymentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("adjustment"))
      res.setAdjustment(parseMoney(getJObject(json, "adjustment")));
    if (json.has("adjustmentReason"))
      res.setAdjustmentReason(parseCodeableConcept(getJObject(json, "adjustmentReason")));
    if (json.has("date"))
      res.setDateElement(parseDate(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("amount"))
      res.setAmount(parseMoney(getJObject(json, "amount")));
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
  }

  protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
    parseExplanationOfBenefitNoteComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitNoteComponentProperties(JsonObject json, ExplanationOfBenefit.NoteComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("number"))
      res.setNumberElement(parsePositiveInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("text"))
      res.setTextElement(parseString(json.get("text").getAsString()));
    if (json.has("_text"))
      parseElementProperties(getJObject(json, "_text"), res.getTextElement());
    if (json.has("language"))
      res.setLanguage(parseCodeableConcept(getJObject(json, "language")));
  }

  protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
    parseExplanationOfBenefitBenefitBalanceComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitBalanceComponentProperties(JsonObject json, ExplanationOfBenefit.BenefitBalanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("excluded"))
      res.setExcludedElement(parseBoolean(json.get("excluded").getAsBoolean()));
    if (json.has("_excluded"))
      parseElementProperties(getJObject(json, "_excluded"), res.getExcludedElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("network"))
      res.setNetwork(parseCodeableConcept(getJObject(json, "network")));
    if (json.has("unit"))
      res.setUnit(parseCodeableConcept(getJObject(json, "unit")));
    if (json.has("term"))
      res.setTerm(parseCodeableConcept(getJObject(json, "term")));
    if (json.has("financial")) {
      JsonArray array = getJArray(json, "financial");
      for (int i = 0; i < array.size(); i++) {
        res.getFinancial().add(parseExplanationOfBenefitBenefitComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
    ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
    parseExplanationOfBenefitBenefitComponentProperties(json, res);
    return res;
  }

  protected void parseExplanationOfBenefitBenefitComponentProperties(JsonObject json, ExplanationOfBenefit.BenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType allowed = parseType("allowed", json);
    if (allowed != null)
      res.setAllowed(allowed);
    DataType used = parseType("used", json);
    if (used != null)
      res.setUsed(used);
  }

  protected FamilyMemberHistory parseFamilyMemberHistory(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory res = new FamilyMemberHistory();
    parseFamilyMemberHistoryProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryProperties(JsonObject json, FamilyMemberHistory res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instantiatesCanonical")) {
      JsonArray array = getJArray(json, "instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesCanonical().add(new CanonicalType());
        } else {;
          res.getInstantiatesCanonical().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesCanonical")) {
      JsonArray array = getJArray(json, "_instantiatesCanonical");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesCanonical().size())
          res.getInstantiatesCanonical().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiatesCanonical().get(i));
      }
    };
    if (json.has("instantiatesUri")) {
      JsonArray array = getJArray(json, "instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getInstantiatesUri().add(new UriType());
        } else {;
          res.getInstantiatesUri().add(parseUri(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_instantiatesUri")) {
      JsonArray array = getJArray(json, "_instantiatesUri");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getInstantiatesUri().size())
          res.getInstantiatesUri().add(parseUri(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getInstantiatesUri().get(i));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("dataAbsentReason"))
      res.setDataAbsentReason(parseCodeableConcept(getJObject(json, "dataAbsentReason")));
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseFamilyMemberHistoryParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("relationship"))
      res.setRelationship(parseCodeableConcept(getJObject(json, "relationship")));
    if (json.has("sex"))
      res.setSex(parseCodeableConcept(getJObject(json, "sex")));
    DataType born = parseType("born", json);
    if (born != null)
      res.setBorn(born);
    DataType age = parseType("age", json);
    if (age != null)
      res.setAge(age);
    if (json.has("estimatedAge"))
      res.setEstimatedAgeElement(parseBoolean(json.get("estimatedAge").getAsBoolean()));
    if (json.has("_estimatedAge"))
      parseElementProperties(getJObject(json, "_estimatedAge"), res.getEstimatedAgeElement());
    DataType deceased = parseType("deceased", json);
    if (deceased != null)
      res.setDeceased(deceased);
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("condition")) {
      JsonArray array = getJArray(json, "condition");
      for (int i = 0; i < array.size(); i++) {
        res.getCondition().add(parseFamilyMemberHistoryConditionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("procedure")) {
      JsonArray array = getJArray(json, "procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseFamilyMemberHistoryProcedureComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected FamilyMemberHistory.FamilyMemberHistoryParticipantComponent parseFamilyMemberHistoryParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryParticipantComponent res = new FamilyMemberHistory.FamilyMemberHistoryParticipantComponent();
    parseFamilyMemberHistoryParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryParticipantComponentProperties(JsonObject json, FamilyMemberHistory.FamilyMemberHistoryParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryConditionComponent(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
    parseFamilyMemberHistoryConditionComponentProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryConditionComponentProperties(JsonObject json, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(getJObject(json, "outcome")));
    if (json.has("contributedToDeath"))
      res.setContributedToDeathElement(parseBoolean(json.get("contributedToDeath").getAsBoolean()));
    if (json.has("_contributedToDeath"))
      parseElementProperties(getJObject(json, "_contributedToDeath"), res.getContributedToDeathElement());
    DataType onset = parseType("onset", json);
    if (onset != null)
      res.setOnset(onset);
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected FamilyMemberHistory.FamilyMemberHistoryProcedureComponent parseFamilyMemberHistoryProcedureComponent(JsonObject json) throws IOException, FHIRFormatError {
    FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res = new FamilyMemberHistory.FamilyMemberHistoryProcedureComponent();
    parseFamilyMemberHistoryProcedureComponentProperties(json, res);
    return res;
  }

  protected void parseFamilyMemberHistoryProcedureComponentProperties(JsonObject json, FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("outcome"))
      res.setOutcome(parseCodeableConcept(getJObject(json, "outcome")));
    if (json.has("contributedToDeath"))
      res.setContributedToDeathElement(parseBoolean(json.get("contributedToDeath").getAsBoolean()));
    if (json.has("_contributedToDeath"))
      parseElementProperties(getJObject(json, "_contributedToDeath"), res.getContributedToDeathElement());
    DataType performed = parseType("performed", json);
    if (performed != null)
      res.setPerformed(performed);
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Flag parseFlag(JsonObject json) throws IOException, FHIRFormatError {
    Flag res = new Flag();
    parseFlagProperties(json, res);
    return res;
  }

  protected void parseFlagProperties(JsonObject json, Flag res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
  }

  protected FormularyItem parseFormularyItem(JsonObject json) throws IOException, FHIRFormatError {
    FormularyItem res = new FormularyItem();
    parseFormularyItemProperties(json, res);
    return res;
  }

  protected void parseFormularyItemProperties(JsonObject json, FormularyItem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), FormularyItem.FormularyItemStatusCodes.NULL, new FormularyItem.FormularyItemStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
  }

  protected GenomicStudy parseGenomicStudy(JsonObject json) throws IOException, FHIRFormatError {
    GenomicStudy res = new GenomicStudy();
    parseGenomicStudyProperties(json, res);
    return res;
  }

  protected void parseGenomicStudyProperties(JsonObject json, GenomicStudy res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), GenomicStudy.GenomicStudyStatus.NULL, new GenomicStudy.GenomicStudyStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("startDate"))
      res.setStartDateElement(parseDateTime(json.get("startDate").getAsString()));
    if (json.has("_startDate"))
      parseElementProperties(getJObject(json, "_startDate"), res.getStartDateElement());
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("referrer"))
      res.setReferrer(parseReference(getJObject(json, "referrer")));
    if (json.has("interpreter")) {
      JsonArray array = getJArray(json, "interpreter");
      for (int i = 0; i < array.size(); i++) {
        res.getInterpreter().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instantiatesCanonical"))
      res.setInstantiatesCanonicalElement(parseCanonical(json.get("instantiatesCanonical").getAsString()));
    if (json.has("_instantiatesCanonical"))
      parseElementProperties(getJObject(json, "_instantiatesCanonical"), res.getInstantiatesCanonicalElement());
    if (json.has("instantiatesUri"))
      res.setInstantiatesUriElement(parseUri(json.get("instantiatesUri").getAsString()));
    if (json.has("_instantiatesUri"))
      parseElementProperties(getJObject(json, "_instantiatesUri"), res.getInstantiatesUriElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("analysis")) {
      JsonArray array = getJArray(json, "analysis");
      for (int i = 0; i < array.size(); i++) {
        res.getAnalysis().add(parseGenomicStudyAnalysisComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected GenomicStudy.GenomicStudyAnalysisComponent parseGenomicStudyAnalysisComponent(JsonObject json) throws IOException, FHIRFormatError {
    GenomicStudy.GenomicStudyAnalysisComponent res = new GenomicStudy.GenomicStudyAnalysisComponent();
    parseGenomicStudyAnalysisComponentProperties(json, res);
    return res;
  }

  protected void parseGenomicStudyAnalysisComponentProperties(JsonObject json, GenomicStudy.GenomicStudyAnalysisComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("methodType")) {
      JsonArray array = getJArray(json, "methodType");
      for (int i = 0; i < array.size(); i++) {
        res.getMethodType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("changeType")) {
      JsonArray array = getJArray(json, "changeType");
      for (int i = 0; i < array.size(); i++) {
        res.getChangeType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("genomeBuild"))
      res.setGenomeBuild(parseCodeableConcept(getJObject(json, "genomeBuild")));
    if (json.has("instantiatesCanonical"))
      res.setInstantiatesCanonicalElement(parseCanonical(json.get("instantiatesCanonical").getAsString()));
    if (json.has("_instantiatesCanonical"))
      parseElementProperties(getJObject(json, "_instantiatesCanonical"), res.getInstantiatesCanonicalElement());
    if (json.has("instantiatesUri"))
      res.setInstantiatesUriElement(parseUri(json.get("instantiatesUri").getAsString()));
    if (json.has("_instantiatesUri"))
      parseElementProperties(getJObject(json, "_instantiatesUri"), res.getInstantiatesUriElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("focus")) {
      JsonArray array = getJArray(json, "focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("specimen")) {
      JsonArray array = getJArray(json, "specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("protocolPerformed"))
      res.setProtocolPerformed(parseReference(getJObject(json, "protocolPerformed")));
    if (json.has("regionsStudied")) {
      JsonArray array = getJArray(json, "regionsStudied");
      for (int i = 0; i < array.size(); i++) {
        res.getRegionsStudied().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("regionsCalled")) {
      JsonArray array = getJArray(json, "regionsCalled");
      for (int i = 0; i < array.size(); i++) {
        res.getRegionsCalled().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("input")) {
      JsonArray array = getJArray(json, "input");
      for (int i = 0; i < array.size(); i++) {
        res.getInput().add(parseGenomicStudyAnalysisInputComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("output")) {
      JsonArray array = getJArray(json, "output");
      for (int i = 0; i < array.size(); i++) {
        res.getOutput().add(parseGenomicStudyAnalysisOutputComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("performer")) {
      JsonArray array = getJArray(json, "performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseGenomicStudyAnalysisPerformerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("device")) {
      JsonArray array = getJArray(json, "device");
      for (int i = 0; i < array.size(); i++) {
        res.getDevice().add(parseGenomicStudyAnalysisDeviceComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected GenomicStudy.GenomicStudyAnalysisInputComponent parseGenomicStudyAnalysisInputComponent(JsonObject json) throws IOException, FHIRFormatError {
    GenomicStudy.GenomicStudyAnalysisInputComponent res = new GenomicStudy.GenomicStudyAnalysisInputComponent();
    parseGenomicStudyAnalysisInputComponentProperties(json, res);
    return res;
  }

  protected void parseGenomicStudyAnalysisInputComponentProperties(JsonObject json, GenomicStudy.GenomicStudyAnalysisInputComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("file"))
      res.setFile(parseReference(getJObject(json, "file")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType generatedBy = parseType("generatedBy", json);
    if (generatedBy != null)
      res.setGeneratedBy(generatedBy);
  }

  protected GenomicStudy.GenomicStudyAnalysisOutputComponent parseGenomicStudyAnalysisOutputComponent(JsonObject json) throws IOException, FHIRFormatError {
    GenomicStudy.GenomicStudyAnalysisOutputComponent res = new GenomicStudy.GenomicStudyAnalysisOutputComponent();
    parseGenomicStudyAnalysisOutputComponentProperties(json, res);
    return res;
  }

  protected void parseGenomicStudyAnalysisOutputComponentProperties(JsonObject json, GenomicStudy.GenomicStudyAnalysisOutputComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("file"))
      res.setFile(parseReference(getJObject(json, "file")));
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
  }

  protected GenomicStudy.GenomicStudyAnalysisPerformerComponent parseGenomicStudyAnalysisPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    GenomicStudy.GenomicStudyAnalysisPerformerComponent res = new GenomicStudy.GenomicStudyAnalysisPerformerComponent();
    parseGenomicStudyAnalysisPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseGenomicStudyAnalysisPerformerComponentProperties(JsonObject json, GenomicStudy.GenomicStudyAnalysisPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
  }

  protected GenomicStudy.GenomicStudyAnalysisDeviceComponent parseGenomicStudyAnalysisDeviceComponent(JsonObject json) throws IOException, FHIRFormatError {
    GenomicStudy.GenomicStudyAnalysisDeviceComponent res = new GenomicStudy.GenomicStudyAnalysisDeviceComponent();
    parseGenomicStudyAnalysisDeviceComponentProperties(json, res);
    return res;
  }

  protected void parseGenomicStudyAnalysisDeviceComponentProperties(JsonObject json, GenomicStudy.GenomicStudyAnalysisDeviceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("device"))
      res.setDevice(parseReference(getJObject(json, "device")));
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
  }

  protected Goal parseGoal(JsonObject json) throws IOException, FHIRFormatError {
    Goal res = new Goal();
    parseGoalProperties(json, res);
    return res;
  }

  protected void parseGoalProperties(JsonObject json, Goal res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("lifecycleStatus"))
      res.setLifecycleStatusElement(parseEnumeration(json.get("lifecycleStatus").getAsString(), Goal.GoalLifecycleStatus.NULL, new Goal.GoalLifecycleStatusEnumFactory()));
    if (json.has("_lifecycleStatus"))
      parseElementProperties(getJObject(json, "_lifecycleStatus"), res.getLifecycleStatusElement());
    if (json.has("achievementStatus"))
      res.setAchievementStatus(parseCodeableConcept(getJObject(json, "achievementStatus")));
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("continuous"))
      res.setContinuousElement(parseBoolean(json.get("continuous").getAsBoolean()));
    if (json.has("_continuous"))
      parseElementProperties(getJObject(json, "_continuous"), res.getContinuousElement());
    if (json.has("priority"))
      res.setPriority(parseCodeableConcept(getJObject(json, "priority")));
    if (json.has("description"))
      res.setDescription(parseCodeableConcept(getJObject(json, "description")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    DataType start = parseType("start", json);
    if (start != null)
      res.setStart(start);
    if (json.has("target")) {
      JsonArray array = getJArray(json, "target");
      for (int i = 0; i < array.size(); i++) {
        res.getTarget().add(parseGoalTargetComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("statusDate"))
      res.setStatusDateElement(parseDate(json.get("statusDate").getAsString()));
    if (json.has("_statusDate"))
      parseElementProperties(getJObject(json, "_statusDate"), res.getStatusDateElement());
    if (json.has("statusReason"))
      res.setStatusReasonElement(parseString(json.get("statusReason").getAsString()));
    if (json.has("_statusReason"))
      parseElementProperties(getJObject(json, "_statusReason"), res.getStatusReasonElement());
    if (json.has("source"))
      res.setSource(parseReference(getJObject(json, "source")));
    if (json.has("addresses")) {
      JsonArray array = getJArray(json, "addresses");
      for (int i = 0; i < array.size(); i++) {
        res.getAddresses().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("outcome")) {
      JsonArray array = getJArray(json, "outcome");
      for (int i = 0; i < array.size(); i++) {
        res.getOutcome().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Goal.GoalTargetComponent parseGoalTargetComponent(JsonObject json) throws IOException, FHIRFormatError {
    Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
    parseGoalTargetComponentProperties(json, res);
    return res;
  }

  protected void parseGoalTargetComponentProperties(JsonObject json, Goal.GoalTargetComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("measure"))
      res.setMeasure(parseCodeableConcept(getJObject(json, "measure")));
    DataType detail = parseType("detail", json);
    if (detail != null)
      res.setDetail(detail);
    DataType due = parseType("due", json);
    if (due != null)
      res.setDue(due);
  }

  protected GraphDefinition parseGraphDefinition(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition res = new GraphDefinition();
    parseGraphDefinitionProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionProperties(JsonObject json, GraphDefinition res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("start"))
      res.setStartElement(parseId(json.get("start").getAsString()));
    if (json.has("_start"))
      parseElementProperties(getJObject(json, "_start"), res.getStartElement());
    if (json.has("node")) {
      JsonArray array = getJArray(json, "node");
      for (int i = 0; i < array.size(); i++) {
        res.getNode().add(parseGraphDefinitionNodeComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("link")) {
      JsonArray array = getJArray(json, "link");
      for (int i = 0; i < array.size(); i++) {
        res.getLink().add(parseGraphDefinitionLinkComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionNodeComponent parseGraphDefinitionNodeComponent(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionNodeComponent res = new GraphDefinition.GraphDefinitionNodeComponent();
    parseGraphDefinitionNodeComponentProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionNodeComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionNodeComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("nodeId"))
      res.setNodeIdElement(parseId(json.get("nodeId").getAsString()));
    if (json.has("_nodeId"))
      parseElementProperties(getJObject(json, "_nodeId"), res.getNodeIdElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Enumerations.VersionIndependentResourceTypesAll.NULL, new Enumerations.VersionIndependentResourceTypesAllEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
  }

  protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionLinkComponent(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
    parseGraphDefinitionLinkComponentProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionLinkComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionLinkComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("min"))
      res.setMinElement(parseInteger(json.get("min").getAsLong()));
    if (json.has("_min"))
      parseElementProperties(getJObject(json, "_min"), res.getMinElement());
    if (json.has("max"))
      res.setMaxElement(parseString(json.get("max").getAsString()));
    if (json.has("_max"))
      parseElementProperties(getJObject(json, "_max"), res.getMaxElement());
    if (json.has("sourceId"))
      res.setSourceIdElement(parseId(json.get("sourceId").getAsString()));
    if (json.has("_sourceId"))
      parseElementProperties(getJObject(json, "_sourceId"), res.getSourceIdElement());
    if (json.has("path"))
      res.setPathElement(parseString(json.get("path").getAsString()));
    if (json.has("_path"))
      parseElementProperties(getJObject(json, "_path"), res.getPathElement());
    if (json.has("sliceName"))
      res.setSliceNameElement(parseString(json.get("sliceName").getAsString()));
    if (json.has("_sliceName"))
      parseElementProperties(getJObject(json, "_sliceName"), res.getSliceNameElement());
    if (json.has("targetId"))
      res.setTargetIdElement(parseId(json.get("targetId").getAsString()));
    if (json.has("_targetId"))
      parseElementProperties(getJObject(json, "_targetId"), res.getTargetIdElement());
    if (json.has("params"))
      res.setParamsElement(parseString(json.get("params").getAsString()));
    if (json.has("_params"))
      parseElementProperties(getJObject(json, "_params"), res.getParamsElement());
    if (json.has("compartment")) {
      JsonArray array = getJArray(json, "compartment");
      for (int i = 0; i < array.size(); i++) {
        res.getCompartment().add(parseGraphDefinitionLinkCompartmentComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected GraphDefinition.GraphDefinitionLinkCompartmentComponent parseGraphDefinitionLinkCompartmentComponent(JsonObject json) throws IOException, FHIRFormatError {
    GraphDefinition.GraphDefinitionLinkCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkCompartmentComponent();
    parseGraphDefinitionLinkCompartmentComponentProperties(json, res);
    return res;
  }

  protected void parseGraphDefinitionLinkCompartmentComponentProperties(JsonObject json, GraphDefinition.GraphDefinitionLinkCompartmentComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("use"))
      res.setUseElement(parseEnumeration(json.get("use").getAsString(), GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
    if (json.has("_use"))
      parseElementProperties(getJObject(json, "_use"), res.getUseElement());
    if (json.has("rule"))
      res.setRuleElement(parseEnumeration(json.get("rule").getAsString(), GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
    if (json.has("_rule"))
      parseElementProperties(getJObject(json, "_rule"), res.getRuleElement());
    if (json.has("code"))
      res.setCodeElement(parseEnumeration(json.get("code").getAsString(), Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("expression"))
      res.setExpressionElement(parseString(json.get("expression").getAsString()));
    if (json.has("_expression"))
      parseElementProperties(getJObject(json, "_expression"), res.getExpressionElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected Group parseGroup(JsonObject json) throws IOException, FHIRFormatError {
    Group res = new Group();
    parseGroupProperties(json, res);
    return res;
  }

  protected void parseGroupProperties(JsonObject json, Group res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(getJObject(json, "_active"), res.getActiveElement());
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("membership"))
      res.setMembershipElement(parseEnumeration(json.get("membership").getAsString(), Group.GroupMembershipBasis.NULL, new Group.GroupMembershipBasisEnumFactory()));
    if (json.has("_membership"))
      parseElementProperties(getJObject(json, "_membership"), res.getMembershipElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("quantity"))
      res.setQuantityElement(parseUnsignedInt(json.get("quantity").getAsString()));
    if (json.has("_quantity"))
      parseElementProperties(getJObject(json, "_quantity"), res.getQuantityElement());
    if (json.has("managingEntity"))
      res.setManagingEntity(parseReference(getJObject(json, "managingEntity")));
    if (json.has("characteristic")) {
      JsonArray array = getJArray(json, "characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseGroupCharacteristicComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("member")) {
      JsonArray array = getJArray(json, "member");
      for (int i = 0; i < array.size(); i++) {
        res.getMember().add(parseGroupMemberComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Group.GroupCharacteristicComponent parseGroupCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
    parseGroupCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseGroupCharacteristicComponentProperties(JsonObject json, Group.GroupCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
    if (json.has("exclude"))
      res.setExcludeElement(parseBoolean(json.get("exclude").getAsBoolean()));
    if (json.has("_exclude"))
      parseElementProperties(getJObject(json, "_exclude"), res.getExcludeElement());
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
  }

  protected Group.GroupMemberComponent parseGroupMemberComponent(JsonObject json) throws IOException, FHIRFormatError {
    Group.GroupMemberComponent res = new Group.GroupMemberComponent();
    parseGroupMemberComponentProperties(json, res);
    return res;
  }

  protected void parseGroupMemberComponentProperties(JsonObject json, Group.GroupMemberComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("entity"))
      res.setEntity(parseReference(getJObject(json, "entity")));
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("inactive"))
      res.setInactiveElement(parseBoolean(json.get("inactive").getAsBoolean()));
    if (json.has("_inactive"))
      parseElementProperties(getJObject(json, "_inactive"), res.getInactiveElement());
  }

  protected GuidanceResponse parseGuidanceResponse(JsonObject json) throws IOException, FHIRFormatError {
    GuidanceResponse res = new GuidanceResponse();
    parseGuidanceResponseProperties(json, res);
    return res;
  }

  protected void parseGuidanceResponseProperties(JsonObject json, GuidanceResponse res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("requestIdentifier"))
      res.setRequestIdentifier(parseIdentifier(getJObject(json, "requestIdentifier")));
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    DataType module = parseType("module", json);
    if (module != null)
      res.setModule(module);
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("occurrenceDateTime"))
      res.setOccurrenceDateTimeElement(parseDateTime(json.get("occurrenceDateTime").getAsString()));
    if (json.has("_occurrenceDateTime"))
      parseElementProperties(getJObject(json, "_occurrenceDateTime"), res.getOccurrenceDateTimeElement());
    if (json.has("performer"))
      res.setPerformer(parseReference(getJObject(json, "performer")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("evaluationMessage"))
      res.setEvaluationMessage(parseReference(getJObject(json, "evaluationMessage")));
    if (json.has("outputParameters"))
      res.setOutputParameters(parseReference(getJObject(json, "outputParameters")));
    if (json.has("result")) {
      JsonArray array = getJArray(json, "result");
      for (int i = 0; i < array.size(); i++) {
        res.getResult().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("dataRequirement")) {
      JsonArray array = getJArray(json, "dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected HealthcareService parseHealthcareService(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService res = new HealthcareService();
    parseHealthcareServiceProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceProperties(JsonObject json, HealthcareService res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(getJObject(json, "_active"), res.getActiveElement());
    if (json.has("providedBy"))
      res.setProvidedBy(parseReference(getJObject(json, "providedBy")));
    if (json.has("offeredIn")) {
      JsonArray array = getJArray(json, "offeredIn");
      for (int i = 0; i < array.size(); i++) {
        res.getOfferedIn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("specialty")) {
      JsonArray array = getJArray(json, "specialty");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecialty().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("location")) {
      JsonArray array = getJArray(json, "location");
      for (int i = 0; i < array.size(); i++) {
        res.getLocation().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("extraDetails"))
      res.setExtraDetailsElement(parseMarkdown(json.get("extraDetails").getAsString()));
    if (json.has("_extraDetails"))
      parseElementProperties(getJObject(json, "_extraDetails"), res.getExtraDetailsElement());
    if (json.has("photo"))
      res.setPhoto(parseAttachment(getJObject(json, "photo")));
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseExtendedContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("coverageArea")) {
      JsonArray array = getJArray(json, "coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("serviceProvisionCode")) {
      JsonArray array = getJArray(json, "serviceProvisionCode");
      for (int i = 0; i < array.size(); i++) {
        res.getServiceProvisionCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("eligibility")) {
      JsonArray array = getJArray(json, "eligibility");
      for (int i = 0; i < array.size(); i++) {
        res.getEligibility().add(parseHealthcareServiceEligibilityComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("program")) {
      JsonArray array = getJArray(json, "program");
      for (int i = 0; i < array.size(); i++) {
        res.getProgram().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("characteristic")) {
      JsonArray array = getJArray(json, "characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("communication")) {
      JsonArray array = getJArray(json, "communication");
      for (int i = 0; i < array.size(); i++) {
        res.getCommunication().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("referralMethod")) {
      JsonArray array = getJArray(json, "referralMethod");
      for (int i = 0; i < array.size(); i++) {
        res.getReferralMethod().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("appointmentRequired"))
      res.setAppointmentRequiredElement(parseBoolean(json.get("appointmentRequired").getAsBoolean()));
    if (json.has("_appointmentRequired"))
      parseElementProperties(getJObject(json, "_appointmentRequired"), res.getAppointmentRequiredElement());
    if (json.has("availability")) {
      JsonArray array = getJArray(json, "availability");
      for (int i = 0; i < array.size(); i++) {
        res.getAvailability().add(parseAvailability(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = getJArray(json, "endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected HealthcareService.HealthcareServiceEligibilityComponent parseHealthcareServiceEligibilityComponent(JsonObject json) throws IOException, FHIRFormatError {
    HealthcareService.HealthcareServiceEligibilityComponent res = new HealthcareService.HealthcareServiceEligibilityComponent();
    parseHealthcareServiceEligibilityComponentProperties(json, res);
    return res;
  }

  protected void parseHealthcareServiceEligibilityComponentProperties(JsonObject json, HealthcareService.HealthcareServiceEligibilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
  }

  protected ImagingSelection parseImagingSelection(JsonObject json) throws IOException, FHIRFormatError {
    ImagingSelection res = new ImagingSelection();
    parseImagingSelectionProperties(json, res);
    return res;
  }

  protected void parseImagingSelectionProperties(JsonObject json, ImagingSelection res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImagingSelection.ImagingSelectionStatus.NULL, new ImagingSelection.ImagingSelectionStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("issued"))
      res.setIssuedElement(parseInstant(json.get("issued").getAsString()));
    if (json.has("_issued"))
      parseElementProperties(getJObject(json, "_issued"), res.getIssuedElement());
    if (json.has("performer")) {
      JsonArray array = getJArray(json, "performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImagingSelectionPerformerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("studyUid"))
      res.setStudyUidElement(parseId(json.get("studyUid").getAsString()));
    if (json.has("_studyUid"))
      parseElementProperties(getJObject(json, "_studyUid"), res.getStudyUidElement());
    if (json.has("derivedFrom")) {
      JsonArray array = getJArray(json, "derivedFrom");
      for (int i = 0; i < array.size(); i++) {
        res.getDerivedFrom().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = getJArray(json, "endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("seriesUid"))
      res.setSeriesUidElement(parseId(json.get("seriesUid").getAsString()));
    if (json.has("_seriesUid"))
      parseElementProperties(getJObject(json, "_seriesUid"), res.getSeriesUidElement());
    if (json.has("seriesNumber"))
      res.setSeriesNumberElement(parseUnsignedInt(json.get("seriesNumber").getAsString()));
    if (json.has("_seriesNumber"))
      parseElementProperties(getJObject(json, "_seriesNumber"), res.getSeriesNumberElement());
    if (json.has("frameOfReferenceUid"))
      res.setFrameOfReferenceUidElement(parseId(json.get("frameOfReferenceUid").getAsString()));
    if (json.has("_frameOfReferenceUid"))
      parseElementProperties(getJObject(json, "_frameOfReferenceUid"), res.getFrameOfReferenceUidElement());
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableReference(getJObject(json, "bodySite")));
    if (json.has("focus")) {
      JsonArray array = getJArray(json, "focus");
      for (int i = 0; i < array.size(); i++) {
        res.getFocus().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instance")) {
      JsonArray array = getJArray(json, "instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingSelectionInstanceComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ImagingSelection.ImagingSelectionPerformerComponent parseImagingSelectionPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingSelection.ImagingSelectionPerformerComponent res = new ImagingSelection.ImagingSelectionPerformerComponent();
    parseImagingSelectionPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseImagingSelectionPerformerComponentProperties(JsonObject json, ImagingSelection.ImagingSelectionPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected ImagingSelection.ImagingSelectionInstanceComponent parseImagingSelectionInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingSelection.ImagingSelectionInstanceComponent res = new ImagingSelection.ImagingSelectionInstanceComponent();
    parseImagingSelectionInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseImagingSelectionInstanceComponentProperties(JsonObject json, ImagingSelection.ImagingSelectionInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseId(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(getJObject(json, "_uid"), res.getUidElement());
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("sopClass"))
      res.setSopClass(parseCoding(getJObject(json, "sopClass")));
    if (json.has("subset")) {
      JsonArray array = getJArray(json, "subset");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getSubset().add(new StringType());
        } else {;
          res.getSubset().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_subset")) {
      JsonArray array = getJArray(json, "_subset");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getSubset().size())
          res.getSubset().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getSubset().get(i));
      }
    };
    if (json.has("imageRegion2D")) {
      JsonArray array = getJArray(json, "imageRegion2D");
      for (int i = 0; i < array.size(); i++) {
        res.getImageRegion2D().add(parseImagingSelectionImageRegion2DComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("imageRegion3D")) {
      JsonArray array = getJArray(json, "imageRegion3D");
      for (int i = 0; i < array.size(); i++) {
        res.getImageRegion3D().add(parseImagingSelectionImageRegion3DComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ImagingSelection.ImageRegion2DComponent parseImagingSelectionImageRegion2DComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingSelection.ImageRegion2DComponent res = new ImagingSelection.ImageRegion2DComponent();
    parseImagingSelectionImageRegion2DComponentProperties(json, res);
    return res;
  }

  protected void parseImagingSelectionImageRegion2DComponentProperties(JsonObject json, ImagingSelection.ImageRegion2DComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("regionType"))
      res.setRegionTypeElement(parseEnumeration(json.get("regionType").getAsString(), ImagingSelection.ImagingSelection2DGraphicType.NULL, new ImagingSelection.ImagingSelection2DGraphicTypeEnumFactory()));
    if (json.has("_regionType"))
      parseElementProperties(getJObject(json, "_regionType"), res.getRegionTypeElement());
    if (json.has("coordinate")) {
      JsonArray array = getJArray(json, "coordinate");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCoordinate().add(new DecimalType());
        } else {;
          res.getCoordinate().add(parseDecimal(array.get(i).getAsBigDecimal()));
        }
      }
    };
    if (json.has("_coordinate")) {
      JsonArray array = getJArray(json, "_coordinate");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCoordinate().size())
          res.getCoordinate().add(parseDecimal(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getCoordinate().get(i));
      }
    };
  }

  protected ImagingSelection.ImageRegion3DComponent parseImagingSelectionImageRegion3DComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingSelection.ImageRegion3DComponent res = new ImagingSelection.ImageRegion3DComponent();
    parseImagingSelectionImageRegion3DComponentProperties(json, res);
    return res;
  }

  protected void parseImagingSelectionImageRegion3DComponentProperties(JsonObject json, ImagingSelection.ImageRegion3DComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("regionType"))
      res.setRegionTypeElement(parseEnumeration(json.get("regionType").getAsString(), ImagingSelection.ImagingSelection3DGraphicType.NULL, new ImagingSelection.ImagingSelection3DGraphicTypeEnumFactory()));
    if (json.has("_regionType"))
      parseElementProperties(getJObject(json, "_regionType"), res.getRegionTypeElement());
    if (json.has("coordinate")) {
      JsonArray array = getJArray(json, "coordinate");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getCoordinate().add(new DecimalType());
        } else {;
          res.getCoordinate().add(parseDecimal(array.get(i).getAsBigDecimal()));
        }
      }
    };
    if (json.has("_coordinate")) {
      JsonArray array = getJArray(json, "_coordinate");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getCoordinate().size())
          res.getCoordinate().add(parseDecimal(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getCoordinate().get(i));
      }
    };
  }

  protected ImagingStudy parseImagingStudy(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy res = new ImagingStudy();
    parseImagingStudyProperties(json, res);
    return res;
  }

  protected void parseImagingStudyProperties(JsonObject json, ImagingStudy res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("modality")) {
      JsonArray array = getJArray(json, "modality");
      for (int i = 0; i < array.size(); i++) {
        res.getModality().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(getJObject(json, "_started"), res.getStartedElement());
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("partOf")) {
      JsonArray array = getJArray(json, "partOf");
      for (int i = 0; i < array.size(); i++) {
        res.getPartOf().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("referrer"))
      res.setReferrer(parseReference(getJObject(json, "referrer")));
    if (json.has("endpoint")) {
      JsonArray array = getJArray(json, "endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("numberOfSeries"))
      res.setNumberOfSeriesElement(parseUnsignedInt(json.get("numberOfSeries").getAsString()));
    if (json.has("_numberOfSeries"))
      parseElementProperties(getJObject(json, "_numberOfSeries"), res.getNumberOfSeriesElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(getJObject(json, "_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("procedure")) {
      JsonArray array = getJArray(json, "procedure");
      for (int i = 0; i < array.size(); i++) {
        res.getProcedure().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("series")) {
      JsonArray array = getJArray(json, "series");
      for (int i = 0; i < array.size(); i++) {
        res.getSeries().add(parseImagingStudySeriesComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudySeriesComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
    parseImagingStudySeriesComponentProperties(json, res);
    return res;
  }

  protected void parseImagingStudySeriesComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseId(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(getJObject(json, "_uid"), res.getUidElement());
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("modality"))
      res.setModality(parseCodeableConcept(getJObject(json, "modality")));
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("numberOfInstances"))
      res.setNumberOfInstancesElement(parseUnsignedInt(json.get("numberOfInstances").getAsString()));
    if (json.has("_numberOfInstances"))
      parseElementProperties(getJObject(json, "_numberOfInstances"), res.getNumberOfInstancesElement());
    if (json.has("endpoint")) {
      JsonArray array = getJArray(json, "endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("bodySite"))
      res.setBodySite(parseCodeableReference(getJObject(json, "bodySite")));
    if (json.has("laterality"))
      res.setLaterality(parseCodeableConcept(getJObject(json, "laterality")));
    if (json.has("specimen")) {
      JsonArray array = getJArray(json, "specimen");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecimen().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("started"))
      res.setStartedElement(parseDateTime(json.get("started").getAsString()));
    if (json.has("_started"))
      parseElementProperties(getJObject(json, "_started"), res.getStartedElement());
    if (json.has("performer")) {
      JsonArray array = getJArray(json, "performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImagingStudySeriesPerformerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instance")) {
      JsonArray array = getJArray(json, "instance");
      for (int i = 0; i < array.size(); i++) {
        res.getInstance().add(parseImagingStudySeriesInstanceComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudySeriesPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
    parseImagingStudySeriesPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseImagingStudySeriesPerformerComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudySeriesInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
    parseImagingStudySeriesInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseImagingStudySeriesInstanceComponentProperties(JsonObject json, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uid"))
      res.setUidElement(parseId(json.get("uid").getAsString()));
    if (json.has("_uid"))
      parseElementProperties(getJObject(json, "_uid"), res.getUidElement());
    if (json.has("sopClass"))
      res.setSopClass(parseCoding(getJObject(json, "sopClass")));
    if (json.has("number"))
      res.setNumberElement(parseUnsignedInt(json.get("number").getAsString()));
    if (json.has("_number"))
      parseElementProperties(getJObject(json, "_number"), res.getNumberElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
  }

  protected Immunization parseImmunization(JsonObject json) throws IOException, FHIRFormatError {
    Immunization res = new Immunization();
    parseImmunizationProperties(json, res);
    return res;
  }

  protected void parseImmunizationProperties(JsonObject json, Immunization res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("basedOn")) {
      JsonArray array = getJArray(json, "basedOn");
      for (int i = 0; i < array.size(); i++) {
        res.getBasedOn().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Immunization.ImmunizationStatusCodes.NULL, new Immunization.ImmunizationStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("statusReason"))
      res.setStatusReason(parseCodeableConcept(getJObject(json, "statusReason")));
    if (json.has("vaccineCode"))
      res.setVaccineCode(parseCodeableConcept(getJObject(json, "vaccineCode")));
    if (json.has("administeredProduct"))
      res.setAdministeredProduct(parseCodeableReference(getJObject(json, "administeredProduct")));
    if (json.has("manufacturer"))
      res.setManufacturer(parseCodeableReference(getJObject(json, "manufacturer")));
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(getJObject(json, "_lotNumber"), res.getLotNumberElement());
    if (json.has("expirationDate"))
      res.setExpirationDateElement(parseDate(json.get("expirationDate").getAsString()));
    if (json.has("_expirationDate"))
      parseElementProperties(getJObject(json, "_expirationDate"), res.getExpirationDateElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("supportingInformation")) {
      JsonArray array = getJArray(json, "supportingInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingInformation().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    DataType occurrence = parseType("occurrence", json);
    if (occurrence != null)
      res.setOccurrence(occurrence);
    if (json.has("primarySource"))
      res.setPrimarySourceElement(parseBoolean(json.get("primarySource").getAsBoolean()));
    if (json.has("_primarySource"))
      parseElementProperties(getJObject(json, "_primarySource"), res.getPrimarySourceElement());
    if (json.has("informationSource"))
      res.setInformationSource(parseCodeableReference(getJObject(json, "informationSource")));
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("site"))
      res.setSite(parseCodeableConcept(getJObject(json, "site")));
    if (json.has("route"))
      res.setRoute(parseCodeableConcept(getJObject(json, "route")));
    if (json.has("doseQuantity"))
      res.setDoseQuantity(parseQuantity(getJObject(json, "doseQuantity")));
    if (json.has("performer")) {
      JsonArray array = getJArray(json, "performer");
      for (int i = 0; i < array.size(); i++) {
        res.getPerformer().add(parseImmunizationPerformerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reason")) {
      JsonArray array = getJArray(json, "reason");
      for (int i = 0; i < array.size(); i++) {
        res.getReason().add(parseCodeableReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("isSubpotent"))
      res.setIsSubpotentElement(parseBoolean(json.get("isSubpotent").getAsBoolean()));
    if (json.has("_isSubpotent"))
      parseElementProperties(getJObject(json, "_isSubpotent"), res.getIsSubpotentElement());
    if (json.has("subpotentReason")) {
      JsonArray array = getJArray(json, "subpotentReason");
      for (int i = 0; i < array.size(); i++) {
        res.getSubpotentReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("programEligibility")) {
      JsonArray array = getJArray(json, "programEligibility");
      for (int i = 0; i < array.size(); i++) {
        res.getProgramEligibility().add(parseImmunizationProgramEligibilityComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("fundingSource"))
      res.setFundingSource(parseCodeableConcept(getJObject(json, "fundingSource")));
    if (json.has("reaction")) {
      JsonArray array = getJArray(json, "reaction");
      for (int i = 0; i < array.size(); i++) {
        res.getReaction().add(parseImmunizationReactionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("protocolApplied")) {
      JsonArray array = getJArray(json, "protocolApplied");
      for (int i = 0; i < array.size(); i++) {
        res.getProtocolApplied().add(parseImmunizationProtocolAppliedComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Immunization.ImmunizationPerformerComponent parseImmunizationPerformerComponent(JsonObject json) throws IOException, FHIRFormatError {
    Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
    parseImmunizationPerformerComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationPerformerComponentProperties(JsonObject json, Immunization.ImmunizationPerformerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("function"))
      res.setFunction(parseCodeableConcept(getJObject(json, "function")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected Immunization.ImmunizationProgramEligibilityComponent parseImmunizationProgramEligibilityComponent(JsonObject json) throws IOException, FHIRFormatError {
    Immunization.ImmunizationProgramEligibilityComponent res = new Immunization.ImmunizationProgramEligibilityComponent();
    parseImmunizationProgramEligibilityComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationProgramEligibilityComponentProperties(JsonObject json, Immunization.ImmunizationProgramEligibilityComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("program"))
      res.setProgram(parseCodeableConcept(getJObject(json, "program")));
    if (json.has("programStatus"))
      res.setProgramStatus(parseCodeableConcept(getJObject(json, "programStatus")));
  }

  protected Immunization.ImmunizationReactionComponent parseImmunizationReactionComponent(JsonObject json) throws IOException, FHIRFormatError {
    Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
    parseImmunizationReactionComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationReactionComponentProperties(JsonObject json, Immunization.ImmunizationReactionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("manifestation"))
      res.setManifestation(parseCodeableReference(getJObject(json, "manifestation")));
    if (json.has("reported"))
      res.setReportedElement(parseBoolean(json.get("reported").getAsBoolean()));
    if (json.has("_reported"))
      parseElementProperties(getJObject(json, "_reported"), res.getReportedElement());
  }

  protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationProtocolAppliedComponent(JsonObject json) throws IOException, FHIRFormatError {
    Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
    parseImmunizationProtocolAppliedComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationProtocolAppliedComponentProperties(JsonObject json, Immunization.ImmunizationProtocolAppliedComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(getJObject(json, "_series"), res.getSeriesElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(getJObject(json, "authority")));
    if (json.has("targetDisease")) {
      JsonArray array = getJArray(json, "targetDisease");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetDisease().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("doseNumber"))
      res.setDoseNumberElement(parseString(json.get("doseNumber").getAsString()));
    if (json.has("_doseNumber"))
      parseElementProperties(getJObject(json, "_doseNumber"), res.getDoseNumberElement());
    if (json.has("seriesDoses"))
      res.setSeriesDosesElement(parseString(json.get("seriesDoses").getAsString()));
    if (json.has("_seriesDoses"))
      parseElementProperties(getJObject(json, "_seriesDoses"), res.getSeriesDosesElement());
  }

  protected ImmunizationEvaluation parseImmunizationEvaluation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationEvaluation res = new ImmunizationEvaluation();
    parseImmunizationEvaluationProperties(json, res);
    return res;
  }

  protected void parseImmunizationEvaluationProperties(JsonObject json, ImmunizationEvaluation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ImmunizationEvaluation.ImmunizationEvaluationStatusCodes.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(getJObject(json, "authority")));
    if (json.has("targetDisease"))
      res.setTargetDisease(parseCodeableConcept(getJObject(json, "targetDisease")));
    if (json.has("immunizationEvent"))
      res.setImmunizationEvent(parseReference(getJObject(json, "immunizationEvent")));
    if (json.has("doseStatus"))
      res.setDoseStatus(parseCodeableConcept(getJObject(json, "doseStatus")));
    if (json.has("doseStatusReason")) {
      JsonArray array = getJArray(json, "doseStatusReason");
      for (int i = 0; i < array.size(); i++) {
        res.getDoseStatusReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(getJObject(json, "_series"), res.getSeriesElement());
    if (json.has("doseNumber"))
      res.setDoseNumberElement(parseString(json.get("doseNumber").getAsString()));
    if (json.has("_doseNumber"))
      parseElementProperties(getJObject(json, "_doseNumber"), res.getDoseNumberElement());
    if (json.has("seriesDoses"))
      res.setSeriesDosesElement(parseString(json.get("seriesDoses").getAsString()));
    if (json.has("_seriesDoses"))
      parseElementProperties(getJObject(json, "_seriesDoses"), res.getSeriesDosesElement());
  }

  protected ImmunizationRecommendation parseImmunizationRecommendation(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation res = new ImmunizationRecommendation();
    parseImmunizationRecommendationProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationProperties(JsonObject json, ImmunizationRecommendation res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("patient"))
      res.setPatient(parseReference(getJObject(json, "patient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("authority"))
      res.setAuthority(parseReference(getJObject(json, "authority")));
    if (json.has("recommendation")) {
      JsonArray array = getJArray(json, "recommendation");
      for (int i = 0; i < array.size(); i++) {
        res.getRecommendation().add(parseImmunizationRecommendationRecommendationComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationRecommendationComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
    parseImmunizationRecommendationRecommendationComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationRecommendationComponentProperties(JsonObject json, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("vaccineCode")) {
      JsonArray array = getJArray(json, "vaccineCode");
      for (int i = 0; i < array.size(); i++) {
        res.getVaccineCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("targetDisease")) {
      JsonArray array = getJArray(json, "targetDisease");
      for (int i = 0; i < array.size(); i++) {
        res.getTargetDisease().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("contraindicatedVaccineCode")) {
      JsonArray array = getJArray(json, "contraindicatedVaccineCode");
      for (int i = 0; i < array.size(); i++) {
        res.getContraindicatedVaccineCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("forecastStatus"))
      res.setForecastStatus(parseCodeableConcept(getJObject(json, "forecastStatus")));
    if (json.has("forecastReason")) {
      JsonArray array = getJArray(json, "forecastReason");
      for (int i = 0; i < array.size(); i++) {
        res.getForecastReason().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("dateCriterion")) {
      JsonArray array = getJArray(json, "dateCriterion");
      for (int i = 0; i < array.size(); i++) {
        res.getDateCriterion().add(parseImmunizationRecommendationRecommendationDateCriterionComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("series"))
      res.setSeriesElement(parseString(json.get("series").getAsString()));
    if (json.has("_series"))
      parseElementProperties(getJObject(json, "_series"), res.getSeriesElement());
    if (json.has("doseNumber"))
      res.setDoseNumberElement(parseString(json.get("doseNumber").getAsString()));
    if (json.has("_doseNumber"))
      parseElementProperties(getJObject(json, "_doseNumber"), res.getDoseNumberElement());
    if (json.has("seriesDoses"))
      res.setSeriesDosesElement(parseString(json.get("seriesDoses").getAsString()));
    if (json.has("_seriesDoses"))
      parseElementProperties(getJObject(json, "_seriesDoses"), res.getSeriesDosesElement());
    if (json.has("supportingImmunization")) {
      JsonArray array = getJArray(json, "supportingImmunization");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingImmunization().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("supportingPatientInformation")) {
      JsonArray array = getJArray(json, "supportingPatientInformation");
      for (int i = 0; i < array.size(); i++) {
        res.getSupportingPatientInformation().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationRecommendationDateCriterionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
    parseImmunizationRecommendationRecommendationDateCriterionComponentProperties(json, res);
    return res;
  }

  protected void parseImmunizationRecommendationRecommendationDateCriterionComponentProperties(JsonObject json, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("value"))
      res.setValueElement(parseDateTime(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected ImplementationGuide parseImplementationGuide(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide res = new ImplementationGuide();
    parseImplementationGuideProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideProperties(JsonObject json, ImplementationGuide res) throws IOException, FHIRFormatError {
    parseCanonicalResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("packageId"))
      res.setPackageIdElement(parseId(json.get("packageId").getAsString()));
    if (json.has("_packageId"))
      parseElementProperties(getJObject(json, "_packageId"), res.getPackageIdElement());
    if (json.has("license"))
      res.setLicenseElement(parseEnumeration(json.get("license").getAsString(), ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
    if (json.has("_license"))
      parseElementProperties(getJObject(json, "_license"), res.getLicenseElement());
    if (json.has("fhirVersion")) {
      JsonArray array = getJArray(json, "fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFhirVersion().add(new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory(), Enumerations.FHIRVersion.NULL));
        } else {;
          res.getFhirVersion().add(parseEnumeration(array.get(i).getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
      }
    };
    if (json.has("_fhirVersion")) {
      JsonArray array = getJArray(json, "_fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFhirVersion().size())
          res.getFhirVersion().add(parseEnumeration(null, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getFhirVersion().get(i));
      }
    };
    if (json.has("dependsOn")) {
      JsonArray array = getJArray(json, "dependsOn");
      for (int i = 0; i < array.size(); i++) {
        res.getDependsOn().add(parseImplementationGuideDependsOnComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("global")) {
      JsonArray array = getJArray(json, "global");
      for (int i = 0; i < array.size(); i++) {
        res.getGlobal().add(parseImplementationGuideGlobalComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("definition"))
      res.setDefinition(parseImplementationGuideDefinitionComponent(getJObject(json, "definition")));
    if (json.has("manifest"))
      res.setManifest(parseImplementationGuideManifestComponent(getJObject(json, "manifest")));
  }

  protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideDependsOnComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
    parseImplementationGuideDependsOnComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDependsOnComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("uri"))
      res.setUriElement(parseCanonical(json.get("uri").getAsString()));
    if (json.has("_uri"))
      parseElementProperties(getJObject(json, "_uri"), res.getUriElement());
    if (json.has("packageId"))
      res.setPackageIdElement(parseId(json.get("packageId").getAsString()));
    if (json.has("_packageId"))
      parseElementProperties(getJObject(json, "_packageId"), res.getPackageIdElement());
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    if (json.has("reason"))
      res.setReasonElement(parseMarkdown(json.get("reason").getAsString()));
    if (json.has("_reason"))
      parseElementProperties(getJObject(json, "_reason"), res.getReasonElement());
  }

  protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideGlobalComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
    parseImplementationGuideGlobalComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideGlobalComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideGlobalComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseCode(json.get("type").getAsString()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("profile"))
      res.setProfileElement(parseCanonical(json.get("profile").getAsString()));
    if (json.has("_profile"))
      parseElementProperties(getJObject(json, "_profile"), res.getProfileElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideDefinitionComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
    parseImplementationGuideDefinitionComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("grouping")) {
      JsonArray array = getJArray(json, "grouping");
      for (int i = 0; i < array.size(); i++) {
        res.getGrouping().add(parseImplementationGuideDefinitionGroupingComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("resource")) {
      JsonArray array = getJArray(json, "resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideDefinitionResourceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("page"))
      res.setPage(parseImplementationGuideDefinitionPageComponent(getJObject(json, "page")));
    if (json.has("parameter")) {
      JsonArray array = getJArray(json, "parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseImplementationGuideDefinitionParameterComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("template")) {
      JsonArray array = getJArray(json, "template");
      for (int i = 0; i < array.size(); i++) {
        res.getTemplate().add(parseImplementationGuideDefinitionTemplateComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuideDefinitionGroupingComponent parseImplementationGuideDefinitionGroupingComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
    parseImplementationGuideDefinitionGroupingComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionGroupingComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideDefinitionResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
    parseImplementationGuideDefinitionResourceComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionResourceComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    if (json.has("fhirVersion")) {
      JsonArray array = getJArray(json, "fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getFhirVersion().add(new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory(), Enumerations.FHIRVersion.NULL));
        } else {;
          res.getFhirVersion().add(parseEnumeration(array.get(i).getAsString(), Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        }
      }
    };
    if (json.has("_fhirVersion")) {
      JsonArray array = getJArray(json, "_fhirVersion");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getFhirVersion().size())
          res.getFhirVersion().add(parseEnumeration(null, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getFhirVersion().get(i));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("isExample"))
      res.setIsExampleElement(parseBoolean(json.get("isExample").getAsBoolean()));
    if (json.has("_isExample"))
      parseElementProperties(getJObject(json, "_isExample"), res.getIsExampleElement());
    if (json.has("profile")) {
      JsonArray array = getJArray(json, "profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {;
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = getJArray(json, "_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProfile().get(i));
      }
    };
    if (json.has("groupingId"))
      res.setGroupingIdElement(parseId(json.get("groupingId").getAsString()));
    if (json.has("_groupingId"))
      parseElementProperties(getJObject(json, "_groupingId"), res.getGroupingIdElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideDefinitionPageComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
    parseImplementationGuideDefinitionPageComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionPageComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType source = parseType("source", json);
    if (source != null)
      res.setSource(source);
    if (json.has("name"))
      res.setNameElement(parseUrl(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("generation"))
      res.setGenerationElement(parseEnumeration(json.get("generation").getAsString(), ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
    if (json.has("_generation"))
      parseElementProperties(getJObject(json, "_generation"), res.getGenerationElement());
    if (json.has("page")) {
      JsonArray array = getJArray(json, "page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideDefinitionPageComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideDefinitionParameterComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
    parseImplementationGuideDefinitionParameterComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionParameterComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCoding(getJObject(json, "code")));
    if (json.has("value"))
      res.setValueElement(parseString(json.get("value").getAsString()));
    if (json.has("_value"))
      parseElementProperties(getJObject(json, "_value"), res.getValueElement());
  }

  protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideDefinitionTemplateComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
    parseImplementationGuideDefinitionTemplateComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideDefinitionTemplateComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCodeElement(parseCode(json.get("code").getAsString()));
    if (json.has("_code"))
      parseElementProperties(getJObject(json, "_code"), res.getCodeElement());
    if (json.has("source"))
      res.setSourceElement(parseString(json.get("source").getAsString()));
    if (json.has("_source"))
      parseElementProperties(getJObject(json, "_source"), res.getSourceElement());
    if (json.has("scope"))
      res.setScopeElement(parseString(json.get("scope").getAsString()));
    if (json.has("_scope"))
      parseElementProperties(getJObject(json, "_scope"), res.getScopeElement());
  }

  protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideManifestComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
    parseImplementationGuideManifestComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideManifestComponentProperties(JsonObject json, ImplementationGuide.ImplementationGuideManifestComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("rendering"))
      res.setRenderingElement(parseUrl(json.get("rendering").getAsString()));
    if (json.has("_rendering"))
      parseElementProperties(getJObject(json, "_rendering"), res.getRenderingElement());
    if (json.has("resource")) {
      JsonArray array = getJArray(json, "resource");
      for (int i = 0; i < array.size(); i++) {
        res.getResource().add(parseImplementationGuideManifestResourceComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("page")) {
      JsonArray array = getJArray(json, "page");
      for (int i = 0; i < array.size(); i++) {
        res.getPage().add(parseImplementationGuideManifestPageComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("image")) {
      JsonArray array = getJArray(json, "image");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getImage().add(new StringType());
        } else {;
          res.getImage().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_image")) {
      JsonArray array = getJArray(json, "_image");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getImage().size())
          res.getImage().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getImage().get(i));
      }
    };
    if (json.has("other")) {
      JsonArray array = getJArray(json, "other");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getOther().add(new StringType());
        } else {;
          res.getOther().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_other")) {
      JsonArray array = getJArray(json, "_other");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getOther().size())
          res.getOther().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getOther().get(i));
      }
    };
  }

  protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
    parseImplementationGuideManifestResourceComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideManifestResourceComponentProperties(JsonObject json, ImplementationGuide.ManifestResourceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("reference"))
      res.setReference(parseReference(getJObject(json, "reference")));
    if (json.has("isExample"))
      res.setIsExampleElement(parseBoolean(json.get("isExample").getAsBoolean()));
    if (json.has("_isExample"))
      parseElementProperties(getJObject(json, "_isExample"), res.getIsExampleElement());
    if (json.has("profile")) {
      JsonArray array = getJArray(json, "profile");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getProfile().add(new CanonicalType());
        } else {;
          res.getProfile().add(parseCanonical(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_profile")) {
      JsonArray array = getJArray(json, "_profile");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getProfile().size())
          res.getProfile().add(parseCanonical(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getProfile().get(i));
      }
    };
    if (json.has("relativePath"))
      res.setRelativePathElement(parseUrl(json.get("relativePath").getAsString()));
    if (json.has("_relativePath"))
      parseElementProperties(getJObject(json, "_relativePath"), res.getRelativePathElement());
  }

  protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(JsonObject json) throws IOException, FHIRFormatError {
    ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
    parseImplementationGuideManifestPageComponentProperties(json, res);
    return res;
  }

  protected void parseImplementationGuideManifestPageComponentProperties(JsonObject json, ImplementationGuide.ManifestPageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("anchor")) {
      JsonArray array = getJArray(json, "anchor");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAnchor().add(new StringType());
        } else {;
          res.getAnchor().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_anchor")) {
      JsonArray array = getJArray(json, "_anchor");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAnchor().size())
          res.getAnchor().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getAnchor().get(i));
      }
    };
  }

  protected Ingredient parseIngredient(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient res = new Ingredient();
    parseIngredientProperties(json, res);
    return res;
  }

  protected void parseIngredientProperties(JsonObject json, Ingredient res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier"))
      res.setIdentifier(parseIdentifier(getJObject(json, "identifier")));
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("for")) {
      JsonArray array = getJArray(json, "for");
      for (int i = 0; i < array.size(); i++) {
        res.getFor().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("function")) {
      JsonArray array = getJArray(json, "function");
      for (int i = 0; i < array.size(); i++) {
        res.getFunction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("group"))
      res.setGroup(parseCodeableConcept(getJObject(json, "group")));
    if (json.has("allergenicIndicator"))
      res.setAllergenicIndicatorElement(parseBoolean(json.get("allergenicIndicator").getAsBoolean()));
    if (json.has("_allergenicIndicator"))
      parseElementProperties(getJObject(json, "_allergenicIndicator"), res.getAllergenicIndicatorElement());
    if (json.has("comment"))
      res.setCommentElement(parseMarkdown(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
    if (json.has("manufacturer")) {
      JsonArray array = getJArray(json, "manufacturer");
      for (int i = 0; i < array.size(); i++) {
        res.getManufacturer().add(parseIngredientManufacturerComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("substance"))
      res.setSubstance(parseIngredientSubstanceComponent(getJObject(json, "substance")));
  }

  protected Ingredient.IngredientManufacturerComponent parseIngredientManufacturerComponent(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient.IngredientManufacturerComponent res = new Ingredient.IngredientManufacturerComponent();
    parseIngredientManufacturerComponentProperties(json, res);
    return res;
  }

  protected void parseIngredientManufacturerComponentProperties(JsonObject json, Ingredient.IngredientManufacturerComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRoleElement(parseEnumeration(json.get("role").getAsString(), Ingredient.IngredientManufacturerRole.NULL, new Ingredient.IngredientManufacturerRoleEnumFactory()));
    if (json.has("_role"))
      parseElementProperties(getJObject(json, "_role"), res.getRoleElement());
    if (json.has("manufacturer"))
      res.setManufacturer(parseReference(getJObject(json, "manufacturer")));
  }

  protected Ingredient.IngredientSubstanceComponent parseIngredientSubstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient.IngredientSubstanceComponent res = new Ingredient.IngredientSubstanceComponent();
    parseIngredientSubstanceComponentProperties(json, res);
    return res;
  }

  protected void parseIngredientSubstanceComponentProperties(JsonObject json, Ingredient.IngredientSubstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("code"))
      res.setCode(parseCodeableReference(getJObject(json, "code")));
    if (json.has("strength")) {
      JsonArray array = getJArray(json, "strength");
      for (int i = 0; i < array.size(); i++) {
        res.getStrength().add(parseIngredientSubstanceStrengthComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Ingredient.IngredientSubstanceStrengthComponent parseIngredientSubstanceStrengthComponent(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient.IngredientSubstanceStrengthComponent res = new Ingredient.IngredientSubstanceStrengthComponent();
    parseIngredientSubstanceStrengthComponentProperties(json, res);
    return res;
  }

  protected void parseIngredientSubstanceStrengthComponentProperties(JsonObject json, Ingredient.IngredientSubstanceStrengthComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    DataType presentation = parseType("presentation", json);
    if (presentation != null)
      res.setPresentation(presentation);
    if (json.has("textPresentation"))
      res.setTextPresentationElement(parseString(json.get("textPresentation").getAsString()));
    if (json.has("_textPresentation"))
      parseElementProperties(getJObject(json, "_textPresentation"), res.getTextPresentationElement());
    DataType concentration = parseType("concentration", json);
    if (concentration != null)
      res.setConcentration(concentration);
    if (json.has("textConcentration"))
      res.setTextConcentrationElement(parseString(json.get("textConcentration").getAsString()));
    if (json.has("_textConcentration"))
      parseElementProperties(getJObject(json, "_textConcentration"), res.getTextConcentrationElement());
    if (json.has("basis"))
      res.setBasis(parseCodeableConcept(getJObject(json, "basis")));
    if (json.has("measurementPoint"))
      res.setMeasurementPointElement(parseString(json.get("measurementPoint").getAsString()));
    if (json.has("_measurementPoint"))
      parseElementProperties(getJObject(json, "_measurementPoint"), res.getMeasurementPointElement());
    if (json.has("country")) {
      JsonArray array = getJArray(json, "country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("referenceStrength")) {
      JsonArray array = getJArray(json, "referenceStrength");
      for (int i = 0; i < array.size(); i++) {
        res.getReferenceStrength().add(parseIngredientSubstanceStrengthReferenceStrengthComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent parseIngredientSubstanceStrengthReferenceStrengthComponent(JsonObject json) throws IOException, FHIRFormatError {
    Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent res = new Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent();
    parseIngredientSubstanceStrengthReferenceStrengthComponentProperties(json, res);
    return res;
  }

  protected void parseIngredientSubstanceStrengthReferenceStrengthComponentProperties(JsonObject json, Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("substance"))
      res.setSubstance(parseCodeableReference(getJObject(json, "substance")));
    DataType strength = parseType("strength", json);
    if (strength != null)
      res.setStrength(strength);
    if (json.has("measurementPoint"))
      res.setMeasurementPointElement(parseString(json.get("measurementPoint").getAsString()));
    if (json.has("_measurementPoint"))
      parseElementProperties(getJObject(json, "_measurementPoint"), res.getMeasurementPointElement());
    if (json.has("country")) {
      JsonArray array = getJArray(json, "country");
      for (int i = 0; i < array.size(); i++) {
        res.getCountry().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InsurancePlan parseInsurancePlan(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan res = new InsurancePlan();
    parseInsurancePlanProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanProperties(JsonObject json, InsurancePlan res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("type")) {
      JsonArray array = getJArray(json, "type");
      for (int i = 0; i < array.size(); i++) {
        res.getType().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("alias")) {
      JsonArray array = getJArray(json, "alias");
      for (int i = 0; i < array.size(); i++) {
        if (array.get(i).isJsonNull()) {
          res.getAlias().add(new StringType());
        } else {;
          res.getAlias().add(parseString(array.get(i).getAsString()));
        }
      }
    };
    if (json.has("_alias")) {
      JsonArray array = getJArray(json, "_alias");
      for (int i = 0; i < array.size(); i++) {
        if (i == res.getAlias().size())
          res.getAlias().add(parseString(null));
        if (array.get(i) instanceof JsonObject) 
          parseElementProperties(getJsonObjectFromArray(array, i), res.getAlias().get(i));
      }
    };
    if (json.has("period"))
      res.setPeriod(parsePeriod(getJObject(json, "period")));
    if (json.has("ownedBy"))
      res.setOwnedBy(parseReference(getJObject(json, "ownedBy")));
    if (json.has("administeredBy"))
      res.setAdministeredBy(parseReference(getJObject(json, "administeredBy")));
    if (json.has("coverageArea")) {
      JsonArray array = getJArray(json, "coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseExtendedContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endpoint")) {
      JsonArray array = getJArray(json, "endpoint");
      for (int i = 0; i < array.size(); i++) {
        res.getEndpoint().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("network")) {
      JsonArray array = getJArray(json, "network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("coverage")) {
      JsonArray array = getJArray(json, "coverage");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverage().add(parseInsurancePlanCoverageComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("plan")) {
      JsonArray array = getJArray(json, "plan");
      for (int i = 0; i < array.size(); i++) {
        res.getPlan().add(parseInsurancePlanPlanComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InsurancePlan.InsurancePlanCoverageComponent parseInsurancePlanCoverageComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanCoverageComponent res = new InsurancePlan.InsurancePlanCoverageComponent();
    parseInsurancePlanCoverageComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanCoverageComponentProperties(JsonObject json, InsurancePlan.InsurancePlanCoverageComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("network")) {
      JsonArray array = getJArray(json, "network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("benefit")) {
      JsonArray array = getJArray(json, "benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseInsurancePlanCoverageBenefitComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InsurancePlan.CoverageBenefitComponent parseInsurancePlanCoverageBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitComponent res = new InsurancePlan.CoverageBenefitComponent();
    parseInsurancePlanCoverageBenefitComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanCoverageBenefitComponentProperties(JsonObject json, InsurancePlan.CoverageBenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("requirement"))
      res.setRequirementElement(parseString(json.get("requirement").getAsString()));
    if (json.has("_requirement"))
      parseElementProperties(getJObject(json, "_requirement"), res.getRequirementElement());
    if (json.has("limit")) {
      JsonArray array = getJArray(json, "limit");
      for (int i = 0; i < array.size(); i++) {
        res.getLimit().add(parseInsurancePlanCoverageBenefitLimitComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InsurancePlan.CoverageBenefitLimitComponent parseInsurancePlanCoverageBenefitLimitComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.CoverageBenefitLimitComponent res = new InsurancePlan.CoverageBenefitLimitComponent();
    parseInsurancePlanCoverageBenefitLimitComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanCoverageBenefitLimitComponentProperties(JsonObject json, InsurancePlan.CoverageBenefitLimitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("value"))
      res.setValue(parseQuantity(getJObject(json, "value")));
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
  }

  protected InsurancePlan.InsurancePlanPlanComponent parseInsurancePlanPlanComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanComponent res = new InsurancePlan.InsurancePlanPlanComponent();
    parseInsurancePlanPlanComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanComponentProperties(JsonObject json, InsurancePlan.InsurancePlanPlanComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("coverageArea")) {
      JsonArray array = getJArray(json, "coverageArea");
      for (int i = 0; i < array.size(); i++) {
        res.getCoverageArea().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("network")) {
      JsonArray array = getJArray(json, "network");
      for (int i = 0; i < array.size(); i++) {
        res.getNetwork().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("generalCost")) {
      JsonArray array = getJArray(json, "generalCost");
      for (int i = 0; i < array.size(); i++) {
        res.getGeneralCost().add(parseInsurancePlanPlanGeneralCostComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("specificCost")) {
      JsonArray array = getJArray(json, "specificCost");
      for (int i = 0; i < array.size(); i++) {
        res.getSpecificCost().add(parseInsurancePlanPlanSpecificCostComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InsurancePlan.InsurancePlanPlanGeneralCostComponent parseInsurancePlanPlanGeneralCostComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanGeneralCostComponent res = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
    parseInsurancePlanPlanGeneralCostComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanGeneralCostComponentProperties(JsonObject json, InsurancePlan.InsurancePlanPlanGeneralCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("groupSize"))
      res.setGroupSizeElement(parsePositiveInt(json.get("groupSize").getAsString()));
    if (json.has("_groupSize"))
      parseElementProperties(getJObject(json, "_groupSize"), res.getGroupSizeElement());
    if (json.has("cost"))
      res.setCost(parseMoney(getJObject(json, "cost")));
    if (json.has("comment"))
      res.setCommentElement(parseString(json.get("comment").getAsString()));
    if (json.has("_comment"))
      parseElementProperties(getJObject(json, "_comment"), res.getCommentElement());
  }

  protected InsurancePlan.InsurancePlanPlanSpecificCostComponent parseInsurancePlanPlanSpecificCostComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.InsurancePlanPlanSpecificCostComponent res = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
    parseInsurancePlanPlanSpecificCostComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanSpecificCostComponentProperties(JsonObject json, InsurancePlan.InsurancePlanPlanSpecificCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("benefit")) {
      JsonArray array = getJArray(json, "benefit");
      for (int i = 0; i < array.size(); i++) {
        res.getBenefit().add(parseInsurancePlanPlanBenefitComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InsurancePlan.PlanBenefitComponent parseInsurancePlanPlanBenefitComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitComponent res = new InsurancePlan.PlanBenefitComponent();
    parseInsurancePlanPlanBenefitComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanBenefitComponentProperties(JsonObject json, InsurancePlan.PlanBenefitComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("cost")) {
      JsonArray array = getJArray(json, "cost");
      for (int i = 0; i < array.size(); i++) {
        res.getCost().add(parseInsurancePlanPlanBenefitCostComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InsurancePlan.PlanBenefitCostComponent parseInsurancePlanPlanBenefitCostComponent(JsonObject json) throws IOException, FHIRFormatError {
    InsurancePlan.PlanBenefitCostComponent res = new InsurancePlan.PlanBenefitCostComponent();
    parseInsurancePlanPlanBenefitCostComponentProperties(json, res);
    return res;
  }

  protected void parseInsurancePlanPlanBenefitCostComponentProperties(JsonObject json, InsurancePlan.PlanBenefitCostComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("applicability"))
      res.setApplicability(parseCodeableConcept(getJObject(json, "applicability")));
    if (json.has("qualifiers")) {
      JsonArray array = getJArray(json, "qualifiers");
      for (int i = 0; i < array.size(); i++) {
        res.getQualifiers().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("value"))
      res.setValue(parseQuantity(getJObject(json, "value")));
  }

  protected InventoryItem parseInventoryItem(JsonObject json) throws IOException, FHIRFormatError {
    InventoryItem res = new InventoryItem();
    parseInventoryItemProperties(json, res);
    return res;
  }

  protected void parseInventoryItemProperties(JsonObject json, InventoryItem res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), InventoryItem.InventoryItemStatusCodes.NULL, new InventoryItem.InventoryItemStatusCodesEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("category")) {
      JsonArray array = getJArray(json, "category");
      for (int i = 0; i < array.size(); i++) {
        res.getCategory().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("code")) {
      JsonArray array = getJArray(json, "code");
      for (int i = 0; i < array.size(); i++) {
        res.getCode().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("name")) {
      JsonArray array = getJArray(json, "name");
      for (int i = 0; i < array.size(); i++) {
        res.getName().add(parseInventoryItemNameComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("responsibleOrganization")) {
      JsonArray array = getJArray(json, "responsibleOrganization");
      for (int i = 0; i < array.size(); i++) {
        res.getResponsibleOrganization().add(parseInventoryItemResponsibleOrganizationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescription(parseInventoryItemDescriptionComponent(getJObject(json, "description")));
    if (json.has("inventoryStatus")) {
      JsonArray array = getJArray(json, "inventoryStatus");
      for (int i = 0; i < array.size(); i++) {
        res.getInventoryStatus().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("baseUnit"))
      res.setBaseUnit(parseCodeableConcept(getJObject(json, "baseUnit")));
    if (json.has("netContent"))
      res.setNetContent(parseQuantity(getJObject(json, "netContent")));
    if (json.has("association")) {
      JsonArray array = getJArray(json, "association");
      for (int i = 0; i < array.size(); i++) {
        res.getAssociation().add(parseInventoryItemAssociationComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("characteristic")) {
      JsonArray array = getJArray(json, "characteristic");
      for (int i = 0; i < array.size(); i++) {
        res.getCharacteristic().add(parseInventoryItemCharacteristicComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("instance"))
      res.setInstance(parseInventoryItemInstanceComponent(getJObject(json, "instance")));
    if (json.has("productReference"))
      res.setProductReference(parseReference(getJObject(json, "productReference")));
  }

  protected InventoryItem.InventoryItemNameComponent parseInventoryItemNameComponent(JsonObject json) throws IOException, FHIRFormatError {
    InventoryItem.InventoryItemNameComponent res = new InventoryItem.InventoryItemNameComponent();
    parseInventoryItemNameComponentProperties(json, res);
    return res;
  }

  protected void parseInventoryItemNameComponentProperties(JsonObject json, InventoryItem.InventoryItemNameComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("nameType"))
      res.setNameType(parseCoding(getJObject(json, "nameType")));
    if (json.has("language"))
      res.setLanguageElement(parseEnumeration(json.get("language").getAsString(), Enumerations.CommonLanguages.NULL, new Enumerations.CommonLanguagesEnumFactory()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
  }

  protected InventoryItem.InventoryItemResponsibleOrganizationComponent parseInventoryItemResponsibleOrganizationComponent(JsonObject json) throws IOException, FHIRFormatError {
    InventoryItem.InventoryItemResponsibleOrganizationComponent res = new InventoryItem.InventoryItemResponsibleOrganizationComponent();
    parseInventoryItemResponsibleOrganizationComponentProperties(json, res);
    return res;
  }

  protected void parseInventoryItemResponsibleOrganizationComponentProperties(JsonObject json, InventoryItem.InventoryItemResponsibleOrganizationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("organization"))
      res.setOrganization(parseReference(getJObject(json, "organization")));
  }

  protected InventoryItem.InventoryItemDescriptionComponent parseInventoryItemDescriptionComponent(JsonObject json) throws IOException, FHIRFormatError {
    InventoryItem.InventoryItemDescriptionComponent res = new InventoryItem.InventoryItemDescriptionComponent();
    parseInventoryItemDescriptionComponentProperties(json, res);
    return res;
  }

  protected void parseInventoryItemDescriptionComponentProperties(JsonObject json, InventoryItem.InventoryItemDescriptionComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("language"))
      res.setLanguageElement(parseEnumeration(json.get("language").getAsString(), Enumerations.CommonLanguages.NULL, new Enumerations.CommonLanguagesEnumFactory()));
    if (json.has("_language"))
      parseElementProperties(getJObject(json, "_language"), res.getLanguageElement());
    if (json.has("description"))
      res.setDescriptionElement(parseString(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
  }

  protected InventoryItem.InventoryItemAssociationComponent parseInventoryItemAssociationComponent(JsonObject json) throws IOException, FHIRFormatError {
    InventoryItem.InventoryItemAssociationComponent res = new InventoryItem.InventoryItemAssociationComponent();
    parseInventoryItemAssociationComponentProperties(json, res);
    return res;
  }

  protected void parseInventoryItemAssociationComponentProperties(JsonObject json, InventoryItem.InventoryItemAssociationComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("associationType"))
      res.setAssociationType(parseCodeableConcept(getJObject(json, "associationType")));
    if (json.has("relatedItem"))
      res.setRelatedItem(parseReference(getJObject(json, "relatedItem")));
    if (json.has("quantity"))
      res.setQuantity(parseRatio(getJObject(json, "quantity")));
  }

  protected InventoryItem.InventoryItemCharacteristicComponent parseInventoryItemCharacteristicComponent(JsonObject json) throws IOException, FHIRFormatError {
    InventoryItem.InventoryItemCharacteristicComponent res = new InventoryItem.InventoryItemCharacteristicComponent();
    parseInventoryItemCharacteristicComponentProperties(json, res);
    return res;
  }

  protected void parseInventoryItemCharacteristicComponentProperties(JsonObject json, InventoryItem.InventoryItemCharacteristicComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("characteristicType"))
      res.setCharacteristicType(parseCodeableConcept(getJObject(json, "characteristicType")));
    DataType value = parseType("value", json);
    if (value != null)
      res.setValue(value);
  }

  protected InventoryItem.InventoryItemInstanceComponent parseInventoryItemInstanceComponent(JsonObject json) throws IOException, FHIRFormatError {
    InventoryItem.InventoryItemInstanceComponent res = new InventoryItem.InventoryItemInstanceComponent();
    parseInventoryItemInstanceComponentProperties(json, res);
    return res;
  }

  protected void parseInventoryItemInstanceComponentProperties(JsonObject json, InventoryItem.InventoryItemInstanceComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("lotNumber"))
      res.setLotNumberElement(parseString(json.get("lotNumber").getAsString()));
    if (json.has("_lotNumber"))
      parseElementProperties(getJObject(json, "_lotNumber"), res.getLotNumberElement());
    if (json.has("expiry"))
      res.setExpiryElement(parseDateTime(json.get("expiry").getAsString()));
    if (json.has("_expiry"))
      parseElementProperties(getJObject(json, "_expiry"), res.getExpiryElement());
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
  }

  protected InventoryReport parseInventoryReport(JsonObject json) throws IOException, FHIRFormatError {
    InventoryReport res = new InventoryReport();
    parseInventoryReportProperties(json, res);
    return res;
  }

  protected void parseInventoryReportProperties(JsonObject json, InventoryReport res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), InventoryReport.InventoryReportStatus.NULL, new InventoryReport.InventoryReportStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("countType"))
      res.setCountTypeElement(parseEnumeration(json.get("countType").getAsString(), InventoryReport.InventoryCountType.NULL, new InventoryReport.InventoryCountTypeEnumFactory()));
    if (json.has("_countType"))
      parseElementProperties(getJObject(json, "_countType"), res.getCountTypeElement());
    if (json.has("operationType"))
      res.setOperationType(parseCodeableConcept(getJObject(json, "operationType")));
    if (json.has("operationTypeReason"))
      res.setOperationTypeReason(parseCodeableConcept(getJObject(json, "operationTypeReason")));
    if (json.has("reportedDateTime"))
      res.setReportedDateTimeElement(parseDateTime(json.get("reportedDateTime").getAsString()));
    if (json.has("_reportedDateTime"))
      parseElementProperties(getJObject(json, "_reportedDateTime"), res.getReportedDateTimeElement());
    if (json.has("reporter"))
      res.setReporter(parseReference(getJObject(json, "reporter")));
    if (json.has("reportingPeriod"))
      res.setReportingPeriod(parsePeriod(getJObject(json, "reportingPeriod")));
    if (json.has("inventoryListing")) {
      JsonArray array = getJArray(json, "inventoryListing");
      for (int i = 0; i < array.size(); i++) {
        res.getInventoryListing().add(parseInventoryReportInventoryListingComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InventoryReport.InventoryReportInventoryListingComponent parseInventoryReportInventoryListingComponent(JsonObject json) throws IOException, FHIRFormatError {
    InventoryReport.InventoryReportInventoryListingComponent res = new InventoryReport.InventoryReportInventoryListingComponent();
    parseInventoryReportInventoryListingComponentProperties(json, res);
    return res;
  }

  protected void parseInventoryReportInventoryListingComponentProperties(JsonObject json, InventoryReport.InventoryReportInventoryListingComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("location"))
      res.setLocation(parseReference(getJObject(json, "location")));
    if (json.has("itemStatus"))
      res.setItemStatus(parseCodeableConcept(getJObject(json, "itemStatus")));
    if (json.has("countingDateTime"))
      res.setCountingDateTimeElement(parseDateTime(json.get("countingDateTime").getAsString()));
    if (json.has("_countingDateTime"))
      parseElementProperties(getJObject(json, "_countingDateTime"), res.getCountingDateTimeElement());
    if (json.has("item")) {
      JsonArray array = getJArray(json, "item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseInventoryReportInventoryListingItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected InventoryReport.InventoryReportInventoryListingItemComponent parseInventoryReportInventoryListingItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    InventoryReport.InventoryReportInventoryListingItemComponent res = new InventoryReport.InventoryReportInventoryListingItemComponent();
    parseInventoryReportInventoryListingItemComponentProperties(json, res);
    return res;
  }

  protected void parseInventoryReportInventoryListingItemComponentProperties(JsonObject json, InventoryReport.InventoryReportInventoryListingItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("category"))
      res.setCategory(parseCodeableConcept(getJObject(json, "category")));
    if (json.has("quantity"))
      res.setQuantity(parseQuantity(getJObject(json, "quantity")));
    if (json.has("item"))
      res.setItem(parseCodeableReference(getJObject(json, "item")));
  }

  protected Invoice parseInvoice(JsonObject json) throws IOException, FHIRFormatError {
    Invoice res = new Invoice();
    parseInvoiceProperties(json, res);
    return res;
  }

  protected void parseInvoiceProperties(JsonObject json, Invoice res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Invoice.InvoiceStatus.NULL, new Invoice.InvoiceStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("cancelledReason"))
      res.setCancelledReasonElement(parseString(json.get("cancelledReason").getAsString()));
    if (json.has("_cancelledReason"))
      parseElementProperties(getJObject(json, "_cancelledReason"), res.getCancelledReasonElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    if (json.has("subject"))
      res.setSubject(parseReference(getJObject(json, "subject")));
    if (json.has("recipient"))
      res.setRecipient(parseReference(getJObject(json, "recipient")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("creation"))
      res.setCreationElement(parseDateTime(json.get("creation").getAsString()));
    if (json.has("_creation"))
      parseElementProperties(getJObject(json, "_creation"), res.getCreationElement());
    DataType period = parseType("period", json);
    if (period != null)
      res.setPeriod(period);
    if (json.has("participant")) {
      JsonArray array = getJArray(json, "participant");
      for (int i = 0; i < array.size(); i++) {
        res.getParticipant().add(parseInvoiceParticipantComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("issuer"))
      res.setIssuer(parseReference(getJObject(json, "issuer")));
    if (json.has("account"))
      res.setAccount(parseReference(getJObject(json, "account")));
    if (json.has("lineItem")) {
      JsonArray array = getJArray(json, "lineItem");
      for (int i = 0; i < array.size(); i++) {
        res.getLineItem().add(parseInvoiceLineItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("totalPriceComponent")) {
      JsonArray array = getJArray(json, "totalPriceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getTotalPriceComponent().add(parseMonetaryComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("totalNet"))
      res.setTotalNet(parseMoney(getJObject(json, "totalNet")));
    if (json.has("totalGross"))
      res.setTotalGross(parseMoney(getJObject(json, "totalGross")));
    if (json.has("paymentTerms"))
      res.setPaymentTermsElement(parseMarkdown(json.get("paymentTerms").getAsString()));
    if (json.has("_paymentTerms"))
      parseElementProperties(getJObject(json, "_paymentTerms"), res.getPaymentTermsElement());
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Invoice.InvoiceParticipantComponent parseInvoiceParticipantComponent(JsonObject json) throws IOException, FHIRFormatError {
    Invoice.InvoiceParticipantComponent res = new Invoice.InvoiceParticipantComponent();
    parseInvoiceParticipantComponentProperties(json, res);
    return res;
  }

  protected void parseInvoiceParticipantComponentProperties(JsonObject json, Invoice.InvoiceParticipantComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("role"))
      res.setRole(parseCodeableConcept(getJObject(json, "role")));
    if (json.has("actor"))
      res.setActor(parseReference(getJObject(json, "actor")));
  }

  protected Invoice.InvoiceLineItemComponent parseInvoiceLineItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    Invoice.InvoiceLineItemComponent res = new Invoice.InvoiceLineItemComponent();
    parseInvoiceLineItemComponentProperties(json, res);
    return res;
  }

  protected void parseInvoiceLineItemComponentProperties(JsonObject json, Invoice.InvoiceLineItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("sequence"))
      res.setSequenceElement(parsePositiveInt(json.get("sequence").getAsString()));
    if (json.has("_sequence"))
      parseElementProperties(getJObject(json, "_sequence"), res.getSequenceElement());
    DataType serviced = parseType("serviced", json);
    if (serviced != null)
      res.setServiced(serviced);
    DataType chargeItem = parseType("chargeItem", json);
    if (chargeItem != null)
      res.setChargeItem(chargeItem);
    if (json.has("priceComponent")) {
      JsonArray array = getJArray(json, "priceComponent");
      for (int i = 0; i < array.size(); i++) {
        res.getPriceComponent().add(parseMonetaryComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Library parseLibrary(JsonObject json) throws IOException, FHIRFormatError {
    Library res = new Library();
    parseLibraryProperties(json, res);
    return res;
  }

  protected void parseLibraryProperties(JsonObject json, Library res) throws IOException, FHIRFormatError {
    parseMetadataResourceProperties(json, res);
    if (json.has("url"))
      res.setUrlElement(parseUri(json.get("url").getAsString()));
    if (json.has("_url"))
      parseElementProperties(getJObject(json, "_url"), res.getUrlElement());
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("version"))
      res.setVersionElement(parseString(json.get("version").getAsString()));
    if (json.has("_version"))
      parseElementProperties(getJObject(json, "_version"), res.getVersionElement());
    DataType versionAlgorithm = parseType("versionAlgorithm", json);
    if (versionAlgorithm != null)
      res.setVersionAlgorithm(versionAlgorithm);
    if (json.has("name"))
      res.setNameElement(parseString(json.get("name").getAsString()));
    if (json.has("_name"))
      parseElementProperties(getJObject(json, "_name"), res.getNameElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("subtitle"))
      res.setSubtitleElement(parseString(json.get("subtitle").getAsString()));
    if (json.has("_subtitle"))
      parseElementProperties(getJObject(json, "_subtitle"), res.getSubtitleElement());
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("experimental"))
      res.setExperimentalElement(parseBoolean(json.get("experimental").getAsBoolean()));
    if (json.has("_experimental"))
      parseElementProperties(getJObject(json, "_experimental"), res.getExperimentalElement());
    if (json.has("type"))
      res.setType(parseCodeableConcept(getJObject(json, "type")));
    DataType subject = parseType("subject", json);
    if (subject != null)
      res.setSubject(subject);
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("publisher"))
      res.setPublisherElement(parseString(json.get("publisher").getAsString()));
    if (json.has("_publisher"))
      parseElementProperties(getJObject(json, "_publisher"), res.getPublisherElement());
    if (json.has("contact")) {
      JsonArray array = getJArray(json, "contact");
      for (int i = 0; i < array.size(); i++) {
        res.getContact().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("description"))
      res.setDescriptionElement(parseMarkdown(json.get("description").getAsString()));
    if (json.has("_description"))
      parseElementProperties(getJObject(json, "_description"), res.getDescriptionElement());
    if (json.has("useContext")) {
      JsonArray array = getJArray(json, "useContext");
      for (int i = 0; i < array.size(); i++) {
        res.getUseContext().add(parseUsageContext(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("jurisdiction")) {
      JsonArray array = getJArray(json, "jurisdiction");
      for (int i = 0; i < array.size(); i++) {
        res.getJurisdiction().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("purpose"))
      res.setPurposeElement(parseMarkdown(json.get("purpose").getAsString()));
    if (json.has("_purpose"))
      parseElementProperties(getJObject(json, "_purpose"), res.getPurposeElement());
    if (json.has("usage"))
      res.setUsageElement(parseMarkdown(json.get("usage").getAsString()));
    if (json.has("_usage"))
      parseElementProperties(getJObject(json, "_usage"), res.getUsageElement());
    if (json.has("copyright"))
      res.setCopyrightElement(parseMarkdown(json.get("copyright").getAsString()));
    if (json.has("_copyright"))
      parseElementProperties(getJObject(json, "_copyright"), res.getCopyrightElement());
    if (json.has("copyrightLabel"))
      res.setCopyrightLabelElement(parseString(json.get("copyrightLabel").getAsString()));
    if (json.has("_copyrightLabel"))
      parseElementProperties(getJObject(json, "_copyrightLabel"), res.getCopyrightLabelElement());
    if (json.has("approvalDate"))
      res.setApprovalDateElement(parseDate(json.get("approvalDate").getAsString()));
    if (json.has("_approvalDate"))
      parseElementProperties(getJObject(json, "_approvalDate"), res.getApprovalDateElement());
    if (json.has("lastReviewDate"))
      res.setLastReviewDateElement(parseDate(json.get("lastReviewDate").getAsString()));
    if (json.has("_lastReviewDate"))
      parseElementProperties(getJObject(json, "_lastReviewDate"), res.getLastReviewDateElement());
    if (json.has("effectivePeriod"))
      res.setEffectivePeriod(parsePeriod(getJObject(json, "effectivePeriod")));
    if (json.has("topic")) {
      JsonArray array = getJArray(json, "topic");
      for (int i = 0; i < array.size(); i++) {
        res.getTopic().add(parseCodeableConcept(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("author")) {
      JsonArray array = getJArray(json, "author");
      for (int i = 0; i < array.size(); i++) {
        res.getAuthor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("editor")) {
      JsonArray array = getJArray(json, "editor");
      for (int i = 0; i < array.size(); i++) {
        res.getEditor().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("reviewer")) {
      JsonArray array = getJArray(json, "reviewer");
      for (int i = 0; i < array.size(); i++) {
        res.getReviewer().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("endorser")) {
      JsonArray array = getJArray(json, "endorser");
      for (int i = 0; i < array.size(); i++) {
        res.getEndorser().add(parseContactDetail(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("relatedArtifact")) {
      JsonArray array = getJArray(json, "relatedArtifact");
      for (int i = 0; i < array.size(); i++) {
        res.getRelatedArtifact().add(parseRelatedArtifact(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("parameter")) {
      JsonArray array = getJArray(json, "parameter");
      for (int i = 0; i < array.size(); i++) {
        res.getParameter().add(parseParameterDefinition(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("dataRequirement")) {
      JsonArray array = getJArray(json, "dataRequirement");
      for (int i = 0; i < array.size(); i++) {
        res.getDataRequirement().add(parseDataRequirement(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("content")) {
      JsonArray array = getJArray(json, "content");
      for (int i = 0; i < array.size(); i++) {
        res.getContent().add(parseAttachment(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Linkage parseLinkage(JsonObject json) throws IOException, FHIRFormatError {
    Linkage res = new Linkage();
    parseLinkageProperties(json, res);
    return res;
  }

  protected void parseLinkageProperties(JsonObject json, Linkage res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("active"))
      res.setActiveElement(parseBoolean(json.get("active").getAsBoolean()));
    if (json.has("_active"))
      parseElementProperties(getJObject(json, "_active"), res.getActiveElement());
    if (json.has("author"))
      res.setAuthor(parseReference(getJObject(json, "author")));
    if (json.has("item")) {
      JsonArray array = getJArray(json, "item");
      for (int i = 0; i < array.size(); i++) {
        res.getItem().add(parseLinkageItemComponent(getJsonObjectFromArray(array, i)));
      }
    };
  }

  protected Linkage.LinkageItemComponent parseLinkageItemComponent(JsonObject json) throws IOException, FHIRFormatError {
    Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
    parseLinkageItemComponentProperties(json, res);
    return res;
  }

  protected void parseLinkageItemComponentProperties(JsonObject json, Linkage.LinkageItemComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("type"))
      res.setTypeElement(parseEnumeration(json.get("type").getAsString(), Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
    if (json.has("_type"))
      parseElementProperties(getJObject(json, "_type"), res.getTypeElement());
    if (json.has("resource"))
      res.setResource(parseReference(getJObject(json, "resource")));
  }

  protected ListResource parseListResource(JsonObject json) throws IOException, FHIRFormatError {
    ListResource res = new ListResource();
    parseListResourceProperties(json, res);
    return res;
  }

  protected void parseListResourceProperties(JsonObject json, ListResource res) throws IOException, FHIRFormatError {
    parseDomainResourceProperties(json, res);
    if (json.has("identifier")) {
      JsonArray array = getJArray(json, "identifier");
      for (int i = 0; i < array.size(); i++) {
        res.getIdentifier().add(parseIdentifier(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("status"))
      res.setStatusElement(parseEnumeration(json.get("status").getAsString(), ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
    if (json.has("_status"))
      parseElementProperties(getJObject(json, "_status"), res.getStatusElement());
    if (json.has("mode"))
      res.setModeElement(parseEnumeration(json.get("mode").getAsString(), Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
    if (json.has("_mode"))
      parseElementProperties(getJObject(json, "_mode"), res.getModeElement());
    if (json.has("title"))
      res.setTitleElement(parseString(json.get("title").getAsString()));
    if (json.has("_title"))
      parseElementProperties(getJObject(json, "_title"), res.getTitleElement());
    if (json.has("code"))
      res.setCode(parseCodeableConcept(getJObject(json, "code")));
    if (json.has("subject")) {
      JsonArray array = getJArray(json, "subject");
      for (int i = 0; i < array.size(); i++) {
        res.getSubject().add(parseReference(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("encounter"))
      res.setEncounter(parseReference(getJObject(json, "encounter")));
    if (json.has("date"))
      res.setDateElement(parseDateTime(json.get("date").getAsString()));
    if (json.has("_date"))
      parseElementProperties(getJObject(json, "_date"), res.getDateElement());
    if (json.has("source"))
      res.setSource(parseReference(getJObject(json, "source")));
    if (json.has("orderedBy"))
      res.setOrderedBy(parseCodeableConcept(getJObject(json, "orderedBy")));
    if (json.has("note")) {
      JsonArray array = getJArray(json, "note");
      for (int i = 0; i < array.size(); i++) {
        res.getNote().add(parseAnnotation(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("entry")) {
      JsonArray array = getJArray(json, "entry");
      for (int i = 0; i < array.size(); i++) {
        res.getEntry().add(parseListResourceEntryComponent(getJsonObjectFromArray(array, i)));
      }
    };
    if (json.has("emptyReason"))
      res.setEmptyReason(parseCodeableConcept(getJObject(json, "emptyReason")));
  }

  protected ListResource.ListResourceEntryComponent parseListResourceEntryComponent(JsonObject json) throws IOException, FHIRFormatError {
    ListResource.ListResourceEntryComponent res = new ListResource.ListResourceEntryComponent();
    parseListResourceEntryComponentProperties(json, res);
    return res;
  }

  protected void parseListResourceEntryComponentProperties(JsonObject json, ListResource.ListResourceEntryComponent res) throws IOException, FHIRFormatError {
    parseBackboneElementProperties(json, res);
    if (json.has("flag"))
      res.setFlag(parseCodeableConcept(ge