/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonBoolean;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonNumber;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.model.JsonString;

public class JsonObject
extends JsonElement {
    private List<JsonProperty> properties = new ArrayList<JsonProperty>();
    private Map<String, JsonProperty> propMap = new HashMap<String, JsonProperty>();
    private boolean extraComma;

    @Override
    public JsonElementType type() {
        return JsonElementType.OBJECT;
    }

    public JsonObject add(String name, JsonElement value) throws JsonException {
        this.check(name != null, "Json Property Name is null");
        this.check(value != null, "Json Property Value is null");
        if (this.get(name) != null) {
            this.check(false, "Name '" + name + "' already exists (value = " + this.get(name).toString() + ")");
        }
        JsonProperty p = new JsonProperty(name, value);
        this.properties.add(p);
        this.propMap.put(name, p);
        return this;
    }

    public JsonObject addIfNotNull(String name, JsonElement value) throws JsonException {
        if (value != null) {
            this.check(name != null, "Name is null");
            if (this.get(name) != null) {
                this.check(false, "Name '" + name + "' already exists (value = " + this.get(name).toString() + ")");
            }
            JsonProperty p = new JsonProperty(name, value);
            this.properties.add(p);
            this.propMap.put(name, p);
        }
        return this;
    }

    public JsonObject addForParser(String name, JsonElement value, boolean noComma, boolean nameUnquoted, boolean valueUnquoted) throws JsonException {
        this.check(name != null, "Name is null");
        this.check(value != null, "Value is null");
        JsonProperty p = new JsonProperty(name, value);
        p.setNoComma(noComma);
        p.setUnquotedName(nameUnquoted);
        p.setUnquotedValue(valueUnquoted);
        this.properties.add(p);
        this.propMap.put(name, p);
        return this;
    }

    public JsonObject add(String name, String value) throws JsonException {
        this.check(name != null, "Name is null");
        return this.add(name, value == null ? new JsonNull() : new JsonString(value));
    }

    public JsonObject add(String name, List<String> values) throws JsonException {
        this.check(name != null, "Name is null");
        JsonArray arr = new JsonArray();
        this.add(name, arr);
        for (String v : values) {
            arr.add(v);
        }
        return this;
    }

    public JsonObject addIfNotNull(String name, String value) throws JsonException {
        this.check(name != null, "Name is null");
        if (value == null) {
            return this;
        }
        return this.add(name, value == null ? new JsonNull() : new JsonString(value));
    }

    public JsonObject add(String name, boolean value) throws JsonException {
        this.check(name != null, "Name is null");
        return this.add(name, new JsonBoolean(value));
    }

    public JsonObject add(String name, int value) throws JsonException {
        this.check(name != null, "Name is null");
        return this.add(name, new JsonNumber(value));
    }

    public JsonObject add(String name, long value) throws JsonException {
        this.check(name != null, "Name is null");
        return this.add(name, new JsonNumber(value));
    }

    public JsonObject set(String name, JsonElement value) throws JsonException {
        this.check(name != null, "Name is null");
        this.check(value != null, "Value is null");
        JsonProperty p = this.propMap.get(name);
        if (p != null) {
            p.setValue(value);
            return this;
        }
        return this.add(name, value);
    }

    public JsonObject set(String name, Instant value) throws JsonException {
        String v = value == null ? null : value.toString();
        return this.set(name, v);
    }

    public JsonObject set(String name, String value) throws JsonException {
        this.check(name != null, "Name is null");
        JsonProperty p = this.propMap.get(name);
        if (p != null) {
            p.setValue(value == null ? new JsonNull() : new JsonString(value));
            return this;
        }
        return this.add(name, value == null ? new JsonNull() : new JsonString(value));
    }

    public JsonObject set(String name, boolean value) throws JsonException {
        this.check(name != null, "Name is null");
        JsonProperty p = this.propMap.get(name);
        if (p != null) {
            p.setValue(new JsonBoolean(value));
            return this;
        }
        return this.add(name, new JsonBoolean(value));
    }

    public JsonObject set(String name, int value) throws JsonException {
        this.check(name != null, "Name is null");
        JsonProperty p = this.propMap.get(name);
        if (p != null) {
            p.setValue(new JsonNumber(value));
            return this;
        }
        return this.add(name, new JsonNumber(value));
    }

    public JsonObject set(String name, long value) throws JsonException {
        this.check(name != null, "Name is null");
        JsonProperty p = this.propMap.get(name);
        if (p != null) {
            p.setValue(new JsonNumber(value));
            return this;
        }
        return this.add(name, new JsonNumber(value));
    }

    public JsonElement get(String name) {
        if (this.propMap.containsKey(name)) {
            return this.propMap.get(name).getValue();
        }
        return null;
    }

    public boolean has(String name) {
        return this.propMap.containsKey(name);
    }

    public boolean has(String ... names) {
        for (String n : names) {
            if (!this.propMap.containsKey(n)) continue;
            return true;
        }
        return false;
    }

    public void remove(String name) {
        if (this.propMap.containsKey(name)) {
            this.propMap.remove(name);
            this.properties.removeIf(item -> name.equals(item.getName()));
        }
    }

    public List<JsonProperty> getProperties() {
        return this.properties;
    }

    public List<String> getNames() {
        return Utilities.sorted(this.propMap.keySet());
    }

    public String str(String name) {
        if (this.hasPrimitive(name)) {
            return this.get(name).asJsonPrimitive().getValue();
        }
        return null;
    }

    public boolean hasObject(String name) {
        return this.propMap.containsKey(name) && this.propMap.get(name).getValue().type() == JsonElementType.OBJECT;
    }

    public boolean hasArray(String name) {
        return this.propMap.containsKey(name) && this.propMap.get(name).getValue().type() == JsonElementType.ARRAY;
    }

    public boolean hasPrimitive(String name) {
        return this.propMap.containsKey(name) && this.propMap.get(name).getValue() instanceof JsonPrimitive;
    }

    public boolean hasString(String name) {
        return this.propMap.containsKey(name) && this.propMap.get(name).getValue().type() == JsonElementType.STRING;
    }

    public boolean hasNumber(String name) {
        return this.propMap.containsKey(name) && this.propMap.get(name).getValue().type() == JsonElementType.NUMBER;
    }

    public boolean hasBoolean(String name) {
        return this.propMap.containsKey(name) && this.propMap.get(name).getValue().type() == JsonElementType.BOOLEAN;
    }

    public boolean hasNull(String name) {
        return this.propMap.containsKey(name) && this.propMap.get(name).getValue().type() == JsonElementType.NULL;
    }

    public JsonObject getJsonObject(String name) {
        return this.hasObject(name) ? (JsonObject)this.get(name) : null;
    }

    public JsonString getJsonString(String name) {
        return this.hasString(name) ? (JsonString)this.get(name) : null;
    }

    public JsonBoolean getJsonBoolean(String name) {
        return this.hasBoolean(name) ? (JsonBoolean)this.get(name) : null;
    }

    public JsonNumber getJsonNumber(String name) {
        return this.hasNumber(name) ? (JsonNumber)this.get(name) : null;
    }

    public JsonNull getJsonNull(String name) {
        return this.hasNull(name) ? (JsonNull)this.get(name) : null;
    }

    public JsonArray getJsonArray(String name) {
        return this.hasArray(name) ? (JsonArray)this.get(name) : null;
    }

    public Integer asInteger(String name) {
        String s;
        if (this.hasNumber(name)) {
            return ((JsonNumber)this.get(name)).getInteger();
        }
        if (this.hasPrimitive(name) && Utilities.isInteger(s = this.asString(name))) {
            return Integer.parseInt(s);
        }
        return null;
    }

    public String asString(String name) {
        return this.hasPrimitive(name) ? ((JsonPrimitive)this.get(name)).getValue() : null;
    }

    public String asString(String ... names) {
        for (String n : names) {
            if (!this.hasPrimitive(n)) continue;
            return this.asString(n);
        }
        return null;
    }

    public boolean asBoolean(String name) {
        if (this.hasBoolean(name)) {
            return ((JsonBoolean)this.get(name)).isValue();
        }
        if (this.hasPrimitive(name)) {
            String s = this.asString(name);
            if ("true".equals(s)) {
                return true;
            }
            if ("false".equals(s)) {
                return false;
            }
        }
        return false;
    }

    public Instant asDate(String name) {
        String source = this.asString(name);
        if (Utilities.noString(source)) {
            return null;
        }
        OffsetDateTime odt = OffsetDateTime.parse(source);
        return odt.toInstant();
    }

    public Instant asInstant(String name) throws ParseException {
        String source = this.asString(name);
        if (Utilities.noString(source) || "null".equals(source)) {
            return null;
        }
        if (source.length() <= 10) {
            Date d = new SimpleDateFormat("yyyy-mm-dd").parse(source);
            return d.toInstant();
        }
        OffsetDateTime odt = OffsetDateTime.parse(source);
        return odt.toInstant();
    }

    public JsonObject forceObject(String name) throws JsonException {
        if (this.has(name) && !this.hasObject(name)) {
            this.remove(name);
        }
        if (!this.has(name)) {
            this.add(name, new JsonObject());
        }
        return this.getJsonObject(name);
    }

    public JsonArray forceArray(String name) throws JsonException {
        if (this.has(name) && !this.hasArray(name)) {
            this.remove(name);
        }
        if (!this.has(name)) {
            this.add(name, new JsonArray());
        }
        return this.getJsonArray(name);
    }

    public List<JsonObject> getJsonObjects(String name) {
        ArrayList<JsonObject> res = new ArrayList<JsonObject>();
        if (this.hasArray(name)) {
            res.addAll(this.getJsonArray(name).asJsonObjects());
        } else if (this.hasObject(name)) {
            res.add(this.getJsonObject(name));
        }
        return res;
    }

    public List<String> getStrings(String name) {
        ArrayList<String> res = new ArrayList<String>();
        if (this.hasArray(name)) {
            res.addAll(this.getJsonArray(name).asStrings());
        } else if (this.hasPrimitive(name)) {
            res.add(this.asString(name));
        }
        return res;
    }

    @Override
    public JsonObject deepCopy() {
        return (JsonObject)this.make().copy(this);
    }

    @Override
    protected JsonElement copy(JsonElement other) {
        JsonObject o = (JsonObject)other;
        for (JsonProperty p : o.getProperties()) {
            this.add(p.getName(), p.getValue().deepCopy());
        }
        return this;
    }

    @Override
    protected JsonElement make() {
        return new JsonObject();
    }

    public JsonObject findByStringProp(String arrName, String prop, String value) {
        for (JsonObject obj : this.getJsonObjects(arrName)) {
            if (!obj.has(prop) || !value.equals(obj.asString(prop))) continue;
            return obj;
        }
        return null;
    }

    public void merge(JsonObject source) {
        for (JsonProperty pp : source.getProperties()) {
            if (this.has(pp.getName())) {
                JsonElement te = this.get(pp.getName());
                if (te.isJsonObject() && pp.getValue().isJsonObject()) {
                    ((JsonObject)te).merge((JsonObject)pp.getValue());
                    continue;
                }
                this.set(pp.getName(), pp.getValue());
                continue;
            }
            this.add(pp.getName(), pp.getValue());
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{ ");
        boolean first = true;
        for (JsonProperty p : this.properties) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(p.toString());
        }
        b.append(" }");
        return b.toString();
    }

    public boolean isExtraComma() {
        return this.extraComma;
    }

    public void setExtraComma(boolean extraComma) {
        this.extraComma = extraComma;
    }

    public void clear() {
        this.properties.clear();
        this.propMap.clear();
    }
}

