/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n.subtag;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.utilities.i18n.subtag.ExtLangSubtag;
import org.hl7.fhir.utilities.i18n.subtag.LanguageSubtag;
import org.hl7.fhir.utilities.i18n.subtag.RegionSubtag;
import org.hl7.fhir.utilities.i18n.subtag.ScriptSubtag;
import org.hl7.fhir.utilities.i18n.subtag.VariantSubtag;

public class LanguageSubtagRegistry {
    private final Map<String, LanguageSubtag> languages = new HashMap<String, LanguageSubtag>();
    private final Map<String, ExtLangSubtag> extLangs = new HashMap<String, ExtLangSubtag>();
    private final Map<String, ScriptSubtag> scripts = new HashMap<String, ScriptSubtag>();
    private final Map<String, RegionSubtag> regions = new HashMap<String, RegionSubtag>();
    private final Map<String, VariantSubtag> variants = new HashMap<String, VariantSubtag>();

    public Set<String> getLanguageKeys() {
        return this.languages.keySet();
    }

    protected LanguageSubtag addLanguage(String key, LanguageSubtag language) {
        return this.languages.put(key, language);
    }

    public boolean containsLanguage(String key) {
        return this.languages.containsKey(key);
    }

    public LanguageSubtag getLanguage(String key) {
        return this.languages.get(key);
    }

    protected ExtLangSubtag addExtLang(String key, ExtLangSubtag extLang) {
        return this.extLangs.put(key, extLang);
    }

    public Set<String> getExtLangKeys() {
        return this.extLangs.keySet();
    }

    public boolean containsExtLang(String key) {
        return this.extLangs.containsKey(key);
    }

    public ExtLangSubtag getExtLang(String key) {
        return this.extLangs.get(key);
    }

    protected ScriptSubtag addScript(String key, ScriptSubtag script) {
        return this.scripts.put(key, script);
    }

    public Set<String> getScriptKeys() {
        return this.scripts.keySet();
    }

    public boolean containsScript(String key) {
        return this.scripts.containsKey(key);
    }

    public ScriptSubtag getScript(String key) {
        return this.scripts.get(key);
    }

    protected RegionSubtag addRegion(String key, RegionSubtag region) {
        return this.regions.put(key, region);
    }

    public Set<String> getRegionKeys() {
        return this.regions.keySet();
    }

    public boolean containsRegion(String key) {
        return this.regions.containsKey(key);
    }

    public RegionSubtag getRegion(String key) {
        return this.regions.get(key);
    }

    protected VariantSubtag addVariant(String key, VariantSubtag variant) {
        return this.variants.put(key, variant);
    }

    public Set<String> getVariantKeys() {
        return this.variants.keySet();
    }

    public boolean containsVariant(String key) {
        return this.variants.containsKey(key);
    }

    public VariantSubtag getVariant(String key) {
        return this.variants.get(key);
    }

    public boolean hasLanguage(String subTag) {
        return this.languages.containsKey(subTag);
    }

    public boolean hasExtLanguage(String subTag) {
        return this.extLangs.containsKey(subTag);
    }

    public boolean hasScript(String subTag) {
        return this.scripts.containsKey(subTag);
    }

    public boolean hasRegion(String subTag) {
        return this.regions.containsKey(subTag);
    }

    public boolean hasVariant(String subTag) {
        return this.variants.containsKey(subTag);
    }
}

