/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.utilities.tests.TestConfig;

public class BaseTestingUtilities {
    public static boolean silent;

    public static String loadTestResource(String ... paths) throws IOException {
        String contents;
        String dir = TestConfig.getInstance().getFhirTestCasesDirectory();
        if (dir == null && FhirSettings.hasFhirTestCasesPath()) {
            dir = FhirSettings.getFhirTestCasesPath();
        }
        if (dir != null && ManagedFileAccess.csfile(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return TextFile.fileToString(ManagedFileAccess.csfile(n));
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        try (InputStream inputStream = BaseTestingUtilities.class.getResourceAsStream(classpath);){
            if (inputStream == null) {
                throw new IOException("Can't find file on classpath: " + classpath);
            }
            contents = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        return contents;
    }

    public static InputStream loadTestResourceStream(String ... paths) throws IOException {
        String dir = TestConfig.getInstance().getFhirTestCasesDirectory();
        if (dir == null && FhirSettings.hasFhirTestCasesPath()) {
            dir = FhirSettings.getFhirTestCasesPath();
        }
        if (dir != null && ManagedFileAccess.file(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return ManagedFileAccess.inStream(n);
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        InputStream s = BaseTestingUtilities.class.getResourceAsStream(classpath);
        if (s == null) {
            throw new Error("unable to find resource " + classpath);
        }
        return s;
    }

    public static byte[] loadTestResourceBytes(String ... paths) throws IOException {
        String dir = TestConfig.getInstance().getFhirTestCasesDirectory();
        if (dir == null && FhirSettings.hasFhirTestCasesPath()) {
            dir = FhirSettings.getFhirTestCasesPath();
        }
        if (dir != null && ManagedFileAccess.file(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return TextFile.fileToBytes(n);
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        InputStream s = BaseTestingUtilities.class.getResourceAsStream(classpath);
        if (s == null) {
            throw new Error("unable to find resource " + classpath);
        }
        return TextFile.streamToBytes(s);
    }

    public static boolean findTestResource(String ... paths) throws IOException {
        String dir = TestConfig.getInstance().getFhirTestCasesDirectory();
        if (dir == null && FhirSettings.hasFhirTestCasesPath()) {
            dir = FhirSettings.getFhirTestCasesPath();
        }
        if (dir != null && ManagedFileAccess.file(dir).exists()) {
            String n = Utilities.path(dir, Utilities.path(paths));
            return ManagedFileAccess.file(n).exists();
        }
        String classpath = "/org/hl7/fhir/testcases/" + Utilities.pathURL(paths);
        try {
            InputStream inputStream = BaseTestingUtilities.class.getResourceAsStream(classpath);
            return inputStream != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String tempFile(String folder, String name) throws IOException {
        String tmp = BaseTestingUtilities.tempFolder(folder);
        return Utilities.path(tmp, name);
    }

    public static String tempFolder(String name) throws IOException {
        String path = Utilities.path(FhirSettings.hasTempPath() ? FhirSettings.getTempPath() : "[tmp]", name);
        Utilities.createDirectory(path);
        return path;
    }

    public static void setFhirTestCasesDirectory(String s) {
    }

    public static void createParentDirIfNotExists(Path target) throws IOException {
        Path parent = target.getParent();
        if (!ManagedFileAccess.fromPath(parent).exists()) {
            ManagedFileAccess.fromPath(parent).mkdirs();
        }
    }
}

