/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.tasks;

import java.io.IOException;
import java.io.PrintStream;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.services.ComparisonService;
import org.hl7.fhir.validation.cli.services.ValidationService;
import org.hl7.fhir.validation.cli.tasks.ValidationEngineTask;
import org.hl7.fhir.validation.cli.utils.Display;
import org.hl7.fhir.validation.cli.utils.Params;

public class CompareTask
extends ValidationEngineTask {
    @Override
    public String getName() {
        return "compare";
    }

    @Override
    public String getDisplayName() {
        return "Comparing Profiles";
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean shouldExecuteTask(CliContext cliContext, String[] args) {
        return Params.hasParam(args, "-compare");
    }

    @Override
    public void printHelp(PrintStream out) {
        Display.displayHelpDetails(out, "help/compare.txt");
    }

    @Override
    public void executeTask(ValidationService validationService, ValidationEngine validationEngine, CliContext cliContext, String[] args, TimeTracker tt, TimeTracker.Session tts) throws Exception {
        Display.printCliParamsAndInfo(args);
        if (!this.destinationDirectoryValid(Params.getParam(args, "-dest"))) {
            return;
        }
        if (cliContext.getSv() == null) {
            cliContext.setSv(validationService.determineVersion(cliContext));
        }
        String v = VersionUtilities.getCurrentVersion((String)cliContext.getSv());
        String definitions = VersionUtilities.packageForVersion((String)v) + "#" + v;
        ValidationEngine validator = validationService.initializeValidator(cliContext, definitions, tt);
        validator.loadPackage("hl7.fhir.pubpack", null);
        ComparisonService.doLeftRightComparison(args, Params.getParam(args, "-dest"), validator);
    }

    private boolean destinationDirectoryValid(String dest) throws IOException {
        if (dest == null) {
            System.out.println("no -dest parameter provided");
            return false;
        }
        if (!ManagedFileAccess.file((String)dest).isDirectory()) {
            System.out.println("Specified destination (-dest parameter) is not valid: \"" + dest + "\")");
            return false;
        }
        System.out.println("Valid destination directory provided: \"" + dest + "\")");
        return true;
    }
}

