/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.utils;

import java.io.File;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.validation.cli.utils.Common;

public class ProfileLoader {
    public static byte[] loadProfileSource(String src) throws FHIRException, IOException {
        if (Utilities.noString((String)src)) {
            throw new FHIRException("Profile Source '" + src + "' could not be processed");
        }
        if (Common.isNetworkPath(src)) {
            return ProfileLoader.loadProfileFromUrl(src);
        }
        if (ManagedFileAccess.file((String)src).exists()) {
            return ProfileLoader.loadProfileFromFile(src);
        }
        throw new FHIRException("Definitions Source '" + src + "' could not be processed");
    }

    private static byte[] loadProfileFromUrl(String src) throws FHIRException {
        try {
            HTTPResult res = ManagedWebAccess.get((String)(src + "?nocache=" + System.currentTimeMillis()));
            res.checkThrowException();
            return res.getContent();
        }
        catch (Exception e) {
            throw new FHIRException("Unable to find definitions at URL '" + src + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] loadProfileFromFile(String src) throws IOException {
        File f = ManagedFileAccess.file((String)src);
        if (f.isDirectory()) {
            throw new IOException("You must provide a file name, not a directory name");
        }
        return TextFile.fileToBytes((String)src);
    }
}

