/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.generator;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.convertors.loaders.loaderR5.R4BToR5Loader;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;

public class InstanceGenerator {
    private IWorkerContext context;

    public static void main(String[] args) throws FHIRException, IOException {
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
        NpmPackage npm = pcm.loadPackage("hl7.fhir.r4.core");
        SimpleWorkerContext context = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(npm);
        context.loadFromPackage(pcm.loadPackage("hl7.fhir.us.core#6.0.0"), (IContextResourceLoader)new R4BToR5Loader(null, null, null));
        InstanceGenerator gen = new InstanceGenerator((IWorkerContext)context);
        StructureDefinition sd = (StructureDefinition)context.fetchResource(StructureDefinition.class, args[0]);
        Manager.FhirFormat fmt = Manager.FhirFormat.valueOf((String)args[1].toUpperCase());
        FileOutputStream f = ManagedFileAccess.outStream((String)args[2]);
        List<String> messages = gen.generateInstance(sd, fmt, f);
        if (messages.isEmpty()) {
            System.out.println("Generated OK");
        } else {
            System.out.println("Generation failed:");
            for (String msg : messages) {
                System.out.println(" - " + msg);
            }
        }
    }

    protected InstanceGenerator(IWorkerContext context) {
        this.context = context;
    }

    public List<String> generateInstance(StructureDefinition profile, Manager.FhirFormat format, OutputStream destination) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("Not done yet");
        return res;
    }
}

