/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.CanonicalPair;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class CodeSystemValidator
extends BaseValidator {
    private static final String VS_PROP_STATUS = null;

    public CodeSystemValidator(BaseValidator parent) {
        super(parent);
    }

    public boolean validateCodeSystem(ValidationContext valContext, List<ValidationMessage> errors, Element cs, NodeStack stack, ValidationOptions options) {
        boolean ok = true;
        String url = cs.getNamedChildValue("url", false);
        String content = cs.getNamedChildValue("content", false);
        String caseSensitive = cs.getNamedChildValue("caseSensitive", false);
        String hierarchyMeaning = cs.getNamedChildValue("hierarchyMeaning", false);
        String supp = cs.getNamedChildValue("supplements", false);
        int count = this.countConcepts(cs);
        CodeSystem csB = null;
        this.metaChecks(errors, cs, stack, url, content, caseSensitive, hierarchyMeaning, !Utilities.noString((String)supp), count, supp);
        String vsu = cs.getNamedChildValue("valueSet", false);
        if (!Utilities.noString((String)vsu)) {
            ValueSet vs;
            if ("supplement".equals(content)) {
                csB = this.context.fetchCodeSystem(supp);
                if (csB != null) {
                    if (csB.hasValueSet()) {
                        this.warning(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vsu.equals(vsu), "CODESYSTEM_CS_NO_VS_SUPPLEMENT2", csB.getValueSet());
                    } else {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "CODESYSTEM_CS_NO_VS_SUPPLEMENT1", new Object[0]);
                    }
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), "complete".equals(content), "CODESYSTEM_CS_NO_VS_NOTCOMPLETE", new Object[0]);
                }
            } else {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), "complete".equals(content), "CODESYSTEM_CS_NO_VS_NOTCOMPLETE", new Object[0]);
            }
            try {
                vs = (ValueSet)this.context.fetchResourceWithException(ValueSet.class, vsu);
            }
            catch (FHIRException e) {
                vs = null;
            }
            if (vs != null) {
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.hasCompose(), "CodeSystem_CS_VS_Invalid", url, vsu)) {
                    if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getCompose().getInclude().size() == 1, "CodeSystem_CS_VS_Invalid", url, vsu)) {
                        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), ((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).getSystem().equals(url), "CodeSystem_CS_VS_WrongSystem", url, vsu, ((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).getSystem())) {
                            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasValueSet() && !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasConcept() && !((ValueSet.ConceptSetComponent)vs.getCompose().getInclude().get(0)).hasFilter(), "CodeSystem_CS_VS_IncludeDetails", url, vsu) && ok;
                            if (vs.hasExpansion()) {
                                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs.getExpansion().getContains().size() == count, "CODESYSTEM_CS_VS_EXP_MISMATCH", url, vsu, count, vs.getExpansion().getContains().size()) && ok;
                            }
                        } else {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
            }
        }
        if ("supplement".equals(content) || supp != null) {
            if (this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !Utilities.noString((String)supp), "CODESYSTEM_CS_SUPP_NO_SUPP", new Object[0])) {
                if (this.context.supportsSystem(supp, options.getFhirVersion())) {
                    List concepts = cs.getChildrenByName("concept");
                    int ce = 0;
                    for (Element concept : concepts) {
                        NodeStack nstack = stack.push(concept, ce, null, null);
                        if (ce == 0) {
                            this.rule(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, nstack, !"not-present".equals(content), "CODESYSTEM_CS_COUNT_NO_CONTENT_ALLOWED", new Object[0]);
                        }
                        ok = this.validateSupplementConcept(errors, concept, nstack, supp, options) && ok;
                        ++ce;
                    }
                } else if (cs.hasChildren("concept")) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), false, "CODESYSTEM_CS_SUPP_CANT_CHECK", supp);
                }
            } else {
                ok = false;
            }
        }
        if (!stack.isContained()) {
            ok = this.checkShareableCodeSystem(errors, cs, stack) && ok;
        } else {
            boolean isInQ = valContext.getRootResource() != null && valContext.getRootResource().fhirType().equals("Questionnaire");
            boolean isSuppProp = valContext.getRootResource() != null && valContext.getRootResource().fhirType().equals("CodeSystem");
            this.hint(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), !isInQ && !isSuppProp, "CODESYSTEM_NOT_CONTAINED");
        }
        HashMap<String, PropertyDef> properties = new HashMap<String, PropertyDef>();
        List propertyElements = cs.getChildrenByName("property");
        int i = 0;
        for (Element propertyElement : propertyElements) {
            ok = this.checkPropertyDefinition(errors, cs, stack.push(propertyElement, i, null, null), "true".equals(caseSensitive), hierarchyMeaning, csB, propertyElement, properties) && ok;
            ++i;
        }
        HashSet<String> codes = new HashSet<String>();
        List concepts = cs.getChildrenByName("concept");
        i = 0;
        for (Element concept : concepts) {
            ok = this.checkConcept(errors, cs, stack.push(concept, i, null, null), "true".equals(caseSensitive), hierarchyMeaning, csB, concept, codes, properties) && ok;
            ++i;
        }
        i = 0;
        for (Element concept : concepts) {
            ok = this.checkConceptProps(errors, cs, stack.push(concept, i, null, null), "true".equals(caseSensitive), hierarchyMeaning, csB, concept, codes, properties) && ok;
            ++i;
        }
        return ok;
    }

    private boolean checkPropertyDefinition(List<ValidationMessage> errors, Element cs, NodeStack stack, boolean equals, String hierarchyMeaning, CodeSystem csB, Element property, Map<String, PropertyDef> properties) {
        boolean ok = true;
        String uri = property.getNamedChildValue("uri");
        String code = property.getNamedChildValue("code");
        String type = property.getNamedChildValue("type");
        PropertyDef pd = new PropertyDef(uri, code, type);
        KnownProperty ukp = null;
        KnownProperty ckp = null;
        if (uri != null) {
            if (this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), !properties.containsKey(uri), "CODESYSTEM_PROPERTY_DUPLICATE_URI", uri)) {
                properties.put(uri, pd);
            } else {
                ok = false;
            }
            if (uri.contains("hl7.org/fhir")) {
                switch (uri) {
                    case "http://hl7.org/fhir/concept-properties#status": {
                        ukp = KnownProperty.Status;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#inactive": {
                        ukp = KnownProperty.Inactive;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#effectiveDate": {
                        ukp = KnownProperty.EffectiveDate;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#deprecationDate": {
                        ukp = KnownProperty.DeprecationDate;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#retirementDate": {
                        ukp = KnownProperty.RetirementDate;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#notSelectable": {
                        ukp = KnownProperty.NotSelectable;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#parent": {
                        ukp = KnownProperty.Parent;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#child": {
                        ukp = KnownProperty.Child;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#partOf": {
                        ukp = KnownProperty.PartOf;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#synonym": {
                        ukp = KnownProperty.Synonym;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#comment": {
                        ukp = KnownProperty.Comment;
                        break;
                    }
                    case "http://hl7.org/fhir/concept-properties#itemWeight": {
                        ukp = KnownProperty.ItemWeight;
                        break;
                    }
                    default: {
                        ok = this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), this.isBaseSpec(cs.getNamedChildValue("url")) || this.isSelfRef(cs.getNamedChildValue("url"), uri), "CODESYSTEM_PROPERTY_BAD_HL7_URI", uri);
                    }
                }
            }
        }
        if (code != null) {
            if (this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), !properties.containsKey(code), "CODESYSTEM_PROPERTY_DUPLICATE_CODE", code)) {
                properties.put(code, pd);
            } else {
                ok = false;
            }
            switch (code) {
                case "status": {
                    ckp = KnownProperty.Status;
                    break;
                }
                case "inactive": {
                    ckp = KnownProperty.Inactive;
                    break;
                }
                case "effectiveDate": {
                    ckp = KnownProperty.EffectiveDate;
                    break;
                }
                case "deprecationDate": {
                    ckp = KnownProperty.DeprecationDate;
                    break;
                }
                case "retirementDate": {
                    ckp = KnownProperty.RetirementDate;
                    break;
                }
                case "notSelectable": {
                    ckp = KnownProperty.NotSelectable;
                    break;
                }
                case "parent": {
                    ckp = KnownProperty.Parent;
                    break;
                }
                case "child": {
                    ckp = KnownProperty.Child;
                    break;
                }
                case "partOf": {
                    ckp = KnownProperty.PartOf;
                    break;
                }
                case "synonym": {
                    ckp = KnownProperty.Synonym;
                    break;
                }
                case "comment": {
                    ckp = KnownProperty.Comment;
                    break;
                }
                case "itemWeight": {
                    ckp = KnownProperty.ItemWeight;
                    break;
                }
            }
        }
        if (ukp != null) {
            boolean bl = ok = this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), ckp == null || ckp == ukp, "CODESYSTEM_PROPERTY_URI_CODE_MISMATCH", uri, ukp.getCode(), code) && ok;
            if (type != null) {
                ok = this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), type.equals(ukp.getType()), "CODESYSTEM_PROPERTY_URI_TYPE_MISMATCH", uri, ukp.getType(), type) && ok;
            }
            switch (ukp) {
                case Child: 
                case Parent: 
                case PartOf: 
                case Synonym: {
                    pd.setCodeValidationRules(CodeValidationRule.INTERNAL_CODE, null);
                    break;
                }
                case Status: {
                    pd.setCodeValidationRules(CodeValidationRule.VS_WARNING, VS_PROP_STATUS);
                    break;
                }
            }
        } else if ("code".equals(pd.getType())) {
            if (property.hasExtension("http://hl7.org/fhir/6.0/StructureDefinition/extension-CodeSystem.property.valueSet")) {
                pd.setCodeValidationRules(CodeValidationRule.VS_ERROR, property.getExtensionValue("http://hl7.org/fhir/6.0/StructureDefinition/extension-CodeSystem.property.valueSet").primitiveValue());
            } else if (VersionUtilities.isR6Plus((String)this.context.getVersion())) {
                this.hint(errors, "2024-03-18", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), ukp != null && type.equals(ukp.getType()), "CODESYSTEM_PROPERTY_CODE_WARNING");
            }
        } else if ("Coding".equals(pd.getType()) && property.hasExtension("http://hl7.org/fhir/6.0/StructureDefinition/extension-CodeSystem.property.valueSet")) {
            pd.setCodeValidationRules(CodeValidationRule.VS_ERROR, property.getExtensionValue("http://hl7.org/fhir/6.0/StructureDefinition/extension-CodeSystem.property.valueSet").primitiveValue());
        }
        if (uri == null) {
            if (ckp == null) {
                this.hint(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), false, "CODESYSTEM_PROPERTY_UNKNOWN_CODE", code);
            } else {
                this.warning(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), false, "CODESYSTEM_PROPERTY_KNOWN_CODE_SUGGESTIVE", code, ckp.getUri());
                if (type != null) {
                    this.warning(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), type.equals(ckp.getType()), "CODESYSTEM_PROPERTY_CODE_TYPE_MISMATCH", code, ckp.getType(), type);
                }
            }
        }
        return ok;
    }

    private boolean isBaseSpec(String url) {
        return url.startsWith("http://hl7.org/fhir/") && !url.substring(20).contains("/");
    }

    private boolean isSelfRef(String url, String uri) {
        return url != null && uri.startsWith(url);
    }

    private boolean checkConcept(List<ValidationMessage> errors, Element cs, NodeStack stack, boolean caseSensitive, String hierarchyMeaning, CodeSystem csB, Element concept, Set<String> codes, Map<String, PropertyDef> properties) {
        String lang;
        CodeSystem.ConceptDefinitionComponent b;
        boolean ok = true;
        String code = concept.getNamedChildValue("code");
        String display = concept.getNamedChildValue("display");
        if (csB != null && !Utilities.noString((String)display) && (b = CodeSystemUtilities.findCode((List)csB.getConcept(), (String)code)) != null && !b.getDisplay().equalsIgnoreCase(display) && ((lang = cs.getNamedChildValue("language")) == null && !csB.hasLanguage() || csB.getLanguage().equals(lang))) {
            this.hint(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), false, "CODESYSTEM_SUPP_NO_DISPLAY", display, b.getDisplay(), lang == null ? "undefined" : lang);
        }
        List designations = concept.getChildrenByName("designation");
        int i = 0;
        for (Element designation : designations) {
            ok = this.checkDesignation(errors, cs, stack.push(designation, i, null, null), concept, designation) && ok;
            ++i;
        }
        List concepts = concept.getChildrenByName("concept");
        i = 0;
        for (Element child : concepts) {
            ok = this.checkConcept(errors, cs, stack.push(concept, i, null, null), caseSensitive, hierarchyMeaning, csB, child, codes, properties) && ok;
            ++i;
        }
        return ok;
    }

    private boolean checkConceptProps(List<ValidationMessage> errors, Element cs, NodeStack stack, boolean caseSensitive, String hierarchyMeaning, CodeSystem csB, Element concept, Set<String> codes, Map<String, PropertyDef> properties) {
        boolean ok = true;
        List propertyElements = concept.getChildrenByName("property");
        int i = 0;
        for (Element propertyElement : propertyElements) {
            ok = this.checkPropertyValue(errors, cs, stack.push(propertyElement, i, null, null), propertyElement, properties, codes) && ok;
            ++i;
        }
        List concepts = concept.getChildrenByName("concept");
        i = 0;
        for (Element child : concepts) {
            ok = this.checkConceptProps(errors, cs, stack.push(concept, i, null, null), caseSensitive, hierarchyMeaning, csB, child, codes, properties) && ok;
            ++i;
        }
        return ok;
    }

    private boolean checkDesignation(List<ValidationMessage> errors, Element cs, NodeStack stack, Element concept, Element designation) {
        boolean ok = true;
        String rlang = cs.getNamedChildValue("language");
        String display = concept.getNamedChildValue("display");
        String lang = designation.getNamedChildValue("language");
        ArrayList<Element> uses = new ArrayList<Element>();
        designation.getNamedChildren("additionalUse", uses);
        Element use = designation.getNamedChild("use");
        if (use != null) {
            uses.add(0, use);
        }
        String value = designation.getNamedChildValue("value");
        if (uses.isEmpty()) {
            if (rlang == null && lang == null) {
                this.warning(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), display == null || display.equals(value), "CODESYSTEM_DESIGNATION_DISP_CLASH_NO_LANG", value, display);
            } else if (rlang != null && (lang == null || rlang.equals(lang))) {
                this.warning(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), display == null || display.equals(value), "CODESYSTEM_DESIGNATION_DISP_CLASH_LANG", value, display, rlang);
            }
        }
        return ok;
    }

    private boolean checkPropertyValue(List<ValidationMessage> errors, Element cs, NodeStack stack, Element property, Map<String, PropertyDef> properties, Set<String> codes) {
        boolean ok = true;
        String code = property.getNamedChildValue("code");
        Element value = property.getNamedChild("value");
        if (code != null) {
            PropertyDef defn = properties.get(code);
            if (!(this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), defn != null, "CODESYSTEM_PROPERTY_UNDEFINED", code) && this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), value != null, "CODESYSTEM_PROPERTY_NO_VALUE", code) && this.rule(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), value.fhirType().equals(defn.type), "CODESYSTEM_PROPERTY_WRONG_TYPE", code, value.fhirType(), defn.type))) {
                ok = false;
            }
            if ("synonym".equals(code)) {
                String vcode = value.isPrimitive() ? value.primitiveValue() : null;
                this.warning(errors, "2024-03-06", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), codes.contains(vcode), "CODESYSTEM_PROPERTY_SYNONYM_CHECK", vcode);
            }
        }
        return ok;
    }

    private boolean checkShareableCodeSystem(List<ValidationMessage> errors, Element cs, NodeStack stack) {
        if (this.parent.isForPublication()) {
            if (this.isHL7(cs)) {
                boolean ok = true;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("url", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "url") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("version", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "version") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("title", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "title") && ok;
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("name", false), "CODESYSTEM_SHAREABLE_EXTRA_MISSING_HL7", "name");
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("status", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "status") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("experimental", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "experimental") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("description", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "description") && ok;
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("content", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "content") && ok;
                if (!"supplement".equals(cs.getChildValue("content"))) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("caseSensitive", false), "CODESYSTEM_SHAREABLE_MISSING_HL7", "caseSensitive") && ok;
                }
                return ok;
            }
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("url", false), "CODESYSTEM_SHAREABLE_MISSING", "url");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("version", false), "CODESYSTEM_SHAREABLE_MISSING", "version");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("title", false), "CODESYSTEM_SHAREABLE_MISSING", "title");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("name", false), "CODESYSTEM_SHAREABLE_EXTRA_MISSING", "name");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("status", false), "CODESYSTEM_SHAREABLE_MISSING", "status");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("experimental", false), "CODESYSTEM_SHAREABLE_MISSING", "experimental");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("description", false), "CODESYSTEM_SHAREABLE_MISSING", "description");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("content", false), "CODESYSTEM_SHAREABLE_MISSING", "content");
            if (!"supplement".equals(cs.getChildValue("content"))) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, cs.line(), cs.col(), stack.getLiteralPath(), cs.hasChild("caseSensitive", false), "CODESYSTEM_SHAREABLE_MISSING", "caseSensitive");
            }
        }
        return true;
    }

    private void metaChecks(List<ValidationMessage> errors, Element cs, NodeStack stack, String url, String content, String caseSensitive, String hierarchyMeaning, boolean isSupplement, int count, String supp) {
        List concepts;
        int statedCount;
        if (this.forPublication && url.contains("hl7.org")) {
            this.hint(errors, "2024-03-07", ValidationMessage.IssueType.BUSINESSRULE, cs.line(), cs.col(), stack.getLiteralPath(), url.contains("terminology.hl7.org") || url.contains("hl7.org/cda/stds/core"), "CODESYSTEM_THO_CHECK");
        }
        if (isSupplement) {
            NodeStack s;
            if (!"supplement".equals(content)) {
                s = stack.push(cs.getNamedChild("content", false), -1, null, null);
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_PRESENT_ELEMENT_SUPPL_WRONG", new Object[0]);
            }
            if (!Utilities.noString((String)caseSensitive)) {
                s = stack.push(cs.getNamedChild("caseSensitive", false), -1, null, null);
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_PRESENT_ELEMENT_SUPPL", "caseSensitive");
            }
            if (!Utilities.noString((String)hierarchyMeaning)) {
                s = stack.push(cs.getNamedChild("hierarchyMeaning", false), -1, null, null);
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_PRESENT_ELEMENT_SUPPL", "hierarchyMeaning");
            }
        } else {
            Element c;
            NodeStack s;
            boolean isHL7;
            boolean bl = isHL7 = url != null && (url.contains("hl7.org") || url.contains("fhir.org"));
            if (Utilities.noString((String)content)) {
                s = stack;
                c = cs.getNamedChild("content", false);
                if (c != null) {
                    s = stack.push(c, -1, null, null);
                }
                if (isHL7) {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_MISSING_ELEMENT_SHALL", "content");
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_NONHL7_MISSING_ELEMENT", "content");
                }
            } else if ("supplement".equals(content)) {
                s = stack.push(cs.getNamedChild("content", false), -1, null, null);
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_PRESENT_ELEMENT_SUPPL_MISSING", new Object[0]);
            }
            if (Utilities.noString((String)caseSensitive)) {
                s = stack;
                c = cs.getNamedChild("caseSensitive", false);
                if (c != null) {
                    s = stack.push(c, -1, null, null);
                }
                if (isHL7) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_MISSING_ELEMENT_SHOULD", "caseSensitive");
                } else {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_NONHL7_MISSING_ELEMENT", "caseSensitive");
                }
            }
            if (Utilities.noString((String)hierarchyMeaning) && this.hasHierarchy(cs)) {
                s = stack;
                c = cs.getNamedChild("hierarchyMeaning", false);
                if (c != null) {
                    s = stack.push(c, -1, null, null);
                }
                if (isHL7) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_HL7_MISSING_ELEMENT_SHOULD", "hierarchyMeaning");
                } else {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, s.getLiteralPath(), false, "CODESYSTEM_CS_NONHL7_MISSING_ELEMENT", "hierarchyMeaning");
                }
            }
        }
        this.warning(errors, "2024-10-03", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), count != 0 || !"complete".equals(content), "CODESYSTEM_CS_COMPLETE_AND_EMPTY", new Object[0]);
        if (cs.hasChild("count", false) && (statedCount = Utilities.parseInt((String)cs.getNamedChildValue("count", false), (int)-1)) > -1 && content != null) {
            NodeStack nstack = stack.push(cs.getNamedChild("count", false), -1, null, null);
            switch (content) {
                case "complete": {
                    this.rule(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, nstack, count == statedCount, "CODESYSTEM_CS_COUNT_COMPLETE_WRONG", count, statedCount);
                    break;
                }
                case "example": 
                case "fragment": {
                    this.warning(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, nstack, count < statedCount, "CODESYSTEM_CS_COUNT_FRAGMENT_WRONG", count, statedCount);
                    break;
                }
                case "not-present": {
                    if (!cs.hasChildren("concept")) break;
                    this.hint(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, stack.push(cs.getNamedChild("concept", false), -1, null, null), statedCount > 0, "CODESYSTEM_CS_COUNT_NOTPRESENT_ZERO", statedCount);
                    break;
                }
                case "supplement": {
                    CodeSystem css = this.context.fetchCodeSystem(supp);
                    if (css == null) break;
                    this.rule(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, nstack, count == css.getCount(), "CODESYSTEM_CS_COUNT_SUPPLEMENT_WRONG", css.getCount(), statedCount);
                    break;
                }
            }
        }
        if ("not-present".equals(content) && (concepts = cs.getChildrenByName("concept")).size() > 0) {
            this.rule(errors, "2023-08-15", ValidationMessage.IssueType.INVALID, stack.push((Element)concepts.get(0), 0, null, null), false, "CODESYSTEM_CS_COUNT_NO_CONTENT_ALLOWED", new Object[0]);
        }
    }

    private boolean hasHierarchy(Element cs) {
        for (Element c : cs.getChildren("concept")) {
            if (!c.hasChildren("concept")) continue;
            return true;
        }
        return false;
    }

    private boolean validateSupplementConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String supp, ValidationOptions options) {
        String code = concept.getChildValue("code");
        if (!Utilities.noString((String)code)) {
            CanonicalPair canonical = new CanonicalPair(supp);
            ValidationResult res = this.context.validateCode(options, canonical.getUrl(), canonical.getVersion(), code, null);
            return this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), res.isOk(), "CODESYSTEM_CS_SUPP_INVALID_CODE", supp, code);
        }
        return true;
    }

    private int countConcepts(Element cs) {
        List concepts = cs.getChildrenByName("concept");
        int res = concepts.size();
        for (Element concept : concepts) {
            res += this.countConcepts(concept);
        }
        return res;
    }

    public class PropertyDef {
        private String uri;
        private String code;
        private String type;
        private CodeValidationRule rule;
        private String valueset;

        protected PropertyDef(String uri, String code, String type) {
            this.uri = uri;
            this.code = code;
            this.type = type;
        }

        public void setCodeValidationRules(CodeValidationRule rule, String valueset) {
            this.rule = rule;
            this.valueset = valueset;
        }

        public String getUri() {
            return this.uri;
        }

        public String getCode() {
            return this.code;
        }

        public String getType() {
            return this.type;
        }

        public String getValueset() {
            return this.valueset;
        }
    }

    public static enum CodeValidationRule {
        NO_VALIDATION,
        INTERNAL_CODE,
        VS_ERROR,
        VS_WARNING;

    }

    public static enum KnownProperty {
        Status,
        Inactive,
        EffectiveDate,
        DeprecationDate,
        RetirementDate,
        NotSelectable,
        Parent,
        Child,
        PartOf,
        Synonym,
        Comment,
        ItemWeight;


        String getType() {
            switch (this) {
                case Child: {
                    return "code";
                }
                case Comment: {
                    return "string";
                }
                case DeprecationDate: {
                    return "dateTime";
                }
                case EffectiveDate: {
                    return "dateTime";
                }
                case Inactive: {
                    return "boolean";
                }
                case ItemWeight: {
                    return "decimal";
                }
                case NotSelectable: {
                    return "boolean";
                }
                case Parent: {
                    return "code";
                }
                case PartOf: {
                    return "code";
                }
                case RetirementDate: {
                    return "dateTime";
                }
                case Status: {
                    return "code";
                }
                case Synonym: {
                    return "code";
                }
            }
            return null;
        }

        String getCode() {
            return Utilities.uncapitalize((String)this.toString());
        }

        String getUri() {
            return "http://hl7.org/fhir/concept-properties#" + this.getCode();
        }
    }
}

