/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.utilities.Utilities;

public class NodeStack {
    protected IWorkerContext context;
    private ElementDefinition definition;
    private Element element;
    private ElementDefinition extension;
    private String literalPath;
    private Set<String> logicalPaths;
    private NodeStack parent;
    private ElementDefinition type;
    private String workingLang;
    private Map<String, Element> ids;
    private boolean resetPoint = false;
    private boolean contained = false;

    public NodeStack(IWorkerContext context) {
        this.context = context;
    }

    public NodeStack(IWorkerContext context, String initialPath, Element element, String validationLanguage) {
        this.context = context;
        this.ids = new HashMap<String, Element>();
        this.element = element;
        this.literalPath = (String)(initialPath == null ? "" : initialPath + ".") + this.buildPathForElement(element, true);
        this.workingLang = validationLanguage;
        if (!element.getName().equals(element.fhirType())) {
            this.logicalPaths = new HashSet<String>();
            this.logicalPaths.add(element.fhirType());
        }
    }

    private String buildPathForElement(Element e, boolean first) {
        if (e.getParentForValidator() != null) {
            Object node;
            Object object = node = e.getName().contains("/") ? e.getName().substring(e.getName().lastIndexOf("/") + 1) : e.getName();
            if (e.hasIndex() && e.getProperty().isList() && e.getSpecial() == null) {
                node = (String)node + "[" + Integer.toString(e.getIndex()) + "]";
            }
            if (!first && e.isResource()) {
                node = (String)node + "/*" + e.fhirType() + "/" + e.getIdBase() + "*/";
            }
            return this.buildPathForElement(e.getParentForValidator(), false) + "." + (String)node;
        }
        return e.getPath();
    }

    public NodeStack(IWorkerContext context, Element element, String refPath, String validationLanguage) {
        this.context = context;
        this.ids = new HashMap<String, Element>();
        this.element = element;
        this.literalPath = refPath + "->" + element.getName();
        this.workingLang = validationLanguage;
    }

    public String addToLiteralPath(String ... path) {
        StringBuilder b = new StringBuilder();
        b.append(this.getLiteralPath());
        for (String p : path) {
            if (p.startsWith(":")) {
                b.append("[");
                b.append(p.substring(1));
                b.append("]");
                continue;
            }
            b.append(".");
            b.append(p);
        }
        return b.toString();
    }

    private ElementDefinition getDefinition() {
        return this.definition;
    }

    public Element getElement() {
        return this.element;
    }

    public String getLiteralPath() {
        return this.literalPath == null ? "" : this.literalPath;
    }

    public Set<String> getLogicalPaths() {
        return this.logicalPaths == null ? new HashSet() : this.logicalPaths;
    }

    private ElementDefinition getType() {
        return this.type;
    }

    public NodeStack pushTarget(Element element, int count, ElementDefinition definition, ElementDefinition type) {
        return this.pushInternal(element, count, definition, type, "->");
    }

    public NodeStack push(Element element, int count, ElementDefinition definition, ElementDefinition type) {
        return this.pushInternal(element, count, definition, type, ".");
    }

    private NodeStack pushInternal(Element element, int count, ElementDefinition definition, ElementDefinition type, String sep) {
        if (definition == null & element.getProperty() != null) {
            definition = element.getProperty().getDefinition();
        }
        NodeStack res = new NodeStack(this.context);
        res.ids = this.ids;
        res.parent = this;
        res.workingLang = this.workingLang;
        res.element = element;
        res.definition = definition;
        res.contained = this.contained;
        res.literalPath = this.getLiteralPath() + sep + element.getName();
        if (count > -1) {
            res.literalPath = res.literalPath + "[" + Integer.toString(count) + "]";
        } else if (element.getSpecial() == null && element.getProperty().isList()) {
            res.literalPath = res.literalPath + "[0]";
        } else if (element.getProperty().isChoice()) {
            String n = res.literalPath.substring(res.literalPath.lastIndexOf(".") + 1);
            String en = element.getProperty().getName();
            if (en.endsWith("[x]")) {
                String t = n.substring((en = en.substring(0, en.length() - 3)).length());
                if (this.context.isPrimitiveType(Utilities.uncapitalize((String)t))) {
                    t = Utilities.uncapitalize((String)t);
                }
                res.literalPath = res.literalPath.substring(0, res.literalPath.lastIndexOf(".")) + "." + en + ".ofType(" + t + ")";
            } else {
                res.literalPath = res.literalPath.substring(0, res.literalPath.lastIndexOf(".")) + "." + en;
            }
        }
        res.logicalPaths = new HashSet<String>();
        if (type != null) {
            res.type = type;
            String tn = res.type.getPath();
            String t = this.tail(definition.getPath());
            if ("Resource".equals(tn)) {
                tn = element.fhirType();
            }
            for (String lp : this.getLogicalPaths()) {
                if (!this.isRealPath(lp, t)) continue;
                res.logicalPaths.add(lp + "." + t);
                if (!t.endsWith("[x]")) continue;
                res.logicalPaths.add(lp + "." + t.substring(0, t.length() - 3) + ".ofType(" + type.getPath() + ")");
                res.logicalPaths.add(lp + "." + t.substring(0, t.length() - 3) + type.getPath());
            }
            res.logicalPaths.add(tn);
        } else if (definition != null) {
            for (String lp : this.getLogicalPaths()) {
                if (!this.isRealPath(lp, element.getName())) continue;
                res.logicalPaths.add(lp + "." + element.getName());
            }
            if (definition.hasContentReference()) {
                res.logicalPaths.add(definition.getContentReference().substring(definition.getContentReference().indexOf("#") + 1));
            } else {
                res.logicalPaths.addAll(definition.typeList());
            }
        } else {
            res.logicalPaths.addAll(this.getLogicalPaths());
        }
        return res;
    }

    private boolean isRealPath(String lp, String t) {
        if (Utilities.existsInList((String)lp, (String[])new String[]{"Element"})) {
            return Utilities.existsInList((String)t, (String[])new String[]{"id", "extension"});
        }
        if (Utilities.existsInList((String)lp, (String[])new String[]{"BackboneElement", "BackboneType"})) {
            return Utilities.existsInList((String)t, (String[])new String[]{"modifierExtension"});
        }
        if (Utilities.existsInList((String)lp, (String[])new String[]{"Resource"})) {
            return Utilities.existsInList((String)t, (String[])new String[]{"id", "meta", "implicitRules", "language"});
        }
        if (Utilities.existsInList((String)lp, (String[])new String[]{"DomainResource"})) {
            return Utilities.existsInList((String)t, (String[])new String[]{"text", "contained", "extension", "modifierExtension"});
        }
        return true;
    }

    private void setType(ElementDefinition type) {
        this.type = type;
    }

    public NodeStack resetIds() {
        this.ids = new HashMap<String, Element>();
        this.resetPoint = true;
        return this;
    }

    public Map<String, Element> getIds() {
        return this.ids;
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    public String getWorkingLang() {
        return this.workingLang;
    }

    public void setWorkingLang(String workingLang) {
        this.workingLang = workingLang;
    }

    public NodeStack getParent() {
        return this.parent;
    }

    public void pathComment(String comment) {
        this.literalPath = this.literalPath + "/*" + comment + "*/";
    }

    public boolean isResetPoint() {
        return this.resetPoint;
    }

    public String toString() {
        return this.literalPath;
    }

    public int depth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.depth() + 1;
    }

    public boolean isContained() {
        return this.contained;
    }

    public void setContained(boolean contained) {
        this.contained = contained;
    }

    public int line() {
        return this.element.line();
    }

    public int col() {
        return this.element.col();
    }
}

