/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.renderers;

import java.io.File;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.cli.renderers.ValidationOutputRenderer;

public class DefaultRenderer
extends ValidationOutputRenderer {
    @Override
    public void render(OperationOutcome oo) {
        int error = 0;
        int warn = 0;
        int info = 0;
        String file = ToolingExtensions.readStringExtension((DomainResource)oo, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file");
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            if (issue.getSeverity() == OperationOutcome.IssueSeverity.FATAL || issue.getSeverity() == OperationOutcome.IssueSeverity.ERROR) {
                ++error;
                continue;
            }
            if (issue.getSeverity() == OperationOutcome.IssueSeverity.WARNING) {
                ++warn;
                continue;
            }
            ++info;
        }
        if (this.moreThanOne) {
            this.dst.print("-- ");
            this.dst.print(file);
            this.dst.print(" --");
            this.dst.println(Utilities.padLeft((String)"", (char)'-', (int)Integer.max(38, file.length() + 6)));
        }
        this.dst.println((error == 0 ? "Success" : "*FAILURE*") + ": " + Integer.toString(error) + " errors, " + Integer.toString(warn) + " warnings, " + Integer.toString(info) + " notes");
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            this.dst.println(this.getIssueSummary(issue) + this.renderMessageId(issue));
            ValidationMessage vm = (ValidationMessage)issue.getUserData("source.msg");
            if (vm == null || vm.sliceText == null || !this.crumbTrails && !vm.isCriticalSignpost()) continue;
            for (String s : vm.sliceText) {
                this.dst.println("    slice info: " + s);
            }
        }
        if (this.moreThanOne) {
            this.dst.print("---");
            this.dst.print(Utilities.padLeft((String)"", (char)'-', (int)file.length()));
            this.dst.print("---");
            this.dst.println(Utilities.padLeft((String)"", (char)'-', (int)Integer.max(38, file.length() + 6)));
            this.dst.println();
        }
    }

    private String getIssueSummary(OperationOutcome.OperationOutcomeIssueComponent issue) {
        Object loc;
        if (issue.hasExpression()) {
            int line = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", (int)-1);
            int col = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", (int)-1);
            loc = " @ " + ((StringType)issue.getExpression().get(0)).asStringValue() + (String)(line >= 0 && col >= 0 ? " (line " + Integer.toString(line) + ", col" + Integer.toString(col) + ")" : "");
        } else if (issue.hasExpressionOrLocation()) {
            loc = " @ " + ((StringType)issue.getExpressionOrLocation().get(0)).asStringValue();
        } else {
            int line = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", (int)-1);
            int col = ToolingExtensions.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", (int)-1);
            loc = issue.getSeverity() == OperationOutcome.IssueSeverity.INFORMATION && (line == -1 || col == -1) ? "" : " @ line " + Integer.toString(line) + ", col" + Integer.toString(col);
        }
        return "  " + issue.getSeverity().getDisplay() + (String)loc + ": " + issue.getDetails().getText();
    }

    @Override
    public boolean isSingleFile() {
        return true;
    }

    @Override
    public String getStyleCode() {
        return "(default)";
    }

    @Override
    public void setFolder(File dir) {
        throw new Error("Not supported");
    }
}

